/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.ivars;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.invoke.MethodHandle;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.runtime.ObjectSpace;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.ivars.FieldVariableAccessor;
import org.jruby.runtime.ivars.NonvolatileVariableAccessor;
import org.jruby.runtime.ivars.StampedVariableAccessor;
import org.jruby.runtime.ivars.SynchronizedVariableAccessor;
import org.jruby.runtime.ivars.VariableAccessor;
import org.jruby.runtime.ivars.VariableAccessorField;
import org.jruby.util.ArraySupport;
import org.jruby.util.StringSupport;
import org.jruby.util.cli.Options;
import org.jruby.util.unsafe.UnsafeHolder;

public class VariableTableManager {
    private final RubyClass realClass;
    private Map<String, VariableAccessor> variableAccessors = Collections.EMPTY_MAP;
    private volatile String[] variableNames = StringSupport.EMPTY_STRING_ARRAY;
    private volatile int hasObjectID = 0;
    private volatile int hasFFI = 0;
    private volatile int hasObjectspaceGroup = 0;
    private volatile int fieldVariables = 0;
    private final VariableAccessorField objectIdVariableAccessorField = new VariableAccessorField("object_id");
    private final VariableAccessorField ffiHandleVariableAccessorField = new VariableAccessorField("ffi");
    private final VariableAccessorField objectGroupVariableAccessorField = new VariableAccessorField("objectspace_group");

    public VariableTableManager(RubyClass realClass) {
        this.realClass = realClass;
    }

    public Map<String, VariableAccessor> getVariableAccessorsForRead() {
        return this.variableAccessors;
    }

    public boolean hasObjectID() {
        return this.hasObjectID == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getObjectId(RubyBasicObject self2) {
        VariableAccessor objectIdAccessor = this.getObjectIdAccessorForRead();
        Long id2 = (Long)objectIdAccessor.get(self2);
        if (id2 != null) {
            return id2;
        }
        RubyBasicObject rubyBasicObject = self2;
        synchronized (rubyBasicObject) {
            objectIdAccessor = this.getObjectIdAccessorForRead();
            id2 = (Long)objectIdAccessor.get(self2);
            if (id2 != null) {
                return id2;
            }
            objectIdAccessor = this.getObjectIdAccessorForWrite();
            return this.initObjectId(self2, objectIdAccessor);
        }
    }

    public void setVariableInternal(RubyBasicObject self2, int index2, Object value2) {
        if (UnsafeHolder.U == null) {
            SynchronizedVariableAccessor.setVariable(self2, this.realClass, index2, value2);
        } else {
            StampedVariableAccessor.setVariable(self2, this.realClass, index2, value2);
        }
    }

    public static void setVariableInternal(RubyClass realClass, RubyBasicObject self2, int index2, Object value2) {
        if (UnsafeHolder.U == null) {
            SynchronizedVariableAccessor.setVariable(self2, realClass, index2, value2);
        } else {
            StampedVariableAccessor.setVariable(self2, realClass, index2, value2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VariableAccessor getVariableAccessorForWrite(String name2) {
        VariableAccessor ivarAccessor = this.variableAccessors.get(name2);
        if (ivarAccessor == null) {
            RubyClass rubyClass = this.realClass;
            synchronized (rubyClass) {
                Map<String, VariableAccessor> myVariableAccessors = this.variableAccessors;
                ivarAccessor = myVariableAccessors.get(name2);
                if (ivarAccessor == null) {
                    ivarAccessor = this.allocateVariableAccessor(name2);
                    HashMap<String, VariableAccessor> newVariableAccessors = new HashMap<String, VariableAccessor>(myVariableAccessors.size() + 1);
                    newVariableAccessors.putAll(myVariableAccessors);
                    newVariableAccessors.put(name2, ivarAccessor);
                    this.variableAccessors = newVariableAccessors;
                }
            }
        }
        return ivarAccessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VariableAccessor getVariableAccessorForVar(String name2, MethodHandle getter, MethodHandle setter) {
        VariableAccessor ivarAccessor = this.variableAccessors.get(name2);
        if (ivarAccessor == null) {
            RubyClass rubyClass = this.realClass;
            synchronized (rubyClass) {
                Map<String, VariableAccessor> myVariableAccessors = this.variableAccessors;
                ivarAccessor = myVariableAccessors.get(name2);
                if (ivarAccessor == null) {
                    ivarAccessor = this.allocateVariableAccessorForVar(name2, getter, setter);
                    HashMap<String, VariableAccessor> newVariableAccessors = new HashMap<String, VariableAccessor>(myVariableAccessors.size() + 1);
                    newVariableAccessors.putAll(myVariableAccessors);
                    newVariableAccessors.put(name2, ivarAccessor);
                    this.variableAccessors = newVariableAccessors;
                }
            }
        }
        return ivarAccessor;
    }

    public VariableAccessor getVariableAccessorForRead(String name2) {
        VariableAccessor accessor = this.getVariableAccessorsForRead().get(name2);
        if (accessor == null) {
            accessor = VariableAccessor.DUMMY_ACCESSOR;
        }
        return accessor;
    }

    public VariableAccessor getObjectIdAccessorForRead() {
        return this.objectIdVariableAccessorField.getVariableAccessorForRead();
    }

    public VariableAccessor getObjectIdAccessorForWrite() {
        if (this.hasObjectID == 0) {
            this.hasObjectID = 1;
        }
        return this.objectIdVariableAccessorField.getVariableAccessorForWrite(this);
    }

    public VariableAccessor getFFIHandleAccessorForRead() {
        return this.ffiHandleVariableAccessorField.getVariableAccessorForRead();
    }

    public VariableAccessor getFFIHandleAccessorForWrite() {
        if (this.hasFFI == 0) {
            this.hasFFI = 1;
        }
        return this.ffiHandleVariableAccessorField.getVariableAccessorForWrite(this);
    }

    public VariableAccessor getObjectGroupAccessorForRead() {
        return this.objectGroupVariableAccessorField.getVariableAccessorForRead();
    }

    public VariableAccessor getObjectGroupAccessorForWrite() {
        if (this.hasObjectspaceGroup == 0) {
            this.hasObjectspaceGroup = 1;
        }
        return this.objectGroupVariableAccessorField.getVariableAccessorForWrite(this);
    }

    public final Object getFFIHandle(RubyBasicObject self2) {
        return this.getFFIHandleAccessorForRead().get(self2);
    }

    public final void setFFIHandle(RubyBasicObject self2, Object value2) {
        int index2 = this.getFFIHandleAccessorForWrite().getIndex();
        VariableTableManager.setVariableInternal(this.realClass, self2, index2, value2);
    }

    public int getVariableTableSize() {
        return this.variableAccessors.size();
    }

    public int getVariableTableSizeWithExtras() {
        return this.variableNames.length;
    }

    public Map<String, VariableAccessor> getVariableTableCopy() {
        return new HashMap<String, VariableAccessor>(this.getVariableAccessorsForRead());
    }

    public String[] getVariableNames() {
        return (String[])this.variableNames.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncVariables(RubyBasicObject self2, IRubyObject other) {
        boolean sameTable;
        RubyClass otherRealClass = other.getMetaClass().getRealClass();
        boolean bl = sameTable = otherRealClass == this.realClass;
        if (sameTable && this.fieldVariables == 0) {
            int idIndex = otherRealClass.getObjectIdAccessorField().getVariableAccessorForRead().getIndex();
            Object[] otherVars = ((RubyBasicObject)other).varTable;
            if (UnsafeHolder.U == null) {
                RubyBasicObject rubyBasicObject = self2;
                synchronized (rubyBasicObject) {
                    self2.varTable = VariableTableManager.makeSyncedTable(self2.varTable, otherVars, idIndex);
                }
            } else {
                int oldStamp;
                while (((oldStamp = self2.varTableStamp) & 1) == 1 || !UnsafeHolder.U.compareAndSwapInt(self2, RubyBasicObject.STAMP_OFFSET, oldStamp++, oldStamp)) {
                }
                Object[] currentTable = (Object[])UnsafeHolder.U.getObjectVolatile(self2, RubyBasicObject.VAR_TABLE_OFFSET);
                Object[] newTable = VariableTableManager.makeSyncedTable(currentTable, otherVars, idIndex);
                UnsafeHolder.U.putOrderedObject(self2, RubyBasicObject.VAR_TABLE_OFFSET, newTable);
                self2.varTableStamp = oldStamp + 1;
            }
        } else {
            for (Map.Entry<String, VariableAccessor> entry : otherRealClass.getVariableAccessorsForRead().entrySet()) {
                VariableAccessor accessor = entry.getValue();
                Object value2 = accessor.get(other);
                if (value2 == null) continue;
                if (sameTable) {
                    accessor.set(self2, value2);
                    continue;
                }
                this.realClass.getVariableAccessorForWrite(accessor.getName()).set(self2, value2);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasVariables(RubyBasicObject object) {
        if (this.fieldVariables > 0) return true;
        Object[] myVarTable = object.varTable;
        if (object.varTable == null) return false;
        if (myVarTable.length <= this.hasObjectID + this.hasFFI + this.hasObjectspaceGroup) return false;
        return true;
    }

    public void serializeVariables(RubyBasicObject object, ObjectOutputStream oos) throws IOException {
        if (object.varTable != null) {
            Map<String, VariableAccessor> accessors = this.getVariableAccessorsForRead();
            oos.writeInt(accessors.size());
            for (VariableAccessor accessor : accessors.values()) {
                oos.writeUTF("Insecure: can't modify instance variable");
                oos.writeObject(accessor.get(object));
            }
        } else {
            oos.writeInt(0);
        }
    }

    public void deserializeVariables(RubyBasicObject object, ObjectInputStream ois) throws IOException, ClassNotFoundException {
        int varCount = ois.readInt();
        for (int i2 = 0; i2 < varCount; ++i2) {
            String name2 = ois.readUTF();
            Object value2 = ois.readObject();
            this.getVariableAccessorForWrite(name2).set(object, value2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clearVariable(RubyBasicObject object, String name2) {
        RubyBasicObject rubyBasicObject = object;
        synchronized (rubyBasicObject) {
            Object value2 = this.getVariableAccessorForRead(name2).get(object);
            this.getVariableAccessorForWrite(name2).set(object, null);
            return value2;
        }
    }

    private long initObjectId(RubyBasicObject self2, VariableAccessor objectIdAccessor) {
        Ruby runtime2 = self2.getRuntime();
        long id2 = runtime2.isObjectSpaceEnabled() ? runtime2.getObjectSpace().createAndRegisterObjectId(self2) : ObjectSpace.calculateObjectId(self2);
        VariableTableManager.setObjectId(this.realClass, self2, objectIdAccessor.getIndex(), id2);
        return id2;
    }

    private static void setObjectId(RubyClass realClass, RubyBasicObject self2, int index2, long value2) {
        if (index2 < 0) {
            return;
        }
        VariableTableManager.setVariableInternal(realClass, self2, index2, value2);
    }

    private static Object[] makeSyncedTable(Object[] currentTable, Object[] otherTable, int objectIdIdx) {
        if (currentTable == null || currentTable.length < otherTable.length) {
            currentTable = (Object[])otherTable.clone();
        } else {
            ArraySupport.copy(otherTable, currentTable, 0, otherTable.length);
        }
        if (objectIdIdx >= 0 && objectIdIdx < currentTable.length) {
            currentTable[objectIdIdx] = null;
        }
        return currentTable;
    }

    final synchronized VariableAccessor allocateVariableAccessor(String name2) {
        int id2 = this.realClass.id;
        Object[] myVariableNames = this.variableNames;
        int newIndex = myVariableNames.length;
        VariableAccessor newVariableAccessor = ((Boolean)Options.VOLATILE_VARIABLES.load()).booleanValue() ? (UnsafeHolder.U == null ? new SynchronizedVariableAccessor(this.realClass, name2, newIndex, id2) : new StampedVariableAccessor(this.realClass, name2, newIndex, id2)) : (UnsafeHolder.U == null ? new NonvolatileVariableAccessor(this.realClass, name2, newIndex, id2) : new StampedVariableAccessor(this.realClass, name2, newIndex, id2));
        Object[] newVariableNames = new String[newIndex + 1];
        ArraySupport.copy(myVariableNames, 0, newVariableNames, 0, newIndex);
        newVariableNames[newIndex] = name2;
        this.variableNames = newVariableNames;
        return newVariableAccessor;
    }

    final synchronized VariableAccessor allocateVariableAccessorForVar(String name2, MethodHandle getter, MethodHandle setter) {
        int id2 = this.realClass.id;
        Object[] myVariableNames = this.variableNames;
        int newIndex = myVariableNames.length;
        ++this.fieldVariables;
        FieldVariableAccessor newVariableAccessor = new FieldVariableAccessor(this.realClass, name2, newIndex, id2, getter, setter);
        Object[] newVariableNames = new String[newIndex + 1];
        ArraySupport.copy(myVariableNames, 0, newVariableNames, 0, newIndex);
        newVariableNames[newIndex] = name2;
        this.variableNames = newVariableNames;
        return newVariableAccessor;
    }

    public VariableAccessorField getObjectIdAccessorField() {
        return this.objectIdVariableAccessorField;
    }

    public VariableAccessorField getFFIHandleAccessorField() {
        return this.ffiHandleVariableAccessorField;
    }

    public VariableAccessorField getObjectGroupAccessorField() {
        return this.objectGroupVariableAccessorField;
    }
}

