/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.util.List;
import org.jcodings.Encoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComparable;
import org.jruby.RubyEnumerable;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.RubyTime;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.JumpException;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.CallBlock;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ObjectMarshal;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.Variable;
import org.jruby.runtime.callsite.RespondToCallSite;
import org.jruby.runtime.component.VariableEntry;
import org.jruby.runtime.invokedynamic.MethodNames;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.ByteList;
import org.jruby.util.TypeConverter;

@JRubyClass(name={"Range"}, include={"Enumerable"})
public class RubyRange
extends RubyObject {
    private IRubyObject begin;
    private IRubyObject end;
    private boolean isExclusive;
    private boolean isInited = false;
    private static final ObjectAllocator RANGE_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new RubyRange(runtime2, klass);
        }
    };
    private static final InspectRecursive INSPECT_RECURSIVE = new InspectRecursive();
    private static final byte[] DOTDOTDOT = new byte[]{46, 46, 46};
    private static final ObjectMarshal RANGE_MARSHAL = new ObjectMarshal(){

        public void marshalTo(Ruby runtime2, Object obj, RubyClass type2, MarshalStream marshalStream) throws IOException {
            RubyRange range = (RubyRange)obj;
            marshalStream.registerLinkTarget(range);
            List<Variable<Object>> attrs = range.getVariableList();
            attrs.add(new VariableEntry<RubyBoolean>("excl", range.isExclusive ? runtime2.getTrue() : runtime2.getFalse()));
            attrs.add(new VariableEntry<IRubyObject>("begin", range.begin));
            attrs.add(new VariableEntry<IRubyObject>("end", range.end));
            marshalStream.dumpVariables(attrs);
        }

        public Object unmarshalFrom(Ruby runtime2, RubyClass type2, UnmarshalStream unmarshalStream) throws IOException {
            RubyRange range = (RubyRange)type2.allocate();
            unmarshalStream.registerLinkTarget(range);
            unmarshalStream.defaultVariablesUnmarshal(range);
            IRubyObject excl = (IRubyObject)range.removeInternalVariable("excl");
            IRubyObject begin2 = (IRubyObject)range.removeInternalVariable("begin");
            IRubyObject end2 = (IRubyObject)range.removeInternalVariable("end");
            if (begin2 == null) {
                begin2 = (IRubyObject)range.removeInternalVariable("begini");
            }
            if (end2 == null) {
                end2 = (IRubyObject)range.removeInternalVariable("endi");
            }
            if (begin2 == null || end2 == null || excl == null) {
                throw runtime2.newArgumentError("bad value for range");
            }
            range.init(runtime2.getCurrentContext(), begin2, end2, excl.isTrue());
            return range;
        }
    };

    public static RubyClass createRangeClass(Ruby runtime2) {
        RubyClass result2 = runtime2.defineClass("Range", runtime2.getObject(), RANGE_ALLOCATOR);
        runtime2.setRange(result2);
        result2.setClassIndex(ClassIndex.RANGE);
        result2.setReifiedClass(RubyRange.class);
        result2.kindOf = new RubyModule.JavaClassKindOf(RubyRange.class);
        result2.setMarshal(RANGE_MARSHAL);
        result2.includeModule(runtime2.getEnumerable());
        result2.defineAnnotatedMethods(RubyRange.class);
        return result2;
    }

    private RubyRange(Ruby runtime2, RubyClass klass) {
        super(runtime2, klass);
        this.begin = this.end = runtime2.getNil();
    }

    public static RubyRange newRange(ThreadContext context, IRubyObject begin2, IRubyObject end2, boolean isExclusive) {
        RubyRange range = new RubyRange(context.runtime, context.runtime.getRange());
        range.init(context, begin2, end2, isExclusive);
        range.isInited = true;
        return range;
    }

    public static RubyRange newInclusiveRange(ThreadContext context, IRubyObject begin2, IRubyObject end2) {
        return RubyRange.newRange(context, begin2, end2, false);
    }

    public static RubyRange newExclusiveRange(ThreadContext context, IRubyObject begin2, IRubyObject end2) {
        return RubyRange.newRange(context, begin2, end2, true);
    }

    @Override
    public void copySpecialInstanceVariables(IRubyObject clone2) {
        RubyRange range = (RubyRange)clone2;
        range.begin = this.begin;
        range.end = this.end;
        range.isExclusive = this.isExclusive;
    }

    final boolean checkBegin(long length2) {
        long beg = RubyNumeric.num2long(this.begin);
        return !(beg < 0L ? (beg += length2) < 0L : length2 < beg);
    }

    final long[] begLen(long len, int err) {
        long beg = RubyNumeric.num2long(this.begin);
        long end2 = RubyNumeric.num2long(this.end);
        if (beg < 0L && (beg += len) < 0L) {
            if (err != 0) {
                throw this.getRuntime().newRangeError(beg + ".." + (this.isExclusive ? "." : "") + end2 + " out of range");
            }
            return null;
        }
        if (err == 0 || err == 2) {
            if (beg > len) {
                if (err != 0) {
                    throw this.getRuntime().newRangeError(beg + ".." + (this.isExclusive ? "." : "") + end2 + " out of range");
                }
                return null;
            }
            if (end2 > len) {
                end2 = len;
            }
        }
        if (end2 < 0L) {
            end2 += len;
        }
        if (!this.isExclusive) {
            ++end2;
        }
        if ((len = end2 - beg) < 0L) {
            len = 0L;
        }
        return new long[]{beg, len};
    }

    final long begLen0(long len) {
        long beg = RubyNumeric.num2long(this.begin);
        if (beg < 0L && (beg += len) < 0L) {
            throw this.getRuntime().newRangeError(beg + ".." + (this.isExclusive ? "." : "") + this.end + " out of range");
        }
        return beg;
    }

    final long begLen1(long len, int beg) {
        long end2 = RubyNumeric.num2long(this.end);
        if (end2 < 0L) {
            end2 += len;
        }
        if (!this.isExclusive) {
            ++end2;
        }
        if ((len = end2 - (long)beg) < 0L) {
            len = 0L;
        }
        return len;
    }

    final int[] begLenInt(int len, int err) {
        int beg = RubyNumeric.num2int(this.begin);
        int end2 = RubyNumeric.num2int(this.end);
        if (beg < 0 && (beg += len) < 0) {
            if (err != 0) {
                throw this.getRuntime().newRangeError(beg + ".." + (this.isExclusive ? "." : "") + end2 + " out of range");
            }
            return null;
        }
        if (err == 0 || err == 2) {
            if (beg > len) {
                if (err != 0) {
                    throw this.getRuntime().newRangeError(beg + ".." + (this.isExclusive ? "." : "") + end2 + " out of range");
                }
                return null;
            }
            if (end2 > len) {
                end2 = len;
            }
        }
        if (end2 < 0) {
            end2 += len;
        }
        if (!this.isExclusive) {
            ++end2;
        }
        if ((len = end2 - beg) < 0) {
            len = 0;
        }
        return new int[]{beg, len};
    }

    private void init(ThreadContext context, IRubyObject begin2, IRubyObject end2, boolean isExclusive) {
        IRubyObject result2;
        if (!(begin2 instanceof RubyFixnum && end2 instanceof RubyFixnum || !(result2 = Helpers.invokedynamic(context, begin2, MethodNames.OP_CMP, end2)).isNil())) {
            throw context.runtime.newArgumentError("bad value for range");
        }
        this.begin = begin2;
        this.end = end2;
        this.isExclusive = isExclusive;
    }

    @JRubyMethod(required=2, optional=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2, Block unusedBlock) {
        if (this.isInited) {
            throw context.runtime.newNameError("`initialize' called twice", "initialize");
        }
        this.checkFrozen();
        this.init(context, args2[0], args2[1], args2.length > 2 && args2[2].isTrue());
        this.isInited = true;
        return context.nil;
    }

    @JRubyMethod(required=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(ThreadContext context, IRubyObject original) {
        if (this.isInited) {
            throw context.runtime.newNameError("`initialize' called twice", "initialize");
        }
        RubyRange other = (RubyRange)original;
        this.init(context, other.begin, other.end, other.isExclusive);
        this.isInited = true;
        return context.nil;
    }

    @Override
    public RubyFixnum hash() {
        return this.hash(this.metaClass.runtime.getCurrentContext());
    }

    @JRubyMethod(name={"hash"})
    public RubyFixnum hash(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        int exclusiveBit = this.isExclusive ? 1 : 0;
        long hash2 = exclusiveBit;
        hash2 = Helpers.hashStart(runtime2, hash2);
        RubyFixnum v = Helpers.safeHash(context, this.begin);
        hash2 = Helpers.murmurCombine(hash2, v.convertToInteger().getLongValue());
        v = Helpers.safeHash(context, this.end);
        hash2 = Helpers.murmurCombine(hash2, v.convertToInteger().getLongValue());
        hash2 = Helpers.murmurCombine(hash2, exclusiveBit << 24);
        hash2 = Helpers.hashEnd(hash2);
        return runtime2.newFixnum(hash2);
    }

    private static RubyString inspectValue(ThreadContext context, IRubyObject value2) {
        return (RubyString)context.safeRecurse(INSPECT_RECURSIVE, value2, value2, "inspect", true);
    }

    @Override
    public IRubyObject inspect() {
        return this.inspect(this.getRuntime().getCurrentContext());
    }

    @JRubyMethod(name={"inspect"})
    public RubyString inspect(ThreadContext context) {
        RubyString i1 = RubyRange.inspectValue(context, this.begin).strDup(context.runtime);
        RubyString i2 = RubyRange.inspectValue(context, this.end);
        i1.cat(DOTDOTDOT, 0, this.isExclusive ? 3 : 2);
        i1.append(i2);
        i1.infectBy(i2);
        i1.infectBy(this);
        return i1;
    }

    @Override
    public IRubyObject to_s() {
        return this.to_s(this.getRuntime());
    }

    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s(ThreadContext context) {
        return this.to_s(context.runtime);
    }

    private RubyString to_s(Ruby runtime2) {
        RubyString i1 = this.begin.asString().strDup(runtime2);
        RubyString i2 = this.end.asString();
        i1.cat(DOTDOTDOT, 0, this.isExclusive ? 3 : 2);
        i1.append(i2);
        i1.infectBy(i2);
        i1.infectBy(this);
        return i1;
    }

    @JRubyMethod(name={"exclude_end?"})
    public RubyBoolean exclude_end_p() {
        return this.getRuntime().newBoolean(this.isExclusive);
    }

    @JRubyMethod(name={"eql?"}, required=1)
    public IRubyObject eql_p(ThreadContext context, IRubyObject other) {
        return this.equalityInner(context, other, MethodNames.EQL);
    }

    @Override
    @JRubyMethod(name={"=="}, required=1)
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        return this.equalityInner(context, other, MethodNames.OP_EQUAL);
    }

    private IRubyObject equalityInner(ThreadContext context, IRubyObject other, MethodNames equalityCheck) {
        if (this == other) {
            return context.tru;
        }
        if (!(other instanceof RubyRange)) {
            return context.fals;
        }
        RubyRange otherRange = (RubyRange)other;
        return context.runtime.newBoolean(this.isExclusive == otherRange.isExclusive && Helpers.invokedynamic(context, this.begin, equalityCheck, otherRange.begin).isTrue() && Helpers.invokedynamic(context, this.end, equalityCheck, otherRange.end).isTrue());
    }

    private static IRubyObject rangeLt(ThreadContext context, IRubyObject a, IRubyObject b2) {
        IRubyObject result2 = Helpers.invokedynamic(context, a, MethodNames.OP_CMP, b2);
        if (result2.isNil()) {
            return null;
        }
        return RubyComparable.cmpint(context, result2, a, b2) < 0 ? context.tru : null;
    }

    private static IRubyObject rangeLe(ThreadContext context, IRubyObject a, IRubyObject b2) {
        IRubyObject result2 = Helpers.invokedynamic(context, a, MethodNames.OP_CMP, b2);
        if (result2.isNil()) {
            return null;
        }
        int c = RubyComparable.cmpint(context, result2, a, b2);
        if (c == 0) {
            return RubyFixnum.zero(context.runtime);
        }
        return c < 0 ? context.tru : null;
    }

    private void rangeEach(ThreadContext context, RangeCallBack callback) {
        IRubyObject v = this.begin;
        if (this.isExclusive) {
            while (RubyRange.rangeLt(context, v, this.end) != null) {
                callback.call(context, v);
                v = v.callMethod(context, "succ");
            }
        } else {
            IRubyObject c;
            while ((c = RubyRange.rangeLe(context, v, this.end)) != null && c.isTrue()) {
                callback.call(context, v);
                if (c != RubyFixnum.zero(context.runtime)) {
                    v = v.callMethod(context, "succ");
                    continue;
                }
                break;
            }
        }
    }

    @JRubyMethod
    public IRubyObject to_a(ThreadContext context, Block block) {
        Ruby runtime2 = context.runtime;
        if (this.begin instanceof RubyFixnum && this.end instanceof RubyFixnum) {
            long base;
            long size2;
            long lim = ((RubyFixnum)this.end).getLongValue();
            if (!this.isExclusive) {
                ++lim;
            }
            if ((size2 = lim - (base = ((RubyFixnum)this.begin).getLongValue())) > Integer.MAX_VALUE) {
                throw runtime2.newRangeError("Range size too large for to_a");
            }
            if (size2 < 0L) {
                return RubyArray.newEmptyArray(runtime2);
            }
            IRubyObject[] array2 = new IRubyObject[(int)size2];
            int i2 = 0;
            while ((long)i2 < size2) {
                array2[i2] = RubyFixnum.newFixnum(runtime2, base + (long)i2);
                ++i2;
            }
            return RubyArray.newArrayMayCopy(runtime2, array2);
        }
        return RubyEnumerable.to_a(context, this);
    }

    @Deprecated
    public IRubyObject each19(ThreadContext context, Block block) {
        return this.each(context, block);
    }

    @JRubyMethod(name={"each"})
    public IRubyObject each(ThreadContext context, final Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, this, "each", this.enumSizeFn(context));
        }
        if (this.begin instanceof RubyFixnum && this.end instanceof RubyFixnum) {
            this.fixnumEach(context, block);
        } else if (this.begin instanceof RubySymbol && this.end instanceof RubySymbol) {
            ((RubySymbol)this.begin).asString().uptoCommon(context, ((RubySymbol)this.end).asString(), this.isExclusive, block, true);
        } else {
            IRubyObject tmp = this.begin.checkStringType();
            if (!tmp.isNil()) {
                ((RubyString)tmp).uptoCommon(context, this.end, this.isExclusive, block);
            } else {
                if (!RubyRange.discreteObject(context, this.begin)) {
                    throw context.runtime.newTypeError("can't iterate from " + this.begin.getMetaClass().getName());
                }
                this.rangeEach(context, new RangeCallBack(){

                    @Override
                    void call(ThreadContext context, IRubyObject arg2) {
                        block.yield(context, arg2);
                    }
                });
            }
        }
        return this;
    }

    private void fixnumEach(ThreadContext context, Block block) {
        long to = ((RubyFixnum)this.end).value;
        if (this.isExclusive) {
            if (to == Long.MIN_VALUE) {
                return;
            }
            --to;
        }
        RubyInteger.fixnumUpto(context, ((RubyFixnum)this.begin).value, to, block);
    }

    @Deprecated
    public IRubyObject step19(ThreadContext context, IRubyObject step2, Block block) {
        return this.step(context, step2, block);
    }

    @Deprecated
    public IRubyObject step19(ThreadContext context, Block block) {
        return this.step(context, block);
    }

    @JRubyMethod(name={"step"})
    public IRubyObject step(ThreadContext context, Block block) {
        return block.isGiven() ? this.stepCommon(context, RubyFixnum.one(context.runtime), block) : RubyEnumerator.enumeratorizeWithSize(context, this, "step", this.stepSizeFn(context));
    }

    @JRubyMethod(name={"step"})
    public IRubyObject step(ThreadContext context, IRubyObject step2, Block block) {
        RubyFixnum zero;
        Ruby runtime2 = context.runtime;
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, (IRubyObject)this, "step", new IRubyObject[]{step2}, this.stepSizeFn(context));
        }
        if (!(step2 instanceof RubyNumeric)) {
            step2 = step2.convertToInteger("to_int");
        }
        if (step2.callMethod(context, "<", zero = RubyFixnum.zero(runtime2)).isTrue()) {
            throw runtime2.newArgumentError("step can't be negative");
        }
        if (!step2.callMethod(context, ">", zero).isTrue()) {
            throw runtime2.newArgumentError("step can't be 0");
        }
        return this.stepCommon(context, step2, block);
    }

    private IRubyObject stepCommon(ThreadContext context, IRubyObject step2, Block block) {
        Ruby runtime2 = context.runtime;
        if (this.begin instanceof RubyFixnum && this.end instanceof RubyFixnum && step2 instanceof RubyFixnum) {
            this.fixnumStep(context, runtime2, ((RubyFixnum)step2).getLongValue(), block);
        } else if (this.begin instanceof RubyFloat || this.end instanceof RubyFloat || step2 instanceof RubyFloat) {
            RubyNumeric.floatStep(context, runtime2, this.begin, this.end, step2, this.isExclusive, block);
        } else if (this.begin instanceof RubyNumeric || !TypeConverter.checkIntegerType(runtime2, this.begin, "to_int").isNil() || !TypeConverter.checkIntegerType(runtime2, this.end, "to_int").isNil()) {
            this.numericStep(context, runtime2, step2, block);
        } else {
            IRubyObject tmp = this.begin.checkStringType();
            if (!tmp.isNil()) {
                StepBlockCallBack callback = new StepBlockCallBack(block, RubyFixnum.one(runtime2), step2);
                Block blockCallback = CallBlock.newCallClosure(context, this, Signature.ONE_ARGUMENT, callback);
                ((RubyString)tmp).uptoCommon(context, this.end, this.isExclusive, blockCallback);
            } else {
                if (!this.begin.respondsTo("succ")) {
                    throw runtime2.newTypeError("can't iterate from " + this.begin.getMetaClass().getName());
                }
                this.rangeEach(context, new StepBlockCallBack(block, RubyFixnum.one(runtime2), step2));
            }
        }
        return this;
    }

    private void fixnumStep(ThreadContext context, Ruby runtime2, long step2, Block block) {
        long i2;
        long tov;
        long to = ((RubyFixnum)this.end).getLongValue();
        if (this.isExclusive) {
            if (to == Long.MIN_VALUE) {
                return;
            }
            --to;
        }
        if (to < (tov = Long.MAX_VALUE - step2)) {
            tov = to;
        }
        for (i2 = ((RubyFixnum)this.begin).getLongValue(); i2 <= tov; i2 += step2) {
            block.yield(context, RubyFixnum.newFixnum(runtime2, i2));
        }
        if (i2 <= to) {
            block.yield(context, RubyFixnum.newFixnum(runtime2, i2));
        }
    }

    private void numericStep(ThreadContext context, Ruby runtime2, IRubyObject step2, Block block) {
        String method2 = this.isExclusive ? "<" : "<=";
        IRubyObject beg = this.begin;
        long i2 = 0L;
        while (beg.callMethod(context, method2, this.end).isTrue()) {
            block.yield(context, beg);
            beg = this.begin.callMethod(context, "+", RubyFixnum.newFixnum(runtime2, ++i2).callMethod(context, "*", step2));
        }
    }

    private RubyEnumerator.SizeFn enumSizeFn(final ThreadContext context) {
        final RubyRange self2 = this;
        return new RubyEnumerator.SizeFn(){

            @Override
            public IRubyObject size(IRubyObject[] args2) {
                return self2.size(context);
            }
        };
    }

    private RubyEnumerator.SizeFn stepSizeFn(final ThreadContext context) {
        final RubyRange self2 = this;
        return new RubyEnumerator.SizeFn(){

            @Override
            public IRubyObject size(IRubyObject[] args2) {
                IRubyObject step2;
                Ruby runtime2 = context.runtime;
                IRubyObject begin2 = self2.begin;
                IRubyObject end2 = self2.end;
                if (args2 != null && args2.length > 0) {
                    step2 = args2[0];
                    if (!(step2 instanceof RubyNumeric)) {
                        step2.convertToInteger();
                    }
                } else {
                    step2 = RubyFixnum.one(runtime2);
                }
                if (step2.callMethod(context, "<", RubyFixnum.zero(runtime2)).isTrue()) {
                    throw runtime2.newArgumentError("step can't be negative");
                }
                if (!step2.callMethod(context, ">", RubyFixnum.zero(runtime2)).isTrue()) {
                    throw runtime2.newArgumentError("step can't be 0");
                }
                if (begin2 instanceof RubyNumeric && end2 instanceof RubyNumeric) {
                    return RubyNumeric.intervalStepSize(context, begin2, end2, step2, self2.isExclusive);
                }
                return context.nil;
            }
        };
    }

    @Deprecated
    public IRubyObject include_p19(ThreadContext context, IRubyObject obj) {
        return this.include_p(context, obj);
    }

    @JRubyMethod(name={"include?", "member?"}, frame=true)
    public IRubyObject include_p(ThreadContext context, IRubyObject obj) {
        boolean iterable;
        Ruby runtime2 = context.runtime;
        boolean bl = iterable = this.begin instanceof RubyNumeric || this.end instanceof RubyNumeric || RubyRange.linearObject(context, this.begin) || RubyRange.linearObject(context, this.end);
        if (iterable || !TypeConverter.convertToTypeWithCheck(context, this.begin, runtime2.getInteger(), RubyRange.sites((ThreadContext)context).to_int_checked).isNil() || !TypeConverter.convertToTypeWithCheck(context, this.end, runtime2.getInteger(), RubyRange.sites((ThreadContext)context).to_int_checked).isNil()) {
            return this.cover_p(context, obj);
        }
        if (this.begin instanceof RubyString && this.end instanceof RubyString && ((RubyString)this.begin).getByteList().getRealSize() == 1 && ((RubyString)this.end).getByteList().getRealSize() == 1) {
            if (obj.isNil()) {
                return runtime2.getFalse();
            }
            if (obj instanceof RubyString) {
                ByteList objBytes = ((RubyString)obj).getByteList();
                if (objBytes.getRealSize() != 1) {
                    return runtime2.getFalse();
                }
                int v = objBytes.getUnsafeBytes()[objBytes.getBegin()] & 0xFF;
                ByteList begBytes = ((RubyString)this.begin).getByteList();
                int b2 = begBytes.getUnsafeBytes()[begBytes.getBegin()] & 0xFF;
                ByteList endBytes = ((RubyString)this.end).getByteList();
                int e = endBytes.getUnsafeBytes()[endBytes.getBegin()] & 0xFF;
                if (Encoding.isAscii((int)v) && Encoding.isAscii((int)b2) && Encoding.isAscii((int)e)) {
                    if (b2 <= v && v < e || !this.isExclusive && v == e) {
                        return runtime2.getTrue();
                    }
                    return runtime2.getFalse();
                }
            }
        }
        return Helpers.invokeSuper(context, (IRubyObject)this, obj, Block.NULL_BLOCK);
    }

    private static boolean discreteObject(ThreadContext context, IRubyObject obj) {
        if (obj instanceof RubyTime) {
            return false;
        }
        return RubyRange.sites((ThreadContext)context).respond_to_succ.respondsTo(context, obj, obj, false);
    }

    private static boolean linearObject(ThreadContext context, IRubyObject obj) {
        if (obj instanceof RubyFixnum || obj instanceof RubyFloat) {
            return true;
        }
        if (obj instanceof RubyBignum) {
            return true;
        }
        if (obj instanceof RubyNumeric) {
            return true;
        }
        return obj instanceof RubyTime;
    }

    @JRubyMethod(name={"==="})
    public IRubyObject eqq_p(ThreadContext context, IRubyObject obj) {
        return this.callMethod(context, "include?", obj);
    }

    @JRubyMethod(name={"cover?"})
    public RubyBoolean cover_p(ThreadContext context, IRubyObject obj) {
        if (RubyRange.rangeLe(context, this.begin, obj) == null) {
            return context.fals;
        }
        return context.runtime.newBoolean(this.isExclusive ? RubyRange.rangeLt(context, obj, this.end) != null : RubyRange.rangeLe(context, obj, this.end) != null);
    }

    @JRubyMethod(frame=true)
    public IRubyObject min(ThreadContext context, Block block) {
        if (block.isGiven()) {
            return Helpers.invokeSuper(context, this, block);
        }
        int cmp2 = RubyComparable.cmpint(context, Helpers.invokedynamic(context, this.begin, MethodNames.OP_CMP, this.end), this.begin, this.end);
        if (cmp2 > 0 || cmp2 == 0 && this.isExclusive) {
            return context.nil;
        }
        return this.begin;
    }

    @JRubyMethod(frame=true)
    public IRubyObject max(ThreadContext context, Block block) {
        boolean isNumeric = this.end instanceof RubyNumeric;
        if (block.isGiven() || this.isExclusive && !isNumeric) {
            return Helpers.invokeSuper(context, this, block);
        }
        int cmp2 = RubyComparable.cmpint(context, Helpers.invokedynamic(context, this.begin, MethodNames.OP_CMP, this.end), this.begin, this.end);
        if (cmp2 > 0) {
            return context.nil;
        }
        if (this.isExclusive) {
            if (!(this.end instanceof RubyInteger)) {
                throw context.runtime.newTypeError("cannot exclude non Integer end value");
            }
            if (cmp2 == 0) {
                return context.nil;
            }
            if (!(this.begin instanceof RubyInteger)) {
                throw context.runtime.newTypeError("cannot exclude end value with non Integer begin value");
            }
            if (this.end instanceof RubyFixnum) {
                return RubyFixnum.newFixnum(context.runtime, ((RubyFixnum)this.end).getLongValue() - 1L);
            }
            return this.end.callMethod(context, "-", RubyFixnum.one(context.runtime));
        }
        return this.end;
    }

    @JRubyMethod(frame=true)
    public IRubyObject min(ThreadContext context, IRubyObject arg2, Block block) {
        return Helpers.invokeSuper(context, (IRubyObject)this, arg2, block);
    }

    @JRubyMethod(frame=true)
    public IRubyObject max(ThreadContext context, IRubyObject arg2, Block block) {
        return Helpers.invokeSuper(context, (IRubyObject)this, arg2, block);
    }

    @JRubyMethod
    public IRubyObject first(ThreadContext context) {
        return this.begin;
    }

    @JRubyMethod
    public IRubyObject begin(ThreadContext context) {
        return this.begin;
    }

    @JRubyMethod
    public IRubyObject first(ThreadContext context, IRubyObject arg2) {
        Ruby runtime2 = context.runtime;
        final int num = RubyNumeric.num2int(arg2);
        if (num < 0) {
            throw context.runtime.newArgumentError("negative array size (or size too big)");
        }
        final RubyArray result2 = runtime2.newArray(num);
        try {
            RubyEnumerable.callEach(context, this, Signature.ONE_ARGUMENT, new BlockCallback(){
                int n;
                {
                    this.n = num;
                }

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    return this.call(ctx, largs[0], blk);
                }

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject larg, Block blk) {
                    if (this.n-- <= 0) {
                        throw JumpException.SPECIAL_JUMP;
                    }
                    result2.append(larg);
                    return ctx.nil;
                }
            });
        }
        catch (JumpException.SpecialJump specialJump) {
            // empty catch block
        }
        return result2;
    }

    @JRubyMethod
    public IRubyObject last(ThreadContext context) {
        return this.end;
    }

    @JRubyMethod
    public IRubyObject end(ThreadContext context) {
        return this.end;
    }

    @JRubyMethod
    public IRubyObject last(ThreadContext context, IRubyObject arg2) {
        return ((RubyArray)RubyKernel.new_array(context, this, this)).last(arg2);
    }

    @JRubyMethod
    public IRubyObject size(ThreadContext context) {
        if (this.begin instanceof RubyNumeric && this.end instanceof RubyNumeric) {
            return RubyNumeric.intervalStepSize(context, this.begin, this.end, RubyFixnum.one(context.runtime), this.isExclusive);
        }
        return context.nil;
    }

    public final boolean isExcludeEnd() {
        return this.isExclusive;
    }

    public static RubyRange rangeFromRangeLike(ThreadContext context, IRubyObject rangeLike, CallSite beginSite, CallSite endSite, CallSite excludeEndSite) {
        IRubyObject begin2 = beginSite.call(context, rangeLike, rangeLike);
        IRubyObject end2 = endSite.call(context, rangeLike, rangeLike);
        IRubyObject excl = excludeEndSite.call(context, rangeLike, rangeLike);
        return RubyRange.newRange(context, begin2, end2, excl.isTrue());
    }

    public static boolean isRangeLike(ThreadContext context, IRubyObject obj, RespondToCallSite respond_to_begin, RespondToCallSite respond_to_end) {
        return respond_to_begin.respondsTo(context, obj, obj) && respond_to_end.respondsTo(context, obj, obj);
    }

    public static boolean isRangeLike(ThreadContext context, IRubyObject obj, JavaSites.CheckedSites begin_checked, JavaSites.CheckedSites end_checked, JavaSites.CheckedSites exclude_end_checked) {
        return obj.checkCallMethod(context, begin_checked) != null && obj.checkCallMethod(context, end_checked) != null && obj.checkCallMethod(context, exclude_end_checked) != null;
    }

    public static IRubyObject rangeBeginLength(ThreadContext context, IRubyObject range, int len, int[] begLen, int err) {
        JavaSites.RangeSites sites = RubyRange.sites(context);
        if (!RubyRange.isRangeLike(context, range, sites.respond_to_begin, sites.respond_to_end)) {
            return context.fals;
        }
        IRubyObject _beg = sites.begin.call(context, range, range);
        IRubyObject _end = sites.end.call(context, range, range);
        boolean excludeEnd = sites.exclude_end.call(context, range, range).isTrue();
        int beg = _beg.convertToInteger().getIntValue();
        int end2 = _end.convertToInteger().getIntValue();
        int origBeg = beg;
        int origEnd = end2;
        if (beg < 0 && (beg += len) < 0) {
            return RubyRange.rangeBeginLengthError(context, origBeg, origEnd, excludeEnd, err);
        }
        if (end2 < 0) {
            end2 += len;
        }
        if (!excludeEnd) {
            ++end2;
        }
        if (err == 0 || err == 2) {
            if (beg > len) {
                return RubyRange.rangeBeginLengthError(context, origBeg, origEnd, excludeEnd, err);
            }
            if (end2 > len) {
                end2 = len;
            }
        }
        if ((len = end2 - beg) < 0) {
            len = 0;
        }
        begLen[0] = beg;
        begLen[1] = len;
        return context.tru;
    }

    private static IRubyObject rangeBeginLengthError(ThreadContext context, int beg, int end2, boolean excludeEnd, int err) {
        if (err != 0) {
            throw context.runtime.newRangeError(beg + ".." + (excludeEnd ? "." : "") + end2 + " out of range");
        }
        return context.nil;
    }

    private static JavaSites.RangeSites sites(ThreadContext context) {
        return context.sites.Range;
    }

    private static final class StepBlockCallBack
    extends RangeCallBack
    implements BlockCallback {
        final Block block;
        IRubyObject iter;
        final IRubyObject step;

        StepBlockCallBack(Block block, RubyFixnum iter, IRubyObject step2) {
            this.block = block;
            this.iter = iter;
            this.step = step2;
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject[] args2, Block originalBlock) {
            this.call(context, args2[0]);
            return context.nil;
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject arg2, Block originalBlock) {
            this.call(context, arg2);
            return context.nil;
        }

        @Override
        void call(ThreadContext context, IRubyObject arg2) {
            this.iter = this.iter instanceof RubyInteger ? ((RubyInteger)this.iter).op_minus(context, 1L) : this.iter.callMethod(context, "-", RubyFixnum.one(context.runtime));
            IRubyObject i2 = this.iter;
            if (i2 instanceof RubyInteger && ((RubyInteger)i2).isZero()) {
                this.block.yield(context, arg2);
                this.iter = this.step;
            }
        }
    }

    private static abstract class RangeCallBack {
        private RangeCallBack() {
        }

        abstract void call(ThreadContext var1, IRubyObject var2);
    }

    private static class InspectRecursive
    implements ThreadContext.RecursiveFunctionEx<IRubyObject> {
        private InspectRecursive() {
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject state2, IRubyObject obj, boolean recur) {
            if (recur) {
                return RubyString.newString(context.runtime, ((RubyRange)obj).isExclusive ? "(... ... ...)" : "(... .. ...)");
            }
            return RubyObject.inspect(context, obj);
        }
    }
}

