/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComplex;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyMatchData;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.common.IRubyWarnings;
import org.jruby.runtime.Arity;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ObjectMarshal;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.invokedynamic.MethodNames;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.ByteList;
import org.jruby.util.Numeric;
import org.jruby.util.TypeConverter;

@JRubyClass(name={"Rational"}, parent="Numeric")
public class RubyRational
extends RubyNumeric {
    private static ObjectAllocator RATIONAL_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            RubyFixnum zero = RubyFixnum.zero(runtime2);
            return new RubyRational(runtime2, klass, zero, zero);
        }
    };
    private RubyInteger num;
    private RubyInteger den;
    private static boolean canonicalization = false;
    private static final long ML = (long)(Math.log(Double.MAX_VALUE) / Math.log(2.0) - 1.0);
    private static final ObjectMarshal RATIONAL_MARSHAL = new ObjectMarshal(){

        public void marshalTo(Ruby runtime2, Object obj, RubyClass type2, MarshalStream marshalStream) {
            throw runtime2.newTypeError("marshal_dump should be used instead for Rational");
        }

        public Object unmarshalFrom(Ruby runtime2, RubyClass type2, UnmarshalStream unmarshalStream) throws IOException {
            ThreadContext context = runtime2.getCurrentContext();
            RubyRational r = (RubyRational)RubyClass.DEFAULT_OBJECT_MARSHAL.unmarshalFrom(runtime2, type2, unmarshalStream);
            RubyInteger num = RubyRational.intCheck(context, r.removeInstanceVariable("@numerator"));
            RubyInteger den = RubyRational.intCheck(context, r.removeInstanceVariable("@denominator"));
            if (RubyRational.canonicalizeShouldNegate(context, den)) {
                num = num.negate();
                den = den.negate();
            }
            r.num = num;
            r.den = den;
            return r;
        }
    };

    public static RubyClass createRationalClass(Ruby runtime2) {
        RubyClass rationalc = runtime2.defineClass("Rational", runtime2.getNumeric(), RATIONAL_ALLOCATOR);
        runtime2.setRational(rationalc);
        rationalc.setClassIndex(ClassIndex.RATIONAL);
        rationalc.setReifiedClass(RubyRational.class);
        rationalc.kindOf = new RubyModule.JavaClassKindOf(RubyRational.class);
        rationalc.setMarshal(RATIONAL_MARSHAL);
        rationalc.defineAnnotatedMethods(RubyRational.class);
        rationalc.getSingletonClass().undefineMethod("allocate");
        rationalc.getSingletonClass().undefineMethod("new");
        return rationalc;
    }

    private RubyRational(Ruby runtime2, RubyClass clazz, RubyInteger num, RubyInteger den) {
        super(runtime2, clazz);
        this.num = num;
        this.den = den;
    }

    public static RubyRational newRationalRaw(Ruby runtime2, IRubyObject x, IRubyObject y) {
        return RubyRational.newRational(runtime2, runtime2.getRational(), x, y);
    }

    static RubyRational newRationalRaw(Ruby runtime2, IRubyObject x) {
        return RubyRational.newRational(runtime2, runtime2.getRational(), x, RubyFixnum.one(runtime2));
    }

    static RubyNumeric newRationalCanonicalize(ThreadContext context, RubyInteger x) {
        return (RubyNumeric)RubyRational.newRationalCanonicalize(context, x, RubyFixnum.one(context.runtime));
    }

    public static IRubyObject newRationalCanonicalize(ThreadContext context, RubyInteger x, RubyInteger y) {
        return RubyRational.canonicalizeInternal(context, context.runtime.getRational(), x, y);
    }

    public static IRubyObject newRationalCanonicalize(ThreadContext context, IRubyObject x, IRubyObject y) {
        return RubyRational.canonicalizeInternal(context, context.runtime.getRational(), (RubyInteger)x, (RubyInteger)y);
    }

    public static IRubyObject newRationalCanonicalize(ThreadContext context, long x, long y) {
        Ruby runtime2 = context.runtime;
        return RubyRational.canonicalizeInternal(context, runtime2.getRational(), x, y);
    }

    public static IRubyObject newRationalCanonicalize(ThreadContext context, long x) {
        Ruby runtime2 = context.runtime;
        return RubyRational.canonicalizeInternal(context, runtime2.getRational(), x, 1L);
    }

    static RubyNumeric newRationalNoReduce(ThreadContext context, RubyInteger x, RubyInteger y) {
        return RubyRational.canonicalizeInternalNoReduce(context, context.runtime.getRational(), x, y);
    }

    private static RubyNumeric newRationalNoReduce(ThreadContext context, RubyClass clazz, RubyInteger x, RubyInteger y) {
        return RubyRational.canonicalizeInternalNoReduce(context, clazz, x, y);
    }

    private static RubyRational newRationalBang(ThreadContext context, RubyClass clazz, IRubyObject x, IRubyObject y) {
        assert (!Numeric.f_negative_p(context, y) && !Numeric.f_zero_p(context, y));
        return RubyRational.newRational(context.runtime, clazz, x, y);
    }

    private static RubyRational newRationalBang(ThreadContext context, RubyClass clazz, IRubyObject x) {
        return RubyRational.newRationalBang(context, clazz, x, RubyFixnum.one(context.runtime));
    }

    private static RubyRational newRationalBang(ThreadContext context, RubyClass clazz, long x) {
        return RubyRational.newRationalBang(context, clazz, RubyFixnum.newFixnum(context.runtime, x), RubyFixnum.one(context.runtime));
    }

    @Override
    public ClassIndex getNativeClassIndex() {
        return ClassIndex.RATIONAL;
    }

    public static void setCanonicalization(boolean canonical) {
        canonicalization = canonical;
    }

    private static RubyInteger intCheck(ThreadContext context, IRubyObject num) {
        if (num instanceof RubyInteger) {
            return (RubyInteger)num;
        }
        if (!(num instanceof RubyNumeric) || !RubyRational.integer_p(context).call(context, num, num).isTrue()) {
            throw context.runtime.newTypeError("can't convert " + num.getMetaClass().getName() + " into Rational");
        }
        return num.convertToInteger();
    }

    private static CallSite integer_p(ThreadContext context) {
        return context.sites.Numeric.integer;
    }

    static RubyInteger intValue(ThreadContext context, IRubyObject num) {
        RubyInteger i2 = RubyInteger.toInteger(context, num);
        if (i2 == null) {
            throw context.runtime.newTypeError("can't convert " + num.getMetaClass().getName() + " into Rational");
        }
        return i2;
    }

    private static RubyNumeric canonicalizeInternal(ThreadContext context, RubyClass clazz, RubyInteger num, RubyInteger den) {
        if (RubyRational.canonicalizeShouldNegate(context, den)) {
            num = num.negate();
            den = den.negate();
        }
        RubyInteger gcd2 = Numeric.f_gcd(context, num, den);
        RubyInteger _num = (RubyInteger)num.idiv(context, gcd2);
        RubyInteger _den = (RubyInteger)den.idiv(context, gcd2);
        if (canonicalization && Numeric.f_one_p(context, _den)) {
            return _num;
        }
        return RubyRational.newRational(context.runtime, clazz, _num, _den);
    }

    private static RubyNumeric canonicalizeInternal(ThreadContext context, RubyClass clazz, long num, long den) {
        if (den == 0L) {
            throw context.runtime.newZeroDivisionError();
        }
        if (num == Long.MIN_VALUE && den == Long.MIN_VALUE) {
            RubyRational.canonicalizeInternal(context, clazz, context.runtime.newFixnum(num), context.runtime.newFixnum(den));
        }
        long gcd2 = Numeric.i_gcd(num, den);
        RubyInteger _num = (RubyInteger)context.runtime.newFixnum(num).idiv(context, gcd2);
        RubyInteger _den = (RubyInteger)context.runtime.newFixnum(den).idiv(context, gcd2);
        if (canonicalization && _den.getLongValue() == 1L) {
            return _num;
        }
        return RubyRational.newRational(context.runtime, clazz, _num, _den);
    }

    private static RubyNumeric canonicalizeInternalNoReduce(ThreadContext context, RubyClass clazz, RubyInteger num, RubyInteger den) {
        if (RubyRational.canonicalizeShouldNegate(context, den)) {
            num = num.negate();
            den = den.negate();
        }
        if (canonicalization && Numeric.f_one_p(context, den)) {
            return num;
        }
        return RubyRational.newRational(context.runtime, clazz, num, den);
    }

    private static boolean canonicalizeShouldNegate(ThreadContext context, RubyInteger den) {
        int signum = den.signum();
        if (signum == 0) {
            throw context.runtime.newZeroDivisionError();
        }
        return signum < 0;
    }

    @Deprecated
    public static IRubyObject newInstance(ThreadContext context, IRubyObject clazz, IRubyObject[] args2) {
        switch (args2.length) {
            case 1: {
                return RubyRational.newInstance(context, (RubyClass)clazz, args2[0]);
            }
            case 2: {
                return RubyRational.newInstance(context, (RubyClass)clazz, args2[0], args2[1]);
            }
        }
        Arity.raiseArgumentError(context.runtime, args2.length, 1, 1);
        return null;
    }

    @Deprecated
    public static IRubyObject newInstance(ThreadContext context, IRubyObject clazz, IRubyObject num) {
        return RubyRational.newInstance(context, (RubyClass)clazz, num);
    }

    static RubyNumeric newInstance(ThreadContext context, RubyClass clazz, IRubyObject num) {
        return RubyRational.canonicalizeInternal(context, clazz, RubyRational.intValue(context, num), RubyFixnum.one(context.runtime));
    }

    @Deprecated
    public static IRubyObject newInstance(ThreadContext context, IRubyObject clazz, IRubyObject num, IRubyObject den) {
        return RubyRational.newInstance(context, (RubyClass)clazz, num, den);
    }

    static RubyNumeric newInstance(ThreadContext context, RubyClass clazz, IRubyObject num, IRubyObject den) {
        return RubyRational.canonicalizeInternal(context, clazz, RubyRational.intValue(context, num), RubyRational.intValue(context, den));
    }

    static RubyNumeric newInstance(ThreadContext context, RubyClass clazz, RubyInteger num, RubyInteger den) {
        return RubyRational.canonicalizeInternal(context, clazz, num, den);
    }

    public static RubyNumeric newInstance(ThreadContext context, RubyInteger num, RubyInteger den) {
        return RubyRational.canonicalizeInternal(context, context.runtime.getRational(), num, den);
    }

    public static RubyNumeric newInstance(ThreadContext context, RubyInteger num) {
        return RubyRational.canonicalizeInternal(context, context.runtime.getRational(), num, RubyFixnum.one(context.runtime));
    }

    public static IRubyObject newRationalConvert(ThreadContext context, IRubyObject x) {
        return RubyRational.newRationalConvert(context, x, RubyFixnum.one(context.runtime));
    }

    public static IRubyObject newRationalConvert(ThreadContext context, IRubyObject x, IRubyObject y) {
        return RubyRational.convert(context, context.runtime.getRational(), x, y);
    }

    public static RubyRational newRational(Ruby runtime2, long x, long y) {
        RubyRational rat = new RubyRational(runtime2, runtime2.getRational(), runtime2.newFixnum(x), runtime2.newFixnum(y));
        rat.setFrozen(true);
        return rat;
    }

    static RubyRational newRational(Ruby runtime2, RubyClass clazz, IRubyObject x, IRubyObject y) {
        RubyRational rat = new RubyRational(runtime2, clazz, x.convertToInteger(), y.convertToInteger());
        rat.setFrozen(true);
        return rat;
    }

    @Deprecated
    public static IRubyObject convert(ThreadContext context, IRubyObject clazz, IRubyObject[] args2) {
        switch (args2.length) {
            case 1: {
                return RubyRational.convert(context, clazz, args2[0]);
            }
            case 2: {
                return RubyRational.convert(context, clazz, args2[0], args2[1]);
            }
        }
        Arity.raiseArgumentError(context.runtime, args2.length, 1, 1);
        return null;
    }

    @JRubyMethod(name={"convert"}, meta=true, visibility=Visibility.PRIVATE)
    public static IRubyObject convert(ThreadContext context, IRubyObject recv2, IRubyObject a1) {
        if (a1 == context.nil) {
            throw context.runtime.newTypeError("can't convert nil into Rational");
        }
        return RubyRational.convertCommon(context, (RubyClass)recv2, a1, context.nil);
    }

    @JRubyMethod(name={"convert"}, meta=true, visibility=Visibility.PRIVATE)
    public static IRubyObject convert(ThreadContext context, IRubyObject recv2, IRubyObject a1, IRubyObject a2) {
        if (a1 == context.nil || a2 == context.nil) {
            throw context.runtime.newTypeError("can't convert nil into Rational");
        }
        return RubyRational.convertCommon(context, (RubyClass)recv2, a1, a2);
    }

    private static RubyNumeric convertCommon(ThreadContext context, RubyClass clazz, IRubyObject a1, IRubyObject a2) {
        RubyComplex a2c;
        RubyComplex a1c;
        if (a1 instanceof RubyComplex && Numeric.k_exact_p((a1c = (RubyComplex)a1).getImage()) && Numeric.f_zero_p(context, a1c.getImage())) {
            a1 = a1c.getReal();
        }
        if (a2 instanceof RubyComplex && Numeric.k_exact_p((a2c = (RubyComplex)a2).getImage()) && Numeric.f_zero_p(context, a2c.getImage())) {
            a2 = a2c.getReal();
        }
        if (a1 instanceof RubyInteger) {
            a1 = ((RubyInteger)a1).to_r(context);
        } else if (a1 instanceof RubyFloat) {
            a1 = ((RubyFloat)a1).to_r(context);
        } else if (a1 instanceof RubyString) {
            a1 = RubyRational.str_to_r_strict(context, (RubyString)a1);
        } else if (a1 instanceof RubyObject && RubyRational.sites((ThreadContext)context).respond_to_to_r.respondsTo(context, a1, a1)) {
            a1 = Numeric.f_to_r(context, a1);
        }
        if (a2 instanceof RubyFloat) {
            a2 = ((RubyFloat)a2).to_r(context);
        } else if (a2 instanceof RubyString) {
            a2 = RubyRational.str_to_r_strict(context, (RubyString)a2);
        }
        if (a1 instanceof RubyRational && (a2 == context.nil || Numeric.k_exact_p(a2) && Numeric.f_one_p(context, a2))) {
            return (RubyRational)a1;
        }
        if (a2 == context.nil) {
            if (!(a1 instanceof RubyNumeric) || !Numeric.f_integer_p(context, (RubyNumeric)a1)) {
                return (RubyRational)TypeConverter.convertToType(context, a1, context.runtime.getRational(), RubyRational.sites((ThreadContext)context).to_r_checked);
            }
            return RubyRational.newInstance(context, clazz, a1);
        }
        if (a1 instanceof RubyNumeric && a2 instanceof RubyNumeric && (!Numeric.f_integer_p(context, (RubyNumeric)a1) || !Numeric.f_integer_p(context, (RubyNumeric)a2))) {
            return (RubyNumeric)Numeric.f_div(context, a1, a2);
        }
        return RubyRational.newInstance(context, clazz, a1, a2);
    }

    @Override
    @JRubyMethod(name={"numerator"})
    public IRubyObject numerator(ThreadContext context) {
        return this.num;
    }

    @Override
    @JRubyMethod(name={"denominator"})
    public IRubyObject denominator(ThreadContext context) {
        return this.den;
    }

    public RubyInteger getNumerator() {
        return this.num;
    }

    public RubyInteger getDenominator() {
        return this.den;
    }

    @Override
    public RubyRational convertToRational() {
        return this;
    }

    @Override
    public IRubyObject zero_p(ThreadContext context) {
        return context.runtime.newBoolean(this.isZero());
    }

    @Override
    public final boolean isZero() {
        return this.num.isZero();
    }

    @Override
    public IRubyObject nonzero_p(ThreadContext context) {
        return this.isZero() ? context.nil : this;
    }

    @Override
    public IRubyObject isNegative(ThreadContext context) {
        return context.runtime.newBoolean(this.signum() < 0);
    }

    @Override
    public IRubyObject isPositive(ThreadContext context) {
        return context.runtime.newBoolean(this.signum() > 0);
    }

    @Override
    public boolean isNegative() {
        return this.signum() < 0;
    }

    @Override
    public boolean isPositive() {
        return this.signum() > 0;
    }

    public final int signum() {
        return this.num.signum();
    }

    private static RubyInteger f_imul(ThreadContext context, long a, long b2) {
        Ruby runtime2 = context.runtime;
        if (a == 0L || b2 == 0L) {
            return RubyFixnum.zero(runtime2);
        }
        if (a == 1L) {
            return RubyFixnum.newFixnum(runtime2, b2);
        }
        if (b2 == 1L) {
            return RubyFixnum.newFixnum(runtime2, a);
        }
        long c = a * b2;
        if (c / a != b2) {
            return (RubyInteger)RubyBignum.newBignum(runtime2, a).op_mul(context, b2);
        }
        return RubyFixnum.newFixnum(runtime2, c);
    }

    private static RubyNumeric f_addsub(ThreadContext context, RubyClass metaClass, RubyInteger anum, RubyInteger aden, RubyInteger bnum, RubyInteger bden, boolean plus) {
        RubyInteger b2;
        RubyInteger a;
        RubyInteger g;
        if (anum instanceof RubyFixnum && aden instanceof RubyFixnum && bnum instanceof RubyFixnum && bden instanceof RubyFixnum) {
            long an = ((RubyFixnum)anum).getLongValue();
            long ad = ((RubyFixnum)aden).getLongValue();
            long bn = ((RubyFixnum)bnum).getLongValue();
            long bd = ((RubyFixnum)bden).getLongValue();
            long ig = Numeric.i_gcd(ad, bd);
            g = RubyFixnum.newFixnum(context.runtime, ig);
            a = RubyRational.f_imul(context, an, bd / ig);
            b2 = RubyRational.f_imul(context, bn, ad / ig);
        } else {
            g = Numeric.f_gcd(context, aden, bden);
            a = Numeric.f_mul(context, anum, Numeric.f_idiv(context, bden, g));
            b2 = Numeric.f_mul(context, bnum, Numeric.f_idiv(context, aden, g));
        }
        RubyInteger c = plus ? Numeric.f_add(context, a, b2) : Numeric.f_sub(context, a, b2);
        b2 = Numeric.f_idiv(context, aden, g);
        g = Numeric.f_gcd(context, c, g);
        RubyInteger newNum = Numeric.f_idiv(context, c, g);
        a = Numeric.f_idiv(context, bden, g);
        RubyInteger newDen = Numeric.f_mul(context, a, b2);
        return RubyRational.newRationalNoReduce(context, metaClass, newNum, newDen);
    }

    @Override
    @JRubyMethod(name={"+"})
    public IRubyObject op_plus(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyInteger) {
            return RubyRational.f_addsub(context, this.getMetaClass(), this.num, this.den, (RubyInteger)other, RubyFixnum.one(context.runtime), true);
        }
        if (other instanceof RubyFloat) {
            return Numeric.f_add(context, RubyRational.r_to_f(context, this), other);
        }
        if (other instanceof RubyRational) {
            return this.op_plus(context, (RubyRational)other);
        }
        return this.coerceBin(context, RubyRational.sites((ThreadContext)context).op_plus, other);
    }

    public final RubyNumeric op_plus(ThreadContext context, RubyRational other) {
        return RubyRational.f_addsub(context, this.getMetaClass(), this.num, this.den, other.num, other.den, true);
    }

    @Deprecated
    public IRubyObject op_add(ThreadContext context, IRubyObject other) {
        return this.op_plus(context, other);
    }

    @JRubyMethod(name={"-"})
    public IRubyObject op_minus(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyInteger) {
            return RubyRational.f_addsub(context, this.getMetaClass(), this.num, this.den, (RubyInteger)other, RubyFixnum.one(context.runtime), false);
        }
        if (other instanceof RubyFloat) {
            return Numeric.f_sub(context, RubyRational.r_to_f(context, this), other);
        }
        if (other instanceof RubyRational) {
            return this.op_minus(context, (RubyRational)other);
        }
        return this.coerceBin(context, RubyRational.sites((ThreadContext)context).op_minus, other);
    }

    public final RubyNumeric op_minus(ThreadContext context, RubyRational other) {
        return RubyRational.f_addsub(context, this.getMetaClass(), this.num, this.den, other.num, other.den, false);
    }

    @Deprecated
    public IRubyObject op_sub(ThreadContext context, IRubyObject other) {
        return this.op_minus(context, other);
    }

    @Override
    public IRubyObject op_uminus(ThreadContext context) {
        return RubyRational.newRationalNoReduce(context, this.num.negate(), this.den);
    }

    private static RubyNumeric f_muldiv(ThreadContext context, RubyClass clazz, RubyInteger anum, RubyInteger aden, RubyInteger bnum, RubyInteger bden, boolean mult) {
        RubyInteger newDen;
        RubyInteger newNum;
        if (!mult) {
            if (Numeric.f_negative_p(context, bnum)) {
                anum = anum.negate();
                bnum = bnum.negate();
            }
            RubyInteger tmp = bnum;
            bnum = bden;
            bden = tmp;
        }
        if (anum instanceof RubyFixnum && aden instanceof RubyFixnum && bnum instanceof RubyFixnum && bden instanceof RubyFixnum) {
            long an = ((RubyFixnum)anum).getLongValue();
            long ad = ((RubyFixnum)aden).getLongValue();
            long bn = ((RubyFixnum)bnum).getLongValue();
            long bd = ((RubyFixnum)bden).getLongValue();
            long g1 = Numeric.i_gcd(an, bd);
            long g2 = Numeric.i_gcd(ad, bn);
            newNum = RubyRational.f_imul(context, an / g1, bn / g2);
            newDen = RubyRational.f_imul(context, ad / g2, bd / g1);
        } else {
            RubyInteger g1 = Numeric.f_gcd(context, anum, bden);
            RubyInteger g2 = Numeric.f_gcd(context, aden, bnum);
            newNum = Numeric.f_mul(context, Numeric.f_idiv(context, anum, g1), Numeric.f_idiv(context, bnum, g2));
            newDen = Numeric.f_mul(context, Numeric.f_idiv(context, aden, g2), Numeric.f_idiv(context, bden, g1));
        }
        return RubyRational.newRationalNoReduce(context, clazz, newNum, newDen);
    }

    @JRubyMethod(name={"*"})
    public IRubyObject op_mul(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyInteger) {
            return this.op_mul(context, (RubyInteger)other);
        }
        if (other instanceof RubyFloat) {
            return Numeric.f_mul(context, RubyRational.r_to_f(context, this), other);
        }
        if (other instanceof RubyRational) {
            RubyRational otherRational = (RubyRational)other;
            return RubyRational.f_muldiv(context, this.getMetaClass(), this.num, this.den, otherRational.num, otherRational.den, true);
        }
        return this.coerceBin(context, RubyRational.sites((ThreadContext)context).op_times, other);
    }

    public IRubyObject op_mul(ThreadContext context, RubyInteger other) {
        return RubyRational.f_muldiv(context, this.getMetaClass(), this.num, this.den, other, RubyFixnum.one(context.runtime), true);
    }

    @JRubyMethod(name={"/", "quo"})
    public IRubyObject op_div(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyInteger) {
            return this.op_div(context, (RubyInteger)other);
        }
        if (other instanceof RubyFloat) {
            IRubyObject fval = RubyRational.r_to_f(context, this);
            return context.sites.Float.op_quo.call(context, fval, fval, other);
        }
        if (other instanceof RubyRational) {
            if (((RubyRational)other).isZero()) {
                throw context.runtime.newZeroDivisionError();
            }
            RubyRational otherRational = (RubyRational)other;
            return RubyRational.f_muldiv(context, this.getMetaClass(), this.num, this.den, otherRational.num, otherRational.den, false);
        }
        return this.coerceBin(context, RubyRational.sites((ThreadContext)context).op_quo, other);
    }

    public final RubyNumeric op_div(ThreadContext context, RubyInteger other) {
        if (other.isZero()) {
            throw context.runtime.newZeroDivisionError();
        }
        return RubyRational.f_muldiv(context, this.getMetaClass(), this.num, this.den, other, RubyFixnum.one(context.runtime), false);
    }

    @Override
    @JRubyMethod(name={"fdiv"})
    public IRubyObject fdiv(ThreadContext context, IRubyObject other) {
        return Numeric.f_div(context, RubyRational.r_to_f(context, this), other);
    }

    @JRubyMethod(name={"**"})
    public IRubyObject op_expt(ThreadContext context, IRubyObject other) {
        if (Numeric.k_exact_p(other) && Numeric.f_zero_p(context, other)) {
            return RubyRational.newRationalBang(context, this.getMetaClass(), 1L);
        }
        if (other instanceof RubyRational) {
            RubyRational otherRational = (RubyRational)other;
            if (otherRational.den.isOne()) {
                other = otherRational.num;
            }
        }
        if (Numeric.k_numeric_p(other) && Numeric.k_exact_p(other) && this.den.isOne()) {
            if (this.num.isOne()) {
                return RubyRational.newRationalBang(context, this.getMetaClass(), 1L);
            }
            if (Numeric.f_minus_one_p(context, this.num) && Numeric.k_integer_p(other)) {
                return RubyRational.newRationalBang(context, this.getMetaClass(), Numeric.f_odd_p(context, other) ? -1L : 1L);
            }
            if (Numeric.f_zero_p(context, this.num)) {
                if (Numeric.f_negative_p(context, other)) {
                    throw context.runtime.newZeroDivisionError();
                }
                return RubyRational.newRationalBang(context, this.getMetaClass(), 0L);
            }
        }
        if (other instanceof RubyInteger) {
            return this.fix_expt(context, (RubyInteger)other, ((RubyInteger)other).signum());
        }
        if (other instanceof RubyFloat || other instanceof RubyRational) {
            return Numeric.f_expt(context, RubyRational.r_to_f(context, this), other);
        }
        return this.coerceBin(context, RubyRational.sites((ThreadContext)context).op_exp, other);
    }

    public final IRubyObject op_expt(ThreadContext context, long other) {
        Ruby runtime2 = context.runtime;
        if (other == 0L) {
            return RubyRational.newRationalBang(context, this.getMetaClass(), 1L);
        }
        if (this.den.isOne()) {
            if (this.num.isOne()) {
                return RubyRational.newRationalBang(context, this.getMetaClass(), 1L);
            }
            if (Numeric.f_minus_one_p(context, this.num)) {
                return RubyRational.newRationalBang(context, this.getMetaClass(), other % 2L != 0L ? -1L : 1L);
            }
            if (Numeric.f_zero_p(context, this.num)) {
                if (other < 0L) {
                    throw context.runtime.newZeroDivisionError();
                }
                return RubyRational.newRationalBang(context, this.getMetaClass(), 0L);
            }
        }
        return this.fix_expt(context, RubyFixnum.newFixnum(runtime2, other), Long.signum(other));
    }

    private RubyNumeric fix_expt(ThreadContext context, RubyInteger other, int sign2) {
        RubyInteger tden;
        RubyInteger tnum;
        if (sign2 > 0) {
            tnum = (RubyInteger)Numeric.f_expt(context, this.num, other);
            tden = (RubyInteger)Numeric.f_expt(context, this.den, other);
        } else if (sign2 < 0) {
            RubyInteger otherNeg = other.negate();
            tnum = (RubyInteger)Numeric.f_expt(context, this.den, otherNeg);
            tden = (RubyInteger)Numeric.f_expt(context, this.num, otherNeg);
        } else {
            tden = RubyFixnum.one(context.runtime);
            tnum = tden;
        }
        return RubyRational.newInstance(context, this.getMetaClass(), tnum, tden);
    }

    @Override
    @JRubyMethod(name={"<=>"})
    public IRubyObject op_cmp(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum || other instanceof RubyBignum) {
            if (this.den instanceof RubyFixnum && ((RubyFixnum)this.den).value == 1L) {
                return Numeric.f_cmp(context, (IRubyObject)this.num, other);
            }
            return Numeric.f_cmp(context, this, RubyRational.newRationalBang(context, this.getMetaClass(), other));
        }
        if (other instanceof RubyFloat) {
            return Numeric.f_cmp(context, RubyRational.r_to_f(context, this), other);
        }
        if (other instanceof RubyRational) {
            RubyInteger num2;
            RubyInteger num1;
            RubyRational otherRational = (RubyRational)other;
            if (this.num instanceof RubyFixnum && this.den instanceof RubyFixnum && otherRational.num instanceof RubyFixnum && otherRational.den instanceof RubyFixnum) {
                num1 = RubyRational.f_imul(context, ((RubyFixnum)this.num).value, ((RubyFixnum)otherRational.den).value);
                num2 = RubyRational.f_imul(context, ((RubyFixnum)otherRational.num).value, ((RubyFixnum)this.den).value);
            } else {
                num1 = Numeric.f_mul(context, this.num, otherRational.den);
                num2 = Numeric.f_mul(context, otherRational.num, this.den);
            }
            return Numeric.f_cmp(context, Numeric.f_sub(context, num1, num2), RubyFixnum.zero(context.runtime));
        }
        return this.coerceCmp(context, RubyRational.sites((ThreadContext)context).op_cmp, other);
    }

    @Override
    @JRubyMethod(name={"=="})
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum || other instanceof RubyBignum) {
            return this.op_equal(context, (RubyInteger)other);
        }
        if (other instanceof RubyFloat) {
            return Numeric.f_equal(context, RubyRational.r_to_f(context, this), other);
        }
        if (other instanceof RubyRational) {
            return this.op_equal(context, (RubyRational)other);
        }
        return Numeric.f_equal(context, other, this);
    }

    public final IRubyObject op_equal(ThreadContext context, RubyInteger other) {
        if (this.num.isZero()) {
            return context.runtime.newBoolean(other.isZero());
        }
        if (!(this.den instanceof RubyFixnum) || this.den.getLongValue() != 1L) {
            return context.fals;
        }
        return Numeric.f_equal(context, this.num, other);
    }

    final RubyBoolean op_equal(ThreadContext context, RubyRational other) {
        if (this.num.isZero()) {
            return context.runtime.newBoolean(other.num.isZero());
        }
        return context.runtime.newBoolean(Numeric.f_equal(context, this.num, other.num).isTrue() && Numeric.f_equal(context, this.den, other.den).isTrue());
    }

    @Override
    public IRubyObject eql_p(ThreadContext context, IRubyObject other) {
        if (!(other instanceof RubyRational)) {
            return context.fals;
        }
        return this.op_equal(context, (RubyRational)other);
    }

    @JRubyMethod(name={"coerce"})
    public IRubyObject op_coerce(ThreadContext context, IRubyObject other) {
        Ruby runtime2 = context.runtime;
        if (other instanceof RubyFixnum || other instanceof RubyBignum) {
            return runtime2.newArray((IRubyObject)RubyRational.newRationalBang(context, this.getMetaClass(), other), (IRubyObject)this);
        }
        if (other instanceof RubyFloat) {
            return runtime2.newArray(other, RubyRational.r_to_f(context, this));
        }
        if (other instanceof RubyRational) {
            return runtime2.newArray(other, (IRubyObject)this);
        }
        if (other instanceof RubyComplex) {
            RubyComplex otherComplex = (RubyComplex)other;
            if (Numeric.k_exact_p(otherComplex.getImage()) && Numeric.f_zero_p(context, otherComplex.getImage())) {
                return runtime2.newArray((IRubyObject)RubyRational.newRationalBang(context, this.getMetaClass(), otherComplex.getReal()), (IRubyObject)this);
            }
            return runtime2.newArray(other, RubyComplex.newComplexCanonicalize(context, this));
        }
        throw runtime2.newTypeError(other.getMetaClass() + " can't be coerced into " + this.getMetaClass());
    }

    @Override
    public IRubyObject idiv(ThreadContext context, IRubyObject other) {
        if (RubyRational.num2dbl(context, other) == 0.0) {
            throw context.runtime.newZeroDivisionError();
        }
        return Numeric.f_floor(context, Numeric.f_div(context, this, other));
    }

    public IRubyObject op_mod(ThreadContext context, IRubyObject other) {
        if (RubyRational.num2dbl(context, other) == 0.0) {
            throw context.runtime.newZeroDivisionError();
        }
        return Numeric.f_sub(context, this, Numeric.f_mul(context, other, Numeric.f_floor(context, Numeric.f_div(context, this, other))));
    }

    @Deprecated
    public IRubyObject op_mod19(ThreadContext context, IRubyObject other) {
        return this.op_mod(context, other);
    }

    @JRubyMethod(name={"divmod"})
    public IRubyObject op_divmod(ThreadContext context, IRubyObject other) {
        if (RubyRational.num2dbl(context, other) == 0.0) {
            throw context.runtime.newZeroDivisionError();
        }
        IRubyObject val = Numeric.f_floor(context, Numeric.f_div(context, this, other));
        return context.runtime.newArray(val, Numeric.f_sub(context, this, Numeric.f_mul(context, other, val)));
    }

    @Deprecated
    public IRubyObject op_divmod19(ThreadContext context, IRubyObject other) {
        return this.op_divmod(context, other);
    }

    @JRubyMethod(name={"remainder"})
    public IRubyObject op_rem(ThreadContext context, IRubyObject other) {
        IRubyObject val = Numeric.f_truncate(context, Numeric.f_div(context, this, other));
        return Numeric.f_sub(context, this, Numeric.f_mul(context, other, val));
    }

    @JRubyMethod(name={"abs"})
    public IRubyObject op_abs(ThreadContext context) {
        if (!Numeric.f_negative_p(context, this)) {
            return this;
        }
        return Numeric.f_negate(context, this);
    }

    @Override
    @JRubyMethod(name={"floor"})
    public IRubyObject floor(ThreadContext context) {
        return this.roundCommon(context, context.nil, RoundingMode.FLOOR);
    }

    @JRubyMethod(name={"floor"})
    public IRubyObject floor(ThreadContext context, IRubyObject n) {
        return this.roundCommon(context, n, RoundingMode.FLOOR);
    }

    private IRubyObject mriFloor(ThreadContext context) {
        return this.num.idiv(context, this.den);
    }

    @Override
    @JRubyMethod(name={"ceil"})
    public IRubyObject ceil(ThreadContext context) {
        return this.roundCommon(context, context.nil, RoundingMode.CEILING);
    }

    @JRubyMethod(name={"ceil"})
    public IRubyObject ceil(ThreadContext context, IRubyObject n) {
        return this.roundCommon(context, n, RoundingMode.CEILING);
    }

    private IRubyObject mriCeil(ThreadContext context) {
        return ((RubyInteger)((RubyInteger)this.num.op_uminus(context)).idiv(context, this.den)).op_uminus(context);
    }

    @Override
    public RubyInteger convertToInteger() {
        return this.mriTruncate(this.getRuntime().getCurrentContext());
    }

    @JRubyMethod(name={"to_i"})
    public IRubyObject to_i(ThreadContext context) {
        return this.mriTruncate(context);
    }

    @Override
    public long getLongValue() {
        return this.convertToInteger().getLongValue();
    }

    @Override
    public BigInteger getBigIntegerValue() {
        return this.convertToInteger().getBigIntegerValue();
    }

    @Override
    @JRubyMethod(name={"truncate"})
    public IRubyObject truncate(ThreadContext context) {
        return this.roundCommon(context, context.nil, RoundingMode.UNNECESSARY);
    }

    @JRubyMethod(name={"truncate"})
    public IRubyObject truncate(ThreadContext context, IRubyObject n) {
        return this.roundCommon(context, n, RoundingMode.UNNECESSARY);
    }

    private RubyInteger mriTruncate(ThreadContext context) {
        if (this.num.isNegative()) {
            return ((RubyInteger)this.num.negate().idiv(context, this.den)).negate();
        }
        return (RubyInteger)this.num.idiv(context, this.den);
    }

    @Override
    @JRubyMethod(name={"round"})
    public IRubyObject round(ThreadContext context) {
        return this.roundCommon(context, context.nil, RoundingMode.HALF_UP);
    }

    @JRubyMethod(name={"round"})
    public IRubyObject round(ThreadContext context, IRubyObject n) {
        IRubyObject opts = ArgsUtil.getOptionsArg(context.runtime, n);
        if (opts != context.nil) {
            n = context.nil;
        }
        RoundingMode mode2 = RubyNumeric.getRoundingMode(context, opts);
        return this.roundCommon(context, n, mode2);
    }

    @JRubyMethod(name={"round"})
    public IRubyObject round(ThreadContext context, IRubyObject n, IRubyObject opts) {
        Ruby runtime2 = context.runtime;
        if (!(opts = ArgsUtil.getOptionsArg(runtime2, opts)).isNil()) {
            n = context.nil;
        }
        RoundingMode mode2 = RubyNumeric.getRoundingMode(context, opts);
        return this.roundCommon(context, n, mode2);
    }

    private IRubyObject roundCommon(ThreadContext context, IRubyObject n, RoundingMode mode2) {
        if (n == context.nil) {
            return this.doRound(context, mode2);
        }
        Ruby runtime2 = context.runtime;
        if (!(n instanceof RubyInteger)) {
            throw runtime2.newTypeError(n, runtime2.getInteger());
        }
        int nsign = ((RubyInteger)n).signum();
        RubyNumeric b2 = Numeric.f_expt(context, runtime2.newFixnum(10), (RubyInteger)n);
        IRubyObject s2 = nsign >= 0 ? this.op_mul(context, (RubyInteger)b2) : this.op_mul(context, b2);
        if (s2 instanceof RubyFloat) {
            if (nsign < 0) {
                return RubyFixnum.zero(runtime2);
            }
            return this;
        }
        if (!(s2 instanceof RubyRational)) {
            s2 = RubyRational.newRationalBang(context, this.getMetaClass(), s2);
        }
        s2 = ((RubyRational)s2).doRound(context, mode2);
        s2 = RubyRational.newRationalBang(context, this.getMetaClass(), (RubyInteger)s2);
        if ((s2 = ((RubyRational)s2).op_div(context, b2)) instanceof RubyRational && Numeric.f_cmp((ThreadContext)context, (RubyInteger)((RubyInteger)n), (long)1L).value < 0L) {
            s2 = ((RubyRational)s2).truncate(context);
        }
        return s2;
    }

    private IRubyObject doRound(ThreadContext context, RoundingMode mode2) {
        switch (mode2) {
            case HALF_UP: {
                return this.roundHalfUp(context);
            }
            case HALF_EVEN: {
                return this.roundHalfEven(context);
            }
            case HALF_DOWN: {
                return this.roundHalfDown(context);
            }
            case FLOOR: {
                return this.mriFloor(context);
            }
            case CEILING: {
                return this.mriCeil(context);
            }
            case UNNECESSARY: {
                return this.mriTruncate(context);
            }
        }
        throw context.runtime.newRuntimeError("BUG: invalid rounding mode: " + (Object)((Object)mode2));
    }

    private RubyInteger roundHalfDown(ThreadContext context) {
        RubyInteger num = this.num;
        RubyInteger den = this.den;
        boolean neg = num.isNegative();
        if (neg) {
            num = (RubyInteger)num.op_uminus(context);
        }
        num = (RubyInteger)((RubyInteger)num.op_mul(context, 2L)).op_plus(context, den);
        num = (RubyInteger)num.op_minus(context, 1L);
        den = (RubyInteger)den.op_mul(context, 2L);
        num = (RubyInteger)num.idiv(context, den);
        if (neg) {
            num = (RubyInteger)num.op_uminus(context);
        }
        return num;
    }

    private RubyInteger roundHalfEven(ThreadContext context) {
        RubyInteger num = this.num;
        RubyInteger den = this.den;
        boolean neg = num.isNegative();
        if (neg) {
            num = (RubyInteger)num.op_uminus(context);
        }
        num = (RubyInteger)((RubyInteger)num.op_mul(context, 2L)).op_plus(context, den);
        den = (RubyInteger)den.op_mul(context, 2L);
        RubyArray qr = (RubyArray)num.divmod(context, den);
        num = (RubyInteger)qr.eltOk(0L);
        if (((RubyInteger)qr.eltOk(1L)).isZero()) {
            num = (RubyInteger)num.op_and(context, RubyFixnum.newFixnum(context.runtime, -2L));
        }
        if (neg) {
            num = (RubyInteger)num.op_uminus(context);
        }
        return num;
    }

    private RubyInteger roundHalfUp(ThreadContext context) {
        RubyInteger num = this.num;
        RubyInteger den = this.den;
        boolean neg = num.isNegative();
        if (neg) {
            num = (RubyInteger)num.op_uminus(context);
        }
        num = (RubyInteger)((RubyInteger)num.op_mul(context, 2L)).op_plus(context, den);
        den = (RubyInteger)den.op_mul(context, 2L);
        num = (RubyInteger)num.idiv(context, den);
        if (neg) {
            num = (RubyInteger)num.op_uminus(context);
        }
        return num;
    }

    @JRubyMethod(name={"to_f"})
    public IRubyObject to_f(ThreadContext context) {
        return context.runtime.newFloat(this.getDoubleValue(context));
    }

    @Override
    public double getDoubleValue() {
        return this.getDoubleValue(this.getRuntime().getCurrentContext());
    }

    public double getDoubleValue(ThreadContext context) {
        long e;
        if (Numeric.f_zero_p(context, this.num)) {
            return 0.0;
        }
        RubyInteger myNum = this.num;
        RubyInteger myDen = this.den;
        boolean minus = false;
        if (Numeric.f_negative_p(context, myNum)) {
            myNum = Numeric.f_negate(context, myNum);
            minus = true;
        }
        long nl = Numeric.i_ilog2(context, myNum);
        long dl = Numeric.i_ilog2(context, myDen);
        long ne = 0L;
        if (nl > ML) {
            ne = nl - ML;
            myNum = myNum.op_rshift(context, ne);
        }
        long de = 0L;
        if (dl > ML) {
            de = dl - ML;
            myDen = myDen.op_rshift(context, de);
        }
        if ((e = ne - de) > 1023L || e < -1022L) {
            context.runtime.getWarnings().warn(IRubyWarnings.ID.FLOAT_OUT_OF_RANGE, "out of Float range");
            return e > 0L ? Double.MAX_VALUE : 0.0;
        }
        double f = RubyNumeric.num2dbl(context, myNum) / RubyNumeric.num2dbl(context, myDen);
        if (minus) {
            f = -f;
        }
        if (Double.isInfinite(f = Numeric.ldexp(f, e)) || Double.isNaN(f)) {
            context.runtime.getWarnings().warn(IRubyWarnings.ID.FLOAT_OUT_OF_RANGE, "out of Float range");
        }
        return f;
    }

    @JRubyMethod(name={"to_r"})
    public IRubyObject to_r(ThreadContext context) {
        return this;
    }

    @JRubyMethod(name={"rationalize"}, optional=1)
    public IRubyObject rationalize(ThreadContext context, IRubyObject[] args2) {
        IRubyObject b2;
        if (args2.length == 0) {
            return this.to_r(context);
        }
        if (Numeric.f_negative_p(context, this)) {
            return Numeric.f_negate(context, ((RubyRational)Numeric.f_abs(context, this)).rationalize(context, args2));
        }
        IRubyObject eps = Numeric.f_abs(context, args2[0]);
        IRubyObject a = Numeric.f_sub(context, this, eps);
        if (Numeric.f_equal(context, a, b2 = Numeric.f_add(context, this, eps)).isTrue()) {
            return this;
        }
        IRubyObject[] ans = Numeric.nurat_rationalize_internal(context, a, b2);
        return RubyRational.newInstance(context, this.metaClass, (RubyInteger)ans[0], (RubyInteger)ans[1]);
    }

    @JRubyMethod(name={"hash"})
    public IRubyObject hash(ThreadContext context) {
        return Numeric.f_xor(context, (RubyInteger)Helpers.invokedynamic(context, (IRubyObject)this.num, MethodNames.HASH), (RubyInteger)Helpers.invokedynamic(context, (IRubyObject)this.den, MethodNames.HASH));
    }

    @Override
    public int hashCode() {
        return this.num.hashCode() ^ this.den.hashCode();
    }

    @Override
    public IRubyObject to_s() {
        return this.to_s(this.getRuntime());
    }

    @JRubyMethod(name={"to_s"})
    public RubyString to_s(ThreadContext context) {
        return this.to_s(context.runtime);
    }

    private RubyString to_s(Ruby runtime2) {
        RubyString str = RubyString.newString(runtime2, new ByteList(10), (Encoding)USASCIIEncoding.INSTANCE);
        str.append(this.num.to_s());
        str.cat((byte)47);
        str.append(this.den.to_s());
        return str;
    }

    @Override
    public IRubyObject inspect() {
        return this.inspectImpl(this.getRuntime());
    }

    @JRubyMethod(name={"inspect"})
    public RubyString inspect(ThreadContext context) {
        return this.inspectImpl(context.runtime);
    }

    private RubyString inspectImpl(Ruby runtime2) {
        RubyString str = RubyString.newString(runtime2, new ByteList(12), (Encoding)USASCIIEncoding.INSTANCE);
        str.cat((byte)40);
        str.append((RubyString)this.num.inspect());
        str.cat((byte)47);
        str.append((RubyString)this.den.inspect());
        str.cat((byte)41);
        return str;
    }

    @JRubyMethod(name={"marshal_dump"})
    public IRubyObject marshal_dump(ThreadContext context) {
        RubyArray dump2 = context.runtime.newArray((IRubyObject)this.num, (IRubyObject)this.den);
        if (this.hasVariables()) {
            dump2.syncVariables(this);
        }
        return dump2;
    }

    @JRubyMethod(name={"marshal_load"})
    public IRubyObject marshal_load(ThreadContext context, IRubyObject arg2) {
        IRubyObject den;
        RubyArray load2 = arg2.convertToArray();
        IRubyObject num = load2.size() > 0 ? load2.eltInternal(0) : context.nil;
        IRubyObject iRubyObject = den = load2.size() > 1 ? load2.eltInternal(1) : context.nil;
        if (den != context.nil && RubyRational.canonicalizeShouldNegate(context, den.convertToInteger())) {
            num = Numeric.f_negate(context, num);
            den = Numeric.f_negate(context, den);
        }
        this.num = (RubyInteger)num;
        this.den = (RubyInteger)den;
        if (load2.hasVariables()) {
            this.syncVariables(load2);
        }
        return this;
    }

    static IRubyObject[] str_to_r_internal(ThreadContext context, RubyString str) {
        Ruby runtime2 = context.runtime;
        IRubyObject nil = context.nil;
        ByteList bytes2 = str.getByteList();
        if (bytes2.getRealSize() == 0) {
            return new IRubyObject[]{nil, str};
        }
        IRubyObject m = RubyRegexp.newDummyRegexp(runtime2, Numeric.RationalPatterns.rat_pat).match_m(context, (IRubyObject)str, false);
        if (m != nil) {
            ByteList siBytes;
            RubyMatchData match2 = (RubyMatchData)m;
            IRubyObject si = match2.at(1);
            RubyString nu = (RubyString)match2.at(2);
            IRubyObject de = match2.at(3);
            IRubyObject re = match2.post_match(context);
            RubyArray a = nu.split(RubyRegexp.newDummyRegexp(runtime2, Numeric.RationalPatterns.an_e_pat), context, false);
            RubyString ifp = (RubyString)a.eltInternal(0);
            IRubyObject exp2 = a.size() != 2 ? nil : a.eltInternal(1);
            a = ifp.split(RubyRegexp.newDummyRegexp(runtime2, Numeric.RationalPatterns.a_dot_pat), context, false);
            Object ip2 = a.eltInternal(0);
            IRubyObject fp = a.size() != 2 ? nil : a.eltInternal(1);
            IRubyObject v = RubyRational.newRationalCanonicalize(context, (RubyInteger)Numeric.f_to_i(context, ip2));
            if (fp != nil) {
                int i2;
                bytes2 = fp.convertToString().getByteList();
                int count2 = 0;
                byte[] buf = bytes2.getUnsafeBytes();
                int end2 = i2 + bytes2.getRealSize();
                for (i2 = bytes2.getBegin(); i2 < end2; ++i2) {
                    if (!ASCIIEncoding.INSTANCE.isDigit((int)buf[i2])) continue;
                    ++count2;
                }
                RubyInteger l = (RubyInteger)RubyFixnum.newFixnum(runtime2, 10L).op_pow(context, count2);
                v = Numeric.f_mul(context, v, (IRubyObject)l);
                v = Numeric.f_add(context, v, Numeric.f_to_i(context, fp));
                v = Numeric.f_div(context, v, l);
            }
            if (si != nil && (siBytes = si.convertToString().getByteList()).length() > 0 && siBytes.get(0) == 45) {
                v = Numeric.f_negate(context, v);
            }
            if (exp2 != nil) {
                v = Numeric.f_mul(context, v, Numeric.f_expt(context, RubyFixnum.newFixnum(runtime2, 10L), (RubyInteger)Numeric.f_to_i(context, exp2)));
            }
            if (de != nil) {
                v = Numeric.f_div(context, v, Numeric.f_to_i(context, de));
            }
            return new IRubyObject[]{v, re};
        }
        return new IRubyObject[]{nil, str};
    }

    private static RubyNumeric str_to_r_strict(ThreadContext context, RubyString str) {
        IRubyObject[] ary = RubyRational.str_to_r_internal(context, str);
        if (ary[0] == context.nil || ary[1].convertToString().getByteList().length() > 0) {
            throw context.runtime.newArgumentError("invalid value for convert(): " + str.inspect(context.runtime));
        }
        return (RubyNumeric)ary[0];
    }

    public static IRubyObject numericQuo(ThreadContext context, IRubyObject x, IRubyObject y) {
        if (y instanceof RubyFloat) {
            return ((RubyNumeric)x).fdiv(context, y);
        }
        x = canonicalization ? RubyRational.newRationalRaw(context.runtime, x) : TypeConverter.convertToType(context, x, context.runtime.getRational(), RubyRational.sites((ThreadContext)context).to_r_checked);
        return RubyRational.sites((ThreadContext)context).op_quo.call(context, x, x, y);
    }

    @Deprecated
    public IRubyObject op_floor(ThreadContext context) {
        return this.floor(context);
    }

    @Deprecated
    public IRubyObject op_floor(ThreadContext context, IRubyObject n) {
        return this.floor(context, n);
    }

    @Deprecated
    public IRubyObject op_ceil(ThreadContext context) {
        return this.ceil(context);
    }

    @Deprecated
    public IRubyObject op_ceil(ThreadContext context, IRubyObject n) {
        return this.ceil(context, n);
    }

    @Deprecated
    public IRubyObject op_idiv19(ThreadContext context, IRubyObject other) {
        return this.idiv(context, other);
    }

    @Deprecated
    public IRubyObject op_idiv(ThreadContext context, IRubyObject other) {
        return this.idiv(context, other);
    }

    @Deprecated
    public IRubyObject op_fdiv(ThreadContext context, IRubyObject other) {
        return this.fdiv(context, other);
    }

    private static JavaSites.RationalSites sites(ThreadContext context) {
        return context.sites.Rational;
    }

    private static IRubyObject r_to_f(ThreadContext context, RubyRational r) {
        return RubyRational.sites((ThreadContext)context).to_f.call(context, r, r);
    }
}

