/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir;

import java.io.IOException;
import java.io.InputStream;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubySymbol;
import org.jruby.ast.DefNode;
import org.jruby.ast.IScopingNode;
import org.jruby.ast.ModuleNode;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.jruby.ir.IRClassBody;
import org.jruby.ir.IRFlags;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRModuleBody;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRScriptBody;
import org.jruby.ir.instructions.LineNumberInstr;
import org.jruby.ir.instructions.ReceiveSelfInstr;
import org.jruby.ir.instructions.ToggleBacktraceInstr;
import org.jruby.ir.listeners.IRScopeListener;
import org.jruby.ir.listeners.InstructionsListener;
import org.jruby.ir.operands.Boolean;
import org.jruby.ir.operands.Nil;
import org.jruby.ir.operands.Self;
import org.jruby.ir.operands.StandardError;
import org.jruby.ir.operands.TemporaryLocalVariable;
import org.jruby.ir.passes.BasicCompilerPassListener;
import org.jruby.ir.passes.CompilerPass;
import org.jruby.ir.passes.CompilerPassListener;
import org.jruby.ir.passes.CompilerPassScheduler;
import org.jruby.ir.passes.DeadCodeElimination;
import org.jruby.ir.passes.OptimizeDelegationPass;
import org.jruby.ir.passes.OptimizeDynScopesPass;
import org.jruby.ir.util.IGVInstrListener;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.FileResource;
import org.jruby.util.JRubyFile;
import org.jruby.util.cli.Options;

public class IRManager {
    public static final String SAFE_COMPILER_PASSES = "";
    public static final String DEFAULT_BUILD_PASSES = "";
    public static final String DEFAULT_JIT_PASSES = "LocalOptimizationPass,DeadCodeElimination,OptimizeDynScopesPass,OptimizeDelegationPass,AddCallProtocolInstructions,AddMissingInitsPass";
    public static final String DEFAULT_INLINING_COMPILER_PASSES = "LocalOptimizationPass";
    public static boolean IR_INLINER = (java.lang.Boolean)Options.IR_INLINER.load();
    public static int IR_INLINER_THRESHOLD = (Integer)Options.IR_INLINER_THRESHOLD.load();
    public static boolean IR_INLINER_VERBOSE = (java.lang.Boolean)Options.IR_INLINER_VERBOSE.load();
    private final CompilerPass deadCodeEliminationPass = new DeadCodeElimination();
    private final CompilerPass optimizeDynScopesPass = new OptimizeDynScopesPass();
    private final CompilerPass optimizeDelegationPass = new OptimizeDelegationPass();
    private static final ByteList OBJECT = new ByteList(new byte[]{79, 98, 106, 101, 99, 116});
    private int dummyMetaClassCount = 0;
    private final IRModuleBody object;
    private final Nil nil = new Nil();
    private final Boolean tru = new Boolean(true);
    private final Boolean fals = new Boolean(false);
    private final StandardError standardError = new StandardError();
    public final ToggleBacktraceInstr needsBacktrace = new ToggleBacktraceInstr(true);
    public final ToggleBacktraceInstr needsNoBacktrace = new ToggleBacktraceInstr(false);
    private Set<CompilerPassListener> passListeners = new HashSet<CompilerPassListener>();
    private CompilerPassListener defaultListener = new BasicCompilerPassListener();
    private InstructionsListener instrsListener = null;
    private IRScopeListener irScopeListener = null;
    private List<CompilerPass> compilerPasses;
    private List<CompilerPass> inliningCompilerPasses;
    private List<CompilerPass> jitPasses;
    private List<CompilerPass> safePasses;
    private final RubyInstanceConfig config;
    public final Ruby runtime;
    private boolean dryRun = false;
    private ReceiveSelfInstr receiveSelfInstr = new ReceiveSelfInstr(Self.SELF);
    private LineNumberInstr[] lineNumbers = new LineNumberInstr[3000];
    private TemporaryLocalVariable[] temporaryLocalVariables = new TemporaryLocalVariable[1600];

    public IRManager(Ruby runtime2, RubyInstanceConfig config) {
        this.runtime = runtime2;
        this.config = config;
        this.object = new IRClassBody(this, null, runtime2.newSymbol(OBJECT), 0, null);
        this.compilerPasses = CompilerPass.getPassesFromString(RubyInstanceConfig.IR_COMPILER_PASSES, "");
        this.inliningCompilerPasses = CompilerPass.getPassesFromString(RubyInstanceConfig.IR_COMPILER_PASSES, DEFAULT_INLINING_COMPILER_PASSES);
        this.jitPasses = CompilerPass.getPassesFromString(RubyInstanceConfig.IR_JIT_PASSES, DEFAULT_JIT_PASSES);
        this.safePasses = CompilerPass.getPassesFromString(null, "");
        if (RubyInstanceConfig.IR_DEBUG_IGV != null) {
            this.instrsListener = new IGVInstrListener();
        }
    }

    public Ruby getRuntime() {
        return this.runtime;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public void setDryRun(boolean value2) {
        this.dryRun = value2;
    }

    public Nil getNil() {
        return this.nil;
    }

    public StandardError getStandardError() {
        return this.standardError;
    }

    public Boolean getTrue() {
        return this.tru;
    }

    public Boolean getFalse() {
        return this.fals;
    }

    public IRModuleBody getObject() {
        return this.object;
    }

    public ToggleBacktraceInstr needsBacktrace(boolean needsIt) {
        return needsIt ? this.needsBacktrace : this.needsNoBacktrace;
    }

    public CompilerPassScheduler schedulePasses() {
        return IRManager.schedulePasses(this.compilerPasses);
    }

    public static CompilerPassScheduler schedulePasses(final List<CompilerPass> passes) {
        CompilerPassScheduler scheduler = new CompilerPassScheduler(){
            private Iterator<CompilerPass> iterator;
            {
                this.iterator = passes.iterator();
            }

            @Override
            public Iterator<CompilerPass> iterator() {
                return this.iterator;
            }
        };
        return scheduler;
    }

    public List<CompilerPass> getCompilerPasses(IRScope scope) {
        return this.compilerPasses;
    }

    public List<CompilerPass> getInliningCompilerPasses(IRScope scope) {
        return this.inliningCompilerPasses;
    }

    public List<CompilerPass> getJITPasses(IRScope scope) {
        return this.jitPasses;
    }

    public List<CompilerPass> getSafePasses(IRScope scope) {
        return this.safePasses;
    }

    public Set<CompilerPassListener> getListeners() {
        if (RubyInstanceConfig.IR_COMPILER_DEBUG) {
            this.addListener(this.defaultListener);
        } else {
            this.removeListener(this.defaultListener);
        }
        return this.passListeners;
    }

    public InstructionsListener getInstructionsListener() {
        return this.instrsListener;
    }

    public IRScopeListener getIRScopeListener() {
        return this.irScopeListener;
    }

    public void addListener(CompilerPassListener listener) {
        this.passListeners.add(listener);
    }

    public void removeListener(CompilerPassListener listener) {
        this.passListeners.remove(listener);
    }

    public void addListener(InstructionsListener listener) {
        if (RubyInstanceConfig.IR_COMPILER_DEBUG || RubyInstanceConfig.IR_VISUALIZER) {
            if (this.instrsListener != null) {
                throw new RuntimeException("InstructionsListener is set and other are currently not allowed");
            }
            this.instrsListener = listener;
        }
    }

    public void removeListener(InstructionsListener listener) {
        if (this.instrsListener.equals(listener)) {
            this.instrsListener = null;
        }
    }

    public void addListener(IRScopeListener listener) {
        if (RubyInstanceConfig.IR_COMPILER_DEBUG || RubyInstanceConfig.IR_VISUALIZER) {
            if (this.irScopeListener != null) {
                throw new RuntimeException("IRScopeListener is set and other are currently not allowed");
            }
            this.irScopeListener = listener;
        }
    }

    public LineNumberInstr newLineNumber(int line) {
        LineNumberInstr tempVar;
        if (line >= this.lineNumbers.length - 1) {
            this.growLineNumbersPool(line);
        }
        if (line < 0) {
            line = 0;
        }
        if ((tempVar = this.lineNumbers[line]) == null) {
            this.lineNumbers[line] = tempVar = new LineNumberInstr(line);
        }
        return tempVar;
    }

    public ReceiveSelfInstr getReceiveSelfInstr() {
        return this.receiveSelfInstr;
    }

    protected LineNumberInstr[] growLineNumbersPool(int index2) {
        int newLength = index2 * 2;
        LineNumberInstr[] newPool = new LineNumberInstr[newLength];
        System.arraycopy(this.lineNumbers, 0, newPool, 0, this.lineNumbers.length);
        this.lineNumbers = newPool;
        return newPool;
    }

    public void removeListener(IRScopeListener listener) {
        if (this.irScopeListener.equals(listener)) {
            this.irScopeListener = null;
        }
    }

    public RubySymbol getMetaClassName() {
        return this.runtime.newSymbol("<DUMMY_MC:" + this.dummyMetaClassCount++ + ">");
    }

    protected TemporaryLocalVariable[] growTemporaryVariablePool(int index2) {
        int newLength = index2 * 2;
        TemporaryLocalVariable[] newPool = new TemporaryLocalVariable[newLength];
        System.arraycopy(this.temporaryLocalVariables, 0, newPool, 0, this.temporaryLocalVariables.length);
        this.temporaryLocalVariables = newPool;
        return newPool;
    }

    public TemporaryLocalVariable newTemporaryLocalVariable(int index2) {
        TemporaryLocalVariable tempVar;
        if (index2 >= this.temporaryLocalVariables.length - 1) {
            this.growTemporaryVariablePool(index2);
        }
        if ((tempVar = this.temporaryLocalVariables[index2]) == null) {
            this.temporaryLocalVariables[index2] = tempVar = new TemporaryLocalVariable(index2);
        }
        return tempVar;
    }

    protected void optimizeIfSimpleScope(IRScope scope) {
        if (RubyInstanceConfig.IR_COMPILER_PASSES != null) {
            return;
        }
        EnumSet<IRFlags> flags2 = scope.getFlags();
        if (!scope.isUnsafeScope() && !flags2.contains((Object)IRFlags.REQUIRES_DYNSCOPE)) {
            if (flags2.contains((Object)IRFlags.RECEIVES_CLOSURE_ARG)) {
                this.optimizeDelegationPass.run(scope);
            }
            this.deadCodeEliminationPass.run(scope);
            this.optimizeDynScopesPass.run(scope);
        }
    }

    public RubyInstanceConfig getInstanceConfig() {
        return this.config;
    }

    public IRMethod loadInternalMethod(ThreadContext context, IRubyObject self2, String method2) {
        try {
            RubyClass type2 = self2.getMetaClass();
            String fileName = "classpath:/jruby/ruby_implementations/" + type2 + "/" + method2 + ".rb";
            FileResource file2 = JRubyFile.createResourceAsFile(context.runtime, fileName);
            Node parseResult = this.parse(context, file2, fileName);
            IScopingNode scopeNode = (IScopingNode)((Object)parseResult.childNodes().get(0));
            scopeNode.getScope().setModule(type2);
            DefNode defNode = (DefNode)((Object)scopeNode.getBodyNode());
            IRScriptBody script = new IRScriptBody(this, this.runtime.newSymbol(parseResult.getFile()), ((RootNode)parseResult).getStaticScope());
            IRModuleBody containingScope = scopeNode instanceof ModuleNode ? new IRModuleBody(this, script, scopeNode.getCPath().getName(), 0, scopeNode.getScope()) : new IRClassBody(this, script, scopeNode.getCPath().getName(), 0, scopeNode.getScope());
            IRMethod newMethod = new IRMethod(this, containingScope, defNode, context.runtime.newSymbol(method2), true, 0, defNode.getScope(), false);
            newMethod.prepareForCompilation();
            return newMethod;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Node parse(ThreadContext context, FileResource file2, String fileName) throws IOException {
        try (InputStream stream = file2.openInputStream();){
            Node node = context.runtime.parseFile(stream, fileName, null, 0);
            return node;
        }
    }
}

