/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.targets;

import com.headius.invokebinder.Binder;
import com.headius.invokebinder.Signature;
import com.headius.invokebinder.SmartBinder;
import com.headius.invokebinder.SmartHandle;
import java.lang.invoke.CallSite;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.MutableCallSite;
import java.lang.invoke.SwitchPoint;
import java.lang.invoke.TypeDescriptor;
import java.math.BigInteger;
import org.jcodings.Encoding;
import org.jcodings.EncodingDB;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyEncoding;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyGlobal;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyNil;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.internal.runtime.GlobalVariable;
import org.jruby.internal.runtime.methods.AttrReaderMethod;
import org.jruby.internal.runtime.methods.AttrWriterMethod;
import org.jruby.internal.runtime.methods.CompiledIRMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.HandleMethod;
import org.jruby.internal.runtime.methods.MixedModeIRMethod;
import org.jruby.internal.runtime.methods.NativeCallMethod;
import org.jruby.ir.IRScope;
import org.jruby.ir.JIT;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.targets.InvokeSite;
import org.jruby.ir.targets.SuperInvokeSite;
import org.jruby.java.invokers.SingletonMethodInvoker;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.proxy.InternalJavaProxy;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.CompiledIRBlockBody;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.invokedynamic.GlobalSite;
import org.jruby.runtime.invokedynamic.InvocationLinker;
import org.jruby.runtime.invokedynamic.InvokeDynamicSupport;
import org.jruby.runtime.invokedynamic.MathLinker;
import org.jruby.runtime.ivars.FieldVariableAccessor;
import org.jruby.runtime.ivars.VariableAccessor;
import org.jruby.runtime.opto.Invalidator;
import org.jruby.runtime.opto.OptoFactory;
import org.jruby.util.ByteList;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JavaNameMangler;
import org.jruby.util.cli.Options;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;
import org.objectweb.asm.Handle;

public class Bootstrap {
    public static final String BOOTSTRAP_BARE_SIG = CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class);
    public static final String BOOTSTRAP_LONG_STRING_INT_SIG = CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, Long.TYPE, Integer.TYPE, String.class, Integer.TYPE);
    public static final String BOOTSTRAP_DOUBLE_STRING_INT_SIG = CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, Double.TYPE, Integer.TYPE, String.class, Integer.TYPE);
    private static final Logger LOG = LoggerFactory.getLogger(Bootstrap.class);
    static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final Signature STRING_SIGNATURE = Signature.from(RubyString.class, (Class[])Helpers.arrayOf(ThreadContext.class), (String[])new String[]{"context"});
    private static final Signature NEW_STRING_SHARED_SIGNATURE = Signature.from(RubyString.class, (Class[])Helpers.arrayOf(ThreadContext.class, ByteList.class), (String[])new String[]{"context", "byteList"});
    private static final SmartHandle NEW_STRING_SHARED_HANDLE = SmartBinder.from((Signature)NEW_STRING_SHARED_SIGNATURE).invokeStaticQuiet(MethodHandles.lookup(), Bootstrap.class, "newStringShared");
    private static final MethodHandle IS_JAVA_SUBCLASS = InvokeDynamicSupport.findStatic(Bootstrap.class, "subclassProxyTest", MethodType.methodType(Boolean.TYPE, Object.class));
    private static final Binder BINDING_MAKER_BINDER = Binder.from(Binding.class, ThreadContext.class, (Class[])new Class[]{IRubyObject.class, DynamicScope.class});
    private static final MethodHandle FRAME_SCOPE_BINDING = BINDING_MAKER_BINDER.invokeStaticQuiet(LOOKUP, Bootstrap.class, "frameScopeBinding");
    private static final MethodHandle FRAME_BINDING = BINDING_MAKER_BINDER.invokeStaticQuiet(LOOKUP, Bootstrap.class, "frameBinding");
    private static final MethodHandle SCOPE_BINDING = BINDING_MAKER_BINDER.invokeStaticQuiet(LOOKUP, Bootstrap.class, "scopeBinding");
    private static final MethodHandle SELF_BINDING = BINDING_MAKER_BINDER.invokeStaticQuiet(LOOKUP, Bootstrap.class, "selfBinding");
    private static final MethodHandle CONSTRUCT_BLOCK = Binder.from(Block.class, Binding.class, (Class[])new Class[]{CompiledIRBlockBody.class}).invokeStaticQuiet(LOOKUP, Bootstrap.class, "constructBlock");

    public static CallSite string(MethodHandles.Lookup lookup, String name2, MethodType type2, String value2, String encodingName, int cr) {
        MutableCallSite site = new MutableCallSite(type2);
        Binder binder = Binder.from(RubyString.class, ThreadContext.class, (Class[])new Class[0]).insert(0, Helpers.arrayOf(MutableCallSite.class, ByteList.class, Integer.TYPE), new Object[]{site, Bootstrap.bytelist(value2, encodingName), cr});
        site.setTarget(binder.invokeStaticQuiet(lookup, Bootstrap.class, "string"));
        return site;
    }

    public static CallSite fstring(MethodHandles.Lookup lookup, String name2, MethodType type2, String value2, String encodingName, int cr, String file2, int line) {
        MutableCallSite site = new MutableCallSite(type2);
        Binder binder = Binder.from(RubyString.class, ThreadContext.class, (Class[])new Class[0]).insert(0, Helpers.arrayOf(MutableCallSite.class, ByteList.class, Integer.TYPE, String.class, Integer.TYPE), new Object[]{site, Bootstrap.bytelist(value2, encodingName), cr, file2, line});
        site.setTarget(binder.invokeStaticQuiet(lookup, Bootstrap.class, "frozenString"));
        return site;
    }

    public static Handle isNilBoot() {
        return new Handle(6, CodegenUtils.p(Bootstrap.class), "isNil", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class), false);
    }

    public static CallSite isNil(MethodHandles.Lookup lookup, String name2, MethodType type2) {
        return new IsNilSite();
    }

    public static Handle isTrueBoot() {
        return new Handle(6, CodegenUtils.p(Bootstrap.class), "isTrue", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class), false);
    }

    public static CallSite isTrue(MethodHandles.Lookup lookup, String name2, MethodType type2) {
        return new IsTrueSite();
    }

    public static CallSite bytelist(MethodHandles.Lookup lookup, String name2, MethodType type2, String value2, String encodingName) {
        return new ConstantCallSite(MethodHandles.constant(ByteList.class, Bootstrap.bytelist(value2, encodingName)));
    }

    private static ByteList bytelist(String value2, String encodingName) {
        EncodingDB.Entry entry = (EncodingDB.Entry)EncodingDB.getEncodings().get(encodingName.getBytes());
        if (entry == null) {
            entry = (EncodingDB.Entry)EncodingDB.getAliases().get(encodingName.getBytes());
        }
        if (entry == null) {
            throw new RuntimeException("could not find encoding: " + encodingName);
        }
        Encoding encoding2 = entry.getEncoding();
        ByteList byteList = new ByteList(value2.getBytes(RubyEncoding.ISO), encoding2);
        return byteList;
    }

    public static CallSite array(MethodHandles.Lookup lookup, String name2, MethodType type2) {
        MethodHandle handle = Binder.from((MethodType)type2).collect(1, IRubyObject[].class).invokeStaticQuiet(LOOKUP, Bootstrap.class, "array");
        ConstantCallSite site = new ConstantCallSite(handle);
        return site;
    }

    public static CallSite hash(MethodHandles.Lookup lookup, String name2, MethodType type2) {
        MethodHandle handle = Binder.from((MethodHandles.Lookup)lookup, (MethodType)type2).collect(1, IRubyObject[].class).invokeStaticQuiet(LOOKUP, Bootstrap.class, "hash");
        ConstantCallSite site = new ConstantCallSite(handle);
        return site;
    }

    public static CallSite kwargsHash(MethodHandles.Lookup lookup, String name2, MethodType type2) {
        MethodHandle handle = Binder.from((MethodHandles.Lookup)lookup, (MethodType)type2).collect(2, IRubyObject[].class).invokeStaticQuiet(LOOKUP, Bootstrap.class, "kwargsHash");
        ConstantCallSite site = new ConstantCallSite(handle);
        return site;
    }

    public static Handle string() {
        return new Handle(6, CodegenUtils.p(Bootstrap.class), "string", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, String.class, String.class, Integer.TYPE), false);
    }

    public static Handle fstring() {
        return new Handle(6, CodegenUtils.p(Bootstrap.class), "fstring", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, String.class, String.class, Integer.TYPE, String.class, Integer.TYPE), false);
    }

    public static Handle bytelist() {
        return new Handle(6, CodegenUtils.p(Bootstrap.class), "bytelist", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, String.class, String.class), false);
    }

    public static Handle array() {
        return new Handle(6, CodegenUtils.p(Bootstrap.class), "array", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class), false);
    }

    public static Handle hash() {
        return new Handle(6, CodegenUtils.p(Bootstrap.class), "hash", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class), false);
    }

    public static Handle kwargsHash() {
        return new Handle(6, CodegenUtils.p(Bootstrap.class), "kwargsHash", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class), false);
    }

    public static Handle invokeSuper() {
        return SuperInvokeSite.BOOTSTRAP;
    }

    public static Handle global() {
        return new Handle(6, CodegenUtils.p(Bootstrap.class), "globalBootstrap", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, String.class, Integer.TYPE), false);
    }

    public static RubyString string(MutableCallSite site, ByteList value2, int cr, ThreadContext context) throws Throwable {
        MethodHandle handle = SmartBinder.from((Signature)STRING_SIGNATURE).invoke(NEW_STRING_SHARED_HANDLE.apply("byteList", (Object)value2)).handle();
        site.setTarget(handle);
        return RubyString.newStringShared(context.runtime, value2, cr);
    }

    public static RubyString frozenString(MutableCallSite site, ByteList value2, int cr, String file2, int line, ThreadContext context) throws Throwable {
        RubyString frozen = IRRuntimeHelpers.newFrozenString(context, value2, cr, file2, line);
        MethodHandle handle = Binder.from(RubyString.class, ThreadContext.class, (Class[])new Class[0]).dropAll().constant((Object)frozen);
        site.setTarget(handle);
        return frozen;
    }

    @JIT
    private static RubyString newStringShared(ThreadContext context, ByteList byteList) {
        return RubyString.newStringShared(context.runtime, byteList);
    }

    public static IRubyObject array(ThreadContext context, IRubyObject[] ary) {
        assert (ary.length > 2);
        return RubyArray.newArrayNoCopy(context.runtime, ary);
    }

    public static Handle contextValue() {
        return new Handle(6, CodegenUtils.p(Bootstrap.class), "contextValue", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class), false);
    }

    public static Handle contextValueString() {
        return new Handle(6, CodegenUtils.p(Bootstrap.class), "contextValueString", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, String.class), false);
    }

    public static CallSite contextValue(MethodHandles.Lookup lookup, String name2, MethodType type2) {
        MutableCallSite site = new MutableCallSite(type2);
        site.setTarget(Binder.from((MethodType)type2).append(new Object[]{site}).invokeStaticQuiet(lookup, Bootstrap.class, name2));
        return site;
    }

    public static CallSite contextValueString(MethodHandles.Lookup lookup, String name2, MethodType type2, String str) {
        MutableCallSite site = new MutableCallSite(type2);
        site.setTarget(Binder.from((MethodType)type2).append(new Object[]{site, str}).invokeStaticQuiet(lookup, Bootstrap.class, name2));
        return site;
    }

    public static IRubyObject nil(ThreadContext context, MutableCallSite site) {
        MethodHandle constant = (MethodHandle)((RubyNil)context.nil).constant();
        if (constant == null) {
            constant = (MethodHandle)OptoFactory.newConstantWrapper(IRubyObject.class, context.nil);
        }
        site.setTarget(constant);
        return context.nil;
    }

    public static IRubyObject True(ThreadContext context, MutableCallSite site) {
        MethodHandle constant = (MethodHandle)context.tru.constant();
        if (constant == null) {
            constant = (MethodHandle)OptoFactory.newConstantWrapper(IRubyObject.class, context.tru);
        }
        site.setTarget(constant);
        return context.tru;
    }

    public static IRubyObject False(ThreadContext context, MutableCallSite site) {
        MethodHandle constant = (MethodHandle)context.fals.constant();
        if (constant == null) {
            constant = (MethodHandle)OptoFactory.newConstantWrapper(IRubyObject.class, context.fals);
        }
        site.setTarget(constant);
        return context.fals;
    }

    public static Ruby runtime(ThreadContext context, MutableCallSite site) {
        MethodHandle constant = (MethodHandle)context.runtime.constant();
        if (constant == null) {
            constant = (MethodHandle)OptoFactory.newConstantWrapper(Ruby.class, context.runtime);
        }
        site.setTarget(constant);
        return context.runtime;
    }

    public static RubyEncoding encoding(ThreadContext context, MutableCallSite site, String name2) {
        RubyEncoding rubyEncoding = IRRuntimeHelpers.retrieveEncoding(context, name2);
        MethodHandle constant = (MethodHandle)rubyEncoding.constant();
        if (constant == null) {
            constant = (MethodHandle)OptoFactory.newConstantWrapper(RubyEncoding.class, rubyEncoding);
        }
        site.setTarget(constant);
        return rubyEncoding;
    }

    public static IRubyObject hash(ThreadContext context, IRubyObject[] pairs) {
        Ruby runtime2 = context.runtime;
        RubyHash hash2 = new RubyHash(runtime2, pairs.length / 2 + 1);
        int i2 = 0;
        while (i2 < pairs.length) {
            hash2.fastASetCheckString(runtime2, pairs[i2++], pairs[i2++]);
        }
        return hash2;
    }

    public static IRubyObject kwargsHash(ThreadContext context, RubyHash hash2, IRubyObject[] pairs) {
        return IRRuntimeHelpers.dupKwargsHashAndPopulateFromArray(context, hash2, pairs);
    }

    static MethodHandle buildIndyHandle(InvokeSite site, DynamicMethod method2, RubyModule implClass) {
        MethodHandle mh = null;
        Signature siteToDyncall = site.signature.insertArgs(3, Helpers.arrayOf("class", "name"), Helpers.arrayOf(RubyModule.class, String.class));
        if (method2 instanceof HandleMethod) {
            boolean blockGiven;
            HandleMethod handleMethod = (HandleMethod)method2;
            boolean bl = blockGiven = site.signature.lastArgType() == Block.class;
            if (site.arity >= 0) {
                mh = handleMethod.getHandle(site.arity);
                if (mh != null) {
                    if (!blockGiven) {
                        mh = MethodHandles.insertArguments(mh, mh.type().parameterCount() - 1, Block.NULL_BLOCK);
                    }
                    mh = MethodHandles.dropArguments(mh, 1, new Class[]{IRubyObject.class});
                } else {
                    mh = handleMethod.getHandle(-1);
                    mh = MethodHandles.dropArguments(mh, 1, new Class[]{IRubyObject.class});
                    if (site.arity == 0) {
                        mh = !blockGiven ? MethodHandles.insertArguments(mh, mh.type().parameterCount() - 2, IRubyObject.NULL_ARRAY, Block.NULL_BLOCK) : MethodHandles.insertArguments(mh, mh.type().parameterCount() - 2, new Object[]{IRubyObject.NULL_ARRAY});
                    } else {
                        if (!blockGiven) {
                            mh = MethodHandles.insertArguments(mh, mh.type().parameterCount() - 1, Block.NULL_BLOCK);
                        }
                        mh = SmartBinder.from((MethodHandles.Lookup)MethodHandles.lookup(), (Signature)siteToDyncall).collect("args", "arg.*").invoke(mh).handle();
                    }
                }
            } else {
                mh = handleMethod.getHandle(-1);
                if (mh != null) {
                    mh = MethodHandles.dropArguments(mh, 1, new Class[]{IRubyObject.class});
                    if (!blockGiven) {
                        mh = MethodHandles.insertArguments(mh, mh.type().parameterCount() - 1, Block.NULL_BLOCK);
                    }
                    mh = SmartBinder.from((MethodHandles.Lookup)MethodHandles.lookup(), (Signature)siteToDyncall).invoke(mh).handle();
                }
            }
            if (mh != null) {
                mh = MethodHandles.insertArguments(mh, 3, implClass, site.name());
                if (((Boolean)Options.INVOKEDYNAMIC_LOG_BINDING.load()).booleanValue()) {
                    LOG.info(site.name() + "\tbound directly to handle " + Bootstrap.logMethod(method2), new Object[0]);
                }
            }
        }
        return mh;
    }

    static MethodHandle buildGenericHandle(InvokeSite site, DynamicMethod method2, RubyClass dispatchClass) {
        SmartBinder binder = SmartBinder.from((Signature)site.signature).permute(new String[]{"context", "self", "arg.*", "block"}).insert(2, new String[]{"rubyClass", "name"}, new Class[]{RubyModule.class, String.class}, new Object[]{dispatchClass, site.name()}).insert(0, "method", DynamicMethod.class, (Object)method2);
        if (site.arity > 3) {
            binder = binder.collect("args", "arg.*");
        }
        if (((Boolean)Options.INVOKEDYNAMIC_LOG_BINDING.load()).booleanValue()) {
            LOG.info(site.name() + "\tbound indirectly " + method2 + ", " + Bootstrap.logMethod(method2), new Object[0]);
        }
        return binder.invokeVirtualQuiet(LOOKUP, "call").handle();
    }

    static MethodHandle buildAttrHandle(InvokeSite site, DynamicMethod method2, IRubyObject self2, RubyClass dispatchClass) {
        if (method2 instanceof AttrReaderMethod && site.arity == 0) {
            AttrReaderMethod attrReader = (AttrReaderMethod)method2;
            String varName = attrReader.getVariableName();
            VariableAccessor accessor = dispatchClass.getRealClass().getVariableAccessorForWrite(varName);
            if (((Boolean)Options.INVOKEDYNAMIC_LOG_BINDING.load()).booleanValue()) {
                if (accessor instanceof FieldVariableAccessor) {
                    LOG.info(site.name() + "\tbound as field attr reader " + Bootstrap.logMethod(method2) + ":" + ((AttrReaderMethod)method2).getVariableName(), new Object[0]);
                } else {
                    LOG.info(site.name() + "\tbound as attr reader " + Bootstrap.logMethod(method2) + ":" + ((AttrReaderMethod)method2).getVariableName(), new Object[0]);
                }
            }
            return Bootstrap.createAttrReaderHandle(site, self2, dispatchClass.getRealClass(), accessor);
        }
        if (method2 instanceof AttrWriterMethod && site.arity == 1) {
            AttrWriterMethod attrReader = (AttrWriterMethod)method2;
            String varName = attrReader.getVariableName();
            VariableAccessor accessor = dispatchClass.getRealClass().getVariableAccessorForWrite(varName);
            if (((Boolean)Options.INVOKEDYNAMIC_LOG_BINDING.load()).booleanValue()) {
                if (accessor instanceof FieldVariableAccessor) {
                    LOG.info(site.name() + "\tbound as field attr writer " + Bootstrap.logMethod(method2) + ":" + ((AttrWriterMethod)method2).getVariableName(), new Object[0]);
                } else {
                    LOG.info(site.name() + "\tbound as attr writer " + Bootstrap.logMethod(method2) + ":" + ((AttrWriterMethod)method2).getVariableName(), new Object[0]);
                }
            }
            return Bootstrap.createAttrWriterHandle(site, self2, dispatchClass.getRealClass(), accessor);
        }
        return null;
    }

    private static MethodHandle createAttrReaderHandle(InvokeSite site, IRubyObject self2, RubyClass cls, VariableAccessor accessor) {
        MethodHandle getValue2;
        MethodHandle filter = cls.getClassRuntime().getNullToNilHandle();
        if (accessor instanceof FieldVariableAccessor) {
            MethodHandle getter = ((FieldVariableAccessor)accessor).getGetter();
            getValue2 = Binder.from((MethodType)site.type()).drop(0, 2).filterReturn(filter).cast(MethodType.methodType(Object.class, self2.getClass())).invoke(getter);
        } else {
            getValue2 = Binder.from((MethodType)site.type()).drop(0, 2).filterReturn(filter).cast(MethodType.methodType(Object.class, Object.class)).prepend(new Object[]{accessor}).invokeVirtualQuiet(LOOKUP, "get");
        }
        return getValue2;
    }

    public static IRubyObject valueOrNil(IRubyObject value2, IRubyObject nil) {
        return value2 == null ? nil : value2;
    }

    private static MethodHandle createAttrWriterHandle(InvokeSite site, IRubyObject self2, RubyClass cls, VariableAccessor accessor) {
        MethodHandle setValue2;
        MethodHandle filter = Binder.from(IRubyObject.class, Object.class, (Class[])new Class[0]).drop(0).constant((Object)cls.getRuntime().getNil());
        if (accessor instanceof FieldVariableAccessor) {
            MethodHandle setter = ((FieldVariableAccessor)accessor).getSetter();
            setValue2 = Binder.from((MethodType)site.type()).drop(0, 2).filterReturn(filter).cast(MethodType.methodType(Void.TYPE, self2.getClass(), Object.class)).invoke(setter);
        } else {
            setValue2 = Binder.from((MethodType)site.type()).drop(0, 2).filterReturn(filter).cast(MethodType.methodType(Void.TYPE, Object.class, Object.class)).prepend(new Object[]{accessor}).invokeVirtualQuiet(LOOKUP, "set");
        }
        return setValue2;
    }

    static MethodHandle buildJittedHandle(InvokeSite site, DynamicMethod method2, boolean blockGiven) {
        MethodHandle mh = null;
        CompiledIRMethod compiledIRMethod = null;
        if (method2 instanceof CompiledIRMethod) {
            compiledIRMethod = (CompiledIRMethod)method2;
        } else if (method2 instanceof MixedModeIRMethod) {
            DynamicMethod actualMethod = ((MixedModeIRMethod)method2).getActualMethod();
            if (actualMethod instanceof CompiledIRMethod) {
                compiledIRMethod = (CompiledIRMethod)actualMethod;
            } else if (((Boolean)Options.INVOKEDYNAMIC_LOG_BINDING.load()).booleanValue()) {
                LOG.info(site.name() + "\tfailed direct binding due to unjitted method " + Bootstrap.logMethod(method2), new Object[0]);
            }
        }
        if (compiledIRMethod != null) {
            MethodHandle specific;
            SmartBinder binder = SmartBinder.from((Signature)site.signature).permute(new String[]{"context", "self", "arg.*", "block"});
            if (site.arity == -1) {
                mh = (MethodHandle)compiledIRMethod.getHandle();
            } else if (site.arity == 0) {
                specific = compiledIRMethod.getHandleFor(site.arity);
                if (specific != null) {
                    mh = specific;
                } else {
                    mh = (MethodHandle)compiledIRMethod.getHandle();
                    binder = binder.insert(2, "args", (Object)IRubyObject.NULL_ARRAY);
                }
            } else {
                specific = compiledIRMethod.getHandleFor(site.arity);
                if (specific != null) {
                    mh = specific;
                } else {
                    mh = (MethodHandle)compiledIRMethod.getHandle();
                    binder = binder.collect("args", "arg.*");
                }
            }
            if (!blockGiven) {
                binder = binder.append("block", Block.class, (Object)Block.NULL_BLOCK);
            }
            binder = binder.insert(1, "scope", StaticScope.class, (Object)compiledIRMethod.getStaticScope()).append("class", RubyModule.class, (Object)compiledIRMethod.getImplementationClass()).append("frameName", String.class, (Object)site.name());
            mh = binder.invoke(mh).handle();
            if (((Boolean)Options.INVOKEDYNAMIC_LOG_BINDING.load()).booleanValue()) {
                LOG.info(site.name() + "\tbound directly to jitted method " + Bootstrap.logMethod(method2), new Object[0]);
            }
        }
        return mh;
    }

    static MethodHandle buildNativeHandle(InvokeSite site, DynamicMethod method2, boolean blockGiven) {
        MethodHandle mh = null;
        SmartBinder binder = null;
        if (method2 instanceof NativeCallMethod && ((NativeCallMethod)((Object)method2)).getNativeCall() != null) {
            JRubyMethod anno;
            NativeCallMethod nativeMethod = (NativeCallMethod)((Object)method2);
            DynamicMethod.NativeCall nativeCall = nativeMethod.getNativeCall();
            DynamicMethod.NativeCall nc = nativeCall;
            if (nc.isJava()) {
                return Bootstrap.createJavaHandle(site, method2);
            }
            int nativeArgCount = Bootstrap.getNativeArgCount(method2, nativeCall);
            if (nativeArgCount >= 0) {
                if (nativeArgCount == site.arity) {
                    binder = SmartBinder.from((MethodHandles.Lookup)MethodHandles.lookup(), (Signature)site.signature);
                } else if (((Boolean)Options.INVOKEDYNAMIC_LOG_BINDING.load()).booleanValue()) {
                    LOG.info(site.name() + "\tdid not match the primary arity for a native method " + Bootstrap.logMethod(method2), new Object[0]);
                }
            } else {
                binder = site.arity == -1 ? SmartBinder.from((MethodHandles.Lookup)MethodHandles.lookup(), (Signature)site.signature) : (site.arity == 0 ? SmartBinder.from((MethodHandles.Lookup)MethodHandles.lookup(), (Signature)site.signature).insert(2, "args", (Object)IRubyObject.NULL_ARRAY) : SmartBinder.from((MethodHandles.Lookup)MethodHandles.lookup(), (Signature)site.signature).collect("args", "arg.*"));
            }
            if (binder != null) {
                if (!nc.hasContext()) {
                    binder = binder.drop("context");
                }
                if (nc.hasBlock() && !blockGiven) {
                    binder = binder.append("block", (Object)Block.NULL_BLOCK);
                } else if (!nc.hasBlock() && blockGiven) {
                    binder = binder.drop("block");
                }
                mh = nc.isStatic() ? binder.permute(new String[]{"context", "self", "arg.*", "block"}).cast(nc.getNativeReturn(), nc.getNativeSignature()).invokeStaticQuiet(LOOKUP, nc.getNativeTarget(), nc.getNativeName()).handle() : binder.permute(new String[]{"self", "context", "arg.*", "block"}).castArg("self", nc.getNativeTarget()).castVirtual(nc.getNativeReturn(), nc.getNativeTarget(), nc.getNativeSignature()).invokeVirtualQuiet(LOOKUP, nc.getNativeName()).handle();
                if (((Boolean)Options.INVOKEDYNAMIC_LOG_BINDING.load()).booleanValue()) {
                    LOG.info(site.name() + "\tbound directly to JVM method " + Bootstrap.logMethod(method2), new Object[0]);
                }
            }
            if ((anno = nativeCall.getMethod().getAnnotation(JRubyMethod.class)) != null && anno.frame()) {
                mh = InvocationLinker.wrapWithFrameOnly(site.signature, method2.getImplementationClass(), site.name(), mh);
            }
        }
        return mh;
    }

    public static int getNativeArgCount(DynamicMethod method2, DynamicMethod.NativeCall nativeCall) {
        return Bootstrap.getArgCount(nativeCall.getNativeSignature(), nativeCall.isStatic());
    }

    private static int getArgCount(Class[] args2, boolean isStatic) {
        int length2 = args2.length;
        boolean hasContext = false;
        if (isStatic) {
            if (args2.length > 1 && args2[0] == ThreadContext.class) {
                --length2;
                hasContext = true;
            }
            assert (args2.length >= 1);
            --length2;
            if (args2.length > 1 && args2[args2.length - 1] == Block.class) {
                --length2;
            }
            if (length2 == 1) {
                if (hasContext && args2[2] == IRubyObject[].class) {
                    length2 = -1;
                } else if (args2[1] == IRubyObject[].class) {
                    length2 = -1;
                }
            }
        } else {
            if (args2.length > 0 && args2[0] == ThreadContext.class) {
                --length2;
                hasContext = true;
            }
            if (args2.length > 0 && args2[args2.length - 1] == Block.class) {
                --length2;
            }
            if (length2 == 1) {
                if (hasContext && args2[1] == IRubyObject[].class) {
                    length2 = -1;
                } else if (args2[0] == IRubyObject[].class) {
                    length2 = -1;
                }
            }
        }
        return length2;
    }

    public static boolean testType(RubyClass original, IRubyObject self2) {
        return ((RubyBasicObject)self2).getMetaClass() == original;
    }

    private static MethodHandle createJavaHandle(InvokeSite site, DynamicMethod method2) {
        MethodHandle nativeTarget = (MethodHandle)method2.getHandle();
        if (nativeTarget != null) {
            return nativeTarget;
        }
        MethodHandle returnFilter = null;
        Ruby runtime2 = method2.getImplementationClass().getRuntime();
        if (!(method2 instanceof NativeCallMethod)) {
            return null;
        }
        DynamicMethod.NativeCall nativeCall = ((NativeCallMethod)((Object)method2)).getNativeCall();
        if (nativeCall == null) {
            return null;
        }
        boolean isStatic = nativeCall.isStatic();
        if (site.fullSignature.lastArgType() == Block.class) {
            if (((Boolean)Options.INVOKEDYNAMIC_LOG_BINDING.load()).booleanValue()) {
                LOG.info(site.name() + "\tpassed a closure to Java method " + nativeCall + ": " + Bootstrap.logMethod(method2), new Object[0]);
            }
            return null;
        }
        if (isStatic ? site.arity != nativeCall.getNativeSignature().length - 1 : site.arity != nativeCall.getNativeSignature().length) {
            return null;
        }
        Class[] signature = nativeCall.getNativeSignature();
        if (signature.length > 0 && signature[signature.length - 1].isArray()) {
            return null;
        }
        if (method2 instanceof SingletonMethodInvoker) {
            return null;
        }
        MethodType apparentType = MethodType.methodType(nativeCall.getNativeReturn(), nativeCall.getNativeSignature());
        nativeTarget = isStatic ? InvokeDynamicSupport.findStatic(nativeCall.getNativeTarget(), nativeCall.getNativeName(), apparentType) : InvokeDynamicSupport.findVirtual(nativeCall.getNativeTarget(), nativeCall.getNativeName(), apparentType);
        MethodType nativeType = nativeTarget.type();
        Class<?>[] nativeParams = nativeType.parameterArray();
        TypeDescriptor.OfField nativeReturn = nativeType.returnType();
        MethodHandle[] argConverters = new MethodHandle[nativeType.parameterCount()];
        for (int i2 = 0; i2 < argConverters.length; ++i2) {
            MethodHandle converter = !isStatic && i2 == 0 ? Binder.from(nativeParams[0], IRubyObject.class, (Class[])new Class[0]).cast(Object.class, new Class[]{IRubyObject.class}).invokeStaticQuiet(MethodHandles.lookup(), JavaUtil.class, "objectFromJavaProxy") : Binder.from(nativeParams[i2], IRubyObject.class, (Class[])new Class[0]).insert(1, new Object[]{nativeParams[i2]}).cast(Object.class, new Class[]{IRubyObject.class, Class.class}).invokeVirtualQuiet(MethodHandles.lookup(), "toJava");
            argConverters[i2] = converter;
        }
        nativeTarget = MethodHandles.filterArguments(nativeTarget, 0, argConverters);
        Class[] convertedParams = CodegenUtils.params(IRubyObject.class, nativeTarget.type().parameterCount());
        if (nativeReturn == Byte.TYPE || nativeReturn == Short.TYPE || nativeReturn == Character.TYPE || nativeReturn == Integer.TYPE || nativeReturn == Long.TYPE) {
            nativeTarget = MethodHandles.explicitCastArguments(nativeTarget, MethodType.methodType(Long.TYPE, convertedParams));
            returnFilter = MethodHandles.insertArguments(InvokeDynamicSupport.findStatic(RubyFixnum.class, "newFixnum", MethodType.methodType(RubyFixnum.class, Ruby.class, Long.TYPE)), 0, runtime2);
        } else if (nativeReturn == Byte.class || nativeReturn == Short.class || nativeReturn == Character.class || nativeReturn == Integer.class || nativeReturn == Long.class) {
            returnFilter = MethodHandles.insertArguments(InvokeDynamicSupport.findStatic(Bootstrap.class, "fixnumOrNil", MethodType.methodType(IRubyObject.class, Ruby.class, new Class[]{nativeReturn})), 0, runtime2);
        } else if (nativeReturn == Float.TYPE || nativeReturn == Double.TYPE) {
            nativeTarget = MethodHandles.explicitCastArguments(nativeTarget, MethodType.methodType(Double.TYPE, convertedParams));
            returnFilter = MethodHandles.insertArguments(InvokeDynamicSupport.findStatic(RubyFloat.class, "newFloat", MethodType.methodType(RubyFloat.class, Ruby.class, Double.TYPE)), 0, runtime2);
        } else if (nativeReturn == Float.class || nativeReturn == Double.class) {
            returnFilter = MethodHandles.insertArguments(InvokeDynamicSupport.findStatic(Bootstrap.class, "floatOrNil", MethodType.methodType(IRubyObject.class, Ruby.class, new Class[]{nativeReturn})), 0, runtime2);
        } else if (nativeReturn == Boolean.TYPE) {
            nativeTarget = MethodHandles.explicitCastArguments(nativeTarget, MethodType.methodType(Boolean.TYPE, convertedParams));
            returnFilter = MethodHandles.insertArguments(InvokeDynamicSupport.findStatic(RubyBoolean.class, "newBoolean", MethodType.methodType(RubyBoolean.class, Ruby.class, Boolean.TYPE)), 0, runtime2);
        } else if (nativeReturn == Boolean.class) {
            returnFilter = MethodHandles.insertArguments(InvokeDynamicSupport.findStatic(Bootstrap.class, "booleanOrNil", MethodType.methodType(IRubyObject.class, Ruby.class, Boolean.class)), 0, runtime2);
        } else if (CharSequence.class.isAssignableFrom((Class<?>)nativeReturn)) {
            nativeTarget = MethodHandles.explicitCastArguments(nativeTarget, MethodType.methodType(CharSequence.class, convertedParams));
            returnFilter = MethodHandles.insertArguments(InvokeDynamicSupport.findStatic(Bootstrap.class, "stringOrNil", MethodType.methodType(IRubyObject.class, Ruby.class, CharSequence.class)), 0, runtime2);
        } else if (nativeReturn == Void.TYPE) {
            returnFilter = MethodHandles.constant(IRubyObject.class, runtime2.getNil());
        } else if (nativeReturn != ByteList.class && nativeReturn != BigInteger.class) {
            nativeTarget = MethodHandles.explicitCastArguments(nativeTarget, MethodType.methodType(Object.class, convertedParams));
            returnFilter = MethodHandles.insertArguments(InvokeDynamicSupport.findStatic(JavaUtil.class, "convertJavaToUsableRubyObject", MethodType.methodType(IRubyObject.class, Ruby.class, Object.class)), 0, runtime2);
        }
        if (returnFilter != null) {
            Class[] newNativeParams = nativeTarget.type().parameterArray();
            TypeDescriptor.OfField newNativeReturn = nativeTarget.type().returnType();
            Binder exBinder = Binder.from((Class)newNativeReturn, Throwable.class, (Class[])newNativeParams).drop(1, newNativeParams.length).insert(0, new Object[]{runtime2});
            if (nativeReturn != Void.TYPE) {
                exBinder = exBinder.filterReturn(Binder.from((Class)newNativeReturn).constant(Bootstrap.nullValue((Class)newNativeReturn)));
            }
            nativeTarget = Binder.from((MethodType)site.type()).drop(0, isStatic ? 3 : 2).filterReturn(returnFilter).invoke(nativeTarget);
            method2.setHandle(nativeTarget);
            return nativeTarget;
        }
        return null;
    }

    public static boolean subclassProxyTest(Object target) {
        return target instanceof InternalJavaProxy;
    }

    private static Object nullValue(Class type2) {
        if (type2 == Boolean.TYPE || type2 == Boolean.class) {
            return false;
        }
        if (type2 == Byte.TYPE || type2 == Byte.class) {
            return (byte)0;
        }
        if (type2 == Short.TYPE || type2 == Short.class) {
            return (short)0;
        }
        if (type2 == Integer.TYPE || type2 == Integer.class) {
            return 0;
        }
        if (type2 == Long.TYPE || type2 == Long.class) {
            return 0L;
        }
        if (type2 == Float.TYPE || type2 == Float.class) {
            return Float.valueOf(0.0f);
        }
        if (type2 == Double.TYPE || type2 == Double.class) {
            return 0.0;
        }
        return null;
    }

    public static IRubyObject fixnumOrNil(Ruby runtime2, Byte b2) {
        return b2 == null ? runtime2.getNil() : RubyFixnum.newFixnum(runtime2, b2.byteValue());
    }

    public static IRubyObject fixnumOrNil(Ruby runtime2, Short s2) {
        return s2 == null ? runtime2.getNil() : RubyFixnum.newFixnum(runtime2, s2.shortValue());
    }

    public static IRubyObject fixnumOrNil(Ruby runtime2, Character c) {
        return c == null ? runtime2.getNil() : RubyFixnum.newFixnum(runtime2, c.charValue());
    }

    public static IRubyObject fixnumOrNil(Ruby runtime2, Integer i2) {
        return i2 == null ? runtime2.getNil() : RubyFixnum.newFixnum(runtime2, i2.intValue());
    }

    public static IRubyObject fixnumOrNil(Ruby runtime2, Long l) {
        return l == null ? runtime2.getNil() : RubyFixnum.newFixnum(runtime2, l);
    }

    public static IRubyObject floatOrNil(Ruby runtime2, Float f) {
        return f == null ? runtime2.getNil() : RubyFloat.newFloat(runtime2, f.floatValue());
    }

    public static IRubyObject floatOrNil(Ruby runtime2, Double d) {
        return d == null ? runtime2.getNil() : RubyFloat.newFloat(runtime2, d);
    }

    public static IRubyObject booleanOrNil(Ruby runtime2, Boolean b2) {
        return b2 == null ? runtime2.getNil() : RubyBoolean.newBoolean(runtime2, b2);
    }

    public static IRubyObject stringOrNil(Ruby runtime2, CharSequence cs) {
        return cs == null ? runtime2.getNil() : RubyString.newUnicodeString(runtime2, cs);
    }

    public static boolean testModuleMatch(ThreadContext context, IRubyObject arg0, int id2) {
        return arg0 instanceof RubyModule && ((RubyModule)arg0).id == id2;
    }

    public static Handle getFixnumOperatorHandle() {
        return Bootstrap.getBootstrapHandle("fixnumOperatorBootstrap", MathLinker.class, BOOTSTRAP_LONG_STRING_INT_SIG);
    }

    public static Handle getFloatOperatorHandle() {
        return Bootstrap.getBootstrapHandle("floatOperatorBootstrap", MathLinker.class, BOOTSTRAP_DOUBLE_STRING_INT_SIG);
    }

    public static Handle checkpointHandle() {
        return Bootstrap.getBootstrapHandle("checkpointBootstrap", BOOTSTRAP_BARE_SIG);
    }

    public static Handle getBootstrapHandle(String name2, String sig) {
        return Bootstrap.getBootstrapHandle(name2, Bootstrap.class, sig);
    }

    public static Handle getBootstrapHandle(String name2, Class type2, String sig) {
        return new Handle(6, CodegenUtils.p(type2), name2, sig, false);
    }

    public static CallSite checkpointBootstrap(MethodHandles.Lookup lookup, String name2, MethodType type2) throws Throwable {
        MutableCallSite site = new MutableCallSite(type2);
        MethodHandle handle = lookup.findStatic(Bootstrap.class, "checkpointFallback", MethodType.methodType(Void.TYPE, MutableCallSite.class, ThreadContext.class));
        handle = handle.bindTo(site);
        site.setTarget(handle);
        return site;
    }

    public static void checkpointFallback(MutableCallSite site, ThreadContext context) throws Throwable {
        Ruby runtime2 = context.runtime;
        Invalidator invalidator = runtime2.getCheckpointInvalidator();
        MethodHandle target = Binder.from(Void.TYPE, ThreadContext.class, (Class[])new Class[0]).nop();
        MethodHandle fallback = MethodHandles.lookup().findStatic(Bootstrap.class, "checkpointFallback", MethodType.methodType(Void.TYPE, MutableCallSite.class, ThreadContext.class));
        fallback = fallback.bindTo(site);
        target = ((SwitchPoint)invalidator.getData()).guardWithTest(target, fallback);
        site.setTarget(target);
    }

    public static CallSite globalBootstrap(MethodHandles.Lookup lookup, String name2, MethodType type2, String file2, int line) throws Throwable {
        String[] names2 = name2.split(":");
        String operation = names2[0];
        String varName = JavaNameMangler.demangleMethodName(names2[1]);
        GlobalSite site = new GlobalSite(type2, varName, file2, line);
        MethodHandle handle = operation.equals("get") ? lookup.findStatic(Bootstrap.class, "getGlobalFallback", MethodType.methodType(IRubyObject.class, GlobalSite.class, ThreadContext.class)) : lookup.findStatic(Bootstrap.class, "setGlobalFallback", MethodType.methodType(Void.TYPE, GlobalSite.class, IRubyObject.class, ThreadContext.class));
        handle = handle.bindTo(site);
        site.setTarget(handle);
        return site;
    }

    public static IRubyObject getGlobalFallback(GlobalSite site, ThreadContext context) throws Throwable {
        Ruby runtime2 = context.runtime;
        GlobalVariable variable = runtime2.getGlobalVariables().getVariable(site.name());
        if (site.failures() > (Integer)Options.INVOKEDYNAMIC_GLOBAL_MAXFAIL.load() || variable.getScope() != GlobalVariable.Scope.GLOBAL || RubyGlobal.UNCACHED_GLOBALS.contains(site.name())) {
            if (((Boolean)Options.INVOKEDYNAMIC_LOG_GLOBALS.load()).booleanValue()) {
                LOG.info("global " + site.name() + " (" + site.file() + ":" + site.line() + ") uncacheable or rebound > " + Options.INVOKEDYNAMIC_GLOBAL_MAXFAIL.load() + " times, reverting to simple lookup", new Object[0]);
            }
            MethodHandle uncached = MethodHandles.lookup().findStatic(Bootstrap.class, "getGlobalUncached", MethodType.methodType(IRubyObject.class, GlobalVariable.class));
            uncached = uncached.bindTo(variable);
            uncached = MethodHandles.dropArguments(uncached, 0, new Class[]{ThreadContext.class});
            site.setTarget(uncached);
            return (IRubyObject)uncached.invokeWithArguments(context);
        }
        Invalidator invalidator = variable.getInvalidator();
        IRubyObject value2 = variable.getAccessor().getValue();
        MethodHandle target = MethodHandles.constant(IRubyObject.class, value2);
        target = MethodHandles.dropArguments(target, 0, new Class[]{ThreadContext.class});
        MethodHandle fallback = MethodHandles.lookup().findStatic(Bootstrap.class, "getGlobalFallback", MethodType.methodType(IRubyObject.class, GlobalSite.class, ThreadContext.class));
        fallback = fallback.bindTo(site);
        target = ((SwitchPoint)invalidator.getData()).guardWithTest(target, fallback);
        site.setTarget(target);
        return value2;
    }

    public static IRubyObject getGlobalUncached(GlobalVariable variable) throws Throwable {
        return variable.getAccessor().getValue();
    }

    public static void setGlobalFallback(GlobalSite site, IRubyObject value2, ThreadContext context) throws Throwable {
        Ruby runtime2 = context.runtime;
        GlobalVariable variable = runtime2.getGlobalVariables().getVariable(site.name());
        MethodHandle uncached = MethodHandles.lookup().findStatic(Bootstrap.class, "setGlobalUncached", MethodType.methodType(Void.TYPE, GlobalVariable.class, IRubyObject.class));
        uncached = uncached.bindTo(variable);
        uncached = MethodHandles.dropArguments(uncached, 1, new Class[]{ThreadContext.class});
        site.setTarget(uncached);
        uncached.invokeWithArguments(value2, context);
    }

    public static void setGlobalUncached(GlobalVariable variable, IRubyObject value2) throws Throwable {
        variable.getAccessor().setValue(value2);
        variable.trace(value2);
        variable.invalidate();
    }

    public static Handle prepareBlock() {
        return new Handle(6, CodegenUtils.p(Bootstrap.class), "prepareBlock", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, MethodHandle.class, MethodHandle.class, Long.TYPE), false);
    }

    public static CallSite prepareBlock(MethodHandles.Lookup lookup, String name2, MethodType type2, MethodHandle bodyHandle, MethodHandle scopeHandle, long encodedSignature) throws Throwable {
        IRScope scope = scopeHandle.invokeExact();
        CompiledIRBlockBody body = new CompiledIRBlockBody(bodyHandle, scope, encodedSignature);
        Binder binder = Binder.from((MethodType)type2);
        binder = binder.fold(FRAME_SCOPE_BINDING);
        MethodHandle blockMaker = binder.drop(1, 3).append(new Object[]{body}).invoke(CONSTRUCT_BLOCK);
        return new ConstantCallSite(blockMaker);
    }

    static String logMethod(DynamicMethod method2) {
        return "[#" + method2.getSerialNumber() + " " + method2.getImplementationClass().getMethodLocation() + "]";
    }

    static String logBlock(Block block) {
        return "[" + block.getBody() + " " + block.getFrame() + "]";
    }

    public static Binding frameScopeBinding(ThreadContext context, IRubyObject self2, DynamicScope scope) {
        Frame frame = context.getCurrentFrame().capture();
        return new Binding(self2, frame, frame.getVisibility(), scope);
    }

    public static Binding frameBinding(ThreadContext context, IRubyObject self2, DynamicScope scope) {
        Frame frame = context.getCurrentFrame().capture();
        return new Binding(self2, frame, frame.getVisibility());
    }

    public static Binding scopeBinding(ThreadContext context, IRubyObject self2, DynamicScope scope) {
        return new Binding(self2, scope);
    }

    public static Binding selfBinding(ThreadContext context, IRubyObject self2, DynamicScope scope) {
        return new Binding(self2);
    }

    public static Block constructBlock(Binding binding2, CompiledIRBlockBody body) throws Throwable {
        return new Block(body, binding2);
    }

    public static class IsTrueSite
    extends MutableCallSite {
        public static final MethodType TYPE = MethodType.methodType(Boolean.TYPE, IRubyObject.class);

        public IsTrueSite() {
            super(TYPE);
            this.setTarget(Binder.from((MethodType)TYPE.insertParameterTypes(0, IsTrueSite.class)).invokeVirtualQuiet(LOOKUP, "init").bindTo(this));
        }

        public boolean init(IRubyObject obj) {
            Ruby runtime2 = obj.getRuntime();
            IRubyObject nil = runtime2.getNil();
            RubyBoolean fals = runtime2.getFalse();
            this.setTarget(Binder.from((MethodType)this.type()).insert(0, RubyBoolean.False.class, (Object)fals).insert(0, RubyNil.class, (Object)nil).invokeStaticQuiet(LOOKUP, IsTrueSite.class, "isTruthy"));
            return nil != obj && fals != obj;
        }

        public static boolean isTruthy(RubyNil nil, RubyBoolean.False fals, IRubyObject obj) {
            return nil != obj && fals != obj;
        }
    }

    public static class IsNilSite
    extends MutableCallSite {
        public static final MethodType TYPE = MethodType.methodType(Boolean.TYPE, IRubyObject.class);

        public IsNilSite() {
            super(TYPE);
            this.setTarget(Binder.from((MethodType)TYPE.insertParameterTypes(0, IsNilSite.class)).invokeVirtualQuiet(LOOKUP, "init").bindTo(this));
        }

        public boolean init(IRubyObject obj) {
            IRubyObject nil = obj.getRuntime().getNil();
            this.setTarget(Binder.from((MethodType)this.type()).insert(0, RubyNil.class, (Object)nil).invokeStaticQuiet(LOOKUP, IsNilSite.class, "isNil"));
            return nil == obj;
        }

        public static boolean isNil(RubyNil nil, IRubyObject obj) {
            return nil == obj;
        }
    }
}

