/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.channels.Channel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import org.jcodings.Encoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyEncoding;
import org.jruby.RubyException;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyIO;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.RubyThreadGroup;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.ThreadKill;
import org.jruby.exceptions.Unrescuable;
import org.jruby.ext.thread.Mutex;
import org.jruby.internal.runtime.NativeThread;
import org.jruby.internal.runtime.RubyRunnable;
import org.jruby.internal.runtime.ThreadLike;
import org.jruby.internal.runtime.ThreadService;
import org.jruby.java.proxies.ConcreteJavaProxy;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.ExecutionContext;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ObjectMarshal;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.backtrace.BacktraceData;
import org.jruby.runtime.backtrace.FrameType;
import org.jruby.runtime.backtrace.RubyStackTraceElement;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.RubyStringBuilder;
import org.jruby.util.StringSupport;
import org.jruby.util.TypeConverter;
import org.jruby.util.io.BlockingIO;
import org.jruby.util.io.OpenFile;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

@JRubyClass(name={"Thread"})
public class RubyThread
extends RubyObject
implements ExecutionContext {
    private static final Logger LOG = LoggerFactory.getLogger(RubyThread.class);
    private volatile ThreadLike threadImpl = ThreadLike.DUMMY;
    private volatile transient Map<IRubyObject, IRubyObject> fiberLocalVariables;
    private volatile transient Map<IRubyObject, IRubyObject> threadLocalVariables;
    private final Map<Object, IRubyObject> contextVariables = new WeakHashMap<Object, IRubyObject>();
    private volatile boolean abortOnException;
    private volatile IRubyObject reportOnException;
    private volatile boolean exceptionCaptured;
    private volatile IRubyObject finalResult;
    private String file;
    private int line;
    private volatile Throwable exitingException;
    private volatile RubyThreadGroup threadGroup;
    private volatile IRubyObject errorInfo;
    private volatile WeakReference<ThreadContext> contextRef;
    private final List<RubyHash> interruptMaskStack = Collections.synchronizedList(new ArrayList());
    private final SleepTask2 sleepTask = new SleepTask2();
    public static final int RUBY_MIN_THREAD_PRIORITY = -3;
    public static final int RUBY_MAX_THREAD_PRIORITY = 3;
    private final AtomicReference<Status> status = new AtomicReference<Status>(Status.RUN);
    private final Queue<IRubyObject> pendingInterruptQueue = new ConcurrentLinkedQueue<IRubyObject>();
    private volatile Unblocker unblockFunc;
    private volatile Object unblockArg;
    private final List<Lock> heldLocks = new Vector<Lock>();
    private volatile boolean disposed = false;
    private volatile int interruptFlag = 0;
    private volatile int interruptMask;
    private volatile boolean pendingInterruptQueueChecked = false;
    private volatile Selector currentSelector;
    private volatile RubyThread fiberCurrentThread;
    private static final AtomicIntegerFieldUpdater<RubyThread> INTERRUPT_FLAG_UPDATER = AtomicIntegerFieldUpdater.newUpdater(RubyThread.class, "interruptFlag");
    private static final int TIMER_INTERRUPT_MASK = 1;
    private static final int PENDING_INTERRUPT_MASK = 2;
    private static final int POSTPONED_JOB_INTERRUPT_MASK = 4;
    private static final int TRAP_INTERRUPT_MASK = 8;
    private static final int INTERRUPT_NONE = 0;
    private static final int INTERRUPT_IMMEDIATE = 1;
    private static final int INTERRUPT_ON_BLOCKING = 2;
    private static final int INTERRUPT_NEVER = 3;
    private static final String RUBY_THREAD_PREFIX = "Ruby-";
    private static final RubyHash.VisitorWithState HandleInterruptVisitor = new RubyHash.VisitorWithState(){

        public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, Object state2) {
            if (value2 instanceof RubySymbol) {
                RubySymbol sym = (RubySymbol)value2;
                switch (sym.idString()) {
                    case "immediate": {
                        return;
                    }
                    case "on_blocking": {
                        return;
                    }
                    case "never": {
                        return;
                    }
                }
                throw key2.getRuntime().newArgumentError("unknown mask signature");
            }
        }
    };
    private volatile BlockingIO.Condition blockingIO = null;
    private static final String MUTEX_FOR_THREAD_EXCLUSIVE = "MUTEX_FOR_THREAD_EXCLUSIVE";
    @Deprecated
    private volatile BlockingTask currentBlockingTask;

    protected RubyThread(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
        this.finalResult = this.errorInfo = runtime2.getNil();
        this.reportOnException = runtime2.getReportOnException();
    }

    public RubyThread(Ruby runtime2, RubyClass klass, Runnable runnable) {
        this(runtime2, klass);
        this.startThread(runtime2.getCurrentContext(), runnable);
    }

    private void executeInterrupts(ThreadContext context, boolean blockingTiming) {
        int interrupt;
        Ruby runtime2 = context.runtime;
        boolean postponedJobInterrupt = false;
        while ((interrupt = this.getInterrupts()) != 0) {
            IRubyObject err;
            boolean timerInterrupt = (interrupt & 1) == 1;
            boolean pendingInterrupt = (interrupt & 2) == 2;
            if (!pendingInterrupt || !this.pendingInterruptActive() || (err = this.pendingInterruptDeque(context, blockingTiming ? 2 : 0)) == UNDEF) continue;
            if (err == RubyFixnum.zero(runtime2) || err == RubyFixnum.one(runtime2) || err == RubyFixnum.two(runtime2)) {
                this.toKill();
                continue;
            }
            this.afterBlockingCall();
            if (this.status.get() == Status.SLEEP) {
                this.exitSleep();
            }
            IRubyObject[] args2 = err instanceof RubyException ? Helpers.arrayOf(err, RubyHash.newKwargs(runtime2, "cause", ((RubyException)err).cause)) : Helpers.arrayOf(err);
            RubyKernel.raise(context, runtime2.getKernel(), args2, Block.NULL_BLOCK);
        }
    }

    private void postponedJobFlush(ThreadContext context) {
    }

    private boolean pendingInterruptActive() {
        if (this.pendingInterruptQueueChecked) {
            return false;
        }
        return !this.pendingInterruptQueue.isEmpty();
    }

    private void toKill() {
        this.pendingInterruptClear();
        this.status.set(Status.ABORTING);
        RubyThread.throwThreadKill();
    }

    private void pendingInterruptClear() {
        this.pendingInterruptQueue.clear();
    }

    private int getInterrupts() {
        int interrupt;
        while (!INTERRUPT_FLAG_UPDATER.compareAndSet(this, interrupt = this.interruptFlag, interrupt & this.interruptMask)) {
        }
        return interrupt & ~this.interruptMask;
    }

    private IRubyObject pendingInterruptDeque(ThreadContext context, int timing) {
        Iterator iterator = this.pendingInterruptQueue.iterator();
        while (iterator.hasNext()) {
            IRubyObject err = (IRubyObject)iterator.next();
            int maskTiming = this.pendingInterruptCheckMask(context, err);
            switch (maskTiming) {
                case 2: {
                    if (timing != 2) break;
                }
                case 0: 
                case 1: {
                    iterator.remove();
                    return err;
                }
            }
        }
        this.pendingInterruptQueueChecked = true;
        return UNDEF;
    }

    private int pendingInterruptCheckMask(ThreadContext context, IRubyObject err) {
        List<IRubyObject> ancestors2 = err.getMetaClass().getAncestorList();
        int ancestorsLen = ancestors2.size();
        List<RubyHash> maskStack = this.interruptMaskStack;
        int maskStackLen = maskStack.size();
        for (int i2 = 0; i2 < maskStackLen; ++i2) {
            RubyHash mask = maskStack.get(maskStackLen - (i2 + 1));
            for (int j = 0; j < ancestorsLen; ++j) {
                String symStr;
                IRubyObject klass = ancestors2.get(j);
                IRubyObject sym = mask.op_aref(context, klass);
                if (sym.isNil()) continue;
                switch (symStr = sym.toString()) {
                    case "immediate": {
                        return 1;
                    }
                    case "on_blocking": {
                        return 2;
                    }
                    case "never": {
                        return 3;
                    }
                }
                throw context.runtime.newThreadError("unknown mask signature");
            }
        }
        return 0;
    }

    public IRubyObject getErrorInfo() {
        return this.errorInfo;
    }

    public IRubyObject setErrorInfo(IRubyObject errorInfo) {
        this.errorInfo = errorInfo;
        return errorInfo;
    }

    public void setContext(ThreadContext context) {
        this.contextRef = new WeakReference<ThreadContext>(context);
    }

    public ThreadContext getContext() {
        WeakReference<ThreadContext> contextRef = this.contextRef;
        return contextRef == null ? null : (ThreadContext)contextRef.get();
    }

    public Thread getNativeThread() {
        return this.threadImpl.nativeThread();
    }

    public void setFiberCurrentThread(RubyThread fiberCurrentThread) {
        this.fiberCurrentThread = fiberCurrentThread;
    }

    public RubyThread getFiberCurrentThread() {
        if (this.fiberCurrentThread == null) {
            return this;
        }
        return this.fiberCurrentThread;
    }

    public void beforeStart() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.disposed) {
            return;
        }
        RubyThread rubyThread = this;
        synchronized (rubyThread) {
            if (this.disposed) {
                return;
            }
            this.disposed = true;
            this.threadGroup.remove(this);
            this.unlockAll();
            this.beDead();
        }
        this.getRuntime().getThreadService().unregisterThread(this);
    }

    public static RubyClass createThreadClass(Ruby runtime2) {
        RubyClass threadClass = runtime2.defineClass("Thread", runtime2.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        runtime2.setThread(threadClass);
        threadClass.setClassIndex(ClassIndex.THREAD);
        threadClass.setReifiedClass(RubyThread.class);
        threadClass.defineAnnotatedMethods(RubyThread.class);
        RubyThread rubyThread = new RubyThread(runtime2, threadClass);
        rubyThread.threadImpl = new NativeThread(rubyThread, Thread.currentThread());
        runtime2.getThreadService().setMainThread(Thread.currentThread(), rubyThread);
        runtime2.getDefaultThreadGroup().addDirectly(rubyThread);
        threadClass.setMarshal(ObjectMarshal.NOT_MARSHALABLE_MARSHAL);
        RubyClass backtrace2 = threadClass.defineClassUnder("Backtrace", runtime2.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        RubyClass location = backtrace2.defineClassUnder("Location", runtime2.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        location.defineAnnotatedMethods(Location.class);
        runtime2.setLocation(location);
        return threadClass;
    }

    @JRubyMethod(name={"new", "fork"}, rest=true, meta=true)
    public static IRubyObject newInstance(IRubyObject recv2, IRubyObject[] args2, Block block) {
        return RubyThread.startThread(recv2, args2, true, block);
    }

    @JRubyMethod(rest=true, name={"start"}, meta=true)
    public static RubyThread start(IRubyObject recv2, IRubyObject[] args2, Block block) {
        if (!block.isGiven()) {
            throw recv2.getRuntime().newArgumentError("tried to create Proc object without a block");
        }
        return RubyThread.startThread(recv2, args2, false, block);
    }

    @Deprecated
    public static RubyThread start19(IRubyObject recv2, IRubyObject[] args2, Block block) {
        return RubyThread.start(recv2, args2, block);
    }

    public static RubyThread adopt(IRubyObject recv2, Thread t) {
        Ruby runtime2 = recv2.getRuntime();
        return RubyThread.adoptThread(runtime2, runtime2.getThreadService(), (RubyClass)recv2, t);
    }

    public static RubyThread adopt(Ruby runtime2, ThreadService service, Thread thread2) {
        return RubyThread.adoptThread(runtime2, service, runtime2.getThread(), thread2);
    }

    private static RubyThread adoptThread(Ruby runtime2, ThreadService service, RubyClass recv2, Thread thread2) {
        RubyThread rubyThread = new RubyThread(runtime2, recv2);
        rubyThread.threadImpl = new NativeThread(rubyThread, thread2);
        ThreadContext context = service.registerNewThread(rubyThread);
        service.associateThread(thread2, rubyThread);
        context.preAdoptThread();
        runtime2.getDefaultThreadGroup().addDirectly(rubyThread);
        return rubyThread;
    }

    @JRubyMethod(rest=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2, Block block) {
        if (!block.isGiven()) {
            throw context.runtime.newThreadError("must be called with a block");
        }
        if (this.threadImpl != ThreadLike.DUMMY) {
            throw context.runtime.newThreadError("already initialized thread");
        }
        return this.startThread(context, new RubyRunnable(this, args2, block));
    }

    private IRubyObject startThread(ThreadContext context, Runnable runnable) throws RaiseException, OutOfMemoryError {
        Ruby runtime2 = context.runtime;
        try {
            Thread thread2 = new Thread(runnable);
            thread2.setDaemon(true);
            this.file = context.getFile();
            this.line = context.getLine();
            RubyThread.initThreadName(runtime2, thread2, this.file, this.line);
            this.threadImpl = new NativeThread(this, thread2);
            this.addToCorrectThreadGroup(context);
            runtime2.getThreadService().associateThread(thread2, this);
            this.interruptMaskStack.addAll(context.getThread().interruptMaskStack);
            this.threadImpl.start();
            Thread.yield();
            return this;
        }
        catch (OutOfMemoryError oome) {
            if (oome.getMessage().equals("unable to create new native thread")) {
                throw runtime2.newThreadError(oome.getMessage());
            }
            throw oome;
        }
        catch (SecurityException ex) {
            throw runtime2.newThreadError(ex.getMessage());
        }
    }

    private static void initThreadName(Ruby runtime2, Thread thread2, String file2, int line) {
        StringBuilder name2 = new StringBuilder(24);
        name2.append(RUBY_THREAD_PREFIX).append(runtime2.getRuntimeNumber()).append('-').append("Thread-").append(RubyThread.incAndGetThreadCount(runtime2));
        if (file2 != null) {
            name2.append(':').append(' ').append(file2).append(':').append(line + 1);
        }
        String newName = name2.toString();
        thread2.setName(newName);
    }

    private static long incAndGetThreadCount(Ruby runtime2) {
        return runtime2.getThreadService().incrementAndGetThreadCount();
    }

    private static RubyThread startThread(IRubyObject recv2, IRubyObject[] args2, boolean callInit, Block block) {
        Ruby runtime2 = recv2.getRuntime();
        RubyThread rubyThread = new RubyThread(runtime2, (RubyClass)recv2);
        if (callInit) {
            rubyThread.callInit(args2, block);
            if (rubyThread.threadImpl == ThreadLike.DUMMY) {
                throw runtime2.newThreadError(RubyStringBuilder.str(runtime2, "uninitialized thread - check ", RubyStringBuilder.types(runtime2, (RubyClass)recv2), "#initialize"));
            }
        } else {
            rubyThread.initialize(runtime2.getCurrentContext(), args2, block);
        }
        return rubyThread;
    }

    protected static RubyThread startWaiterThread(Ruby runtime2, int pid2, Block block) {
        IRubyObject waiter = runtime2.getProcess().getConstantAt("Waiter");
        RubyThread rubyThread = new RubyThread(runtime2, (RubyClass)waiter);
        rubyThread.op_aset(runtime2.newSymbol("pid"), runtime2.newFixnum(pid2));
        rubyThread.callInit(IRubyObject.NULL_ARRAY, block);
        return rubyThread;
    }

    public synchronized void cleanTerminate(IRubyObject result2) {
        this.finalResult = result2;
    }

    public void beDead() {
        this.status.set(Status.DEAD);
    }

    public void pollThreadEvents() {
        this.pollThreadEvents(this.getRuntime().getCurrentContext());
    }

    public void pollThreadEvents(ThreadContext context) {
        if (this.anyInterrupted()) {
            this.executeInterrupts(context, true);
        }
    }

    private boolean anyInterrupted() {
        return Thread.interrupted() || (this.interruptFlag & ~this.interruptMask) != 0;
    }

    private static void throwThreadKill() {
        throw new ThreadKill();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(meta=true)
    public static IRubyObject handle_interrupt(ThreadContext context, IRubyObject self2, IRubyObject _mask, Block block) {
        if (!block.isGiven()) {
            throw context.runtime.newArgumentError("block is needed");
        }
        RubyHash mask = (RubyHash)TypeConverter.convertToType(_mask, context.runtime.getHash(), "to_hash");
        mask.visitAll(context, HandleInterruptVisitor, null);
        RubyThread th = context.getThread();
        th.interruptMaskStack.add(mask);
        if (th.pendingInterruptQueue.isEmpty()) {
            th.pendingInterruptQueueChecked = false;
            th.setInterrupt();
        }
        try {
            th.pollThreadEvents();
            IRubyObject iRubyObject = block.call(context);
            return iRubyObject;
        }
        finally {
            th.interruptMaskStack.remove(th.interruptMaskStack.size() - 1);
            th.setInterrupt();
            th.pollThreadEvents(context);
        }
    }

    @JRubyMethod(name={"pending_interrupt?"}, meta=true, optional=1)
    public static IRubyObject pending_interrupt_p(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        return context.getThread().pending_interrupt_p(context, args2);
    }

    @JRubyMethod(name={"pending_interrupt?"}, optional=1)
    public IRubyObject pending_interrupt_p(ThreadContext context, IRubyObject[] args2) {
        if (this.pendingInterruptQueue.isEmpty()) {
            return context.fals;
        }
        if (args2.length == 1) {
            IRubyObject err = args2[0];
            if (!(err instanceof RubyModule)) {
                throw context.runtime.newTypeError("class or module required for rescue clause");
            }
            if (this.pendingInterruptInclude(err)) {
                return context.tru;
            }
            return context.fals;
        }
        return context.tru;
    }

    @JRubyMethod(name={"name="}, required=1)
    public IRubyObject setName(IRubyObject name2) {
        Ruby runtime2 = this.getRuntime();
        if (!name2.isNil()) {
            RubyString nameStr = StringSupport.checkEmbeddedNulls(runtime2, name2);
            Encoding enc = nameStr.getEncoding();
            if (!enc.isAsciiCompatible()) {
                throw runtime2.newArgumentError("ASCII incompatible encoding (" + enc + ")");
            }
            this.threadImpl.setRubyName(runtime2.freezeAndDedupString(nameStr).asJavaString());
        } else {
            this.threadImpl.setRubyName(null);
        }
        return name2;
    }

    @JRubyMethod(name={"name"})
    public IRubyObject getName() {
        Ruby runtime2 = this.getRuntime();
        String rubyName = this.threadImpl.getRubyName();
        if (rubyName == null) {
            return runtime2.getNil();
        }
        return RubyString.newString(runtime2, (CharSequence)rubyName);
    }

    private boolean pendingInterruptInclude(IRubyObject err) {
        for (IRubyObject e : this.pendingInterruptQueue) {
            if (!((RubyModule)e).op_le(err).isTrue()) continue;
            return true;
        }
        return false;
    }

    @JRubyMethod(name={"abort_on_exception"}, meta=true)
    public static RubyBoolean abort_on_exception_x(IRubyObject recv2) {
        Ruby runtime2 = recv2.getRuntime();
        return runtime2.isGlobalAbortOnExceptionEnabled() ? runtime2.getTrue() : runtime2.getFalse();
    }

    @JRubyMethod(name={"abort_on_exception="}, required=1, meta=true)
    public static IRubyObject abort_on_exception_set_x(IRubyObject recv2, IRubyObject value2) {
        recv2.getRuntime().setGlobalAbortOnExceptionEnabled(value2.isTrue());
        return value2;
    }

    @JRubyMethod(meta=true)
    public static RubyThread current(IRubyObject recv2) {
        return recv2.getRuntime().getCurrentContext().getThread();
    }

    @JRubyMethod(meta=true)
    public static RubyThread main(IRubyObject recv2) {
        return recv2.getRuntime().getThreadService().getMainThread();
    }

    @JRubyMethod(meta=true)
    public static IRubyObject pass(ThreadContext context, IRubyObject recv2) {
        Thread.yield();
        return context.nil;
    }

    @JRubyMethod(meta=true)
    public static RubyArray list(IRubyObject recv2) {
        Ruby runtime2 = recv2.getRuntime();
        IRubyObject[] activeThreads = runtime2.getThreadService().getActiveRubyThreads();
        return RubyArray.newArrayMayCopy(runtime2, activeThreads);
    }

    private void addToCorrectThreadGroup(ThreadContext context) {
        IRubyObject group2 = context.getThread().group();
        if (!group2.isNil()) {
            ((RubyThreadGroup)group2).addDirectly(this);
        } else {
            context.runtime.getDefaultThreadGroup().addDirectly(this);
        }
    }

    private IRubyObject getSymbolKey(IRubyObject originalKey) {
        if (originalKey instanceof RubySymbol) {
            return originalKey;
        }
        Ruby runtime2 = this.getRuntime();
        if (originalKey instanceof RubyString) {
            return runtime2.newSymbol(((RubyString)originalKey).getByteList());
        }
        throw this.getRuntime().newTypeError(RubyStringBuilder.str(this.getRuntime(), RubyStringBuilder.ids(runtime2, originalKey), " is not a symbol nor a string"));
    }

    private synchronized Map<IRubyObject, IRubyObject> getFiberLocals() {
        if (this.fiberLocalVariables == null) {
            this.fiberLocalVariables = new HashMap<IRubyObject, IRubyObject>();
        }
        return this.fiberLocalVariables;
    }

    private synchronized Map<IRubyObject, IRubyObject> getThreadLocals() {
        return this.getFiberCurrentThread().getThreadLocals0();
    }

    private synchronized Map<IRubyObject, IRubyObject> getThreadLocals0() {
        if (this.threadLocalVariables == null) {
            this.threadLocalVariables = new HashMap<IRubyObject, IRubyObject>();
        }
        return this.threadLocalVariables;
    }

    @Override
    public final Map<Object, IRubyObject> getContextVariables() {
        return this.contextVariables;
    }

    public boolean isAlive() {
        return this.threadImpl.isAlive() && this.status.get() != Status.DEAD;
    }

    @JRubyMethod
    public IRubyObject fetch(ThreadContext context, IRubyObject key2, Block block) {
        Ruby runtime2 = context.runtime;
        IRubyObject value2 = this.op_aref(key2);
        if (value2.isNil()) {
            if (block.isGiven()) {
                return block.yield(context, key2);
            }
            throw runtime2.newKeyError("key not found: " + key2.inspect(), this, key2);
        }
        return value2;
    }

    @JRubyMethod
    public IRubyObject fetch(ThreadContext context, IRubyObject key2, IRubyObject _default, Block block) {
        IRubyObject value2;
        Ruby runtime2 = context.runtime;
        boolean blockGiven = block.isGiven();
        if (blockGiven) {
            runtime2.getWarnings().warn(IRubyWarnings.ID.BLOCK_BEATS_DEFAULT_VALUE, "block supersedes default value argument");
        }
        if ((value2 = this.op_aref(key2)).isNil()) {
            if (blockGiven) {
                return block.yield(context, key2);
            }
            return _default;
        }
        return value2;
    }

    @JRubyMethod(name={"[]"}, required=1)
    public synchronized IRubyObject op_aref(IRubyObject key2) {
        IRubyObject value2 = this.getFiberLocals().get(this.getSymbolKey(key2));
        if (value2 != null) {
            return value2;
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"[]="}, required=2)
    public synchronized IRubyObject op_aset(IRubyObject key2, IRubyObject value2) {
        this.checkFrozen();
        key2 = this.getSymbolKey(key2);
        this.getFiberLocals().put(key2, value2);
        return value2;
    }

    @JRubyMethod(name={"thread_variable?"}, required=1)
    public synchronized IRubyObject thread_variable_p(ThreadContext context, IRubyObject key2) {
        return context.runtime.newBoolean(this.getThreadLocals().containsKey(this.getSymbolKey(key2)));
    }

    @JRubyMethod(name={"thread_variable_get"}, required=1)
    public synchronized IRubyObject thread_variable_get(ThreadContext context, IRubyObject key2) {
        IRubyObject value2 = this.getThreadLocals().get(this.getSymbolKey(key2));
        if (value2 != null) {
            return value2;
        }
        return context.nil;
    }

    @JRubyMethod(name={"thread_variable_set"}, required=2)
    public synchronized IRubyObject thread_variable_set(ThreadContext context, IRubyObject key2, IRubyObject value2) {
        this.checkFrozen();
        key2 = this.getSymbolKey(key2);
        this.getThreadLocals().put(key2, value2);
        return value2;
    }

    @JRubyMethod(name={"thread_variables"})
    public synchronized IRubyObject thread_variables(ThreadContext context) {
        Map<IRubyObject, IRubyObject> vars = this.getThreadLocals();
        RubyArray ary = RubyArray.newArray(context.runtime, vars.size());
        for (Map.Entry<IRubyObject, IRubyObject> entry : vars.entrySet()) {
            ary.append(entry.getKey());
        }
        return ary;
    }

    @JRubyMethod
    public RubyBoolean abort_on_exception() {
        return this.abortOnException ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"abort_on_exception="}, required=1)
    public IRubyObject abort_on_exception_set(IRubyObject val) {
        this.abortOnException = val.isTrue();
        return val;
    }

    @JRubyMethod(name={"alive?"})
    public RubyBoolean alive_p() {
        return this.isAlive() ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @Deprecated
    public IRubyObject join(IRubyObject[] args2) {
        return this.join(this.getRuntime().getCurrentContext(), args2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(optional=1)
    public IRubyObject join(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime2 = context.runtime;
        long timeoutMillis = Long.MAX_VALUE;
        if (args2.length > 0 && !args2[0].isNil()) {
            if (args2.length > 1) {
                throw runtime2.newArgumentError(args2.length, 1);
            }
            timeoutMillis = (long)(1000.0 * args2[0].convertToFloat().getValue());
            if (timeoutMillis <= 0L) {
                if (this.threadImpl.isAlive()) {
                    return context.nil;
                }
                return this;
            }
        }
        if (this.isCurrent()) {
            throw runtime2.newThreadError("thread " + this.identityString() + " tried to join itself");
        }
        RubyThread currentThread = context.getThread();
        try {
            currentThread.enterSleep();
            long timeToWait = Math.min(timeoutMillis, 200L);
            long start2 = System.currentTimeMillis();
            do {
                currentThread.pollThreadEvents();
                this.threadImpl.join(timeToWait);
                if (this.threadImpl.isAlive()) continue;
                break;
            } while (System.currentTimeMillis() - start2 <= timeoutMillis);
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
            assert (false) : ie;
        }
        catch (ExecutionException ie) {
            ie.printStackTrace();
            assert (false) : ie;
        }
        finally {
            currentThread.exitSleep();
        }
        if (this.exitingException != null) {
            if (this.exitingException instanceof RaiseException) {
                RaiseException raiseException = (RaiseException)this.exitingException;
                runtime2.getGlobalVariables().set("$!", raiseException.getException());
            } else {
                runtime2.getGlobalVariables().set("$!", JavaUtil.convertJavaToUsableRubyObject(runtime2, this.exitingException));
            }
            Helpers.throwException(this.exitingException);
        }
        currentThread.pollThreadEvents(context);
        if (this.threadImpl.isAlive()) {
            return context.nil;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod
    public IRubyObject value() {
        this.join(this.getRuntime().getCurrentContext(), NULL_ARRAY);
        RubyThread rubyThread = this;
        synchronized (rubyThread) {
            return this.finalResult;
        }
    }

    @JRubyMethod
    public IRubyObject group() {
        if (this.threadGroup == null) {
            return this.getRuntime().getNil();
        }
        return this.threadGroup;
    }

    void setThreadGroup(RubyThreadGroup rubyThreadGroup) {
        this.threadGroup = rubyThreadGroup;
    }

    @Override
    @JRubyMethod
    public synchronized IRubyObject inspect() {
        RubyString result2 = this.getRuntime().newString("#<");
        Ruby runtime2 = this.getRuntime();
        ThreadContext context = runtime2.getCurrentContext();
        result2.cat(this.getMetaClass().getRealClass().toRubyString(context));
        result2.cat(58);
        result2.catString(this.identityString());
        String id2 = this.threadImpl.getRubyName();
        if (this.notEmpty(id2)) {
            result2.cat(64);
            result2.append(this.getRuntime().newSymbol(id2).to_s());
        }
        if (this.notEmpty(this.file) && this.line >= 0) {
            result2.cat(64);
            result2.catString(this.file);
            result2.cat(58);
            result2.catString("" + (this.line + 1));
        }
        result2.cat(32);
        result2.catString(this.status.toString().toLowerCase());
        result2.cat(62);
        return result2;
    }

    private boolean notEmpty(String str) {
        return str != null && str.length() > 0;
    }

    @JRubyMethod(name={"key?"}, required=1)
    public RubyBoolean key_p(IRubyObject key2) {
        key2 = this.getSymbolKey(key2);
        return this.getRuntime().newBoolean(this.getFiberLocals().containsKey(key2));
    }

    @JRubyMethod
    public RubyArray keys() {
        IRubyObject[] keys2 = new IRubyObject[this.getFiberLocals().size()];
        return RubyArray.newArrayMayCopy(this.getRuntime(), this.getFiberLocals().keySet().toArray(keys2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(meta=true)
    public static IRubyObject stop(ThreadContext context, IRubyObject receiver2) {
        RubyThread rubyThread = context.getThread();
        if (context.runtime.getThreadService().getActiveRubyThreads().length == 1) {
            throw context.runtime.newThreadError("stopping only thread\n\tnote: use sleep to stop forever");
        }
        RubyThread rubyThread2 = rubyThread;
        synchronized (rubyThread2) {
            rubyThread.pollThreadEvents(context);
            Status oldStatus = rubyThread.status.get();
            try {
                rubyThread.status.set(Status.SLEEP);
                rubyThread.wait();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                rubyThread.pollThreadEvents(context);
                rubyThread.status.set(oldStatus);
            }
        }
        return context.nil;
    }

    @JRubyMethod(required=1, meta=true)
    public static IRubyObject kill(IRubyObject receiver2, IRubyObject rubyThread, Block block) {
        if (!(rubyThread instanceof RubyThread)) {
            throw receiver2.getRuntime().newTypeError(rubyThread, receiver2.getRuntime().getThread());
        }
        return ((RubyThread)rubyThread).kill();
    }

    @JRubyMethod(meta=true)
    public static IRubyObject exit(IRubyObject receiver2, Block block) {
        RubyThread rubyThread = receiver2.getRuntime().getThreadService().getCurrentContext().getThread();
        return rubyThread.kill();
    }

    @JRubyMethod(name={"stop?"})
    public RubyBoolean stop_p() {
        return this.getRuntime().newBoolean(this.status.get() == Status.SLEEP || this.status.get() == Status.DEAD);
    }

    @JRubyMethod
    public synchronized RubyThread wakeup() {
        if (!this.threadImpl.isAlive() && this.status.get() == Status.DEAD) {
            throw this.getRuntime().newThreadError("killed thread");
        }
        this.status.set(Status.RUN);
        this.interrupt();
        return this;
    }

    @JRubyMethod
    public RubyFixnum priority() {
        return RubyFixnum.newFixnum(this.getRuntime(), RubyThread.javaPriorityToRubyPriority(this.threadImpl.getPriority()));
    }

    @JRubyMethod(name={"priority="}, required=1)
    public IRubyObject priority_set(IRubyObject priority2) {
        int iPriority = RubyNumeric.fix2int(priority2);
        if (iPriority < -3) {
            iPriority = -3;
        } else if (iPriority > 3) {
            iPriority = 3;
        }
        if (this.threadImpl.isAlive()) {
            int jPriority = RubyThread.rubyPriorityToJavaPriority(iPriority);
            if (jPriority < 1) {
                jPriority = 1;
            } else if (jPriority > 10) {
                jPriority = 10;
            }
            this.threadImpl.setPriority(jPriority);
        }
        return RubyFixnum.newFixnum(this.getRuntime(), iPriority);
    }

    public static int javaPriorityToRubyPriority(int javaPriority) {
        double d = 1.5 * Math.sqrt(8.0 * (double)javaPriority + 41.0) - 13.5;
        return Math.round((float)d);
    }

    public static int rubyPriorityToJavaPriority(int rubyPriority) {
        double d = (double)(rubyPriority * rubyPriority) / 18.0 + 1.5 * (double)rubyPriority + 5.0;
        return Math.round((float)d);
    }

    public final IRubyObject raise(IRubyObject exception2) {
        return this.raise(new IRubyObject[]{exception2}, Block.NULL_BLOCK);
    }

    public final IRubyObject raise(IRubyObject exception2, RubyString message2) {
        return this.raise(new IRubyObject[]{exception2, message2}, Block.NULL_BLOCK);
    }

    @JRubyMethod(optional=3)
    public IRubyObject raise(IRubyObject[] args2, Block block) {
        Ruby runtime2 = this.getRuntime();
        RubyThread currentThread = runtime2.getCurrentContext().getThread();
        return this.genericRaise(runtime2, args2, currentThread);
    }

    public IRubyObject genericRaise(Ruby runtime2, IRubyObject[] args2, RubyThread currentThread) {
        if (!this.isAlive()) {
            return runtime2.getNil();
        }
        if (currentThread == this) {
            RubyKernel.raise(runtime2.getCurrentContext(), runtime2.getKernel(), args2, Block.NULL_BLOCK);
        }
        IRubyObject exception2 = this.prepareRaiseException(runtime2, args2, Block.NULL_BLOCK);
        this.pendingInterruptEnqueue(exception2);
        this.interrupt();
        return runtime2.getNil();
    }

    private IRubyObject prepareRaiseException(Ruby runtime2, IRubyObject[] args2, Block block) {
        IRubyObject cause2;
        IRubyObject tmp;
        if (args2.length == 0) {
            if (this.errorInfo.isNil()) {
                return RaiseException.from(runtime2, runtime2.getRuntimeError(), "").getException();
            }
            return this.errorInfo;
        }
        ThreadContext context = runtime2.getCurrentContext();
        IRubyObject arg2 = args2[0];
        if (args2.length == 1) {
            if (arg2 instanceof RubyString) {
                tmp = runtime2.getRuntimeError().newInstance(context, args2, block);
            } else {
                if (arg2 instanceof ConcreteJavaProxy) {
                    return arg2;
                }
                if (!arg2.respondsTo("exception")) {
                    throw runtime2.newTypeError("exception class/object expected");
                }
                tmp = arg2.callMethod(context, "exception");
            }
        } else {
            if (!arg2.respondsTo("exception")) {
                throw runtime2.newTypeError("exception class/object expected");
            }
            tmp = arg2.callMethod(context, "exception", args2[1]);
        }
        if (!runtime2.getException().isInstance(tmp)) {
            throw runtime2.newTypeError("exception object expected");
        }
        RubyException exception2 = (RubyException)tmp;
        if (args2.length == 3) {
            exception2.set_backtrace(args2[2]);
        }
        if ((cause2 = context.getErrorInfo()) != exception2) {
            exception2.setCause(cause2);
        }
        return exception2;
    }

    @JRubyMethod
    public synchronized IRubyObject run() {
        return this.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sleep(long millis) throws InterruptedException {
        assert (this == this.getRuntime().getCurrentContext().getThread());
        this.sleepTask.millis = millis;
        try {
            long timeSlept = this.executeTask(this.getContext(), null, this.sleepTask);
            if (millis == 0L || timeSlept >= millis) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.sleepTask.semaphore.drainPermits();
        }
    }

    public IRubyObject status() {
        return this.status(this.getRuntime());
    }

    @JRubyMethod
    public IRubyObject status(ThreadContext context) {
        return this.status(context.runtime);
    }

    private synchronized IRubyObject status(Ruby runtime2) {
        if (this.threadImpl.isAlive()) {
            Status status2 = this.status.get();
            if (status2 == Status.DEAD) {
                return runtime2.getFalse();
            }
            return runtime2.getThreadStatus(status2);
        }
        if (this.exitingException != null) {
            return runtime2.getNil();
        }
        return runtime2.getFalse();
    }

    @Deprecated
    public void executeBlockingTask(BlockingTask task) throws InterruptedException {
        try {
            this.currentBlockingTask = task;
            this.enterSleep();
            this.pollThreadEvents();
            task.run();
        }
        finally {
            this.exitSleep();
            this.currentBlockingTask = null;
            this.pollThreadEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <Data, Return> Return executeTask(ThreadContext context, Data data2, Task<Data, Return> task) throws InterruptedException {
        try {
            this.unblockArg = data2;
            this.unblockFunc = task;
            this.pollThreadEvents(context);
            this.enterSleep();
            Return Return = task.run(context, data2);
            return Return;
        }
        finally {
            this.exitSleep();
            this.unblockFunc = null;
            this.unblockArg = null;
            this.pollThreadEvents(context);
        }
    }

    public void enterSleep() {
        this.status.set(Status.SLEEP);
    }

    public void exitSleep() {
        if (this.status.get() != Status.ABORTING) {
            this.status.set(Status.RUN);
        }
    }

    @JRubyMethod(name={"kill", "exit", "terminate"})
    public IRubyObject kill() {
        Ruby runtime2 = this.getRuntime();
        RubyThread currentThread = runtime2.getCurrentContext().getThread();
        if (currentThread == runtime2.getThreadService().getMainThread()) {
            // empty if block
        }
        this.status.set(Status.ABORTING);
        return this.genericKill(runtime2, currentThread);
    }

    private IRubyObject genericKill(Ruby runtime2, RubyThread currentThread) {
        if (currentThread == this) {
            RubyThread.throwThreadKill();
        }
        this.pendingInterruptEnqueue(RubyFixnum.zero(runtime2));
        this.interrupt();
        return this;
    }

    private void pendingInterruptEnqueue(IRubyObject v) {
        this.pendingInterruptQueue.add(v);
        this.pendingInterruptQueueChecked = false;
    }

    public void dieFromFinalizer() {
        this.genericKill(this.getRuntime(), null);
    }

    @JRubyMethod
    public IRubyObject safe_level() {
        throw this.getRuntime().newNotImplementedError("Thread-specific SAFE levels are not supported");
    }

    @JRubyMethod(name={"backtrace"})
    public IRubyObject backtrace(ThreadContext context) {
        return this.backtraceInternal(context, null, null);
    }

    @JRubyMethod(name={"backtrace"})
    public IRubyObject backtrace(ThreadContext context, IRubyObject level2) {
        return this.backtraceInternal(context, level2, null);
    }

    @JRubyMethod(name={"backtrace"})
    public IRubyObject backtrace(ThreadContext context, IRubyObject level2, IRubyObject length2) {
        return this.backtraceInternal(context, level2, length2);
    }

    private IRubyObject backtraceInternal(ThreadContext context, IRubyObject level2, IRubyObject length2) {
        ThreadContext myContext = this.getContext();
        Thread nativeThread = this.getNativeThread();
        if (myContext == null || nativeThread == null || !nativeThread.isAlive()) {
            return context.nil;
        }
        Integer[] ll = RubyKernel.levelAndLengthFromArgs(context, level2, length2, 0);
        Integer levelInt = ll[0];
        Integer lengthInt = ll[1];
        return myContext.createCallerBacktrace(levelInt, lengthInt, this.getNativeThread().getStackTrace());
    }

    @JRubyMethod
    public IRubyObject backtrace_locations(ThreadContext context) {
        return this.backtraceLocationsInternal(context, null, null);
    }

    @JRubyMethod
    public IRubyObject backtrace_locations(ThreadContext context, IRubyObject level2) {
        return this.backtraceLocationsInternal(context, level2, null);
    }

    @JRubyMethod
    public IRubyObject backtrace_locations(ThreadContext context, IRubyObject level2, IRubyObject length2) {
        return this.backtraceLocationsInternal(context, level2, length2);
    }

    private IRubyObject backtraceLocationsInternal(ThreadContext context, IRubyObject level2, IRubyObject length2) {
        ThreadContext myContext = this.getContext();
        Thread nativeThread = this.getNativeThread();
        if (myContext == null || nativeThread == null || !nativeThread.isAlive()) {
            return context.nil;
        }
        Integer[] ll = RubyKernel.levelAndLengthFromArgs(context, level2, length2, 0);
        Integer levelInt = ll[0];
        Integer lengthInt = ll[1];
        return myContext.createCallerLocations(levelInt, lengthInt, this.getNativeThread().getStackTrace());
    }

    @JRubyMethod(name={"report_on_exception="})
    public IRubyObject report_on_exception_set(ThreadContext context, IRubyObject state2) {
        this.reportOnException = state2.isNil() ? state2 : context.runtime.newBoolean(state2.isTrue());
        return this;
    }

    @JRubyMethod(name={"report_on_exception"})
    public IRubyObject report_on_exception(ThreadContext context) {
        return this.reportOnException;
    }

    @JRubyMethod(name={"report_on_exception="}, meta=true)
    public static IRubyObject report_on_exception_set(ThreadContext context, IRubyObject self2, IRubyObject state2) {
        Ruby runtime2 = context.runtime;
        if (state2.isNil()) {
            runtime2.setReportOnException(state2);
        } else {
            runtime2.setReportOnException(runtime2.newBoolean(state2.isTrue()));
        }
        return self2;
    }

    @JRubyMethod(name={"report_on_exception"}, meta=true)
    public static IRubyObject report_on_exception(ThreadContext context, IRubyObject self2) {
        return context.runtime.getReportOnException();
    }

    public StackTraceElement[] javaBacktrace() {
        if (this.threadImpl instanceof NativeThread) {
            return ((NativeThread)this.threadImpl).getThread().getStackTrace();
        }
        return BacktraceData.EMPTY_STACK_TRACE;
    }

    private boolean isCurrent() {
        return this.threadImpl.isCurrent();
    }

    public void exceptionRaised(RaiseException exception2) {
        this.exceptionRaised((Throwable)exception2);
    }

    protected void printReportExceptionWarning() {
        Ruby runtime2 = this.getRuntime();
        String name2 = this.threadImpl.getReportName();
        runtime2.getErrorStream().println("warning: thread \"" + name2 + "\" terminated with exception (report_on_exception is true):");
    }

    public void exceptionRaised(Throwable throwable) {
        IRubyObject rubyException;
        if (throwable instanceof Unrescuable) {
            Helpers.throwException(throwable);
        }
        Ruby runtime2 = this.getRuntime();
        assert (this.isCurrent());
        if (throwable instanceof RaiseException) {
            RaiseException exception2 = (RaiseException)throwable;
            rubyException = exception2.getException();
        } else {
            rubyException = JavaUtil.convertJavaToUsableRubyObject(runtime2, throwable);
        }
        if (runtime2.getSystemExit().isInstance(rubyException)) {
            runtime2.getThreadService().getMainThread().raise(rubyException);
        } else if (this.abortOnException(runtime2) || this.reportOnException.isTrue()) {
            if (this.reportOnException.isTrue()) {
                this.printReportExceptionWarning();
                runtime2.printError(throwable);
            }
            if (this.abortOnException(runtime2)) {
                runtime2.getThreadService().getMainThread().raise(rubyException);
            }
        } else if (runtime2.isDebug()) {
            runtime2.printError(throwable);
        }
        this.exitingException = throwable;
    }

    private boolean abortOnException(Ruby runtime2) {
        return runtime2.isGlobalAbortOnExceptionEnabled() || this.abortOnException;
    }

    public static RubyThread mainThread(IRubyObject receiver2) {
        return receiver2.getRuntime().getThreadService().getMainThread();
    }

    public boolean select(RubyIO io2, int ops) {
        return this.select(io2.getChannel(), io2.getOpenFile(), ops);
    }

    public boolean select(RubyIO io2, int ops, long timeout2) {
        return this.select(io2.getChannel(), io2.getOpenFile(), ops, timeout2);
    }

    public boolean select(Channel channel, OpenFile fptr, int ops) {
        return this.select(channel, fptr, ops, -1L);
    }

    public boolean select(Channel channel, RubyIO io2, int ops) {
        return this.select(channel, io2 == null ? null : io2.getOpenFile(), ops, -1L);
    }

    public boolean select(Channel channel, RubyIO io2, int ops, long timeout2) {
        return this.select(channel, io2 == null ? null : io2.getOpenFile(), ops, timeout2);
    }

    /*
     * Exception decompiling
     */
    public boolean select(Channel channel, OpenFile fptr, int ops, long timeout) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public synchronized void interrupt() {
        BlockingTask t;
        Unblocker task;
        BlockingIO.Condition iowait;
        this.setInterrupt();
        Selector activeSelector = this.currentSelector;
        if (activeSelector != null) {
            activeSelector.wakeup();
        }
        if ((iowait = this.blockingIO) != null) {
            iowait.cancel();
        }
        if ((task = this.unblockFunc) != null) {
            task.wakeup(this, this.unblockArg);
        }
        if ((t = this.currentBlockingTask) != null) {
            t.wakeup();
        }
        this.notify();
    }

    public void setInterrupt() {
        int oldFlag;
        while (!INTERRUPT_FLAG_UPDATER.compareAndSet(this, oldFlag = this.interruptFlag, oldFlag | 2)) {
        }
    }

    public boolean waitForIO(ThreadContext context, RubyIO io2, int ops) {
        Channel channel = io2.getChannel();
        if (!(channel instanceof SelectableChannel)) {
            return true;
        }
        try {
            io2.addBlockingThread(this);
            this.blockingIO = BlockingIO.newCondition(channel, ops);
            boolean ready2 = this.blockingIO.await();
            this.pollThreadEvents();
            boolean bl = ready2;
            return bl;
        }
        catch (IOException ioe) {
            throw context.runtime.newRuntimeError("Error with selector: " + ioe);
        }
        catch (InterruptedException ex) {
            throw context.runtime.newRuntimeError("Interrupted");
        }
        finally {
            this.blockingIO = null;
            io2.removeBlockingThread(this);
        }
    }

    public void beforeBlockingCall() {
        this.pollThreadEvents();
        this.enterSleep();
    }

    public void afterBlockingCall() {
        this.exitSleep();
        this.pollThreadEvents();
    }

    public boolean wait_timeout(IRubyObject o, Double timeout2) throws InterruptedException {
        if (timeout2 != null) {
            long end_ns;
            long delay_ns = (long)(timeout2 * 1.0E9);
            long start_ns = System.nanoTime();
            if (delay_ns > 0L) {
                long delay_ms = delay_ns / 1000000L;
                int delay_ns_remainder = (int)(delay_ns % 1000000L);
                this.executeBlockingTask(new SleepTask(o, delay_ms, delay_ns_remainder));
            }
            return (end_ns = System.nanoTime()) - start_ns <= delay_ns;
        }
        this.executeBlockingTask(new SleepTask(o, 0L, 0));
        return true;
    }

    public RubyThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RubyThread other = (RubyThread)obj;
        return this.threadImpl == other.threadImpl || this.threadImpl != ThreadLike.DUMMY && this.threadImpl.equals(other.threadImpl);
    }

    @Override
    public int hashCode() {
        return 291 + (this.threadImpl != ThreadLike.DUMMY ? this.threadImpl.hashCode() : 0);
    }

    @Override
    public String toString() {
        return this.threadImpl.toString();
    }

    public void lock(Lock lock2) {
        assert (Thread.currentThread() == this.getNativeThread());
        lock2.lock();
        this.heldLocks.add(lock2);
    }

    public void lockInterruptibly(Lock lock2) throws InterruptedException {
        assert (Thread.currentThread() == this.getNativeThread());
        lock2.lockInterruptibly();
        this.heldLocks.add(lock2);
    }

    public boolean tryLock(Lock lock2) {
        assert (Thread.currentThread() == this.getNativeThread());
        boolean locked = lock2.tryLock();
        if (locked) {
            this.heldLocks.add(lock2);
        }
        return locked;
    }

    public void unlock(Lock lock2) {
        assert (Thread.currentThread() == this.getNativeThread());
        lock2.unlock();
        this.heldLocks.remove(lock2);
    }

    public void unlockAll() {
        assert (Thread.currentThread() == this.getNativeThread());
        for (Lock lock2 : this.heldLocks) {
            lock2.unlock();
        }
    }

    private String identityString() {
        return "0x" + Integer.toHexString(System.identityHashCode(this));
    }

    @Deprecated
    @JRubyMethod(meta=true)
    public static IRubyObject exclusive(ThreadContext context, IRubyObject recv2, Block block) {
        recv2.callMethod(context, "warn", context.runtime.newString("Thread.exclusive is deprecated, use Thread::Mutex"));
        return RubyThread.getMutexForThreadExclusive(context, (RubyClass)recv2).synchronize(context, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Mutex getMutexForThreadExclusive(ThreadContext context, RubyClass recv2) {
        Mutex mutex = (Mutex)recv2.getConstantNoConstMissing(MUTEX_FOR_THREAD_EXCLUSIVE, false, false);
        if (mutex != null) {
            return mutex;
        }
        RubyClass rubyClass = recv2;
        synchronized (rubyClass) {
            mutex = (Mutex)recv2.getConstantNoConstMissing(MUTEX_FOR_THREAD_EXCLUSIVE, false, false);
            if (mutex == null) {
                mutex = Mutex.newInstance(context, context.runtime.getThread().getClass("Mutex"), NULL_ARRAY, Block.NULL_BLOCK);
                recv2.setConstant(MUTEX_FOR_THREAD_EXCLUSIVE, mutex, true);
            }
            return mutex;
        }
    }

    @Deprecated
    public void internalRaise(IRubyObject[] args2) {
        Ruby runtime2 = this.getRuntime();
        this.genericRaise(runtime2, args2, runtime2.getCurrentContext().getThread());
    }

    @Deprecated
    public void receiveMail(ThreadService.Event event2) {
    }

    @Deprecated
    public void checkMail(ThreadContext context) {
    }

    @Deprecated
    public boolean selectForAccept(RubyIO io2) {
        return this.select(io2, 16);
    }

    @Deprecated
    public IRubyObject backtrace20(ThreadContext context, IRubyObject[] args2) {
        return this.backtrace(context);
    }

    @Deprecated
    public IRubyObject backtrace(ThreadContext context, IRubyObject[] args2) {
        switch (args2.length) {
            case 0: {
                return this.backtrace(context);
            }
            case 1: {
                return this.backtrace(context, args2[0]);
            }
            case 2: {
                return this.backtrace(context, args2[0], args2[1]);
            }
        }
        Arity.checkArgumentCount(context.runtime, args2, 0, 2);
        return null;
    }

    @Deprecated
    public IRubyObject backtrace_locations(ThreadContext context, IRubyObject[] args2) {
        switch (args2.length) {
            case 0: {
                return this.backtrace_locations(context);
            }
            case 1: {
                return this.backtrace_locations(context, args2[0]);
            }
            case 2: {
                return this.backtrace_locations(context, args2[0], args2[1]);
            }
        }
        Arity.checkArgumentCount(context.runtime, args2, 0, 2);
        return null;
    }

    @Deprecated
    public static IRubyObject pass(IRubyObject recv2) {
        Ruby runtime2 = recv2.getRuntime();
        return RubyThread.pass(runtime2.getCurrentContext(), recv2);
    }

    private static class SleepTask2
    implements Task<Object, Long> {
        final Semaphore semaphore = new Semaphore(1);
        long millis;

        private SleepTask2() {
            this.semaphore.drainPermits();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Long run(ThreadContext context, Object data2) throws InterruptedException {
            long start2 = System.currentTimeMillis();
            try {
                if (this.millis == 0L) {
                    this.semaphore.tryAcquire(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
                } else {
                    this.semaphore.tryAcquire(this.millis, TimeUnit.MILLISECONDS);
                }
                Long l = System.currentTimeMillis() - start2;
                return l;
            }
            finally {
                this.semaphore.drainPermits();
            }
        }

        @Override
        public void wakeup(RubyThread thread2, Object data2) {
            this.semaphore.release();
        }
    }

    public static final class SleepTask
    implements BlockingTask {
        private final Object object;
        private final long millis;
        private final int nanos;

        public SleepTask(Object object, long millis, int nanos) {
            this.object = object;
            this.millis = millis;
            this.nanos = nanos;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() throws InterruptedException {
            Object object = this.object;
            synchronized (object) {
                this.object.wait(this.millis, this.nanos);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void wakeup() {
            Object object = this.object;
            synchronized (object) {
                this.object.notify();
            }
        }
    }

    public static interface Task<Data, Return>
    extends Unblocker<Data> {
        public Return run(ThreadContext var1, Data var2) throws InterruptedException;

        @Override
        public void wakeup(RubyThread var1, Data var2);
    }

    public static interface Unblocker<Data> {
        public void wakeup(RubyThread var1, Data var2);
    }

    @Deprecated
    public static interface BlockingTask {
        public void run() throws InterruptedException;

        public void wakeup();
    }

    public static class Location
    extends RubyObject {
        private final RubyStackTraceElement element;
        private transient RubyString baseLabel = null;
        private transient RubyString label = null;

        public Location(Ruby runtime2, RubyClass klass, RubyStackTraceElement element) {
            super(runtime2, klass);
            this.element = element;
        }

        @JRubyMethod
        public IRubyObject absolute_path(ThreadContext context) {
            return context.runtime.newString(this.element.getFileName());
        }

        @JRubyMethod
        public IRubyObject base_label(ThreadContext context) {
            if (this.baseLabel == null) {
                this.baseLabel = context.runtime.newString(this.element.getMethodName());
            }
            return this.baseLabel;
        }

        @JRubyMethod
        public IRubyObject inspect(ThreadContext context) {
            return this.to_s(context).inspect();
        }

        @JRubyMethod
        public IRubyObject label(ThreadContext context) {
            if (this.element.getFrameType() == FrameType.BLOCK) {
                if (this.label == null) {
                    this.label = context.runtime.newString("block in " + this.element.getMethodName());
                }
                return this.label;
            }
            return this.base_label(context);
        }

        @JRubyMethod
        public IRubyObject lineno(ThreadContext context) {
            return context.runtime.newFixnum(this.element.getLineNumber());
        }

        @JRubyMethod
        public IRubyObject path(ThreadContext context) {
            return context.runtime.newString(this.element.getFileName());
        }

        @JRubyMethod
        public IRubyObject to_s(ThreadContext context) {
            return RubyStackTraceElement.to_s_mri(context, this.element);
        }

        public static RubyArray newLocationArray(Ruby runtime2, RubyStackTraceElement[] elements) {
            return Location.newLocationArray(runtime2, elements, 0, elements.length);
        }

        public static RubyArray newLocationArray(Ruby runtime2, RubyStackTraceElement[] elements, int offset2, int length2) {
            RubyClass locationClass = runtime2.getLocation();
            IRubyObject[] ary = new IRubyObject[length2];
            for (int i2 = 0; i2 < length2; ++i2) {
                ary[i2] = new Location(runtime2, locationClass, elements[i2 + offset2]);
            }
            return RubyArray.newArrayNoCopy(runtime2, ary);
        }
    }

    public static enum Status {
        RUN,
        SLEEP,
        ABORTING,
        DEAD;

        public final ByteList bytes = new ByteList(this.toString().toLowerCase().getBytes(RubyEncoding.UTF8));
    }
}

