/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime;

import java.util.ArrayList;
import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.IRMethodArgs;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRScope;
import org.jruby.ir.instructions.GetFieldInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.PutFieldInstr;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.ArgumentDescriptor;
import org.jruby.runtime.Arity;
import org.jruby.runtime.PositionAware;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.ivars.MethodData;
import org.jruby.util.cli.Options;

public abstract class AbstractIRMethod
extends DynamicMethod
implements IRMethodArgs,
PositionAware,
Cloneable {
    protected final Signature signature;
    protected final IRScope method;
    protected final StaticScope staticScope;
    protected InterpreterContext interpreterContext = null;
    protected int callCount = 0;
    private MethodData methodData;

    public AbstractIRMethod(IRScope method2, Visibility visibility, RubyModule implementationClass) {
        super(implementationClass, visibility, method2.getId());
        this.method = method2;
        this.staticScope = method2.getStaticScope();
        this.staticScope.determineModule();
        this.signature = this.staticScope.getSignature();
        if ((Integer)Options.JIT_THRESHOLD.load() == -1) {
            this.callCount = -1;
        }
        if (IRRuntimeHelpers.shouldPrintIR(implementationClass.getRuntime())) {
            this.ensureInstrsReady();
        }
    }

    public IRScope getIRScope() {
        return this.method;
    }

    public void setCallCount(int callCount) {
        this.callCount = callCount;
    }

    public StaticScope getStaticScope() {
        return this.staticScope;
    }

    @Override
    public ArgumentDescriptor[] getArgumentDescriptors() {
        this.ensureInstrsReady();
        return ((IRMethod)this.method).getArgumentDescriptors();
    }

    public abstract InterpreterContext ensureInstrsReady();

    @Override
    public Signature getSignature() {
        return this.signature;
    }

    @Override
    public Arity getArity() {
        return this.signature.arity();
    }

    @Override
    public DynamicMethod dup() {
        return (DynamicMethod)this.clone();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new RuntimeException("not cloneable: " + this);
        }
    }

    public String getClassName(ThreadContext context) {
        return null;
    }

    @Override
    public String getFile() {
        return this.method.getFile();
    }

    @Override
    public int getLine() {
        return this.method.getLine();
    }

    @Override
    public MethodData getMethodData() {
        if (this.methodData == null) {
            ArrayList<String> ivarNames = new ArrayList<String>();
            InterpreterContext context = this.ensureInstrsReady();
            block4: for (Instr i2 : context.getInstructions()) {
                switch (i2.getOperation()) {
                    case GET_FIELD: {
                        ivarNames.add(((GetFieldInstr)i2).getId());
                        continue block4;
                    }
                    case PUT_FIELD: {
                        ivarNames.add(((PutFieldInstr)i2).getId());
                    }
                }
            }
            this.methodData = new MethodData(this.method.getId(), this.method.getFile(), ivarNames);
        }
        return this.methodData;
    }
}

