/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.io;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.channels.Pipe;
import jnr.constants.platform.Errno;
import jnr.constants.platform.Fcntl;
import jnr.posix.FileStat;
import jnr.posix.POSIX;
import org.jruby.Ruby;
import org.jruby.platform.Platform;
import org.jruby.runtime.Helpers;
import org.jruby.util.JRubyFile;
import org.jruby.util.ResourceException;
import org.jruby.util.io.ChannelFD;
import org.jruby.util.io.FilenoUtil;
import org.jruby.util.io.ModeFlags;

public class PosixShim {
    public static final int LOCK_SH = 1;
    public static final int LOCK_EX = 2;
    public static final int LOCK_NB = 4;
    public static final int LOCK_UN = 8;
    public static final int SEEK_SET = 0;
    public static final int SEEK_CUR = 1;
    public static final int SEEK_END = 2;
    private static final int NATIVE_EOF = 0;
    private static final int JAVA_EOF = -1;
    public static final WaitMacros WAIT_MACROS = Platform.IS_BSD ? new BSDWaitMacros() : new LinuxWaitMacros();
    public Throwable error;
    public Errno errno;
    public String errmsg;
    private final POSIX posix;
    private final Ruby runtime;
    private static final Object _umaskLock = new Object();
    private static int _cachedUmask = 0;

    public PosixShim(Ruby runtime2) {
        this.runtime = runtime2;
        this.posix = runtime2.getPosix();
    }

    public long lseek(ChannelFD fd, long offset2, int type2) {
        this.clear();
        if (fd.chSeek != null) {
            int adj = 0;
            try {
                switch (type2) {
                    case 0: {
                        return fd.chSeek.position(offset2).position();
                    }
                    case 1: {
                        return fd.chSeek.position(fd.chSeek.position() - (long)adj + offset2).position();
                    }
                    case 2: {
                        return fd.chSeek.position(fd.chSeek.size() + offset2).position();
                    }
                }
                this.errno = Errno.EINVAL;
                return -1L;
            }
            catch (IllegalArgumentException e) {
                this.errno = Errno.EINVAL;
                return -1L;
            }
            catch (IOException ioe) {
                this.errno = Helpers.errnoFromException(ioe);
                return -1L;
            }
        }
        if (fd.chNative != null) {
            long ret = this.posix.lseekLong(fd.chNative.getFD(), offset2, type2);
            if (ret == -1L) {
                this.errno = Errno.valueOf((long)this.posix.errno());
            }
            return ret;
        }
        if (fd.chSelect != null) {
            this.errno = Errno.EPIPE;
            return -1L;
        }
        return 0L;
    }

    public int write(ChannelFD fd, byte[] bytes2, int offset2, int length2, boolean nonblock) {
        this.clear();
        ByteBuffer tmp = ByteBuffer.wrap(bytes2, offset2, length2);
        try {
            if (nonblock) {
                // empty if block
            }
            if (fd.chWrite == null) {
                this.errno = Errno.EACCES;
                return -1;
            }
            int written = fd.chWrite.write(tmp);
            if (written == 0 && length2 > 0 && nonblock) {
                this.errno = Errno.EAGAIN;
                return -1;
            }
            return written;
        }
        catch (IOException ioe) {
            this.errno = Helpers.errnoFromException(ioe);
            this.error = ioe;
            return -1;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read(ChannelFD fd, byte[] target, int offset2, int length2, boolean nonblock) {
        this.clear();
        try {
            if (nonblock && fd.chSelect == null) {
                if (fd.chFile != null) {
                    long position = fd.chFile.position();
                    long size2 = fd.chFile.size();
                    if (position == -1L || size2 == -1L || position >= size2) {
                        this.errno = Errno.EAGAIN;
                        return -1;
                    }
                } else if (fd.chNative == null || !fd.isNativeFile) {
                    this.errno = Errno.EAGAIN;
                    return -1;
                }
            }
            ByteBuffer buffer = ByteBuffer.wrap(target, offset2, length2);
            int read2 = fd.chRead.read(buffer);
            if (nonblock) {
                if (read2 == -1) {
                    return 0;
                }
                if (read2 != 0) return read2;
                this.errno = Errno.EAGAIN;
                return -1;
            }
            if (read2 != -1) return read2;
            return 0;
        }
        catch (IOException ioe) {
            this.errno = Helpers.errnoFromException(ioe);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int flock(ChannelFD fd, int lockMode) {
        Channel channel = fd.ch;
        this.clear();
        int real_fd = fd.realFileno;
        if (real_fd != -1 && real_fd < 100000 && !Platform.IS_SOLARIS) {
            int result2 = this.posix.flock(real_fd, lockMode);
            if (result2 < 0) {
                this.errno = Errno.valueOf((long)this.posix.errno());
                return -1;
            }
            return 0;
        }
        if (fd.chFile != null) {
            int ret = this.checkSharedExclusive(fd, lockMode);
            if (ret < 0) {
                return ret;
            }
            if (!PosixShim.lockStateChanges(fd.currentLock, lockMode)) {
                return 0;
            }
            try {
                FileChannel fileChannel = fd.chFile;
                synchronized (fileChannel) {
                    if (!PosixShim.lockStateChanges(fd.currentLock, lockMode)) {
                        return 0;
                    }
                    switch (lockMode) {
                        case 8: 
                        case 12: {
                            return this.unlock(fd);
                        }
                        case 2: {
                            return this.lock(fd, true);
                        }
                        case 6: {
                            return this.tryLock(fd, true);
                        }
                        case 1: {
                            return this.lock(fd, false);
                        }
                        case 5: {
                            return this.tryLock(fd, false);
                        }
                    }
                }
            }
            catch (IOException ioe) {
                this.errno = Helpers.errnoFromException(ioe);
                return -1;
            }
            catch (OverlappingFileLockException ioe) {
                this.errno = Errno.EINVAL;
                this.errmsg = "overlapping file locks";
            }
            return PosixShim.lockFailedReturn(lockMode);
        }
        this.errno = Errno.EINVAL;
        this.errmsg = "stream is not a file";
        return -1;
    }

    public int dup2(ChannelFD filedes, ChannelFD filedes2) {
        return filedes2.dup2From(this.posix, filedes);
    }

    public int close(ChannelFD fd) {
        return this.close((Closeable)fd);
    }

    public int close(Closeable closeable) {
        this.clear();
        try {
            closeable.close();
            return 0;
        }
        catch (IOException ioe) {
            Errno errno2 = Helpers.errnoFromException(ioe);
            if (errno2 == null) {
                throw new RuntimeException("unknown IOException: " + ioe);
            }
            this.errno = errno2;
            return -1;
        }
    }

    public Channel[] pipe() {
        this.clear();
        try {
            Pipe pipe2 = Pipe.open();
            Pipe.SourceChannel source2 = pipe2.source();
            Pipe.SinkChannel sink = pipe2.sink();
            if (this.posix.isNative() && !Platform.IS_WINDOWS) {
                int read2 = FilenoUtil.filenoFrom(source2);
                int write2 = FilenoUtil.filenoFrom(sink);
                this.setCloexec(read2, true);
                this.setCloexec(write2, true);
            }
            return new Channel[]{source2, sink};
        }
        catch (IOException ioe) {
            this.errno = Helpers.errnoFromException(ioe);
            return null;
        }
    }

    public int setCloexec(int fd, boolean cloexec) {
        int ret = this.posix.fcntl(fd, Fcntl.F_GETFD);
        if (ret == -1) {
            this.errno = Errno.valueOf((long)this.posix.errno());
            return -1;
        }
        if (cloexec && (ret & 1) == 1 || !cloexec && (ret & 1) == 0) {
            return 0;
        }
        ret = cloexec ? ret | 1 : ret & 0xFFFFFFFE;
        if ((ret = this.posix.fcntlInt(fd, Fcntl.F_SETFD, ret)) == -1) {
            this.errno = Errno.valueOf((long)this.posix.errno());
        }
        return ret;
    }

    public int fcntlSetFD(int fd, int flags2) {
        int ret = this.posix.fcntlInt(fd, Fcntl.F_SETFD, flags2);
        if (ret == -1) {
            this.errno = Errno.valueOf((long)this.posix.errno());
        }
        return ret;
    }

    public int fcntlGetFD(int fd) {
        int ret = this.posix.fcntl(fd, Fcntl.F_GETFD);
        return ret;
    }

    public Channel open(String cwd, String path2, int flags2, int perm) {
        if ((path2.equals("/dev/null") || path2.equalsIgnoreCase("nul")) && Platform.IS_WINDOWS) {
            path2 = "NUL:";
        }
        try {
            return JRubyFile.createResource(this.runtime, cwd, path2).openChannel(flags2, perm);
        }
        catch (ResourceException.FileExists e) {
            this.errno = Errno.EEXIST;
        }
        catch (ResourceException.FileIsDirectory e) {
            this.errno = Errno.EISDIR;
        }
        catch (ResourceException.FileIsNotDirectory e) {
            this.errno = Errno.ENOTDIR;
        }
        catch (ResourceException.NotFound e) {
            this.errno = Errno.ENOENT;
        }
        catch (ResourceException.PermissionDenied e) {
            this.errno = Errno.EACCES;
        }
        catch (ResourceException.TooManySymlinks e) {
            this.errno = Errno.ELOOP;
        }
        catch (ResourceException ex) {
            throw ex.newRaiseException(this.runtime);
        }
        catch (IOException ex) {
            throw this.runtime.newIOErrorFromException(ex);
        }
        return null;
    }

    public Channel open(String cwd, String path2, ModeFlags flags2, int perm) {
        return this.open(cwd, path2, flags2, perm);
    }

    @Deprecated
    public Channel open(String cwd, String path2, ModeFlags flags2, int perm, ClassLoader classLoader) {
        if (path2.startsWith("classpath:/") && classLoader != null) {
            path2 = path2.substring("classpath:/".length());
            return Channels.newChannel(classLoader.getResourceAsStream(path2));
        }
        return this.open(cwd, path2, flags2, perm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int umask(POSIX posix) {
        Object object = _umaskLock;
        synchronized (object) {
            int umask2 = posix.umask(_cachedUmask);
            if (_cachedUmask != umask2) {
                posix.umask(umask2);
                _cachedUmask = umask2;
            }
            return umask2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int umask(POSIX posix, int newMask) {
        int oldMask;
        Object object = _umaskLock;
        synchronized (object) {
            oldMask = posix.umask(newMask);
            _cachedUmask = newMask;
        }
        return oldMask;
    }

    public int ftruncate(ChannelFD fd, long pos2) {
        if (fd.chNative != null) {
            int ret = this.posix.ftruncate(fd.chNative.getFD(), pos2);
            if (ret == -1) {
                this.errno = Errno.valueOf((long)this.posix.errno());
            }
            return ret;
        }
        if (fd.chFile != null) {
            try {
                fd.chFile.truncate(pos2);
            }
            catch (IOException ioe) {
                this.errno = Helpers.errnoFromException(ioe);
                return -1;
            }
        } else {
            this.errno = Errno.EINVAL;
            return -1;
        }
        return 0;
    }

    public long size(ChannelFD fd) {
        if (fd.chNative != null) {
            FileStat stat2 = this.posix.allocateStat();
            int ret = this.posix.fstat(fd.chNative.getFD(), stat2);
            if (ret == -1) {
                this.errno = Errno.valueOf((long)this.posix.errno());
                return -1L;
            }
            return stat2.st_size();
        }
        if (fd.chSeek != null) {
            try {
                return fd.chSeek.size();
            }
            catch (IOException ioe) {
                this.errno = Helpers.errnoFromException(ioe);
                return -1L;
            }
        }
        this.errno = Errno.EINVAL;
        return -1L;
    }

    private void clear() {
        this.errno = null;
        this.errmsg = null;
    }

    private int checkSharedExclusive(ChannelFD fd, int lockMode) {
        if (fd.chWrite == null && (lockMode & 2) > 0) {
            this.errno = Errno.EINVAL;
            this.errmsg = "cannot acquire exclusive lock on File not opened for write";
            return -1;
        }
        if (fd.chRead == null && (lockMode & 1) > 0) {
            this.errno = Errno.EINVAL;
            this.errmsg = "cannot acquire shared lock on File not opened for read";
            return -1;
        }
        return 0;
    }

    private static int lockFailedReturn(int lockMode) {
        return (lockMode & 2) == 0 ? 0 : -1;
    }

    private static boolean lockStateChanges(FileLock lock2, int lockMode) {
        if (lock2 == null) {
            switch (lockMode & 0xF) {
                case 8: 
                case 12: {
                    return false;
                }
            }
            return true;
        }
        switch (lockMode & 0xF) {
            case 8: 
            case 12: {
                return true;
            }
            case 2: 
            case 6: {
                return lock2.isShared();
            }
            case 1: 
            case 5: {
                return !lock2.isShared();
            }
        }
        return false;
    }

    private int unlock(ChannelFD fd) throws IOException {
        if (fd.currentLock != null) {
            fd.currentLock.release();
            fd.currentLock = null;
            return 0;
        }
        return -1;
    }

    private int lock(ChannelFD fd, boolean exclusive2) throws IOException {
        if (fd.currentLock != null) {
            fd.currentLock.release();
        }
        fd.currentLock = fd.chFile.lock(0L, Long.MAX_VALUE, !exclusive2);
        if (fd.currentLock != null) {
            return 0;
        }
        return PosixShim.lockFailedReturn(exclusive2 ? 2 : 1);
    }

    private int tryLock(ChannelFD fd, boolean exclusive2) throws IOException {
        if (fd.currentLock != null) {
            fd.currentLock.release();
        }
        fd.currentLock = fd.chFile.tryLock(0L, Long.MAX_VALUE, !exclusive2);
        if (fd.currentLock != null) {
            return 0;
        }
        return PosixShim.lockFailedReturn(exclusive2 ? 2 : 1);
    }

    public static class LinuxWaitMacros
    implements WaitMacros {
        private static int __W_CONTINUED = 65535;
        private static int __WCOREFLAG = 128;

        private int __WAIT_INT(long status2) {
            return (int)status2;
        }

        private int __W_EXITCODE(int ret, int sig) {
            return ret << 8 | sig;
        }

        private int __W_STOPCODE(int sig) {
            return sig << 8 | 0x7F;
        }

        private int __WEXITSTATUS(long status2) {
            return (int)((status2 & 0xFF00L) >> 8);
        }

        private int __WTERMSIG(long status2) {
            return (int)(status2 & 0x7FL);
        }

        private int __WSTOPSIG(long status2) {
            return this.__WEXITSTATUS(status2);
        }

        private boolean __WIFEXITED(long status2) {
            return this.__WTERMSIG(status2) == 0;
        }

        private boolean __WIFSIGNALED(long status2) {
            return (status2 & 0x7FL) + 1L >> 1 > 0L;
        }

        private boolean __WIFSTOPPED(long status2) {
            return (status2 & 0xFFL) == 127L;
        }

        private boolean __WCOREDUMP(long status2) {
            return (status2 & (long)__WCOREFLAG) != 0L;
        }

        @Override
        public int WEXITSTATUS(long status2) {
            return this.__WEXITSTATUS(this.__WAIT_INT(status2));
        }

        @Override
        public int WTERMSIG(long status2) {
            return this.__WTERMSIG(this.__WAIT_INT(status2));
        }

        @Override
        public int WSTOPSIG(long status2) {
            return this.__WSTOPSIG(this.__WAIT_INT(status2));
        }

        @Override
        public boolean WIFEXITED(long status2) {
            return this.__WIFEXITED(this.__WAIT_INT(status2));
        }

        @Override
        public boolean WIFSIGNALED(long status2) {
            return this.__WIFSIGNALED(this.__WAIT_INT(status2));
        }

        @Override
        public boolean WIFSTOPPED(long status2) {
            return this.__WIFSTOPPED(this.__WAIT_INT(status2));
        }

        @Override
        public boolean WCOREDUMP(long status2) {
            return this.__WCOREDUMP(this.__WAIT_INT(status2));
        }
    }

    public static class BSDWaitMacros
    implements WaitMacros {
        public final long _WSTOPPED = 127L;
        public final long WCOREFLAG = 128L;

        public long _WSTATUS(long status2) {
            return status2 & 0x7FL;
        }

        @Override
        public boolean WIFEXITED(long status2) {
            return this._WSTATUS(status2) == 0L;
        }

        @Override
        public boolean WIFSIGNALED(long status2) {
            return this._WSTATUS(status2) != 127L && this._WSTATUS(status2) != 0L;
        }

        @Override
        public int WTERMSIG(long status2) {
            return (int)this._WSTATUS(status2);
        }

        @Override
        public int WEXITSTATUS(long status2) {
            return (int)(status2 >>> 8 & 0xFFL);
        }

        @Override
        public int WSTOPSIG(long status2) {
            return (int)(status2 >>> 8);
        }

        @Override
        public boolean WIFSTOPPED(long status2) {
            return this._WSTATUS(status2) == 127L && this.WSTOPSIG(status2) != 19;
        }

        @Override
        public boolean WCOREDUMP(long status2) {
            return (status2 & 0x80L) != 0L;
        }
    }

    public static interface WaitMacros {
        public boolean WIFEXITED(long var1);

        public boolean WIFSIGNALED(long var1);

        public int WTERMSIG(long var1);

        public int WEXITSTATUS(long var1);

        public int WSTOPSIG(long var1);

        public boolean WIFSTOPPED(long var1);

        public boolean WCOREDUMP(long var1);
    }
}

