/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import java.io.ByteArrayOutputStream;
import org.jruby.RubyModule;
import org.jruby.compiler.Compilable;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IRScope;
import org.jruby.ir.interpreter.Interpreter;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.ir.persistence.IRDumper;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.runtime.ArgumentDescriptor;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.IRBlockBody;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.cli.Options;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class InterpretedIRBlockBody
extends IRBlockBody
implements Compilable<InterpreterContext> {
    private static final Logger LOG = LoggerFactory.getLogger(InterpretedIRBlockBody.class);
    protected boolean pushScope = true;
    protected boolean reuseParentScope = false;
    private boolean displayedCFG = false;
    private int callCount = 0;
    private InterpreterContext interpreterContext;
    private InterpreterContext fullInterpreterContext;

    public InterpretedIRBlockBody(IRClosure closure, Signature signature) {
        super(closure, signature);
        if (closure.getManager().getInstanceConfig().getCompileMode().shouldJIT() || (Integer)Options.JIT_THRESHOLD.load() == -1) {
            this.callCount = -1;
        }
    }

    @Override
    public void setCallCount(int callCount) {
        this.callCount = callCount;
    }

    @Override
    public void completeBuild(InterpreterContext interpreterContext) {
        this.fullInterpreterContext = interpreterContext;
        this.displayedCFG = false;
    }

    @Override
    public IRScope getIRScope() {
        return this.closure;
    }

    @Override
    public ArgumentDescriptor[] getArgumentDescriptors() {
        return this.closure.getArgumentDescriptors();
    }

    @Override
    public InterpreterContext ensureInstrsReady() {
        if (IRRuntimeHelpers.isDebug() && !this.displayedCFG) {
            LOG.info("Executing '" + this.closure + "' (pushScope=" + this.pushScope + ", reuseParentScope=" + this.reuseParentScope, new Object[0]);
            LOG.info(this.closure.debugOutput(), new Object[0]);
            this.displayedCFG = true;
        }
        if (this.interpreterContext == null) {
            if (IRRuntimeHelpers.shouldPrintIR(this.closure.getStaticScope().getModule().getRuntime())) {
                ByteArrayOutputStream baos = IRDumper.printIR(this.closure, false);
                LOG.info("Printing simple IR for " + this.closure.getId() + ":\n" + new String(baos.toByteArray()), new Object[0]);
            }
            this.fullInterpreterContext = this.interpreterContext = this.closure.getInterpreterContext();
        }
        return this.interpreterContext;
    }

    @Override
    public String getClassName(ThreadContext context) {
        return null;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public boolean canCallDirect() {
        return this.interpreterContext != null && this.interpreterContext.hasExplicitCallProtocol();
    }

    @Override
    protected IRubyObject callDirect(ThreadContext context, Block block, IRubyObject[] args2, Block blockArg) {
        InterpreterContext ic = this.ensureInstrsReady();
        return Interpreter.INTERPRET_BLOCK(context, block, null, ic, args2, block.getBinding().getMethod(), blockArg);
    }

    @Override
    protected IRubyObject yieldDirect(ThreadContext context, Block block, IRubyObject[] args2, IRubyObject self2) {
        InterpreterContext ic = this.ensureInstrsReady();
        return Interpreter.INTERPRET_BLOCK(context, block, self2, ic, args2, block.getBinding().getMethod(), Block.NULL_BLOCK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IRubyObject commonYieldPath(ThreadContext context, Block block, Block.Type type2, IRubyObject[] args2, IRubyObject self2, Block blockArg) {
        if (this.callCount >= 0) {
            this.promoteToFullBuild(context);
        }
        InterpreterContext ic = this.ensureInstrsReady();
        this.interpreterContext = this.fullInterpreterContext;
        Binding binding2 = block.getBinding();
        Visibility oldVis = binding2.getFrame().getVisibility();
        Frame prevFrame = context.preYieldNoScope(binding2);
        DynamicScope actualScope = binding2.getDynamicScope();
        if (ic.pushNewDynScope()) {
            context.pushScope(block.allocScope(actualScope));
        } else if (ic.reuseParentDynScope()) {
            context.pushScope(actualScope);
        }
        self2 = IRRuntimeHelpers.updateBlockState(block, self2);
        try {
            IRubyObject iRubyObject = Interpreter.INTERPRET_BLOCK(context, block, self2, ic, args2, binding2.getMethod(), blockArg);
            return iRubyObject;
        }
        finally {
            InterpretedIRBlockBody.postYield(context, ic, binding2, oldVis, prevFrame);
        }
    }

    private void promoteToFullBuild(ThreadContext context) {
        if (context.runtime.isBooting() && !((Boolean)Options.JIT_KERNEL.load()).booleanValue()) {
            return;
        }
        if (this.callCount++ >= (Integer)Options.JIT_THRESHOLD.load()) {
            context.runtime.getJITCompiler().buildThresholdReached(context, this);
        }
    }

    @Override
    public RubyModule getImplementationClass() {
        return null;
    }
}

