/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.stringio;

import java.util.Arrays;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jruby.ObjectFlags;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyIO;
import org.jruby.RubyInteger;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.FrameField;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.java.addons.IOJavaAddons;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.encoding.EncodingCapable;
import org.jruby.util.ArraySupport;
import org.jruby.util.ByteList;
import org.jruby.util.StringSupport;
import org.jruby.util.TypeConverter;
import org.jruby.util.io.EncodingUtils;
import org.jruby.util.io.Getline;
import org.jruby.util.io.ModeFlags;
import org.jruby.util.io.OpenFile;

@JRubyClass(name={"StringIO"})
public class StringIO
extends RubyObject
implements EncodingCapable {
    StringIOData ptr;
    private static final int STRIO_READABLE = ObjectFlags.STRIO_READABLE;
    private static final int STRIO_WRITABLE = ObjectFlags.STRIO_WRITABLE;
    private static final int STRIO_READWRITE = STRIO_READABLE | STRIO_WRITABLE;
    private static ObjectAllocator STRINGIO_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new StringIO(runtime2, klass);
        }
    };
    private static final int CHAR_BIT = 8;
    private static final Getline.Callback<StringIO, IRubyObject> GETLINE = new Getline.Callback<StringIO, IRubyObject>(){

        @Override
        public IRubyObject getline(ThreadContext context, StringIO self2, IRubyObject rs, int limit2, boolean chomp2, Block block) {
            if (limit2 == 0) {
                return RubyString.newEmptyString(context.runtime, self2.getEncoding());
            }
            IRubyObject result2 = self2.getline(context, rs, limit2, chomp2);
            context.setLastLine(result2);
            return result2;
        }
    };
    private static final Getline.Callback<StringIO, StringIO> GETLINE_YIELD = new Getline.Callback<StringIO, StringIO>(){

        @Override
        public StringIO getline(ThreadContext context, StringIO self2, IRubyObject rs, int limit2, boolean chomp2, Block block) {
            IRubyObject line;
            if (limit2 == 0) {
                throw context.runtime.newArgumentError("invalid limit: 0 for each_line");
            }
            while (!(line = self2.getline(context, rs, limit2, chomp2)).isNil()) {
                block.yieldSpecific(context, line);
            }
            return self2;
        }
    };
    private static final Getline.Callback<StringIO, RubyArray> GETLINE_ARY = new Getline.Callback<StringIO, RubyArray>(){

        @Override
        public RubyArray getline(ThreadContext context, StringIO self2, IRubyObject rs, int limit2, boolean chomp2, Block block) {
            IRubyObject line;
            RubyArray ary = context.runtime.newArray();
            if (limit2 == 0) {
                throw context.runtime.newArgumentError("invalid limit: 0 for readlines");
            }
            while (!(line = self2.getline(context, rs, limit2, chomp2)).isNil()) {
                ary.append(line);
            }
            return ary;
        }
    };
    public static final ByteList NEWLINE = ByteList.create("\n");

    public static RubyClass createStringIOClass(Ruby runtime2) {
        RubyClass stringIOClass = runtime2.defineClass("StringIO", runtime2.getData(), STRINGIO_ALLOCATOR);
        stringIOClass.defineAnnotatedMethods(StringIO.class);
        stringIOClass.includeModule(runtime2.getEnumerable());
        if (runtime2.getObject().isConstantDefined("Java")) {
            stringIOClass.defineAnnotatedMethods(IOJavaAddons.AnyIO.class);
        }
        RubyModule genericReadable = runtime2.getIO().defineOrGetModuleUnder("GenericReadable");
        genericReadable.defineAnnotatedMethods(GenericReadable.class);
        stringIOClass.includeModule(genericReadable);
        RubyModule genericWritable = runtime2.getIO().defineOrGetModuleUnder("GenericWritable");
        genericWritable.defineAnnotatedMethods(GenericWritable.class);
        stringIOClass.includeModule(genericWritable);
        return stringIOClass;
    }

    @Override
    public Encoding getEncoding() {
        return this.ptr.enc != null ? this.ptr.enc : this.ptr.string.getEncoding();
    }

    @Override
    public void setEncoding(Encoding enc) {
        this.ptr.enc = enc;
    }

    @JRubyMethod(name={"new"}, rest=true, meta=true)
    public static IRubyObject newInstance(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        return RubyIO.newInstance(context, recv2, args2, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(meta=true, rest=true)
    public static IRubyObject open(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        StringIO strio;
        IRubyObject val = strio = (StringIO)((RubyClass)recv2).newInstance(context, args2, Block.NULL_BLOCK);
        if (block.isGiven()) {
            try {
                val = block.yield(context, strio);
            }
            finally {
                strio.ptr.string = null;
                strio.flags &= ~STRIO_READWRITE;
            }
        }
        return val;
    }

    protected StringIO(Ruby runtime2, RubyClass klass) {
        super(runtime2, klass);
    }

    @JRubyMethod(optional=2, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2) {
        if (this.ptr == null) {
            this.ptr = new StringIOData();
        }
        this.strioInit(context, args2);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void strioInit(ThreadContext context, IRubyObject[] args2) {
        StringIOData ptr;
        Ruby runtime2 = context.runtime;
        StringIOData stringIOData = ptr = this.ptr;
        synchronized (stringIOData) {
            RubyString string2;
            switch (args2.length) {
                case 2: {
                    boolean trunc;
                    IRubyObject mode2 = args2[1];
                    if (mode2 instanceof RubyFixnum) {
                        int flags2 = RubyFixnum.fix2int(mode2);
                        ptr.flags = ModeFlags.getOpenFileFlagsFor(flags2);
                        trunc = (flags2 & ModeFlags.TRUNC) != 0;
                    } else {
                        String m = args2[1].convertToString().toString();
                        ptr.flags = OpenFile.ioModestrFmode(runtime2, m);
                        trunc = m.length() > 0 && m.charAt(0) == 'w';
                    }
                    string2 = args2[0].convertToString();
                    if ((ptr.flags & 2) != 0 && string2.isFrozen()) {
                        throw runtime2.newErrnoEACCESError("Permission denied");
                    }
                    if (!trunc) break;
                    string2.resize(0);
                    break;
                }
                case 1: {
                    string2 = args2[0].convertToString();
                    ptr.flags = string2.isFrozen() ? 1 : 3;
                    break;
                }
                case 0: {
                    string2 = RubyString.newEmptyString(runtime2, runtime2.getDefaultExternalEncoding());
                    ptr.flags = 3;
                    break;
                }
                default: {
                    throw runtime2.newArgumentError(args2.length, 2);
                }
            }
            ptr.string = string2;
            ptr.enc = null;
            ptr.pos = 0;
            ptr.lineno = 0;
            this.flags |= (ptr.flags & 3) * (STRIO_READABLE / 1);
        }
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(ThreadContext context, IRubyObject other) {
        StringIO otherIO = (StringIO)TypeConverter.convertToType(other, context.runtime.getClass("StringIO"), "to_strio");
        if (this == otherIO) {
            return this;
        }
        this.ptr = otherIO.ptr;
        this.infectBy(otherIO);
        this.flags &= ~STRIO_READWRITE;
        this.flags |= otherIO.flags & STRIO_READWRITE;
        return this;
    }

    @JRubyMethod
    public IRubyObject binmode(ThreadContext context) {
        this.ptr.enc = EncodingUtils.ascii8bitEncoding(context.runtime);
        if (this.writable()) {
            this.ptr.string.setEncoding(this.ptr.enc);
        }
        return this;
    }

    @JRubyMethod(name={"flush"})
    public IRubyObject strio_self() {
        return this;
    }

    @JRubyMethod(name={"fcntl"}, rest=true)
    public IRubyObject strio_unimpl(ThreadContext context, IRubyObject[] args2) {
        throw context.runtime.newNotImplementedError("");
    }

    @JRubyMethod(name={"fsync"})
    public IRubyObject strioZero(ThreadContext context) {
        return RubyFixnum.zero(context.runtime);
    }

    @JRubyMethod(name={"sync="})
    public IRubyObject strioFirst(IRubyObject arg2) {
        this.checkInitialized();
        return arg2;
    }

    @JRubyMethod(name={"isatty", "tty?"})
    public IRubyObject strioFalse(ThreadContext context) {
        return context.fals;
    }

    @JRubyMethod(name={"pid", "fileno"})
    public IRubyObject strioNil(ThreadContext context) {
        return context.nil;
    }

    @JRubyMethod
    public IRubyObject close(ThreadContext context) {
        this.checkInitialized();
        if (this.closed()) {
            return context.nil;
        }
        this.flags &= ~STRIO_READWRITE;
        return context.nil;
    }

    @JRubyMethod(name={"closed?"})
    public IRubyObject closed_p() {
        this.checkInitialized();
        return this.getRuntime().newBoolean(this.closed());
    }

    @JRubyMethod
    public IRubyObject close_read(ThreadContext context) {
        this.checkInitialized();
        if ((this.ptr.flags & 1) == 0) {
            throw context.runtime.newIOError("not opened for reading");
        }
        if ((this.flags & STRIO_READABLE) != 0) {
            this.flags &= ~STRIO_READABLE;
        }
        return context.nil;
    }

    @JRubyMethod(name={"closed_read?"})
    public IRubyObject closed_read_p() {
        this.checkInitialized();
        return this.getRuntime().newBoolean(!this.readable());
    }

    @JRubyMethod
    public IRubyObject close_write(ThreadContext context) {
        this.checkInitialized();
        if ((this.ptr.flags & 2) == 0) {
            throw context.runtime.newIOError("not opened for writing");
        }
        if ((this.flags & STRIO_WRITABLE) != 0) {
            this.flags &= ~STRIO_WRITABLE;
        }
        return context.nil;
    }

    @JRubyMethod(name={"closed_write?"})
    public IRubyObject closed_write_p() {
        this.checkInitialized();
        return this.getRuntime().newBoolean(!this.writable());
    }

    @JRubyMethod(name={"each"}, writes={FrameField.LASTLINE})
    public IRubyObject each(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, this, "each");
        }
        return Getline.getlineCall(context, GETLINE_YIELD, this, this.getEncoding(), 0, null, null, null, block);
    }

    @JRubyMethod(name={"each"}, writes={FrameField.LASTLINE})
    public IRubyObject each(ThreadContext context, IRubyObject arg0, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, (IRubyObject)this, "each", arg0);
        }
        return Getline.getlineCall(context, GETLINE_YIELD, this, this.getEncoding(), 1, arg0, null, null, block);
    }

    @JRubyMethod(name={"each"}, writes={FrameField.LASTLINE})
    public IRubyObject each(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, (IRubyObject)this, "each", Helpers.arrayOf(arg0, arg1));
        }
        return Getline.getlineCall(context, GETLINE_YIELD, this, this.getEncoding(), 2, arg0, arg1, null, block);
    }

    @JRubyMethod(name={"each"})
    public IRubyObject each(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, (IRubyObject)this, "each", Helpers.arrayOf(arg0, arg1, arg2));
        }
        return Getline.getlineCall(context, GETLINE_YIELD, this, this.getEncoding(), 3, arg0, arg1, arg2, block);
    }

    public IRubyObject each(ThreadContext context, IRubyObject[] args2, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, (IRubyObject)this, "each", args2);
        }
        switch (args2.length) {
            case 0: {
                return this.each(context, block);
            }
            case 1: {
                return this.each(context, args2[0], block);
            }
            case 2: {
                return this.each(context, args2[0], args2[1], block);
            }
            case 3: {
                return this.each(context, args2[0], args2[1], args2[2], block);
            }
        }
        Arity.raiseArgumentError(context, args2.length, 0, 3);
        throw new AssertionError((Object)"BUG");
    }

    @JRubyMethod(name={"each_line"})
    public IRubyObject each_line(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, this, "each_line");
        }
        return this.each(context, block);
    }

    @JRubyMethod(name={"each_line"})
    public IRubyObject each_line(ThreadContext context, IRubyObject arg0, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, (IRubyObject)this, "each_line", arg0);
        }
        return this.each(context, arg0, block);
    }

    @JRubyMethod(name={"each_line"})
    public IRubyObject each_line(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, (IRubyObject)this, "each_line", arg0, arg1);
        }
        return this.each(context, arg0, arg1, block);
    }

    @JRubyMethod(name={"each_line"})
    public IRubyObject each_line(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, (IRubyObject)this, "each_line", arg0, arg1, arg2);
        }
        return this.each(context, arg0, arg1, arg2, block);
    }

    public IRubyObject each_line(ThreadContext context, IRubyObject[] args2, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, (IRubyObject)this, "each_line", args2);
        }
        switch (args2.length) {
            case 0: {
                return this.each_line(context, block);
            }
            case 1: {
                return this.each_line(context, args2[0], block);
            }
            case 2: {
                return this.each_line(context, args2[0], args2[1], block);
            }
            case 3: {
                return this.each_line(context, args2[0], args2[1], args2[2], block);
            }
        }
        Arity.raiseArgumentError(context, args2.length, 0, 3);
        throw new AssertionError((Object)"BUG");
    }

    @JRubyMethod(name={"lines"}, optional=2)
    public IRubyObject lines(ThreadContext context, IRubyObject[] args2, Block block) {
        context.runtime.getWarnings().warn("StringIO#lines is deprecated; use #each_line instead");
        return block.isGiven() ? this.each(context, args2, block) : RubyEnumerator.enumeratorize(context.runtime, (IRubyObject)this, "each_line", args2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"each_byte", "bytes"})
    public IRubyObject each_byte(ThreadContext context, Block block) {
        StringIOData ptr;
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, this, "each_byte");
        }
        this.checkReadable();
        Ruby runtime2 = context.runtime;
        StringIOData stringIOData = ptr = this.ptr;
        synchronized (stringIOData) {
            ByteList bytes2 = ptr.string.getByteList();
            while (ptr.pos < bytes2.length()) {
                block.yield(context, runtime2.newFixnum(bytes2.get(ptr.pos++) & 0xFF));
            }
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject each_char(ThreadContext context, Block block) {
        IRubyObject c;
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, this, "each_char");
        }
        while (!(c = this.getc(context)).isNil()) {
            block.yieldSpecific(context, c);
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject chars(ThreadContext context, Block block) {
        context.runtime.getWarnings().warn("StringIO#chars is deprecated; use #each_char instead");
        return this.each_char(context, block);
    }

    @JRubyMethod(name={"eof", "eof?"})
    public IRubyObject eof(ThreadContext context) {
        this.checkReadable();
        Ruby runtime2 = context.runtime;
        if (this.ptr.pos < this.ptr.string.size()) {
            return runtime2.getFalse();
        }
        return runtime2.getTrue();
    }

    private boolean isEndOfString() {
        return this.ptr.pos >= this.ptr.string.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"getc"})
    public IRubyObject getc(ThreadContext context) {
        StringIOData ptr;
        this.checkReadable();
        if (this.isEndOfString()) {
            return context.nil;
        }
        StringIOData stringIOData = ptr = this.ptr;
        synchronized (stringIOData) {
            int start2 = ptr.pos;
            int total2 = 1 + StringSupport.bytesToFixBrokenTrailingCharacter(ptr.string.getByteList(), start2 + 1);
            ptr.pos += total2;
            return context.runtime.newString(ptr.string.getByteList().makeShared(start2, total2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"getbyte"})
    public IRubyObject getbyte(ThreadContext context) {
        int c;
        StringIOData ptr;
        this.checkReadable();
        if (this.isEndOfString()) {
            return context.nil;
        }
        StringIOData stringIOData = ptr = this.ptr;
        synchronized (stringIOData) {
            c = ptr.string.getByteList().get(this.ptr.pos++) & 0xFF;
        }
        return context.runtime.newFixnum(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RubyString strioSubstr(Ruby runtime2, int pos2, int len, Encoding enc) {
        StringIOData ptr;
        StringIOData stringIOData = ptr = this.ptr;
        synchronized (stringIOData) {
            RubyString string2 = ptr.string;
            ByteList stringBytes = string2.getByteList();
            int rlen = string2.size() - pos2;
            if (len > rlen) {
                len = rlen;
            }
            if (len < 0) {
                len = 0;
            }
            if (len == 0) {
                return RubyString.newEmptyString(runtime2, enc);
            }
            string2.setByteListShared();
            return RubyString.newStringShared(runtime2, stringBytes.getUnsafeBytes(), stringBytes.getBegin() + pos2, len, enc);
        }
    }

    private static void bm_init_skip(int[] skip2, byte[] pat, int patPtr, int m) {
        for (int c = 0; c < 256; ++c) {
            skip2[c] = m;
        }
        while (--m > 0) {
            skip2[pat[patPtr++]] = m;
        }
    }

    private static int bm_search(byte[] little, int lstart, int llen, byte[] big, int bstart, int blen, int[] skip2) {
        for (int i2 = llen - 1; i2 < blen; i2 += skip2[big[i2 + bstart] & 0xFF]) {
            int j;
            int k = i2;
            for (j = llen - 1; j >= 0 && big[k + bstart] == little[j + lstart]; --j) {
                --k;
            }
            if (j >= 0) continue;
            return k + 1;
        }
        return -1;
    }

    @JRubyMethod(name={"gets"}, writes={FrameField.LASTLINE})
    public IRubyObject gets(ThreadContext context) {
        return Getline.getlineCall(context, GETLINE, this, this.getEncoding());
    }

    @JRubyMethod(name={"gets"}, writes={FrameField.LASTLINE})
    public IRubyObject gets(ThreadContext context, IRubyObject arg0) {
        return Getline.getlineCall(context, GETLINE, this, this.getEncoding(), arg0);
    }

    @JRubyMethod(name={"gets"}, writes={FrameField.LASTLINE})
    public IRubyObject gets(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        return Getline.getlineCall(context, GETLINE, this, this.getEncoding(), arg0, arg1);
    }

    @JRubyMethod(name={"gets"}, writes={FrameField.LASTLINE})
    public IRubyObject gets(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        return Getline.getlineCall(context, GETLINE, this, this.getEncoding(), arg0, arg1, arg2);
    }

    public IRubyObject gets(ThreadContext context, IRubyObject[] args2) {
        switch (args2.length) {
            case 0: {
                return this.gets(context);
            }
            case 1: {
                return this.gets(context, args2[0]);
            }
            case 2: {
                return this.gets(context, args2[0], args2[1]);
            }
            case 3: {
                return this.gets(context, args2[0], args2[1], args2[2]);
            }
        }
        Arity.raiseArgumentError(context, args2.length, 0, 3);
        throw new AssertionError((Object)"BUG");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject getline(ThreadContext context, IRubyObject rs, int limit2, boolean chomp2) {
        RubyString str;
        Ruby runtime2 = context.runtime;
        this.checkReadable();
        if (this.isEndOfString()) {
            return context.nil;
        }
        StringIOData ptr = this.ptr;
        Encoding enc = this.getEncoding();
        StringIOData stringIOData = ptr;
        synchronized (stringIOData) {
            ByteList string2 = ptr.string.getByteList();
            byte[] stringBytes = string2.getUnsafeBytes();
            int begin2 = string2.getBegin();
            int s2 = begin2 + ptr.pos;
            int e = begin2 + string2.getRealSize();
            int w = 0;
            if (limit2 > 0 && s2 + limit2 < e) {
                e = this.getEncoding().rightAdjustCharHead(stringBytes, s2, s2 + limit2, e);
            }
            if (rs == context.nil) {
                if (chomp2) {
                    w = StringIO.chompNewlineWidth(stringBytes, s2, e);
                }
                str = this.strioSubstr(runtime2, ptr.pos, e - s2 - w, enc);
            } else {
                int n = ((RubyString)rs).size();
                if (n == 0) {
                    int p2 = s2;
                    while (stringBytes[p2] == 10) {
                        if (++p2 != e) continue;
                        return context.nil;
                    }
                    s2 = p2;
                    while ((p2 = StringSupport.memchr(stringBytes, p2, 10, e - p2)) != -1 && p2 != e && ++p2 != e) {
                        if (stringBytes[p2] == 10) {
                            e = p2 + 1;
                            w = chomp2 ? 1 : 0;
                            break;
                        }
                        if (stringBytes[p2] != 13 || p2 >= e || stringBytes[p2 + 1] != 10) continue;
                        e = p2 + 2;
                        int n2 = w = chomp2 ? 2 : 0;
                        break;
                    }
                    if (w == 0 && chomp2) {
                        w = StringIO.chompNewlineWidth(stringBytes, s2, e);
                    }
                    str = this.strioSubstr(runtime2, s2 - begin2, e - s2 - w, enc);
                } else if (n == 1) {
                    RubyString strStr = (RubyString)rs;
                    ByteList strByteList = strStr.getByteList();
                    int p3 = StringSupport.memchr(stringBytes, s2, strByteList.get(0), e - s2);
                    if (p3 != -1) {
                        e = p3 + 1;
                        w = chomp2 ? (p3 > s2 && stringBytes[p3 - 1] == 13 ? 1 : 0) + 1 : 0;
                    }
                    str = this.strioSubstr(runtime2, ptr.pos, e - s2 - w, enc);
                } else {
                    if (n < e - s2) {
                        RubyString rsStr = (RubyString)rs;
                        ByteList rsByteList = rsStr.getByteList();
                        byte[] rsBytes = rsByteList.getUnsafeBytes();
                        int[] skip2 = new int[256];
                        int p4 = rsByteList.getBegin();
                        StringIO.bm_init_skip(skip2, rsBytes, p4, n);
                        int pos2 = StringIO.bm_search(rsBytes, p4, n, stringBytes, s2, e - s2, skip2);
                        if (pos2 >= 0) {
                            e = s2 + pos2 + n;
                        }
                    }
                    str = this.strioSubstr(runtime2, ptr.pos, e - s2 - w, enc);
                }
            }
            ptr.pos = e - begin2;
            ++ptr.lineno;
        }
        return str;
    }

    private static int chompNewlineWidth(byte[] bytes2, int s2, int e) {
        if (e > s2 && bytes2[--e] == 10) {
            if (e > s2 && bytes2[--e] == 13) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    @JRubyMethod(name={"length", "size"})
    public IRubyObject length() {
        this.checkInitialized();
        this.checkFinalized();
        return this.getRuntime().newFixnum(this.ptr.string.size());
    }

    @JRubyMethod(name={"lineno"})
    public IRubyObject lineno(ThreadContext context) {
        return context.runtime.newFixnum(this.ptr.lineno);
    }

    @JRubyMethod(name={"lineno="}, required=1)
    public IRubyObject set_lineno(ThreadContext context, IRubyObject arg2) {
        this.ptr.lineno = RubyNumeric.fix2int(arg2);
        return context.nil;
    }

    @JRubyMethod(name={"pos", "tell"})
    public IRubyObject pos(ThreadContext context) {
        this.checkInitialized();
        return context.runtime.newFixnum(this.ptr.pos);
    }

    @JRubyMethod(name={"pos="}, required=1)
    public IRubyObject set_pos(IRubyObject arg2) {
        this.checkInitialized();
        long p2 = RubyNumeric.fix2long(arg2);
        if (p2 < 0L) {
            throw this.getRuntime().newErrnoEINVALError(arg2.toString());
        }
        if (p2 > Integer.MAX_VALUE) {
            throw this.getRuntime().newArgumentError("JRuby does not support StringIO larger than 2147483647 bytes");
        }
        this.ptr.pos = (int)p2;
        return arg2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void strioExtend(int pos2, int len) {
        StringIOData ptr;
        StringIOData stringIOData = ptr = this.ptr;
        synchronized (stringIOData) {
            int olen = ptr.string.size();
            if (pos2 + len > olen) {
                ptr.string.resize(pos2 + len);
                if (pos2 > olen) {
                    ptr.string.modify19();
                    ByteList ptrByteList = ptr.string.getByteList();
                    Arrays.fill(ptrByteList.getUnsafeBytes(), ptrByteList.getBegin() + olen, ptrByteList.getBegin() + pos2, (byte)0);
                }
            } else {
                ptr.string.modify19();
            }
        }
    }

    @JRubyMethod(name={"putc"})
    public IRubyObject putc(ThreadContext context, IRubyObject ch) {
        IRubyObject str;
        Ruby runtime2 = context.runtime;
        this.checkWritable();
        this.checkModifiable();
        if (ch instanceof RubyString) {
            str = ((RubyString)ch).substr19(runtime2, 0, 1);
        } else {
            byte c = RubyNumeric.num2chr(ch);
            str = RubyString.newString(runtime2, new byte[]{c});
        }
        this.write(context, str);
        return ch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"read"}, optional=2)
    public IRubyObject read(ThreadContext context, IRubyObject[] args2) {
        RubyString string2;
        StringIOData ptr;
        this.checkReadable();
        Ruby runtime2 = context.runtime;
        IRubyObject str = context.nil;
        boolean binary = false;
        StringIOData stringIOData = ptr = this.ptr;
        synchronized (stringIOData) {
            int len;
            switch (args2.length) {
                case 2: {
                    str = args2[1];
                    if (!str.isNil()) {
                        str = str.convertToString();
                        ((RubyString)str).modify();
                    }
                }
                case 1: {
                    if (!args2[0].isNil()) {
                        len = RubyNumeric.fix2int(args2[0]);
                        if (len < 0) {
                            throw runtime2.newArgumentError("negative length " + len + " given");
                        }
                        if (len > 0 && this.isEndOfString()) {
                            if (!str.isNil()) {
                                ((RubyString)str).resize(0);
                            }
                            return context.nil;
                        }
                        binary = true;
                        break;
                    }
                }
                case 0: {
                    len = ptr.string.size();
                    if (len <= ptr.pos) {
                        ASCIIEncoding enc;
                        Object object = enc = binary ? ASCIIEncoding.INSTANCE : this.getEncoding();
                        if (str.isNil()) {
                            str = runtime2.newString();
                        } else {
                            ((RubyString)str).resize(0);
                        }
                        ((RubyString)str).setEncoding((Encoding)enc);
                        return str;
                    }
                    len -= ptr.pos;
                    break;
                }
                default: {
                    throw runtime2.newArgumentError(args2.length, 0);
                }
            }
            if (str.isNil()) {
                ASCIIEncoding enc = binary ? ASCIIEncoding.INSTANCE : this.getEncoding();
                string2 = this.strioSubstr(runtime2, ptr.pos, len, (Encoding)enc);
            } else {
                string2 = (RubyString)str;
                int rest2 = ptr.string.size() - ptr.pos;
                if (len > rest2) {
                    len = rest2;
                }
                string2.resize(len);
                ByteList strByteList = string2.getByteList();
                byte[] strBytes = strByteList.getUnsafeBytes();
                ByteList dataByteList = ptr.string.getByteList();
                byte[] dataBytes = dataByteList.getUnsafeBytes();
                System.arraycopy(dataBytes, dataByteList.getBegin() + ptr.pos, strBytes, strByteList.getBegin(), len);
                if (binary) {
                    string2.setEncoding((Encoding)ASCIIEncoding.INSTANCE);
                } else {
                    string2.setEncoding(ptr.string.getEncoding());
                }
            }
            ptr.pos += string2.size();
        }
        return string2;
    }

    @JRubyMethod(name={"readlines"})
    public IRubyObject readlines(ThreadContext context) {
        return Getline.getlineCall(context, GETLINE_ARY, this, this.getEncoding());
    }

    @JRubyMethod(name={"readlines"})
    public IRubyObject readlines(ThreadContext context, IRubyObject arg0) {
        return Getline.getlineCall(context, GETLINE_ARY, this, this.getEncoding(), arg0);
    }

    @JRubyMethod(name={"readlines"})
    public IRubyObject readlines(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        return Getline.getlineCall(context, GETLINE_ARY, this, this.getEncoding(), arg0, arg1);
    }

    @JRubyMethod(name={"readlines"})
    public IRubyObject readlines(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        return Getline.getlineCall(context, GETLINE_ARY, this, this.getEncoding(), arg0, arg1, arg2);
    }

    public IRubyObject readlines(ThreadContext context, IRubyObject[] args2) {
        switch (args2.length) {
            case 0: {
                return this.readlines(context);
            }
            case 1: {
                return this.readlines(context, args2[0]);
            }
            case 2: {
                return this.readlines(context, args2[0], args2[1]);
            }
            case 3: {
                return this.readlines(context, args2[0], args2[1], args2[2]);
            }
        }
        Arity.raiseArgumentError(context, args2.length, 0, 3);
        throw new AssertionError((Object)"BUG");
    }

    @JRubyMethod(name={"reopen"}, required=0, optional=2)
    public IRubyObject reopen(ThreadContext context, IRubyObject[] args2) {
        this.checkFrozen();
        if (args2.length == 1 && !(args2[0] instanceof RubyString)) {
            return this.initialize_copy(context, args2[0]);
        }
        this.strioInit(context, args2);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"rewind"})
    public IRubyObject rewind(ThreadContext context) {
        StringIOData ptr;
        this.checkInitialized();
        StringIOData stringIOData = ptr = this.ptr;
        synchronized (stringIOData) {
            ptr.pos = 0;
            ptr.lineno = 0;
        }
        return RubyFixnum.zero(context.runtime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(required=1, optional=1)
    public IRubyObject seek(ThreadContext context, IRubyObject[] args2) {
        StringIOData ptr;
        Ruby runtime2 = context.runtime;
        this.checkFrozen();
        this.checkFinalized();
        int offset2 = RubyNumeric.num2int(args2[0]);
        IRubyObject whence = context.nil;
        if (args2.length > 1 && !args2[0].isNil()) {
            whence = args2[1];
        }
        this.checkOpen();
        StringIOData stringIOData = ptr = this.ptr;
        synchronized (stringIOData) {
            switch (whence.isNil() ? 0 : RubyNumeric.num2int(whence)) {
                case 0: {
                    break;
                }
                case 1: {
                    offset2 += ptr.pos;
                    break;
                }
                case 2: {
                    offset2 += ptr.string.size();
                    break;
                }
                default: {
                    throw runtime2.newErrnoEINVALError("invalid whence");
                }
            }
            if (offset2 < 0) {
                throw runtime2.newErrnoEINVALError("invalid seek value");
            }
            ptr.pos = offset2;
        }
        return RubyFixnum.zero(runtime2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"string="}, required=1)
    public IRubyObject set_string(IRubyObject arg2) {
        StringIOData ptr;
        this.checkFrozen();
        StringIOData stringIOData = ptr = this.ptr;
        synchronized (stringIOData) {
            ptr.flags &= 0xFFFFFFFC;
            RubyString str = arg2.convertToString();
            ptr.flags = str.isFrozen() ? 1 : 3;
            ptr.pos = 0;
            ptr.lineno = 0;
            ptr.string = str;
            return ptr.string;
        }
    }

    @JRubyMethod(name={"string"})
    public IRubyObject string(ThreadContext context) {
        RubyString string2 = this.ptr.string;
        if (string2 == null) {
            return context.nil;
        }
        return string2;
    }

    @JRubyMethod(name={"sync"})
    public IRubyObject sync(ThreadContext context) {
        this.checkInitialized();
        return context.tru;
    }

    public IRubyObject sysread(IRubyObject[] args2) {
        return GenericReadable.sysread(this.getRuntime().getCurrentContext(), this, args2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"truncate"}, required=1)
    public IRubyObject truncate(IRubyObject len) {
        this.checkWritable();
        int l = RubyFixnum.fix2int(len);
        StringIOData ptr = this.ptr;
        RubyString string2 = ptr.string;
        StringIOData stringIOData = ptr;
        synchronized (stringIOData) {
            int plen = string2.size();
            if (l < 0) {
                throw this.getRuntime().newErrnoEINVALError("negative legnth");
            }
            string2.resize(l);
            ByteList buf = string2.getByteList();
            if (plen < l) {
                Arrays.fill(buf.getUnsafeBytes(), buf.getBegin() + plen, buf.getBegin() + l, (byte)0);
            }
        }
        return len;
    }

    @JRubyMethod(name={"ungetc"})
    public IRubyObject ungetc(ThreadContext context, IRubyObject arg2) {
        RubyString argStr;
        Encoding enc2;
        this.checkModifiable();
        this.checkReadable();
        if (arg2.isNil()) {
            return arg2;
        }
        if (arg2 instanceof RubyInteger) {
            int cc = RubyNumeric.num2int(arg2);
            byte[] buf = new byte[16];
            Encoding enc = this.getEncoding();
            int len = enc.codeToMbcLength(cc);
            if (len <= 0) {
                EncodingUtils.encUintChr(context, cc, enc);
            }
            enc.codeToMbc(cc, buf, 0);
            this.ungetbyteCommon(buf, 0, len);
            return context.nil;
        }
        arg2 = arg2.convertToString();
        Encoding enc = this.getEncoding();
        if (enc != (enc2 = (argStr = (RubyString)arg2).getEncoding()) && enc != ASCIIEncoding.INSTANCE) {
            argStr = EncodingUtils.strConvEnc(context, argStr, enc2, enc);
        }
        ByteList argBytes = argStr.getByteList();
        this.ungetbyteCommon(argBytes.unsafeBytes(), argBytes.begin(), argBytes.realSize());
        return context.nil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ungetbyteCommon(int c) {
        StringIOData ptr;
        StringIOData stringIOData = ptr = this.ptr;
        synchronized (stringIOData) {
            ptr.string.modify();
            --ptr.pos;
            ByteList bytes2 = ptr.string.getByteList();
            if (this.isEndOfString()) {
                bytes2.length(ptr.pos + 1);
            }
            if (ptr.pos == -1) {
                bytes2.prepend((byte)c);
                ptr.pos = 0;
            } else {
                bytes2.set(ptr.pos, c);
            }
        }
    }

    private void ungetbyteCommon(RubyString ungetBytes) {
        ByteList ungetByteList = ungetBytes.getByteList();
        this.ungetbyteCommon(ungetByteList.unsafeBytes(), ungetByteList.begin(), ungetByteList.realSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ungetbyteCommon(byte[] ungetBytes, int ungetBegin, int ungetLen) {
        StringIOData ptr;
        if (ungetLen == 0) {
            return;
        }
        StringIOData stringIOData = ptr = this.ptr;
        synchronized (stringIOData) {
            ptr.string.modify();
            int start2 = ungetLen > ptr.pos ? 0 : ptr.pos - ungetLen;
            ByteList byteList = ptr.string.getByteList();
            if (this.isEndOfString()) {
                byteList.length(Math.max(ptr.pos, ungetLen));
            }
            byteList.replace(start2, ptr.pos - start2, ungetBytes, ungetBegin, ungetLen);
            ptr.pos = start2;
        }
    }

    @JRubyMethod
    public IRubyObject ungetbyte(ThreadContext context, IRubyObject arg2) {
        this.checkReadable();
        if (arg2.isNil()) {
            return arg2;
        }
        this.checkModifiable();
        if (arg2 instanceof RubyFixnum) {
            this.ungetbyteCommon(RubyNumeric.fix2int(arg2));
        } else {
            this.ungetbyteCommon(arg2.convertToString());
        }
        return context.nil;
    }

    @JRubyMethod(name={"write"})
    public IRubyObject write(ThreadContext context, IRubyObject arg2) {
        Ruby runtime2 = context.runtime;
        return RubyFixnum.newFixnum(runtime2, this.stringIOWrite(context, runtime2, arg2));
    }

    @JRubyMethod(name={"write"}, required=1, rest=true)
    public IRubyObject write(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime2 = context.runtime;
        long len = 0L;
        for (IRubyObject arg2 : args2) {
            len += this.stringIOWrite(context, runtime2, arg2);
        }
        return RubyFixnum.newFixnum(runtime2, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long stringIOWrite(ThreadContext context, Ruby runtime2, IRubyObject arg2) {
        int len;
        StringIOData ptr;
        this.checkWritable();
        RubyString str = arg2.asString();
        StringIOData stringIOData = ptr = this.ptr;
        synchronized (stringIOData) {
            Encoding enc = this.getEncoding();
            Encoding encStr = str.getEncoding();
            if (enc != encStr && enc != EncodingUtils.ascii8bitEncoding(runtime2) && encStr != ASCIIEncoding.INSTANCE) {
                str = EncodingUtils.strConvEnc(context, str, encStr, enc);
            }
            ByteList strByteList = str.getByteList();
            len = str.size();
            if (len == 0) {
                return 0L;
            }
            this.checkModifiable();
            int olen = ptr.string.size();
            if ((ptr.flags & 0x40) != 0) {
                ptr.pos = olen;
            }
            if (ptr.pos == olen) {
                EncodingUtils.encStrBufCat(runtime2, ptr.string, strByteList, enc);
            } else {
                this.strioExtend(ptr.pos, len);
                ByteList ptrByteList = ptr.string.getByteList();
                System.arraycopy(strByteList.getUnsafeBytes(), strByteList.getBegin(), ptrByteList.getUnsafeBytes(), ptrByteList.begin() + ptr.pos, len);
            }
            ptr.string.infectBy((IRubyObject)str);
            ptr.string.infectBy((IRubyObject)this);
            ptr.pos += len;
        }
        return len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod
    public IRubyObject set_encoding(ThreadContext context, IRubyObject ext_enc) {
        StringIOData ptr;
        Encoding enc = ext_enc.isNil() ? EncodingUtils.defaultExternalEncoding(context.runtime) : EncodingUtils.rbToEncoding(context, ext_enc);
        StringIOData stringIOData = ptr = this.ptr;
        synchronized (stringIOData) {
            RubyString string2;
            ptr.enc = enc;
            if (this.writable() && (string2 = ptr.string).getEncoding() != enc) {
                string2.modify();
                string2.setEncoding(enc);
            }
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject set_encoding(ThreadContext context, IRubyObject enc, IRubyObject ignored) {
        return this.set_encoding(context, enc);
    }

    @JRubyMethod
    public IRubyObject set_encoding(ThreadContext context, IRubyObject enc, IRubyObject ignored1, IRubyObject ignored2) {
        return this.set_encoding(context, enc);
    }

    @JRubyMethod
    public IRubyObject external_encoding(ThreadContext context) {
        return context.runtime.getEncodingService().convertEncodingToRubyEncoding(this.getEncoding());
    }

    @JRubyMethod
    public IRubyObject internal_encoding(ThreadContext context) {
        return context.nil;
    }

    @JRubyMethod(name={"each_codepoint"})
    public IRubyObject each_codepoint(ThreadContext context, Block block) {
        StringIOData ptr;
        Ruby runtime2 = context.runtime;
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(runtime2, this, "each_codepoint");
        }
        this.checkReadable();
        StringIOData stringIOData = ptr = this.ptr;
        synchronized (stringIOData) {
            Encoding enc = this.getEncoding();
            ByteList string2 = ptr.string.getByteList();
            byte[] stringBytes = string2.getUnsafeBytes();
            int begin2 = string2.getBegin();
            while (true) {
                if (ptr.pos >= ptr.string.size()) {
                    return this;
                }
                int c = StringSupport.codePoint(runtime2, enc, stringBytes, begin2 + ptr.pos, stringBytes.length);
                int n = StringSupport.codeLength(enc, c);
                block.yield(context, runtime2.newFixnum(c));
                ptr.pos += n;
            }
        }
    }

    @JRubyMethod(name={"codepoints"})
    public IRubyObject codepoints(ThreadContext context, Block block) {
        Ruby runtime2 = context.runtime;
        runtime2.getWarnings().warn("StringIO#codepoints is deprecated; use #each_codepoint");
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(runtime2, this, "each_codepoint");
        }
        return this.each_codepoint(context, block);
    }

    public IRubyObject puts(ThreadContext context, IRubyObject[] args2) {
        return GenericWritable.puts(context, this, args2);
    }

    @Override
    public void checkFrozen() {
        super.checkFrozen();
        this.checkInitialized();
    }

    private boolean readable() {
        return (this.flags & STRIO_READABLE) != 0 && (this.ptr.flags & 1) != 0;
    }

    private boolean writable() {
        return (this.flags & STRIO_WRITABLE) != 0 && (this.ptr.flags & 2) != 0;
    }

    private boolean closed() {
        return (this.flags & STRIO_READWRITE) == 0 || (this.ptr.flags & 3) == 0;
    }

    private void checkReadable() {
        this.checkInitialized();
        if (!this.readable()) {
            throw this.getRuntime().newIOError("not opened for reading");
        }
    }

    private void checkWritable() {
        this.checkInitialized();
        if (!this.writable()) {
            throw this.getRuntime().newIOError("not opened for writing");
        }
    }

    private void checkModifiable() {
        this.checkFrozen();
        if (this.ptr.string.isFrozen()) {
            throw this.getRuntime().newIOError("not modifiable string");
        }
    }

    private void checkInitialized() {
        if (this.ptr == null) {
            throw this.getRuntime().newIOError("uninitialized stream");
        }
    }

    private void checkFinalized() {
        if (this.ptr.string == null) {
            throw this.getRuntime().newIOError("not opened");
        }
    }

    private void checkOpen() {
        if (this.closed()) {
            throw this.getRuntime().newIOError("closed stream");
        }
    }

    public static class GenericWritable {
        @JRubyMethod(name={"<<"}, required=1)
        public static IRubyObject append(ThreadContext context, IRubyObject self2, IRubyObject arg2) {
            self2.callMethod(context, "write", arg2);
            return self2;
        }

        @JRubyMethod(name={"print"}, rest=true)
        public static IRubyObject print(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
            return RubyIO.print(context, self2, args2);
        }

        @JRubyMethod(name={"printf"}, required=1, rest=true)
        public static IRubyObject printf(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
            self2.callMethod(context, "write", RubyKernel.sprintf(context, self2, args2));
            return context.nil;
        }

        /*
         * Enabled aggressive block sorting
         */
        @JRubyMethod(name={"puts"}, rest=true)
        public static IRubyObject puts(ThreadContext context, IRubyObject maybeIO, IRubyObject[] args2) {
            Ruby runtime2 = context.runtime;
            if (args2.length == 0) {
                RubyIO.write(context, maybeIO, RubyString.newStringShared(runtime2, NEWLINE));
                return runtime2.getNil();
            }
            int i2 = 0;
            while (true) {
                block8: {
                    RubyString line;
                    block5: {
                        block6: {
                            RubyArray arr;
                            block7: {
                                if (i2 >= args2.length) {
                                    return runtime2.getNil();
                                }
                                line = null;
                                if (args2[i2].isNil()) break block5;
                                IRubyObject tmp = args2[i2].checkArrayType();
                                if (tmp.isNil()) break block6;
                                arr = (RubyArray)tmp;
                                if (!runtime2.isInspecting(arr)) break block7;
                                line = runtime2.newString("[...]");
                                break block5;
                            }
                            GenericWritable.inspectPuts(context, maybeIO, arr);
                            break block8;
                        }
                        line = args2[i2] instanceof RubyString ? (RubyString)args2[i2] : args2[i2].asString();
                    }
                    if (line != null) {
                        RubyIO.write(context, maybeIO, line);
                    }
                    if (line == null || !line.getByteList().endsWith(NEWLINE)) {
                        RubyIO.write(context, maybeIO, RubyString.newStringShared(runtime2, NEWLINE));
                    }
                }
                ++i2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static IRubyObject inspectPuts(ThreadContext context, IRubyObject maybeIO, RubyArray array2) {
            Ruby runtime2 = context.runtime;
            try {
                runtime2.registerInspecting(array2);
                IRubyObject iRubyObject = GenericWritable.puts(context, maybeIO, array2.toJavaArray());
                return iRubyObject;
            }
            finally {
                runtime2.unregisterInspecting(array2);
            }
        }

        @JRubyMethod(name={"syswrite"}, required=1)
        public static IRubyObject syswrite(ThreadContext context, IRubyObject self2, IRubyObject arg2) {
            return RubyIO.write(context, self2, arg2);
        }

        @JRubyMethod(name={"write_nonblock"}, required=1, optional=1)
        public static IRubyObject syswrite_nonblock(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
            Ruby runtime2 = context.runtime;
            ArgsUtil.getOptionsArg(runtime2, args2);
            return GenericWritable.syswrite(context, self2, args2[0]);
        }
    }

    public static class GenericReadable {
        @JRubyMethod(name={"readchar"})
        public static IRubyObject readchar(ThreadContext context, IRubyObject self2) {
            IRubyObject c = self2.callMethod(context, "getc");
            if (c.isNil()) {
                throw context.runtime.newEOFError();
            }
            return c;
        }

        @JRubyMethod(name={"readbyte"})
        public static IRubyObject readbyte(ThreadContext context, IRubyObject self2) {
            IRubyObject b2 = self2.callMethod(context, "getbyte");
            if (b2.isNil()) {
                throw context.runtime.newEOFError();
            }
            return b2;
        }

        @JRubyMethod(name={"readline"}, optional=1, writes={FrameField.LASTLINE})
        public static IRubyObject readline(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
            IRubyObject line = self2.callMethod(context, "gets", args2);
            if (line.isNil()) {
                throw context.runtime.newEOFError();
            }
            return line;
        }

        @JRubyMethod(name={"sysread", "readpartial"}, optional=2)
        public static IRubyObject sysread(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
            IRubyObject val = self2.callMethod(context, "read", args2);
            if (val.isNil()) {
                throw context.runtime.newEOFError();
            }
            return val;
        }

        @JRubyMethod(name={"read_nonblock"}, required=1, optional=2)
        public static IRubyObject read_nonblock(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
            IRubyObject val;
            Ruby runtime2 = context.runtime;
            boolean exception2 = true;
            IRubyObject opts = ArgsUtil.getOptionsArg(runtime2, args2);
            if (opts != context.nil) {
                args2 = ArraySupport.newCopy(args2, args2.length - 1);
                boolean bl = exception2 = ArgsUtil.extractKeywordArg(context, "exception", (RubyHash)opts) != context.fals;
            }
            if ((val = self2.callMethod(context, "read", args2)) == context.nil) {
                if (!exception2) {
                    return context.nil;
                }
                throw runtime2.newEOFError();
            }
            return val;
        }
    }

    static class StringIOData {
        RubyString string;
        Encoding enc;
        int pos;
        int lineno;
        int flags;

        StringIOData() {
        }
    }
}

