/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler;

import org.jruby.Ruby;
import org.jruby.compiler.JITClassGenerator;
import org.jruby.compiler.NotCompilableException;
import org.jruby.internal.runtime.methods.MixedModeIRMethod;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.ir.targets.JVMVisitor;
import org.jruby.ir.targets.JVMVisitorMethodContext;
import org.jruby.util.cli.Options;

public class MethodJITClassGenerator
extends JITClassGenerator {
    private final MixedModeIRMethod method;

    public MethodJITClassGenerator(String className, String methodName, String key2, Ruby ruby2, MixedModeIRMethod method2, JVMVisitor visitor) {
        super(className, methodName, key2, ruby2, visitor);
        this.method = method2;
    }

    protected void compile(JVMVisitorMethodContext context) {
        if (this.bytecode != null) {
            return;
        }
        long start2 = System.nanoTime();
        InterpreterContext ic = this.method.ensureInstrsReady();
        int insnCount = ic.getInstructions().length;
        if (insnCount > (Integer)Options.JIT_MAXSIZE.load()) {
            throw new NotCompilableException("Could not compile " + this.method + "; instruction count " + insnCount + " exceeds threshold of " + Options.JIT_MAXSIZE.load());
        }
        this.bytecode = this.visitor.compileToBytecode(this.method.getIRScope(), context);
        this.compileTime = System.nanoTime() - start2;
    }

    public void generate() {
        this.compile(new JVMVisitorMethodContext());
    }

    public String toString() {
        return this.methodName + "() at " + this.method.getFile() + ':' + this.method.getLine();
    }
}

