/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.RubyEnumerable;
import org.jruby.RubyException;
import org.jruby.RubyFloat;
import org.jruby.RubyGenerator;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubyYielder;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.Unrescuable;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.CallBlock;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ArraySupport;
import org.jruby.util.ByteList;
import org.jruby.util.cli.Options;

@JRubyModule(name={"Enumerator"}, include={"Enumerable"})
public class RubyEnumerator
extends RubyObject
implements Iterator<Object> {
    private IRubyObject object;
    private String method;
    private IRubyObject[] methodArgs;
    private IRubyObject size;
    private SizeFn sizeFn;
    private IRubyObject feedValue;
    private static final ObjectAllocator ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new RubyEnumerator(runtime2, klass);
        }
    };
    private volatile Nexter nexter = null;

    public static void defineEnumerator(Ruby runtime2) {
        RubyModule Enumerable = runtime2.getModule("Enumerable");
        RubyClass Enumerator = runtime2.defineClass("Enumerator", runtime2.getObject(), ALLOCATOR);
        Enumerator.includeModule(Enumerable);
        Enumerator.defineAnnotatedMethods(RubyEnumerator.class);
        runtime2.setEnumerator(Enumerator);
        RubyGenerator.createGeneratorClass(runtime2);
        RubyYielder.createYielderClass(runtime2);
    }

    private RubyEnumerator(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
        this.object = runtime2.getNil();
        this.initialize(runtime2, runtime2.getNil(), (IRubyObject)RubyString.newEmptyString(runtime2), IRubyObject.NULL_ARRAY);
    }

    private RubyEnumerator(Ruby runtime2, RubyClass type2, IRubyObject object, IRubyObject method2, IRubyObject[] args2, IRubyObject size2) {
        super(runtime2, type2);
        this.initialize(runtime2, object, method2, args2, size2, null);
    }

    private RubyEnumerator(Ruby runtime2, RubyClass type2, IRubyObject object, IRubyObject method2, IRubyObject[] args2, SizeFn sizeFn) {
        super(runtime2, type2);
        this.initialize(runtime2, object, method2, args2, null, sizeFn);
    }

    private RubyEnumerator(Ruby runtime2, RubyClass type2, IRubyObject object, IRubyObject method2, IRubyObject[] args2) {
        super(runtime2, type2);
        this.initialize(runtime2, object, method2, args2);
    }

    public static IRubyObject enumeratorizeWithSize(ThreadContext context, IRubyObject object, String method2, IRubyObject[] args2, SizeFn sizeFn) {
        Ruby runtime2 = context.runtime;
        return new RubyEnumerator(runtime2, runtime2.getEnumerator(), object, (IRubyObject)runtime2.fastNewSymbol(method2), args2, sizeFn);
    }

    public static IRubyObject enumeratorizeWithSize(ThreadContext context, IRubyObject object, String method2, SizeFn sizeFn) {
        return RubyEnumerator.enumeratorizeWithSize(context, object, method2, NULL_ARRAY, sizeFn);
    }

    public static IRubyObject enumeratorizeWithSize(ThreadContext context, IRubyObject object, String method2, IRubyObject arg2, IRubyObject size2) {
        Ruby runtime2 = context.runtime;
        return new RubyEnumerator(runtime2, runtime2.getEnumerator(), object, (IRubyObject)runtime2.fastNewSymbol(method2), new IRubyObject[]{arg2}, size2);
    }

    public static IRubyObject enumeratorize(Ruby runtime2, IRubyObject object, String method2) {
        return new RubyEnumerator(runtime2, runtime2.getEnumerator(), object, runtime2.fastNewSymbol(method2), IRubyObject.NULL_ARRAY);
    }

    public static IRubyObject enumeratorize(Ruby runtime2, IRubyObject object, String method2, IRubyObject arg2) {
        return new RubyEnumerator(runtime2, runtime2.getEnumerator(), object, runtime2.fastNewSymbol(method2), new IRubyObject[]{arg2});
    }

    public static IRubyObject enumeratorize(Ruby runtime2, IRubyObject object, String method2, IRubyObject ... args2) {
        return new RubyEnumerator(runtime2, runtime2.getEnumerator(), object, runtime2.fastNewSymbol(method2), args2);
    }

    public static IRubyObject enumeratorize(Ruby runtime2, RubyClass type2, IRubyObject object, String method2) {
        return new RubyEnumerator(runtime2, type2, object, runtime2.fastNewSymbol(method2), IRubyObject.NULL_ARRAY);
    }

    public static IRubyObject enumeratorize(Ruby runtime2, RubyClass type2, IRubyObject object, String method2, IRubyObject arg2) {
        return new RubyEnumerator(runtime2, type2, object, runtime2.fastNewSymbol(method2), new IRubyObject[]{arg2});
    }

    public static IRubyObject enumeratorize(Ruby runtime2, RubyClass type2, IRubyObject object, String method2, IRubyObject[] args2) {
        return new RubyEnumerator(runtime2, type2, object, runtime2.fastNewSymbol(method2), args2);
    }

    @Override
    public IRubyObject initialize(ThreadContext context) {
        return this.initialize(context, Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, Block block) {
        return this.initialize(context, NULL_ARRAY, block);
    }

    @Deprecated
    public IRubyObject initialize19(ThreadContext context, Block block) {
        return this.initialize(context, block);
    }

    @Deprecated
    public IRubyObject initialize20(ThreadContext context, Block block) {
        return this.initialize(context, block);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject object, Block block) {
        return this.initialize(context, new IRubyObject[]{object}, block);
    }

    @Deprecated
    public IRubyObject initialize20(ThreadContext context, IRubyObject object, Block block) {
        return this.initialize(context, object, block);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE, rest=true)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2, Block block) {
        IRubyObject object;
        Ruby runtime2 = context.runtime;
        IRubyObject method2 = runtime2.newSymbol("each");
        IRubyObject size2 = null;
        if (block.isGiven()) {
            Arity.checkArgumentCount(runtime2, args2, 0, 1);
            if (args2.length > 0) {
                size2 = args2[0];
                args2 = Arrays.copyOfRange(args2, 1, args2.length);
                if (!(size2.isNil() || size2.respondsTo("call") || runtime2.getFloat().isInstance(size2) && ((RubyFloat)size2).getDoubleValue() == Double.POSITIVE_INFINITY || size2 instanceof RubyInteger)) {
                    throw runtime2.newTypeError(size2, runtime2.getInteger());
                }
            }
            object = runtime2.getGenerator().newInstance(context, IRubyObject.NULL_ARRAY, block);
        } else {
            Arity.checkArgumentCount(runtime2, args2, 1, -1);
            object = args2[0];
            args2 = Arrays.copyOfRange(args2, 1, args2.length);
            if (args2.length > 0) {
                method2 = args2[0];
                args2 = Arrays.copyOfRange(args2, 1, args2.length);
            }
        }
        return this.initialize(runtime2, object, method2, args2, size2, null);
    }

    @Deprecated
    public IRubyObject initialize20(ThreadContext context, IRubyObject[] args2, Block block) {
        return this.initialize(context, args2, block);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject object, IRubyObject method2, Block block) {
        if (block.isGiven()) {
            throw context.runtime.newArgumentError(2, 1);
        }
        return this.initialize(context.runtime, object, method2, NULL_ARRAY);
    }

    public IRubyObject initialize(ThreadContext context, IRubyObject object, IRubyObject method2) {
        return this.initialize(context, object, method2, Block.NULL_BLOCK);
    }

    @Deprecated
    public IRubyObject initialize19(ThreadContext context, IRubyObject object, IRubyObject method2, Block block) {
        return this.initialize(context, object, method2, block);
    }

    @Deprecated
    public IRubyObject initialize20(ThreadContext context, IRubyObject object, IRubyObject method2, Block block) {
        return this.initialize(context, object, method2, block);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject object, IRubyObject method2, IRubyObject methodArg, Block block) {
        if (block.isGiven()) {
            throw context.runtime.newArgumentError(3, 1);
        }
        return this.initialize(context.runtime, object, method2, new IRubyObject[]{methodArg});
    }

    public IRubyObject initialize(ThreadContext context, IRubyObject object, IRubyObject method2, IRubyObject methodArg) {
        return this.initialize(context, object, method2, methodArg, Block.NULL_BLOCK);
    }

    @Deprecated
    public IRubyObject initialize19(ThreadContext context, IRubyObject object, IRubyObject method2, IRubyObject methodArg, Block block) {
        return this.initialize(context, object, method2, methodArg, Block.NULL_BLOCK);
    }

    @Deprecated
    public IRubyObject initialize20(ThreadContext context, IRubyObject object, IRubyObject method2, IRubyObject methodArg, Block block) {
        return this.initialize(context, object, method2, methodArg, block);
    }

    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2) {
        return this.initialize(context, args2, Block.NULL_BLOCK);
    }

    @Deprecated
    public IRubyObject initialize19(ThreadContext context, IRubyObject[] args2, Block block) {
        return this.initialize(context, args2, block);
    }

    private IRubyObject initialize(Ruby runtime2, IRubyObject object, IRubyObject method2, IRubyObject[] methodArgs) {
        return this.initialize(runtime2, object, method2, methodArgs, null, null);
    }

    private IRubyObject initialize(Ruby runtime2, IRubyObject object, IRubyObject method2, IRubyObject[] methodArgs, IRubyObject size2, SizeFn sizeFn) {
        this.object = object;
        this.method = method2.asJavaString();
        this.methodArgs = methodArgs;
        this.size = size2;
        this.sizeFn = sizeFn;
        this.feedValue = runtime2.getNil();
        this.setInstanceVariable("@__object__", object);
        this.setInstanceVariable("@__method__", method2);
        this.setInstanceVariable("@__args__", RubyArray.newArrayMayCopy(runtime2, methodArgs));
        return this;
    }

    @Override
    @JRubyMethod(name={"dup"})
    public IRubyObject dup() {
        RubyEnumerator copy = (RubyEnumerator)super.dup();
        copy.object = this.object;
        copy.method = this.method;
        copy.methodArgs = this.methodArgs;
        copy.size = this.size;
        copy.sizeFn = this.sizeFn;
        copy.feedValue = this.getRuntime().getNil();
        return copy;
    }

    @JRubyMethod
    public IRubyObject each(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return this;
        }
        return this.object.callMethod(context, this.method, this.methodArgs, block);
    }

    @JRubyMethod(rest=true)
    public IRubyObject each(ThreadContext context, IRubyObject[] args2, Block block) {
        if (args2.length == 0) {
            return this.each(context, block);
        }
        int mlen = this.methodArgs.length;
        Object[] newArgs = new IRubyObject[mlen + args2.length];
        ArraySupport.copy(this.methodArgs, newArgs, 0, mlen);
        ArraySupport.copy(args2, newArgs, mlen, args2.length);
        return new RubyEnumerator(context.runtime, this.getType(), this.object, context.runtime.newSymbol("each"), (IRubyObject[])newArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect19(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        if (runtime2.isInspecting(this)) {
            return this.inspect(context, true);
        }
        try {
            runtime2.registerInspecting(this);
            IRubyObject iRubyObject = this.inspect(context, false);
            return iRubyObject;
        }
        finally {
            runtime2.unregisterInspecting(this);
        }
    }

    private IRubyObject inspect(ThreadContext context, boolean recurse) {
        Ruby runtime2 = context.runtime;
        ByteList bytes2 = new ByteList();
        bytes2.append((byte)35).append((byte)60);
        bytes2.append(this.getMetaClass().getName().getBytes());
        bytes2.append((byte)58).append((byte)32);
        if (recurse) {
            bytes2.append("...>".getBytes());
            return RubyString.newStringNoCopy(runtime2, bytes2).taint(context);
        }
        boolean tainted = this.isTaint();
        bytes2.append(RubyObject.inspect(context, this.object).getByteList());
        bytes2.append((byte)58);
        bytes2.append(this.method.getBytes());
        if (this.methodArgs.length > 0) {
            bytes2.append((byte)40);
            for (int i2 = 0; i2 < this.methodArgs.length; ++i2) {
                bytes2.append(RubyObject.inspect(context, this.methodArgs[i2]).getByteList());
                if (i2 < this.methodArgs.length - 1) {
                    bytes2.append((byte)44).append((byte)32);
                } else {
                    bytes2.append((byte)41);
                }
                if (!this.methodArgs[i2].isTaint()) continue;
                tainted = true;
            }
        }
        bytes2.append((byte)62);
        RubyString result2 = RubyString.newStringNoCopy(runtime2, bytes2);
        if (tainted) {
            result2.setTaint(true);
        }
        return result2;
    }

    protected static IRubyObject newEnumerator(ThreadContext context, IRubyObject arg2) {
        Ruby runtime2 = context.runtime;
        return new RubyEnumerator(runtime2, runtime2.getEnumerator(), arg2, runtime2.newSymbol("each"), IRubyObject.NULL_ARRAY);
    }

    protected static IRubyObject newEnumerator(ThreadContext context, IRubyObject arg1, IRubyObject arg2) {
        Ruby runtime2 = context.runtime;
        return new RubyEnumerator(runtime2, runtime2.getEnumerator(), arg1, arg2, IRubyObject.NULL_ARRAY);
    }

    protected static IRubyObject newEnumerator(ThreadContext context, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        Ruby runtime2 = context.runtime;
        return new RubyEnumerator(runtime2, runtime2.getEnumerator(), arg1, arg2, new IRubyObject[]{arg3});
    }

    @JRubyMethod(required=1)
    public IRubyObject each_with_object(ThreadContext context, IRubyObject arg2, Block block) {
        return block.isGiven() ? RubyEnumerable.each_with_objectCommon(context, this, block, arg2) : RubyEnumerator.enumeratorizeWithSize(context, (IRubyObject)this, "each_with_object", new IRubyObject[]{arg2}, this.enumSizeFn(context));
    }

    @JRubyMethod
    public IRubyObject with_object(ThreadContext context, IRubyObject arg2, Block block) {
        return block.isGiven() ? RubyEnumerable.each_with_objectCommon(context, this, block, arg2) : RubyEnumerator.enumeratorizeWithSize(context, (IRubyObject)this, "with_object", new IRubyObject[]{arg2}, this.enumSizeFn(context));
    }

    @JRubyMethod(rest=true)
    public IRubyObject each_entry(ThreadContext context, IRubyObject[] args2, Block block) {
        return block.isGiven() ? RubyEnumerable.each_entryCommon(context, this, args2, block) : RubyEnumerator.enumeratorize(context.runtime, this.getType(), (IRubyObject)this, "each_entry", args2);
    }

    @Deprecated
    public IRubyObject each_slice19(ThreadContext context, IRubyObject arg2, Block block) {
        return this.each_slice(context, arg2, block);
    }

    @JRubyMethod(name={"each_slice"})
    public IRubyObject each_slice(ThreadContext context, IRubyObject arg2, Block block) {
        int size2 = (int)RubyNumeric.num2long(arg2);
        if (size2 <= 0) {
            throw context.runtime.newArgumentError("invalid size");
        }
        return block.isGiven() ? RubyEnumerable.each_sliceCommon(context, this, size2, block) : RubyEnumerator.enumeratorize(context.runtime, this.getType(), (IRubyObject)this, "each_slice", arg2);
    }

    @Deprecated
    public IRubyObject each_cons19(ThreadContext context, IRubyObject arg2, Block block) {
        return this.each_cons(context, arg2, block);
    }

    @JRubyMethod(name={"each_cons"})
    public IRubyObject each_cons(ThreadContext context, IRubyObject arg2, Block block) {
        int size2 = (int)RubyNumeric.num2long(arg2);
        if (size2 <= 0) {
            throw context.runtime.newArgumentError("invalid size");
        }
        return block.isGiven() ? RubyEnumerable.each_consCommon(context, this, size2, block) : RubyEnumerator.enumeratorize(context.runtime, this.getType(), (IRubyObject)this, "each_cons", arg2);
    }

    @JRubyMethod
    public final IRubyObject size(ThreadContext context) {
        if (this.sizeFn != null) {
            return this.sizeFn.size(this.methodArgs);
        }
        IRubyObject size2 = this.size;
        if (size2 != null) {
            if (size2.respondsTo("call")) {
                if (context == null) {
                    context = this.getRuntime().getCurrentContext();
                }
                return size2.callMethod(context, "call");
            }
            return size2;
        }
        if (context == null) {
            context = this.getRuntime().getCurrentContext();
        }
        return context.nil;
    }

    public long size() {
        IRubyObject size2 = this.size(null);
        if (size2 instanceof RubyNumeric) {
            return ((RubyNumeric)size2).getLongValue();
        }
        return -1L;
    }

    private SizeFn enumSizeFn(final ThreadContext context) {
        final RubyEnumerator self2 = this;
        return new SizeFn(){

            @Override
            public IRubyObject size(IRubyObject[] args2) {
                return self2.size(context);
            }
        };
    }

    private IRubyObject with_index_common(ThreadContext context, Block block, String rubyMethodName, IRubyObject arg2) {
        int index2;
        Ruby runtime2 = context.runtime;
        int n = index2 = arg2.isNil() ? 0 : RubyNumeric.num2int(arg2);
        if (!block.isGiven()) {
            return arg2.isNil() ? RubyEnumerator.enumeratorizeWithSize(context, this, rubyMethodName, this.enumSizeFn(context)) : RubyEnumerator.enumeratorizeWithSize(context, (IRubyObject)this, rubyMethodName, new IRubyObject[]{runtime2.newFixnum(index2)}, this.enumSizeFn(context));
        }
        return RubyEnumerable.callEach(runtime2, context, this, new RubyEnumerable.EachWithIndex(block, index2));
    }

    @JRubyMethod
    public IRubyObject each_with_index(ThreadContext context, Block block) {
        return this.with_index_common(context, block, "each_with_index", context.nil);
    }

    @JRubyMethod(name={"with_index"})
    public IRubyObject with_index(ThreadContext context, Block block) {
        return this.with_index_common(context, block, "with_index", context.nil);
    }

    @Deprecated
    public IRubyObject with_index19(ThreadContext context, Block block) {
        return this.with_index(context, block);
    }

    @JRubyMethod(name={"with_index"})
    public IRubyObject with_index(ThreadContext context, IRubyObject arg2, Block block) {
        return this.with_index_common(context, block, "with_index", arg2);
    }

    @Deprecated
    public IRubyObject with_index19(ThreadContext context, IRubyObject arg2, Block block) {
        return this.with_index(context, arg2, block);
    }

    @JRubyMethod
    public synchronized IRubyObject next(ThreadContext context) {
        Nexter nexter = this.ensureNexter(context.runtime);
        if (!this.feedValue.isNil()) {
            this.feedValue = context.nil;
        }
        return nexter.next();
    }

    @JRubyMethod
    public synchronized IRubyObject rewind(ThreadContext context) {
        if (this.object.respondsTo("rewind")) {
            this.object.callMethod(context, "rewind");
        }
        if (this.nexter != null) {
            this.nexter.shutdown();
            this.nexter = null;
        }
        return this;
    }

    @JRubyMethod
    public synchronized IRubyObject peek(ThreadContext context) {
        Nexter nexter = this.ensureNexter(context.runtime);
        return nexter.peek();
    }

    @JRubyMethod(name={"peek_values"})
    public IRubyObject peekValues(ThreadContext context) {
        return RubyArray.newArray(context.runtime, this.peek(context));
    }

    @JRubyMethod(name={"next_values"})
    public IRubyObject nextValues(ThreadContext context) {
        return RubyArray.newArray(context.runtime, this.next(context));
    }

    @JRubyMethod
    public synchronized IRubyObject feed(ThreadContext context, IRubyObject val) {
        Nexter nexter = this.ensureNexter(context.runtime);
        if (!this.feedValue.isNil()) {
            throw context.runtime.newTypeError("feed value already set");
        }
        this.feedValue = val;
        nexter.setFeedValue(val);
        return context.nil;
    }

    private Nexter ensureNexter(Ruby runtime2) {
        Nexter nexter = this.nexter;
        if (nexter != null) {
            return nexter;
        }
        if (((Boolean)Options.ENUMERATOR_LIGHTWEIGHT.load()).booleanValue() && this.object instanceof RubyArray && this.method.equals("each") && this.methodArgs.length == 0) {
            this.nexter = new ArrayNexter(runtime2, this.object, this.method, this.methodArgs);
            return this.nexter;
        }
        this.nexter = new ThreadedNexter(runtime2, this.object, this.method, this.methodArgs);
        return this.nexter;
    }

    protected void finalize() throws Throwable {
        try {
            Nexter nexter = this.nexter;
            if (nexter != null) {
                nexter.shutdown();
                Object var1_1 = null;
            }
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public synchronized boolean hasNext() {
        return this.ensureNexter(this.getRuntime()).hasNext();
    }

    @Override
    public Object next() {
        return this.next(this.getRuntime().getCurrentContext()).toJava(Object.class);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public Stream<Object> stream() {
        return this.stream(false);
    }

    public Stream<Object> stream(boolean parallel) {
        return StreamSupport.stream(this.spliterator(), parallel);
    }

    public Spliterator<Object> spliterator() {
        long size2 = this.size();
        int mod = 1024;
        if (size2 >= 0L) {
            mod |= 0x40;
        }
        return Spliterators.spliterator(this, size2, mod);
    }

    public Spliterator<Object> spliterator(int mod) {
        return Spliterators.spliterator(this, this.size(), mod);
    }

    private static class ThreadedNexter
    extends Nexter
    implements Runnable {
        private static final boolean DEBUG = false;
        final SynchronousQueue<IRubyObject> out = new SynchronousQueue();
        private volatile Thread thread;
        private IRubyObject doneObject;
        private Future future;
        protected volatile boolean die = false;
        private IRubyObject lastValue;
        private volatile IRubyObject stopValue;

        public ThreadedNexter(Ruby runtime2, IRubyObject object, String method2, IRubyObject[] methodArgs) {
            super(runtime2, object, method2, methodArgs);
            this.setFeedValue(runtime2.getNil());
        }

        @Override
        public synchronized IRubyObject next() {
            return this.nextImpl(false);
        }

        @Override
        public synchronized void shutdown() {
            this.future.cancel(true);
            this.die = true;
            if (this.dissociateNexterThread(true)) {
                this.doneObject = null;
            }
        }

        private synchronized boolean dissociateNexterThread(boolean interrupt) {
            Thread nexterThread = this.thread;
            if (nexterThread != null) {
                if (interrupt) {
                    nexterThread.interrupt();
                    nexterThread.interrupt();
                }
                this.thread = null;
                return true;
            }
            return false;
        }

        @Override
        public synchronized IRubyObject peek() {
            if (this.doneObject != null) {
                return this.returnValue(this.doneObject, false);
            }
            this.ensureStarted();
            if (this.lastValue != null) {
                return this.lastValue;
            }
            this.peekTake();
            return this.returnValue(this.lastValue, false);
        }

        private void ensureStarted() {
            try {
                if (this.thread == null) {
                    this.future = this.runtime.getFiberExecutor().submit(this);
                }
            }
            catch (OutOfMemoryError oome) {
                String oomeMessage = oome.getMessage();
                if (oomeMessage != null && oomeMessage.contains("unable to create new native thread")) {
                    System.gc();
                    this.future = this.runtime.getFiberExecutor().submit(this);
                }
                throw oome;
            }
        }

        private IRubyObject peekTake() {
            try {
                this.lastValue = this.out.take();
                return this.lastValue;
            }
            catch (InterruptedException ie) {
                throw this.runtime.newThreadError("interrupted during iteration");
            }
        }

        private IRubyObject take() {
            try {
                if (this.lastValue != null) {
                    IRubyObject iRubyObject = this.lastValue;
                    return iRubyObject;
                }
                IRubyObject iRubyObject = this.out.take();
                return iRubyObject;
            }
            catch (InterruptedException ie) {
                throw this.runtime.newThreadError("interrupted during iteration");
            }
            finally {
                this.lastValue = null;
            }
        }

        private IRubyObject returnValue(IRubyObject value2, boolean silent) {
            if (value2 == RubyBasicObject.NEVER) {
                this.doneObject = value2;
                if (silent) {
                    return null;
                }
                throw this.runtime.newStopIteration(this.stopValue, "iteration reached an end");
            }
            if (value2 instanceof RubyException) {
                this.doneObject = value2;
                if (silent) {
                    return null;
                }
                throw ((RubyException)value2).toThrowable();
            }
            return value2;
        }

        private IRubyObject nextImpl(boolean hasNext) {
            if (this.doneObject != null) {
                return this.returnValue(this.doneObject, hasNext);
            }
            this.ensureStarted();
            return this.returnValue(this.take(), hasNext);
        }

        @Override
        final synchronized boolean hasNext() {
            if (this.doneObject == RubyBasicObject.NEVER) {
                return false;
            }
            this.lastValue = this.nextImpl(true);
            return this.lastValue != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.die) {
                return;
            }
            this.thread = Thread.currentThread();
            ThreadContext context = this.runtime.getCurrentContext();
            IRubyObject finalObject = RubyBasicObject.NEVER;
            try {
                IRubyObject oldExc = this.runtime.getGlobalVariables().get("$!");
                final TerminateEnumeration terminateEnumeration = new TerminateEnumeration();
                Block generatorClosure = CallBlock.newCallClosure(this.object, (RubyModule)this.object.getMetaClass(), Signature.OPTIONAL, new BlockCallback(){

                    @Override
                    public IRubyObject call(ThreadContext context, IRubyObject[] args2, Block block) {
                        try {
                            if (die) {
                                throw terminateEnumeration;
                            }
                            out.put(RubyEnumerable.packEnumValues(context, args2));
                            if (die) {
                                throw terminateEnumeration;
                            }
                        }
                        catch (InterruptedException ie) {
                            throw terminateEnumeration;
                        }
                        IRubyObject feedValue = this.getFeedValue();
                        this.setFeedValue(context.nil);
                        return feedValue;
                    }
                }, context);
                try {
                    this.stopValue = this.object.callMethod(context, this.method, this.methodArgs, generatorClosure);
                }
                catch (TerminateEnumeration te) {
                    if (te != terminateEnumeration) {
                        throw te;
                    }
                }
                catch (RaiseException re) {
                    finalObject = re.getException();
                    this.runtime.getGlobalVariables().set("$!", oldExc);
                }
                catch (Throwable t) {
                    Helpers.throwException(t);
                }
                try {
                    if (!this.die) {
                        this.out.put(finalObject);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            finally {
                this.dissociateNexterThread(false);
            }
        }

        private static class TerminateEnumeration
        extends RuntimeException
        implements Unrescuable {
            private TerminateEnumeration() {
            }
        }
    }

    private static class ArrayNexter
    extends Nexter {
        private final RubyArray array;
        private int index = 0;

        public ArrayNexter(Ruby runtime2, IRubyObject object, String method2, IRubyObject[] methodArgs) {
            super(runtime2, object, method2, methodArgs);
            this.array = (RubyArray)object;
        }

        @Override
        public IRubyObject next() {
            IRubyObject obj = this.peek();
            ++this.index;
            return obj;
        }

        @Override
        public void shutdown() {
            this.index = 0;
        }

        @Override
        public IRubyObject peek() {
            this.checkIndex();
            return this.get();
        }

        protected IRubyObject get() {
            return this.array.eltOk(this.index);
        }

        private void checkIndex() throws RaiseException {
            if (!this.hasNext()) {
                throw this.runtime.newStopIteration(this.array, null);
            }
        }

        @Override
        final boolean hasNext() {
            return this.index < this.array.size();
        }
    }

    private static abstract class Nexter {
        protected final Ruby runtime;
        protected final IRubyObject object;
        protected final String method;
        protected final IRubyObject[] methodArgs;
        private IRubyObject feedValue;

        public Nexter(Ruby runtime2, IRubyObject object, String method2, IRubyObject[] methodArgs) {
            this.object = object;
            this.method = method2;
            this.methodArgs = methodArgs;
            this.runtime = runtime2;
        }

        public void setFeedValue(IRubyObject feedValue) {
            this.feedValue = feedValue;
        }

        public IRubyObject getFeedValue() {
            return this.feedValue;
        }

        public abstract IRubyObject next();

        public abstract void shutdown();

        public abstract IRubyObject peek();

        abstract boolean hasNext();
    }

    public static interface SizeFn {
        public IRubyObject size(IRubyObject[] var1);
    }
}

