/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.targets;

import com.headius.invokebinder.Binder;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.MutableCallSite;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.targets.Bootstrap;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.CompiledIRBlockBody;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CodegenUtils;
import org.jruby.util.cli.Options;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;
import org.objectweb.asm.Handle;

public class YieldSite
extends MutableCallSite {
    private final boolean unwrap;
    private int bindCount;
    private static final int MAX_REBIND = 2;
    private static final Logger LOG = LoggerFactory.getLogger(YieldSite.class);
    public static final Handle BOOTSTRAP = new Handle(6, CodegenUtils.p(YieldSite.class), "bootstrap", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, Integer.TYPE), false);

    public YieldSite(MethodType type2, boolean unwrap) {
        super(type2);
        this.unwrap = unwrap;
    }

    public static CallSite bootstrap(MethodHandles.Lookup lookup, String name2, MethodType type2, int unwrap) throws Throwable {
        MethodHandle handle;
        YieldSite site = new YieldSite(type2, unwrap == 1);
        switch (name2) {
            case "yield": 
            case "yieldSpecific": {
                handle = Binder.from((MethodType)type2).prepend(YieldSite.class, (Object)site).invokeVirtual(lookup, name2);
                break;
            }
            case "yieldValues": {
                handle = Binder.from((MethodType)type2).collect(2, IRubyObject[].class).prepend(YieldSite.class, (Object)site).invokeVirtual(lookup, name2);
                break;
            }
            default: {
                throw new RuntimeException("invalid yield type: " + name2);
            }
        }
        site.setTarget(handle);
        return site;
    }

    public IRubyObject yield(ThreadContext context, Block block, IRubyObject arg2) throws Throwable {
        if (((Boolean)Options.INVOKEDYNAMIC_YIELD.load()).booleanValue()) {
            if (++this.bindCount >= 2) {
                if (((Boolean)Options.INVOKEDYNAMIC_LOG_BINDING.load()).booleanValue()) {
                    LOG.info("yield \tdisabled due to polymorphism:" + Bootstrap.logBlock(block), new Object[0]);
                }
            } else {
                MethodHandle target;
                BlockBody body = block.getBody();
                if (block.getBody() instanceof CompiledIRBlockBody) {
                    CompiledIRBlockBody compiledBody = (CompiledIRBlockBody)block.getBody();
                    if (((Boolean)Options.INVOKEDYNAMIC_LOG_BINDING.load()).booleanValue()) {
                        LOG.info("yield \tbound directly as yield:" + Bootstrap.logBlock(block), new Object[0]);
                    }
                    target = this.unwrap ? compiledBody.getNormalYieldUnwrapHandle() : compiledBody.getNormalYieldHandle();
                } else {
                    if (((Boolean)Options.INVOKEDYNAMIC_LOG_BINDING.load()).booleanValue()) {
                        LOG.info("yield \tbound indirectly as yield:" + Bootstrap.logBlock(block), new Object[0]);
                    }
                    target = Binder.from((MethodType)this.type()).append(this.unwrap).invokeStaticQuiet(MethodHandles.lookup(), IRRuntimeHelpers.class, "yield");
                }
                MethodHandle fallback = this.getTarget();
                MethodHandle test2 = body.getTestBlockBody();
                MethodHandle guard = MethodHandles.guardWithTest(test2, target, fallback);
                this.setTarget(guard);
                return target.invokeExact(context, block, arg2);
            }
        }
        return IRRuntimeHelpers.yield(context, block, arg2, this.unwrap);
    }

    public IRubyObject yieldSpecific(ThreadContext context, Block block) throws Throwable {
        if (((Boolean)Options.INVOKEDYNAMIC_YIELD.load()).booleanValue()) {
            if (++this.bindCount >= 2) {
                if (((Boolean)Options.INVOKEDYNAMIC_LOG_BINDING.load()).booleanValue()) {
                    LOG.info("yield \tdisabled due to polymorphism:" + Bootstrap.logBlock(block), new Object[0]);
                }
            } else {
                MethodHandle target;
                BlockBody body = block.getBody();
                if (block.getBody() instanceof CompiledIRBlockBody) {
                    CompiledIRBlockBody compiledBody = (CompiledIRBlockBody)block.getBody();
                    if (((Boolean)Options.INVOKEDYNAMIC_LOG_BINDING.load()).booleanValue()) {
                        LOG.info("yield \tbound directly as yieldSpecific:" + Bootstrap.logBlock(block), new Object[0]);
                    }
                    target = compiledBody.getNormalYieldSpecificHandle();
                } else {
                    if (((Boolean)Options.INVOKEDYNAMIC_LOG_BINDING.load()).booleanValue()) {
                        LOG.info("yield \tbound indirectly as yieldSpecific:" + Bootstrap.logBlock(block), new Object[0]);
                    }
                    target = Binder.from((MethodType)this.type()).permute(new int[]{1, 0}).invokeVirtualQuiet(MethodHandles.lookup(), "yieldSpecific");
                }
                MethodHandle fallback = this.getTarget();
                MethodHandle test2 = body.getTestBlockBody();
                MethodHandle guard = MethodHandles.guardWithTest(test2, target, fallback);
                this.setTarget(guard);
                return target.invokeExact(context, block);
            }
        }
        return block.yieldSpecific(context);
    }

    public IRubyObject yieldValues(ThreadContext context, Block block, IRubyObject[] args2) {
        if (((Boolean)Options.INVOKEDYNAMIC_YIELD.load()).booleanValue() && ((Boolean)Options.INVOKEDYNAMIC_LOG_BINDING.load()).booleanValue()) {
            LOG.info("yield \tbound indirectly as yieldValues:" + Bootstrap.logBlock(block), new Object[0]);
        }
        return block.yieldValues(context, args2);
    }
}

