/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.IOException;
import java.nio.file.attribute.FileTime;
import jnr.posix.FileStat;
import org.jruby.runtime.Helpers;
import org.jruby.util.FileResource;

final class DummyResourceStat
implements FileStat {
    private final FileResourceExt resource;

    DummyResourceStat(FileResourceExt resource2) {
        this.resource = resource2;
    }

    public long blocks() {
        return this.resource.length();
    }

    public long blockSize() {
        return 1L;
    }

    public long dev() {
        return -1L;
    }

    public String ftype() {
        return "unknown";
    }

    public int gid() {
        return -1;
    }

    public boolean groupMember(int i2) {
        return false;
    }

    public long ino() {
        return -1L;
    }

    public boolean isBlockDev() {
        return false;
    }

    public boolean isCharDev() {
        return false;
    }

    public boolean isDirectory() {
        return this.resource.isDirectory();
    }

    public boolean isEmpty() {
        return this.resource.length() == 0L;
    }

    public boolean isExecutable() {
        return false;
    }

    public boolean isExecutableReal() {
        return false;
    }

    public boolean isFifo() {
        return false;
    }

    public boolean isFile() {
        return this.resource.isFile();
    }

    public boolean isGroupOwned() {
        return false;
    }

    public boolean isIdentical(FileStat fs) {
        return fs instanceof DummyResourceStat && ((DummyResourceStat)fs).resource.equals(this.resource);
    }

    public boolean isNamedPipe() {
        return false;
    }

    public boolean isOwned() {
        return false;
    }

    public boolean isROwned() {
        return false;
    }

    public boolean isReadable() {
        return this.resource.canRead();
    }

    public boolean isReadableReal() {
        return this.isReadable();
    }

    public boolean isWritable() {
        return false;
    }

    public boolean isWritableReal() {
        return this.isWritable();
    }

    public boolean isSetgid() {
        return false;
    }

    public boolean isSetuid() {
        return false;
    }

    public boolean isSocket() {
        return false;
    }

    public boolean isSticky() {
        return false;
    }

    public boolean isSymlink() {
        return false;
    }

    public int major(long l) {
        return -1;
    }

    public int minor(long l) {
        return -1;
    }

    public int mode() {
        return -1;
    }

    public int nlink() {
        return -1;
    }

    public long rdev() {
        return -1L;
    }

    public long st_size() {
        return this.resource.length();
    }

    public int uid() {
        return 0;
    }

    public long ctime() {
        FileTime time = null;
        try {
            time = this.resource.creationTime();
        }
        catch (IOException ex) {
            Helpers.throwException(ex);
        }
        return time == null ? 0L : time.toMillis();
    }

    public long atime() {
        FileTime time = null;
        try {
            time = this.resource.lastAccessTime();
        }
        catch (IOException ex) {
            Helpers.throwException(ex);
        }
        return time == null ? 0L : time.toMillis();
    }

    public long mtime() {
        FileTime time = null;
        try {
            time = this.resource.lastModifiedTime();
        }
        catch (IOException ex) {
            Helpers.throwException(ex);
        }
        return time == null ? 0L : time.toMillis();
    }

    static interface FileResourceExt
    extends FileResource {
        public FileTime creationTime() throws IOException;

        public FileTime lastAccessTime() throws IOException;

        public FileTime lastModifiedTime() throws IOException;
    }
}

