/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.Arrays;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.RubySymbol;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.CallInstr;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Symbol;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.CallType;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class ConstMissingInstr
extends CallInstr
implements FixedArityInstr {
    private final RubySymbol missingConst;
    private static final ByteList CONST_MISSING = new ByteList(new byte[]{99, 111, 110, 115, 116, 95, 109, 105, 115, 115, 105, 110, 103});

    public ConstMissingInstr(IRScope scope, Variable result2, Operand currentModule, RubySymbol missingConst, boolean isPotentiallyRefined) {
        super(scope, Operation.CONST_MISSING, CallType.FUNCTIONAL, result2, missingConst.getRuntime().newSymbol(CONST_MISSING), currentModule, new Operand[]{new Symbol(missingConst)}, null, isPotentiallyRefined);
        this.missingConst = missingConst;
    }

    public RubySymbol getMissingConst() {
        return this.missingConst;
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new ConstMissingInstr(ii.getScope(), ii.getRenamedVariable(this.result), this.getReceiver().cloneForInlining(ii), this.missingConst, this.isPotentiallyRefined());
    }

    @Override
    public void encode(IRWriterEncoder e) {
        if (RubyInstanceConfig.IR_WRITING_DEBUG) {
            System.out.println("Instr(" + (Object)((Object)this.getOperation()) + "): " + this);
        }
        e.encode(this.getOperation());
        e.encode(this.getResult());
        e.encode(this.getReceiver());
        e.encode(this.getMissingConst());
    }

    public static ConstMissingInstr decode(IRReaderDecoder d) {
        return new ConstMissingInstr(d.getCurrentScope(), d.decodeVariable(), d.decodeOperand(), d.decodeSymbol(), d.getCurrentScope().maybeUsingRefinements());
    }

    @Override
    public String[] toStringNonOperandArgs() {
        String[] base = super.toStringNonOperandArgs();
        String[] args2 = Arrays.copyOf(base, base.length + 1);
        args2[args2.length - 1] = "missing: " + this.missingConst;
        return args2;
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        RubyModule module = (RubyModule)this.getReceiver().retrieve(context, self2, currScope, currDynScope, temp);
        return module.callMethod(context, "const_missing", (IRubyObject)this.missingConst);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.ConstMissingInstr(this);
    }
}

