/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.ObjectFlags;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallBlock19;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.ByteList;
import org.jruby.util.RecursiveComparator;
import org.jruby.util.TypeConverter;

@JRubyClass(name={"Hash"}, include={"Enumerable"})
public class RubyHash
extends RubyObject
implements Map {
    public static final int DEFAULT_INSPECT_STR_SIZE = 20;
    public static final int COMPARE_BY_IDENTITY_F = ObjectFlags.COMPARE_BY_IDENTITY_F;
    private static final ObjectAllocator HASH_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new RubyHash(runtime2, klass);
        }
    };
    private RubyHashEntry[] table;
    protected int size = 0;
    private int threshold;
    private static final int PROCDEFAULT_HASH_F = ObjectFlags.PROCDEFAULT_HASH_F;
    private IRubyObject ifNone;
    public static final int[] MRI_PRIMES = new int[]{11, 19, 37, 67, 131, 283, 521, 1033, 2053, 4099, 8219, 16427, 32771, 65581, 131101, 262147, 524309, 0x100007, 0x200011, 0x40000F, 0x800009, 16777259, 0x2000023, 0x400000F, 134217757, 0x10000003, 0x2000000B, 0x40000055, 0};
    private static final int JAVASOFT_INITIAL_CAPACITY = 8;
    private static final int MRI_INITIAL_CAPACITY = MRI_PRIMES[0];
    private static final int INITIAL_THRESHOLD = 6;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    public static final RubyHashEntry NO_ENTRY = new RubyHashEntry();
    private int generation = 0;
    private final RubyHashEntry head = new RubyHashEntry();
    private static final int HASH_SIGN_BIT_MASK = Integer.MAX_VALUE;
    private static final int MIN_CAPA = 8;
    private static final int ST_DEFAULT_MAX_DENSITY = 5;
    private static final boolean MRI_HASH = true;
    private static final boolean MRI_HASH_RESIZE = true;
    private static final EntryMatchType MATCH_KEY = new EntryMatchType(){

        @Override
        public boolean matches(RubyHashEntry entry, Object obj) {
            IRubyObject key2 = entry.key;
            return obj == key2 || ((IRubyObject)obj).eql(key2);
        }
    };
    private static final EntryMatchType MATCH_ENTRY = new EntryMatchType(){

        @Override
        public boolean matches(RubyHashEntry entry, Object obj) {
            return entry.equals(obj);
        }
    };
    private static final VisitorWithState<RubyString> InspectVisitor = new VisitorWithState<RubyString>(){

        @Override
        public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, RubyString str) {
            RubyString keyStr = RubyObject.inspect(context, key2);
            RubyString valStr = RubyObject.inspect(context, value2);
            ByteList bytes2 = str.getByteList();
            bytes2.ensure(2 + keyStr.size() + 2 + valStr.size());
            if (index2 > 0) {
                bytes2.append((byte)44).append((byte)32);
            }
            str.cat19(keyStr);
            bytes2.append((byte)61).append((byte)62);
            str.cat19(valStr);
        }
    };
    private static final VisitorWithState<RubyArray> StoreKeyValueVisitor = new VisitorWithState<RubyArray>(){

        @Override
        public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, RubyArray result2) {
            result2.store(index2, RubyArray.newArray(context.runtime, key2, value2));
        }
    };
    private static final VisitorWithState<RubyHash> FindMismatchUsingEqualVisitor = new VisitorWithState<RubyHash>(){

        @Override
        public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, RubyHash otherHash) {
            IRubyObject value22 = otherHash.fastARef(key2);
            if (value22 == null) {
                throw MISMATCH;
            }
            if (!Helpers.rbEqual(context, value2, value22).isTrue()) {
                throw MISMATCH;
            }
        }
    };
    private static final VisitorWithState<RubyHash> FindMismatchUsingEqlVisitor = new VisitorWithState<RubyHash>(){

        @Override
        public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, RubyHash otherHash) {
            IRubyObject value22 = otherHash.fastARef(key2);
            if (value22 == null) {
                throw MISMATCH;
            }
            if (!Helpers.rbEql(context, value2, value22).isTrue()) {
                throw MISMATCH;
            }
        }
    };
    private static final VisitorWithState<long[]> CalculateHashVisitor = new VisitorWithState<long[]>(){

        @Override
        public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, long[] hval) {
            hval[0] = hval[0] + (Helpers.safeHash(context, key2).convertToInteger().getLongValue() ^ Helpers.safeHash(context, value2).convertToInteger().getLongValue());
        }
    };
    private static final Found FOUND = new Found();
    private static final VisitorWithState<IRubyObject> FoundIfEqualVisitor = new VisitorWithState<IRubyObject>(){

        @Override
        public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, IRubyObject expected) {
            if (RubyObject.equalInternal(context, value2, expected)) {
                throw FOUND;
            }
        }
    };
    private volatile int iteratorCount;
    private static final AtomicIntegerFieldUpdater<RubyHash> ITERATOR_UPDATER;
    private static final VisitorWithState<Block> YieldArrayVisitor;
    private static final VisitorWithState<Block> YieldKeyValueArrayVisitor;
    private static final VisitorWithState<Block> YieldValueVisitor;
    private static final VisitorWithState<Block> YieldKeyVisitor;
    private static final VisitorWithState<IRubyObject> FoundKeyIfEqual;
    private static final VisitorWithState<RubyArray> StoreKeyVisitor;
    public static final VisitorWithState<RubyArray> StoreValueVisitor;
    private static final Mismatch MISMATCH;
    private static final VisitorWithState<Block> DeleteIfVisitor;
    private static final VisitorWithState<RubyHash> InvertVisitor;
    private static final VisitorWithState<RubyHash> ReplaceVisitor;
    private static final VisitorWithState<IRubyObject> FoundPairIfEqualKeyVisitor;
    private static final VisitorWithState<IRubyObject> FoundPairIfEqualValueVisitor;
    private static final VisitorWithState<MarshalStream> MarshalDumpVisitor;
    private static final EntryView DIRECT_KEY_VIEW;
    private static final EntryView KEY_VIEW;
    private static final EntryView DIRECT_VALUE_VIEW;
    private static final EntryView VALUE_VIEW;
    private static final EntryView DIRECT_ENTRY_VIEW;
    private static final EntryView ENTRY_VIEW;

    public static RubyClass createHashClass(Ruby runtime2) {
        RubyClass hashc = runtime2.defineClass("Hash", runtime2.getObject(), HASH_ALLOCATOR);
        runtime2.setHash(hashc);
        hashc.setClassIndex(ClassIndex.HASH);
        hashc.setReifiedClass(RubyHash.class);
        hashc.kindOf = new RubyModule.JavaClassKindOf(RubyHash.class);
        hashc.includeModule(runtime2.getEnumerable());
        hashc.defineAnnotatedMethods(RubyHash.class);
        return hashc;
    }

    @Override
    public ClassIndex getNativeClassIndex() {
        return ClassIndex.HASH;
    }

    @JRubyMethod(name={"[]"}, rest=true, meta=true)
    public static IRubyObject create(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        Ruby runtime2 = context.runtime;
        if (args2.length == 1) {
            IRubyObject tmp = TypeConverter.convertToTypeWithCheck(args2[0], runtime2.getHash(), "to_hash");
            if (tmp != context.nil) {
                return new RubyHash(runtime2, (RubyClass)recv2, (RubyHash)tmp);
            }
            tmp = TypeConverter.convertToTypeWithCheck(args2[0], runtime2.getArray(), "to_ary");
            if (tmp != context.nil) {
                RubyHash hash2 = (RubyHash)((RubyClass)recv2).allocate();
                RubyArray arr = (RubyArray)tmp;
                int j = arr.getLength();
                for (int i2 = 0; i2 < j; ++i2) {
                    IRubyObject e = arr.entry(i2);
                    IRubyObject v = TypeConverter.convertToTypeWithCheck(e, runtime2.getArray(), "to_ary");
                    IRubyObject val = runtime2.getNil();
                    if (v == context.nil) {
                        runtime2.getWarnings().warn("wrong element type " + e.getMetaClass() + " at " + i2 + " (expected array)");
                        runtime2.getWarnings().warn("ignoring wrong elements is deprecated, remove them explicitly");
                        runtime2.getWarnings().warn("this causes ArgumentError in the next release");
                        continue;
                    }
                    switch (((RubyArray)v).getLength()) {
                        default: {
                            throw runtime2.newArgumentError("invalid number of elements (" + ((RubyArray)v).getLength() + " for 1..2)");
                        }
                        case 2: {
                            val = ((RubyArray)v).entry(1);
                        }
                        case 1: 
                    }
                    IRubyObject key2 = ((RubyArray)v).entry(0);
                    hash2.fastASetCheckString(runtime2, key2, val);
                }
                return hash2;
            }
        }
        if ((args2.length & 1) != 0) {
            throw runtime2.newArgumentError("odd number of arguments for Hash");
        }
        RubyHash hash3 = (RubyHash)((RubyClass)recv2).allocate();
        for (int i3 = 0; i3 < args2.length; i3 += 2) {
            hash3.fastASetCheckString(runtime2, args2[i3], args2[i3 + 1]);
        }
        return hash3;
    }

    @JRubyMethod(name={"try_convert"}, meta=true)
    public static IRubyObject try_convert(ThreadContext context, IRubyObject recv2, IRubyObject args2) {
        return TypeConverter.convertToTypeWithCheck(args2, context.runtime.getHash(), "to_hash");
    }

    public static final RubyHash newHash(Ruby runtime2) {
        return new RubyHash(runtime2);
    }

    public static final RubyHash newSmallHash(Ruby runtime2) {
        return new RubyHash(runtime2, 1);
    }

    public static RubyHash newKwargs(Ruby runtime2, String key2, IRubyObject value2) {
        RubyHash kwargs = RubyHash.newSmallHash(runtime2);
        kwargs.fastASetSmall(runtime2.newSymbol(key2), value2);
        return kwargs;
    }

    public static final RubyHash newHash(Ruby runtime2, Map valueMap, IRubyObject defaultValue) {
        assert (defaultValue != null);
        return new RubyHash(runtime2, valueMap, defaultValue);
    }

    private RubyHash(Ruby runtime2, RubyClass klass, RubyHash other) {
        super(runtime2, klass);
        this.head.prevAdded = (this.head.nextAdded = this.head);
        this.ifNone = UNDEF;
        this.threshold = 6;
        this.table = other.internalCopyTable(this.head);
        this.size = other.size;
    }

    public RubyHash(Ruby runtime2, RubyClass klass) {
        super(runtime2, klass);
        this.head.prevAdded = (this.head.nextAdded = this.head);
        this.ifNone = UNDEF;
        this.allocFirst();
    }

    public RubyHash(Ruby runtime2, int buckets) {
        this(runtime2, UNDEF, buckets);
    }

    public RubyHash(Ruby runtime2) {
        this(runtime2, UNDEF);
    }

    public RubyHash(Ruby runtime2, IRubyObject defaultValue) {
        super(runtime2, runtime2.getHash());
        this.head.prevAdded = (this.head.nextAdded = this.head);
        this.ifNone = defaultValue;
        this.allocFirst();
    }

    public RubyHash(Ruby runtime2, IRubyObject defaultValue, int buckets) {
        super(runtime2, runtime2.getHash());
        this.head.prevAdded = (this.head.nextAdded = this.head);
        this.ifNone = defaultValue;
        this.allocFirst(buckets);
    }

    protected RubyHash(Ruby runtime2, RubyClass metaClass, IRubyObject defaultValue, RubyHashEntry[] initialTable, int threshold) {
        super(runtime2, metaClass);
        this.head.prevAdded = (this.head.nextAdded = this.head);
        this.ifNone = defaultValue;
        this.threshold = threshold;
        this.table = initialTable;
    }

    RubyHash(Ruby runtime2, boolean objectSpace) {
        super(runtime2, runtime2.getHash(), objectSpace);
        this.head.prevAdded = (this.head.nextAdded = this.head);
        this.allocFirst();
    }

    public RubyHash(Ruby runtime2, Map valueMap, IRubyObject defaultValue) {
        super(runtime2, runtime2.getHash());
        this.head.prevAdded = (this.head.nextAdded = this.head);
        this.ifNone = defaultValue;
        this.allocFirst();
        for (Map.Entry e : valueMap.entrySet()) {
            this.internalPut((IRubyObject)e.getKey(), (IRubyObject)e.getValue());
        }
    }

    private final void allocFirst() {
        this.threshold = 6;
        this.table = new RubyHashEntry[MRI_INITIAL_CAPACITY];
    }

    private final void allocFirst(int buckets) {
        if (buckets <= 0) {
            throw new ArrayIndexOutOfBoundsException("invalid bucket size: " + buckets);
        }
        this.threshold = 6;
        this.table = new RubyHashEntry[buckets];
    }

    private final void alloc() {
        ++this.generation;
        this.head.prevAdded = (this.head.nextAdded = this.head);
        this.allocFirst();
    }

    private static int JavaSoftHashValue(int h) {
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    private static int JavaSoftBucketIndex(int h, int length2) {
        return h & length2 - 1;
    }

    private static int MRIHashValue(int h) {
        return h & Integer.MAX_VALUE;
    }

    private static int MRIBucketIndex(int h, int length2) {
        return (h & Integer.MAX_VALUE) % length2;
    }

    private final synchronized void resize(int newCapacity) {
        RubyHashEntry[] oldTable = this.table;
        RubyHashEntry[] newTable = new RubyHashEntry[newCapacity];
        for (int j = 0; j < oldTable.length; ++j) {
            RubyHashEntry entry = oldTable[j];
            oldTable[j] = null;
            while (entry != null) {
                RubyHashEntry next2 = entry.next;
                int i2 = RubyHash.bucketIndex(entry.hash, newCapacity);
                entry.next = newTable[i2];
                newTable[i2] = entry;
                entry = next2;
            }
        }
        this.table = newTable;
    }

    private final void JavaSoftCheckResize() {
        if (this.overThreshold()) {
            RubyHashEntry[] tbl = this.table;
            if (tbl.length == 0x40000000) {
                this.threshold = Integer.MAX_VALUE;
                return;
            }
            this.resizeAndAdjustThreshold(this.table);
        }
    }

    private boolean overThreshold() {
        return this.size > this.threshold;
    }

    private void resizeAndAdjustThreshold(RubyHashEntry[] oldTable) {
        int newCapacity = oldTable.length << 1;
        this.resize(newCapacity);
        this.threshold = newCapacity - (newCapacity >> 2);
    }

    private final void MRICheckResize() {
        if (this.size / this.table.length > 5) {
            int forSize = this.table.length + 1;
            int i2 = 0;
            int newCapacity = 8;
            while (i2 < MRI_PRIMES.length) {
                if (newCapacity > forSize) {
                    this.resize(MRI_PRIMES[i2]);
                    return;
                }
                ++i2;
                newCapacity <<= 1;
            }
            return;
        }
    }

    protected final int hashValue(IRubyObject key2) {
        int h = this.isComparedByIdentity() ? System.identityHashCode(key2) : key2.hashCode();
        return RubyHash.MRIHashValue(h);
    }

    private static int bucketIndex(int h, int length2) {
        return RubyHash.MRIBucketIndex(h, length2);
    }

    private void checkResize() {
        this.MRICheckResize();
    }

    protected final void checkIterating() {
        if (this.iteratorCount > 0) {
            throw this.getRuntime().newRuntimeError("can't add a new key into hash during iteration");
        }
    }

    private final void internalPut(IRubyObject key2, IRubyObject value2) {
        this.internalPut(key2, value2, true);
    }

    private final void internalPutSmall(IRubyObject key2, IRubyObject value2) {
        this.internalPutNoResize(key2, value2, true);
    }

    protected void internalPut(IRubyObject key2, IRubyObject value2, boolean checkForExisting) {
        this.checkResize();
        this.internalPutNoResize(key2, value2, checkForExisting);
    }

    protected final IRubyObject internalJavaPut(IRubyObject key2, IRubyObject value2) {
        this.checkResize();
        return this.internalPutNoResize(key2, value2, true);
    }

    protected IRubyObject internalPutNoResize(IRubyObject key2, IRubyObject value2, boolean checkForExisting) {
        int hash2 = this.hashValue(key2);
        int i2 = RubyHash.bucketIndex(hash2, this.table.length);
        if (checkForExisting) {
            RubyHashEntry entry = this.table[i2];
            while (entry != null) {
                if (this.internalKeyExist(entry, hash2, key2)) {
                    IRubyObject existing = entry.value;
                    entry.value = value2;
                    return existing;
                }
                entry = entry.next;
            }
        }
        this.checkIterating();
        this.table[i2] = new RubyHashEntry(hash2, key2, value2, this.table[i2], this.head);
        ++this.size;
        return null;
    }

    protected IRubyObject internalGet(IRubyObject key2) {
        return this.internalGetEntry((IRubyObject)key2).value;
    }

    protected RubyHashEntry internalGetEntry(IRubyObject key2) {
        if (this.size == 0) {
            return NO_ENTRY;
        }
        int hash2 = this.hashValue(key2);
        RubyHashEntry entry = this.table[RubyHash.bucketIndex(hash2, this.table.length)];
        while (entry != null) {
            if (this.internalKeyExist(entry, hash2, key2)) {
                return entry;
            }
            entry = entry.next;
        }
        return NO_ENTRY;
    }

    final RubyHashEntry getEntry(IRubyObject key2) {
        return this.internalGetEntry(key2);
    }

    private boolean internalKeyExist(RubyHashEntry entry, int hash2, IRubyObject key2) {
        return entry.hash == hash2 && (entry.key == key2 || !this.isComparedByIdentity() && key2.eql(entry.key));
    }

    protected RubyHashEntry internalDelete(IRubyObject key2) {
        if (this.size == 0) {
            return NO_ENTRY;
        }
        return this.internalDelete(this.hashValue(key2), MATCH_KEY, key2);
    }

    protected RubyHashEntry internalDeleteEntry(RubyHashEntry entry) {
        return this.internalDelete(this.hashValue(entry.key), MATCH_ENTRY, entry);
    }

    private final RubyHashEntry internalDelete(int hash2, EntryMatchType matchType, Object obj) {
        int i2 = RubyHash.bucketIndex(hash2, this.table.length);
        RubyHashEntry entry = this.table[i2];
        if (entry != null) {
            RubyHashEntry prior = null;
            while (entry != null) {
                if (entry.hash == hash2 && matchType.matches(entry, obj)) {
                    if (prior != null) {
                        prior.next = entry.next;
                    } else {
                        this.table[i2] = entry.next;
                    }
                    entry.detach();
                    --this.size;
                    return entry;
                }
                prior = entry;
                entry = entry.next;
            }
        }
        return NO_ENTRY;
    }

    private final RubyHashEntry[] internalCopyTable(RubyHashEntry destHead) {
        RubyHashEntry[] newTable = new RubyHashEntry[this.table.length];
        RubyHashEntry entry = this.head.nextAdded;
        while (entry != this.head) {
            int i2 = RubyHash.bucketIndex(entry.hash, this.table.length);
            newTable[i2] = new RubyHashEntry(entry.hash, entry.key, entry.value, newTable[i2], destHead);
            entry = entry.nextAdded;
        }
        return newTable;
    }

    public <T> void visitAll(ThreadContext context, VisitorWithState visitor, T state2) {
        this.visitLimited(context, visitor, -1L, state2);
    }

    private <T> void visitLimited(ThreadContext context, VisitorWithState visitor, long size2, T state2) {
        int startGeneration = this.generation;
        long count2 = size2;
        int index2 = 0;
        RubyHashEntry entry = this.head.nextAdded;
        while (entry != this.head && count2 != 0L) {
            if (startGeneration != this.generation) {
                startGeneration = this.generation;
                entry = this.head.nextAdded;
                if (entry == this.head) break;
            }
            if (entry != null && entry.isLive()) {
                visitor.visit(context, this, entry.key, entry.value, index2++, state2);
                --count2;
            }
            entry = entry.nextAdded;
        }
        if (count2 > 0L) {
            throw this.concurrentModification();
        }
    }

    public <T> boolean allSymbols() {
        int startGeneration = this.generation;
        RubyHashEntry head = this.head;
        RubyHashEntry entry = head.nextAdded;
        while (entry != head) {
            if (startGeneration != this.generation) {
                startGeneration = this.generation;
                entry = head.nextAdded;
                if (entry == head) break;
            }
            if (entry != null && entry.isLive() && !(entry.key instanceof RubySymbol)) {
                return false;
            }
            entry = entry.nextAdded;
        }
        return true;
    }

    @JRubyMethod(optional=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject[] args2, Block block) {
        this.modify();
        if (block.isGiven()) {
            if (args2.length > 0) {
                throw this.getRuntime().newArgumentError("wrong number of arguments");
            }
            this.ifNone = this.getRuntime().newProc(Block.Type.PROC, block);
            this.flags |= PROCDEFAULT_HASH_F;
        } else {
            Arity.checkArgumentCount(this.getRuntime(), args2, 0, 1);
            if (args2.length == 1) {
                this.ifNone = args2[0];
            }
            if (args2.length == 0) {
                this.ifNone = UNDEF;
            }
        }
        return this;
    }

    @JRubyMethod(name={"default"})
    public IRubyObject default_value_get(ThreadContext context) {
        if ((this.flags & PROCDEFAULT_HASH_F) != 0) {
            return context.nil;
        }
        return this.ifNone == UNDEF ? context.nil : this.ifNone;
    }

    @JRubyMethod(name={"default"})
    public IRubyObject default_value_get(ThreadContext context, IRubyObject arg2) {
        if ((this.flags & PROCDEFAULT_HASH_F) != 0) {
            return RubyHash.sites((ThreadContext)context).call.call(context, this.ifNone, this.ifNone, (IRubyObject)this, arg2);
        }
        return this.ifNone == UNDEF ? context.nil : this.ifNone;
    }

    @JRubyMethod(name={"default="}, required=1)
    public IRubyObject default_value_set(IRubyObject defaultValue) {
        this.modify();
        this.ifNone = defaultValue;
        this.flags &= ~PROCDEFAULT_HASH_F;
        return this.ifNone;
    }

    @JRubyMethod
    public IRubyObject default_proc() {
        return (this.flags & PROCDEFAULT_HASH_F) != 0 ? this.ifNone : this.getRuntime().getNil();
    }

    private void checkDefaultProcArity(IRubyObject proc2) {
        int n = ((RubyProc)proc2).getBlock().getSignature().arityValue();
        if (((RubyProc)proc2).getBlock().type == Block.Type.LAMBDA && n != 2 && (n >= 0 || n < -3)) {
            if (n < 0) {
                n = -n - 1;
            }
            throw this.getRuntime().newTypeError("default_proc takes two arguments (2 for " + n + ")");
        }
    }

    @JRubyMethod(name={"default_proc="})
    public IRubyObject set_default_proc(IRubyObject proc2) {
        this.modify();
        if (proc2.isNil()) {
            this.ifNone = proc2;
            this.flags &= ~PROCDEFAULT_HASH_F;
            return proc2;
        }
        IRubyObject b2 = TypeConverter.convertToType(proc2, this.getRuntime().getProc(), "to_proc");
        if (b2.isNil() || !(b2 instanceof RubyProc)) {
            throw this.getRuntime().newTypeError("wrong default_proc type " + proc2.getMetaClass() + " (expected Proc)");
        }
        proc2 = b2;
        this.checkDefaultProcArity(proc2);
        this.ifNone = proc2;
        this.flags |= PROCDEFAULT_HASH_F;
        return proc2;
    }

    @Deprecated
    public IRubyObject set_default_proc20(IRubyObject proc2) {
        return this.set_default_proc(proc2);
    }

    public void modify() {
        this.testFrozen("Hash");
    }

    private IRubyObject inspectHash(ThreadContext context) {
        RubyString str = RubyString.newStringLight(context.runtime, 20, (Encoding)USASCIIEncoding.INSTANCE);
        str.infectBy(this);
        str.cat((byte)123);
        this.visitAll(context, InspectVisitor, str);
        str.cat((byte)125);
        return str;
    }

    @Override
    public IRubyObject inspect() {
        return this.inspect(this.getRuntime().getCurrentContext());
    }

    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect(ThreadContext context) {
        if (this.size == 0) {
            return RubyString.newUSASCIIString(context.runtime, "{}");
        }
        if (context.runtime.isInspecting(this)) {
            return RubyString.newUSASCIIString(context.runtime, "{...}");
        }
        try {
            context.runtime.registerInspecting(this);
            IRubyObject iRubyObject = this.inspectHash(context);
            return iRubyObject;
        }
        finally {
            context.runtime.unregisterInspecting(this);
        }
    }

    @Deprecated
    public IRubyObject inspect19(ThreadContext context) {
        return this.inspect(context);
    }

    @JRubyMethod(name={"size", "length"})
    public RubyFixnum rb_size() {
        return this.getRuntime().newFixnum(this.size);
    }

    private RubyEnumerator.SizeFn enumSizeFn() {
        final RubyHash self2 = this;
        return new RubyEnumerator.SizeFn(){

            @Override
            public IRubyObject size(IRubyObject[] args2) {
                return self2.rb_size();
            }
        };
    }

    @JRubyMethod(name={"empty?"})
    public RubyBoolean empty_p() {
        return this.size == 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @Override
    @JRubyMethod(name={"to_a"})
    public RubyArray to_a() {
        Ruby runtime2 = this.getRuntime();
        try {
            RubyArray result2 = RubyArray.newBlankArray(runtime2, this.size);
            this.visitAll(runtime2.getCurrentContext(), StoreKeyValueVisitor, result2);
            result2.setTaint(this.isTaint());
            return result2;
        }
        catch (NegativeArraySizeException nase) {
            throw this.concurrentModification();
        }
    }

    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s(ThreadContext context) {
        return this.inspect(context);
    }

    public final IRubyObject to_s19(ThreadContext context) {
        return this.to_s(context);
    }

    @JRubyMethod(name={"rehash"})
    public RubyHash rehash() {
        if (this.iteratorCount > 0) {
            throw this.getRuntime().newRuntimeError("rehash during iteration");
        }
        this.modify();
        RubyHashEntry[] oldTable = this.table;
        RubyHashEntry[] newTable = new RubyHashEntry[oldTable.length];
        for (int j = 0; j < oldTable.length; ++j) {
            RubyHashEntry entry = oldTable[j];
            oldTable[j] = null;
            while (entry != null) {
                RubyHashEntry next2 = entry.next;
                entry.hash = this.hashValue(entry.key);
                int i2 = RubyHash.bucketIndex(entry.hash, newTable.length);
                if (newTable[i2] != null && this.internalKeyExist(newTable[i2], entry.hash, entry.key)) {
                    RubyHashEntry tmpNext = entry.nextAdded;
                    RubyHashEntry tmpPrev = entry.prevAdded;
                    tmpPrev.nextAdded = tmpNext;
                    tmpPrev.prevAdded = tmpPrev;
                    --this.size;
                } else {
                    entry.next = newTable[i2];
                    newTable[i2] = entry;
                }
                entry = next2;
            }
        }
        this.table = newTable;
        return this;
    }

    @JRubyMethod(name={"to_hash"})
    public RubyHash to_hash() {
        return this;
    }

    @JRubyMethod
    public RubyHash to_h(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        return this.getType() == runtime2.getHash() ? this : RubyHash.newHash(runtime2).replace(context, this);
    }

    @Override
    public RubyHash convertToHash() {
        return this;
    }

    public final void fastASet(IRubyObject key2, IRubyObject value2) {
        this.internalPut(key2, value2);
    }

    public final void fastASetSmall(IRubyObject key2, IRubyObject value2) {
        this.internalPutSmall(key2, value2);
    }

    public final void fastASetCheckString(Ruby runtime2, IRubyObject key2, IRubyObject value2) {
        if (key2 instanceof RubyString && !this.isComparedByIdentity()) {
            this.op_asetForString(runtime2, (RubyString)key2, value2);
        } else {
            this.internalPut(key2, value2);
        }
    }

    public final void fastASetSmallCheckString(Ruby runtime2, IRubyObject key2, IRubyObject value2) {
        if (key2 instanceof RubyString) {
            this.op_asetSmallForString(runtime2, (RubyString)key2, value2);
        } else {
            this.internalPutSmall(key2, value2);
        }
    }

    public final void fastASet(Ruby runtime2, IRubyObject key2, IRubyObject value2, boolean prepareString) {
        if (prepareString) {
            this.fastASetCheckString(runtime2, key2, value2);
        } else {
            this.fastASet(key2, value2);
        }
    }

    public final void fastASetSmall(Ruby runtime2, IRubyObject key2, IRubyObject value2, boolean prepareString) {
        if (prepareString) {
            this.fastASetSmallCheckString(runtime2, key2, value2);
        } else {
            this.fastASetSmall(key2, value2);
        }
    }

    @JRubyMethod(name={"[]=", "store"})
    public IRubyObject op_aset(ThreadContext context, IRubyObject key2, IRubyObject value2) {
        this.modify();
        this.fastASetCheckString(context.runtime, key2, value2);
        return value2;
    }

    protected void op_asetForString(Ruby runtime2, RubyString key2, IRubyObject value2) {
        RubyHashEntry entry = this.internalGetEntry(key2);
        if (entry != NO_ENTRY) {
            entry.value = value2;
        } else {
            this.checkIterating();
            if (!key2.isFrozen()) {
                key2 = (RubyString)key2.dupFrozen();
            }
            this.internalPut(key2, value2, false);
        }
    }

    protected void op_asetSmallForString(Ruby runtime2, RubyString key2, IRubyObject value2) {
        RubyHashEntry entry = this.internalGetEntry(key2);
        if (entry != NO_ENTRY) {
            entry.value = value2;
        } else {
            this.checkIterating();
            if (!key2.isFrozen()) {
                key2 = (RubyString)key2.dupFrozen();
            }
            this.internalPutNoResize(key2, value2, false);
        }
    }

    public final IRubyObject fastARef(IRubyObject key2) {
        return this.internalGet(key2);
    }

    public RubyBoolean compare(ThreadContext context, VisitorWithState<RubyHash> visitor, IRubyObject other) {
        Ruby runtime2 = context.runtime;
        if (!(other instanceof RubyHash)) {
            if (!RubyHash.sites((ThreadContext)context).respond_to_to_hash.respondsTo(context, other, other)) {
                return runtime2.getFalse();
            }
            return Helpers.rbEqual(context, other, this);
        }
        RubyHash otherHash = (RubyHash)other;
        if (this.size != otherHash.size) {
            return runtime2.getFalse();
        }
        try {
            this.visitAll(context, visitor, otherHash);
        }
        catch (Mismatch e) {
            return runtime2.getFalse();
        }
        return runtime2.getTrue();
    }

    @Override
    @JRubyMethod(name={"=="})
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        return RecursiveComparator.compare(context, FindMismatchUsingEqualVisitor, this, other);
    }

    @JRubyMethod(name={"eql?"})
    public IRubyObject op_eql(ThreadContext context, IRubyObject other) {
        return RecursiveComparator.compare(context, FindMismatchUsingEqlVisitor, this, other);
    }

    @Deprecated
    public IRubyObject op_eql19(ThreadContext context, IRubyObject other) {
        return this.op_eql(context, other);
    }

    @JRubyMethod(name={"[]"}, required=1)
    public IRubyObject op_aref(ThreadContext context, IRubyObject key2) {
        IRubyObject value2 = this.internalGet(key2);
        return value2 == null ? RubyHash.sites((ThreadContext)context).default_.call(context, (IRubyObject)this, (IRubyObject)this, key2) : value2;
    }

    private boolean hash_le(RubyHash other) {
        return other.directEntrySet().containsAll(this.directEntrySet());
    }

    @JRubyMethod(name={"<"}, required=1)
    public IRubyObject op_lt(ThreadContext context, IRubyObject other) {
        RubyHash otherHash = ((RubyBasicObject)other).convertToHash();
        if (this.size() >= otherHash.size()) {
            return context.fals;
        }
        return RubyBoolean.newBoolean(context.runtime, this.hash_le(otherHash));
    }

    @JRubyMethod(name={"<="}, required=1)
    public IRubyObject op_le(ThreadContext context, IRubyObject other) {
        RubyHash otherHash = other.convertToHash();
        if (this.size() > otherHash.size()) {
            return context.fals;
        }
        return RubyBoolean.newBoolean(context.runtime, this.hash_le(otherHash));
    }

    @JRubyMethod(name={">"}, required=1)
    public IRubyObject op_gt(ThreadContext context, IRubyObject other) {
        RubyHash otherHash = other.convertToHash();
        return otherHash.op_lt(context, this);
    }

    @JRubyMethod(name={">="}, required=1)
    public IRubyObject op_ge(ThreadContext context, IRubyObject other) {
        RubyHash otherHash = other.convertToHash();
        return otherHash.op_le(context, this);
    }

    @Override
    public RubyFixnum hash() {
        return this.hash(this.getRuntime().getCurrentContext());
    }

    @JRubyMethod(name={"hash"})
    public RubyFixnum hash(ThreadContext context) {
        int size2 = this.size();
        long[] hval = new long[]{Helpers.hashStart(context.runtime, size2)};
        if (size2 > 0) {
            this.iteratorVisitAll(context, CalculateHashVisitor, hval);
        }
        return context.runtime.newFixnum(hval[0]);
    }

    @Deprecated
    public final RubyFixnum hash19() {
        return this.hash(this.getRuntime().getCurrentContext());
    }

    public IRubyObject fetch(ThreadContext context, IRubyObject[] args2, Block block) {
        Arity.checkArgumentCount(context.runtime, args2.length, 1, 2);
        switch (args2.length) {
            case 1: {
                return this.fetch(context, args2[0], block);
            }
            case 2: {
                return this.fetch(context, args2[0], args2[1], block);
            }
        }
        return null;
    }

    @JRubyMethod
    public IRubyObject fetch(ThreadContext context, IRubyObject key2, Block block) {
        Ruby runtime2 = context.runtime;
        IRubyObject value2 = this.internalGet(key2);
        if (value2 == null) {
            if (block.isGiven()) {
                return block.yield(context, key2);
            }
            throw runtime2.newKeyError("key not found: " + key2.inspect(), this, key2);
        }
        return value2;
    }

    @JRubyMethod
    public IRubyObject fetch(ThreadContext context, IRubyObject key2, IRubyObject _default, Block block) {
        IRubyObject value2;
        Ruby runtime2 = context.runtime;
        boolean blockGiven = block.isGiven();
        if (blockGiven) {
            runtime2.getWarnings().warn(IRubyWarnings.ID.BLOCK_BEATS_DEFAULT_VALUE, "block supersedes default value argument");
        }
        if ((value2 = this.internalGet(key2)) == null) {
            if (blockGiven) {
                return block.yield(context, key2);
            }
            return _default;
        }
        return value2;
    }

    @JRubyMethod(name={"has_key?", "key?", "include?", "member?"}, required=1)
    public RubyBoolean has_key_p(ThreadContext context, IRubyObject key2) {
        Ruby runtime2 = context.runtime;
        return this.internalGetEntry(key2) == NO_ENTRY ? runtime2.getFalse() : runtime2.getTrue();
    }

    public RubyBoolean has_key_p(IRubyObject key2) {
        return this.internalGetEntry(key2) == NO_ENTRY ? this.getRuntime().getFalse() : this.getRuntime().getTrue();
    }

    private boolean hasValue(ThreadContext context, IRubyObject expected) {
        try {
            this.visitAll(context, FoundIfEqualVisitor, expected);
            return false;
        }
        catch (Found found) {
            return true;
        }
    }

    @JRubyMethod(name={"has_value?", "value?"}, required=1)
    public RubyBoolean has_value_p(ThreadContext context, IRubyObject expected) {
        return context.runtime.newBoolean(this.hasValue(context, expected));
    }

    private void iteratorEntry() {
        if (ITERATOR_UPDATER == null) {
            this.iteratorEntrySync();
            return;
        }
        ITERATOR_UPDATER.incrementAndGet(this);
    }

    private void iteratorExit() {
        if (ITERATOR_UPDATER == null) {
            this.iteratorExitSync();
            return;
        }
        ITERATOR_UPDATER.decrementAndGet(this);
    }

    private synchronized void iteratorEntrySync() {
        ++this.iteratorCount;
    }

    private void iteratorExitSync() {
        --this.iteratorCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void iteratorVisitAll(ThreadContext context, VisitorWithState<T> visitor, T state2) {
        try {
            this.iteratorEntry();
            this.visitAll(context, visitor, state2);
        }
        finally {
            this.iteratorExit();
        }
    }

    public RubyHash eachCommon(ThreadContext context, Block block) {
        this.iteratorVisitAll(context, YieldArrayVisitor, block);
        return this;
    }

    @JRubyMethod(name={"each", "each_pair"})
    public IRubyObject each(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_pairCommon(context, block) : RubyEnumerator.enumeratorizeWithSize(context, this, "each", this.enumSizeFn());
    }

    public IRubyObject each19(ThreadContext context, Block block) {
        return this.each(context, block);
    }

    public RubyHash each_pairCommon(ThreadContext context, Block block) {
        this.iteratorVisitAll(context, YieldKeyValueArrayVisitor, block);
        return this;
    }

    public RubyHash each_valueCommon(ThreadContext context, Block block) {
        this.iteratorVisitAll(context, YieldValueVisitor, block);
        return this;
    }

    @JRubyMethod
    public IRubyObject each_value(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_valueCommon(context, block) : RubyEnumerator.enumeratorizeWithSize(context, this, "each_value", this.enumSizeFn());
    }

    public RubyHash each_keyCommon(ThreadContext context, Block block) {
        this.iteratorVisitAll(context, YieldKeyVisitor, block);
        return this;
    }

    @JRubyMethod
    public IRubyObject each_key(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_keyCommon(context, block) : RubyEnumerator.enumeratorizeWithSize(context, this, "each_key", this.enumSizeFn());
    }

    @JRubyMethod(name={"transform_keys"})
    public IRubyObject transform_keys(ThreadContext context, Block block) {
        if (block.isGiven()) {
            RubyHash result2 = RubyHash.newHash(context.runtime);
            this.visitAll(context, new TransformKeysVisitor(block), result2);
            return result2;
        }
        return RubyEnumerator.enumeratorizeWithSize(context, this, "transform_keys", this.enumSizeFn());
    }

    @JRubyMethod(name={"transform_values"})
    public IRubyObject transform_values(ThreadContext context, Block block) {
        return new RubyHash(context.runtime, context.runtime.getHash(), this).transform_values_bang(context, block);
    }

    @JRubyMethod(name={"transform_keys!"})
    public IRubyObject transform_keys_bang(ThreadContext context, Block block) {
        if (block.isGiven()) {
            this.testFrozen("Hash");
            RubyArray keys2 = this.keys(context);
            Arrays.stream(keys2.toJavaArrayMaybeUnsafe()).forEach((? super T key2) -> this.op_aset(context, block.yield(context, (IRubyObject)key2), this.delete(context, (IRubyObject)key2)));
            return this;
        }
        return RubyEnumerator.enumeratorizeWithSize(context, this, "transform_keys!", this.enumSizeFn());
    }

    @JRubyMethod(name={"transform_values!"})
    public IRubyObject transform_values_bang(ThreadContext context, Block block) {
        if (block.isGiven()) {
            this.testFrozen("Hash");
            TransformValuesVisitor tvf = new TransformValuesVisitor();
            this.iteratorVisitAll(context, tvf, block);
            return this;
        }
        return RubyEnumerator.enumeratorizeWithSize(context, this, "transform_values!", this.enumSizeFn());
    }

    @JRubyMethod(name={"select!"})
    public IRubyObject select_bang(ThreadContext context, Block block) {
        if (block.isGiven()) {
            return this.keep_ifCommon(context, block) ? this : context.nil;
        }
        return RubyEnumerator.enumeratorizeWithSize(context, this, "select!", this.enumSizeFn());
    }

    @JRubyMethod
    public IRubyObject keep_if(ThreadContext context, Block block) {
        if (block.isGiven()) {
            this.keep_ifCommon(context, block);
            return this;
        }
        return RubyEnumerator.enumeratorizeWithSize(context, this, "keep_if", this.enumSizeFn());
    }

    public boolean keep_ifCommon(ThreadContext context, Block block) {
        this.testFrozen("Hash");
        KeepIfVisitor kif = new KeepIfVisitor();
        this.iteratorVisitAll(context, kif, block);
        return kif.modified;
    }

    @Deprecated
    public IRubyObject sort(ThreadContext context, Block block) {
        return this.to_a().sort_bang(context, block);
    }

    @JRubyMethod(name={"index"})
    public IRubyObject index(ThreadContext context, IRubyObject expected) {
        context.runtime.getWarnings().warn(IRubyWarnings.ID.DEPRECATED_METHOD, "Hash#index is deprecated; use Hash#key");
        return this.key(context, expected);
    }

    @Deprecated
    public IRubyObject index19(ThreadContext context, IRubyObject expected) {
        return this.index(context, expected);
    }

    @JRubyMethod
    public IRubyObject key(ThreadContext context, IRubyObject expected) {
        IRubyObject key2 = this.internalIndex(context, expected);
        return key2 != null ? key2 : context.nil;
    }

    private IRubyObject internalIndex(ThreadContext context, IRubyObject expected) {
        try {
            this.visitAll(context, FoundKeyIfEqual, expected);
            return null;
        }
        catch (FoundKey found) {
            return found.key;
        }
    }

    @JRubyMethod(name={"keys"})
    public RubyArray keys(ThreadContext context) {
        try {
            RubyArray keys2 = RubyArray.newBlankArray(context.runtime, this.size);
            this.visitAll(context, StoreKeyVisitor, keys2);
            return keys2;
        }
        catch (NegativeArraySizeException nase) {
            throw this.concurrentModification();
        }
    }

    public final RubyArray keys() {
        return this.keys(this.getRuntime().getCurrentContext());
    }

    @JRubyMethod(name={"values"})
    public RubyArray values(ThreadContext context) {
        try {
            RubyArray values2 = RubyArray.newBlankArray(context.runtime, this.size);
            this.visitAll(context, StoreValueVisitor, values2);
            return values2;
        }
        catch (NegativeArraySizeException nase) {
            throw this.concurrentModification();
        }
    }

    public final RubyArray rb_values() {
        return this.values(this.getRuntime().getCurrentContext());
    }

    @JRubyMethod(name={"shift"})
    public IRubyObject shift(ThreadContext context) {
        this.modify();
        RubyHashEntry entry = this.head.nextAdded;
        if (entry != this.head) {
            RubyArray result2 = RubyArray.newArray(context.runtime, entry.key, entry.value);
            this.internalDeleteEntry(entry);
            return result2;
        }
        if (this.isBuiltin("default")) {
            return this.default_value_get(context, context.nil);
        }
        return RubyHash.sites((ThreadContext)context).default_.call(context, (IRubyObject)this, (IRubyObject)this, context.nil);
    }

    public final boolean fastDelete(IRubyObject key2) {
        return this.internalDelete(key2) != NO_ENTRY;
    }

    @JRubyMethod
    public IRubyObject delete(ThreadContext context, IRubyObject key2, Block block) {
        this.modify();
        RubyHashEntry entry = this.internalDelete(key2);
        if (entry != NO_ENTRY) {
            return entry.value;
        }
        if (block.isGiven()) {
            return block.yield(context, key2);
        }
        return context.nil;
    }

    public IRubyObject delete(ThreadContext context, IRubyObject key2) {
        return this.delete(context, key2, Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"select"})
    public IRubyObject select(ThreadContext context, Block block) {
        Ruby runtime2 = context.runtime;
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, this, "select", this.enumSizeFn());
        }
        RubyHash result2 = RubyHash.newHash(runtime2);
        this.iteratorVisitAll(context, new SelectVisitor(result2), block);
        return result2;
    }

    @JRubyMethod(name={"slice"}, rest=true)
    public RubyHash slice(ThreadContext context, IRubyObject[] args2) {
        RubyHash result2 = RubyHash.newHash(context.runtime);
        for (int i2 = 0; i2 < args2.length; ++i2) {
            IRubyObject key2 = args2[i2];
            IRubyObject value2 = this.internalGet(key2);
            if (value2 == null) continue;
            result2.op_aset(key2, value2);
        }
        return result2;
    }

    @Deprecated
    public IRubyObject select19(ThreadContext context, Block block) {
        return this.select(context, block);
    }

    public RubyHash delete_ifInternal(ThreadContext context, Block block) {
        this.modify();
        this.iteratorVisitAll(context, DeleteIfVisitor, block);
        return this;
    }

    @JRubyMethod
    public IRubyObject delete_if(ThreadContext context, Block block) {
        return block.isGiven() ? this.delete_ifInternal(context, block) : RubyEnumerator.enumeratorizeWithSize(context, this, "delete_if", this.enumSizeFn());
    }

    public RubyHash rejectInternal(ThreadContext context, Block block) {
        RubyHash result2 = RubyHash.newHash(context.runtime);
        this.iteratorVisitAll(context, new RejectVisitor(result2), block);
        return result2;
    }

    @JRubyMethod
    public IRubyObject reject(ThreadContext context, Block block) {
        return block.isGiven() ? this.rejectInternal(context, block) : RubyEnumerator.enumeratorizeWithSize(context, this, "reject", this.enumSizeFn());
    }

    public IRubyObject reject_bangInternal(ThreadContext context, Block block) {
        int n = this.size;
        this.delete_if(context, block);
        if (n == this.size) {
            return this.getRuntime().getNil();
        }
        return this;
    }

    @JRubyMethod(name={"reject!"})
    public IRubyObject reject_bang(ThreadContext context, Block block) {
        return block.isGiven() ? this.reject_bangInternal(context, block) : RubyEnumerator.enumeratorizeWithSize(context, this, "reject!", this.enumSizeFn());
    }

    @JRubyMethod(name={"clear"})
    public RubyHash rb_clear() {
        this.modify();
        if (this.size > 0) {
            this.alloc();
            this.size = 0;
        }
        return this;
    }

    @JRubyMethod(name={"invert"})
    public RubyHash invert(ThreadContext context) {
        RubyHash result2 = RubyHash.newHash(this.getRuntime());
        this.visitAll(context, InvertVisitor, result2);
        return result2;
    }

    @JRubyMethod(name={"merge!", "update"}, required=1)
    public RubyHash merge_bang(ThreadContext context, IRubyObject other, Block block) {
        this.modify();
        RubyHash otherHash = other.convertToHash();
        if (otherHash.empty_p().isTrue()) {
            return this;
        }
        otherHash.visitAll(context, new MergeVisitor(this), block);
        return this;
    }

    @Deprecated
    public RubyHash merge_bang19(ThreadContext context, IRubyObject other, Block block) {
        return this.merge_bang(context, other, block);
    }

    @JRubyMethod
    public RubyHash merge(ThreadContext context, IRubyObject other, Block block) {
        return ((RubyHash)this.dup()).merge_bang(context, other, block);
    }

    @JRubyMethod(name={"initialize_copy"}, required=1, visibility=Visibility.PRIVATE)
    public RubyHash initialize_copy(ThreadContext context, IRubyObject other) {
        return this.replace(context, other);
    }

    @Deprecated
    public RubyHash initialize_copy19(ThreadContext context, IRubyObject other) {
        return this.initialize_copy(context, other);
    }

    @JRubyMethod(name={"replace"}, required=1)
    public RubyHash replace(ThreadContext context, IRubyObject other) {
        this.modify();
        RubyHash otherHash = other.convertToHash();
        if (this == otherHash) {
            return this;
        }
        this.rb_clear();
        if (!this.isComparedByIdentity() && otherHash.isComparedByIdentity()) {
            this.setComparedByIdentity(true);
        }
        otherHash.visitAll(context, ReplaceVisitor, this);
        this.ifNone = otherHash.ifNone;
        this.flags = (otherHash.flags & PROCDEFAULT_HASH_F) != 0 ? (this.flags |= PROCDEFAULT_HASH_F) : (this.flags &= ~PROCDEFAULT_HASH_F);
        return this;
    }

    @JRubyMethod(name={"values_at"}, rest=true)
    public RubyArray values_at(ThreadContext context, IRubyObject[] args2) {
        RubyArray result2 = RubyArray.newBlankArrayInternal(context.runtime, args2.length);
        for (int i2 = 0; i2 < args2.length; ++i2) {
            result2.store(i2, this.op_aref(context, args2[i2]));
        }
        return result2;
    }

    @JRubyMethod(name={"fetch_values"}, rest=true)
    public RubyArray fetch_values(ThreadContext context, IRubyObject[] args2, Block block) {
        RubyArray result2 = RubyArray.newBlankArrayInternal(context.runtime, args2.length);
        for (int i2 = 0; i2 < args2.length; ++i2) {
            result2.store(i2, this.fetch(context, args2[i2], block));
        }
        return result2;
    }

    @JRubyMethod(name={"assoc"})
    public IRubyObject assoc(ThreadContext context, IRubyObject obj) {
        try {
            this.visitAll(context, FoundPairIfEqualKeyVisitor, obj);
            return context.nil;
        }
        catch (FoundPair found) {
            return context.runtime.newArray(found.key, found.value);
        }
    }

    @JRubyMethod(name={"rassoc"})
    public IRubyObject rassoc(ThreadContext context, IRubyObject obj) {
        try {
            this.visitAll(context, FoundPairIfEqualValueVisitor, obj);
            return context.nil;
        }
        catch (FoundPair found) {
            return context.runtime.newArray(found.key, found.value);
        }
    }

    @JRubyMethod
    public IRubyObject flatten(ThreadContext context) {
        RubyArray ary = this.to_a();
        RubyHash.sites((ThreadContext)context).flatten_bang.call(context, (IRubyObject)ary, (IRubyObject)ary, (IRubyObject)RubyFixnum.one(context.runtime));
        return ary;
    }

    @JRubyMethod
    public IRubyObject flatten(ThreadContext context, IRubyObject level2) {
        RubyArray ary = this.to_a();
        RubyHash.sites((ThreadContext)context).flatten_bang.call(context, (IRubyObject)ary, (IRubyObject)ary, level2);
        return ary;
    }

    @JRubyMethod(name={"compact"})
    public IRubyObject compact(ThreadContext context) {
        IRubyObject res = this.dup();
        ((RubyHash)res).compact_bang(context);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"compact!"})
    public IRubyObject compact_bang(ThreadContext context) {
        boolean changed = false;
        this.modify();
        this.iteratorEntry();
        try {
            RubyHashEntry entry = this.head.nextAdded;
            while (entry != this.head) {
                if (entry.value == context.nil) {
                    this.internalDelete(entry.key);
                    changed = true;
                }
                entry = entry.nextAdded;
            }
        }
        finally {
            this.iteratorExit();
        }
        return changed ? this : context.nil;
    }

    @JRubyMethod(name={"compare_by_identity"})
    public IRubyObject compare_by_identity(ThreadContext context) {
        this.modify();
        this.setComparedByIdentity(true);
        return this.rehash();
    }

    @JRubyMethod(name={"compare_by_identity?"})
    public IRubyObject compare_by_identity_p(ThreadContext context) {
        return context.runtime.newBoolean(this.isComparedByIdentity());
    }

    @JRubyMethod
    public IRubyObject dup(ThreadContext context) {
        RubyHash dup2 = (RubyHash)super.dup();
        dup2.setComparedByIdentity(this.isComparedByIdentity());
        return dup2;
    }

    @JRubyMethod(name={"clone"})
    public IRubyObject rbClone(ThreadContext context) {
        RubyHash clone2 = (RubyHash)super.rbClone();
        clone2.setComparedByIdentity(this.isComparedByIdentity());
        return clone2;
    }

    @JRubyMethod(name={"any?"}, optional=1)
    public IRubyObject any_p(ThreadContext context, IRubyObject[] args2, Block block) {
        boolean patternGiven;
        IRubyObject pattern = args2.length > 0 ? args2[0] : null;
        boolean bl = patternGiven = pattern != null;
        if (this.isEmpty()) {
            return context.fals;
        }
        if (!block.isGiven() && !patternGiven) {
            return context.tru;
        }
        if (patternGiven) {
            return this.any_p_p(context, pattern);
        }
        if (block.getSignature().arityValue() > 1) {
            return this.any_p_i_fast(context, block);
        }
        return this.any_p_i(context, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject any_p_i(ThreadContext context, Block block) {
        this.iteratorEntry();
        try {
            RubyHashEntry entry = this.head.nextAdded;
            while (entry != this.head) {
                RubyArray newAssoc = RubyArray.newArray(context.runtime, entry.key, entry.value);
                if (block.yield(context, newAssoc).isTrue()) {
                    RubyBoolean rubyBoolean = context.tru;
                    return rubyBoolean;
                }
                entry = entry.nextAdded;
            }
            RubyBoolean rubyBoolean = context.fals;
            return rubyBoolean;
        }
        finally {
            this.iteratorExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject any_p_i_fast(ThreadContext context, Block block) {
        this.iteratorEntry();
        try {
            RubyHashEntry entry = this.head.nextAdded;
            while (entry != this.head) {
                if (block.yieldArray(context, context.runtime.newArray(entry.key, entry.value), null).isTrue()) {
                    RubyBoolean rubyBoolean = context.tru;
                    return rubyBoolean;
                }
                entry = entry.nextAdded;
            }
            RubyBoolean rubyBoolean = context.fals;
            return rubyBoolean;
        }
        finally {
            this.iteratorExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject any_p_p(ThreadContext context, IRubyObject pattern) {
        this.iteratorEntry();
        try {
            RubyHashEntry entry = this.head.nextAdded;
            while (entry != this.head) {
                RubyArray newAssoc = RubyArray.newArray(context.runtime, entry.key, entry.value);
                if (pattern.callMethod(context, "===", newAssoc).isTrue()) {
                    RubyBoolean rubyBoolean = context.tru;
                    return rubyBoolean;
                }
                entry = entry.nextAdded;
            }
            RubyBoolean rubyBoolean = context.fals;
            return rubyBoolean;
        }
        finally {
            this.iteratorExit();
        }
    }

    public RubyHash dupFast(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        RubyHash dup2 = new RubyHash(runtime2, this.getMetaClass(), this);
        dup2.setComparedByIdentity(this.isComparedByIdentity());
        dup2.ifNone = this.ifNone;
        dup2.flags = (this.flags & PROCDEFAULT_HASH_F) != 0 ? (dup2.flags |= PROCDEFAULT_HASH_F) : (dup2.flags &= ~PROCDEFAULT_HASH_F);
        return dup2;
    }

    public boolean hasDefaultProc() {
        return (this.flags & PROCDEFAULT_HASH_F) != 0;
    }

    public IRubyObject getIfNone() {
        return this.ifNone;
    }

    @JRubyMethod(name={"dig"}, required=1, rest=true)
    public IRubyObject dig(ThreadContext context, IRubyObject[] args2) {
        return this.dig(context, args2, 0);
    }

    final IRubyObject dig(ThreadContext context, IRubyObject[] args2, int idx) {
        IRubyObject val = this.op_aref(context, args2[idx++]);
        return idx == args2.length ? val : RubyObject.dig(context, val, args2, idx);
    }

    @JRubyMethod
    public IRubyObject to_proc(ThreadContext context) {
        Block block = CallBlock19.newCallClosure((IRubyObject)this, (RubyModule)this.metaClass, Signature.ONE_ARGUMENT, (context1, args2, procBlock) -> {
            Arity.checkArgumentCount(context1, args2, 1, 1);
            return this.op_aref(context1, args2[0]);
        }, context);
        return RubyProc.newProc(context.runtime, block, Block.Type.PROC);
    }

    public static void marshalTo(RubyHash hash2, MarshalStream output) throws IOException {
        output.registerLinkTarget(hash2);
        int hashSize = hash2.size;
        output.writeInt(hashSize);
        try {
            hash2.visitLimited(hash2.getRuntime().getCurrentContext(), MarshalDumpVisitor, hashSize, output);
        }
        catch (VisitorIOException e) {
            throw (IOException)e.getCause();
        }
        if (hash2.ifNone != UNDEF) {
            output.dumpObject(hash2.ifNone);
        }
    }

    public static RubyHash unmarshalFrom(UnmarshalStream input, boolean defaultValue) throws IOException {
        RubyHash result2 = RubyHash.newHash(input.getRuntime());
        input.registerLinkTarget(result2);
        int size2 = input.unmarshalInt();
        for (int i2 = 0; i2 < size2; ++i2) {
            result2.fastASetCheckString(input.getRuntime(), input.unmarshalObject(), input.unmarshalObject());
        }
        if (defaultValue) {
            result2.default_value_set(input.unmarshalObject());
        }
        return result2;
    }

    @Override
    public Class getJavaClass() {
        return Map.class;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean containsKey(Object key2) {
        return this.internalGet(JavaUtil.convertJavaToUsableRubyObject(this.getRuntime(), key2)) != null;
    }

    @Override
    public boolean containsValue(Object value2) {
        return this.hasValue(this.getRuntime().getCurrentContext(), JavaUtil.convertJavaToUsableRubyObject(this.getRuntime(), value2));
    }

    public Object get(Object key2) {
        IRubyObject gotten = this.internalGet(JavaUtil.convertJavaToUsableRubyObject(this.getRuntime(), key2));
        return gotten == null ? null : gotten.toJava(Object.class);
    }

    public Object put(Object key2, Object value2) {
        Ruby runtime2 = this.getRuntime();
        IRubyObject existing = this.internalJavaPut(JavaUtil.convertJavaToUsableRubyObject(runtime2, key2), JavaUtil.convertJavaToUsableRubyObject(runtime2, value2));
        return existing == null ? null : existing.toJava(Object.class);
    }

    public Object remove(Object key2) {
        IRubyObject rubyKey = JavaUtil.convertJavaToUsableRubyObject(this.getRuntime(), key2);
        return this.internalDelete((IRubyObject)rubyKey).value;
    }

    public void putAll(Map map2) {
        Ruby runtime2 = this.getRuntime();
        for (Map.Entry entry : map2.entrySet()) {
            this.internalPut(JavaUtil.convertJavaToUsableRubyObject(runtime2, entry.getKey()), JavaUtil.convertJavaToUsableRubyObject(runtime2, entry.getValue()));
        }
    }

    @Override
    public void clear() {
        this.rb_clear();
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof RubyHash)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        return this.op_equal(this.getRuntime().getCurrentContext(), (RubyHash)other).isTrue();
    }

    public Set keySet() {
        return new BaseSet(KEY_VIEW);
    }

    public Set directKeySet() {
        return new BaseSet(DIRECT_KEY_VIEW);
    }

    public Collection values() {
        return new BaseCollection(VALUE_VIEW);
    }

    public Collection directValues() {
        return new BaseCollection(DIRECT_VALUE_VIEW);
    }

    public Set entrySet() {
        return new BaseSet(ENTRY_VIEW);
    }

    public Set directEntrySet() {
        return new BaseSet(DIRECT_ENTRY_VIEW);
    }

    private final RaiseException concurrentModification() {
        return this.getRuntime().newConcurrencyError("Detected invalid hash contents due to unsynchronized modifications with concurrent users");
    }

    protected boolean isComparedByIdentity() {
        return (this.flags & COMPARE_BY_IDENTITY_F) != 0;
    }

    public void setComparedByIdentity(boolean comparedByIdentity) {
        this.flags = comparedByIdentity ? (this.flags |= COMPARE_BY_IDENTITY_F) : (this.flags &= ~COMPARE_BY_IDENTITY_F);
    }

    @Deprecated
    public IRubyObject op_aset19(ThreadContext context, IRubyObject key2, IRubyObject value2) {
        this.modify();
        this.fastASetCheckString19(context.runtime, key2, value2);
        return value2;
    }

    public IRubyObject aset(IRubyObject key2, IRubyObject value2) {
        return this.op_aset(this.getRuntime().getCurrentContext(), key2, value2);
    }

    public IRubyObject aref(IRubyObject key2) {
        return this.op_aref(this.getRuntime().getCurrentContext(), key2);
    }

    private static JavaSites.HashSites sites(ThreadContext context) {
        return context.sites.Hash;
    }

    @Deprecated
    public final void fastASetCheckString19(Ruby runtime2, IRubyObject key2, IRubyObject value2) {
        this.fastASetCheckString(runtime2, key2, value2);
    }

    @Deprecated
    public final void fastASetSmallCheckString19(Ruby runtime2, IRubyObject key2, IRubyObject value2) {
        this.fastASetSmallCheckString(runtime2, key2, value2);
    }

    @Deprecated
    public IRubyObject op_aset(IRubyObject key2, IRubyObject value2) {
        return this.op_aset(this.getRuntime().getCurrentContext(), key2, value2);
    }

    @Deprecated
    public IRubyObject each_pair(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_pairCommon(context, block) : RubyEnumerator.enumeratorizeWithSize(context, this, "each_pair", this.enumSizeFn());
    }

    @Deprecated
    public RubyHash each_pairCommon(ThreadContext context, Block block, boolean oneNine) {
        this.iteratorVisitAll(context, YieldKeyValueArrayVisitor, block);
        return this;
    }

    @Deprecated
    public RubyHash replace19(ThreadContext context, IRubyObject other) {
        return this.replace(context, other);
    }

    @Deprecated
    public final void visitAll(Visitor visitor) {
        this.visitLimited(this.getRuntime().getCurrentContext(), visitor, -1L, null);
    }

    @Deprecated
    public IRubyObject default_value_get(ThreadContext context, IRubyObject[] args2) {
        switch (args2.length) {
            case 0: {
                return this.default_value_get(context);
            }
            case 1: {
                return this.default_value_get(context, args2[0]);
            }
        }
        throw context.runtime.newArgumentError(args2.length, 1);
    }

    @Deprecated
    protected void internalPutSmall(IRubyObject key2, IRubyObject value2, boolean checkForExisting) {
        this.internalPutNoResize(key2, value2, checkForExisting);
    }

    static {
        AtomicIntegerFieldUpdater<RubyHash> iterUp = null;
        try {
            iterUp = AtomicIntegerFieldUpdater.newUpdater(RubyHash.class, "iteratorCount");
        }
        catch (Exception exception2) {
            // empty catch block
        }
        ITERATOR_UPDATER = iterUp;
        YieldArrayVisitor = new VisitorWithState<Block>(){

            @Override
            public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, Block block) {
                block.yieldArray(context, context.runtime.newArray(key2, value2), null);
            }
        };
        YieldKeyValueArrayVisitor = new VisitorWithState<Block>(){

            @Override
            public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, Block block) {
                block.yield(context, context.runtime.newArray(key2, value2));
            }
        };
        YieldValueVisitor = new VisitorWithState<Block>(){

            @Override
            public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, Block block) {
                block.yield(context, value2);
            }
        };
        YieldKeyVisitor = new VisitorWithState<Block>(){

            @Override
            public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, Block block) {
                block.yield(context, key2);
            }
        };
        FoundKeyIfEqual = new VisitorWithState<IRubyObject>(){

            @Override
            public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, IRubyObject expected) {
                if (RubyObject.equalInternal(context, value2, expected)) {
                    throw new FoundKey(key2);
                }
            }
        };
        StoreKeyVisitor = new VisitorWithState<RubyArray>(){

            @Override
            public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, RubyArray keys2) {
                keys2.store(index2, key2);
            }
        };
        StoreValueVisitor = new VisitorWithState<RubyArray>(){

            @Override
            public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, RubyArray values2) {
                values2.store(index2, value2);
            }
        };
        MISMATCH = new Mismatch();
        DeleteIfVisitor = new VisitorWithState<Block>(){

            @Override
            public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, Block block) {
                if (block.yieldArray(context, RubyArray.newArray(context.runtime, key2, value2), null).isTrue()) {
                    self2.delete(context, key2, Block.NULL_BLOCK);
                }
            }
        };
        InvertVisitor = new VisitorWithState<RubyHash>(){

            @Override
            public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, RubyHash state2) {
                state2.op_aset(context, value2, key2);
            }
        };
        ReplaceVisitor = new VisitorWithState<RubyHash>(){

            @Override
            public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, RubyHash target) {
                target.op_aset(context, key2, value2);
            }
        };
        FoundPairIfEqualKeyVisitor = new VisitorWithState<IRubyObject>(){

            @Override
            public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, IRubyObject obj) {
                if (RubyObject.equalInternal(context, obj, key2)) {
                    throw new FoundPair(key2, value2);
                }
            }
        };
        FoundPairIfEqualValueVisitor = new VisitorWithState<IRubyObject>(){

            @Override
            public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, IRubyObject obj) {
                if (RubyObject.equalInternal(context, obj, value2)) {
                    throw new FoundPair(key2, value2);
                }
            }
        };
        MarshalDumpVisitor = new VisitorWithState<MarshalStream>(){

            @Override
            public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, MarshalStream output) {
                try {
                    output.dumpObject(key2);
                    output.dumpObject(value2);
                }
                catch (IOException e) {
                    throw new VisitorIOException(e);
                }
            }
        };
        DIRECT_KEY_VIEW = new EntryView(){

            @Override
            public Object convertEntry(Ruby runtime2, RubyHashEntry entry) {
                return entry.key;
            }

            @Override
            public boolean contains(RubyHash hash2, Object o) {
                if (!(o instanceof IRubyObject)) {
                    return false;
                }
                return hash2.internalGet((IRubyObject)o) != null;
            }

            @Override
            public boolean remove(RubyHash hash2, Object o) {
                if (!(o instanceof IRubyObject)) {
                    return false;
                }
                return hash2.internalDelete((IRubyObject)o) != NO_ENTRY;
            }
        };
        KEY_VIEW = new EntryView(){

            @Override
            public Object convertEntry(Ruby runtime2, RubyHashEntry entry) {
                return entry.key.toJava(Object.class);
            }

            @Override
            public boolean contains(RubyHash hash2, Object o) {
                return hash2.containsKey(o);
            }

            @Override
            public boolean remove(RubyHash hash2, Object o) {
                return hash2.remove(o) != null;
            }
        };
        DIRECT_VALUE_VIEW = new EntryView(){

            @Override
            public Object convertEntry(Ruby runtime2, RubyHashEntry entry) {
                return entry.value;
            }

            @Override
            public boolean contains(RubyHash hash2, Object o) {
                if (!(o instanceof IRubyObject)) {
                    return false;
                }
                IRubyObject obj = (IRubyObject)o;
                return hash2.hasValue(obj.getRuntime().getCurrentContext(), obj);
            }

            @Override
            public boolean remove(RubyHash hash2, Object o) {
                if (!(o instanceof IRubyObject)) {
                    return false;
                }
                IRubyObject obj = (IRubyObject)o;
                IRubyObject key2 = hash2.internalIndex(obj.getRuntime().getCurrentContext(), obj);
                if (key2 == null) {
                    return false;
                }
                return hash2.internalDelete(key2) != NO_ENTRY;
            }
        };
        VALUE_VIEW = new EntryView(){

            @Override
            public Object convertEntry(Ruby runtime2, RubyHashEntry entry) {
                return entry.value.toJava(Object.class);
            }

            @Override
            public boolean contains(RubyHash hash2, Object o) {
                return hash2.containsValue(o);
            }

            @Override
            public boolean remove(RubyHash hash2, Object o) {
                IRubyObject value2 = JavaUtil.convertJavaToUsableRubyObject(hash2.getRuntime(), o);
                IRubyObject key2 = hash2.internalIndex(hash2.getRuntime().getCurrentContext(), value2);
                if (key2 == null) {
                    return false;
                }
                return hash2.internalDelete(key2) != NO_ENTRY;
            }
        };
        DIRECT_ENTRY_VIEW = new EntryView(){

            @Override
            public Object convertEntry(Ruby runtime2, RubyHashEntry entry) {
                return entry;
            }

            @Override
            public boolean contains(RubyHash hash2, Object o) {
                if (!(o instanceof RubyHashEntry)) {
                    return false;
                }
                RubyHashEntry entry = (RubyHashEntry)o;
                RubyHashEntry candidate = hash2.internalGetEntry(entry.key);
                return candidate != NO_ENTRY && entry.equals(candidate);
            }

            @Override
            public boolean remove(RubyHash hash2, Object o) {
                if (!(o instanceof RubyHashEntry)) {
                    return false;
                }
                return hash2.internalDeleteEntry((RubyHashEntry)o) != NO_ENTRY;
            }
        };
        ENTRY_VIEW = new EntryView(){

            @Override
            public Object convertEntry(Ruby runtime2, RubyHashEntry entry) {
                return new ConvertingEntry(runtime2, entry);
            }

            @Override
            public boolean contains(RubyHash hash2, Object o) {
                if (!(o instanceof ConvertingEntry)) {
                    return false;
                }
                ConvertingEntry entry = (ConvertingEntry)o;
                RubyHashEntry candidate = hash2.internalGetEntry(((ConvertingEntry)entry).entry.key);
                return candidate != NO_ENTRY && entry.entry.equals(candidate);
            }

            @Override
            public boolean remove(RubyHash hash2, Object o) {
                if (!(o instanceof ConvertingEntry)) {
                    return false;
                }
                ConvertingEntry entry = (ConvertingEntry)o;
                return hash2.internalDeleteEntry(entry.entry) != NO_ENTRY;
            }
        };
    }

    private static class ConvertingEntry
    implements Map.Entry {
        private final RubyHashEntry entry;
        private final Ruby runtime;

        public ConvertingEntry(Ruby runtime2, RubyHashEntry entry) {
            this.entry = entry;
            this.runtime = runtime2;
        }

        public Object getKey() {
            return this.entry.key.toJava(Object.class);
        }

        public Object getValue() {
            return this.entry.value.toJava(Object.class);
        }

        public Object setValue(Object o) {
            return this.entry.setValue(JavaUtil.convertJavaToUsableRubyObject(this.runtime, o));
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof ConvertingEntry)) {
                return false;
            }
            ConvertingEntry other = (ConvertingEntry)o;
            return this.entry.equals(other.entry);
        }

        @Override
        public int hashCode() {
            return this.entry.hashCode();
        }
    }

    private static abstract class EntryView {
        private EntryView() {
        }

        public abstract Object convertEntry(Ruby var1, RubyHashEntry var2);

        public abstract boolean contains(RubyHash var1, Object var2);

        public abstract boolean remove(RubyHash var1, Object var2);
    }

    private class BaseIterator
    implements Iterator {
        private final EntryView view;
        private RubyHashEntry entry;
        private boolean peeking;
        private int startGeneration;

        public BaseIterator(EntryView view) {
            this.view = view;
            this.entry = RubyHash.this.head;
            this.startGeneration = RubyHash.this.generation;
        }

        private void advance(boolean consume) {
            if (!this.peeking) {
                do {
                    if (this.startGeneration != RubyHash.this.generation) {
                        this.startGeneration = RubyHash.this.generation;
                        this.entry = RubyHash.this.head;
                    }
                    this.entry = this.entry.nextAdded;
                } while (this.entry != RubyHash.this.head && !this.entry.isLive());
            }
            this.peeking = !consume;
        }

        public Object next() {
            this.advance(true);
            if (this.entry == RubyHash.this.head) {
                this.peeking = true;
                throw new NoSuchElementException();
            }
            return this.view.convertEntry(RubyHash.this.getRuntime(), this.entry);
        }

        @Override
        public boolean hasNext() {
            this.advance(false);
            return this.entry != RubyHash.this.head;
        }

        @Override
        public void remove() {
            if (this.entry == RubyHash.this.head) {
                throw new IllegalStateException("Iterator out of range");
            }
            RubyHash.this.internalDeleteEntry(this.entry);
        }
    }

    private class BaseCollection
    extends AbstractCollection {
        final EntryView view;

        public BaseCollection(EntryView view) {
            this.view = view;
        }

        @Override
        public Iterator iterator() {
            return new BaseIterator(this.view);
        }

        @Override
        public boolean contains(Object o) {
            return this.view.contains(RubyHash.this, o);
        }

        @Override
        public void clear() {
            RubyHash.this.clear();
        }

        @Override
        public int size() {
            return RubyHash.this.size;
        }

        @Override
        public boolean remove(Object o) {
            return this.view.remove(RubyHash.this, o);
        }
    }

    private class BaseSet
    extends AbstractSet {
        final EntryView view;

        public BaseSet(EntryView view) {
            this.view = view;
        }

        @Override
        public Iterator iterator() {
            return new BaseIterator(this.view);
        }

        @Override
        public boolean contains(Object o) {
            return this.view.contains(RubyHash.this, o);
        }

        @Override
        public void clear() {
            RubyHash.this.clear();
        }

        @Override
        public int size() {
            return RubyHash.this.size;
        }

        @Override
        public boolean remove(Object o) {
            return this.view.remove(RubyHash.this, o);
        }
    }

    private static class VisitorIOException
    extends RuntimeException {
        VisitorIOException(Throwable cause2) {
            super(cause2);
        }
    }

    private static class MergeVisitor
    extends VisitorWithState<Block> {
        final RubyHash target;

        MergeVisitor(RubyHash target) {
            this.target = target;
        }

        @Override
        public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, Block block) {
            IRubyObject existing;
            if (block.isGiven() && (existing = this.target.internalGet(key2)) != null) {
                value2 = block.yield(context, RubyArray.newArray(context.runtime, key2, existing, value2));
            }
            this.target.op_aset(context, key2, value2);
        }
    }

    private static final class RejectVisitor
    extends VisitorWithState<Block> {
        final RubyHash result;

        RejectVisitor(RubyHash result2) {
            this.result = result2;
        }

        @Override
        public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, Block block) {
            if (!block.yieldArray(context, RubyArray.newArray(context.runtime, key2, value2), null).isTrue()) {
                this.result.fastASet(key2, value2);
            }
        }
    }

    private static class SelectVisitor
    extends VisitorWithState<Block> {
        final RubyHash result;

        SelectVisitor(RubyHash result2) {
            this.result = result2;
        }

        @Override
        public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, Block block) {
            if (block.yieldArray(context, context.runtime.newArray(key2, value2), null).isTrue()) {
                this.result.fastASet(key2, value2);
            }
        }
    }

    private static class Mismatch
    extends RuntimeException {
        private Mismatch() {
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    private static class KeepIfVisitor
    extends VisitorWithState<Block> {
        boolean modified = false;

        private KeepIfVisitor() {
        }

        @Override
        public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, Block block) {
            if (!block.yieldArray(context, context.runtime.newArray(key2, value2), null).isTrue()) {
                this.modified = true;
                self2.remove(key2);
            }
        }
    }

    private static class TransformValuesVisitor
    extends VisitorWithState<Block> {
        private TransformValuesVisitor() {
        }

        @Override
        public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, Block block) {
            IRubyObject newValue = block.yield(context, value2);
            self2.op_aset(context, key2, newValue);
        }
    }

    private static class TransformKeysVisitor
    extends VisitorWithState<RubyHash> {
        private final Block block;

        public TransformKeysVisitor(Block block) {
            this.block = block;
        }

        @Override
        public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, RubyHash result2) {
            IRubyObject newKey = this.block.yield(context, key2);
            result2.fastASet(newKey, value2);
        }
    }

    private static class FoundPair
    extends FoundKey {
        public final IRubyObject value;

        FoundPair(IRubyObject key2, IRubyObject value2) {
            super(key2);
            this.value = value2;
        }
    }

    private static class FoundKey
    extends Found {
        public final IRubyObject key;

        FoundKey(IRubyObject key2) {
            this.key = key2;
        }
    }

    private static class Found
    extends RuntimeException {
        private Found() {
        }

        @Override
        public Throwable fillInStackTrace() {
            return null;
        }
    }

    public static abstract class Visitor
    extends VisitorWithState {
        public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, Object state2) {
            this.visit(key2, value2);
        }

        public abstract void visit(IRubyObject var1, IRubyObject var2);
    }

    public static abstract class VisitorWithState<T> {
        public abstract void visit(ThreadContext var1, RubyHash var2, IRubyObject var3, IRubyObject var4, int var5, T var6);
    }

    private static abstract class EntryMatchType {
        private EntryMatchType() {
        }

        public abstract boolean matches(RubyHashEntry var1, Object var2);
    }

    public static final class RubyHashEntry
    implements Map.Entry {
        IRubyObject key;
        IRubyObject value;
        private RubyHashEntry next;
        private RubyHashEntry prevAdded;
        private RubyHashEntry nextAdded;
        private int hash;

        RubyHashEntry() {
            this.key = RubyBasicObject.NEVER;
        }

        public RubyHashEntry(int h, IRubyObject k, IRubyObject v, RubyHashEntry e, RubyHashEntry head) {
            this.key = k;
            this.value = v;
            this.next = e;
            this.hash = h;
            if (head != null) {
                this.prevAdded = head.prevAdded;
                this.nextAdded = head;
                this.nextAdded.prevAdded = this;
                this.prevAdded.nextAdded = this;
            }
        }

        public void detach() {
            if (this.prevAdded != null) {
                this.prevAdded.nextAdded = this.nextAdded;
                this.nextAdded.prevAdded = this.prevAdded;
                this.prevAdded = null;
            }
        }

        public boolean isLive() {
            return this.prevAdded != null;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getJavaifiedKey() {
            return this.key.toJava(Object.class);
        }

        public Object getValue() {
            return this.value;
        }

        public Object getJavaifiedValue() {
            return this.value.toJava(Object.class);
        }

        public Object setValue(Object value2) {
            IRubyObject oldValue = this.value;
            if (!(value2 instanceof IRubyObject)) {
                throw new UnsupportedOperationException("directEntrySet() doesn't support setValue for non IRubyObject instance entries, convert them manually or use entrySet() instead");
            }
            this.value = (IRubyObject)value2;
            return oldValue;
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof RubyHashEntry)) {
                return false;
            }
            RubyHashEntry otherEntry = (RubyHashEntry)other;
            return !(this.key != otherEntry.key && !this.key.eql(otherEntry.key) || this.value != otherEntry.value && !this.value.equals(otherEntry.value));
        }

        @Override
        public int hashCode() {
            return this.key.hashCode() ^ this.value.hashCode();
        }
    }
}

