/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.ast.AliasNode;
import org.jruby.ast.AndNode;
import org.jruby.ast.ArgsCatNode;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ArgsPushNode;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.AssignableNode;
import org.jruby.ast.AttrAssignNode;
import org.jruby.ast.BackRefNode;
import org.jruby.ast.BeginNode;
import org.jruby.ast.BignumNode;
import org.jruby.ast.BlockArgNode;
import org.jruby.ast.BlockNode;
import org.jruby.ast.BlockPassNode;
import org.jruby.ast.BreakNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.CaseNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.ClassVarAsgnNode;
import org.jruby.ast.ClassVarDeclNode;
import org.jruby.ast.ClassVarNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.Colon3Node;
import org.jruby.ast.ComplexNode;
import org.jruby.ast.ConstDeclNode;
import org.jruby.ast.ConstNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.DNode;
import org.jruby.ast.DRegexpNode;
import org.jruby.ast.DStrNode;
import org.jruby.ast.DSymbolNode;
import org.jruby.ast.DVarNode;
import org.jruby.ast.DXStrNode;
import org.jruby.ast.DefNode;
import org.jruby.ast.DefinedNode;
import org.jruby.ast.DefsNode;
import org.jruby.ast.DotNode;
import org.jruby.ast.EncodingNode;
import org.jruby.ast.EnsureNode;
import org.jruby.ast.EvStrNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.FileNode;
import org.jruby.ast.FixnumNode;
import org.jruby.ast.FlipNode;
import org.jruby.ast.FloatNode;
import org.jruby.ast.ForNode;
import org.jruby.ast.GlobalAsgnNode;
import org.jruby.ast.GlobalVarNode;
import org.jruby.ast.HashNode;
import org.jruby.ast.IfNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.KeywordArgNode;
import org.jruby.ast.KeywordRestArgNode;
import org.jruby.ast.LambdaNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.LiteralNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.LocalVarNode;
import org.jruby.ast.Match2CaptureNode;
import org.jruby.ast.Match2Node;
import org.jruby.ast.Match3Node;
import org.jruby.ast.MatchNode;
import org.jruby.ast.MethodDefNode;
import org.jruby.ast.ModuleNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.NextNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.NthRefNode;
import org.jruby.ast.OpAsgnAndNode;
import org.jruby.ast.OpAsgnConstDeclNode;
import org.jruby.ast.OpAsgnNode;
import org.jruby.ast.OpAsgnOrNode;
import org.jruby.ast.OpElementAsgnNode;
import org.jruby.ast.OptArgNode;
import org.jruby.ast.OrNode;
import org.jruby.ast.PostExeNode;
import org.jruby.ast.PreExeNode;
import org.jruby.ast.RationalNode;
import org.jruby.ast.RegexpNode;
import org.jruby.ast.RescueBodyNode;
import org.jruby.ast.RescueModNode;
import org.jruby.ast.RescueNode;
import org.jruby.ast.ReturnNode;
import org.jruby.ast.RootNode;
import org.jruby.ast.SClassNode;
import org.jruby.ast.SValueNode;
import org.jruby.ast.SelfNode;
import org.jruby.ast.SideEffectFree;
import org.jruby.ast.SplatNode;
import org.jruby.ast.StarNode;
import org.jruby.ast.StrNode;
import org.jruby.ast.SuperNode;
import org.jruby.ast.SymbolNode;
import org.jruby.ast.UndefNode;
import org.jruby.ast.UntilNode;
import org.jruby.ast.VAliasNode;
import org.jruby.ast.VCallNode;
import org.jruby.ast.WhenNode;
import org.jruby.ast.WhileNode;
import org.jruby.ast.XStrNode;
import org.jruby.ast.YieldNode;
import org.jruby.ast.ZSuperNode;
import org.jruby.ast.types.INameNode;
import org.jruby.compiler.NotCompilableException;
import org.jruby.ir.IRClassBody;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IREvalScript;
import org.jruby.ir.IRFlags;
import org.jruby.ir.IRFor;
import org.jruby.ir.IRManager;
import org.jruby.ir.IRMetaClassBody;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRModuleBody;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRScriptBody;
import org.jruby.ir.Tuple;
import org.jruby.ir.instructions.AliasInstr;
import org.jruby.ir.instructions.ArgScopeDepthInstr;
import org.jruby.ir.instructions.ArrayDerefInstr;
import org.jruby.ir.instructions.AttrAssignInstr;
import org.jruby.ir.instructions.BEQInstr;
import org.jruby.ir.instructions.BNEInstr;
import org.jruby.ir.instructions.BNilInstr;
import org.jruby.ir.instructions.BSwitchInstr;
import org.jruby.ir.instructions.BacktickInstr;
import org.jruby.ir.instructions.BlockGivenInstr;
import org.jruby.ir.instructions.BreakInstr;
import org.jruby.ir.instructions.BuildBackrefInstr;
import org.jruby.ir.instructions.BuildCompoundArrayInstr;
import org.jruby.ir.instructions.BuildCompoundStringInstr;
import org.jruby.ir.instructions.BuildDynRegExpInstr;
import org.jruby.ir.instructions.BuildLambdaInstr;
import org.jruby.ir.instructions.BuildRangeInstr;
import org.jruby.ir.instructions.BuildSplatInstr;
import org.jruby.ir.instructions.CallBase;
import org.jruby.ir.instructions.CallInstr;
import org.jruby.ir.instructions.CheckArityInstr;
import org.jruby.ir.instructions.CheckForLJEInstr;
import org.jruby.ir.instructions.ClassSuperInstr;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.DefineClassInstr;
import org.jruby.ir.instructions.DefineClassMethodInstr;
import org.jruby.ir.instructions.DefineInstanceMethodInstr;
import org.jruby.ir.instructions.DefineMetaClassInstr;
import org.jruby.ir.instructions.DefineModuleInstr;
import org.jruby.ir.instructions.EQQInstr;
import org.jruby.ir.instructions.ExceptionRegionEndMarkerInstr;
import org.jruby.ir.instructions.ExceptionRegionStartMarkerInstr;
import org.jruby.ir.instructions.GVarAliasInstr;
import org.jruby.ir.instructions.GetClassVarContainerModuleInstr;
import org.jruby.ir.instructions.GetClassVariableInstr;
import org.jruby.ir.instructions.GetEncodingInstr;
import org.jruby.ir.instructions.GetFieldInstr;
import org.jruby.ir.instructions.GetGlobalVariableInstr;
import org.jruby.ir.instructions.InheritanceSearchConstInstr;
import org.jruby.ir.instructions.InstanceSuperInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.JumpInstr;
import org.jruby.ir.instructions.LabelInstr;
import org.jruby.ir.instructions.LexicalSearchConstInstr;
import org.jruby.ir.instructions.LineNumberInstr;
import org.jruby.ir.instructions.LoadFrameClosureInstr;
import org.jruby.ir.instructions.LoadImplicitClosureInstr;
import org.jruby.ir.instructions.MatchInstr;
import org.jruby.ir.instructions.NonlocalReturnInstr;
import org.jruby.ir.instructions.ProcessModuleBodyInstr;
import org.jruby.ir.instructions.PutClassVariableInstr;
import org.jruby.ir.instructions.PutConstInstr;
import org.jruby.ir.instructions.PutFieldInstr;
import org.jruby.ir.instructions.PutGlobalVarInstr;
import org.jruby.ir.instructions.RaiseRequiredKeywordArgumentError;
import org.jruby.ir.instructions.ReceiveArgBase;
import org.jruby.ir.instructions.ReceiveJRubyExceptionInstr;
import org.jruby.ir.instructions.ReceiveKeywordArgInstr;
import org.jruby.ir.instructions.ReceiveKeywordRestArgInstr;
import org.jruby.ir.instructions.ReceiveOptArgInstr;
import org.jruby.ir.instructions.ReceivePostReqdArgInstr;
import org.jruby.ir.instructions.ReceivePreReqdArgInstr;
import org.jruby.ir.instructions.ReceiveRestArgInstr;
import org.jruby.ir.instructions.ReceiveRubyExceptionInstr;
import org.jruby.ir.instructions.RecordEndBlockInstr;
import org.jruby.ir.instructions.ReifyClosureInstr;
import org.jruby.ir.instructions.ReqdArgMultipleAsgnInstr;
import org.jruby.ir.instructions.RescueEQQInstr;
import org.jruby.ir.instructions.RestArgMultipleAsgnInstr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.instructions.ReturnInstr;
import org.jruby.ir.instructions.ReturnOrRethrowSavedExcInstr;
import org.jruby.ir.instructions.RuntimeHelperCall;
import org.jruby.ir.instructions.SearchConstInstr;
import org.jruby.ir.instructions.SearchModuleForConstInstr;
import org.jruby.ir.instructions.SetCapturedVarInstr;
import org.jruby.ir.instructions.ThreadPollInstr;
import org.jruby.ir.instructions.ThrowExceptionInstr;
import org.jruby.ir.instructions.ToAryInstr;
import org.jruby.ir.instructions.TraceInstr;
import org.jruby.ir.instructions.UndefMethodInstr;
import org.jruby.ir.instructions.UnresolvedSuperInstr;
import org.jruby.ir.instructions.YieldInstr;
import org.jruby.ir.instructions.ZSuperInstr;
import org.jruby.ir.instructions.defined.GetErrorInfoInstr;
import org.jruby.ir.instructions.defined.RestoreErrorInfoInstr;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.ir.operands.Array;
import org.jruby.ir.operands.AsString;
import org.jruby.ir.operands.Bignum;
import org.jruby.ir.operands.Boolean;
import org.jruby.ir.operands.Complex;
import org.jruby.ir.operands.CurrentScope;
import org.jruby.ir.operands.DepthCloneable;
import org.jruby.ir.operands.DynamicSymbol;
import org.jruby.ir.operands.Filename;
import org.jruby.ir.operands.Fixnum;
import org.jruby.ir.operands.Float;
import org.jruby.ir.operands.FrozenString;
import org.jruby.ir.operands.Hash;
import org.jruby.ir.operands.IRException;
import org.jruby.ir.operands.ImmutableLiteral;
import org.jruby.ir.operands.Label;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.Nil;
import org.jruby.ir.operands.NthRef;
import org.jruby.ir.operands.NullBlock;
import org.jruby.ir.operands.ObjectClass;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Rational;
import org.jruby.ir.operands.Regexp;
import org.jruby.ir.operands.SValue;
import org.jruby.ir.operands.ScopeModule;
import org.jruby.ir.operands.Splat;
import org.jruby.ir.operands.StringLiteral;
import org.jruby.ir.operands.Symbol;
import org.jruby.ir.operands.SymbolProc;
import org.jruby.ir.operands.TemporaryVariable;
import org.jruby.ir.operands.UndefinedValue;
import org.jruby.ir.operands.UnexecutableNil;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.operands.WrappedIRClosure;
import org.jruby.ir.transformations.inlining.SimpleCloneInfo;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.ArgumentDescriptor;
import org.jruby.runtime.ArgumentType;
import org.jruby.runtime.CallType;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.Signature;
import org.jruby.util.ByteList;
import org.jruby.util.DefinedMessage;
import org.jruby.util.KeyValuePair;

public class IRBuilder {
    static final Operand[] NO_ARGS = new Operand[0];
    static final UnexecutableNil U_NIL = UnexecutableNil.U_NIL;
    public static final String USING_METHOD = "using";
    private Stack<RescueBlockInfo> activeRescueBlockStack = new Stack();
    private Stack<EnsureBlockInfo> activeEnsureBlockStack = new Stack();
    private Stack<EnsureBlockInfo> ensureBodyBuildStack = new Stack();
    private Stack<Label> activeRescuers = new Stack();
    private Stack<IRLoop> loopStack = new Stack();
    private int _lastProcessedLineNum = -1;
    public boolean underscoreVariableSeen = false;
    protected IRBuilder parent;
    protected IRManager manager;
    protected IRScope scope;
    protected List<Instr> instructions;
    protected List<String> argumentDescriptions;
    protected boolean needsCodeCoverage;
    static final ArgumentDescriptor[] NO_ARG_DESCS = new ArgumentDescriptor[0];

    public static Node buildAST(boolean isCommandLineScript, String arg2) {
        Ruby ruby2 = Ruby.getGlobalRuntime();
        if (isCommandLineScript) {
            return ruby2.parse(ByteList.create((CharSequence)arg2), "-e", null, 0, false);
        }
        FileInputStream fis = null;
        try {
            File file2 = new File(arg2);
            fis = new FileInputStream(file2);
            long size2 = file2.length();
            byte[] bytes2 = new byte[(int)size2];
            fis.read(bytes2);
            System.out.println("-- processing " + arg2 + " --");
            Node node = ruby2.parse(new ByteList(bytes2), arg2, null, 0, false);
            return node;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception exception2) {}
        }
    }

    public IRLoop getCurrentLoop() {
        return this.loopStack.isEmpty() ? null : this.loopStack.peek();
    }

    public IRBuilder(IRManager manager, IRScope scope, IRBuilder parent) {
        this.manager = manager;
        this.scope = scope;
        this.parent = parent;
        this.instructions = new ArrayList<Instr>(50);
        this.activeRescuers.push(Label.UNRESCUED_REGION_LABEL);
    }

    private boolean needsCodeCoverage() {
        return this.needsCodeCoverage || this.parent != null && this.parent.needsCodeCoverage();
    }

    public void addArgumentDescription(ArgumentType type2, String name2) {
        if (this.argumentDescriptions == null) {
            this.argumentDescriptions = new ArrayList<String>();
        }
        this.argumentDescriptions.add(type2.toString());
        this.argumentDescriptions.add(name2);
    }

    public void addInstr(Instr instr) {
        if (this.ensureBodyBuildStack.empty()) {
            if (instr instanceof ThreadPollInstr) {
                ++this.scope.threadPollInstrsCount;
            }
            instr.computeScopeFlags(this.scope);
            if (this.hasListener()) {
                this.manager.getIRScopeListener().addedInstr(this.scope, instr, this.instructions.size());
            }
            this.instructions.add(instr);
        } else {
            this.ensureBodyBuildStack.peek().addInstr(instr);
        }
    }

    public void addInstrAtBeginning(Instr instr) {
        if (this.ensureBodyBuildStack.empty()) {
            instr.computeScopeFlags(this.scope);
            if (this.hasListener()) {
                this.manager.getIRScopeListener().addedInstr(this.scope, instr, 0);
            }
            this.instructions.add(0, instr);
        } else {
            this.ensureBodyBuildStack.peek().addInstrAtBeginning(instr);
        }
    }

    public IRBuilder getNearestFlipVariableScopeBuilder() {
        IRBuilder current2 = this;
        while (current2 != null && !this.scope.isFlipScope()) {
            current2 = current2.parent;
        }
        return current2;
    }

    private void emitEnsureBlocks(IRLoop loop2) {
        int n = this.activeEnsureBlockStack.size();
        EnsureBlockInfo[] ebArray = this.activeEnsureBlockStack.toArray(new EnsureBlockInfo[n]);
        for (int i2 = n - 1; i2 >= 0; --i2) {
            EnsureBlockInfo ebi = ebArray[i2];
            if (loop2 != null && ebi.innermostLoop != loop2) break;
            ebi.cloneIntoHostScope(this);
        }
    }

    private Operand buildOperand(Node node) throws NotCompilableException {
        int currLineNum;
        if (node.isNewline() && (currLineNum = node.getLine()) != this._lastProcessedLineNum) {
            this.addInstr(this.manager.newLineNumber(currLineNum));
            if (RubyInstanceConfig.FULL_TRACE_ENABLED) {
                this.addInstr(new TraceInstr(RubyEvent.LINE, this.methodNameFor(), this.getFileName(), currLineNum));
                if (this.needsCodeCoverage()) {
                    this.addInstr(new TraceInstr(RubyEvent.COVERAGE, this.methodNameFor(), this.getFileName(), currLineNum));
                }
            }
            this._lastProcessedLineNum = currLineNum;
        }
        switch (node.getNodeType()) {
            case ALIASNODE: {
                return this.buildAlias((AliasNode)node);
            }
            case ANDNODE: {
                return this.buildAnd((AndNode)node);
            }
            case ARGSCATNODE: {
                return this.buildArgsCat((ArgsCatNode)node);
            }
            case ARGSPUSHNODE: {
                return this.buildArgsPush((ArgsPushNode)node);
            }
            case ARRAYNODE: {
                return this.buildArray((ArrayNode)node, false);
            }
            case ATTRASSIGNNODE: {
                return this.buildAttrAssign((AttrAssignNode)node);
            }
            case BACKREFNODE: {
                return this.buildBackref((BackRefNode)node);
            }
            case BEGINNODE: {
                return this.buildBegin((BeginNode)node);
            }
            case BIGNUMNODE: {
                return this.buildBignum((BignumNode)node);
            }
            case BLOCKNODE: {
                return this.buildBlock((BlockNode)node);
            }
            case BREAKNODE: {
                return this.buildBreak((BreakNode)node);
            }
            case CALLNODE: {
                return this.buildCall((CallNode)node);
            }
            case CASENODE: {
                return this.buildCase((CaseNode)node);
            }
            case CLASSNODE: {
                return this.buildClass((ClassNode)node);
            }
            case CLASSVARNODE: {
                return this.buildClassVar((ClassVarNode)node);
            }
            case CLASSVARASGNNODE: {
                return this.buildClassVarAsgn((ClassVarAsgnNode)node);
            }
            case CLASSVARDECLNODE: {
                return this.buildClassVarDecl((ClassVarDeclNode)node);
            }
            case COLON2NODE: {
                return this.buildColon2((Colon2Node)node);
            }
            case COLON3NODE: {
                return this.buildColon3((Colon3Node)node);
            }
            case COMPLEXNODE: {
                return this.buildComplex((ComplexNode)node);
            }
            case CONSTDECLNODE: {
                return this.buildConstDecl((ConstDeclNode)node);
            }
            case CONSTNODE: {
                return this.searchConst(((ConstNode)node).getName());
            }
            case DASGNNODE: {
                return this.buildDAsgn((DAsgnNode)node);
            }
            case DEFINEDNODE: {
                return this.buildGetDefinition(((DefinedNode)node).getExpressionNode());
            }
            case DEFNNODE: {
                return this.buildDefn((MethodDefNode)node);
            }
            case DEFSNODE: {
                return this.buildDefs((DefsNode)node);
            }
            case DOTNODE: {
                return this.buildDot((DotNode)node);
            }
            case DREGEXPNODE: {
                return this.buildDRegexp((DRegexpNode)node);
            }
            case DSTRNODE: {
                return this.buildDStr((DStrNode)node);
            }
            case DSYMBOLNODE: {
                return this.buildDSymbol((DSymbolNode)node);
            }
            case DVARNODE: {
                return this.buildDVar((DVarNode)node);
            }
            case DXSTRNODE: {
                return this.buildDXStr((DXStrNode)node);
            }
            case ENCODINGNODE: {
                return this.buildEncoding((EncodingNode)node);
            }
            case ENSURENODE: {
                return this.buildEnsureNode((EnsureNode)node);
            }
            case EVSTRNODE: {
                return this.buildEvStr((EvStrNode)node);
            }
            case FALSENODE: {
                return this.buildFalse();
            }
            case FCALLNODE: {
                return this.buildFCall((FCallNode)node);
            }
            case FIXNUMNODE: {
                return this.buildFixnum((FixnumNode)node);
            }
            case FLIPNODE: {
                return this.buildFlip((FlipNode)node);
            }
            case FLOATNODE: {
                return this.buildFloat((FloatNode)node);
            }
            case FORNODE: {
                return this.buildFor((ForNode)node);
            }
            case GLOBALASGNNODE: {
                return this.buildGlobalAsgn((GlobalAsgnNode)node);
            }
            case GLOBALVARNODE: {
                return this.buildGlobalVar((GlobalVarNode)node);
            }
            case HASHNODE: {
                return this.buildHash((HashNode)node);
            }
            case IFNODE: {
                return this.buildIf((IfNode)node);
            }
            case INSTASGNNODE: {
                return this.buildInstAsgn((InstAsgnNode)node);
            }
            case INSTVARNODE: {
                return this.buildInstVar((InstVarNode)node);
            }
            case ITERNODE: {
                return this.buildIter((IterNode)node);
            }
            case LAMBDANODE: {
                return this.buildLambda((LambdaNode)node);
            }
            case LITERALNODE: {
                return this.buildLiteral((LiteralNode)node);
            }
            case LOCALASGNNODE: {
                return this.buildLocalAsgn((LocalAsgnNode)node);
            }
            case LOCALVARNODE: {
                return this.buildLocalVar((LocalVarNode)node);
            }
            case MATCH2NODE: {
                return this.buildMatch2((Match2Node)node);
            }
            case MATCH3NODE: {
                return this.buildMatch3((Match3Node)node);
            }
            case MATCHNODE: {
                return this.buildMatch((MatchNode)node);
            }
            case MODULENODE: {
                return this.buildModule((ModuleNode)node);
            }
            case MULTIPLEASGNNODE: {
                return this.buildMultipleAsgn19((MultipleAsgnNode)node);
            }
            case NEXTNODE: {
                return this.buildNext((NextNode)node);
            }
            case NTHREFNODE: {
                return this.buildNthRef((NthRefNode)node);
            }
            case NILNODE: {
                return this.buildNil();
            }
            case OPASGNANDNODE: {
                return this.buildOpAsgnAnd((OpAsgnAndNode)node);
            }
            case OPASGNCONSTDECLNODE: {
                return this.buildOpAsgnConstDeclNode((OpAsgnConstDeclNode)node);
            }
            case OPASGNNODE: {
                return this.buildOpAsgn((OpAsgnNode)node);
            }
            case OPASGNORNODE: {
                return this.buildOpAsgnOr((OpAsgnOrNode)node);
            }
            case OPELEMENTASGNNODE: {
                return this.buildOpElementAsgn((OpElementAsgnNode)node);
            }
            case ORNODE: {
                return this.buildOr((OrNode)node);
            }
            case PREEXENODE: {
                return this.buildPreExe((PreExeNode)node);
            }
            case POSTEXENODE: {
                return this.buildPostExe((PostExeNode)node);
            }
            case RATIONALNODE: {
                return this.buildRational((RationalNode)node);
            }
            case REDONODE: {
                return this.buildRedo();
            }
            case REGEXPNODE: {
                return this.buildRegexp((RegexpNode)node);
            }
            case RESCUEBODYNODE: {
                throw new NotCompilableException("rescue body is handled by rescue compilation at: " + this.scope.getFileName() + ":" + node.getLine());
            }
            case RESCUENODE: {
                return this.buildRescue((RescueNode)node);
            }
            case RETRYNODE: {
                return this.buildRetry();
            }
            case RETURNNODE: {
                return this.buildReturn((ReturnNode)node);
            }
            case ROOTNODE: {
                throw new NotCompilableException("Use buildRoot(); Root node at: " + this.scope.getFileName() + ":" + node.getLine());
            }
            case SCLASSNODE: {
                return this.buildSClass((SClassNode)node);
            }
            case SELFNODE: {
                return this.buildSelf();
            }
            case SPLATNODE: {
                return this.buildSplat((SplatNode)node);
            }
            case STRNODE: {
                return this.buildStr((StrNode)node);
            }
            case SUPERNODE: {
                return this.buildSuper((SuperNode)node);
            }
            case SVALUENODE: {
                return this.buildSValue((SValueNode)node);
            }
            case SYMBOLNODE: {
                return this.buildSymbol((SymbolNode)node);
            }
            case TRUENODE: {
                return this.buildTrue();
            }
            case UNDEFNODE: {
                return this.buildUndef(node);
            }
            case UNTILNODE: {
                return this.buildUntil((UntilNode)node);
            }
            case VALIASNODE: {
                return this.buildVAlias((VAliasNode)node);
            }
            case VCALLNODE: {
                return this.buildVCall((VCallNode)node);
            }
            case WHILENODE: {
                return this.buildWhile((WhileNode)node);
            }
            case WHENNODE: {
                assert (false) : "When nodes are handled by case node compilation.";
                return null;
            }
            case XSTRNODE: {
                return this.buildXStr((XStrNode)node);
            }
            case YIELDNODE: {
                return this.buildYield((YieldNode)node);
            }
            case ZARRAYNODE: {
                return this.buildZArray();
            }
            case ZSUPERNODE: {
                return this.buildZSuper((ZSuperNode)node);
            }
        }
        throw new NotCompilableException("Unknown node encountered in builder: " + node.getClass());
    }

    private boolean hasListener() {
        return this.manager.getIRScopeListener() != null;
    }

    public IRBuilder newIRBuilder(IRManager manager, IRScope newScope) {
        return new IRBuilder(manager, newScope, this);
    }

    public static IRBuilder topIRBuilder(IRManager manager, IRScope newScope) {
        return new IRBuilder(manager, newScope, null);
    }

    public Operand build(Node node) {
        if (node == null) {
            return null;
        }
        if (this.hasListener()) {
            this.manager.getIRScopeListener().startBuildOperand(node, this.scope);
        }
        Operand operand = this.buildOperand(node);
        if (this.hasListener()) {
            this.manager.getIRScopeListener().endBuildOperand(node, this.scope, operand);
        }
        return operand;
    }

    private InterpreterContext buildLambdaInner(LambdaNode node) {
        Operand closureRetVal;
        this.prepareImplicitState();
        this.addCurrentScopeAndModule();
        this.receiveBlockArgs(node);
        Operand operand = closureRetVal = node.getBody() == null ? this.manager.getNil() : this.build(node.getBody());
        if (closureRetVal != U_NIL) {
            this.addInstr(new ReturnInstr(closureRetVal));
        }
        this.handleBreakAndReturnsInLambdas();
        return this.scope.allocateInterpreterContext(this.instructions);
    }

    public Operand buildLambda(LambdaNode node) {
        IRClosure closure = new IRClosure(this.manager, this.scope, node.getLine(), node.getScope(), Signature.from(node), this.needsCodeCoverage);
        this.newIRBuilder(this.manager, closure).buildLambdaInner(node);
        TemporaryVariable lambda2 = this.createTemporaryVariable();
        WrappedIRClosure lambdaBody = new WrappedIRClosure(closure.getSelf(), closure);
        this.addInstr(new BuildLambdaInstr(lambda2, lambdaBody, this.scope.getFileName(), node.getLine()));
        return lambda2;
    }

    public Operand buildEncoding(EncodingNode node) {
        TemporaryVariable ret = this.createTemporaryVariable();
        this.addInstr(new GetEncodingInstr(ret, node.getEncoding()));
        return ret;
    }

    public Operand buildMultipleAsgn19(MultipleAsgnNode multipleAsgnNode) {
        Node valueNode = multipleAsgnNode.getValueNode();
        Operand values2 = this.build(valueNode);
        Variable ret = this.getValueInTemporaryVariable(values2);
        if (valueNode instanceof ArrayNode) {
            this.buildMultipleAsgn19Assignment(multipleAsgnNode, null, ret);
        } else {
            TemporaryVariable tmp = this.createTemporaryVariable();
            this.addInstr(new ToAryInstr(tmp, (Operand)ret));
            this.buildMultipleAsgn19Assignment(multipleAsgnNode, null, tmp);
        }
        return ret;
    }

    protected Variable copyAndReturnValue(Operand val) {
        return this.addResultInstr(new CopyInstr(this.createTemporaryVariable(), val));
    }

    protected Operand buildWithOrder(Node node, boolean preserveOrder) {
        Operand value2 = this.build(node);
        return preserveOrder && !(value2 instanceof ImmutableLiteral) ? this.copyAndReturnValue(value2) : value2;
    }

    protected Variable getValueInTemporaryVariable(Operand val) {
        if (val != null && val instanceof TemporaryVariable) {
            return (Variable)val;
        }
        return this.copyAndReturnValue(val);
    }

    protected Operand buildAttrAssignCallArgs(List<Operand> argsList, Node args2, boolean containsAssignment) {
        if (args2 == null) {
            return this.manager.getNil();
        }
        switch (args2.getNodeType()) {
            case ARRAYNODE: {
                Operand last2 = this.manager.getNil();
                for (Node n : ((ListNode)args2).children()) {
                    last2 = this.buildWithOrder(n, containsAssignment);
                    argsList.add(last2);
                }
                return last2;
            }
            case ARGSPUSHNODE: {
                ArgsPushNode argsPushNode = (ArgsPushNode)args2;
                Operand lhs = this.build(argsPushNode.getFirstNode());
                Operand rhs = this.build(argsPushNode.getSecondNode());
                TemporaryVariable res = this.createTemporaryVariable();
                this.addInstr(new BuildCompoundArrayInstr(res, lhs, rhs, true));
                argsList.add(new Splat(res));
                return rhs;
            }
            case SPLATNODE: {
                Splat rhs = new Splat(this.buildSplat((SplatNode)args2));
                argsList.add(rhs);
                return rhs;
            }
        }
        throw new NotCompilableException("Invalid node for attrassign call args: " + args2.getClass().getSimpleName() + ":" + this.scope.getFileName() + ":" + args2.getLine());
    }

    protected Operand[] buildCallArgs(Node args2) {
        switch (args2.getNodeType()) {
            case ARGSCATNODE: 
            case ARGSPUSHNODE: {
                return new Operand[]{new Splat(this.addResultInstr(new BuildSplatInstr(this.createTemporaryVariable(), this.build(args2), false)))};
            }
            case ARRAYNODE: {
                Node[] children = ((ListNode)args2).children();
                int numberOfArgs = children.length;
                Operand[] builtArgs = new Operand[numberOfArgs];
                boolean hasAssignments = args2.containsVariableAssignment();
                for (int i2 = 0; i2 < numberOfArgs; ++i2) {
                    builtArgs[i2] = this.buildWithOrder(children[i2], hasAssignments);
                }
                return builtArgs;
            }
            case SPLATNODE: {
                return new Operand[]{new Splat(this.addResultInstr(new BuildSplatInstr(this.createTemporaryVariable(), this.build(args2), false)))};
            }
        }
        throw new NotCompilableException("Invalid node for call args: " + args2.getClass().getSimpleName() + ":" + this.scope.getFileName() + ":" + args2.getLine());
    }

    public Operand[] setupCallArgs(Node args2) {
        return args2 == null ? Operand.EMPTY_ARRAY : this.buildCallArgs(args2);
    }

    public static Operand[] addArg(Operand[] args2, Operand extraArg) {
        Operand[] newArgs = new Operand[args2.length + 1];
        System.arraycopy(args2, 0, newArgs, 0, args2.length);
        newArgs[args2.length] = extraArg;
        return newArgs;
    }

    public void buildAssignment(Node node, Variable rhsVal) {
        switch (node.getNodeType()) {
            case ATTRASSIGNNODE: {
                this.buildAttrAssignAssignment(node, rhsVal);
                break;
            }
            case CLASSVARASGNNODE: {
                this.addInstr(new PutClassVariableInstr(this.classVarDefinitionContainer(), ((ClassVarAsgnNode)node).getName(), (Operand)rhsVal));
                break;
            }
            case CLASSVARDECLNODE: {
                this.addInstr(new PutClassVariableInstr(this.classVarDeclarationContainer(), ((ClassVarDeclNode)node).getName(), (Operand)rhsVal));
                break;
            }
            case CONSTDECLNODE: {
                this.buildConstDeclAssignment((ConstDeclNode)node, rhsVal);
                break;
            }
            case DASGNNODE: {
                DAsgnNode variable = (DAsgnNode)node;
                int depth = variable.getDepth();
                this.addInstr(new CopyInstr(this.getLocalVariable(variable.getName(), depth), (Operand)rhsVal));
                break;
            }
            case GLOBALASGNNODE: {
                this.addInstr(new PutGlobalVarInstr(((GlobalAsgnNode)node).getName(), (Operand)rhsVal));
                break;
            }
            case INSTASGNNODE: {
                this.addInstr(new PutFieldInstr(this.buildSelf(), ((InstAsgnNode)node).getName(), (Operand)rhsVal));
                break;
            }
            case LOCALASGNNODE: {
                LocalAsgnNode localVariable = (LocalAsgnNode)node;
                int depth = localVariable.getDepth();
                this.addInstr(new CopyInstr(this.getLocalVariable(localVariable.getName(), depth), (Operand)rhsVal));
                break;
            }
            case ZEROARGNODE: {
                throw new NotCompilableException("Shouldn't get here; zeroarg does not do assignment: " + node);
            }
            case MULTIPLEASGNNODE: {
                TemporaryVariable tmp = this.createTemporaryVariable();
                this.addInstr(new ToAryInstr(tmp, (Operand)rhsVal));
                this.buildMultipleAsgn19Assignment((MultipleAsgnNode)node, null, tmp);
                break;
            }
            default: {
                throw new NotCompilableException("Can't build assignment node: " + node);
            }
        }
    }

    protected LocalVariable getBlockArgVariable(String name2, int depth) {
        if (!(this.scope instanceof IRFor)) {
            throw new NotCompilableException("Cannot ask for block-arg variable in 1.9 mode");
        }
        return this.getLocalVariable(name2, depth);
    }

    protected void receiveBlockArg(Variable v, Operand argsArray, int argIndex, boolean isSplat) {
        if (argsArray != null) {
            if (isSplat) {
                this.addInstr(new RestArgMultipleAsgnInstr(v, argsArray, argIndex));
            } else {
                this.addInstr(new ReqdArgMultipleAsgnInstr(v, argsArray, argIndex));
            }
        } else {
            this.addInstr(isSplat ? new ReceiveRestArgInstr(v, argIndex, argIndex) : new ReceivePreReqdArgInstr(v, argIndex));
        }
    }

    public void buildVersionSpecificBlockArgsAssignment(Node node) {
        if (!(this.scope instanceof IRFor)) {
            throw new NotCompilableException("Should not have come here for block args assignment in 1.9 mode: " + node);
        }
        switch (node.getNodeType()) {
            case MULTIPLEASGNNODE: {
                ListNode sourceArray = ((MultipleAsgnNode)node).getPre();
                int i2 = 0;
                for (Node an : sourceArray.children()) {
                    this.buildBlockArgsAssignment(an, null, i2, false);
                    ++i2;
                }
                break;
            }
            default: {
                throw new NotCompilableException("Can't build assignment node: " + node);
            }
        }
    }

    public void buildBlockArgsAssignment(Node node, Operand argsArray, int argIndex, boolean isSplat) {
        switch (node.getNodeType()) {
            case ATTRASSIGNNODE: {
                TemporaryVariable v = this.createTemporaryVariable();
                this.receiveBlockArg(v, argsArray, argIndex, isSplat);
                this.buildAttrAssignAssignment(node, v);
                break;
            }
            case DASGNNODE: {
                DAsgnNode dynamicAsgn = (DAsgnNode)node;
                LocalVariable v = this.getBlockArgVariable(dynamicAsgn.getName(), dynamicAsgn.getDepth());
                this.receiveBlockArg(v, argsArray, argIndex, isSplat);
                break;
            }
            case CLASSVARASGNNODE: {
                TemporaryVariable v = this.createTemporaryVariable();
                this.receiveBlockArg(v, argsArray, argIndex, isSplat);
                this.addInstr(new PutClassVariableInstr(this.classVarDefinitionContainer(), ((ClassVarAsgnNode)node).getName(), (Operand)v));
                break;
            }
            case CLASSVARDECLNODE: {
                TemporaryVariable v = this.createTemporaryVariable();
                this.receiveBlockArg(v, argsArray, argIndex, isSplat);
                this.addInstr(new PutClassVariableInstr(this.classVarDeclarationContainer(), ((ClassVarDeclNode)node).getName(), (Operand)v));
                break;
            }
            case CONSTDECLNODE: {
                TemporaryVariable v = this.createTemporaryVariable();
                this.receiveBlockArg(v, argsArray, argIndex, isSplat);
                this.buildConstDeclAssignment((ConstDeclNode)node, v);
                break;
            }
            case GLOBALASGNNODE: {
                TemporaryVariable v = this.createTemporaryVariable();
                this.receiveBlockArg(v, argsArray, argIndex, isSplat);
                this.addInstr(new PutGlobalVarInstr(((GlobalAsgnNode)node).getName(), (Operand)v));
                break;
            }
            case INSTASGNNODE: {
                TemporaryVariable v = this.createTemporaryVariable();
                this.receiveBlockArg(v, argsArray, argIndex, isSplat);
                this.addInstr(new PutFieldInstr(this.buildSelf(), ((InstAsgnNode)node).getName(), (Operand)v));
                break;
            }
            case LOCALASGNNODE: {
                LocalAsgnNode localVariable = (LocalAsgnNode)node;
                int depth = localVariable.getDepth();
                LocalVariable v = this.getBlockArgVariable(localVariable.getName(), depth);
                this.receiveBlockArg(v, argsArray, argIndex, isSplat);
                break;
            }
            case ZEROARGNODE: {
                throw new NotCompilableException("Shouldn't get here; zeroarg does not do assignment: " + node);
            }
            default: {
                this.buildVersionSpecificBlockArgsAssignment(node);
            }
        }
    }

    public Operand buildAlias(AliasNode alias) {
        Operand newName = this.build(alias.getNewName());
        Operand oldName = this.build(alias.getOldName());
        this.addInstr(new AliasInstr(newName, oldName));
        return this.manager.getNil();
    }

    public Operand buildAnd(AndNode andNode) {
        if (andNode.getFirstNode().getNodeType().alwaysTrue()) {
            this.build(andNode.getFirstNode());
            return this.build(andNode.getSecondNode());
        }
        if (andNode.getFirstNode().getNodeType().alwaysFalse()) {
            return this.build(andNode.getFirstNode());
        }
        Label l = this.getNewLabel();
        Operand v1 = this.build(andNode.getFirstNode());
        Variable ret = this.getValueInTemporaryVariable(v1);
        this.addInstr(BEQInstr.create(v1, this.manager.getFalse(), l));
        Operand v2 = this.build(andNode.getSecondNode());
        this.addInstr(new CopyInstr(ret, v2));
        this.addInstr(new LabelInstr(l));
        return ret;
    }

    public Operand buildArray(ArrayNode node, boolean operandOnly) {
        Node[] nodes = node.children();
        Operand[] elts = new Operand[nodes.length];
        boolean containsAssignments = node.containsVariableAssignment();
        for (int i2 = 0; i2 < nodes.length; ++i2) {
            elts[i2] = this.buildWithOrder(nodes[i2], containsAssignments);
        }
        Array array = new Array(elts);
        return operandOnly ? array : this.copyAndReturnValue(array);
    }

    public Operand buildArgsCat(ArgsCatNode argsCatNode) {
        Operand lhs = this.build(argsCatNode.getFirstNode());
        Operand rhs = this.build(argsCatNode.getSecondNode());
        return this.addResultInstr(new BuildCompoundArrayInstr(this.createTemporaryVariable(), lhs, rhs, false));
    }

    public Operand buildArgsPush(ArgsPushNode node) {
        Operand lhs = this.build(node.getFirstNode());
        Operand rhs = this.build(node.getSecondNode());
        return this.addResultInstr(new BuildCompoundArrayInstr(this.createTemporaryVariable(), lhs, rhs, true));
    }

    private Operand buildAttrAssign(AttrAssignNode attrAssignNode) {
        boolean containsAssignment = attrAssignNode.containsVariableAssignment();
        Operand obj = this.buildWithOrder(attrAssignNode.getReceiverNode(), containsAssignment);
        Label lazyLabel = this.getNewLabel();
        Label endLabel = this.getNewLabel();
        TemporaryVariable result2 = this.createTemporaryVariable();
        if (attrAssignNode.isLazy()) {
            this.addInstr(new BNilInstr(lazyLabel, obj));
        }
        ArrayList<Operand> args2 = new ArrayList<Operand>();
        Node argsNode = attrAssignNode.getArgsNode();
        Operand lastArg = this.buildAttrAssignCallArgs(args2, argsNode, containsAssignment);
        this.addInstr(AttrAssignInstr.create(obj, attrAssignNode.getName(), args2.toArray(new Operand[args2.size()]), this.scope.maybeUsingRefinements()));
        this.addInstr(new CopyInstr(result2, lastArg));
        if (attrAssignNode.isLazy()) {
            this.addInstr(new JumpInstr(endLabel));
            this.addInstr(new LabelInstr(lazyLabel));
            this.addInstr(new CopyInstr(result2, this.manager.getNil()));
            this.addInstr(new LabelInstr(endLabel));
        }
        return result2;
    }

    public Operand buildAttrAssignAssignment(Node node, Operand value2) {
        AttrAssignNode attrAssignNode = (AttrAssignNode)node;
        Operand obj = this.build(attrAssignNode.getReceiverNode());
        Operand[] args2 = this.setupCallArgs(attrAssignNode.getArgsNode());
        args2 = IRBuilder.addArg(args2, value2);
        this.addInstr(AttrAssignInstr.create(obj, attrAssignNode.getName(), args2, this.scope.maybeUsingRefinements()));
        return value2;
    }

    public Operand buildBackref(BackRefNode node) {
        return this.addResultInstr(new BuildBackrefInstr(this.createTemporaryVariable(), node.getType()));
    }

    public Operand buildBegin(BeginNode beginNode) {
        return this.build(beginNode.getBodyNode());
    }

    public Operand buildBignum(BignumNode node) {
        return new Bignum(node.getValue());
    }

    public Operand buildBlock(BlockNode node) {
        Operand retVal = null;
        for (Node child : node.children()) {
            retVal = this.build(child);
        }
        return retVal;
    }

    public Operand buildBreak(BreakNode breakNode) {
        IRLoop currLoop = this.getCurrentLoop();
        Operand rv = this.build(breakNode.getValueNode());
        if (currLoop != null) {
            if (!this.activeEnsureBlockStack.empty()) {
                this.emitEnsureBlocks(currLoop);
            }
            this.addInstr(new CopyInstr(currLoop.loopResult, rv));
            this.addInstr(new JumpInstr(currLoop.loopEndLabel));
        } else if (this.scope instanceof IRClosure) {
            IRScope returnScope = this.scope.getLexicalParent();
            if (this.scope instanceof IREvalScript || returnScope == null) {
                this.addInstr(new ThrowExceptionInstr(IRException.BREAK_LocalJumpError));
            } else {
                this.addInstr(new BreakInstr(rv, returnScope.getName()));
            }
        } else {
            this.addInstr(new ThrowExceptionInstr(IRException.BREAK_LocalJumpError));
        }
        return U_NIL;
    }

    private void handleNonlocalReturnInMethod() {
        Label rBeginLabel = this.getNewLabel();
        Label rEndLabel = this.getNewLabel();
        Label gebLabel = this.getNewLabel();
        this.addInstrAtBeginning(new ExceptionRegionStartMarkerInstr(gebLabel));
        this.addInstrAtBeginning(new LabelInstr(rBeginLabel));
        this.addInstr(new ExceptionRegionEndMarkerInstr());
        this.addInstr(new LabelInstr(gebLabel));
        TemporaryVariable exc = this.createTemporaryVariable();
        this.addInstr(new ReceiveJRubyExceptionInstr(exc));
        TemporaryVariable ret = this.createTemporaryVariable();
        this.addInstr(new RuntimeHelperCall(ret, RuntimeHelperCall.Methods.HANDLE_NONLOCAL_RETURN, new Operand[]{exc}));
        this.addInstr(new ReturnInstr(ret));
        this.addInstr(new LabelInstr(rEndLabel));
    }

    private Operand receiveBreakException(Operand block, CodeBlock codeBlock) {
        if (block == null || !(block instanceof WrappedIRClosure) || !((WrappedIRClosure)block).getClosure().flags.contains((Object)IRFlags.HAS_BREAK_INSTRS)) {
            return codeBlock.run();
        }
        Label rBeginLabel = this.getNewLabel();
        Label rEndLabel = this.getNewLabel();
        Label rescueLabel = this.getNewLabel();
        this.addInstr(new LabelInstr(rBeginLabel));
        this.addInstr(new ExceptionRegionStartMarkerInstr(rescueLabel));
        Variable callResult = (Variable)codeBlock.run();
        this.addInstr(new JumpInstr(rEndLabel, true));
        this.addInstr(new ExceptionRegionEndMarkerInstr());
        this.addInstr(new LabelInstr(rescueLabel));
        TemporaryVariable exc = this.createTemporaryVariable();
        this.addInstr(new ReceiveJRubyExceptionInstr(exc));
        this.addInstr(new RuntimeHelperCall(callResult, RuntimeHelperCall.Methods.HANDLE_PROPAGATED_BREAK, new Operand[]{exc}));
        this.addInstr(new LabelInstr(rEndLabel));
        return callResult;
    }

    private void receiveBreakException(Operand block, final CallInstr callInstr) {
        this.receiveBreakException(block, new CodeBlock(){

            @Override
            public Operand run() {
                IRBuilder.this.addInstr(callInstr);
                return callInstr.getResult();
            }
        });
    }

    public Operand buildCall(CallNode callNode) {
        ArrayNode argsAry;
        Node callArgsNode = callNode.getArgsNode();
        Node receiverNode = callNode.getReceiverNode();
        if (receiverNode instanceof StrNode && callNode.getName().equals("freeze")) {
            StrNode asString = (StrNode)receiverNode;
            return new FrozenString(asString.getValue(), asString.getCodeRange(), asString.getPosition().getFile(), asString.getPosition().getLine());
        }
        Operand receiver2 = this.buildWithOrder(receiverNode, callNode.containsVariableAssignment());
        TemporaryVariable callResult = this.createTemporaryVariable();
        if (!callNode.isLazy() && callNode.getName().equals("[]") && callNode.getArgsNode() instanceof ArrayNode && (argsAry = (ArrayNode)callNode.getArgsNode()).size() == 1 && argsAry.get(0) instanceof StrNode && !this.scope.maybeUsingRefinements() && callNode.getIterNode() == null) {
            StrNode keyNode = (StrNode)argsAry.get(0);
            this.addInstr(ArrayDerefInstr.create(callResult, receiver2, new FrozenString(keyNode.getValue(), keyNode.getCodeRange(), keyNode.getPosition().getFile(), keyNode.getLine())));
            return callResult;
        }
        Label lazyLabel = this.getNewLabel();
        Label endLabel = this.getNewLabel();
        if (callNode.isLazy()) {
            this.addInstr(new BNilInstr(lazyLabel, receiver2));
        }
        Operand[] args2 = this.setupCallArgs(callArgsNode);
        Operand block = this.setupCallClosure(callNode.getIterNode());
        CallInstr callInstr = CallInstr.create(this.scope, callResult, callNode.getName(), receiver2, args2, block);
        if (callNode.getName().equals("new") && receiverNode instanceof ConstNode && ((ConstNode)receiverNode).getName().equals("Proc")) {
            callInstr.setProcNew(true);
        }
        this.receiveBreakException(block, callInstr);
        if (callNode.isLazy()) {
            this.addInstr(new JumpInstr(endLabel));
            this.addInstr(new LabelInstr(lazyLabel));
            this.addInstr(new CopyInstr(callResult, this.manager.getNil()));
            this.addInstr(new LabelInstr(endLabel));
        }
        return callResult;
    }

    public Operand buildCase(CaseNode caseNode) {
        Operand value2;
        Enum seenType = null;
        for (Node aCase : caseNode.getCases().children()) {
            WhenNode whenNode = (WhenNode)aCase;
            NodeType exprNodeType = whenNode.getExpressionNodes().getNodeType();
            if (seenType == null) {
                seenType = exprNodeType;
                continue;
            }
            if (seenType == exprNodeType) continue;
            seenType = null;
            break;
        }
        if (seenType != null) {
            switch (10.$SwitchMap$org$jruby$ast$NodeType[seenType.ordinal()]) {
                case 38: {
                    return this.buildFixnumCase(caseNode);
                }
            }
        }
        if ((value2 = this.build(caseNode.getCaseNode())) == null) {
            value2 = UndefinedValue.UNDEFINED;
        }
        Label endLabel = this.getNewLabel();
        boolean hasElse = caseNode.getElseNode() != null;
        Label elseLabel = this.getNewLabel();
        TemporaryVariable result2 = this.createTemporaryVariable();
        ArrayList<Label> labels = new ArrayList<Label>();
        HashMap<Label, Node> bodies = new HashMap<Label, Node>();
        for (Node aCase : caseNode.getCases().children()) {
            Operand v2;
            Operand v1;
            WhenNode whenNode = (WhenNode)aCase;
            Label bodyLabel = this.getNewLabel();
            TemporaryVariable eqqResult = this.createTemporaryVariable();
            labels.add(bodyLabel);
            if (whenNode.getExpressionNodes() instanceof ListNode && !(whenNode.getExpressionNodes() instanceof DNode)) {
                if (value2 == UndefinedValue.UNDEFINED) {
                    v1 = this.build(whenNode.getExpressionNodes());
                    v2 = this.manager.getTrue();
                } else {
                    v1 = value2;
                    v2 = this.build(whenNode.getExpressionNodes());
                }
            } else {
                Operand expression = this.buildWithOrder(whenNode.getExpressionNodes(), whenNode.containsVariableAssignment());
                Node exprNodes = whenNode.getExpressionNodes();
                boolean needsSplat = exprNodes instanceof ArgsPushNode || exprNodes instanceof SplatNode || exprNodes instanceof ArgsCatNode;
                this.addInstr(new EQQInstr(eqqResult, expression, value2, needsSplat));
                v1 = eqqResult;
                v2 = this.manager.getTrue();
            }
            this.addInstr(BEQInstr.create(v1, v2, bodyLabel));
            bodies.put(bodyLabel, whenNode.getBodyNode());
        }
        this.addInstr(new JumpInstr(elseLabel));
        if (hasElse) {
            labels.add(elseLabel);
            bodies.put(elseLabel, caseNode.getElseNode());
        }
        for (Label whenLabel : labels) {
            this.addInstr(new LabelInstr(whenLabel));
            Operand bodyValue = this.build((Node)bodies.get(whenLabel));
            if (bodyValue == null) continue;
            this.addInstr(new CopyInstr(result2, bodyValue));
            this.addInstr(new JumpInstr(endLabel));
        }
        if (!hasElse) {
            this.addInstr(new LabelInstr(elseLabel));
            this.addInstr(new CopyInstr(result2, this.manager.getNil()));
            this.addInstr(new JumpInstr(endLabel));
        }
        this.addInstr(new LabelInstr(endLabel));
        return result2;
    }

    private Operand buildFixnumCase(CaseNode caseNode) {
        HashMap<Integer, Label> jumpTable = new HashMap<Integer, Label>();
        HashMap<Map.Entry[], Label> nodeBodies = new HashMap<Map.Entry[], Label>();
        for (Node aCase : caseNode.getCases().children()) {
            Map.Entry[] whenNode = (Map.Entry[])aCase;
            Label bodyLabel = this.getNewLabel();
            FixnumNode expr = (FixnumNode)whenNode.getExpressionNodes();
            long exprLong = expr.getValue();
            if (exprLong > Integer.MAX_VALUE) {
                throw new NotCompilableException("optimized fixnum case has long-ranged when at " + caseNode.getPosition());
            }
            if (jumpTable.get((int)exprLong) == null) {
                jumpTable.put((int)exprLong, bodyLabel);
            }
            nodeBodies.put(whenNode, bodyLabel);
        }
        Map.Entry[] jumpEntries = jumpTable.entrySet().toArray(new Map.Entry[jumpTable.size()]);
        Arrays.sort(jumpEntries, new Comparator<Map.Entry<Integer, Label>>(){

            @Override
            public int compare(Map.Entry<Integer, Label> o1, Map.Entry<Integer, Label> o2) {
                return Integer.compare(o1.getKey(), o2.getKey());
            }
        });
        int[] jumps = new int[jumpTable.size()];
        Label[] targets = new Label[jumps.length];
        int i2 = 0;
        for (Map.Entry jumpEntry : jumpEntries) {
            jumps[i2] = (Integer)jumpEntry.getKey();
            targets[i2] = (Label)jumpEntry.getValue();
            ++i2;
        }
        Operand value2 = this.build(caseNode.getCaseNode());
        Label eqqPath = this.getNewLabel();
        Label endLabel = this.getNewLabel();
        boolean hasElse = caseNode.getElseNode() != null;
        Label elseLabel = this.getNewLabel();
        TemporaryVariable result2 = this.createTemporaryVariable();
        this.addInstr(new BSwitchInstr(jumps, value2, eqqPath, targets, elseLabel));
        this.addInstr(new LabelInstr(eqqPath));
        ArrayList<Label> labels = new ArrayList<Label>();
        HashMap<Label, Node> bodies = new HashMap<Label, Node>();
        for (Node aCase : caseNode.getCases().children()) {
            Operand v2;
            Operand v1;
            WhenNode whenNode = (WhenNode)aCase;
            Label bodyLabel = (Label)nodeBodies.get(whenNode);
            if (bodyLabel == null) {
                bodyLabel = this.getNewLabel();
            }
            TemporaryVariable eqqResult = this.createTemporaryVariable();
            labels.add(bodyLabel);
            if (whenNode.getExpressionNodes() instanceof ListNode && !(whenNode.getExpressionNodes() instanceof DNode)) {
                if (value2 == UndefinedValue.UNDEFINED) {
                    v1 = this.build(whenNode.getExpressionNodes());
                    v2 = this.manager.getTrue();
                } else {
                    v1 = value2;
                    v2 = this.build(whenNode.getExpressionNodes());
                }
            } else {
                Operand expression = this.build(whenNode.getExpressionNodes());
                if (expression instanceof StringLiteral) {
                    expression = ((StringLiteral)expression).frozenString;
                }
                this.addInstr(new EQQInstr(eqqResult, expression, value2, true));
                v1 = eqqResult;
                v2 = this.manager.getTrue();
            }
            this.addInstr(BEQInstr.create(v1, v2, bodyLabel));
            bodies.put(bodyLabel, whenNode.getBodyNode());
        }
        this.addInstr(new JumpInstr(elseLabel));
        if (hasElse) {
            labels.add(elseLabel);
            bodies.put(elseLabel, caseNode.getElseNode());
        }
        for (Label whenLabel : labels) {
            this.addInstr(new LabelInstr(whenLabel));
            Operand bodyValue = this.build((Node)bodies.get(whenLabel));
            if (bodyValue == null) continue;
            this.addInstr(new CopyInstr(result2, bodyValue));
            this.addInstr(new JumpInstr(endLabel));
        }
        if (!hasElse) {
            this.addInstr(new LabelInstr(elseLabel));
            this.addInstr(new CopyInstr(result2, this.manager.getNil()));
            this.addInstr(new JumpInstr(endLabel));
        }
        this.addInstr(new LabelInstr(endLabel));
        return result2;
    }

    public Operand buildClass(ClassNode classNode) {
        Node superNode = classNode.getSuperNode();
        Colon3Node cpath = classNode.getCPath();
        Operand superClass = superNode == null ? null : this.build(superNode);
        String className = cpath.getName();
        Operand container = this.getContainerFromCPath(cpath);
        IRClassBody body = new IRClassBody(this.manager, this.scope, className, classNode.getLine(), classNode.getScope());
        Variable classVar = this.addResultInstr(new DefineClassInstr(this.createTemporaryVariable(), body, container, superClass));
        Variable processBodyResult = this.addResultInstr(new ProcessModuleBodyInstr(this.createTemporaryVariable(), classVar, NullBlock.INSTANCE));
        this.newIRBuilder(this.manager, body).buildModuleOrClassBody(classNode.getBodyNode(), classNode.getLine());
        return processBodyResult;
    }

    public Operand buildSClass(SClassNode sclassNode) {
        Operand receiver2 = this.build(sclassNode.getReceiverNode());
        IRMetaClassBody body = new IRMetaClassBody(this.manager, this.scope, this.manager.getMetaClassName(), sclassNode.getLine(), sclassNode.getScope());
        Variable sClassVar = this.addResultInstr(new DefineMetaClassInstr(this.createTemporaryVariable(), receiver2, body));
        Variable processBodyResult = this.addResultInstr(new ProcessModuleBodyInstr(this.createTemporaryVariable(), sClassVar, this.scope.getYieldClosureVariable()));
        this.newIRBuilder(this.manager, body).buildModuleOrClassBody(sclassNode.getBodyNode(), sclassNode.getLine());
        return processBodyResult;
    }

    public Operand buildClassVar(ClassVarNode node) {
        TemporaryVariable ret = this.createTemporaryVariable();
        this.addInstr(new GetClassVariableInstr(ret, this.classVarDefinitionContainer(), node.getName()));
        return ret;
    }

    private Variable addResultInstr(ResultInstr instr) {
        this.addInstr((Instr)((Object)instr));
        return instr.getResult();
    }

    public Operand buildClassVarAsgn(ClassVarAsgnNode classVarAsgnNode) {
        Operand val = this.build(classVarAsgnNode.getValueNode());
        this.addInstr(new PutClassVariableInstr(this.classVarDefinitionContainer(), classVarAsgnNode.getName(), val));
        return val;
    }

    public Operand buildClassVarDecl(ClassVarDeclNode classVarDeclNode) {
        Operand val = this.build(classVarDeclNode.getValueNode());
        this.addInstr(new PutClassVariableInstr(this.classVarDeclarationContainer(), classVarDeclNode.getName(), val));
        return val;
    }

    public Operand classVarDeclarationContainer() {
        return this.classVarContainer(true);
    }

    public Operand classVarDefinitionContainer() {
        return this.classVarContainer(false);
    }

    public Operand classVarContainer(boolean declContext) {
        IRScope cvarScope;
        int n = 0;
        for (cvarScope = this.scope; cvarScope != null && !(cvarScope instanceof IREvalScript) && !cvarScope.isNonSingletonClassBody(); cvarScope = cvarScope.getLexicalParent()) {
            if (cvarScope instanceof IRFor) continue;
            ++n;
        }
        if (cvarScope != null && cvarScope.isNonSingletonClassBody()) {
            return ScopeModule.ModuleFor(n);
        }
        return this.addResultInstr(new GetClassVarContainerModuleInstr(this.createTemporaryVariable(), (Operand)this.scope.getCurrentScopeVariable(), declContext ? null : this.buildSelf()));
    }

    public Operand buildConstDecl(ConstDeclNode node) {
        return this.buildConstDeclAssignment(node, this.build(node.getValueNode()));
    }

    private Operand findContainerModule() {
        int nearestModuleBodyDepth = this.scope.getNearestModuleReferencingScopeDepth();
        return nearestModuleBodyDepth == -1 ? this.scope.getCurrentModuleVariable() : ScopeModule.ModuleFor(nearestModuleBodyDepth);
    }

    private Operand startingSearchScope() {
        int nearestModuleBodyDepth = this.scope.getNearestModuleReferencingScopeDepth();
        return nearestModuleBodyDepth == -1 ? this.scope.getCurrentScopeVariable() : CurrentScope.ScopeFor(nearestModuleBodyDepth);
    }

    public Operand buildConstDeclAssignment(ConstDeclNode constDeclNode, Operand value2) {
        Node constNode = constDeclNode.getConstNode();
        if (constNode == null) {
            return this.putConstant(constDeclNode.getName(), value2);
        }
        if (constNode.getNodeType() == NodeType.COLON2NODE) {
            return this.putConstant((Colon2Node)constNode, value2);
        }
        return this.putConstant((Colon3Node)constNode, value2);
    }

    private Operand putConstant(String name2, Operand value2) {
        this.addInstr(new PutConstInstr(this.findContainerModule(), name2, value2));
        return value2;
    }

    private Operand putConstant(Colon3Node node, Operand value2) {
        this.addInstr(new PutConstInstr(new ObjectClass(), node.getName(), value2));
        return value2;
    }

    private Operand putConstant(Colon2Node node, Operand value2) {
        this.addInstr(new PutConstInstr(this.build(node.getLeftNode()), node.getName(), value2));
        return value2;
    }

    private Operand putConstantAssignment(OpAsgnConstDeclNode node, Operand value2) {
        Node constNode = node.getFirstNode();
        if (constNode instanceof Colon2Node) {
            return this.putConstant((Colon2Node)constNode, value2);
        }
        return this.putConstant((Colon3Node)constNode, value2);
    }

    private Operand searchModuleForConst(Operand startingModule, String name2) {
        return this.addResultInstr(new SearchModuleForConstInstr(this.createTemporaryVariable(), startingModule, name2, true));
    }

    private Operand searchConst(String name2) {
        return this.addResultInstr(new SearchConstInstr(this.createTemporaryVariable(), name2, this.startingSearchScope(), false));
    }

    public Operand buildColon2(Colon2Node colon2) {
        Node lhs = colon2.getLeftNode();
        if (lhs == null) {
            return this.searchConst(colon2.getName());
        }
        return this.searchModuleForConst(this.build(lhs), colon2.getName());
    }

    public Operand buildColon3(Colon3Node node) {
        return this.searchModuleForConst(new ObjectClass(), node.getName());
    }

    public Operand buildComplex(ComplexNode node) {
        return new Complex((ImmutableLiteral)this.build(node.getNumber()));
    }

    private Operand protectCodeWithRescue(CodeBlock protectedCode, CodeBlock rescueBlock) {
        TemporaryVariable rv = this.createTemporaryVariable();
        Label rBeginLabel = this.getNewLabel();
        Label rEndLabel = this.getNewLabel();
        Label rescueLabel = this.getNewLabel();
        this.addInstr(new LabelInstr(rBeginLabel));
        this.addInstr(new ExceptionRegionStartMarkerInstr(rescueLabel));
        Operand v1 = protectedCode.run();
        this.addInstr(new CopyInstr(rv, v1));
        this.addInstr(new JumpInstr(rEndLabel, true));
        this.addInstr(new ExceptionRegionEndMarkerInstr());
        Label caughtLabel = this.getNewLabel();
        TemporaryVariable exc = this.createTemporaryVariable();
        TemporaryVariable excType = this.createTemporaryVariable();
        this.addInstr(new LabelInstr(rescueLabel));
        this.addInstr(new ReceiveRubyExceptionInstr(exc));
        this.addInstr(new InheritanceSearchConstInstr(excType, new ObjectClass(), "Exception"));
        this.outputExceptionCheck(excType, exc, caughtLabel);
        this.addInstr(new ThrowExceptionInstr(exc));
        this.addInstr(new LabelInstr(caughtLabel));
        Operand v2 = rescueBlock.run();
        if (v2 != null) {
            this.addInstr(new CopyInstr(rv, this.manager.getNil()));
        }
        this.addInstr(new LabelInstr(rEndLabel));
        return rv;
    }

    public Operand buildGetDefinition(Node node) {
        switch (node.getNodeType()) {
            case CLASSVARASGNNODE: 
            case CLASSVARDECLNODE: 
            case CONSTDECLNODE: 
            case DASGNNODE: 
            case GLOBALASGNNODE: 
            case INSTASGNNODE: 
            case LOCALASGNNODE: 
            case MULTIPLEASGNNODE: 
            case OPASGNANDNODE: 
            case OPASGNNODE: 
            case OPASGNORNODE: 
            case OPELEMENTASGNNODE: {
                return new FrozenString(DefinedMessage.ASSIGNMENT.getText());
            }
            case ANDNODE: 
            case DREGEXPNODE: 
            case DSTRNODE: 
            case ORNODE: {
                return new FrozenString(DefinedMessage.EXPRESSION.getText());
            }
            case FALSENODE: {
                return new FrozenString(DefinedMessage.FALSE.getText());
            }
            case DVARNODE: 
            case LOCALVARNODE: {
                return new FrozenString(DefinedMessage.LOCAL_VARIABLE.getText());
            }
            case MATCH2NODE: 
            case MATCH3NODE: {
                return new FrozenString(DefinedMessage.METHOD.getText());
            }
            case NILNODE: {
                return new FrozenString(DefinedMessage.NIL.getText());
            }
            case SELFNODE: {
                return new FrozenString(DefinedMessage.SELF.getText());
            }
            case TRUENODE: {
                return new FrozenString(DefinedMessage.TRUE.getText());
            }
            case ARRAYNODE: {
                ArrayNode array = (ArrayNode)node;
                Label undefLabel = this.getNewLabel();
                Label doneLabel = this.getNewLabel();
                TemporaryVariable tmpVar = this.createTemporaryVariable();
                for (Node elt : array.children()) {
                    Operand result2 = this.buildGetDefinition(elt);
                    this.addInstr(BEQInstr.create(result2, this.manager.getNil(), undefLabel));
                }
                this.addInstr(new CopyInstr(tmpVar, new FrozenString(DefinedMessage.EXPRESSION.getText())));
                this.addInstr(new JumpInstr(doneLabel));
                this.addInstr(new LabelInstr(undefLabel));
                this.addInstr(new CopyInstr(tmpVar, this.manager.getNil()));
                this.addInstr(new LabelInstr(doneLabel));
                return tmpVar;
            }
            case BACKREFNODE: {
                return this.addResultInstr(new RuntimeHelperCall(this.createTemporaryVariable(), RuntimeHelperCall.Methods.IS_DEFINED_BACKREF, new Operand[]{new FrozenString(DefinedMessage.GLOBAL_VARIABLE.getText())}));
            }
            case GLOBALVARNODE: {
                return this.addResultInstr(new RuntimeHelperCall(this.createTemporaryVariable(), RuntimeHelperCall.Methods.IS_DEFINED_GLOBAL, new Operand[]{new FrozenString(((GlobalVarNode)node).getName()), new FrozenString(DefinedMessage.GLOBAL_VARIABLE.getText())}));
            }
            case NTHREFNODE: {
                return this.addResultInstr(new RuntimeHelperCall(this.createTemporaryVariable(), RuntimeHelperCall.Methods.IS_DEFINED_NTH_REF, new Operand[]{new Fixnum(((NthRefNode)node).getMatchNumber()), new FrozenString(DefinedMessage.GLOBAL_VARIABLE.getText())}));
            }
            case INSTVARNODE: {
                return this.addResultInstr(new RuntimeHelperCall(this.createTemporaryVariable(), RuntimeHelperCall.Methods.IS_DEFINED_INSTANCE_VAR, new Operand[]{this.buildSelf(), new FrozenString(((InstVarNode)node).getName()), new FrozenString(DefinedMessage.INSTANCE_VARIABLE.getText())}));
            }
            case CLASSVARNODE: {
                return this.addResultInstr(new RuntimeHelperCall(this.createTemporaryVariable(), RuntimeHelperCall.Methods.IS_DEFINED_CLASS_VAR, new Operand[]{this.classVarDefinitionContainer(), new FrozenString(((ClassVarNode)node).getName()), new FrozenString(DefinedMessage.CLASS_VARIABLE.getText())}));
            }
            case SUPERNODE: {
                Label undefLabel = this.getNewLabel();
                Variable tmpVar = this.addResultInstr(new RuntimeHelperCall(this.createTemporaryVariable(), RuntimeHelperCall.Methods.IS_DEFINED_SUPER, new Operand[]{this.buildSelf(), new FrozenString(DefinedMessage.SUPER.getText())}));
                this.addInstr(BEQInstr.create(tmpVar, this.manager.getNil(), undefLabel));
                Operand superDefnVal = this.buildGetArgumentDefinition(((SuperNode)node).getArgsNode(), DefinedMessage.SUPER.getText());
                return this.buildDefnCheckIfThenPaths(undefLabel, superDefnVal);
            }
            case VCALLNODE: {
                return this.addResultInstr(new RuntimeHelperCall(this.createTemporaryVariable(), RuntimeHelperCall.Methods.IS_DEFINED_METHOD, new Operand[]{this.buildSelf(), new FrozenString(((VCallNode)node).getName()), this.manager.getFalse(), new FrozenString(DefinedMessage.METHOD.getText())}));
            }
            case YIELDNODE: {
                return this.buildDefinitionCheck(new BlockGivenInstr(this.createTemporaryVariable(), (Operand)this.scope.getYieldClosureVariable()), DefinedMessage.YIELD.getText());
            }
            case ZSUPERNODE: {
                return this.addResultInstr(new RuntimeHelperCall(this.createTemporaryVariable(), RuntimeHelperCall.Methods.IS_DEFINED_SUPER, new Operand[]{this.buildSelf(), new FrozenString(DefinedMessage.SUPER.getText())}));
            }
            case CONSTNODE: {
                Label defLabel = this.getNewLabel();
                Label doneLabel = this.getNewLabel();
                TemporaryVariable tmpVar = this.createTemporaryVariable();
                String constName = ((ConstNode)node).getName();
                this.addInstr(new LexicalSearchConstInstr(tmpVar, this.startingSearchScope(), constName));
                this.addInstr(BNEInstr.create(defLabel, tmpVar, UndefinedValue.UNDEFINED));
                this.addInstr(new InheritanceSearchConstInstr(tmpVar, this.findContainerModule(), constName));
                this.addInstr(BNEInstr.create(defLabel, tmpVar, UndefinedValue.UNDEFINED));
                this.addInstr(new CopyInstr(tmpVar, this.manager.getNil()));
                this.addInstr(new JumpInstr(doneLabel));
                this.addInstr(new LabelInstr(defLabel));
                this.addInstr(new CopyInstr(tmpVar, new FrozenString(DefinedMessage.CONSTANT.getText())));
                this.addInstr(new LabelInstr(doneLabel));
                return tmpVar;
            }
            case COLON2NODE: 
            case COLON3NODE: {
                final Colon3Node colon = (Colon3Node)node;
                final String name2 = colon.getName();
                final TemporaryVariable errInfo = this.createTemporaryVariable();
                this.addInstr(new GetErrorInfoInstr(errInfo));
                CodeBlock protectedCode = new CodeBlock(){

                    @Override
                    public Operand run() {
                        if (!(colon instanceof Colon2Node)) {
                            return IRBuilder.this.addResultInstr(new RuntimeHelperCall(IRBuilder.this.createTemporaryVariable(), RuntimeHelperCall.Methods.IS_DEFINED_CONSTANT_OR_METHOD, new Operand[]{new ObjectClass(), new FrozenString(name2), new FrozenString(DefinedMessage.CONSTANT.getText()), new FrozenString(DefinedMessage.METHOD.getText())}));
                        }
                        Label bad = IRBuilder.this.getNewLabel();
                        Label done = IRBuilder.this.getNewLabel();
                        TemporaryVariable result2 = IRBuilder.this.createTemporaryVariable();
                        Operand test2 = IRBuilder.this.buildGetDefinition(((Colon2Node)colon).getLeftNode());
                        IRBuilder.this.addInstr(BEQInstr.create(test2, IRBuilder.this.manager.getNil(), bad));
                        Operand lhs = IRBuilder.this.build(((Colon2Node)colon).getLeftNode());
                        IRBuilder.this.addInstr(new RuntimeHelperCall(result2, RuntimeHelperCall.Methods.IS_DEFINED_CONSTANT_OR_METHOD, new Operand[]{lhs, new FrozenString(name2), new FrozenString(DefinedMessage.CONSTANT.getText()), new FrozenString(DefinedMessage.METHOD.getText())}));
                        IRBuilder.this.addInstr(new JumpInstr(done));
                        IRBuilder.this.addInstr(new LabelInstr(bad));
                        IRBuilder.this.addInstr(new CopyInstr(result2, IRBuilder.this.manager.getNil()));
                        IRBuilder.this.addInstr(new LabelInstr(done));
                        return result2;
                    }
                };
                CodeBlock rescueBlock = new CodeBlock(){

                    @Override
                    public Operand run() {
                        IRBuilder.this.addInstr(new RestoreErrorInfoInstr(errInfo));
                        return IRBuilder.this.manager.getNil();
                    }
                };
                return this.protectCodeWithRescue(protectedCode, rescueBlock);
            }
            case FCALLNODE: {
                Label undefLabel = this.getNewLabel();
                Variable tmpVar = this.addResultInstr(new RuntimeHelperCall(this.createTemporaryVariable(), RuntimeHelperCall.Methods.IS_DEFINED_METHOD, new Operand[]{this.buildSelf(), new FrozenString(((FCallNode)node).getName()), this.manager.getFalse(), new FrozenString(DefinedMessage.METHOD.getText())}));
                this.addInstr(BEQInstr.create(tmpVar, this.manager.getNil(), undefLabel));
                Operand argsCheckDefn = this.buildGetArgumentDefinition(((FCallNode)node).getArgsNode(), "method");
                return this.buildDefnCheckIfThenPaths(undefLabel, argsCheckDefn);
            }
            case CALLNODE: {
                final CallNode callNode = (CallNode)node;
                CodeBlock protectedCode = new CodeBlock(){

                    @Override
                    public Operand run() {
                        Label undefLabel = IRBuilder.this.getNewLabel();
                        Operand receiverDefn = IRBuilder.this.buildGetDefinition(callNode.getReceiverNode());
                        IRBuilder.this.addInstr(BEQInstr.create(receiverDefn, IRBuilder.this.manager.getNil(), undefLabel));
                        TemporaryVariable tmpVar = IRBuilder.this.createTemporaryVariable();
                        IRBuilder.this.addInstr(new RuntimeHelperCall(tmpVar, RuntimeHelperCall.Methods.IS_DEFINED_CALL, new Operand[]{IRBuilder.this.build(callNode.getReceiverNode()), new StringLiteral(callNode.getName()), new FrozenString(DefinedMessage.METHOD.getText())}));
                        return IRBuilder.this.buildDefnCheckIfThenPaths(undefLabel, tmpVar);
                    }
                };
                CodeBlock rescueBlock = new CodeBlock(){

                    @Override
                    public Operand run() {
                        return IRBuilder.this.manager.getNil();
                    }
                };
                return this.protectCodeWithRescue(protectedCode, rescueBlock);
            }
            case ATTRASSIGNNODE: {
                final AttrAssignNode attrAssign = (AttrAssignNode)node;
                CodeBlock protectedCode = new CodeBlock(){

                    @Override
                    public Operand run() {
                        Label undefLabel = IRBuilder.this.getNewLabel();
                        Operand receiverDefn = IRBuilder.this.buildGetDefinition(attrAssign.getReceiverNode());
                        IRBuilder.this.addInstr(BEQInstr.create(receiverDefn, IRBuilder.this.manager.getNil(), undefLabel));
                        TemporaryVariable tmpVar = IRBuilder.this.createTemporaryVariable();
                        Operand receiver2 = IRBuilder.this.build(attrAssign.getReceiverNode());
                        IRBuilder.this.addInstr(new RuntimeHelperCall(tmpVar, RuntimeHelperCall.Methods.IS_DEFINED_METHOD, new Operand[]{receiver2, new StringLiteral(attrAssign.getName()), IRBuilder.this.manager.getTrue(), new FrozenString(DefinedMessage.METHOD.getText())}));
                        IRBuilder.this.addInstr(BEQInstr.create(tmpVar, IRBuilder.this.manager.getNil(), undefLabel));
                        Operand argsCheckDefn = IRBuilder.this.buildGetArgumentDefinition(attrAssign.getArgsNode(), "assignment");
                        return IRBuilder.this.buildDefnCheckIfThenPaths(undefLabel, argsCheckDefn);
                    }
                };
                CodeBlock rescueBlock = new CodeBlock(){

                    @Override
                    public Operand run() {
                        return IRBuilder.this.manager.getNil();
                    }
                };
                return this.protectCodeWithRescue(protectedCode, rescueBlock);
            }
        }
        return new FrozenString("expression");
    }

    protected Variable buildDefnCheckIfThenPaths(Label undefLabel, Operand defVal) {
        Label defLabel = this.getNewLabel();
        Variable tmpVar = this.getValueInTemporaryVariable(defVal);
        this.addInstr(new JumpInstr(defLabel));
        this.addInstr(new LabelInstr(undefLabel));
        this.addInstr(new CopyInstr(tmpVar, this.manager.getNil()));
        this.addInstr(new LabelInstr(defLabel));
        return tmpVar;
    }

    protected Variable buildDefinitionCheck(ResultInstr definedInstr, String definedReturnValue) {
        Label undefLabel = this.getNewLabel();
        this.addInstr((Instr)((Object)definedInstr));
        this.addInstr(BEQInstr.create(definedInstr.getResult(), this.manager.getFalse(), undefLabel));
        return this.buildDefnCheckIfThenPaths(undefLabel, new FrozenString(definedReturnValue));
    }

    public Operand buildGetArgumentDefinition(Node node, String type2) {
        if (node == null) {
            return new StringLiteral(type2);
        }
        ImmutableLiteral rv = new FrozenString(type2);
        boolean failPathReqd = false;
        Label failLabel = this.getNewLabel();
        if (node instanceof ArrayNode) {
            for (int i2 = 0; i2 < ((ArrayNode)node).size(); ++i2) {
                Node iterNode = ((ArrayNode)node).get(i2);
                Operand def = this.buildGetDefinition(iterNode);
                if (def == this.manager.getNil()) {
                    rv = this.manager.getNil();
                    break;
                }
                if (def.hasKnownValue()) continue;
                failPathReqd = true;
                this.addInstr(BEQInstr.create(def, this.manager.getNil(), failLabel));
            }
        } else {
            Operand def = this.buildGetDefinition(node);
            if (def == this.manager.getNil()) {
                rv = this.manager.getNil();
            } else if (!def.hasKnownValue()) {
                failPathReqd = true;
                this.addInstr(BEQInstr.create(def, this.manager.getNil(), failLabel));
            }
        }
        return failPathReqd ? this.buildDefnCheckIfThenPaths(failLabel, rv) : rv;
    }

    public Operand buildDAsgn(DAsgnNode dasgnNode) {
        Operand value2;
        int depth = dasgnNode.getDepth();
        LocalVariable arg2 = this.getLocalVariable(dasgnNode.getName(), depth);
        if (arg2 == (value2 = this.build(dasgnNode.getValueNode()))) {
            return value2;
        }
        this.addInstr(new CopyInstr(arg2, value2));
        return value2;
    }

    protected InterpreterContext defineMethodInner(DefNode defNode, IRScope parent, boolean needsCodeCoverage) {
        ArgumentDescriptor[] argDesc;
        this.needsCodeCoverage = needsCodeCoverage;
        if (RubyInstanceConfig.FULL_TRACE_ENABLED) {
            this.addInstr(this.manager.newLineNumber(this.scope.getLineNumber()));
            this.addInstr(new TraceInstr(RubyEvent.CALL, this.getName(), this.getFileName(), this.scope.getLineNumber()));
        }
        this.prepareImplicitState();
        int nearestScopeDepth = parent.getNearestModuleReferencingScopeDepth();
        this.addInstr(new CopyInstr(this.scope.getCurrentScopeVariable(), CurrentScope.ScopeFor(nearestScopeDepth == -1 ? 1 : nearestScopeDepth)));
        this.addInstr(new CopyInstr(this.scope.getCurrentModuleVariable(), ScopeModule.ModuleFor(nearestScopeDepth == -1 ? 1 : nearestScopeDepth)));
        this.receiveMethodArgs(defNode.getArgsNode());
        Operand rv = this.build(defNode.getBodyNode());
        if (RubyInstanceConfig.FULL_TRACE_ENABLED) {
            this.addInstr(new LineNumberInstr(defNode.getEndLine()));
            this.addInstr(new TraceInstr(RubyEvent.RETURN, this.getName(), this.getFileName(), defNode.getEndLine()));
        }
        if (rv != null) {
            this.addInstr(new ReturnInstr(rv));
        }
        this.scope.computeScopeFlagsEarly(this.instructions);
        if (this.scope.canReceiveNonlocalReturns()) {
            this.handleNonlocalReturnInMethod();
        }
        if (this.argumentDescriptions == null) {
            argDesc = NO_ARG_DESCS;
        } else {
            argDesc = new ArgumentDescriptor[this.argumentDescriptions.size() / 2];
            int i2 = 0;
            while (i2 < this.argumentDescriptions.size()) {
                argDesc[i2 / 2] = new ArgumentDescriptor(ArgumentType.valueOf(this.argumentDescriptions.get(i2++)), this.argumentDescriptions.get(i2++));
            }
        }
        ((IRMethod)this.scope).setArgumentDescriptors(argDesc);
        return this.scope.allocateInterpreterContext(this.instructions);
    }

    private IRMethod defineNewMethod(MethodDefNode defNode, boolean isInstanceMethod) {
        return new IRMethod(this.manager, this.scope, defNode, defNode.getName(), isInstanceMethod, defNode.getLine(), defNode.getScope(), this.needsCodeCoverage());
    }

    public Operand buildDefn(MethodDefNode node) {
        IRMethod method = this.defineNewMethod(node, true);
        this.addInstr(new DefineInstanceMethodInstr(method));
        return new Symbol(method.getName(), (Encoding)ASCIIEncoding.INSTANCE);
    }

    public Operand buildDefs(DefsNode node) {
        Operand container = this.build(node.getReceiverNode());
        IRMethod method = this.defineNewMethod(node, false);
        this.addInstr(new DefineClassMethodInstr(container, method));
        return new Symbol(method.getName(), (Encoding)ASCIIEncoding.INSTANCE);
    }

    protected LocalVariable getArgVariable(String name2, int depth) {
        return this.scope instanceof IRFor ? this.getLocalVariable(name2, depth) : this.getNewLocalVariable(name2, 0);
    }

    private void addArgReceiveInstr(Variable v, int argIndex, Signature signature) {
        boolean post;
        boolean bl = post = signature != null;
        if (post) {
            this.addInstr(new ReceivePostReqdArgInstr(v, argIndex, signature.pre(), signature.opt(), signature.hasRest(), signature.post()));
        } else {
            this.addInstr(new ReceivePreReqdArgInstr(v, argIndex));
        }
    }

    private Variable argumentResult(String name2) {
        boolean isUnderscore = name2.equals("_");
        if (isUnderscore && this.underscoreVariableSeen) {
            return this.createTemporaryVariable();
        }
        if (isUnderscore) {
            this.underscoreVariableSeen = true;
        }
        return this.getNewLocalVariable(name2, 0);
    }

    public void receiveRequiredArg(Node node, int argIndex, Signature signature) {
        switch (node.getNodeType()) {
            case ARGUMENTNODE: {
                String argName = ((ArgumentNode)node).getName();
                if (this.scope instanceof IRMethod) {
                    this.addArgumentDescription(ArgumentType.req, argName);
                }
                this.addArgReceiveInstr(this.argumentResult(argName), argIndex, signature);
                break;
            }
            case MULTIPLEASGNNODE: {
                MultipleAsgnNode childNode = (MultipleAsgnNode)node;
                TemporaryVariable v = this.createTemporaryVariable();
                this.addArgReceiveInstr(v, argIndex, signature);
                if (this.scope instanceof IRMethod) {
                    this.addArgumentDescription(ArgumentType.anonreq, null);
                }
                TemporaryVariable tmp = this.createTemporaryVariable();
                this.addInstr(new ToAryInstr(tmp, (Operand)v));
                this.buildMultipleAsgn19Assignment(childNode, tmp, null);
                break;
            }
            default: {
                throw new NotCompilableException("Can't build assignment node: " + node);
            }
        }
    }

    protected void receiveNonBlockArgs(ArgsNode argsNode) {
        int opt;
        Signature signature = this.scope.getStaticScope().getSignature();
        if (this.scope instanceof IRMethod) {
            this.addInstr(new CheckArityInstr(signature.required(), signature.opt(), signature.hasRest(), argsNode.hasKwargs(), signature.keyRest()));
        } else if (this.scope instanceof IRClosure && argsNode.hasKwargs()) {
            this.addInstr(new CheckArityInstr(signature.required(), signature.opt(), signature.hasRest(), argsNode.hasKwargs(), signature.keyRest()));
        }
        int argIndex = 0;
        Node[] args2 = argsNode.getArgs();
        int preCount = signature.pre();
        int i2 = 0;
        while (i2 < preCount) {
            this.receiveRequiredArg(args2[i2], argIndex, null);
            ++i2;
            ++argIndex;
        }
        int n = opt = signature.opt() > 0 ? signature.opt() : 0;
        if (opt > 0) {
            int optIndex = argsNode.getOptArgIndex();
            int j = 0;
            while (j < opt) {
                Label variableAssigned = this.getNewLabel();
                OptArgNode optArg = (OptArgNode)args2[optIndex + j];
                String argName = optArg.getName();
                Variable argVar = this.argumentResult(argName);
                if (this.scope instanceof IRMethod) {
                    this.addArgumentDescription(ArgumentType.opt, argName);
                }
                this.addInstr(new ReceiveOptArgInstr(argVar, signature.required(), signature.pre(), j));
                this.addInstr(BNEInstr.create(variableAssigned, argVar, UndefinedValue.UNDEFINED));
                this.addInstr(new CopyInstr(argVar, this.manager.getNil()));
                this.build(optArg.getValue());
                this.addInstr(new LabelInstr(variableAssigned));
                ++j;
                ++argIndex;
            }
        }
        if (signature.hasRest()) {
            String argName = argsNode.getRestArgNode().getName();
            if (this.scope instanceof IRMethod) {
                this.addArgumentDescription(argName == null || argName.length() == 0 ? ArgumentType.anonrest : ArgumentType.rest, argName);
            }
            argName = argName == null || argName.equals("") ? "*" : argName;
            this.addInstr(new ReceiveRestArgInstr(this.argumentResult(argName), signature.required() + opt, argIndex));
        }
        int postCount = argsNode.getPostCount();
        int postIndex = argsNode.getPostIndex();
        for (int i3 = 0; i3 < postCount; ++i3) {
            this.receiveRequiredArg(args2[postIndex + i3], i3, signature);
        }
    }

    protected void receiveBlockArg(ArgsNode argsNode) {
        BlockArgNode blockArg = argsNode.getBlock();
        if (blockArg != null) {
            String argName = blockArg.getName();
            Variable blockVar = this.argumentResult(argName);
            if (this.scope instanceof IRMethod) {
                this.addArgumentDescription(ArgumentType.block, argName);
            }
            TemporaryVariable tmp = this.createTemporaryVariable();
            this.addInstr(new LoadImplicitClosureInstr(tmp));
            this.addInstr(new ReifyClosureInstr(blockVar, (Variable)tmp));
        }
    }

    private void prepareImplicitState() {
        this.addInstr(this.manager.getReceiveSelfInstr());
        if (this.scope instanceof IRMethod || this.scope instanceof IRMetaClassBody) {
            this.addInstr(new LoadImplicitClosureInstr(this.scope.getYieldClosureVariable()));
        } else {
            this.addInstr(new LoadFrameClosureInstr(this.scope.getYieldClosureVariable()));
        }
    }

    public void receiveArgs(ArgsNode argsNode) {
        KeywordRestArgNode keyRest;
        this.receiveNonBlockArgs(argsNode);
        Node[] args2 = argsNode.getArgs();
        int required = argsNode.getRequiredArgsCount();
        if (argsNode.hasKwargs()) {
            int keywordIndex = argsNode.getKeywordsIndex();
            int keywordsCount = argsNode.getKeywordCount();
            for (int i2 = 0; i2 < keywordsCount; ++i2) {
                KeywordArgNode kwarg = (KeywordArgNode)args2[keywordIndex + i2];
                AssignableNode kasgn = kwarg.getAssignable();
                String argName = ((INameNode)((Object)kasgn)).getName();
                LocalVariable av = this.getNewLocalVariable(argName, 0);
                Label l = this.getNewLabel();
                if (this.scope instanceof IRMethod) {
                    this.addKeyArgDesc(kasgn, argName);
                }
                this.addInstr(new ReceiveKeywordArgInstr(av, argName, required));
                this.addInstr(BNEInstr.create(l, av, UndefinedValue.UNDEFINED));
                if (!this.isRequiredKeywordArgumentValue(kasgn)) {
                    this.addInstr(new CopyInstr(av, this.buildNil()));
                    this.build(kasgn);
                } else {
                    this.addInstr(new RaiseRequiredKeywordArgumentError(argName));
                }
                this.addInstr(new LabelInstr(l));
            }
        }
        if ((keyRest = argsNode.getKeyRest()) != null) {
            String argName = keyRest.getName();
            ArgumentType type2 = ArgumentType.keyrest;
            if (argName == null || argName.length() == 0) {
                type2 = ArgumentType.anonkeyrest;
            }
            LocalVariable av = this.getNewLocalVariable(argName, 0);
            if (this.scope instanceof IRMethod) {
                this.addArgumentDescription(type2, argName);
            }
            this.addInstr(new ReceiveKeywordRestArgInstr(av, required));
        }
        this.receiveBlockArg(argsNode);
    }

    private void addKeyArgDesc(AssignableNode kasgn, String argName) {
        if (this.isRequiredKeywordArgumentValue(kasgn)) {
            this.addArgumentDescription(ArgumentType.keyreq, argName);
        } else {
            this.addArgumentDescription(ArgumentType.key, argName);
        }
    }

    private boolean isRequiredKeywordArgumentValue(AssignableNode kasgn) {
        return kasgn.getValueNode().getNodeType() == NodeType.REQUIRED_KEYWORD_ARGUMENT_VALUE;
    }

    public void buildArgsMasgn(Node node, Operand argsArray, boolean isMasgnRoot, int preArgsCount, int postArgsCount, int index2, boolean isSplat) {
        switch (node.getNodeType()) {
            case DASGNNODE: {
                DAsgnNode dynamicAsgn = (DAsgnNode)node;
                LocalVariable v = this.getArgVariable(dynamicAsgn.getName(), dynamicAsgn.getDepth());
                if (isSplat) {
                    this.addInstr(new RestArgMultipleAsgnInstr(v, argsArray, preArgsCount, postArgsCount, index2));
                    break;
                }
                this.addInstr(new ReqdArgMultipleAsgnInstr(v, argsArray, preArgsCount, postArgsCount, index2));
                break;
            }
            case LOCALASGNNODE: {
                LocalAsgnNode localVariable = (LocalAsgnNode)node;
                LocalVariable v = this.getArgVariable(localVariable.getName(), localVariable.getDepth());
                if (isSplat) {
                    this.addInstr(new RestArgMultipleAsgnInstr(v, argsArray, preArgsCount, postArgsCount, index2));
                    break;
                }
                this.addInstr(new ReqdArgMultipleAsgnInstr(v, argsArray, preArgsCount, postArgsCount, index2));
                break;
            }
            case MULTIPLEASGNNODE: {
                MultipleAsgnNode childNode = (MultipleAsgnNode)node;
                if (!isMasgnRoot) {
                    TemporaryVariable v = this.createTemporaryVariable();
                    if (isSplat) {
                        this.addInstr(new RestArgMultipleAsgnInstr(v, argsArray, preArgsCount, postArgsCount, index2));
                    } else {
                        this.addInstr(new ReqdArgMultipleAsgnInstr(v, argsArray, preArgsCount, postArgsCount, index2));
                    }
                    TemporaryVariable tmp = this.createTemporaryVariable();
                    this.addInstr(new ToAryInstr(tmp, (Operand)v));
                    argsArray = tmp;
                }
                this.buildMultipleAsgn19Assignment(childNode, argsArray, null);
                break;
            }
            default: {
                throw new NotCompilableException("Shouldn't get here: " + node);
            }
        }
    }

    public void buildMultipleAsgn19Assignment(MultipleAsgnNode multipleAsgnNode, Operand argsArray, Operand values2) {
        ListNode masgnPost;
        ListNode masgnPre = multipleAsgnNode.getPre();
        ArrayList<Tuple<Node, TemporaryVariable>> assigns = new ArrayList<Tuple<Node, TemporaryVariable>>();
        int i2 = 0;
        if (masgnPre != null) {
            for (Node an : masgnPre.children()) {
                if (values2 == null) {
                    this.buildArgsMasgn(an, argsArray, false, -1, -1, i2, false);
                } else {
                    TemporaryVariable temporaryVariable = this.createTemporaryVariable();
                    this.addInstr(new ReqdArgMultipleAsgnInstr(temporaryVariable, values2, i2));
                    assigns.add(new Tuple<Node, TemporaryVariable>(an, temporaryVariable));
                }
                ++i2;
            }
        }
        Node restNode = multipleAsgnNode.getRest();
        int postArgsCount = multipleAsgnNode.getPostCount();
        if (restNode != null && !(restNode instanceof StarNode)) {
            if (values2 == null) {
                this.buildArgsMasgn(restNode, argsArray, false, i2, postArgsCount, 0, true);
            } else {
                TemporaryVariable rhsVal = this.createTemporaryVariable();
                this.addInstr(new RestArgMultipleAsgnInstr(rhsVal, values2, i2, postArgsCount, 0));
                assigns.add(new Tuple<Node, TemporaryVariable>(restNode, rhsVal));
            }
        }
        if ((masgnPost = multipleAsgnNode.getPost()) != null) {
            int j = 0;
            for (Node an : masgnPost.children()) {
                if (values2 == null) {
                    this.buildArgsMasgn(an, argsArray, false, i2, postArgsCount, j, false);
                } else {
                    TemporaryVariable rhsVal = this.createTemporaryVariable();
                    this.addInstr(new ReqdArgMultipleAsgnInstr(rhsVal, values2, i2, postArgsCount, j));
                    assigns.add(new Tuple<Node, TemporaryVariable>(an, rhsVal));
                }
                ++j;
            }
        }
        for (Tuple tuple : assigns) {
            this.buildAssignment((Node)tuple.a, (Variable)tuple.b);
        }
    }

    private void handleBreakAndReturnsInLambdas() {
        Label rEndLabel = this.getNewLabel();
        Label rescueLabel = Label.getGlobalEnsureBlockLabel();
        this.addInstrAtBeginning(new ExceptionRegionStartMarkerInstr(rescueLabel));
        this.addInstr(new ExceptionRegionEndMarkerInstr());
        this.addInstr(new LabelInstr(rescueLabel));
        TemporaryVariable exc = this.createTemporaryVariable();
        this.addInstr(new ReceiveJRubyExceptionInstr(exc));
        TemporaryVariable ret = this.createTemporaryVariable();
        this.addInstr(new RuntimeHelperCall(ret, RuntimeHelperCall.Methods.HANDLE_BREAK_AND_RETURNS_IN_LAMBDA, new Operand[]{exc}));
        this.addInstr(new ReturnOrRethrowSavedExcInstr(ret));
        this.addInstr(new LabelInstr(rEndLabel));
    }

    public void receiveMethodArgs(ArgsNode argsNode) {
        this.receiveArgs(argsNode);
    }

    public void receiveBlockArgs(IterNode node) {
        Node args2 = node.getVarNode();
        if (args2 instanceof ArgsNode) {
            ((IRClosure)this.scope).setArgumentDescriptors(Helpers.argsNodeToArgumentDescriptors((ArgsNode)args2));
            this.receiveArgs((ArgsNode)args2);
        } else {
            this.buildBlockArgsAssignment(args2, null, 0, false);
        }
    }

    public Operand buildDot(DotNode dotNode) {
        return this.addResultInstr(new BuildRangeInstr(this.createTemporaryVariable(), this.build(dotNode.getBeginNode()), this.build(dotNode.getEndNode()), dotNode.isExclusive()));
    }

    private Operand dynamicPiece(Node pieceNode) {
        Operand piece;
        Operand operand = piece = pieceNode instanceof StrNode ? this.buildStrRaw((StrNode)pieceNode) : this.build(pieceNode);
        if (piece instanceof StringLiteral) {
            piece = ((StringLiteral)piece).frozenString;
        }
        return piece == null ? this.manager.getNil() : piece;
    }

    public Operand buildDRegexp(DRegexpNode node) {
        Node[] nodePieces = node.children();
        Operand[] pieces = new Operand[nodePieces.length];
        for (int i2 = 0; i2 < pieces.length; ++i2) {
            pieces[i2] = this.dynamicPiece(nodePieces[i2]);
        }
        TemporaryVariable res = this.createTemporaryVariable();
        this.addInstr(new BuildDynRegExpInstr(res, pieces, node.getOptions()));
        return res;
    }

    public Operand buildDStr(DStrNode node) {
        Node[] nodePieces = node.children();
        Operand[] pieces = new Operand[nodePieces.length];
        for (int i2 = 0; i2 < pieces.length; ++i2) {
            pieces[i2] = this.dynamicPiece(nodePieces[i2]);
        }
        TemporaryVariable res = this.createTemporaryVariable();
        this.addInstr(new BuildCompoundStringInstr(res, pieces, node.getEncoding(), node.isFrozen(), this.getFileName(), node.getLine()));
        return res;
    }

    public Operand buildDSymbol(DSymbolNode node) {
        Node[] nodePieces = node.children();
        Operand[] pieces = new Operand[nodePieces.length];
        for (int i2 = 0; i2 < pieces.length; ++i2) {
            pieces[i2] = this.dynamicPiece(nodePieces[i2]);
        }
        TemporaryVariable res = this.createTemporaryVariable();
        this.addInstr(new BuildCompoundStringInstr(res, pieces, node.getEncoding(), false, this.getFileName(), node.getLine()));
        return this.copyAndReturnValue(new DynamicSymbol(res));
    }

    public Operand buildDVar(DVarNode node) {
        return this.getLocalVariable(node.getName(), node.getDepth());
    }

    public Operand buildDXStr(DXStrNode dstrNode) {
        Node[] nodePieces = dstrNode.children();
        Operand[] pieces = new Operand[nodePieces.length];
        for (int i2 = 0; i2 < pieces.length; ++i2) {
            pieces[i2] = this.dynamicPiece(nodePieces[i2]);
        }
        return this.addResultInstr(new BacktickInstr(this.createTemporaryVariable(), pieces));
    }

    public Operand buildEnsureNode(EnsureNode ensureNode) {
        return this.buildEnsureInternal(ensureNode.getBodyNode(), ensureNode.getEnsureNode());
    }

    public Operand buildEnsureInternal(Node ensureBodyNode, Node ensurerNode) {
        boolean isEnsureExpr;
        TemporaryVariable savedGlobalException = this.createTemporaryVariable();
        this.addInstr(new GetGlobalVariableInstr((Variable)savedGlobalException, "$!"));
        EnsureBlockInfo ebi = new EnsureBlockInfo(this.scope, ensureBodyNode instanceof RescueNode ? (RescueNode)ensureBodyNode : null, this.getCurrentLoop(), this.activeRescuers.peek());
        if (ensureBodyNode != null && ensureBodyNode instanceof RescueNode) {
            ebi.savedGlobalException = savedGlobalException;
        }
        this.ensureBodyBuildStack.push(ebi);
        Operand ensureRetVal = ensurerNode == null ? this.manager.getNil() : this.build(ensurerNode);
        this.ensureBodyBuildStack.pop();
        this.activeEnsureBlockStack.push(ebi);
        this.addInstr(new LabelInstr(ebi.regionStart));
        this.addInstr(new ExceptionRegionStartMarkerInstr(ebi.dummyRescueBlockLabel));
        this.activeRescuers.push(ebi.dummyRescueBlockLabel);
        TemporaryVariable ensureExprValue = this.createTemporaryVariable();
        Operand rv = ensureBodyNode instanceof RescueNode ? this.buildRescueInternal((RescueNode)ensureBodyNode, ebi) : this.build(ensureBodyNode);
        this.addInstr(new ExceptionRegionEndMarkerInstr());
        this.activeRescuers.pop();
        boolean bl = isEnsureExpr = ensurerNode != null && rv != U_NIL && !(ensureBodyNode instanceof RescueNode);
        if (isEnsureExpr) {
            this.addInstr(new CopyInstr(ensureExprValue, rv));
            ebi.cloneIntoHostScope(this);
            this.addInstr(new JumpInstr(ebi.end));
        }
        this.activeEnsureBlockStack.pop();
        TemporaryVariable exc = this.createTemporaryVariable();
        this.addInstr(new LabelInstr(ebi.dummyRescueBlockLabel));
        this.addInstr(new ReceiveJRubyExceptionInstr(exc));
        TemporaryVariable ret = this.createTemporaryVariable();
        this.addInstr(new RuntimeHelperCall(ret, RuntimeHelperCall.Methods.RESTORE_EXCEPTION_VAR, new Operand[]{exc, savedGlobalException}));
        if (ensurerNode != null) {
            ebi.emitBody(this);
        }
        if (ensureRetVal == U_NIL) {
            rv = U_NIL;
        }
        this.addInstr(new ThrowExceptionInstr(exc));
        this.addInstr(new LabelInstr(ebi.end));
        return isEnsureExpr ? ensureExprValue : rv;
    }

    public Operand buildEvStr(EvStrNode node) {
        return new AsString(this.build(node.getBody()));
    }

    public Operand buildFalse() {
        return this.manager.getFalse();
    }

    public Operand buildFCall(FCallNode fcallNode) {
        IRClosure closure;
        Node callArgsNode = fcallNode.getArgsNode();
        Operand[] args2 = this.setupCallArgs(callArgsNode);
        Operand block = this.setupCallClosure(fcallNode.getIterNode());
        TemporaryVariable callResult = this.createTemporaryVariable();
        this.determineIfMaybeUsingMethod(fcallNode.getName(), args2);
        if (fcallNode.getName().equals("define_method") && block instanceof WrappedIRClosure && !(closure = ((WrappedIRClosure)block).getClosure()).getFlags().contains((Object)IRFlags.ACCESS_PARENTS_LOCAL_VARIABLES) && fcallNode.getIterNode() instanceof IterNode) {
            closure.setSource((IterNode)fcallNode.getIterNode());
        }
        CallInstr callInstr = CallInstr.create(this.scope, CallType.FUNCTIONAL, callResult, fcallNode.getName(), this.buildSelf(), args2, block);
        this.receiveBreakException(block, callInstr);
        return callResult;
    }

    private Operand setupCallClosure(Node node) {
        if (node == null) {
            return null;
        }
        switch (node.getNodeType()) {
            case ITERNODE: {
                return this.build(node);
            }
            case BLOCKPASSNODE: {
                Node bodyNode = ((BlockPassNode)node).getBodyNode();
                if (bodyNode instanceof SymbolNode) {
                    return new SymbolProc(((SymbolNode)bodyNode).getName(), ((SymbolNode)bodyNode).getEncoding());
                }
                return this.build(bodyNode);
            }
        }
        throw new NotCompilableException("ERROR: Encountered a method with a non-block, non-blockpass iter node at: " + node);
    }

    private void determineIfMaybeUsingMethod(String methodName, Operand[] args2) {
        IRScope outerScope = this.scope.getNearestTopLocalVariableScope();
        if (USING_METHOD.equals(methodName) && !(outerScope instanceof IRMethod) && args2.length == 1) {
            this.scope.setIsMaybeUsingRefinements();
        }
    }

    public Operand buildFixnum(FixnumNode node) {
        return new Fixnum(node.getValue());
    }

    public Operand buildFlip(FlipNode flipNode) {
        Fixnum s1 = new Fixnum(1L);
        Fixnum s2 = new Fixnum(2L);
        IRBuilder nearestNonClosureBuilder = this.getNearestFlipVariableScopeBuilder();
        if (nearestNonClosureBuilder == null) {
            TemporaryVariable excType = this.createTemporaryVariable();
            this.addInstr(new InheritanceSearchConstInstr(excType, new ObjectClass(), "NotImplementedError"));
            Variable exc = this.addResultInstr(CallInstr.create(this.scope, this.createTemporaryVariable(), "new", excType, new Operand[]{new FrozenString("Flip support currently broken")}, null));
            this.addInstr(new ThrowExceptionInstr(exc));
            return this.buildNil();
        }
        LocalVariable flipState = nearestNonClosureBuilder.scope.getNewFlipStateVariable();
        nearestNonClosureBuilder.initFlipStateVariable(flipState, s1);
        if (this.scope instanceof IRClosure) {
            int n = 0;
            IRScope x = this.scope;
            while (!x.isFlipScope()) {
                ++n;
                x = x.getLexicalParent();
            }
            if (n > 0) {
                flipState = flipState.cloneForDepth(n);
            }
        }
        TemporaryVariable returnVal = this.createTemporaryVariable();
        Label s2Label = this.getNewLabel();
        Label doneLabel = this.getNewLabel();
        this.addInstr(new CopyInstr(returnVal, this.manager.getFalse()));
        this.addInstr(BNEInstr.create(s2Label, flipState, s1));
        Operand s1Val = this.build(flipNode.getBeginNode());
        this.addInstr(BNEInstr.create(s2Label, s1Val, this.manager.getTrue()));
        this.addInstr(new CopyInstr(returnVal, this.manager.getTrue()));
        this.addInstr(new CopyInstr(flipState, s2));
        this.addInstr(new LabelInstr(s2Label));
        if (flipNode.isExclusive()) {
            this.addInstr(BEQInstr.create(returnVal, this.manager.getTrue(), doneLabel));
        }
        this.addInstr(BNEInstr.create(doneLabel, flipState, s2));
        Operand s2Val = this.build(flipNode.getEndNode());
        this.addInstr(new CopyInstr(returnVal, this.manager.getTrue()));
        this.addInstr(BNEInstr.create(doneLabel, s2Val, this.manager.getTrue()));
        this.addInstr(new CopyInstr(flipState, s1));
        this.addInstr(new LabelInstr(doneLabel));
        return returnVal;
    }

    public Operand buildFloat(FloatNode node) {
        return new Float(node.getValue());
    }

    public Operand buildFor(ForNode forNode) {
        TemporaryVariable result2 = this.createTemporaryVariable();
        Operand receiver2 = this.build(forNode.getIterNode());
        Operand forBlock = this.buildForIter(forNode);
        CallInstr callInstr = new CallInstr(CallType.NORMAL, result2, "each", receiver2, NO_ARGS, forBlock, this.scope.maybeUsingRefinements());
        this.receiveBreakException(forBlock, callInstr);
        return result2;
    }

    private InterpreterContext buildForIterInner(ForNode forNode) {
        Operand closureRetVal;
        this.prepareImplicitState();
        Node varNode = forNode.getVarNode();
        if (varNode != null && varNode.getNodeType() != null) {
            this.receiveBlockArgs(forNode);
        }
        this.addCurrentScopeAndModule();
        this.addInstr(new LabelInstr(((IRClosure)this.scope).startLabel));
        Operand operand = closureRetVal = forNode.getBodyNode() == null ? this.manager.getNil() : this.build(forNode.getBodyNode());
        if (closureRetVal != U_NIL) {
            this.addInstr(new ReturnInstr(closureRetVal));
        }
        return this.scope.allocateInterpreterContext(this.instructions);
    }

    public Operand buildForIter(ForNode forNode) {
        IRFor closure = new IRFor(this.manager, this.scope, forNode.getLine(), forNode.getScope(), Signature.from(forNode));
        this.newIRBuilder(this.manager, closure).buildForIterInner(forNode);
        return new WrappedIRClosure(this.buildSelf(), closure);
    }

    public Operand buildGlobalAsgn(GlobalAsgnNode globalAsgnNode) {
        Operand value2 = this.build(globalAsgnNode.getValueNode());
        this.addInstr(new PutGlobalVarInstr(globalAsgnNode.getName(), value2));
        return value2;
    }

    public Operand buildGlobalVar(GlobalVarNode node) {
        return this.addResultInstr(new GetGlobalVariableInstr((Variable)this.createTemporaryVariable(), node.getName()));
    }

    public Operand buildHash(HashNode hashNode) {
        ArrayList<KeyValuePair<Operand, Operand>> args2 = new ArrayList<KeyValuePair<Operand, Operand>>();
        boolean hasAssignments = hashNode.containsVariableAssignment();
        Variable hash2 = null;
        for (KeyValuePair<Node, Node> pair : hashNode.getPairs()) {
            Node key2 = pair.getKey();
            if (key2 == null) {
                if (hash2 == null) {
                    hash2 = this.copyAndReturnValue(new Hash(args2));
                    args2 = new ArrayList();
                } else if (!args2.isEmpty()) {
                    this.addInstr(new RuntimeHelperCall(hash2, RuntimeHelperCall.Methods.MERGE_KWARGS, new Operand[]{hash2, new Hash(args2)}));
                    args2 = new ArrayList();
                }
                Operand splat = this.buildWithOrder(pair.getValue(), hasAssignments);
                this.addInstr(new RuntimeHelperCall(hash2, RuntimeHelperCall.Methods.MERGE_KWARGS, new Operand[]{hash2, splat}));
                continue;
            }
            Operand keyOperand = this.buildWithOrder(key2, hasAssignments);
            args2.add(new KeyValuePair<Operand, Operand>(keyOperand, this.buildWithOrder(pair.getValue(), hasAssignments)));
        }
        if (hash2 == null) {
            hash2 = this.copyAndReturnValue(new Hash(args2));
        } else if (!args2.isEmpty()) {
            this.addInstr(new RuntimeHelperCall(hash2, RuntimeHelperCall.Methods.MERGE_KWARGS, new Operand[]{hash2, new Hash(args2)}));
        }
        return hash2;
    }

    public Operand buildIf(IfNode ifNode) {
        Variable result2;
        Node actualCondition = ifNode.getCondition();
        Label falseLabel = this.getNewLabel();
        Label doneLabel = this.getNewLabel();
        this.addInstr(BEQInstr.create(this.build(actualCondition), this.manager.getFalse(), falseLabel));
        boolean thenNull = false;
        boolean elseNull = false;
        boolean thenUnil = false;
        boolean elseUnil = false;
        if (ifNode.getThenBody() != null) {
            Operand thenResult = this.build(ifNode.getThenBody());
            if (thenResult != U_NIL) {
                result2 = this.getValueInTemporaryVariable(thenResult);
                this.addInstr(new JumpInstr(doneLabel));
            } else {
                result2 = this.createTemporaryVariable();
                thenUnil = true;
            }
        } else {
            thenNull = true;
            result2 = this.addResultInstr(new CopyInstr(this.createTemporaryVariable(), this.manager.getNil()));
            this.addInstr(new JumpInstr(doneLabel));
        }
        this.addInstr(new LabelInstr(falseLabel));
        if (ifNode.getElseBody() != null) {
            Operand elseResult = this.build(ifNode.getElseBody());
            if (elseResult != U_NIL) {
                this.addInstr(new CopyInstr(result2, elseResult));
            } else {
                elseUnil = true;
            }
        } else {
            elseNull = true;
            this.addInstr(new CopyInstr(result2, this.manager.getNil()));
        }
        if (thenNull && elseNull) {
            this.addInstr(new LabelInstr(doneLabel));
            return this.manager.getNil();
        }
        if (thenUnil && elseUnil) {
            return U_NIL;
        }
        this.addInstr(new LabelInstr(doneLabel));
        return result2;
    }

    public Operand buildInstAsgn(InstAsgnNode instAsgnNode) {
        Operand val = this.build(instAsgnNode.getValueNode());
        this.addInstr(new PutFieldInstr(this.buildSelf(), instAsgnNode.getName(), val));
        return val;
    }

    public Operand buildInstVar(InstVarNode node) {
        return this.addResultInstr(new GetFieldInstr(this.createTemporaryVariable(), (Operand)this.buildSelf(), node.getName()));
    }

    private InterpreterContext buildIterInner(IterNode iterNode) {
        Operand closureRetVal;
        this.prepareImplicitState();
        this.addCurrentScopeAndModule();
        if (iterNode.getVarNode().getNodeType() != null) {
            this.receiveBlockArgs(iterNode);
        }
        this.addInstr(new LabelInstr(((IRClosure)this.scope).startLabel));
        Operand operand = closureRetVal = iterNode.getBodyNode() == null ? this.manager.getNil() : this.build(iterNode.getBodyNode());
        if (closureRetVal != U_NIL) {
            this.addInstr(new ReturnInstr(closureRetVal));
        }
        this.handleBreakAndReturnsInLambdas();
        return this.scope.allocateInterpreterContext(this.instructions);
    }

    public Operand buildIter(IterNode iterNode) {
        IRClosure closure = new IRClosure(this.manager, this.scope, iterNode.getLine(), iterNode.getScope(), Signature.from(iterNode), this.needsCodeCoverage);
        this.newIRBuilder(this.manager, closure).buildIterInner(iterNode);
        return new WrappedIRClosure(this.buildSelf(), closure);
    }

    public Operand buildLiteral(LiteralNode literalNode) {
        return this.copyAndReturnValue(new StringLiteral(literalNode.getName()));
    }

    public Operand buildLocalAsgn(LocalAsgnNode localAsgnNode) {
        Operand value2;
        LocalVariable var = this.getLocalVariable(localAsgnNode.getName(), localAsgnNode.getDepth());
        if (var == (value2 = this.build(localAsgnNode.getValueNode()))) {
            return value2;
        }
        this.addInstr(new CopyInstr(var, value2));
        return value2;
    }

    public Operand buildLocalVar(LocalVarNode node) {
        return this.getLocalVariable(node.getName(), node.getDepth());
    }

    public Operand buildMatch(MatchNode matchNode) {
        Operand regexp2 = this.build(matchNode.getRegexpNode());
        TemporaryVariable tempLastLine = this.createTemporaryVariable();
        this.addResultInstr(new GetGlobalVariableInstr((Variable)tempLastLine, "$_"));
        return this.addResultInstr(new MatchInstr(this.createTemporaryVariable(), regexp2, tempLastLine));
    }

    public Operand buildMatch2(Match2Node matchNode) {
        Operand receiver2 = this.build(matchNode.getReceiverNode());
        Operand value2 = this.build(matchNode.getValueNode());
        TemporaryVariable result2 = this.createTemporaryVariable();
        this.addInstr(new MatchInstr(result2, receiver2, value2));
        if (matchNode instanceof Match2CaptureNode) {
            Match2CaptureNode m2c = (Match2CaptureNode)matchNode;
            for (int slot : m2c.getScopeOffsets()) {
                int depth = slot >> 16;
                int offset2 = slot & 0xFFFF;
                String var = this.getVarNameFromScopeTree(this.scope, depth, offset2);
                this.addInstr(new SetCapturedVarInstr(this.getLocalVariable(var, depth), (Operand)result2, var));
            }
        }
        return result2;
    }

    private String getVarNameFromScopeTree(IRScope scope, int depth, int offset2) {
        if (depth == 0) {
            return scope.getStaticScope().getVariables()[offset2];
        }
        return this.getVarNameFromScopeTree(scope.getLexicalParent(), depth - 1, offset2);
    }

    public Operand buildMatch3(Match3Node matchNode) {
        Operand receiver2 = this.build(matchNode.getReceiverNode());
        Operand value2 = this.build(matchNode.getValueNode());
        return this.addResultInstr(new MatchInstr(this.createTemporaryVariable(), receiver2, value2));
    }

    private Operand getContainerFromCPath(Colon3Node cpath) {
        Node leftNode;
        Operand container = cpath instanceof Colon2Node ? ((leftNode = ((Colon2Node)cpath).getLeftNode()) != null ? this.build(leftNode) : this.findContainerModule()) : new ObjectClass();
        return container;
    }

    public Operand buildModule(ModuleNode moduleNode) {
        Colon3Node cpath = moduleNode.getCPath();
        String moduleName = cpath.getName();
        Operand container = this.getContainerFromCPath(cpath);
        IRModuleBody body = new IRModuleBody(this.manager, this.scope, moduleName, moduleNode.getLine(), moduleNode.getScope());
        Variable moduleVar = this.addResultInstr(new DefineModuleInstr(this.createTemporaryVariable(), body, container));
        Variable processBodyResult = this.addResultInstr(new ProcessModuleBodyInstr(this.createTemporaryVariable(), moduleVar, NullBlock.INSTANCE));
        this.newIRBuilder(this.manager, body).buildModuleOrClassBody(moduleNode.getBodyNode(), moduleNode.getLine());
        return processBodyResult;
    }

    public Operand buildNext(NextNode nextNode) {
        IRLoop currLoop = this.getCurrentLoop();
        Operand rv = this.build(nextNode.getValueNode());
        if (!this.activeEnsureBlockStack.empty()) {
            this.emitEnsureBlocks(currLoop);
        }
        if (currLoop != null) {
            this.addInstr(new JumpInstr(currLoop.iterEndLabel));
        } else {
            this.addInstr(new ThreadPollInstr(true));
            if (this.scope instanceof IRClosure) {
                this.addInstr(new ReturnInstr(rv));
            } else {
                this.addInstr(new ThrowExceptionInstr(IRException.NEXT_LocalJumpError));
            }
        }
        return U_NIL;
    }

    public Operand buildNthRef(NthRefNode nthRefNode) {
        return this.copyAndReturnValue(new NthRef(nthRefNode.getMatchNumber()));
    }

    public Operand buildNil() {
        return this.manager.getNil();
    }

    public Operand buildOpAsgn(OpAsgnNode opAsgnNode) {
        TemporaryVariable readerValue = this.createTemporaryVariable();
        TemporaryVariable writerValue = this.createTemporaryVariable();
        Node receiver2 = opAsgnNode.getReceiverNode();
        CallType callType = receiver2 instanceof SelfNode ? CallType.FUNCTIONAL : CallType.NORMAL;
        Operand v1 = this.build(opAsgnNode.getReceiverNode());
        Label lazyLabel = this.getNewLabel();
        Label endLabel = this.getNewLabel();
        TemporaryVariable result2 = this.createTemporaryVariable();
        if (opAsgnNode.isLazy()) {
            this.addInstr(new BNilInstr(lazyLabel, v1));
        }
        this.addInstr(CallInstr.create(this.scope, callType, readerValue, opAsgnNode.getVariableName(), v1, NO_ARGS, null));
        String opName = opAsgnNode.getOperatorName();
        if (opName.equals("||") || opName.equals("&&")) {
            Label l = this.getNewLabel();
            this.addInstr(BEQInstr.create(readerValue, opName.equals("||") ? this.manager.getTrue() : this.manager.getFalse(), l));
            Operand v2 = this.build(opAsgnNode.getValueNode());
            this.addInstr(CallInstr.create(this.scope, callType, writerValue, opAsgnNode.getVariableNameAsgn(), v1, new Operand[]{v2}, null));
            this.addInstr(new CopyInstr(readerValue, v2));
            this.addInstr(new LabelInstr(l));
            if (!opAsgnNode.isLazy()) {
                return readerValue;
            }
            this.addInstr(new CopyInstr(result2, (Operand)readerValue));
        } else {
            Operand v2 = this.build(opAsgnNode.getValueNode());
            TemporaryVariable setValue2 = this.createTemporaryVariable();
            this.addInstr(CallInstr.create(this.scope, setValue2, opAsgnNode.getOperatorName(), readerValue, new Operand[]{v2}, null));
            this.addInstr(CallInstr.create(this.scope, callType, writerValue, opAsgnNode.getVariableNameAsgn(), v1, new Operand[]{setValue2}, null));
            if (!opAsgnNode.isLazy()) {
                return setValue2;
            }
            this.addInstr(new CopyInstr(result2, (Operand)setValue2));
        }
        this.addInstr(new JumpInstr(endLabel));
        this.addInstr(new LabelInstr(lazyLabel));
        this.addInstr(new CopyInstr(result2, this.manager.getNil()));
        this.addInstr(new LabelInstr(endLabel));
        return result2;
    }

    public Operand buildOpAsgnConstDeclNode(OpAsgnConstDeclNode node) {
        String op = node.getOperator();
        if ("||".equals(op)) {
            TemporaryVariable result2 = this.createTemporaryVariable();
            Label isDefined = this.getNewLabel();
            Label done = this.getNewLabel();
            TemporaryVariable defined = this.createTemporaryVariable();
            this.addInstr(new CopyInstr(defined, this.buildGetDefinition(node.getFirstNode())));
            this.addInstr(BNEInstr.create(isDefined, defined, this.manager.getNil()));
            this.addInstr(new CopyInstr(result2, this.putConstantAssignment(node, this.build(node.getSecondNode()))));
            this.addInstr(new JumpInstr(done));
            this.addInstr(new LabelInstr(isDefined));
            this.addInstr(new CopyInstr(result2, this.build(node.getFirstNode())));
            this.addInstr(new LabelInstr(done));
            return result2;
        }
        if ("&&".equals(op)) {
            this.build(node.getFirstNode());
            return this.addResultInstr(new CopyInstr(this.createTemporaryVariable(), this.putConstantAssignment(node, this.build(node.getSecondNode()))));
        }
        TemporaryVariable result3 = this.createTemporaryVariable();
        Operand lhs = this.build(node.getFirstNode());
        Operand rhs = this.build(node.getSecondNode());
        this.addInstr(CallInstr.create(this.scope, result3, node.getOperator(), lhs, new Operand[]{rhs}, null));
        return this.addResultInstr(new CopyInstr(this.createTemporaryVariable(), this.putConstantAssignment(node, result3)));
    }

    public Operand buildOpAsgnAnd(OpAsgnAndNode andNode) {
        Label l = this.getNewLabel();
        Operand v1 = this.build(andNode.getFirstNode());
        Variable result2 = this.getValueInTemporaryVariable(v1);
        this.addInstr(BEQInstr.create(v1, this.manager.getFalse(), l));
        Operand v2 = this.build(andNode.getSecondNode());
        this.addInstr(new CopyInstr(result2, v2));
        this.addInstr(new LabelInstr(l));
        return result2;
    }

    public Operand buildOpAsgnOr(OpAsgnOrNode orNode) {
        Operand v1;
        Label l1 = this.getNewLabel();
        Label l2 = null;
        TemporaryVariable flag = this.createTemporaryVariable();
        boolean needsDefnCheck = orNode.getFirstNode().needsDefinitionCheck();
        if (needsDefnCheck) {
            l2 = this.getNewLabel();
            v1 = this.buildGetDefinition(orNode.getFirstNode());
            this.addInstr(new CopyInstr(flag, v1));
            this.addInstr(BEQInstr.create(flag, this.manager.getNil(), l2));
        }
        v1 = this.build(orNode.getFirstNode());
        this.addInstr(new CopyInstr(flag, v1));
        Variable result2 = this.getValueInTemporaryVariable(v1);
        if (needsDefnCheck) {
            this.addInstr(new LabelInstr(l2));
        }
        this.addInstr(BEQInstr.create(flag, this.manager.getTrue(), l1));
        Operand v2 = this.build(orNode.getSecondNode());
        this.addInstr(new CopyInstr(result2, v2));
        this.addInstr(new LabelInstr(l1));
        return result2;
    }

    public Operand buildOpElementAsgn(OpElementAsgnNode node) {
        if (node.isOr()) {
            return this.buildOpElementAsgnWith(node, this.manager.getTrue());
        }
        if (node.isAnd()) {
            return this.buildOpElementAsgnWith(node, this.manager.getFalse());
        }
        return this.buildOpElementAsgnWithMethod(node);
    }

    private Operand buildOpElementAsgnWith(OpElementAsgnNode opElementAsgnNode, Boolean truthy) {
        Node receiver2 = opElementAsgnNode.getReceiverNode();
        CallType callType = receiver2 instanceof SelfNode ? CallType.FUNCTIONAL : CallType.NORMAL;
        Operand array = this.buildWithOrder(receiver2, opElementAsgnNode.containsVariableAssignment());
        Label endLabel = this.getNewLabel();
        TemporaryVariable elt = this.createTemporaryVariable();
        Operand[] argList = this.setupCallArgs(opElementAsgnNode.getArgsNode());
        this.addInstr(CallInstr.create(this.scope, callType, elt, "[]", array, argList, null));
        this.addInstr(BEQInstr.create(elt, truthy, endLabel));
        Operand value2 = this.build(opElementAsgnNode.getValueNode());
        argList = IRBuilder.addArg(argList, value2);
        this.addInstr(CallInstr.create(this.scope, callType, elt, "[]=", array, argList, null));
        this.addInstr(new CopyInstr(elt, value2));
        this.addInstr(new LabelInstr(endLabel));
        return elt;
    }

    public Operand buildOpElementAsgnWithMethod(OpElementAsgnNode opElementAsgnNode) {
        Node receiver2 = opElementAsgnNode.getReceiverNode();
        CallType callType = receiver2 instanceof SelfNode ? CallType.FUNCTIONAL : CallType.NORMAL;
        Operand array = this.buildWithOrder(receiver2, opElementAsgnNode.containsVariableAssignment());
        Operand[] argList = this.setupCallArgs(opElementAsgnNode.getArgsNode());
        TemporaryVariable elt = this.createTemporaryVariable();
        this.addInstr(CallInstr.create(this.scope, callType, elt, "[]", array, argList, null));
        Operand value2 = this.build(opElementAsgnNode.getValueNode());
        String operation = opElementAsgnNode.getOperatorName();
        this.addInstr(CallInstr.create(this.scope, callType, elt, operation, elt, new Operand[]{value2}, null));
        TemporaryVariable tmp = this.createTemporaryVariable();
        argList = IRBuilder.addArg(argList, elt);
        this.addInstr(CallInstr.create(this.scope, callType, tmp, "[]=", array, argList, null));
        return elt;
    }

    public Operand buildOr(OrNode orNode) {
        if (orNode.getFirstNode().getNodeType().alwaysTrue()) {
            return this.build(orNode.getFirstNode());
        }
        if (orNode.getFirstNode().getNodeType().alwaysFalse()) {
            this.build(orNode.getFirstNode());
            return this.build(orNode.getSecondNode());
        }
        Label endOfExprLabel = this.getNewLabel();
        Operand left2 = this.build(orNode.getFirstNode());
        Variable result2 = this.getValueInTemporaryVariable(left2);
        this.addInstr(BEQInstr.create(left2, this.manager.getTrue(), endOfExprLabel));
        Operand right = this.build(orNode.getSecondNode());
        this.addInstr(new CopyInstr(result2, right));
        this.addInstr(new LabelInstr(endOfExprLabel));
        return result2;
    }

    private InterpreterContext buildPrePostExeInner(Node body) {
        this.addInstr(new CopyInstr(this.scope.getCurrentScopeVariable(), CurrentScope.CURRENT_SCOPE[0]));
        this.addInstr(new CopyInstr(this.scope.getCurrentModuleVariable(), ScopeModule.SCOPE_MODULE[0]));
        this.build(body);
        this.addInstr(new ReturnInstr(new Nil()));
        return this.scope.allocateInterpreterContext(this.instructions);
    }

    public Operand buildPostExe(PostExeNode postExeNode) {
        IRScope topLevel = this.scope.getTopLevelScope();
        IRScope nearestLVarScope = this.scope.getNearestTopLocalVariableScope();
        IRClosure endClosure = new IRClosure(this.manager, this.scope, postExeNode.getLine(), nearestLVarScope.getStaticScope(), Signature.from(postExeNode), "_END_", true);
        this.newIRBuilder(this.manager, endClosure).buildPrePostExeInner(postExeNode.getBodyNode());
        this.addInstr(new RecordEndBlockInstr(topLevel, new WrappedIRClosure(this.buildSelf(), endClosure)));
        return this.manager.getNil();
    }

    public Operand buildPreExe(PreExeNode preExeNode) {
        IRScope topLevel = this.scope.getTopLevelScope();
        IRFor beginClosure = new IRFor(this.manager, this.scope, preExeNode.getLine(), topLevel.getStaticScope(), Signature.from(preExeNode), "_BEGIN_");
        this.newIRBuilder(this.manager, beginClosure).buildPrePostExeInner(preExeNode.getBodyNode());
        topLevel.recordBeginBlock(beginClosure);
        return this.manager.getNil();
    }

    public Operand buildRational(RationalNode rationalNode) {
        return new Rational(rationalNode.getNumerator(), rationalNode.getDenominator());
    }

    public Operand buildRedo() {
        IRLoop currLoop;
        if (!this.activeEnsureBlockStack.empty()) {
            this.emitEnsureBlocks(this.getCurrentLoop());
        }
        if ((currLoop = this.getCurrentLoop()) != null) {
            this.addInstr(new JumpInstr(currLoop.iterStartLabel));
        } else if (this.scope instanceof IRClosure) {
            this.addInstr(new ThreadPollInstr(true));
            this.addInstr(new JumpInstr(((IRClosure)this.scope).startLabel));
        } else {
            this.addInstr(new ThrowExceptionInstr(IRException.REDO_LocalJumpError));
        }
        return this.manager.getNil();
    }

    public Operand buildRegexp(RegexpNode reNode) {
        return this.copyAndReturnValue(new Regexp(reNode.getValue(), reNode.getOptions()));
    }

    public Operand buildRescue(RescueNode node) {
        return this.buildEnsureInternal(node, null);
    }

    private boolean canBacktraceBeRemoved(RescueNode rescueNode) {
        if (RubyInstanceConfig.FULL_TRACE_ENABLED || !(rescueNode instanceof RescueModNode) && rescueNode.getElseNode() != null) {
            return false;
        }
        Node body = rescueNode.getRescueNode().getBodyNode();
        if (body instanceof GlobalVarNode && ((GlobalVarNode)body).getName().equals("$!")) {
            return false;
        }
        return body instanceof SideEffectFree;
    }

    private Operand buildRescueInternal(RescueNode rescueNode, EnsureBlockInfo ensure) {
        boolean needsBacktrace = !this.canBacktraceBeRemoved(rescueNode);
        Label rBeginLabel = this.getNewLabel();
        Label rEndLabel = ensure.end;
        Label rescueLabel = this.getNewLabel();
        ensure.needsBacktrace = needsBacktrace;
        this.addInstr(new LabelInstr(rBeginLabel));
        this.addInstr(new ExceptionRegionStartMarkerInstr(rescueLabel));
        this.activeRescuers.push(rescueLabel);
        this.addInstr(this.manager.needsBacktrace(needsBacktrace));
        Operand tmp = this.manager.getNil();
        TemporaryVariable rv = this.createTemporaryVariable();
        if (rescueNode.getBodyNode() != null) {
            tmp = this.build(rescueNode.getBodyNode());
        }
        RescueBlockInfo rbi = new RescueBlockInfo(rBeginLabel, ensure.savedGlobalException);
        this.activeRescueBlockStack.push(rbi);
        this.addInstr(new ExceptionRegionEndMarkerInstr());
        this.activeRescuers.pop();
        if (rescueNode.getElseNode() != null) {
            this.addInstr(new LabelInstr(this.getNewLabel()));
            tmp = this.build(rescueNode.getElseNode());
        }
        if (tmp != U_NIL) {
            this.addInstr(new CopyInstr(rv, tmp));
            ensure.cloneIntoHostScope(this);
            this.addInstr(new JumpInstr(rEndLabel, true));
        }
        this.addInstr(new LabelInstr(rescueLabel));
        if (!needsBacktrace) {
            this.addInstr(this.manager.needsBacktrace(true));
        }
        Variable exc = this.addResultInstr(new ReceiveRubyExceptionInstr(this.createTemporaryVariable()));
        this.buildRescueBodyInternal(rescueNode.getRescueNode(), rv, exc, rEndLabel);
        this.activeRescueBlockStack.pop();
        return rv;
    }

    private void outputExceptionCheck(Operand excType, Operand excObj, Label caughtLabel) {
        Variable eqqResult = this.addResultInstr(new RescueEQQInstr(this.createTemporaryVariable(), excType, excObj));
        this.addInstr(BEQInstr.create(eqqResult, this.manager.getTrue(), caughtLabel));
    }

    private void buildRescueBodyInternal(RescueBodyNode rescueBodyNode, Variable rv, Variable exc, Label endLabel) {
        Node exceptionList = rescueBodyNode.getExceptionNodes();
        Label uncaughtLabel = this.getNewLabel();
        Label caughtLabel = this.getNewLabel();
        if (exceptionList != null) {
            if (exceptionList instanceof ListNode) {
                Node[] exceptionNodes = ((ListNode)exceptionList).children();
                Operand[] exceptionTypes = new Operand[exceptionNodes.length];
                for (int i2 = 0; i2 < exceptionNodes.length; ++i2) {
                    exceptionTypes[i2] = this.build(exceptionNodes[i2]);
                }
                this.outputExceptionCheck(new Array(exceptionTypes), exc, caughtLabel);
            } else if (exceptionList instanceof SplatNode) {
                this.outputExceptionCheck(this.build(((SplatNode)exceptionList).getValue()), exc, caughtLabel);
            } else {
                this.outputExceptionCheck(this.build(exceptionList), exc, caughtLabel);
            }
        } else {
            this.outputExceptionCheck(this.manager.getStandardError(), exc, caughtLabel);
        }
        this.addInstr(new LabelInstr(uncaughtLabel));
        if (rescueBodyNode.getOptRescueNode() != null) {
            this.buildRescueBodyInternal(rescueBodyNode.getOptRescueNode(), rv, exc, endLabel);
        } else {
            this.addInstr(new ThrowExceptionInstr(exc));
        }
        this.addInstr(new LabelInstr(caughtLabel));
        Node realBody = rescueBodyNode.getBodyNode();
        Operand x = this.build(realBody);
        if (x != U_NIL) {
            this.addInstr(new CopyInstr(rv, x));
            this.activeEnsureBlockStack.peek().cloneIntoHostScope(this);
            this.addInstr(new JumpInstr(endLabel, true));
        }
    }

    public Operand buildRetry() {
        if (this.activeRescueBlockStack.empty()) {
            this.addInstr(new ThrowExceptionInstr(IRException.RETRY_LocalJumpError));
        } else {
            this.addInstr(new ThreadPollInstr(true));
            RescueBlockInfo rbi = this.activeRescueBlockStack.peek();
            this.addInstr(new PutGlobalVarInstr("$!", (Operand)rbi.savedExceptionVariable));
            this.addInstr(new JumpInstr(rbi.entryLabel));
            this.scope.setHasLoopsFlag();
        }
        return this.manager.getNil();
    }

    private Operand processEnsureRescueBlocks(Operand retVal) {
        if (!this.activeEnsureBlockStack.empty()) {
            retVal = this.addResultInstr(new CopyInstr(this.createTemporaryVariable(), retVal));
            this.emitEnsureBlocks(null);
        }
        return retVal;
    }

    public Operand buildReturn(ReturnNode returnNode) {
        Operand retVal = this.build(returnNode.getValueNode());
        if (this.scope instanceof IRClosure) {
            boolean maybeLambda = this.scope.getNearestMethod() == null;
            this.addInstr(new CheckForLJEInstr(maybeLambda));
            this.addInstr(new NonlocalReturnInstr(retVal, maybeLambda ? "--none--" : this.scope.getNearestMethod().getName()));
        } else if (this.scope.isModuleBody()) {
            IRMethod sm = this.scope.getNearestMethod();
            if (sm == null) {
                this.addInstr(new ThrowExceptionInstr(IRException.RETURN_LocalJumpError));
            }
            if (sm != null) {
                this.addInstr(new NonlocalReturnInstr(retVal, sm.getName()));
            }
        } else {
            retVal = this.processEnsureRescueBlocks(retVal);
            if (RubyInstanceConfig.FULL_TRACE_ENABLED) {
                this.addInstr(new TraceInstr(RubyEvent.RETURN, this.getName(), this.getFileName(), returnNode.getLine()));
            }
            this.addInstr(new ReturnInstr(retVal));
        }
        return U_NIL;
    }

    public InterpreterContext buildEvalRoot(RootNode rootNode) {
        this.needsCodeCoverage = false;
        this.addInstr(this.manager.newLineNumber(this.scope.getLineNumber()));
        this.prepareImplicitState();
        this.addCurrentScopeAndModule();
        Operand returnValue = rootNode.getBodyNode() == null ? this.manager.getNil() : this.build(rootNode.getBodyNode());
        this.addInstr(new ReturnInstr(returnValue));
        return this.scope.allocateInterpreterContext(this.instructions);
    }

    public static InterpreterContext buildRoot(IRManager manager, RootNode rootNode) {
        IRScriptBody script = new IRScriptBody(manager, rootNode.getFile(), rootNode.getStaticScope());
        return IRBuilder.topIRBuilder(manager, script).buildRootInner(rootNode);
    }

    private void addCurrentScopeAndModule() {
        this.addInstr(new CopyInstr(this.scope.getCurrentScopeVariable(), CurrentScope.CURRENT_SCOPE[0]));
        this.addInstr(new CopyInstr(this.scope.getCurrentModuleVariable(), ScopeModule.SCOPE_MODULE[0]));
    }

    private InterpreterContext buildRootInner(RootNode rootNode) {
        this.needsCodeCoverage = rootNode.needsCoverage();
        this.prepareImplicitState();
        this.addCurrentScopeAndModule();
        this.addInstr(new ReturnInstr(this.build(rootNode.getBodyNode())));
        return this.scope.allocateInterpreterContext(this.instructions);
    }

    public Variable buildSelf() {
        return this.scope.getSelf();
    }

    public Operand buildSplat(SplatNode splatNode) {
        return this.addResultInstr(new BuildSplatInstr(this.createTemporaryVariable(), this.build(splatNode.getValue()), true));
    }

    public Operand buildStr(StrNode strNode) {
        Operand literal = this.buildStrRaw(strNode);
        return literal instanceof FrozenString ? literal : this.copyAndReturnValue(literal);
    }

    public Operand buildStrRaw(StrNode strNode) {
        if (strNode instanceof FileNode) {
            return new Filename();
        }
        ISourcePosition pos2 = strNode.getPosition();
        if (strNode.isFrozen()) {
            return new FrozenString(strNode.getValue(), strNode.getCodeRange(), pos2.getFile(), pos2.getLine());
        }
        return new StringLiteral(strNode.getValue(), strNode.getCodeRange(), pos2.getFile(), pos2.getLine());
    }

    private Operand buildSuperInstr(Operand block, Operand[] args2) {
        TemporaryVariable ret = this.createTemporaryVariable();
        CallInstr superInstr = this.scope instanceof IRMethod && this.scope.getLexicalParent() instanceof IRClassBody ? (((IRMethod)this.scope).isInstanceMethod ? new InstanceSuperInstr(ret, this.scope.getCurrentModuleVariable(), this.getName(), args2, block, this.scope.maybeUsingRefinements()) : new ClassSuperInstr(ret, this.scope.getCurrentModuleVariable(), this.getName(), args2, block, this.scope.maybeUsingRefinements())) : new UnresolvedSuperInstr(ret, this.buildSelf(), args2, block, this.scope.maybeUsingRefinements());
        this.receiveBreakException(block, superInstr);
        return ret;
    }

    public Operand buildSuper(SuperNode superNode) {
        if (this.scope.isModuleBody()) {
            return this.buildSuperInScriptBody();
        }
        Operand[] args2 = this.setupCallArgs(superNode.getArgsNode());
        Operand block = this.setupCallClosure(superNode.getIterNode());
        if (block == null) {
            block = this.scope.getYieldClosureVariable();
        }
        return this.buildSuperInstr(block, args2);
    }

    private Operand buildSuperInScriptBody() {
        return this.addResultInstr(new UnresolvedSuperInstr(this.createTemporaryVariable(), this.buildSelf(), NO_ARGS, null, this.scope.maybeUsingRefinements()));
    }

    public Operand buildSValue(SValueNode node) {
        return this.copyAndReturnValue(new SValue(this.build(node.getValue())));
    }

    public Operand buildSymbol(SymbolNode node) {
        return new Symbol(node.getName(), node.getEncoding());
    }

    public Operand buildTrue() {
        return this.manager.getTrue();
    }

    public Operand buildUndef(Node node) {
        Operand methName = this.build(((UndefNode)node).getName());
        return this.addResultInstr(new UndefMethodInstr(this.createTemporaryVariable(), methName));
    }

    private Operand buildConditionalLoop(Node conditionNode, Node bodyNode, boolean isWhile, boolean isLoopHeadCondition) {
        Operand cv;
        if (isLoopHeadCondition && (isWhile && conditionNode.getNodeType().alwaysFalse() || !isWhile && conditionNode.getNodeType().alwaysTrue())) {
            this.build(conditionNode);
            return this.manager.getNil();
        }
        IRLoop loop2 = new IRLoop(this.scope, this.getCurrentLoop());
        Variable loopResult = loop2.loopResult;
        Label setupResultLabel = this.getNewLabel();
        this.loopStack.push(loop2);
        this.addInstr(new LabelInstr(loop2.loopStartLabel));
        if (isLoopHeadCondition) {
            cv = this.build(conditionNode);
            this.addInstr(BEQInstr.create(cv, isWhile ? this.manager.getFalse() : this.manager.getTrue(), setupResultLabel));
        }
        this.addInstr(new LabelInstr(loop2.iterStartLabel));
        this.addInstr(new ThreadPollInstr(true));
        if (bodyNode != null) {
            this.build(bodyNode);
        }
        this.addInstr(new LabelInstr(loop2.iterEndLabel));
        if (isLoopHeadCondition) {
            this.addInstr(new JumpInstr(loop2.loopStartLabel));
        } else {
            cv = this.build(conditionNode);
            this.addInstr(BEQInstr.create(cv, isWhile ? this.manager.getTrue() : this.manager.getFalse(), loop2.iterStartLabel));
        }
        this.addInstr(new LabelInstr(setupResultLabel));
        this.addInstr(new CopyInstr(loopResult, this.manager.getNil()));
        this.addInstr(new LabelInstr(loop2.loopEndLabel));
        this.loopStack.pop();
        return loopResult;
    }

    public Operand buildUntil(UntilNode untilNode) {
        return this.buildConditionalLoop(untilNode.getConditionNode(), untilNode.getBodyNode(), false, untilNode.evaluateAtStart());
    }

    public Operand buildVAlias(VAliasNode valiasNode) {
        this.addInstr(new GVarAliasInstr(new StringLiteral(valiasNode.getNewName()), new StringLiteral(valiasNode.getOldName())));
        return this.manager.getNil();
    }

    public Operand buildVCall(VCallNode node) {
        return this.addResultInstr(CallInstr.create(this.scope, CallType.VARIABLE, this.createTemporaryVariable(), node.getName(), this.buildSelf(), NO_ARGS, null));
    }

    public Operand buildWhile(WhileNode whileNode) {
        return this.buildConditionalLoop(whileNode.getConditionNode(), whileNode.getBodyNode(), true, whileNode.evaluateAtStart());
    }

    public Operand buildXStr(XStrNode node) {
        return this.addResultInstr(new BacktickInstr(this.createTemporaryVariable(), new Operand[]{new FrozenString(node.getValue(), node.getCodeRange(), node.getPosition().getFile(), node.getPosition().getLine())}));
    }

    public Operand buildYield(YieldNode node) {
        boolean unwrap = true;
        Node argNode = node.getArgsNode();
        if (argNode != null && argNode instanceof ArrayNode && ((ArrayNode)argNode).size() == 1) {
            argNode = ((ArrayNode)argNode).getLast();
            unwrap = false;
        }
        TemporaryVariable ret = this.createTemporaryVariable();
        if (argNode instanceof ArrayNode && unwrap) {
            this.addInstr(new YieldInstr(ret, (Operand)this.scope.getYieldClosureVariable(), this.buildArray((ArrayNode)argNode, true), unwrap));
        } else {
            this.addInstr(new YieldInstr(ret, (Operand)this.scope.getYieldClosureVariable(), this.build(argNode), unwrap));
        }
        return ret;
    }

    public Operand buildZArray() {
        return this.copyAndReturnValue(new Array());
    }

    private Operand buildZSuperIfNest(final Operand block) {
        final IRBuilder builder = this;
        CodeBlock zsuperBuilder = new CodeBlock(){

            @Override
            public Operand run() {
                Operand[] args2;
                TemporaryVariable scopeDepth = IRBuilder.this.createTemporaryVariable();
                IRBuilder.this.addInstr(new ArgScopeDepthInstr(scopeDepth));
                Label allDoneLabel = IRBuilder.this.getNewLabel();
                int depthFromSuper = 0;
                Label next2 = null;
                IRBuilder superBuilder = builder;
                IRScope superScope = IRBuilder.this.scope;
                TemporaryVariable zsuperResult = IRBuilder.this.createTemporaryVariable();
                while (superScope instanceof IRClosure) {
                    if (next2 != null) {
                        IRBuilder.this.addInstr(new LabelInstr(next2));
                    }
                    next2 = IRBuilder.this.getNewLabel();
                    IRBuilder.this.addInstr(BNEInstr.create(next2, new Fixnum(depthFromSuper), scopeDepth));
                    args2 = IRBuilder.this.adjustVariableDepth(IRBuilder.getCallArgs(superScope, superBuilder), depthFromSuper);
                    IRBuilder.this.addInstr(new ZSuperInstr(zsuperResult, IRBuilder.this.buildSelf(), args2, block, IRBuilder.this.scope.maybeUsingRefinements()));
                    IRBuilder.this.addInstr(new JumpInstr(allDoneLabel));
                    superBuilder = superBuilder != null && superBuilder.parent != null ? superBuilder.parent : null;
                    superScope = superScope.getLexicalParent();
                    ++depthFromSuper;
                }
                IRBuilder.this.addInstr(new LabelInstr(next2));
                if (superScope instanceof IRMethod) {
                    args2 = IRBuilder.this.adjustVariableDepth(IRBuilder.getCallArgs(superScope, superBuilder), depthFromSuper);
                    IRBuilder.this.addInstr(new ZSuperInstr(zsuperResult, IRBuilder.this.buildSelf(), args2, block, IRBuilder.this.scope.maybeUsingRefinements()));
                }
                IRBuilder.this.addInstr(new LabelInstr(allDoneLabel));
                return zsuperResult;
            }
        };
        return this.receiveBreakException(block, zsuperBuilder);
    }

    public Operand buildZSuper(ZSuperNode zsuperNode) {
        if (this.scope.isModuleBody()) {
            return this.buildSuperInScriptBody();
        }
        Operand block = this.setupCallClosure(zsuperNode.getIterNode());
        if (block == null) {
            block = this.scope.getYieldClosureVariable();
        }
        if (this.scope instanceof IRMethod) {
            return this.buildSuperInstr(block, IRBuilder.getCallArgs(this.scope, this));
        }
        return this.buildZSuperIfNest(block);
    }

    private Operand[] adjustVariableDepth(Operand[] args2, int depthFromSuper) {
        Operand[] newArgs = new Operand[args2.length];
        for (int i2 = 0; i2 < args2.length; ++i2) {
            newArgs[i2] = args2[i2] instanceof Hash ? ((Hash)args2[i2]).cloneForLVarDepth(depthFromSuper) : ((DepthCloneable)((Object)args2[i2])).cloneForDepth(depthFromSuper);
        }
        return newArgs;
    }

    private InterpreterContext buildModuleOrClassBody(Node bodyNode, int linenumber) {
        if (RubyInstanceConfig.FULL_TRACE_ENABLED) {
            this.addInstr(new TraceInstr(RubyEvent.CLASS, null, this.getFileName(), linenumber));
        }
        this.prepareImplicitState();
        this.addCurrentScopeAndModule();
        Operand bodyReturnValue = this.build(bodyNode);
        if (RubyInstanceConfig.FULL_TRACE_ENABLED) {
            this.addInstr(new TraceInstr(RubyEvent.END, null, this.getFileName(), -1));
        }
        this.addInstr(new ReturnInstr(bodyReturnValue));
        return this.scope.allocateInterpreterContext(this.instructions);
    }

    private String methodNameFor() {
        IRMethod method = this.scope.getNearestMethod();
        return method == null ? null : method.getName();
    }

    private TemporaryVariable createTemporaryVariable() {
        return this.scope.createTemporaryVariable();
    }

    public LocalVariable getLocalVariable(String name2, int scopeDepth) {
        return this.scope.getLocalVariable(name2, scopeDepth);
    }

    public LocalVariable getNewLocalVariable(String name2, int scopeDepth) {
        return this.scope.getNewLocalVariable(name2, scopeDepth);
    }

    public String getName() {
        return this.scope.getName();
    }

    private Label getNewLabel() {
        return this.scope.getNewLabel();
    }

    private String getFileName() {
        return this.scope.getFileName();
    }

    public void initFlipStateVariable(Variable v, Operand initState) {
        this.addInstrAtBeginning(new CopyInstr(v, initState));
    }

    public static Operand[] getCallArgs(IRScope scope, IRBuilder builder) {
        ArrayList<Operand> callArgs = new ArrayList<Operand>(5);
        ArrayList<KeyValuePair<Operand, Operand>> keywordArgs = new ArrayList<KeyValuePair<Operand, Operand>>(3);
        if (builder != null) {
            for (Instr instr : builder.instructions) {
                IRBuilder.extractCallOperands(callArgs, keywordArgs, instr);
            }
        } else {
            for (Instr instr : scope.interpreterContext.getInstructions()) {
                IRBuilder.extractCallOperands(callArgs, keywordArgs, instr);
            }
        }
        return IRBuilder.getCallOperands(scope, callArgs, keywordArgs);
    }

    private static void extractCallOperands(List<Operand> callArgs, List<KeyValuePair<Operand, Operand>> keywordArgs, Instr instr) {
        if (instr instanceof ReceiveKeywordRestArgInstr) {
            keywordArgs.add(0, new KeyValuePair<Symbol, Variable>(Symbol.KW_REST_ARG_DUMMY, ((ReceiveArgBase)instr).getResult()));
        } else if (instr instanceof ReceiveKeywordArgInstr) {
            ReceiveKeywordArgInstr rkai = (ReceiveKeywordArgInstr)instr;
            keywordArgs.add(new KeyValuePair<Symbol, Variable>(new Symbol(rkai.argName, (Encoding)USASCIIEncoding.INSTANCE), rkai.getResult()));
        } else if (instr instanceof ReceiveRestArgInstr) {
            callArgs.add(new Splat(((ReceiveRestArgInstr)instr).getResult()));
        } else if (instr instanceof ReceiveArgBase) {
            callArgs.add(((ReceiveArgBase)instr).getResult());
        }
    }

    private static Operand[] getCallOperands(IRScope scope, List<Operand> callArgs, List<KeyValuePair<Operand, Operand>> keywordArgs) {
        if (scope.receivesKeywordArgs()) {
            int i2 = 0;
            Operand[] args2 = new Operand[callArgs.size() + 1];
            for (Operand arg2 : callArgs) {
                args2[i2++] = arg2;
            }
            args2[i2] = new Hash(keywordArgs, true);
            return args2;
        }
        return callArgs.toArray(new Operand[callArgs.size()]);
    }

    static interface CodeBlock {
        public Operand run();
    }

    private static class EnsureBlockInfo {
        Label regionStart;
        Label start;
        Label end;
        Label dummyRescueBlockLabel;
        Variable savedGlobalException;
        boolean needsBacktrace;
        Label bodyRescuer;
        IRLoop innermostLoop;
        RescueNode matchingRescueNode;
        List<Instr> instrs;

        public EnsureBlockInfo(IRScope s2, RescueNode n, IRLoop l, Label bodyRescuer) {
            this.regionStart = s2.getNewLabel();
            this.start = s2.getNewLabel();
            this.end = s2.getNewLabel();
            this.dummyRescueBlockLabel = s2.getNewLabel();
            this.instrs = new ArrayList<Instr>();
            this.savedGlobalException = null;
            this.innermostLoop = l;
            this.matchingRescueNode = n;
            this.bodyRescuer = bodyRescuer;
            this.needsBacktrace = true;
        }

        public void addInstr(Instr i2) {
            this.instrs.add(i2);
        }

        public void addInstrAtBeginning(Instr i2) {
            this.instrs.add(0, i2);
        }

        public void emitBody(IRBuilder b2) {
            b2.addInstr(new LabelInstr(this.start));
            for (Instr i2 : this.instrs) {
                b2.addInstr(i2);
            }
        }

        public void cloneIntoHostScope(IRBuilder builder) {
            SimpleCloneInfo ii = new SimpleCloneInfo(builder.scope, true);
            ii.renameLabel(this.start);
            for (Instr i2 : this.instrs) {
                if (!(i2 instanceof LabelInstr)) continue;
                ii.renameLabel(((LabelInstr)i2).getLabel());
            }
            if (this.savedGlobalException != null) {
                if (!this.needsBacktrace) {
                    builder.addInstr(builder.manager.needsBacktrace(true));
                }
                builder.addInstr(new PutGlobalVarInstr("$!", (Operand)this.savedGlobalException));
            }
            builder.addInstr(new LabelInstr(ii.getRenamedLabel(this.start)));
            builder.addInstr(new ExceptionRegionStartMarkerInstr(this.bodyRescuer));
            for (Instr instr : this.instrs) {
                CallBase call2;
                Operand block;
                Instr clonedInstr = instr.clone(ii);
                if (clonedInstr instanceof CallBase && (block = (call2 = (CallBase)clonedInstr).getClosureArg(null)) instanceof WrappedIRClosure) {
                    builder.scope.addClosure(((WrappedIRClosure)block).getClosure());
                }
                builder.addInstr(clonedInstr);
            }
            builder.addInstr(new ExceptionRegionEndMarkerInstr());
        }
    }

    private static class RescueBlockInfo {
        Label entryLabel;
        Variable savedExceptionVariable;

        public RescueBlockInfo(Label l, Variable v) {
            this.entryLabel = l;
            this.savedExceptionVariable = v;
        }
    }

    private static class IRLoop {
        public final IRScope container;
        public final IRLoop parentLoop;
        public final Label loopStartLabel;
        public final Label loopEndLabel;
        public final Label iterStartLabel;
        public final Label iterEndLabel;
        public final Variable loopResult;

        public IRLoop(IRScope s2, IRLoop outerLoop) {
            this.container = s2;
            this.parentLoop = outerLoop;
            this.loopStartLabel = s2.getNewLabel("_LOOP_BEGIN");
            this.loopEndLabel = s2.getNewLabel("_LOOP_END");
            this.iterStartLabel = s2.getNewLabel("_ITER_BEGIN");
            this.iterEndLabel = s2.getNewLabel("_ITER_END");
            this.loopResult = s2.createTemporaryVariable();
            s2.setHasLoopsFlag();
        }
    }
}

