/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.util.Map;
import jnr.enxio.channels.NativeDeviceChannel;
import jnr.posix.POSIX;
import org.jcodings.Encoding;
import org.jruby.Ruby;
import org.jruby.RubyArgsFile;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyIO;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.internal.runtime.GlobalVariable;
import org.jruby.internal.runtime.GlobalVariables;
import org.jruby.internal.runtime.ValueAccessor;
import org.jruby.javasupport.JavaUtil;
import org.jruby.platform.Platform;
import org.jruby.runtime.Block;
import org.jruby.runtime.Constants;
import org.jruby.runtime.GlobalVariable;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.IAccessor;
import org.jruby.runtime.ReadonlyGlobalVariable;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.KCode;
import org.jruby.util.OSEnvironment;
import org.jruby.util.RegexpOptions;
import org.jruby.util.cli.OutputStrings;
import org.jruby.util.io.ChannelHelper;
import org.jruby.util.io.EncodingUtils;
import org.jruby.util.io.FilenoUtil;
import org.jruby.util.io.STDIO;

public class RubyGlobal {
    public static void initARGV(Ruby runtime) {
        String[] argv2;
        RubyArray argvArray = runtime.newArray();
        for (String arg2 : argv2 = runtime.getInstanceConfig().getArgv()) {
            argvArray.append(RubyString.newInternalFromJavaExternal(runtime, arg2));
        }
        if (runtime.getObject().getConstantNoConstMissing("ARGV") != null) {
            ((RubyArray)runtime.getObject().getConstant("ARGV")).replace(argvArray);
        } else {
            runtime.getObject().setConstantQuiet("ARGV", argvArray);
            runtime.getGlobalVariables().define("$*", new ValueAccessor(argvArray), GlobalVariable.Scope.GLOBAL);
        }
    }

    public static void createGlobals(ThreadContext context, Ruby runtime) {
        GlobalVariables globals = runtime.getGlobalVariables();
        runtime.defineGlobalConstant("TOPLEVEL_BINDING", runtime.newBinding());
        runtime.defineGlobalConstant("TRUE", runtime.getTrue());
        runtime.defineGlobalConstant("FALSE", runtime.getFalse());
        runtime.defineGlobalConstant("NIL", runtime.getNil());
        RubyGlobal.initARGV(runtime);
        ValueAccessor d = new ValueAccessor(runtime.newString(runtime.getInstanceConfig().displayedFileName()));
        globals.define("$PROGRAM_NAME", d, GlobalVariable.Scope.GLOBAL);
        globals.define("$0", d, GlobalVariable.Scope.GLOBAL);
        IRubyObject version = null;
        RubyFixnum patchlevel = null;
        IRubyObject release = runtime.newString("2021-01-06").freeze(context);
        IRubyObject platform = runtime.newString("java").freeze(context);
        IRubyObject engine = runtime.newString("jruby").freeze(context);
        version = runtime.newString("2.3.1").freeze(context);
        patchlevel = runtime.newFixnum(0);
        runtime.defineGlobalConstant("RUBY_VERSION", version);
        runtime.defineGlobalConstant("RUBY_PATCHLEVEL", patchlevel);
        runtime.defineGlobalConstant("RUBY_RELEASE_DATE", release);
        runtime.defineGlobalConstant("RUBY_PLATFORM", platform);
        IRubyObject description = runtime.newString(OutputStrings.getVersionString()).freeze(context);
        runtime.defineGlobalConstant("RUBY_DESCRIPTION", description);
        IRubyObject copyright = runtime.newString(OutputStrings.getCopyrightString()).freeze(context);
        runtime.defineGlobalConstant("RUBY_COPYRIGHT", copyright);
        runtime.defineGlobalConstant("RELEASE_DATE", release);
        runtime.defineGlobalConstant("PLATFORM", platform);
        IRubyObject jrubyVersion = runtime.newString("9.1.7.0").freeze(context);
        IRubyObject jrubyRevision = runtime.newString(Constants.REVISION).freeze(context);
        runtime.defineGlobalConstant("JRUBY_VERSION", jrubyVersion);
        runtime.defineGlobalConstant("JRUBY_REVISION", jrubyRevision);
        runtime.defineGlobalConstant("RUBY_REVISION", runtime.newFixnum(Constants.RUBY_REVISION));
        runtime.defineGlobalConstant("RUBY_ENGINE", engine);
        runtime.defineGlobalConstant("RUBY_ENGINE_VERSION", jrubyVersion);
        RubyInstanceConfig.Verbosity verbosity = runtime.getInstanceConfig().getVerbosity();
        runtime.defineVariable(new WarningGlobalVariable(runtime, "$-W", verbosity), GlobalVariable.Scope.GLOBAL);
        NonEffectiveGlobalVariable kcodeGV = new NonEffectiveGlobalVariable(runtime, "$KCODE", runtime.getNil());
        runtime.defineVariable(kcodeGV, GlobalVariable.Scope.GLOBAL);
        runtime.defineVariable(new GlobalVariable.Copy(runtime, "$-K", kcodeGV), GlobalVariable.Scope.GLOBAL);
        IRubyObject defaultRS = runtime.newString(runtime.getInstanceConfig().getRecordSeparator()).freeze(context);
        StringGlobalVariable rs = new StringGlobalVariable(runtime, "$/", defaultRS);
        runtime.defineVariable(rs, GlobalVariable.Scope.GLOBAL);
        runtime.setRecordSeparatorVar(rs);
        globals.setDefaultSeparator(defaultRS);
        runtime.defineVariable(new StringGlobalVariable(runtime, "$\\", runtime.getNil()), GlobalVariable.Scope.GLOBAL);
        runtime.defineVariable(new StringGlobalVariable(runtime, "$,", runtime.getNil()), GlobalVariable.Scope.GLOBAL);
        runtime.defineVariable(new LineNumberGlobalVariable(runtime, "$."), GlobalVariable.Scope.GLOBAL);
        runtime.defineVariable(new LastlineGlobalVariable(runtime, "$_"), GlobalVariable.Scope.FRAME);
        runtime.defineVariable(new LastExitStatusVariable(runtime, "$?"), GlobalVariable.Scope.THREAD);
        runtime.defineVariable(new ErrorInfoGlobalVariable(runtime, "$!", runtime.getNil()), GlobalVariable.Scope.THREAD);
        runtime.defineVariable(new NonEffectiveGlobalVariable(runtime, "$=", runtime.getFalse()), GlobalVariable.Scope.GLOBAL);
        if (runtime.getInstanceConfig().getInputFieldSeparator() == null) {
            runtime.defineVariable(new GlobalVariable(runtime, "$;", runtime.getNil()), GlobalVariable.Scope.GLOBAL);
        } else {
            runtime.defineVariable(new GlobalVariable(runtime, "$;", RubyRegexp.newRegexp(runtime, runtime.getInstanceConfig().getInputFieldSeparator(), new RegexpOptions())), GlobalVariable.Scope.GLOBAL);
        }
        RubyInstanceConfig.Verbosity verbose = runtime.getInstanceConfig().getVerbosity();
        IRubyObject verboseValue = null;
        verboseValue = verbose == RubyInstanceConfig.Verbosity.NIL ? runtime.getNil() : (verbose == RubyInstanceConfig.Verbosity.TRUE ? runtime.getTrue() : runtime.getFalse());
        runtime.defineVariable(new VerboseGlobalVariable(runtime, "$VERBOSE", verboseValue), GlobalVariable.Scope.GLOBAL);
        runtime.defineVariable(new VerboseGlobalVariable(runtime, "$-v", verboseValue), GlobalVariable.Scope.GLOBAL);
        runtime.defineVariable(new VerboseGlobalVariable(runtime, "$-w", verboseValue), GlobalVariable.Scope.GLOBAL);
        RubyBoolean debug = runtime.newBoolean(runtime.getInstanceConfig().isDebug());
        runtime.defineVariable(new DebugGlobalVariable(runtime, "$DEBUG", debug), GlobalVariable.Scope.GLOBAL);
        runtime.defineVariable(new DebugGlobalVariable(runtime, "$-d", debug), GlobalVariable.Scope.GLOBAL);
        runtime.defineVariable(new SafeGlobalVariable(runtime, "$SAFE"), GlobalVariable.Scope.THREAD);
        runtime.defineVariable(new BacktraceGlobalVariable(runtime, "$@"), GlobalVariable.Scope.THREAD);
        RubyGlobal.initSTDIO(runtime, globals);
        runtime.defineVariable(new LoadedFeatures(runtime, "$\""), GlobalVariable.Scope.GLOBAL);
        runtime.defineVariable(new LoadedFeatures(runtime, "$LOADED_FEATURES"), GlobalVariable.Scope.GLOBAL);
        runtime.defineVariable(new LoadPath(runtime, "$:"), GlobalVariable.Scope.GLOBAL);
        runtime.defineVariable(new LoadPath(runtime, "$-I"), GlobalVariable.Scope.GLOBAL);
        runtime.defineVariable(new LoadPath(runtime, "$LOAD_PATH"), GlobalVariable.Scope.GLOBAL);
        runtime.defineVariable(new MatchMatchGlobalVariable(runtime, "$&"), GlobalVariable.Scope.FRAME);
        runtime.defineVariable(new PreMatchGlobalVariable(runtime, "$`"), GlobalVariable.Scope.FRAME);
        runtime.defineVariable(new PostMatchGlobalVariable(runtime, "$'"), GlobalVariable.Scope.FRAME);
        runtime.defineVariable(new LastMatchGlobalVariable(runtime, "$+"), GlobalVariable.Scope.FRAME);
        runtime.defineVariable(new BackRefGlobalVariable(runtime, "$~"), GlobalVariable.Scope.FRAME);
        globals.defineReadonly("$$", new PidAccessor(runtime), GlobalVariable.Scope.GLOBAL);
        RubyGlobal.defineGlobalEnvConstants(runtime);
        if (globals.get("$*").isNil()) {
            globals.defineReadonly("$*", new ValueAccessor(runtime.newArray()), GlobalVariable.Scope.GLOBAL);
        }
        globals.defineReadonly("$-p", new ValueAccessor(runtime.newBoolean(runtime.getInstanceConfig().isAssumePrinting())), GlobalVariable.Scope.GLOBAL);
        globals.defineReadonly("$-a", new ValueAccessor(runtime.newBoolean(runtime.getInstanceConfig().isSplit())), GlobalVariable.Scope.GLOBAL);
        globals.defineReadonly("$-l", new ValueAccessor(runtime.newBoolean(runtime.getInstanceConfig().isProcessLineEnds())), GlobalVariable.Scope.GLOBAL);
        RubyArgsFile.initArgsFile(runtime);
        globals.alias("$-0", "$/");
        globals.alias("$ERROR_INFO", "$!");
        globals.alias("$ERROR_POSITION", "$@");
        globals.alias("$FS", "$;");
        globals.alias("$FIELD_SEPARATOR", "$;");
        globals.alias("$OFS", "$,");
        globals.alias("$OUTPUT_FIELD_SEPARATOR", "$,");
        globals.alias("$RS", "$/");
        globals.alias("$INPUT_RECORD_SEPARATOR", "$/");
        globals.alias("$ORS", "$\\");
        globals.alias("$OUTPUT_RECORD_SEPARATOR", "$\\");
        globals.alias("$NR", "$.");
        globals.alias("$INPUT_LINE_NUMBER", "$.");
        globals.alias("$LAST_READ_LINE", "$_");
        globals.alias("$DEFAULT_OUTPUT", "$>");
        globals.alias("$DEFAULT_INPUT", "$<");
        globals.alias("$PID", "$$");
        globals.alias("$PROCESS_ID", "$$");
        globals.alias("$CHILD_STATUS", "$?");
        globals.alias("$LAST_MATCH_INFO", "$~");
        globals.alias("$IGNORECASE", "$=");
        globals.alias("$ARGV", "$*");
        globals.alias("$MATCH", "$&");
        globals.alias("$PREMATCH", "$`");
        globals.alias("$POSTMATCH", "$'");
        globals.alias("$LAST_PAREN_MATCH", "$+");
    }

    public static void initSTDIO(Ruby runtime, GlobalVariables globals) {
        RubyIO stdin = RubyIO.prepStdio(runtime, runtime.getIn(), RubyGlobal.prepareStdioChannel(runtime, STDIO.IN, runtime.getIn()), 1, runtime.getIO(), "<STDIN>");
        RubyIO stdout = RubyIO.prepStdio(runtime, runtime.getOut(), RubyGlobal.prepareStdioChannel(runtime, STDIO.OUT, runtime.getOut()), 2, runtime.getIO(), "<STDOUT>");
        RubyIO stderr = RubyIO.prepStdio(runtime, runtime.getErr(), RubyGlobal.prepareStdioChannel(runtime, STDIO.ERR, runtime.getErr()), 10, runtime.getIO(), "<STDERR>");
        if (runtime.getObject().getConstantFromNoConstMissing("STDIN") == null) {
            runtime.defineVariable(new InputGlobalVariable(runtime, "$stdin", stdin), GlobalVariable.Scope.GLOBAL);
            runtime.defineVariable(new OutputGlobalVariable(runtime, "$stdout", stdout), GlobalVariable.Scope.GLOBAL);
            globals.alias("$>", "$stdout");
            runtime.defineVariable(new OutputGlobalVariable(runtime, "$stderr", stderr), GlobalVariable.Scope.GLOBAL);
            runtime.defineGlobalConstant("STDIN", stdin);
            runtime.defineGlobalConstant("STDOUT", stdout);
            runtime.defineGlobalConstant("STDERR", stderr);
        } else {
            ((RubyIO)runtime.getObject().getConstant("STDIN")).getOpenFile().setFD(stdin.getOpenFile().fd());
            ((RubyIO)runtime.getObject().getConstant("STDOUT")).getOpenFile().setFD(stdout.getOpenFile().fd());
            ((RubyIO)runtime.getObject().getConstant("STDERR")).getOpenFile().setFD(stderr.getOpenFile().fd());
        }
    }

    private static Channel prepareStdioChannel(Ruby runtime, STDIO stdio, Object stream) {
        if (runtime.getPosix().isNative() && stdio.isJVMDefault(stream) && !Platform.IS_WINDOWS) {
            OutputStream unwrappedStream;
            int fileno2 = -1;
            Channel channel = null;
            if (stream instanceof Channel) {
                channel = (Channel)stream;
                fileno2 = FilenoUtil.filenoFrom(channel);
            } else if (stream instanceof InputStream) {
                InputStream unwrappedStream2 = ChannelHelper.unwrapFilterInputStream((InputStream)stream);
                if (unwrappedStream2 instanceof FileInputStream) {
                    fileno2 = FilenoUtil.filenoFrom(((FileInputStream)unwrappedStream2).getChannel());
                }
            } else if (stream instanceof OutputStream && (unwrappedStream = ChannelHelper.unwrapFilterOutputStream((OutputStream)stream)) instanceof FileOutputStream) {
                fileno2 = FilenoUtil.filenoFrom(((FileOutputStream)unwrappedStream).getChannel());
            }
            if (fileno2 >= 0) {
                return new NativeDeviceChannel(fileno2);
            }
        }
        switch (stdio) {
            case IN: {
                return Channels.newChannel((InputStream)stream);
            }
            case OUT: 
            case ERR: {
                return Channels.newChannel((OutputStream)stream);
            }
        }
        throw new RuntimeException("invalid stdio: " + (Object)((Object)stdio));
    }

    private static int unwrapDripStream(Object stream) {
        if (stream.getClass().getName().startsWith("org.flatland.drip.Switchable")) {
            try {
                FileDescriptor fd = (FileDescriptor)stream.getClass().getMethod("getFD", new Class[0]).invoke(stream, new Object[0]);
                return FilenoUtil.filenoFrom(fd);
            }
            catch (NoSuchMethodException nsme) {
                nsme.printStackTrace(System.err);
            }
            catch (IllegalAccessException iae) {
                iae.printStackTrace(System.err);
            }
            catch (InvocationTargetException ite) {
                ite.printStackTrace(System.err);
            }
        }
        return -1;
    }

    private static void defineGlobalEnvConstants(Ruby runtime) {
        Map<RubyString, RubyString> environmentVariableMap = OSEnvironment.environmentVariableMap(runtime);
        CaseInsensitiveStringOnlyRubyHash env = new CaseInsensitiveStringOnlyRubyHash(runtime, environmentVariableMap, runtime.getNil(), runtime.getInstanceConfig().isNativeEnabled() && runtime.getInstanceConfig().isUpdateNativeENVEnabled());
        env.getSingletonClass().defineAnnotatedMethods(CaseInsensitiveStringOnlyRubyHash.class);
        runtime.defineGlobalConstant("ENV", env);
        runtime.setENV(env);
        Map<RubyString, RubyString> systemPropertiesMap = OSEnvironment.systemPropertiesMap(runtime);
        ReadOnlySystemPropertiesHash envJava = new ReadOnlySystemPropertiesHash(runtime, systemPropertiesMap, runtime.getNil());
        envJava.setFrozen(true);
        runtime.defineGlobalConstant("ENV_JAVA", envJava);
    }

    private static final class PidAccessor
    implements IAccessor {
        private final Ruby runtime;
        private volatile IRubyObject pid = null;

        public PidAccessor(Ruby runtime) {
            this.runtime = runtime;
        }

        @Override
        public IRubyObject getValue() {
            return this.pid != null ? this.pid : (this.pid = this.runtime.newFixnum(this.runtime.getPosix().getpid()));
        }

        @Override
        public IRubyObject setValue(IRubyObject newValue) {
            throw this.runtime.newRuntimeError("cannot assign to $$");
        }
    }

    private static class LoadedFeatures
    extends ReadonlyGlobalVariable {
        public LoadedFeatures(Ruby runtime, String name2) {
            super(runtime, name2, null);
        }

        @Override
        public IRubyObject get() {
            return this.runtime.getLoadService().getLoadedFeatures();
        }
    }

    private static class LoadPath
    extends ReadonlyGlobalVariable {
        public LoadPath(Ruby runtime, String name2) {
            super(runtime, name2, null);
        }

        @Override
        public IRubyObject get() {
            return this.runtime.getLoadService().getLoadPath();
        }
    }

    public static class OutputGlobalVariable
    extends GlobalVariable {
        public OutputGlobalVariable(Ruby runtime, String name2, IRubyObject value2) {
            super(runtime, name2, value2);
        }

        @Override
        public IRubyObject set(IRubyObject value2) {
            if (value2 == this.get()) {
                return value2;
            }
            if (!value2.respondsTo("write") && !value2.respondsToMissing("write")) {
                throw this.runtime.newTypeError(this.name() + " must have write method, " + value2.getType().getName() + " given");
            }
            return super.set(value2);
        }
    }

    public static class InputGlobalVariable
    extends GlobalVariable {
        public InputGlobalVariable(Ruby runtime, String name2, IRubyObject value2) {
            super(runtime, name2, value2);
        }

        @Override
        public IRubyObject set(IRubyObject value2) {
            if (value2 == this.get()) {
                return value2;
            }
            return super.set(value2);
        }
    }

    private static class LastlineGlobalVariable
    extends GlobalVariable {
        public LastlineGlobalVariable(Ruby runtime, String name2) {
            super(runtime, name2, null);
        }

        @Override
        public IRubyObject get() {
            return Helpers.getLastLine(this.runtime, this.runtime.getCurrentContext());
        }

        @Override
        public IRubyObject set(IRubyObject value2) {
            Helpers.setLastLine(this.runtime, this.runtime.getCurrentContext(), value2);
            return value2;
        }
    }

    private static class BacktraceGlobalVariable
    extends GlobalVariable {
        public BacktraceGlobalVariable(Ruby runtime, String name2) {
            super(runtime, name2, null);
        }

        @Override
        public IRubyObject get() {
            IRubyObject backtrace2;
            IRubyObject errorInfo = this.runtime.getGlobalVariables().get("$!");
            IRubyObject iRubyObject = backtrace2 = errorInfo.isNil() ? this.runtime.getNil() : errorInfo.callMethod(errorInfo.getRuntime().getCurrentContext(), "backtrace");
            if (!(backtrace2 instanceof RubyArray)) {
                backtrace2 = this.runtime.getNil();
            }
            return backtrace2;
        }

        @Override
        public IRubyObject set(IRubyObject value2) {
            if (this.runtime.getGlobalVariables().get("$!").isNil()) {
                throw this.runtime.newArgumentError("$! not set");
            }
            this.runtime.getGlobalVariables().get("$!").callMethod(value2.getRuntime().getCurrentContext(), "set_backtrace", value2);
            return value2;
        }
    }

    private static class DebugGlobalVariable
    extends GlobalVariable {
        public DebugGlobalVariable(Ruby runtime, String name2, IRubyObject initialValue) {
            super(runtime, name2, initialValue);
            this.set(initialValue);
        }

        @Override
        public IRubyObject get() {
            return this.runtime.getDebug();
        }

        @Override
        public IRubyObject set(IRubyObject newValue) {
            if (newValue.isNil()) {
                this.runtime.setDebug(newValue);
            } else {
                this.runtime.setDebug(this.runtime.newBoolean(newValue.isTrue()));
            }
            return newValue;
        }
    }

    private static class WarningGlobalVariable
    extends ReadonlyGlobalVariable {
        public WarningGlobalVariable(Ruby runtime, String name2, RubyInstanceConfig.Verbosity verbosity) {
            super(runtime, name2, verbosity == RubyInstanceConfig.Verbosity.NIL ? RubyFixnum.newFixnum(runtime, 0L) : (verbosity == RubyInstanceConfig.Verbosity.FALSE ? RubyFixnum.newFixnum(runtime, 1L) : (verbosity == RubyInstanceConfig.Verbosity.TRUE ? RubyFixnum.newFixnum(runtime, 2L) : runtime.getNil())));
        }
    }

    private static class VerboseGlobalVariable
    extends GlobalVariable {
        public VerboseGlobalVariable(Ruby runtime, String name2, IRubyObject initialValue) {
            super(runtime, name2, initialValue);
            this.set(initialValue);
        }

        @Override
        public IRubyObject get() {
            return this.runtime.getVerbose();
        }

        @Override
        public IRubyObject set(IRubyObject newValue) {
            if (newValue.isNil()) {
                this.runtime.setVerbose(newValue);
            } else {
                this.runtime.setVerbose(this.runtime.newBoolean(newValue.isTrue()));
            }
            return newValue;
        }
    }

    private static class SafeGlobalVariable
    extends GlobalVariable {
        public SafeGlobalVariable(Ruby runtime, String name2) {
            super(runtime, name2, null);
        }

        @Override
        public IRubyObject get() {
            return RubyFixnum.zero(this.runtime);
        }

        @Override
        public IRubyObject set(IRubyObject value2) {
            this.runtime.getWarnings().warnOnce(IRubyWarnings.ID.SAFE_NOT_SUPPORTED, "SAFE levels are not supported in JRuby");
            return RubyFixnum.zero(this.runtime);
        }
    }

    public static class KCodeGlobalVariable
    extends GlobalVariable {
        public KCodeGlobalVariable(Ruby runtime, String name2, IRubyObject value2) {
            super(runtime, name2, value2);
        }

        @Override
        public IRubyObject get() {
            String kcode = this.runtime.getKCode().getKCode();
            return kcode == null ? this.runtime.getNil() : this.runtime.newString(kcode);
        }

        @Override
        public IRubyObject set(IRubyObject value2) {
            this.runtime.setKCode(KCode.create(value2.convertToString().toString()));
            return value2;
        }
    }

    public static class StringGlobalVariable
    extends GlobalVariable {
        public StringGlobalVariable(Ruby runtime, String name2, IRubyObject value2) {
            super(runtime, name2, value2);
        }

        @Override
        public IRubyObject set(IRubyObject value2) {
            if (!value2.isNil() && !(value2 instanceof RubyString)) {
                throw this.runtime.newTypeError("value of " + this.name() + " must be a String");
            }
            return super.set(value2);
        }
    }

    private static class ErrorInfoGlobalVariable
    extends GlobalVariable {
        public ErrorInfoGlobalVariable(Ruby runtime, String name2, IRubyObject value2) {
            super(runtime, name2, null);
            this.set(value2);
        }

        @Override
        public IRubyObject set(IRubyObject value2) {
            if (!(value2.isNil() || this.runtime.getException().isInstance(value2) || JavaUtil.isJavaObject(value2) && JavaUtil.unwrapJavaObject(value2) instanceof Throwable)) {
                throw this.runtime.newTypeError("assigning non-exception to $!");
            }
            return this.runtime.getCurrentContext().setErrorInfo(value2);
        }

        @Override
        public IRubyObject get() {
            return this.runtime.getCurrentContext().getErrorInfo();
        }
    }

    private static class LineNumberGlobalVariable
    extends GlobalVariable {
        public LineNumberGlobalVariable(Ruby runtime, String name2) {
            super(runtime, name2, null);
        }

        @Override
        public IRubyObject set(IRubyObject value2) {
            int line = (int)value2.convertToInteger().getLongValue();
            this.runtime.setCurrentLine(line);
            RubyArgsFile.setCurrentLineNumber(this.runtime.getArgsFile(), line);
            return value2;
        }

        @Override
        public IRubyObject get() {
            return this.runtime.newFixnum(this.runtime.getCurrentLine());
        }
    }

    private static class BackRefGlobalVariable
    extends GlobalVariable {
        public BackRefGlobalVariable(Ruby runtime, String name2) {
            super(runtime, name2, runtime.getNil());
        }

        @Override
        public IRubyObject get() {
            return Helpers.getBackref(this.runtime, this.runtime.getCurrentContext());
        }

        @Override
        public IRubyObject set(IRubyObject value2) {
            Helpers.setBackref(this.runtime, this.runtime.getCurrentContext(), value2);
            return value2;
        }
    }

    private static class LastMatchGlobalVariable
    extends GlobalVariable {
        public LastMatchGlobalVariable(Ruby runtime, String name2) {
            super(runtime, name2, runtime.getNil());
        }

        @Override
        public IRubyObject get() {
            return RubyRegexp.match_last(this.runtime.getCurrentContext().getBackRef());
        }
    }

    private static class PostMatchGlobalVariable
    extends GlobalVariable {
        public PostMatchGlobalVariable(Ruby runtime, String name2) {
            super(runtime, name2, runtime.getNil());
        }

        @Override
        public IRubyObject get() {
            return RubyRegexp.match_post(this.runtime.getCurrentContext().getBackRef());
        }
    }

    private static class PreMatchGlobalVariable
    extends GlobalVariable {
        public PreMatchGlobalVariable(Ruby runtime, String name2) {
            super(runtime, name2, runtime.getNil());
        }

        @Override
        public IRubyObject get() {
            return RubyRegexp.match_pre(this.runtime.getCurrentContext().getBackRef());
        }
    }

    private static class MatchMatchGlobalVariable
    extends GlobalVariable {
        public MatchMatchGlobalVariable(Ruby runtime, String name2) {
            super(runtime, name2, runtime.getNil());
        }

        @Override
        public IRubyObject get() {
            return RubyRegexp.last_match(this.runtime.getCurrentContext().getBackRef());
        }
    }

    private static class LastExitStatusVariable
    extends GlobalVariable {
        public LastExitStatusVariable(Ruby runtime, String name2) {
            super(runtime, name2, runtime.getNil());
        }

        @Override
        public IRubyObject get() {
            IRubyObject lastExitStatus = this.runtime.getCurrentContext().getLastExitStatus();
            return lastExitStatus == null ? this.runtime.getNil() : lastExitStatus;
        }

        @Override
        public IRubyObject set(IRubyObject lastExitStatus) {
            throw this.runtime.newNameError("$? is a read-only variable", "$?");
        }
    }

    private static class NonEffectiveGlobalVariable
    extends GlobalVariable {
        public NonEffectiveGlobalVariable(Ruby runtime, String name2, IRubyObject value2) {
            super(runtime, name2, value2);
        }

        @Override
        public IRubyObject set(IRubyObject value2) {
            this.runtime.getWarnings().warn(IRubyWarnings.ID.INEFFECTIVE_GLOBAL, "warning: variable " + this.name + " is no longer effective; ignored");
            return value2;
        }

        @Override
        public IRubyObject get() {
            this.runtime.getWarnings().warn(IRubyWarnings.ID.INEFFECTIVE_GLOBAL, "warning: variable " + this.name + " is no longer effective");
            return this.value;
        }
    }

    private static class ReadOnlySystemPropertiesHash
    extends StringOnlyRubyHash {
        public ReadOnlySystemPropertiesHash(Ruby runtime, Map<RubyString, RubyString> valueMap, IRubyObject defaultValue, boolean updateRealENV) {
            super(runtime, valueMap, defaultValue, updateRealENV);
        }

        public ReadOnlySystemPropertiesHash(Ruby runtime, Map<RubyString, RubyString> valueMap, IRubyObject defaultValue) {
            this(runtime, valueMap, defaultValue, false);
        }

        @Override
        public void modify() {
            if (this.isFrozen()) {
                throw this.getRuntime().newTypeError("ENV_JAVA is not writable until you require 'java'");
            }
        }
    }

    public static class StringOnlyRubyHash
    extends RubyHash {
        private final boolean updateRealENV;

        public StringOnlyRubyHash(Ruby runtime, Map<RubyString, RubyString> valueMap, IRubyObject defaultValue, boolean updateRealENV) {
            super(runtime, valueMap, defaultValue);
            this.updateRealENV = updateRealENV;
        }

        public StringOnlyRubyHash(Ruby runtime, Map<RubyString, RubyString> valueMap, IRubyObject defaultValue) {
            this(runtime, valueMap, defaultValue, false);
        }

        @Override
        public IRubyObject op_aref(ThreadContext context, IRubyObject key2) {
            return this.case_aware_op_aref(context, key2, true);
        }

        @Override
        public RubyHash to_hash() {
            Ruby runtime = this.getRuntime();
            RubyHash hash2 = RubyHash.newHash(runtime);
            hash2.replace(runtime.getCurrentContext(), this);
            return hash2;
        }

        @Override
        public IRubyObject op_aset(ThreadContext context, IRubyObject key2, IRubyObject value2) {
            return this.case_aware_op_aset(context, key2, value2, true);
        }

        @Override
        @Deprecated
        public IRubyObject op_aset19(ThreadContext context, IRubyObject key2, IRubyObject value2) {
            return this.op_aset(context, key2, value2);
        }

        protected IRubyObject case_aware_op_aref(ThreadContext context, IRubyObject key2, boolean caseSensitive) {
            if (!caseSensitive) {
                key2 = this.getCorrectKey(key2, context);
            }
            return super.op_aref(context, key2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected IRubyObject case_aware_op_aset(ThreadContext context, IRubyObject key2, IRubyObject value2, boolean caseSensitive) {
            IRubyObject valueAsStr;
            if (!key2.respondsTo("to_str")) {
                throw this.getRuntime().newTypeError("can't convert " + key2.getMetaClass() + " into String");
            }
            if (!value2.respondsTo("to_str") && !value2.isNil()) {
                throw this.getRuntime().newTypeError("can't convert " + value2.getMetaClass() + " into String");
            }
            if (!caseSensitive) {
                key2 = this.getCorrectKey(key2, context);
            }
            if (value2.isNil()) {
                return super.delete(context, key2, Block.NULL_BLOCK);
            }
            IRubyObject keyAsStr = this.normalizeEnvString(context, key2, Helpers.invoke(context, key2, "to_str"));
            IRubyObject iRubyObject = valueAsStr = value2.isNil() ? context.nil : this.normalizeEnvString(context, key2, Helpers.invoke(context, value2, "to_str"));
            if (!this.updateRealENV) return super.op_aset(context, keyAsStr, valueAsStr);
            POSIX posix = context.runtime.getPosix();
            String keyAsJava = keyAsStr.asJavaString();
            if (valueAsStr == context.nil) {
                Class<Object> clazz = Object.class;
                synchronized (Object.class) {
                    posix.unsetenv(keyAsJava);
                    // ** MonitorExit[var9_9] (shouldn't be in output)
                    return super.op_aset(context, keyAsStr, valueAsStr);
                }
            }
            Class<Object> clazz = Object.class;
            synchronized (Object.class) {
                posix.setenv(keyAsJava, valueAsStr.asJavaString(), 1);
                // ** MonitorExit[var9_10] (shouldn't be in output)
                return super.op_aset(context, keyAsStr, valueAsStr);
            }
        }

        private RubyString getCorrectKey(IRubyObject key2, ThreadContext context) {
            RubyString originalKey;
            RubyString actualKey = originalKey = key2.convertToString();
            Ruby runtime = context.runtime;
            if (Platform.IS_WINDOWS) {
                RubyArray keys2 = super.keys();
                for (int i2 = 0; i2 < keys2.size(); ++i2) {
                    RubyString candidateKey = keys2.eltInternal(i2).convertToString();
                    if (!candidateKey.casecmp(context, originalKey).op_equal(context, RubyFixnum.zero(runtime)).isTrue()) continue;
                    actualKey = candidateKey;
                    break;
                }
            }
            return actualKey;
        }

        private IRubyObject normalizeEnvString(ThreadContext context, IRubyObject key2, IRubyObject value2) {
            if (value2 instanceof RubyString) {
                Ruby runtime = context.runtime;
                RubyString valueStr = (RubyString)value2;
                if (Platform.IS_WINDOWS ? key2.toString().equalsIgnoreCase("PATH") : key2.toString().equals("PATH")) {
                    Encoding enc = runtime.getEncodingService().getFileSystemEncoding();
                    valueStr = EncodingUtils.strConvEnc(context, valueStr, valueStr.getEncoding(), enc);
                } else {
                    valueStr = RubyString.newString(runtime, valueStr.toString(), runtime.getEncodingService().getLocaleEncoding());
                }
                valueStr.setFrozen(true);
                return valueStr;
            }
            return value2;
        }
    }

    public static class CaseInsensitiveStringOnlyRubyHash
    extends StringOnlyRubyHash {
        public CaseInsensitiveStringOnlyRubyHash(Ruby runtime, Map<RubyString, RubyString> valueMap, IRubyObject defaultValue, boolean updateRealENV) {
            super(runtime, valueMap, defaultValue, updateRealENV);
        }

        @Override
        public IRubyObject op_aref(ThreadContext context, IRubyObject key2) {
            return this.case_aware_op_aref(context, key2, false);
        }

        @Override
        public IRubyObject op_aset(ThreadContext context, IRubyObject key2, IRubyObject value2) {
            return this.case_aware_op_aset(context, key2, value2, false);
        }

        @Override
        @JRubyMethod(name={"to_s"})
        public IRubyObject to_s(ThreadContext context) {
            return context.runtime.newString("ENV");
        }

        @Override
        public IRubyObject to_s() {
            return this.getRuntime().newString("ENV");
        }

        @JRubyMethod
        public RubyHash to_h() {
            return this.to_hash();
        }
    }
}

