/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import jnr.constants.platform.PRIO;
import jnr.constants.platform.RLIM;
import jnr.constants.platform.RLIMIT;
import jnr.constants.platform.Signal;
import jnr.constants.platform.Sysconf;
import jnr.ffi.Pointer;
import jnr.ffi.byref.IntByReference;
import jnr.posix.POSIX;
import jnr.posix.RLimit;
import jnr.posix.Times;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubySignal;
import org.jruby.RubyString;
import org.jruby.RubyStruct;
import org.jruby.RubySymbol;
import org.jruby.RubyThread;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.exceptions.RaiseException;
import org.jruby.platform.Platform;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.CallBlock;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.invokedynamic.MethodNames;
import org.jruby.runtime.marshal.CoreObjectType;
import org.jruby.util.ShellLauncher;
import org.jruby.util.TypeConverter;
import org.jruby.util.WindowsFFI;
import org.jruby.util.io.PopenExecutor;
import org.jruby.util.io.PosixShim;

@JRubyModule(name={"Process"})
public class RubyProcess {
    public static final String CLOCK_MONOTONIC = "CLOCK_MONOTONIC";
    public static final String CLOCK_REALTIME = "CLOCK_REALTIME";
    public static final String CLOCK_UNIT_NANOSECOND = "nanosecond";
    public static final String CLOCK_UNIT_MICROSECOND = "microsecond";
    public static final String CLOCK_UNIT_MILLISECOND = "millisecond";
    public static final String CLOCK_UNIT_SECOND = "second";
    public static final String CLOCK_UNIT_FLOAT_MICROSECOND = "float_microsecond";
    public static final String CLOCK_UNIT_FLOAT_MILLISECOND = "float_millisecond";
    public static final String CLOCK_UNIT_FLOAT_SECOND = "float_second";
    public static final String CLOCK_UNIT_HERTZ = "hertz";
    private static final NonNativeErrno ECHILD = new NonNativeErrno(){

        @Override
        public int handle(Ruby runtime, int result2) {
            throw runtime.newErrnoECHILDError();
        }
    };
    private static final NonNativeErrno IGNORE = new NonNativeErrno(){

        @Override
        public int handle(Ruby runtime, int result2) {
            return result2;
        }
    };

    public static RubyModule createProcessModule(Ruby runtime) {
        RubyModule process = runtime.defineModule("Process");
        runtime.setProcess(process);
        RubyClass process_status = process.defineClassUnder("Status", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        runtime.setProcStatus(process_status);
        RubyModule process_uid = process.defineModuleUnder("UID");
        runtime.setProcUID(process_uid);
        RubyModule process_gid = process.defineModuleUnder("GID");
        runtime.setProcGID(process_gid);
        RubyModule process_sys = process.defineModuleUnder("Sys");
        runtime.setProcSys(process_sys);
        process.defineAnnotatedMethods(RubyProcess.class);
        process_status.defineAnnotatedMethods(RubyStatus.class);
        process_uid.defineAnnotatedMethods(UserID.class);
        process_gid.defineAnnotatedMethods(GroupID.class);
        process_sys.defineAnnotatedMethods(Sys.class);
        runtime.loadConstantSet(process, PRIO.class);
        runtime.loadConstantSet(process, RLIM.class);
        for (RLIMIT r : RLIMIT.values()) {
            if (!r.defined()) continue;
            process.defineConstant(r.name(), runtime.newFixnum(r.intValue()));
        }
        process.defineConstant("WNOHANG", runtime.newFixnum(1));
        process.defineConstant("WUNTRACED", runtime.newFixnum(2));
        process.defineConstant(CLOCK_REALTIME, RubySymbol.newSymbol(runtime, CLOCK_REALTIME));
        process.defineConstant(CLOCK_MONOTONIC, RubySymbol.newSymbol(runtime, CLOCK_MONOTONIC));
        RubyClass tmsStruct = RubyStruct.newInstance(runtime.getStructClass(), new IRubyObject[]{runtime.newString("Tms"), runtime.newSymbol("utime"), runtime.newSymbol("stime"), runtime.newSymbol("cutime"), runtime.newSymbol("cstime")}, Block.NULL_BLOCK);
        process.defineConstant("Tms", tmsStruct);
        runtime.setTmsStruct(tmsStruct);
        return process;
    }

    @JRubyMethod(name={"abort"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject abort(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyKernel.abort(context, recv2, args2);
    }

    @JRubyMethod(name={"exit!"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject exit_bang(IRubyObject recv2, IRubyObject[] args2) {
        return RubyKernel.exit_bang(recv2, args2);
    }

    @JRubyMethod(name={"groups"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject groups(IRubyObject recv2) {
        long[] groups2 = Platform.getPlatform().getGroups(recv2);
        RubyArray ary = RubyArray.newArray(recv2.getRuntime(), groups2.length);
        for (int i2 = 0; i2 < groups2.length; ++i2) {
            ary.push(RubyFixnum.newFixnum(recv2.getRuntime(), groups2[i2]));
        }
        return ary;
    }

    @JRubyMethod(name={"setrlimit"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject setrlimit(ThreadContext context, IRubyObject recv2, IRubyObject resource2, IRubyObject rlimCur) {
        return RubyProcess.setrlimit(context, recv2, resource2, rlimCur, context.nil);
    }

    @JRubyMethod(name={"setrlimit"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject setrlimit(ThreadContext context, IRubyObject recv2, IRubyObject resource2, IRubyObject rlimCur, IRubyObject rlimMax) {
        Ruby runtime = context.runtime;
        RLimit rlim = runtime.getPosix().getrlimit(0);
        if (rlimMax == context.nil) {
            rlimMax = rlimCur;
        }
        rlim.init((long)RubyProcess.rlimitResourceValue(runtime, rlimCur), (long)RubyProcess.rlimitResourceValue(runtime, rlimMax));
        if (runtime.getPosix().setrlimit(RubyProcess.rlimitResourceType(runtime, resource2), rlim) < 0) {
            throw runtime.newErrnoFromInt(runtime.getPosix().errno(), "setrlimit");
        }
        return context.nil;
    }

    private static int rlimitResourceValue(Ruby runtime, IRubyObject rval) {
        String name2;
        switch (((CoreObjectType)((Object)rval)).getNativeClassIndex()) {
            case SYMBOL: {
                name2 = rval.toString();
                break;
            }
            case STRING: {
                name2 = rval.toString();
                break;
            }
            default: {
                IRubyObject v = TypeConverter.checkStringType(runtime, rval);
                if (!v.isNil()) {
                    rval = v;
                    name2 = rval.convertToString().toString();
                    break;
                }
            }
            case FIXNUM: 
            case BIGNUM: {
                return rval.convertToInteger().getIntValue();
            }
        }
        if (RLIM.RLIM_INFINITY.defined() && name2.equals("INFINITY")) {
            return RLIM.RLIM_INFINITY.intValue();
        }
        if (RLIM.RLIM_SAVED_MAX.defined() && name2.equals("SAVED_MAX")) {
            return RLIM.RLIM_SAVED_MAX.intValue();
        }
        if (RLIM.RLIM_SAVED_CUR.defined() && name2.equals("SAVED_CUR")) {
            return RLIM.RLIM_SAVED_CUR.intValue();
        }
        throw runtime.newArgumentError("invalid resource value: " + rval);
    }

    private static int rlimitResourceType(Ruby runtime, IRubyObject rtype) {
        String name2;
        switch (((CoreObjectType)((Object)rtype)).getNativeClassIndex()) {
            case SYMBOL: {
                name2 = rtype.toString();
                break;
            }
            case STRING: {
                name2 = rtype.toString();
                break;
            }
            default: {
                IRubyObject v = TypeConverter.checkStringType(runtime, rtype);
                if (!v.isNil()) {
                    rtype = v;
                    name2 = rtype.toString();
                    break;
                }
            }
            case FIXNUM: 
            case BIGNUM: {
                return rtype.convertToInteger().getIntValue();
            }
        }
        int r = RubyProcess.rlimitTypeByHname(name2);
        if (r != -1) {
            return r;
        }
        throw runtime.newArgumentError("invalid resource name: " + rtype);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int rlimitResourceName2int(String name2, int casetype) {
        RLIMIT resource2;
        block28: {
            switch (Character.toUpperCase(name2.charAt(0))) {
                case 'A': {
                    if (!RLIMIT.RLIMIT_AS.defined() || !name2.equalsIgnoreCase("AS")) break;
                    resource2 = RLIMIT.RLIMIT_AS;
                    break block28;
                }
                case 'C': {
                    if (RLIMIT.RLIMIT_CORE.defined() && name2.equalsIgnoreCase("CORE")) {
                        resource2 = RLIMIT.RLIMIT_CORE;
                        break block28;
                    } else {
                        if (!RLIMIT.RLIMIT_CPU.defined() || !name2.equalsIgnoreCase("CPU")) break;
                        resource2 = RLIMIT.RLIMIT_CPU;
                    }
                    break block28;
                }
                case 'D': {
                    if (!RLIMIT.RLIMIT_DATA.defined() || !name2.equalsIgnoreCase("DATA")) break;
                    resource2 = RLIMIT.RLIMIT_DATA;
                    break block28;
                }
                case 'F': {
                    if (!RLIMIT.RLIMIT_FSIZE.defined() || !name2.equalsIgnoreCase("FSIZE")) break;
                    resource2 = RLIMIT.RLIMIT_FSIZE;
                    break block28;
                }
                case 'M': {
                    if (RLIMIT.RLIMIT_MEMLOCK.defined() && name2.equalsIgnoreCase("MEMLOCK")) {
                        resource2 = RLIMIT.RLIMIT_MEMLOCK;
                        break block28;
                    } else {
                        if (!RLIMIT.RLIMIT_MSGQUEUE.defined() || !name2.equalsIgnoreCase("MSGQUEUE")) break;
                        resource2 = RLIMIT.RLIMIT_MSGQUEUE;
                    }
                    break block28;
                }
                case 'N': {
                    if (RLIMIT.RLIMIT_NOFILE.defined() && name2.equalsIgnoreCase("NOFILE")) {
                        resource2 = RLIMIT.RLIMIT_NOFILE;
                        break block28;
                    } else if (RLIMIT.RLIMIT_NPROC.defined() && name2.equalsIgnoreCase("NPROC")) {
                        resource2 = RLIMIT.RLIMIT_NPROC;
                        break block28;
                    } else {
                        if (!RLIMIT.RLIMIT_NICE.defined() || !name2.equalsIgnoreCase("NICE")) break;
                        resource2 = RLIMIT.RLIMIT_NICE;
                    }
                    break block28;
                }
                case 'R': {
                    if (RLIMIT.RLIMIT_RSS.defined() && name2.equalsIgnoreCase("RSS")) {
                        resource2 = RLIMIT.RLIMIT_RSS;
                        break block28;
                    } else if (RLIMIT.RLIMIT_RTPRIO.defined() && name2.equalsIgnoreCase("RTPRIO")) {
                        resource2 = RLIMIT.RLIMIT_RTPRIO;
                        break block28;
                    } else {
                        if (!RLIMIT.RLIMIT_RTTIME.defined() || !name2.equalsIgnoreCase("RTTIME")) break;
                        resource2 = RLIMIT.RLIMIT_RTTIME;
                    }
                    break block28;
                }
                case 'S': {
                    if (RLIMIT.RLIMIT_STACK.defined() && name2.equalsIgnoreCase("STACK")) {
                        resource2 = RLIMIT.RLIMIT_STACK;
                    } else {
                        if (!RLIMIT.RLIMIT_SIGPENDING.defined() || !name2.equalsIgnoreCase("SIGPENDING")) break;
                        resource2 = RLIMIT.RLIMIT_SIGPENDING;
                    }
                    break block28;
                }
            }
            return -1;
        }
        switch (casetype) {
            case 0: {
                if (name2.equals(name2.toUpperCase())) break;
                return -1;
            }
            case 1: {
                if (name2.equals(name2.toLowerCase())) break;
                return -1;
            }
            default: {
                throw new RuntimeException("unexpected casetype");
            }
        }
        return resource2.intValue();
    }

    private static int rlimitTypeByHname(String name2) {
        return RubyProcess.rlimitResourceName2int(name2, 0);
    }

    @Deprecated
    public static IRubyObject getpgrp(IRubyObject recv2) {
        return RubyProcess.getpgrp(recv2.getRuntime());
    }

    @JRubyMethod(name={"getpgrp"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject getpgrp(ThreadContext context, IRubyObject recv2) {
        return RubyProcess.getpgrp(context.runtime);
    }

    public static IRubyObject getpgrp(Ruby runtime) {
        return runtime.newFixnum(runtime.getPosix().getpgrp());
    }

    @JRubyMethod(name={"groups="}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject groups_set(IRubyObject recv2, IRubyObject arg2) {
        throw recv2.getRuntime().newNotImplementedError("Process#groups not yet implemented");
    }

    @Deprecated
    public static IRubyObject waitpid(IRubyObject recv2, IRubyObject[] args2) {
        return RubyProcess.waitpid(recv2.getRuntime(), args2);
    }

    @JRubyMethod(name={"waitpid"}, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject waitpid(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyProcess.waitpid(context.runtime, args2);
    }

    public static IRubyObject waitpid(Ruby runtime, IRubyObject[] args2) {
        long pid2 = -1L;
        int flags2 = 0;
        if (args2.length > 0) {
            pid2 = args2[0].convertToInteger().getLongValue();
        }
        if (args2.length > 1) {
            flags2 = (int)args2[1].convertToInteger().getLongValue();
        }
        if ((pid2 = RubyProcess.waitpid(runtime, pid2, flags2)) == 0L) {
            return runtime.getNil();
        }
        return runtime.newFixnum(pid2);
    }

    public static long waitpid(Ruby runtime, long pid2, int flags2) {
        int[] status2 = new int[1];
        runtime.getPosix().errno(0);
        pid2 = runtime.getPosix().waitpid(pid2, status2, flags2);
        RubyProcess.raiseErrnoIfSet(runtime, ECHILD);
        if (pid2 > 0L) {
            runtime.getCurrentContext().setLastExitStatus(RubyStatus.newProcessStatus(runtime, status2[0], pid2));
        } else {
            runtime.getCurrentContext().setLastExitStatus(runtime.getNil());
        }
        return pid2;
    }

    @Deprecated
    public static IRubyObject wait(IRubyObject recv2, IRubyObject[] args2) {
        return RubyProcess.wait(recv2.getRuntime(), args2);
    }

    @JRubyMethod(name={"wait"}, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject wait(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyProcess.wait(context.runtime, args2);
    }

    public static IRubyObject wait(Ruby runtime, IRubyObject[] args2) {
        if (args2.length > 0) {
            return RubyProcess.waitpid(runtime, args2);
        }
        int[] status2 = new int[1];
        runtime.getPosix().errno(0);
        int pid2 = runtime.getPosix().wait(status2);
        RubyProcess.raiseErrnoIfSet(runtime, ECHILD);
        runtime.getCurrentContext().setLastExitStatus(RubyStatus.newProcessStatus(runtime, status2[0], pid2));
        return runtime.newFixnum(pid2);
    }

    @Deprecated
    public static IRubyObject waitall(IRubyObject recv2) {
        return RubyProcess.waitall(recv2.getRuntime());
    }

    @JRubyMethod(name={"waitall"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject waitall(ThreadContext context, IRubyObject recv2) {
        return RubyProcess.waitall(context.runtime);
    }

    public static IRubyObject waitall(Ruby runtime) {
        POSIX posix = runtime.getPosix();
        RubyArray results = runtime.newArray();
        int[] status2 = new int[1];
        int result2 = posix.wait(status2);
        while (result2 != -1) {
            results.append(runtime.newArray((IRubyObject)runtime.newFixnum(result2), (IRubyObject)RubyStatus.newProcessStatus(runtime, status2[0], result2)));
            result2 = posix.wait(status2);
        }
        return results;
    }

    @Deprecated
    public static IRubyObject setsid(IRubyObject recv2) {
        return RubyProcess.setsid(recv2.getRuntime());
    }

    @JRubyMethod(name={"setsid"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject setsid(ThreadContext context, IRubyObject recv2) {
        return RubyProcess.setsid(context.runtime);
    }

    public static IRubyObject setsid(Ruby runtime) {
        return runtime.newFixnum(RubyProcess.checkErrno(runtime, runtime.getPosix().setsid()));
    }

    @Deprecated
    public static IRubyObject setpgrp(IRubyObject recv2) {
        return RubyProcess.setpgrp(recv2.getRuntime());
    }

    @JRubyMethod(name={"setpgrp"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject setpgrp(ThreadContext context, IRubyObject recv2) {
        return RubyProcess.setpgrp(context.runtime);
    }

    public static IRubyObject setpgrp(Ruby runtime) {
        return runtime.newFixnum(RubyProcess.checkErrno(runtime, runtime.getPosix().setpgid(0, 0)));
    }

    @Deprecated
    public static IRubyObject egid_set(IRubyObject recv2, IRubyObject arg2) {
        return RubyProcess.egid_set(recv2.getRuntime(), arg2);
    }

    @JRubyMethod(name={"egid="}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject egid_set(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        return RubyProcess.egid_set(context.runtime, arg2);
    }

    public static IRubyObject egid_set(Ruby runtime, IRubyObject arg2) {
        RubyProcess.checkErrno(runtime, runtime.getPosix().setegid((int)arg2.convertToInteger().getLongValue()));
        return RubyFixnum.zero(runtime);
    }

    @Deprecated
    public static IRubyObject euid(IRubyObject recv2) {
        return RubyProcess.euid(recv2.getRuntime());
    }

    @JRubyMethod(name={"euid"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject euid(ThreadContext context, IRubyObject recv2) {
        return RubyProcess.euid(context.runtime);
    }

    public static IRubyObject euid(Ruby runtime) {
        return runtime.newFixnum(RubyProcess.checkErrno(runtime, runtime.getPosix().geteuid()));
    }

    @Deprecated
    public static IRubyObject uid_set(IRubyObject recv2, IRubyObject arg2) {
        return RubyProcess.uid_set(recv2.getRuntime(), arg2);
    }

    @JRubyMethod(name={"uid="}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject uid_set(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        return RubyProcess.uid_set(context.runtime, arg2);
    }

    public static IRubyObject uid_set(Ruby runtime, IRubyObject arg2) {
        RubyProcess.checkErrno(runtime, runtime.getPosix().setuid((int)arg2.convertToInteger().getLongValue()));
        return RubyFixnum.zero(runtime);
    }

    @Deprecated
    public static IRubyObject gid(IRubyObject recv2) {
        return RubyProcess.gid(recv2.getRuntime());
    }

    @JRubyMethod(name={"gid"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject gid(ThreadContext context, IRubyObject recv2) {
        return RubyProcess.gid(context.runtime);
    }

    public static IRubyObject gid(Ruby runtime) {
        if (Platform.IS_WINDOWS) {
            return RubyFixnum.zero(runtime);
        }
        return runtime.newFixnum(RubyProcess.checkErrno(runtime, runtime.getPosix().getgid()));
    }

    @JRubyMethod(name={"maxgroups"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject maxgroups(IRubyObject recv2) {
        throw recv2.getRuntime().newNotImplementedError("Process#maxgroups not yet implemented");
    }

    @Deprecated
    public static IRubyObject getpriority(IRubyObject recv2, IRubyObject arg1, IRubyObject arg2) {
        return RubyProcess.getpriority(recv2.getRuntime(), arg1, arg2);
    }

    @JRubyMethod(name={"getpriority"}, required=2, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject getpriority(ThreadContext context, IRubyObject recv2, IRubyObject arg1, IRubyObject arg2) {
        return RubyProcess.getpriority(context.runtime, arg1, arg2);
    }

    public static IRubyObject getpriority(Ruby runtime, IRubyObject arg1, IRubyObject arg2) {
        int which = (int)arg1.convertToInteger().getLongValue();
        int who = (int)arg2.convertToInteger().getLongValue();
        int result2 = RubyProcess.checkErrno(runtime, runtime.getPosix().getpriority(which, who));
        return runtime.newFixnum(result2);
    }

    @Deprecated
    public static IRubyObject uid(IRubyObject recv2) {
        return RubyProcess.uid(recv2.getRuntime());
    }

    @JRubyMethod(name={"uid"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject uid(ThreadContext context, IRubyObject recv2) {
        return RubyProcess.uid(context.runtime);
    }

    public static IRubyObject uid(Ruby runtime) {
        return runtime.newFixnum(RubyProcess.checkErrno(runtime, runtime.getPosix().getuid()));
    }

    @JRubyMethod(name={"waitpid2"}, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject waitpid2(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        IRubyObject pid2 = RubyProcess.waitpid(context, recv2, args2);
        if (pid2.isNil()) {
            return pid2;
        }
        return context.runtime.newArray(pid2, context.getLastExitStatus());
    }

    public static IRubyObject waitpid2(Ruby runtime, IRubyObject[] args2) {
        return RubyProcess.waitpid2(runtime.getCurrentContext(), runtime.getProcess(), args2);
    }

    @JRubyMethod(name={"initgroups"}, required=2, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject initgroups(IRubyObject recv2, IRubyObject arg1, IRubyObject arg2) {
        throw recv2.getRuntime().newNotImplementedError("Process#initgroups not yet implemented");
    }

    @JRubyMethod(name={"maxgroups="}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject maxgroups_set(IRubyObject recv2, IRubyObject arg2) {
        throw recv2.getRuntime().newNotImplementedError("Process#maxgroups_set not yet implemented");
    }

    @Deprecated
    public static IRubyObject ppid(IRubyObject recv2) {
        return RubyProcess.ppid(recv2.getRuntime());
    }

    @JRubyMethod(name={"ppid"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject ppid(ThreadContext context, IRubyObject recv2) {
        return RubyProcess.ppid(context.runtime);
    }

    public static IRubyObject ppid(Ruby runtime) {
        int result2 = RubyProcess.checkErrno(runtime, runtime.getPosix().getppid());
        return runtime.newFixnum(result2);
    }

    @Deprecated
    public static IRubyObject gid_set(IRubyObject recv2, IRubyObject arg2) {
        return RubyProcess.gid_set(recv2.getRuntime(), arg2);
    }

    @JRubyMethod(name={"gid="}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject gid_set(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        return RubyProcess.gid_set(context.runtime, arg2);
    }

    public static IRubyObject gid_set(Ruby runtime, IRubyObject arg2) {
        int result2 = RubyProcess.checkErrno(runtime, runtime.getPosix().setgid((int)arg2.convertToInteger().getLongValue()));
        return runtime.newFixnum(result2);
    }

    @Deprecated
    public static IRubyObject wait2(IRubyObject recv2, IRubyObject[] args2) {
        return RubyProcess.waitpid2(recv2.getRuntime(), args2);
    }

    @JRubyMethod(name={"wait2"}, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject wait2(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyProcess.waitpid2(context.runtime, args2);
    }

    @Deprecated
    public static IRubyObject euid_set(IRubyObject recv2, IRubyObject arg2) {
        return RubyProcess.euid_set(recv2.getRuntime(), arg2);
    }

    @JRubyMethod(name={"euid="}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject euid_set(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        return RubyProcess.euid_set(context.runtime, arg2);
    }

    public static IRubyObject euid_set(Ruby runtime, IRubyObject arg2) {
        RubyProcess.checkErrno(runtime, runtime.getPosix().seteuid((int)arg2.convertToInteger().getLongValue()));
        return RubyFixnum.zero(runtime);
    }

    @Deprecated
    public static IRubyObject setpriority(IRubyObject recv2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        return RubyProcess.setpriority(recv2.getRuntime(), arg1, arg2, arg3);
    }

    @JRubyMethod(name={"setpriority"}, required=3, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject setpriority(ThreadContext context, IRubyObject recv2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        return RubyProcess.setpriority(context.runtime, arg1, arg2, arg3);
    }

    public static IRubyObject setpriority(Ruby runtime, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        int which = (int)arg1.convertToInteger().getLongValue();
        int who = (int)arg2.convertToInteger().getLongValue();
        int prio = (int)arg3.convertToInteger().getLongValue();
        runtime.getPosix().errno(0);
        int result2 = RubyProcess.checkErrno(runtime, runtime.getPosix().setpriority(which, who, prio));
        return runtime.newFixnum(result2);
    }

    @Deprecated
    public static IRubyObject setpgid(IRubyObject recv2, IRubyObject arg1, IRubyObject arg2) {
        return RubyProcess.setpgid(recv2.getRuntime(), arg1, arg2);
    }

    @JRubyMethod(name={"setpgid"}, required=2, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject setpgid(ThreadContext context, IRubyObject recv2, IRubyObject arg1, IRubyObject arg2) {
        return RubyProcess.setpgid(context.runtime, arg1, arg2);
    }

    public static IRubyObject setpgid(Ruby runtime, IRubyObject arg1, IRubyObject arg2) {
        int pid2 = (int)arg1.convertToInteger().getLongValue();
        int gid2 = (int)arg2.convertToInteger().getLongValue();
        return runtime.newFixnum(RubyProcess.checkErrno(runtime, runtime.getPosix().setpgid(pid2, gid2)));
    }

    @Deprecated
    public static IRubyObject getpgid(IRubyObject recv2, IRubyObject arg2) {
        return RubyProcess.getpgid(recv2.getRuntime(), arg2);
    }

    @JRubyMethod(name={"getpgid"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject getpgid(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        return RubyProcess.getpgid(context.runtime, arg2);
    }

    public static IRubyObject getpgid(Ruby runtime, IRubyObject arg2) {
        return runtime.newFixnum(RubyProcess.checkErrno(runtime, runtime.getPosix().getpgid((int)arg2.convertToInteger().getLongValue())));
    }

    @Deprecated
    public static IRubyObject getrlimit(IRubyObject recv2, IRubyObject arg2) {
        return RubyProcess.getrlimit(recv2.getRuntime(), arg2);
    }

    @JRubyMethod(name={"getrlimit"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject getrlimit(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        return RubyProcess.getrlimit(context.runtime, arg2);
    }

    public static IRubyObject getrlimit(Ruby runtime, IRubyObject arg2) {
        if (!runtime.getPosix().isNative() || Platform.IS_WINDOWS) {
            runtime.getWarnings().warn("Process#getrlimit not supported on this platform");
            return runtime.newFixnum(Long.MAX_VALUE);
        }
        RLimit rlimit = runtime.getPosix().getrlimit(RubyProcess.rlimitResourceType(runtime, arg2));
        return runtime.newArray((IRubyObject)runtime.newFixnum(rlimit.rlimCur()), (IRubyObject)runtime.newFixnum(rlimit.rlimMax()));
    }

    @Deprecated
    public static IRubyObject egid(IRubyObject recv2) {
        return RubyProcess.egid(recv2.getRuntime());
    }

    @JRubyMethod(name={"egid"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject egid(ThreadContext context, IRubyObject recv2) {
        return RubyProcess.egid(context.runtime);
    }

    public static IRubyObject egid(Ruby runtime) {
        if (Platform.IS_WINDOWS) {
            return RubyFixnum.zero(runtime);
        }
        return runtime.newFixnum(RubyProcess.checkErrno(runtime, runtime.getPosix().getegid()));
    }

    private static int parseSignalString(Ruby runtime, String value2) {
        boolean negative = value2.startsWith("-");
        if (negative) {
            value2 = value2.substring(1);
        }
        String signalName = value2.startsWith("SIG") ? value2 : "SIG" + value2;
        try {
            int signalValue = Signal.valueOf((String)signalName).intValue();
            return negative ? -signalValue : signalValue;
        }
        catch (IllegalArgumentException ex) {
            throw runtime.newArgumentError("unsupported name `" + signalName + "'");
        }
    }

    @Deprecated
    public static IRubyObject kill(IRubyObject recv2, IRubyObject[] args2) {
        return RubyProcess.kill(recv2.getRuntime(), args2);
    }

    @JRubyMethod(name={"kill"}, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject kill(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyProcess.kill(context.runtime, args2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject kill(Ruby runtime, IRubyObject[] args2) {
        boolean processGroupKill;
        if (args2.length < 2) {
            throw runtime.newArgumentError("wrong number of arguments -- kill(sig, pid...)");
        }
        int signal2 = args2[0] instanceof RubyFixnum ? (int)((RubyFixnum)args2[0]).getLongValue() : (args2[0] instanceof RubySymbol ? RubyProcess.parseSignalString(runtime, args2[0].toString()) : (args2[0] instanceof RubyString ? RubyProcess.parseSignalString(runtime, args2[0].toString()) : RubyProcess.parseSignalString(runtime, args2[0].checkStringType().toString())));
        boolean bl = processGroupKill = signal2 < 0;
        if (processGroupKill) {
            if (Platform.IS_WINDOWS) {
                throw runtime.newErrnoEINVALError("group signals not implemented in windows");
            }
            signal2 = -signal2;
        }
        if (Platform.IS_WINDOWS) {
            for (int i2 = 1; i2 < args2.length; ++i2) {
                IntByReference status2;
                Pointer ptr;
                int pid2 = RubyNumeric.num2int(args2[i2]);
                if (signal2 == 0) {
                    ptr = WindowsFFI.kernel32().OpenProcess(1024, 0, pid2);
                    if (ptr != null && ptr.address() != -1L) {
                        try {
                            status2 = new IntByReference(0);
                            if (WindowsFFI.kernel32().GetExitCodeProcess(ptr, status2) == 0) {
                                throw runtime.newErrnoEPERMError("unable to call GetExitCodeProcess " + pid2);
                            }
                            if (status2.intValue() == 259) continue;
                            throw runtime.newErrnoEPERMError("Process exists but is not alive anymore " + pid2);
                        }
                        finally {
                            WindowsFFI.kernel32().CloseHandle(ptr);
                        }
                    }
                    if (WindowsFFI.kernel32().GetLastError() == 87) {
                        throw runtime.newErrnoESRCHError();
                    }
                    throw runtime.newErrnoEPERMError("Process does not exist " + pid2);
                }
                if (signal2 == 9) {
                    ptr = WindowsFFI.kernel32().OpenProcess(1025, 0, pid2);
                    if (ptr != null && ptr.address() != -1L) {
                        try {
                            status2 = new IntByReference(0);
                            if (WindowsFFI.kernel32().GetExitCodeProcess(ptr, status2) == 0) {
                                throw runtime.newErrnoEPERMError("unable to call GetExitCodeProcess " + pid2);
                            }
                            if (status2.intValue() != 259 || WindowsFFI.kernel32().TerminateProcess(ptr, 0) != 0) continue;
                            throw runtime.newErrnoEPERMError("unable to call TerminateProcess " + pid2);
                        }
                        finally {
                            WindowsFFI.kernel32().CloseHandle(ptr);
                        }
                    }
                    if (WindowsFFI.kernel32().GetLastError() == 87) {
                        throw runtime.newErrnoESRCHError();
                    }
                    throw runtime.newErrnoEPERMError("Process does not exist " + pid2);
                }
                throw runtime.newNotImplementedError("this signal not yet implemented in windows");
            }
        } else {
            POSIX posix = runtime.getPosix();
            for (int i3 = 1; i3 < args2.length; ++i3) {
                int pid3 = RubyNumeric.num2int(args2[i3]);
                if (pid3 == 0) {
                    pid3 = runtime.getPosix().getpid();
                }
                RubyProcess.checkErrno(runtime, posix.kill(processGroupKill ? -pid3 : pid3, signal2));
            }
        }
        return runtime.newFixnum(args2.length - 1);
    }

    @JRubyMethod(name={"detach"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject detach(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        final int pid2 = (int)arg2.convertToInteger().getLongValue();
        Ruby runtime = context.runtime;
        BlockCallback callback = new BlockCallback(){

            @Override
            public IRubyObject call(ThreadContext context, IRubyObject[] args2, Block block) {
                int[] status2 = new int[1];
                Ruby runtime = context.runtime;
                int result2 = RubyProcess.checkErrno(runtime, runtime.getPosix().waitpid(pid2, status2, 0));
                return RubyStatus.newProcessStatus(runtime, status2[0], pid2);
            }
        };
        return RubyThread.newInstance(runtime.getThread(), IRubyObject.NULL_ARRAY, CallBlock.newCallClosure(recv2, (RubyModule)recv2, Signature.NO_ARGUMENTS, callback, context));
    }

    @Deprecated
    public static IRubyObject times(IRubyObject recv2, Block unusedBlock) {
        return RubyProcess.times(recv2.getRuntime());
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject times(ThreadContext context, IRubyObject recv2, Block unusedBlock) {
        return RubyProcess.times(context.runtime);
    }

    public static IRubyObject times(Ruby runtime) {
        Times tms = runtime.getPosix().times();
        double utime2 = 0.0;
        double stime = 0.0;
        double cutime = 0.0;
        double cstime = 0.0;
        if (tms == null) {
            ThreadMXBean bean = ManagementFactory.getThreadMXBean();
            if (bean.isCurrentThreadCpuTimeSupported()) {
                cutime = utime2 = (double)bean.getCurrentThreadUserTime();
                cstime = stime = (double)(bean.getCurrentThreadCpuTime() - bean.getCurrentThreadUserTime());
            }
        } else {
            utime2 = tms.utime();
            stime = tms.stime();
            cutime = tms.cutime();
            cstime = tms.cstime();
        }
        long hz = runtime.getPosix().sysconf(Sysconf._SC_CLK_TCK);
        if (hz == -1L) {
            hz = 60L;
        }
        return RubyStruct.newStruct(runtime.getTmsStruct(), new IRubyObject[]{runtime.newFloat(utime2 / (double)hz), runtime.newFloat(stime / (double)hz), runtime.newFloat(cutime / (double)hz), runtime.newFloat(cstime / (double)hz)}, Block.NULL_BLOCK);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject clock_gettime(ThreadContext context, IRubyObject self2, IRubyObject _clock_id) {
        Ruby runtime = context.runtime;
        return RubyProcess.makeClockResult(runtime, RubyProcess.getTimeForClock(_clock_id, runtime), CLOCK_UNIT_FLOAT_SECOND);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject clock_gettime(ThreadContext context, IRubyObject self2, IRubyObject _clock_id, IRubyObject _unit) {
        Ruby runtime = context.runtime;
        if (!(_unit instanceof RubySymbol) && !_unit.isNil()) {
            throw runtime.newArgumentError("unexpected unit: " + _unit);
        }
        return RubyProcess.makeClockResult(runtime, RubyProcess.getTimeForClock(_clock_id, runtime), _unit.toString());
    }

    @JRubyMethod(rest=true, meta=true)
    public static IRubyObject exec(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        return RubyKernel.exec(context, self2, args2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static long getTimeForClock(IRubyObject _clock_id, Ruby runtime) throws RaiseException {
        if (!(_clock_id instanceof RubySymbol)) throw runtime.newErrnoEINVALError("clock_gettime");
        if (_clock_id.toString().equals(CLOCK_MONOTONIC)) {
            return System.nanoTime();
        }
        if (!_clock_id.toString().equals(CLOCK_REALTIME)) throw runtime.newErrnoEINVALError("clock_gettime");
        return System.currentTimeMillis() * 1000000L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static long getResolutionForClock(IRubyObject _clock_id, Ruby runtime) throws RaiseException {
        if (!(_clock_id instanceof RubySymbol)) throw runtime.newErrnoEINVALError("clock_gettime");
        if (_clock_id.toString().equals(CLOCK_MONOTONIC)) {
            return 1L;
        }
        if (!_clock_id.toString().equals(CLOCK_REALTIME)) throw runtime.newErrnoEINVALError("clock_gettime");
        return 1000000L;
    }

    private static IRubyObject makeClockResult(Ruby runtime, long nanos, String unit) {
        if (unit.equals(CLOCK_UNIT_NANOSECOND)) {
            return runtime.newFixnum(nanos);
        }
        if (unit.equals(CLOCK_UNIT_MICROSECOND)) {
            return runtime.newFixnum(nanos / 1000L);
        }
        if (unit.equals(CLOCK_UNIT_MILLISECOND)) {
            return runtime.newFixnum(nanos / 1000000L);
        }
        if (unit.equals(CLOCK_UNIT_SECOND)) {
            return runtime.newFixnum(nanos / 1000000000L);
        }
        if (unit.equals(CLOCK_UNIT_FLOAT_MICROSECOND)) {
            return runtime.newFloat((double)nanos / 1000.0);
        }
        if (unit.equals(CLOCK_UNIT_FLOAT_MILLISECOND)) {
            return runtime.newFloat((double)nanos / 1000000.0);
        }
        if (unit.equals(CLOCK_UNIT_FLOAT_SECOND) || unit.equals("")) {
            return runtime.newFloat((double)nanos / 1.0E9);
        }
        throw runtime.newArgumentError("unexpected unit: " + unit);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject clock_getres(ThreadContext context, IRubyObject self2, IRubyObject _clock_id) {
        Ruby runtime = context.runtime;
        return RubyProcess.makeClockResolutionResult(runtime, RubyProcess.getResolutionForClock(_clock_id, runtime), CLOCK_UNIT_FLOAT_SECOND);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject clock_getres(ThreadContext context, IRubyObject self2, IRubyObject _clock_id, IRubyObject _unit) {
        Ruby runtime = context.runtime;
        if (!(_unit instanceof RubySymbol) && !_unit.isNil()) {
            throw runtime.newArgumentError("unexpected unit: " + _unit);
        }
        return RubyProcess.makeClockResolutionResult(runtime, RubyProcess.getResolutionForClock(_clock_id, runtime), _unit.toString());
    }

    private static IRubyObject makeClockResolutionResult(Ruby runtime, long nanos, String unit) {
        if (unit.equals(CLOCK_UNIT_HERTZ)) {
            return runtime.newFloat(1.0E9 / (double)nanos);
        }
        return RubyProcess.makeClockResult(runtime, nanos, unit);
    }

    @Deprecated
    public static IRubyObject pid(IRubyObject recv2) {
        return RubyProcess.pid(recv2.getRuntime());
    }

    @JRubyMethod(name={"pid"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject pid(ThreadContext context, IRubyObject recv2) {
        return RubyProcess.pid(context.runtime);
    }

    public static IRubyObject pid(Ruby runtime) {
        return runtime.newFixnum(runtime.getPosix().getpid());
    }

    public static IRubyObject fork(ThreadContext context, IRubyObject recv2, Block block) {
        return RubyKernel.fork(context, recv2, block);
    }

    @JRubyMethod(name={"fork"}, module=true, visibility=Visibility.PRIVATE, notImplemented=true)
    public static IRubyObject fork19(ThreadContext context, IRubyObject recv2, Block block) {
        return RubyKernel.fork(context, recv2, block);
    }

    @JRubyMethod(rest=true, module=true, visibility=Visibility.PRIVATE)
    public static RubyFixnum spawn(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Ruby runtime = context.runtime;
        if (runtime.getPosix().isNative() && !Platform.IS_WINDOWS) {
            return PopenExecutor.spawn(context, args2);
        }
        return RubyFixnum.newFixnum(runtime, ShellLauncher.runExternalWithoutWait(runtime, args2));
    }

    @JRubyMethod(name={"exit"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject exit(IRubyObject recv2, IRubyObject[] args2) {
        return RubyKernel.exit(recv2, args2);
    }

    @JRubyMethod(name={"setproctitle"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject setproctitle(IRubyObject recv2, IRubyObject name2) {
        name2.convertToString();
        return name2;
    }

    public static void syswait(Ruby runtime, int pid2) {
        int[] status2 = new int[]{0};
        runtime.getPosix().waitpid(pid2, status2, 0);
    }

    private static int checkErrno(Ruby runtime, int result2) {
        return RubyProcess.checkErrno(runtime, result2, IGNORE);
    }

    private static int checkErrno(Ruby runtime, int result2, NonNativeErrno nonNative) {
        if (result2 == -1) {
            if (runtime.getPosix().isNative()) {
                RubyProcess.raiseErrnoIfSet(runtime, nonNative);
            } else {
                nonNative.handle(runtime, result2);
            }
        }
        return result2;
    }

    private static void raiseErrnoIfSet(Ruby runtime, NonNativeErrno nonNative) {
        if (runtime.getPosix().errno() != 0) {
            throw runtime.newErrnoFromInt(runtime.getPosix().errno());
        }
    }

    @Deprecated
    public static IRubyObject waitpid2(IRubyObject recv2, IRubyObject[] args2) {
        return RubyProcess.waitpid2(recv2.getRuntime(), args2);
    }

    private static interface NonNativeErrno {
        public int handle(Ruby var1, int var2);
    }

    @JRubyModule(name={"Process::Sys"})
    public static class Sys {
        @Deprecated
        public static IRubyObject getegid(IRubyObject self2) {
            return RubyProcess.egid(self2.getRuntime());
        }

        @JRubyMethod(name={"getegid"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject getegid(ThreadContext context, IRubyObject self2) {
            return RubyProcess.egid(context.runtime);
        }

        @Deprecated
        public static IRubyObject geteuid(IRubyObject self2) {
            return RubyProcess.euid(self2.getRuntime());
        }

        @JRubyMethod(name={"geteuid"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject geteuid(ThreadContext context, IRubyObject self2) {
            return RubyProcess.euid(context.runtime);
        }

        @Deprecated
        public static IRubyObject getgid(IRubyObject self2) {
            return RubyProcess.gid(self2.getRuntime());
        }

        @JRubyMethod(name={"getgid"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject getgid(ThreadContext context, IRubyObject self2) {
            return RubyProcess.gid(context.runtime);
        }

        @Deprecated
        public static IRubyObject getuid(IRubyObject self2) {
            return RubyProcess.uid(self2.getRuntime());
        }

        @JRubyMethod(name={"getuid"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject getuid(ThreadContext context, IRubyObject self2) {
            return RubyProcess.uid(context.runtime);
        }

        @Deprecated
        public static IRubyObject setegid(IRubyObject recv2, IRubyObject arg2) {
            return RubyProcess.egid_set(recv2.getRuntime(), arg2);
        }

        @JRubyMethod(name={"setegid"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject setegid(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
            return RubyProcess.egid_set(context.runtime, arg2);
        }

        @Deprecated
        public static IRubyObject seteuid(IRubyObject recv2, IRubyObject arg2) {
            return RubyProcess.euid_set(recv2.getRuntime(), arg2);
        }

        @JRubyMethod(name={"seteuid"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject seteuid(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
            return RubyProcess.euid_set(context.runtime, arg2);
        }

        @Deprecated
        public static IRubyObject setgid(IRubyObject recv2, IRubyObject arg2) {
            return RubyProcess.gid_set(recv2.getRuntime(), arg2);
        }

        @JRubyMethod(name={"setgid"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject setgid(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
            return RubyProcess.gid_set(context.runtime, arg2);
        }

        @Deprecated
        public static IRubyObject setuid(IRubyObject recv2, IRubyObject arg2) {
            return RubyProcess.uid_set(recv2.getRuntime(), arg2);
        }

        @JRubyMethod(name={"setuid"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject setuid(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
            return RubyProcess.uid_set(context.runtime, arg2);
        }
    }

    @JRubyModule(name={"Process::GID"})
    public static class GroupID {
        @JRubyMethod(name={"change_privilege"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject change_privilege(IRubyObject self2, IRubyObject arg2) {
            throw self2.getRuntime().newNotImplementedError("Process::GID::change_privilege not implemented yet");
        }

        @Deprecated
        public static IRubyObject eid(IRubyObject self2) {
            return GroupID.eid(self2.getRuntime());
        }

        @JRubyMethod(name={"eid"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject eid(ThreadContext context, IRubyObject self2) {
            return GroupID.eid(context.runtime);
        }

        public static IRubyObject eid(Ruby runtime) {
            return RubyProcess.egid(runtime);
        }

        @Deprecated
        public static IRubyObject eid(IRubyObject self2, IRubyObject arg2) {
            return GroupID.eid(self2.getRuntime(), arg2);
        }

        @JRubyMethod(name={"eid="}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject eid(ThreadContext context, IRubyObject self2, IRubyObject arg2) {
            return GroupID.eid(context.runtime, arg2);
        }

        public static IRubyObject eid(Ruby runtime, IRubyObject arg2) {
            return RubyProcess.egid_set(runtime, arg2);
        }

        @JRubyMethod(name={"grant_privilege"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject grant_privilege(IRubyObject self2, IRubyObject arg2) {
            throw self2.getRuntime().newNotImplementedError("Process::GID::grant_privilege not implemented yet");
        }

        @JRubyMethod(name={"re_exchange"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject re_exchange(ThreadContext context, IRubyObject self2) {
            return GroupID.switch_rb(context, self2, Block.NULL_BLOCK);
        }

        @JRubyMethod(name={"re_exchangeable?"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject re_exchangeable_p(IRubyObject self2) {
            throw self2.getRuntime().newNotImplementedError("Process::GID::re_exchangeable? not implemented yet");
        }

        @Deprecated
        public static IRubyObject rid(IRubyObject self2) {
            return GroupID.rid(self2.getRuntime());
        }

        @JRubyMethod(name={"rid"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject rid(ThreadContext context, IRubyObject self2) {
            return GroupID.rid(context.runtime);
        }

        public static IRubyObject rid(Ruby runtime) {
            return RubyProcess.gid(runtime);
        }

        @JRubyMethod(name={"sid_available?"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject sid_available_p(IRubyObject self2) {
            throw self2.getRuntime().newNotImplementedError("Process::GID::sid_available not implemented yet");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod(name={"switch"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject switch_rb(ThreadContext context, IRubyObject self2, Block block) {
            Ruby runtime = context.runtime;
            int gid2 = RubyProcess.checkErrno(runtime, runtime.getPosix().getgid());
            int egid2 = RubyProcess.checkErrno(runtime, runtime.getPosix().getegid());
            if (block.isGiven()) {
                try {
                    RubyProcess.checkErrno(runtime, runtime.getPosix().setegid(gid2));
                    RubyProcess.checkErrno(runtime, runtime.getPosix().setgid(egid2));
                    IRubyObject iRubyObject = block.yield(context, runtime.getNil());
                    return iRubyObject;
                }
                finally {
                    RubyProcess.checkErrno(runtime, runtime.getPosix().setegid(egid2));
                    RubyProcess.checkErrno(runtime, runtime.getPosix().setgid(gid2));
                }
            }
            RubyProcess.checkErrno(runtime, runtime.getPosix().setegid(gid2));
            RubyProcess.checkErrno(runtime, runtime.getPosix().setgid(egid2));
            return RubyFixnum.zero(runtime);
        }
    }

    @JRubyModule(name={"Process::UID"})
    public static class UserID {
        @JRubyMethod(name={"change_privilege"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject change_privilege(IRubyObject self2, IRubyObject arg2) {
            throw self2.getRuntime().newNotImplementedError("Process::UID::change_privilege not implemented yet");
        }

        @Deprecated
        public static IRubyObject eid(IRubyObject self2) {
            return RubyProcess.euid(self2.getRuntime());
        }

        @JRubyMethod(name={"eid"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject eid(ThreadContext context, IRubyObject self2) {
            return RubyProcess.euid(context.runtime);
        }

        @Deprecated
        public static IRubyObject eid(IRubyObject self2, IRubyObject arg2) {
            return UserID.eid(self2.getRuntime(), arg2);
        }

        @JRubyMethod(name={"eid="}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject eid(ThreadContext context, IRubyObject self2, IRubyObject arg2) {
            return UserID.eid(context.runtime, arg2);
        }

        public static IRubyObject eid(Ruby runtime, IRubyObject arg2) {
            return RubyProcess.euid_set(runtime, arg2);
        }

        @JRubyMethod(name={"grant_privilege"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject grant_privilege(IRubyObject self2, IRubyObject arg2) {
            throw self2.getRuntime().newNotImplementedError("Process::UID::grant_privilege not implemented yet");
        }

        @JRubyMethod(name={"re_exchange"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject re_exchange(ThreadContext context, IRubyObject self2) {
            return UserID.switch_rb(context, self2, Block.NULL_BLOCK);
        }

        @JRubyMethod(name={"re_exchangeable?"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject re_exchangeable_p(IRubyObject self2) {
            throw self2.getRuntime().newNotImplementedError("Process::UID::re_exchangeable? not implemented yet");
        }

        @Deprecated
        public static IRubyObject rid(IRubyObject self2) {
            return UserID.rid(self2.getRuntime());
        }

        @JRubyMethod(name={"rid"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject rid(ThreadContext context, IRubyObject self2) {
            return UserID.rid(context.runtime);
        }

        public static IRubyObject rid(Ruby runtime) {
            return RubyProcess.uid(runtime);
        }

        @JRubyMethod(name={"sid_available?"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject sid_available_p(IRubyObject self2) {
            throw self2.getRuntime().newNotImplementedError("Process::UID::sid_available not implemented yet");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod(name={"switch"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject switch_rb(ThreadContext context, IRubyObject self2, Block block) {
            Ruby runtime = context.runtime;
            int uid2 = RubyProcess.checkErrno(runtime, runtime.getPosix().getuid());
            int euid2 = RubyProcess.checkErrno(runtime, runtime.getPosix().geteuid());
            if (block.isGiven()) {
                try {
                    RubyProcess.checkErrno(runtime, runtime.getPosix().seteuid(uid2));
                    RubyProcess.checkErrno(runtime, runtime.getPosix().setuid(euid2));
                    IRubyObject iRubyObject = block.yield(context, runtime.getNil());
                    return iRubyObject;
                }
                finally {
                    RubyProcess.checkErrno(runtime, runtime.getPosix().seteuid(euid2));
                    RubyProcess.checkErrno(runtime, runtime.getPosix().setuid(uid2));
                }
            }
            RubyProcess.checkErrno(runtime, runtime.getPosix().seteuid(uid2));
            RubyProcess.checkErrno(runtime, runtime.getPosix().setuid(euid2));
            return RubyFixnum.zero(runtime);
        }
    }

    @JRubyClass(name={"Process::Status"})
    public static class RubyStatus
    extends RubyObject {
        private final long status;
        private final long pid;
        private static final long EXIT_SUCCESS = 0L;

        public RubyStatus(Ruby runtime, RubyClass metaClass, long status2, long pid2) {
            super(runtime, metaClass);
            this.status = status2;
            this.pid = pid2;
        }

        public static RubyStatus newProcessStatus(Ruby runtime, long status2, long pid2) {
            return new RubyStatus(runtime, runtime.getProcStatus(), status2, pid2);
        }

        @JRubyMethod(name={"&"})
        public IRubyObject op_and(IRubyObject arg2) {
            return this.getRuntime().newFixnum(this.status & arg2.convertToInteger().getLongValue());
        }

        @JRubyMethod(name={"stopped?"})
        public IRubyObject stopped_p() {
            return RubyBoolean.newBoolean(this.getRuntime(), PosixShim.WAIT_MACROS.WIFSTOPPED(this.status));
        }

        @JRubyMethod(name={"signaled?"})
        public IRubyObject signaled() {
            return RubyBoolean.newBoolean(this.getRuntime(), PosixShim.WAIT_MACROS.WIFSIGNALED(this.status));
        }

        @JRubyMethod(name={"exited?"})
        public IRubyObject exited() {
            return RubyBoolean.newBoolean(this.getRuntime(), PosixShim.WAIT_MACROS.WIFEXITED(this.status));
        }

        @JRubyMethod(name={"stopsig"})
        public IRubyObject stopsig() {
            if (PosixShim.WAIT_MACROS.WIFSTOPPED(this.status)) {
                return RubyFixnum.newFixnum(this.getRuntime(), PosixShim.WAIT_MACROS.WSTOPSIG(this.status));
            }
            return this.getRuntime().getNil();
        }

        @JRubyMethod(name={"termsig"})
        public IRubyObject termsig() {
            if (PosixShim.WAIT_MACROS.WIFSIGNALED(this.status)) {
                return RubyFixnum.newFixnum(this.getRuntime(), PosixShim.WAIT_MACROS.WTERMSIG(this.status));
            }
            return this.getRuntime().getNil();
        }

        @JRubyMethod
        public IRubyObject exitstatus() {
            if (PosixShim.WAIT_MACROS.WIFEXITED(this.status)) {
                return this.getRuntime().newFixnum(PosixShim.WAIT_MACROS.WEXITSTATUS(this.status));
            }
            return this.getRuntime().getNil();
        }

        @JRubyMethod(name={">>"})
        public IRubyObject op_rshift(ThreadContext context, IRubyObject other) {
            return this.op_rshift(context.runtime, other);
        }

        @Override
        @JRubyMethod(name={"=="})
        public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
            Ruby runtime = context.runtime;
            if (this == other) {
                return runtime.getTrue();
            }
            return Helpers.invokedynamic(context, (IRubyObject)runtime.newFixnum(this.status), MethodNames.OP_EQUAL, other);
        }

        @JRubyMethod(name={"to_i"})
        public IRubyObject to_i(ThreadContext context) {
            return this.to_i(context.runtime);
        }

        @JRubyMethod
        public IRubyObject to_s(ThreadContext context) {
            return this.to_s(context.runtime);
        }

        @JRubyMethod
        public IRubyObject inspect(ThreadContext context) {
            return this.inspect(context.runtime);
        }

        @JRubyMethod(name={"success?"})
        public IRubyObject success_p(ThreadContext context) {
            if (!PosixShim.WAIT_MACROS.WIFEXITED(this.status)) {
                return context.nil;
            }
            return context.runtime.newBoolean((long)PosixShim.WAIT_MACROS.WEXITSTATUS(this.status) == 0L);
        }

        @JRubyMethod(name={"coredump?"})
        public IRubyObject coredump_p() {
            return RubyBoolean.newBoolean(this.getRuntime(), PosixShim.WAIT_MACROS.WCOREDUMP(this.status));
        }

        @JRubyMethod
        public IRubyObject pid(ThreadContext context) {
            return context.runtime.newFixnum(this.pid);
        }

        public long getStatus() {
            return this.status;
        }

        public IRubyObject op_rshift(Ruby runtime, IRubyObject other) {
            long shiftValue = other.convertToInteger().getLongValue();
            return runtime.newFixnum(this.status >> (int)shiftValue);
        }

        public IRubyObject to_i(Ruby runtime) {
            return runtime.newFixnum(this.status);
        }

        public IRubyObject to_s(Ruby runtime) {
            return runtime.newString(RubyStatus.pst_message("", this.pid, this.status));
        }

        @Override
        public IRubyObject to_s() {
            return this.to_s(this.getRuntime());
        }

        public IRubyObject inspect(Ruby runtime) {
            return runtime.newString(RubyStatus.pst_message("#<" + this.getMetaClass().getName() + ": ", this.pid, this.status) + ">");
        }

        private static String pst_message(String prefix, long pid2, long status2) {
            String signame2;
            StringBuilder sb = new StringBuilder(prefix);
            sb.append("pid ").append(pid2);
            if (PosixShim.WAIT_MACROS.WIFSTOPPED(status2)) {
                long stopsig2 = PosixShim.WAIT_MACROS.WSTOPSIG(status2);
                signame2 = RubySignal.signo2signm(stopsig2);
                if (signame2 != null) {
                    sb.append(" stopped ").append(signame2).append(" (signal ").append(stopsig2).append(")");
                } else {
                    sb.append(" stopped signal ").append(stopsig2);
                }
            }
            if (PosixShim.WAIT_MACROS.WIFSIGNALED(status2)) {
                long termsig2 = PosixShim.WAIT_MACROS.WTERMSIG(status2);
                signame2 = RubySignal.signo2signm(termsig2);
                if (signame2 != null) {
                    sb.append(" ").append(signame2).append(" (signal ").append(termsig2).append(")");
                } else {
                    sb.append(" signal ").append(termsig2);
                }
            }
            if (PosixShim.WAIT_MACROS.WIFEXITED(status2)) {
                sb.append(" exit ").append(PosixShim.WAIT_MACROS.WEXITSTATUS(status2));
            }
            if (PosixShim.WAIT_MACROS.WCOREDUMP(status2)) {
                sb.append(" (core dumped)");
            }
            return sb.toString();
        }

        @Override
        public IRubyObject inspect() {
            return this.inspect(this.getRuntime());
        }

        @Deprecated
        public IRubyObject op_rshift(IRubyObject other) {
            return this.op_rshift(this.getRuntime(), other);
        }

        @Deprecated
        public IRubyObject to_i() {
            return this.to_i(this.getRuntime());
        }
    }
}

