/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyEncoding;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.ast.util.SexpMaker;
import org.jruby.compiler.Compilable;
import org.jruby.compiler.JITCompilerMBean;
import org.jruby.compiler.NotCompilableException;
import org.jruby.internal.runtime.methods.CompiledIRMethod;
import org.jruby.internal.runtime.methods.MixedModeIRMethod;
import org.jruby.ir.IRClosure;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.ir.targets.JVMVisitor;
import org.jruby.ir.targets.JVMVisitorMethodContext;
import org.jruby.runtime.CompiledIRBlockBody;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.MixedModeIRBlockBody;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.threading.DaemonThreadFactory;
import org.jruby.util.JavaNameMangler;
import org.jruby.util.OneShotClassLoader;
import org.jruby.util.cli.Options;
import org.jruby.util.collections.IntHashMap;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class JITCompiler
implements JITCompilerMBean {
    private static final Logger LOG = LoggerFactory.getLogger(JITCompiler.class);
    public static final String RUBY_JIT_PREFIX = "rubyjit";
    public static final String CLASS_METHOD_DELIMITER = "$$";
    private final JITCounts counts = new JITCounts();
    private final ExecutorService executor;
    private final Ruby runtime;
    private final RubyInstanceConfig config;
    private static final MethodHandles.Lookup PUBLIC_LOOKUP = MethodHandles.publicLookup().in(Ruby.class);

    public JITCompiler(Ruby runtime) {
        this.runtime = runtime;
        this.config = runtime.getInstanceConfig();
        this.executor = new ThreadPoolExecutor(0, 2, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new DaemonThreadFactory("Ruby-" + runtime.getRuntimeNumber() + "-JIT", 1));
    }

    @Override
    public long getSuccessCount() {
        return this.counts.successCount.get();
    }

    @Override
    public long getCompileCount() {
        return this.counts.compiledCount.get();
    }

    @Override
    public long getFailCount() {
        return this.counts.failCount.get();
    }

    @Override
    public long getCompileTime() {
        return this.counts.compileTime.get() / 1000L;
    }

    @Override
    public long getAbandonCount() {
        return this.counts.abandonCount.get();
    }

    @Override
    public long getCodeSize() {
        return this.counts.codeSize.get();
    }

    @Override
    public long getAverageCodeSize() {
        return this.counts.averageCodeSize.get();
    }

    @Override
    public long getAverageCompileTime() {
        return this.counts.averageCompileTime.get() / 1000L;
    }

    @Override
    public long getLargestCodeSize() {
        return this.counts.largestCodeSize.get();
    }

    @Override
    public String[] getFrameAwareMethods() {
        Object[] frameAwareMethods = MethodIndex.FRAME_AWARE_METHODS.toArray(new String[0]);
        Arrays.sort(frameAwareMethods);
        return frameAwareMethods;
    }

    @Override
    public String[] getScopeAwareMethods() {
        Object[] scopeAwareMethods = MethodIndex.SCOPE_AWARE_METHODS.toArray(new String[0]);
        Arrays.sort(scopeAwareMethods);
        return scopeAwareMethods;
    }

    public void tearDown() {
        try {
            this.executor.shutdown();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public Runnable getTaskFor(ThreadContext context, Compilable method) {
        if (method instanceof MixedModeIRMethod) {
            return new MethodJITTask((MixedModeIRMethod)method, method.getClassName(context));
        }
        if (method instanceof MixedModeIRBlockBody) {
            return new BlockJITTask((MixedModeIRBlockBody)method, method.getClassName(context));
        }
        return new FullBuildTask(method);
    }

    public void buildThresholdReached(ThreadContext context, Compilable method) {
        RubyInstanceConfig config = context.runtime.getInstanceConfig();
        method.setCallCount(-1);
        Runnable jitTask = this.getTaskFor(context, method);
        if (config.getJitBackground() && config.getJitThreshold() > 0) {
            try {
                this.executor.submit(jitTask);
            }
            catch (RejectedExecutionException ree) {
                jitTask.run();
            }
        } else {
            method.ensureInstrsReady();
            jitTask.run();
        }
    }

    public static String getHashForString(String str) {
        return JITCompiler.getHashForBytes(RubyEncoding.encodeUTF8(str));
    }

    public static String getHashForBytes(byte[] bytes2) {
        try {
            MessageDigest sha1 = MessageDigest.getInstance("SHA1");
            sha1.update(bytes2);
            StringBuilder builder = new StringBuilder();
            for (byte aByte : sha1.digest()) {
                builder.append(Integer.toString((aByte & 0xFF) + 256, 16).substring(1));
            }
            return builder.toString().toUpperCase(Locale.ENGLISH);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException(nsae);
        }
    }

    static void log(RubyModule implementationClass, String file2, int line, String name2, String message2, String ... reason2) {
        String className;
        boolean isBlock = implementationClass == null;
        String string2 = className = isBlock ? "<block>" : implementationClass.getBaseName();
        if (className == null) {
            className = "<anon class>";
        }
        StringBuilder builder = new StringBuilder(32);
        builder.append(message2).append(": ").append(className).append(' ').append(name2 == null ? "" : name2).append(" at ").append(file2).append(':').append(line);
        if (reason2.length > 0) {
            builder.append(" because of: \"");
            for (String aReason : reason2) {
                builder.append(aReason);
            }
            builder.append('\"');
        }
        LOG.info(builder.toString(), new Object[0]);
    }

    public static class BlockJITClassGenerator {
        private final String packageName;
        private final String className;
        private final String methodName;
        private final String digestString;
        private final MixedModeIRBlockBody body;
        private final JVMVisitor visitor;
        private byte[] bytecode;
        private long compileTime;
        private final String name;

        public BlockJITClassGenerator(String className, String methodName, String key2, Ruby ruby2, MixedModeIRBlockBody body, JVMVisitor visitor) {
            this.packageName = JITCompiler.RUBY_JIT_PREFIX;
            this.digestString = RubyInstanceConfig.JAVA_VERSION == 51 || (Boolean)Options.COMPILE_INVOKEDYNAMIC.load() == true ? key2 + Math.abs(ruby2.hashCode()) : key2;
            this.className = this.packageName + '/' + className.replace('.', '/') + JITCompiler.CLASS_METHOD_DELIMITER + JavaNameMangler.mangleMethodName(methodName) + '_' + this.digestString;
            this.name = this.className.replace('/', '.');
            this.methodName = methodName;
            this.body = body;
            this.visitor = visitor;
        }

        protected void compile(JVMVisitorMethodContext context) {
            if (this.bytecode != null) {
                return;
            }
            long start2 = System.nanoTime();
            InterpreterContext ic = this.body.ensureInstrsReady();
            int insnCount = ic.getInstructions().length;
            if (insnCount > (Integer)Options.JIT_MAXSIZE.load()) {
                throw new NotCompilableException("Could not compile " + this.body + "; instruction count " + insnCount + " exceeds threshold of " + Options.JIT_MAXSIZE.load());
            }
            this.bytecode = this.visitor.compileToBytecode(this.body.getIRScope(), context);
            this.compileTime = System.nanoTime() - start2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updateCounters(JITCounts counts) {
            counts.compiledCount.incrementAndGet();
            counts.compileTime.addAndGet(this.compileTime);
            counts.codeSize.addAndGet(this.bytecode.length);
            counts.averageCompileTime.set(counts.compileTime.get() / counts.compiledCount.get());
            counts.averageCodeSize.set(counts.codeSize.get() / counts.compiledCount.get());
            JITCounts jITCounts = counts;
            synchronized (jITCounts) {
                if (counts.largestCodeSize.get() < (long)this.bytecode.length) {
                    counts.largestCodeSize.set(this.bytecode.length);
                }
            }
        }

        public void generate() {
            this.compile(new JVMVisitorMethodContext());
        }

        public byte[] bytecode() {
            return this.bytecode;
        }

        public String name() {
            return this.name;
        }

        public String toString() {
            return "{} at " + this.body.getFile() + ':' + this.body.getLine();
        }
    }

    public static class MethodJITClassGenerator {
        private final String packageName;
        private final String className;
        private final String methodName;
        private final String digestString;
        private final MixedModeIRMethod method;
        private final JVMVisitor visitor;
        private byte[] bytecode;
        private long compileTime;
        private final String name;

        public MethodJITClassGenerator(String className, String methodName, String key2, Ruby ruby2, MixedModeIRMethod method, JVMVisitor visitor) {
            this.packageName = JITCompiler.RUBY_JIT_PREFIX;
            this.digestString = RubyInstanceConfig.JAVA_VERSION == 51 || (Boolean)Options.COMPILE_INVOKEDYNAMIC.load() == true ? key2 + Math.abs(ruby2.hashCode()) : key2;
            this.className = this.packageName + '/' + className.replace('.', '/') + JITCompiler.CLASS_METHOD_DELIMITER + JavaNameMangler.mangleMethodName(methodName) + '_' + this.digestString;
            this.name = this.className.replace('/', '.');
            this.methodName = methodName;
            this.method = method;
            this.visitor = visitor;
        }

        protected void compile(JVMVisitorMethodContext context) {
            if (this.bytecode != null) {
                return;
            }
            long start2 = System.nanoTime();
            InterpreterContext ic = this.method.ensureInstrsReady();
            int insnCount = ic.getInstructions().length;
            if (insnCount > (Integer)Options.JIT_MAXSIZE.load()) {
                throw new NotCompilableException("Could not compile " + this.method + "; instruction count " + insnCount + " exceeds threshold of " + Options.JIT_MAXSIZE.load());
            }
            this.bytecode = this.visitor.compileToBytecode(this.method.getIRScope(), context);
            this.compileTime = System.nanoTime() - start2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updateCounters(JITCounts counts) {
            counts.compiledCount.incrementAndGet();
            counts.compileTime.addAndGet(this.compileTime);
            counts.codeSize.addAndGet(this.bytecode.length);
            counts.averageCompileTime.set(counts.compileTime.get() / counts.compiledCount.get());
            counts.averageCodeSize.set(counts.codeSize.get() / counts.compiledCount.get());
            JITCounts jITCounts = counts;
            synchronized (jITCounts) {
                if (counts.largestCodeSize.get() < (long)this.bytecode.length) {
                    counts.largestCodeSize.set(this.bytecode.length);
                }
            }
        }

        public void generate() {
            this.compile(new JVMVisitorMethodContext());
        }

        public byte[] bytecode() {
            return this.bytecode;
        }

        public String name() {
            return this.name;
        }

        public String toString() {
            return this.methodName + "() at " + this.method.getFile() + ':' + this.method.getLine();
        }
    }

    private class BlockJITTask
    implements Runnable {
        private final String className;
        private final MixedModeIRBlockBody body;
        private final String methodName;

        public BlockJITTask(MixedModeIRBlockBody body, String className) {
            this.body = body;
            this.className = className;
            this.methodName = body.getName();
        }

        @Override
        public void run() {
            try {
                String key2 = SexpMaker.sha1(this.body.getIRScope());
                JVMVisitor visitor = new JVMVisitor();
                BlockJITClassGenerator generator = new BlockJITClassGenerator(this.className, this.methodName, key2, JITCompiler.this.runtime, this.body, visitor);
                JVMVisitorMethodContext context = new JVMVisitorMethodContext();
                generator.compile(context);
                Class sourceClass = visitor.defineFromBytecode(this.body.getIRScope(), generator.bytecode(), new OneShotClassLoader(JITCompiler.this.runtime.getJRubyClassLoader()));
                if (sourceClass == null) {
                    JITCompiler.this.counts.failCount.incrementAndGet();
                    return;
                }
                generator.updateCounters(JITCompiler.this.counts);
                if (JITCompiler.this.config.isJitLogging()) {
                    JITCompiler.log(this.body.getImplementationClass(), this.body.getFile(), this.body.getLine(), this.className + "." + this.methodName, "done jitting", new String[0]);
                }
                String jittedName = context.getJittedName();
                this.body.completeBuild(new CompiledIRBlockBody(PUBLIC_LOOKUP.findStatic(sourceClass, jittedName, JVMVisitor.CLOSURE_SIGNATURE.type()), this.body.getIRScope(), ((IRClosure)this.body.getIRScope()).getSignature().encode()));
            }
            catch (Throwable t) {
                if (JITCompiler.this.config.isJitLogging()) {
                    JITCompiler.log(this.body.getImplementationClass(), this.body.getFile(), this.body.getLine(), this.className + "." + this.methodName, "Could not compile; passes run: " + this.body.getIRScope().getExecutedPasses(), t.getMessage());
                    if (JITCompiler.this.config.isJitLoggingVerbose()) {
                        t.printStackTrace();
                    }
                }
                JITCompiler.this.counts.failCount.incrementAndGet();
            }
        }
    }

    private class MethodJITTask
    implements Runnable {
        private final String className;
        private final MixedModeIRMethod method;
        private final String methodName;

        public MethodJITTask(MixedModeIRMethod method, String className) {
            this.method = method;
            this.className = className;
            this.methodName = method.getName();
        }

        @Override
        public void run() {
            try {
                if (JITCompiler.this.config.getExcludedMethods().size() > 0) {
                    IRubyObject possibleRealClass;
                    String excludeModuleName = this.className;
                    if (this.method.getImplementationClass().getMethodLocation().isSingleton() && (possibleRealClass = ((MetaClass)this.method.getImplementationClass()).getAttached()) instanceof RubyModule) {
                        excludeModuleName = "Meta:" + ((RubyModule)possibleRealClass).getName();
                    }
                    if (JITCompiler.this.config.getExcludedMethods().contains(excludeModuleName) || JITCompiler.this.config.getExcludedMethods().contains(excludeModuleName + '#' + this.methodName) || JITCompiler.this.config.getExcludedMethods().contains(this.methodName)) {
                        this.method.setCallCount(-1);
                        if (JITCompiler.this.config.isJitLogging()) {
                            JITCompiler.log(this.method.getImplementationClass(), this.method.getFile(), this.method.getLine(), this.methodName, "skipping method: " + excludeModuleName + '#' + this.methodName, new String[0]);
                        }
                        return;
                    }
                }
                String key2 = SexpMaker.sha1(this.method.getIRScope());
                JVMVisitor visitor = new JVMVisitor();
                MethodJITClassGenerator generator = new MethodJITClassGenerator(this.className, this.methodName, key2, JITCompiler.this.runtime, this.method, visitor);
                JVMVisitorMethodContext context = new JVMVisitorMethodContext();
                generator.compile(context);
                Class sourceClass = visitor.defineFromBytecode(this.method.getIRScope(), generator.bytecode(), new OneShotClassLoader(JITCompiler.this.runtime.getJRubyClassLoader()));
                if (sourceClass == null) {
                    JITCompiler.this.counts.failCount.incrementAndGet();
                    return;
                }
                generator.updateCounters(JITCompiler.this.counts);
                long methodCount = JITCompiler.this.counts.successCount.incrementAndGet();
                if (JITCompiler.this.config.getJitLogEvery() > 0 && methodCount % (long)JITCompiler.this.config.getJitLogEvery() == 0L) {
                    JITCompiler.log(this.method.getImplementationClass(), this.method.getFile(), this.method.getLine(), this.methodName, "live compiled methods: " + methodCount, new String[0]);
                }
                if (JITCompiler.this.config.isJitLogging()) {
                    JITCompiler.log(this.method.getImplementationClass(), this.method.getFile(), this.method.getLine(), this.className + '.' + this.methodName, "done jitting", new String[0]);
                }
                String jittedName = context.getJittedName();
                MethodHandle variable = PUBLIC_LOOKUP.findStatic(sourceClass, jittedName, context.getNativeSignature(-1));
                IntHashMap<MethodType> signatures = context.getNativeSignaturesExceptVariable();
                if (signatures.size() == 0) {
                    this.method.completeBuild(new CompiledIRMethod(variable, this.method.getIRScope(), this.method.getVisibility(), this.method.getImplementationClass(), this.method.getIRScope().receivesKeywordArgs()));
                } else {
                    Iterator<IntHashMap.Entry<MethodType>> iterator = signatures.entrySet().iterator();
                    if (iterator.hasNext()) {
                        IntHashMap.Entry<MethodType> entry = iterator.next();
                        this.method.completeBuild(new CompiledIRMethod(variable, PUBLIC_LOOKUP.findStatic(sourceClass, jittedName, entry.getValue()), entry.getKey(), this.method.getIRScope(), this.method.getVisibility(), this.method.getImplementationClass(), this.method.getIRScope().receivesKeywordArgs()));
                    }
                }
            }
            catch (Throwable t) {
                if (JITCompiler.this.config.isJitLogging()) {
                    JITCompiler.log(this.method.getImplementationClass(), this.method.getFile(), this.method.getLine(), this.className + '.' + this.methodName, "Could not compile; passes run: " + this.method.getIRScope().getExecutedPasses(), t.getMessage());
                    if (JITCompiler.this.config.isJitLoggingVerbose()) {
                        t.printStackTrace();
                    }
                }
                JITCompiler.this.counts.failCount.incrementAndGet();
            }
        }
    }

    private class FullBuildTask
    implements Runnable {
        private final Compilable<InterpreterContext> method;

        FullBuildTask(Compilable<InterpreterContext> method) {
            this.method = method;
        }

        @Override
        public void run() {
            block3: {
                try {
                    this.method.completeBuild(this.method.getIRScope().prepareFullBuild());
                    if (JITCompiler.this.config.isJitLogging()) {
                        JITCompiler.log(this.method.getImplementationClass(), this.method.getFile(), this.method.getLine(), this.method.getName(), "done building", new String[0]);
                    }
                }
                catch (Throwable t) {
                    if (!JITCompiler.this.config.isJitLogging()) break block3;
                    JITCompiler.log(this.method.getImplementationClass(), this.method.getFile(), this.method.getLine(), this.method.getName(), "Could not build; passes run: " + this.method.getIRScope().getExecutedPasses(), t.getMessage());
                    if (!JITCompiler.this.config.isJitLoggingVerbose()) break block3;
                    t.printStackTrace();
                }
            }
        }
    }

    public static class JITCounts {
        private final AtomicLong compiledCount = new AtomicLong(0L);
        private final AtomicLong successCount = new AtomicLong(0L);
        private final AtomicLong failCount = new AtomicLong(0L);
        private final AtomicLong abandonCount = new AtomicLong(0L);
        private final AtomicLong compileTime = new AtomicLong(0L);
        private final AtomicLong averageCompileTime = new AtomicLong(0L);
        private final AtomicLong codeSize = new AtomicLong(0L);
        private final AtomicLong averageCodeSize = new AtomicLong(0L);
        private final AtomicLong largestCodeSize = new AtomicLong(0L);
    }
}

