/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyArgsFile;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBignum;
import org.jruby.RubyBinding;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyContinuation;
import org.jruby.RubyEnumerator;
import org.jruby.RubyException;
import org.jruby.RubyFile;
import org.jruby.RubyFileTest;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyIO;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyProcess;
import org.jruby.RubyRandom;
import org.jruby.RubyRange;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.RubyThread;
import org.jruby.RubyTime;
import org.jruby.RubyUnboundMethod;
import org.jruby.RubyUncaughtThrowError;
import org.jruby.anno.FrameField;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.MainExitException;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.ir.interpreter.Interpreter;
import org.jruby.java.proxies.ConcreteJavaProxy;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.platform.Platform;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.backtrace.RubyStackTraceElement;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ArraySupport;
import org.jruby.util.ByteList;
import org.jruby.util.ConvertBytes;
import org.jruby.util.IdUtil;
import org.jruby.util.ShellLauncher;
import org.jruby.util.StringSupport;
import org.jruby.util.TypeConverter;
import org.jruby.util.cli.Options;
import org.jruby.util.io.OpenFile;
import org.jruby.util.io.PopenExecutor;

@JRubyModule(name={"Kernel"})
public class RubyKernel {
    private static EvalBinding evalBinding19 = new EvalBinding(){

        @Override
        public Binding convertToBinding(IRubyObject scope) {
            if (scope instanceof RubyBinding) {
                return ((RubyBinding)scope).getBinding().cloneForEval();
            }
            throw scope.getRuntime().newTypeError("wrong argument type " + scope.getMetaClass() + " (expected binding)");
        }
    };
    private static final byte[] uncaught_throw_p = new byte[]{117, 110, 99, 97, 117, 103, 104, 116, 32, 116, 104, 114, 111, 119, 32, 37, 112};

    public static RubyModule createKernelModule(Ruby runtime) {
        RubyModule module = runtime.defineModule("Kernel");
        runtime.setKernel(module);
        module.defineAnnotatedMethods(RubyKernel.class);
        module.setFlag(RubyModule.NEEDSIMPL_F, false);
        runtime.setPrivateMethodMissing(new MethodMissingMethod(module, Visibility.PRIVATE, CallType.NORMAL));
        runtime.setProtectedMethodMissing(new MethodMissingMethod(module, Visibility.PROTECTED, CallType.NORMAL));
        runtime.setVariableMethodMissing(new MethodMissingMethod(module, Visibility.PUBLIC, CallType.VARIABLE));
        runtime.setSuperMethodMissing(new MethodMissingMethod(module, Visibility.PUBLIC, CallType.SUPER));
        runtime.setNormalMethodMissing(new MethodMissingMethod(module, Visibility.PUBLIC, CallType.NORMAL));
        if (runtime.getInstanceConfig().isAssumeLoop()) {
            module.defineAnnotatedMethods(LoopMethods.class);
        }
        RubyKernel.recacheBuiltinMethods(runtime);
        return module;
    }

    static void recacheBuiltinMethods(Ruby runtime) {
        RubyModule module = runtime.getKernel();
        runtime.setRespondToMethod(module.searchMethod("respond_to?"));
        runtime.setRespondToMissingMethod(module.searchMethod("respond_to_missing?"));
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject at_exit(ThreadContext context, IRubyObject recv2, Block block) {
        return context.runtime.pushExitBlock(context.runtime.newProc(Block.Type.PROC, block));
    }

    @JRubyMethod(name={"autoload?"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject autoload_p(ThreadContext context, IRubyObject recv2, IRubyObject symbol) {
        Ruby runtime = context.runtime;
        RubyModule module = RubyKernel.getModuleForAutoload(runtime, recv2);
        RubyString file2 = module.getAutoloadFile(symbol.asJavaString());
        return file2 == null ? context.nil : file2;
    }

    @JRubyMethod(required=2, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject autoload(ThreadContext context, IRubyObject recv2, IRubyObject symbol, IRubyObject file2) {
        Ruby runtime = context.runtime;
        String nonInternedName = symbol.asJavaString();
        if (!IdUtil.isValidConstantName19(nonInternedName)) {
            throw runtime.newNameError("autoload must be constant name", nonInternedName);
        }
        final RubyString fileString = StringSupport.checkEmbeddedNulls(runtime, RubyFile.get_path(context, file2));
        if (fileString.isEmpty()) {
            throw runtime.newArgumentError("empty file name");
        }
        final String baseName = nonInternedName.intern();
        final RubyModule module = RubyKernel.getModuleForAutoload(runtime, recv2);
        IRubyObject existingValue = module.fetchConstant(baseName);
        if (existingValue != null && existingValue != RubyObject.UNDEF) {
            return context.nil;
        }
        module.defineAutoload(baseName, new RubyModule.AutoloadMethod(){

            @Override
            public RubyString getFile() {
                return fileString;
            }

            @Override
            public void load(Ruby runtime) {
                String file2 = this.getFile().asJavaString();
                if (runtime.getLoadService().autoloadRequire(file2)) {
                    module.finishAutoload(baseName);
                }
            }
        });
        return context.nil;
    }

    @Deprecated
    public static IRubyObject autoload(IRubyObject recv2, IRubyObject symbol, IRubyObject file2) {
        return RubyKernel.autoload(recv2.getRuntime().getCurrentContext(), recv2, symbol, file2);
    }

    static RubyModule getModuleForAutoload(Ruby runtime, IRubyObject recv2) {
        RubyModule module;
        RubyModule rubyModule = module = recv2 instanceof RubyModule ? (RubyModule)recv2 : recv2.getMetaClass().getRealClass();
        if (module == runtime.getKernel()) {
            module = runtime.getObject().getSingletonClass();
        }
        return module;
    }

    public static IRubyObject method_missing(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        Visibility lastVis = context.getLastVisibility();
        CallType lastCallType = context.getLastCallType();
        if (args2.length == 0 || !(args2[0] instanceof RubySymbol)) {
            throw context.runtime.newArgumentError("no id given");
        }
        return RubyKernel.methodMissingDirect(context, recv2, (RubySymbol)args2[0], lastVis, lastCallType, args2);
    }

    protected static IRubyObject methodMissingDirect(ThreadContext context, IRubyObject recv2, RubySymbol symbol, Visibility lastVis, CallType lastCallType, IRubyObject[] args2) {
        return RubyKernel.methodMissing(context, recv2, symbol.toString(), lastVis, lastCallType, args2, true);
    }

    public static IRubyObject methodMissing(ThreadContext context, IRubyObject recv2, String name2, Visibility lastVis, CallType lastCallType, IRubyObject[] args2) {
        return RubyKernel.methodMissing(context, recv2, name2, lastVis, lastCallType, args2, false);
    }

    public static IRubyObject methodMissing(ThreadContext context, IRubyObject recv2, String name2, Visibility lastVis, CallType lastCallType, IRubyObject[] args2, boolean dropFirst) {
        Ruby runtime = context.runtime;
        if (lastCallType != CallType.VARIABLE) {
            throw runtime.newNoMethodError(RubyKernel.getMethodMissingFormat(lastVis, lastCallType), recv2, name2, RubyArray.newArrayMayCopy(runtime, args2, dropFirst ? 1 : 0));
        }
        throw runtime.newNameError(RubyKernel.getMethodMissingFormat(lastVis, lastCallType), recv2, name2);
    }

    private static String getMethodMissingFormat(Visibility visibility, CallType callType) {
        String format = "undefined method `%s' for %s%s%s";
        if (visibility == Visibility.PRIVATE) {
            format = "private method `%s' called for %s%s%s";
        } else if (visibility == Visibility.PROTECTED) {
            format = "protected method `%s' called for %s%s%s";
        } else if (callType == CallType.VARIABLE) {
            format = "undefined local variable or method `%s' for %s%s%s";
        } else if (callType == CallType.SUPER) {
            format = "super: no superclass method `%s' for %s%s%s";
        }
        return format;
    }

    private static IRubyObject[] popenArgs(Ruby runtime, String pipedArg, IRubyObject[] args2) {
        RubyString command = runtime.newString(pipedArg.substring(1));
        if (args2.length >= 2) {
            return new IRubyObject[]{command, args2[1]};
        }
        return new IRubyObject[]{command};
    }

    public static IRubyObject open(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        return RubyKernel.open19(context, recv2, args2, block);
    }

    @JRubyMethod(name={"open"}, required=1, optional=3, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject open19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        Ruby runtime = context.runtime;
        boolean redirect = false;
        int argc = args2.length;
        if (argc >= 1) {
            if (args2[0].respondsTo("to_open")) {
                redirect = true;
            } else {
                IRubyObject tmp = args2[0];
                if ((tmp = RubyFile.get_path(context, tmp)).isNil()) {
                    redirect = true;
                } else {
                    IRubyObject cmd = PopenExecutor.checkPipeCommand(context, tmp);
                    if (!cmd.isNil()) {
                        args2[0] = cmd;
                        return PopenExecutor.popen(context, args2, runtime.getIO(), block);
                    }
                }
            }
        }
        if (redirect) {
            IRubyObject io2 = args2[0].callMethod(context, "to_open", Arrays.copyOfRange(args2, 1, args2.length));
            RubyIO.ensureYieldClose(context, io2, block);
            return io2;
        }
        return RubyIO.open(context, runtime.getFile(), args2, block);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject getc(ThreadContext context, IRubyObject recv2) {
        context.runtime.getWarnings().warn(IRubyWarnings.ID.DEPRECATED_METHOD, "getc is obsolete; use STDIN.getc instead");
        IRubyObject defin = context.runtime.getGlobalVariables().get("$stdin");
        return RubyKernel.sites((ThreadContext)context).getc.call(context, defin, defin);
    }

    @JRubyMethod(optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject gets(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Ruby runtime = context.runtime;
        IRubyObject argsFile = runtime.getArgsFile();
        if (recv2 == argsFile) {
            return RubyArgsFile.gets(context, argsFile, args2);
        }
        return RubyKernel.sites((ThreadContext)context).gets.call(context, argsFile, argsFile, args2);
    }

    @JRubyMethod(optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject abort(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Ruby runtime = context.runtime;
        RubyString message2 = null;
        if (args2.length == 1) {
            message2 = args2[0].convertToString();
            IRubyObject stderr = runtime.getGlobalVariables().get("$stderr");
            RubyKernel.sites((ThreadContext)context).puts.call(context, stderr, stderr, (IRubyObject)message2);
        }
        RubyKernel.exit(runtime, new IRubyObject[]{runtime.getFalse(), message2}, false);
        return runtime.getNil();
    }

    @JRubyMethod(name={"Array"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject new_array(ThreadContext context, IRubyObject recv2, IRubyObject object) {
        return TypeConverter.rb_Array(context, object);
    }

    @JRubyMethod(name={"Complex"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject new_complex(ThreadContext context, IRubyObject recv2) {
        RubyClass complex = context.runtime.getComplex();
        return RubyKernel.sites((ThreadContext)context).convert_complex.call(context, complex, complex);
    }

    @JRubyMethod(name={"Complex"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject new_complex(ThreadContext context, IRubyObject recv2, IRubyObject arg0) {
        RubyClass complex = context.runtime.getComplex();
        return RubyKernel.sites((ThreadContext)context).convert_complex.call(context, (IRubyObject)complex, (IRubyObject)complex, arg0);
    }

    @JRubyMethod(name={"Complex"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject new_complex(ThreadContext context, IRubyObject recv2, IRubyObject arg0, IRubyObject arg1) {
        RubyClass complex = context.runtime.getComplex();
        return RubyKernel.sites((ThreadContext)context).convert_complex.call(context, (IRubyObject)complex, (IRubyObject)complex, arg0, arg1);
    }

    @JRubyMethod(name={"Rational"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject new_rational(ThreadContext context, IRubyObject recv2) {
        RubyClass rational = context.runtime.getRational();
        return RubyKernel.sites((ThreadContext)context).convert_rational.call(context, rational, rational);
    }

    @JRubyMethod(name={"Rational"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject new_rational(ThreadContext context, IRubyObject recv2, IRubyObject arg0) {
        RubyClass rational = context.runtime.getRational();
        return RubyKernel.sites((ThreadContext)context).convert_rational.call(context, (IRubyObject)rational, (IRubyObject)rational, arg0);
    }

    @JRubyMethod(name={"Rational"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject new_rational(ThreadContext context, IRubyObject recv2, IRubyObject arg0, IRubyObject arg1) {
        RubyClass rational = context.runtime.getRational();
        return RubyKernel.sites((ThreadContext)context).convert_rational.call(context, (IRubyObject)rational, (IRubyObject)rational, arg0, arg1);
    }

    public static RubyFloat new_float(IRubyObject recv2, IRubyObject object) {
        return RubyKernel.new_float19(recv2, object);
    }

    @JRubyMethod(name={"Float"}, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat new_float19(IRubyObject recv2, IRubyObject object) {
        Ruby runtime = recv2.getRuntime();
        if (object instanceof RubyFixnum) {
            return RubyFloat.newFloat(runtime, ((RubyFixnum)object).getDoubleValue());
        }
        if (object instanceof RubyFloat) {
            return (RubyFloat)object;
        }
        if (object instanceof RubyBignum) {
            return RubyFloat.newFloat(runtime, RubyBignum.big2dbl((RubyBignum)object));
        }
        if (object instanceof RubyString) {
            if (((RubyString)object).getByteList().getRealSize() == 0) {
                throw runtime.newArgumentError("invalid value for Float(): " + object.inspect());
            }
            RubyString arg2 = (RubyString)object;
            if (arg2.toString().startsWith("0x")) {
                return ConvertBytes.byteListToInum19(runtime, arg2.getByteList(), 16, true).toFloat();
            }
            return RubyNumeric.str2fnum(runtime, arg2, true);
        }
        if (object.isNil()) {
            throw runtime.newTypeError("can't convert nil into Float");
        }
        ThreadContext context = runtime.getCurrentContext();
        JavaSites.KernelSites sites = RubyKernel.sites(context);
        return (RubyFloat)TypeConverter.convertToType19(context, object, runtime.getFloat(), sites.to_f_checked);
    }

    @JRubyMethod(name={"Hash"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject new_hash(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        Ruby runtime = context.runtime;
        if (arg2.isNil()) {
            return RubyHash.newHash(runtime);
        }
        IRubyObject tmp = TypeConverter.checkHashType(context, RubyKernel.sites((ThreadContext)context).to_hash_checked, arg2);
        if (tmp.isNil()) {
            if (arg2 instanceof RubyArray && ((RubyArray)arg2).isEmpty()) {
                return RubyHash.newHash(runtime);
            }
            throw runtime.newTypeError("can't convert " + arg2.getMetaClass() + " into Hash");
        }
        return tmp;
    }

    public static IRubyObject new_integer(ThreadContext context, IRubyObject recv2, IRubyObject object) {
        return RubyKernel.new_integer19(context, recv2, object);
    }

    @JRubyMethod(name={"Integer"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject new_integer19(ThreadContext context, IRubyObject recv2, IRubyObject object) {
        return RubyKernel.newIntegerCommon(context, object, 0);
    }

    @JRubyMethod(name={"Integer"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject new_integer19(ThreadContext context, IRubyObject recv2, IRubyObject object, IRubyObject base) {
        return RubyKernel.newIntegerCommon(context, object, RubyNumeric.num2int(base));
    }

    private static IRubyObject newIntegerCommon(ThreadContext context, IRubyObject object, int bs) {
        return TypeConverter.convertToInteger(context, object, bs);
    }

    public static IRubyObject new_string(ThreadContext context, IRubyObject recv2, IRubyObject object) {
        return RubyKernel.new_string19(context, recv2, object);
    }

    @JRubyMethod(name={"String"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject new_string19(ThreadContext context, IRubyObject recv2, IRubyObject object) {
        Ruby runtime = context.runtime;
        JavaSites.KernelSites sites = RubyKernel.sites(context);
        IRubyObject tmp = TypeConverter.checkStringType(context, sites.to_str_checked, object, runtime.getString());
        if (tmp.isNil()) {
            tmp = TypeConverter.convertToType19(context, object, runtime.getString(), RubyKernel.sites((ThreadContext)context).to_s_checked);
        }
        return tmp;
    }

    @JRubyMethod(rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject p(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Ruby runtime = context.runtime;
        int argc = args2.length;
        IRubyObject ret = context.nil;
        IRubyObject defout = runtime.getGlobalVariables().get("$>");
        IRubyObject defaultRS = context.runtime.getGlobalVariables().getDefaultSeparator();
        boolean defoutWriteBuiltin = defout instanceof RubyIO && defout.getMetaClass().isMethodBuiltin("write");
        for (int i2 = 0; i2 < argc; ++i2) {
            IRubyObject obj = args2[i2];
            IRubyObject str = RubyBasicObject.rbInspect(context, obj);
            if (defoutWriteBuiltin) {
                ((RubyIO)defout).write(context, str, true);
                ((RubyIO)defout).write(context, defaultRS, true);
                continue;
            }
            RubyIO.write(context, defout, str);
            RubyIO.write(context, defout, defaultRS);
        }
        if (argc == 1) {
            ret = args2[0];
        } else if (argc > 1) {
            ret = RubyArray.newArray(runtime, args2);
        }
        if (defout instanceof RubyIO) {
            ((RubyIO)defout).flush(context);
        }
        return ret;
    }

    @JRubyMethod(required=1, module=true)
    public static IRubyObject public_method(ThreadContext context, IRubyObject recv2, IRubyObject symbol) {
        return recv2.getMetaClass().newMethod(recv2, symbol.asJavaString(), true, Visibility.PUBLIC, true, false);
    }

    @JRubyMethod(required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject putc(ThreadContext context, IRubyObject recv2, IRubyObject ch) {
        IRubyObject defout = context.runtime.getGlobalVariables().get("$>");
        if (recv2 == defout) {
            return RubyIO.putc(context, recv2, ch);
        }
        return RubyKernel.sites((ThreadContext)context).putc.call(context, defout, defout, ch);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject puts(ThreadContext context, IRubyObject recv2) {
        IRubyObject defout = context.runtime.getGlobalVariables().get("$>");
        if (recv2 == defout) {
            return RubyIO.puts0(context, recv2);
        }
        return RubyKernel.sites((ThreadContext)context).puts.call(context, defout, defout);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject puts(ThreadContext context, IRubyObject recv2, IRubyObject arg0) {
        IRubyObject defout = context.runtime.getGlobalVariables().get("$>");
        if (recv2 == defout) {
            return RubyIO.puts1(context, recv2, arg0);
        }
        return RubyKernel.sites((ThreadContext)context).puts.call(context, defout, defout, arg0);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject puts(ThreadContext context, IRubyObject recv2, IRubyObject arg0, IRubyObject arg1) {
        IRubyObject defout = context.runtime.getGlobalVariables().get("$>");
        if (recv2 == defout) {
            return RubyIO.puts2(context, recv2, arg0, arg1);
        }
        return RubyKernel.sites((ThreadContext)context).puts.call(context, defout, defout, arg0, arg1);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject puts(ThreadContext context, IRubyObject recv2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        IRubyObject defout = context.runtime.getGlobalVariables().get("$>");
        if (recv2 == defout) {
            return RubyIO.puts3(context, recv2, arg0, arg1, arg2);
        }
        return RubyKernel.sites((ThreadContext)context).puts.call(context, defout, defout, arg0, arg1, arg2);
    }

    @JRubyMethod(rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject puts(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        IRubyObject defout = context.runtime.getGlobalVariables().get("$>");
        if (recv2 == defout) {
            return RubyIO.puts(context, recv2, args2);
        }
        return RubyKernel.sites((ThreadContext)context).puts.call(context, defout, defout, args2);
    }

    @JRubyMethod(rest=true, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE})
    public static IRubyObject print(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        RubyIO.print(context, context.runtime.getGlobalVariables().get("$>"), args2);
        return context.nil;
    }

    @JRubyMethod(rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject printf(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        IRubyObject out;
        if (args2.length == 0) {
            return context.nil;
        }
        if (args2[0] instanceof RubyString) {
            out = context.runtime.getGlobalVariables().get("$>");
        } else {
            out = args2[0];
            args2 = Arrays.copyOfRange(args2, 1, args2.length);
        }
        RubyIO.write(context, out, RubyKernel.sprintf(context, recv2, args2));
        return context.nil;
    }

    @JRubyMethod(optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject readline(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        IRubyObject line = RubyKernel.gets(context, recv2, args2);
        if (line.isNil()) {
            throw context.runtime.newEOFError();
        }
        return line;
    }

    @JRubyMethod(optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject readlines(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyArgsFile.readlines(context, context.runtime.getArgsFile(), args2);
    }

    @JRubyMethod(name={"respond_to_missing?"}, visibility=Visibility.PRIVATE)
    public static IRubyObject respond_to_missing_p(ThreadContext context, IRubyObject recv2, IRubyObject symbol) {
        return context.runtime.getFalse();
    }

    @JRubyMethod(name={"respond_to_missing?"}, visibility=Visibility.PRIVATE)
    public static IRubyObject respond_to_missing_p(ThreadContext context, IRubyObject recv2, IRubyObject symbol, IRubyObject isPrivate) {
        return context.runtime.getFalse();
    }

    private static RubyString getLastlineString(ThreadContext context, Ruby runtime) {
        IRubyObject line = context.getLastLine();
        if (line.isNil()) {
            throw runtime.newTypeError("$_ value need to be String (nil given).");
        }
        if (!(line instanceof RubyString)) {
            throw runtime.newTypeError("$_ value need to be String (" + line.getMetaClass().getName() + " given).");
        }
        return (RubyString)line;
    }

    @JRubyMethod(required=1, optional=3, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject select(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyIO.select(context, recv2, args2);
    }

    @JRubyMethod(optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject sleep(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        long loopStartTime;
        long milliseconds;
        if (args2.length == 0) {
            milliseconds = 0L;
        } else {
            milliseconds = (long)(RubyTime.convertTimeInterval(context, args2[0]) * 1000.0);
            if (milliseconds == 0L) {
                return context.runtime.newFixnum(0);
            }
        }
        long startTime = System.currentTimeMillis();
        RubyThread rubyThread = context.getThread();
        do {
            loopStartTime = System.currentTimeMillis();
            try {
                if (rubyThread.sleep(milliseconds)) continue;
                break;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while ((milliseconds -= System.currentTimeMillis() - loopStartTime) > 0L);
        return context.runtime.newFixnum(Math.round((double)(System.currentTimeMillis() - startTime) / 1000.0));
    }

    @JRubyMethod(optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject exit(IRubyObject recv2, IRubyObject[] args2) {
        RubyKernel.exit(recv2.getRuntime(), args2, false);
        return recv2.getRuntime().getNil();
    }

    @JRubyMethod(name={"exit!"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject exit_bang(IRubyObject recv2, IRubyObject[] args2) {
        RubyKernel.exit(recv2.getRuntime(), args2, true);
        return recv2.getRuntime().getNil();
    }

    private static void exit(Ruby runtime, IRubyObject[] args2, boolean hard) {
        int status2 = hard ? 1 : 0;
        String message2 = null;
        if (args2.length > 0) {
            RubyObject argument = (RubyObject)args2[0];
            status2 = argument instanceof RubyBoolean ? (argument.isFalse() ? 1 : 0) : RubyNumeric.fix2int(argument);
        }
        if (args2.length == 2 && args2[1] instanceof RubyString) {
            message2 = ((RubyString)args2[1]).toString();
        }
        if (hard) {
            if (!runtime.getInstanceConfig().isHardExit()) {
                throw new MainExitException(status2, true);
            }
        } else {
            if (message2 == null) {
                throw runtime.newSystemExit(status2);
            }
            throw runtime.newSystemExit(status2, message2);
        }
        System.exit(status2);
    }

    public static RubyArray global_variables(ThreadContext context, IRubyObject recv2) {
        return RubyKernel.global_variables19(context, recv2);
    }

    @JRubyMethod(name={"global_variables"}, module=true, visibility=Visibility.PRIVATE)
    public static RubyArray global_variables19(ThreadContext context, IRubyObject recv2) {
        Ruby runtime = context.runtime;
        RubyArray globalVariables = runtime.newArray();
        for (String globalVariableName : runtime.getGlobalVariables().getNames()) {
            globalVariables.append(runtime.newSymbol(globalVariableName));
        }
        return globalVariables;
    }

    public static RubyArray local_variables(ThreadContext context, IRubyObject recv2) {
        return RubyKernel.local_variables19(context, recv2);
    }

    @JRubyMethod(name={"local_variables"}, module=true, visibility=Visibility.PRIVATE)
    public static RubyArray local_variables19(ThreadContext context, IRubyObject recv2) {
        Ruby runtime = context.runtime;
        HashSet<String> encounteredLocalVariables = new HashSet<String>();
        RubyArray allLocalVariables = runtime.newArray();
        for (DynamicScope currentScope = context.getCurrentScope(); currentScope != null; currentScope = currentScope.getParentScope()) {
            for (String name2 : currentScope.getStaticScope().getVariables()) {
                if (!IdUtil.isLocal(name2) || encounteredLocalVariables.contains(name2)) continue;
                allLocalVariables.push(runtime.newSymbol(name2));
                encounteredLocalVariables.add(name2);
            }
        }
        return allLocalVariables;
    }

    public static RubyBinding binding(ThreadContext context, IRubyObject recv2, Block block) {
        return RubyKernel.binding19(context, recv2, block);
    }

    @JRubyMethod(name={"binding"}, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.JUMPTARGET, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE}, writes={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.JUMPTARGET, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE})
    public static RubyBinding binding19(ThreadContext context, IRubyObject recv2, Block block) {
        return RubyBinding.newBinding(context.runtime, context.currentBinding());
    }

    @JRubyMethod(name={"block_given?", "iterator?"}, module=true, visibility=Visibility.PRIVATE, reads={FrameField.BLOCK})
    public static RubyBoolean block_given_p(ThreadContext context, IRubyObject recv2) {
        return context.runtime.newBoolean(context.getCurrentFrame().getBlock().isGiven());
    }

    @Deprecated
    public static IRubyObject sprintf(IRubyObject recv2, IRubyObject[] args2) {
        return RubyKernel.sprintf(recv2.getRuntime().getCurrentContext(), recv2, args2);
    }

    @JRubyMethod(name={"sprintf", "format"}, required=1, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject sprintf(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        IRubyObject arg2;
        if (args2.length == 0) {
            throw context.runtime.newArgumentError("sprintf must have at least one argument");
        }
        RubyString str = RubyString.stringValue(args2[0]);
        if (args2.length == 2 && args2[1] instanceof RubyHash) {
            arg2 = args2[1];
        } else {
            RubyArray newArgs = RubyArray.newArrayMayCopy(context.runtime, args2);
            newArgs.shift(context);
            arg2 = newArgs;
        }
        return str.op_format(context, arg2);
    }

    @JRubyMethod(name={"raise", "fail"}, optional=3, module=true, visibility=Visibility.PRIVATE, omit=true)
    public static IRubyObject raise(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        RaiseException raise2;
        RubySymbol key2;
        RubyHash opt;
        IRubyObject last2;
        Ruby runtime = context.runtime;
        int argc = args2.length;
        IRubyObject cause2 = null;
        if (argc > 0 && (last2 = args2[argc - 1]) instanceof RubyHash && !(opt = (RubyHash)last2).isEmpty() && opt.has_key_p(key2 = runtime.newSymbol("cause")) == runtime.getTrue()) {
            cause2 = opt.delete(context, key2, Block.NULL_BLOCK);
            if (opt.isEmpty() && --argc == 0) {
                throw runtime.newArgumentError("only cause is given with no arguments");
            }
        }
        if (argc > 0 && cause2 == null) {
            cause2 = context.getErrorInfo();
        }
        RubyKernel.maybeRaiseJavaException(runtime, args2, argc, cause2);
        switch (argc) {
            case 0: {
                IRubyObject lastException = runtime.getGlobalVariables().get("$!");
                if (lastException.isNil()) {
                    raise2 = new RaiseException(runtime, runtime.getRuntimeError(), "", false);
                    break;
                }
                raise2 = new RaiseException((RubyException)lastException);
                break;
            }
            case 1: {
                if (args2[0] instanceof RubyString) {
                    raise2 = new RaiseException((RubyException)runtime.getRuntimeError().newInstance(context, args2, block));
                    break;
                }
                raise2 = new RaiseException(RubyKernel.convertToException(runtime, args2[0], null));
                break;
            }
            case 2: {
                raise2 = new RaiseException(RubyKernel.convertToException(runtime, args2[0], args2[1]));
                break;
            }
            default: {
                raise2 = new RaiseException(RubyKernel.convertToException(runtime, args2[0], args2[1]), args2[2]);
            }
        }
        if (runtime.isDebug()) {
            RubyKernel.printExceptionSummary(context, runtime, raise2.getException());
        }
        if (argc > 0 && raise2.getException().getCause() == RubyBasicObject.UNDEF) {
            raise2.getException().setCause(cause2);
        }
        throw raise2;
    }

    private static void maybeRaiseJavaException(Ruby runtime, IRubyObject[] args2, int argc, IRubyObject cause2) {
        JavaProxy exception2 = null;
        switch (argc) {
            case 0: {
                IRubyObject lastException = runtime.getGlobalVariables().get("$!");
                if (!(lastException instanceof ConcreteJavaProxy)) break;
                exception2 = (ConcreteJavaProxy)lastException;
                break;
            }
            case 1: {
                if (args2.length != 1 || !(args2[0] instanceof ConcreteJavaProxy)) break;
                exception2 = (ConcreteJavaProxy)args2[0];
            }
        }
        if (exception2 != null) {
            Object maybeThrowable = exception2.getObject();
            if (maybeThrowable instanceof Throwable) {
                Throwable ex = (Throwable)maybeThrowable;
                if (ex.getCause() == null && cause2 instanceof ConcreteJavaProxy && (maybeThrowable = ((ConcreteJavaProxy)cause2).getObject()) instanceof Throwable && ex != maybeThrowable) {
                    ex.initCause((Throwable)maybeThrowable);
                }
                Helpers.throwException(ex);
                return;
            }
            throw runtime.newTypeError("can't raise a non-Throwable Java object");
        }
    }

    private static RubyException convertToException(Ruby runtime, IRubyObject obj, IRubyObject optionalMessage) {
        if (!obj.respondsTo("exception")) {
            throw runtime.newTypeError("exception class/object expected");
        }
        IRubyObject exception2 = optionalMessage == null ? obj.callMethod(runtime.getCurrentContext(), "exception") : obj.callMethod(runtime.getCurrentContext(), "exception", optionalMessage);
        try {
            return (RubyException)exception2;
        }
        catch (ClassCastException cce) {
            throw runtime.newTypeError("exception object expected");
        }
    }

    private static void printExceptionSummary(ThreadContext context, Ruby runtime, RubyException rEx) {
        RubyStackTraceElement[] elements = rEx.getBacktraceElements();
        RubyStackTraceElement firstElement = elements.length > 0 ? elements[0] : new RubyStackTraceElement("", "", "(empty)", 0, false);
        String msg = String.format("Exception `%s' at %s:%s - %s\n", rEx.getMetaClass(), firstElement.getFileName(), firstElement.getLineNumber(), TypeConverter.convertToType(rEx, runtime.getString(), "to_s"));
        runtime.getErrorStream().print(msg);
    }

    public static IRubyObject require(IRubyObject recv2, IRubyObject name2, Block block) {
        return RubyKernel.require19(recv2.getRuntime().getCurrentContext(), recv2, name2, block);
    }

    @JRubyMethod(name={"require"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject require19(ThreadContext context, IRubyObject recv2, IRubyObject name2, Block block) {
        Ruby runtime = context.runtime;
        IRubyObject tmp = name2.checkStringType();
        if (!tmp.isNil()) {
            return RubyKernel.requireCommon(runtime, recv2, tmp, block);
        }
        return RubyKernel.requireCommon(runtime, recv2, RubyFile.get_path(context, name2), block);
    }

    private static IRubyObject requireCommon(Ruby runtime, IRubyObject recv2, IRubyObject name2, Block block) {
        RubyString path2 = StringSupport.checkEmbeddedNulls(runtime, name2);
        return runtime.newBoolean(runtime.getLoadService().require(path2.toString()));
    }

    public static IRubyObject load(IRubyObject recv2, IRubyObject[] args2, Block block) {
        return RubyKernel.load19(recv2.getRuntime().getCurrentContext(), recv2, args2, block);
    }

    @JRubyMethod(name={"load"}, required=1, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject load19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        Ruby runtime = context.runtime;
        RubyString path2 = StringSupport.checkEmbeddedNulls(runtime, RubyFile.get_path(context, args2[0]));
        return RubyKernel.loadCommon(path2, runtime, args2, block);
    }

    private static IRubyObject loadCommon(IRubyObject fileName, Ruby runtime, IRubyObject[] args2, Block block) {
        RubyString file2 = fileName.convertToString();
        boolean wrap2 = args2.length == 2 ? args2[1].isTrue() : false;
        runtime.getLoadService().load(file2.toString(), wrap2);
        return runtime.getTrue();
    }

    public static IRubyObject eval(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        return RubyKernel.eval19(context, recv2, args2, block);
    }

    @JRubyMethod(name={"eval"}, required=1, optional=3, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.JUMPTARGET, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE}, writes={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.JUMPTARGET, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE})
    public static IRubyObject eval19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        return RubyKernel.evalCommon(context, recv2, args2, evalBinding19);
    }

    private static IRubyObject evalCommon(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, EvalBinding evalBinding) {
        Binding binding2;
        RubyString src = args2[0].convertToString();
        boolean bindingGiven = args2.length > 1 && !args2[1].isNil();
        Binding binding3 = binding2 = bindingGiven ? evalBinding.convertToBinding(args2[1]) : context.currentBinding();
        if (args2.length > 2) {
            binding2.setFile(args2[2].convertToString().toString());
            if (args2.length > 3) {
                binding2.setLine((int)args2[3].convertToInteger().getLongValue() - 1);
            } else {
                binding2.setLine(0);
            }
        } else if (!bindingGiven) {
            binding2.setFile("(eval)");
            binding2.setLine(0);
        }
        String frameName = context.getFrameName();
        if (frameName != null) {
            binding2.setMethod(frameName);
        }
        if (bindingGiven) {
            recv2 = binding2.getSelf();
        }
        return Interpreter.evalWithBinding(context, recv2, src, binding2);
    }

    public static IRubyObject caller(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        return RubyKernel.caller20(context, recv2, args2, block);
    }

    public static IRubyObject caller19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        return RubyKernel.caller20(context, recv2, args2, block);
    }

    @JRubyMethod(name={"caller"}, optional=2, module=true, visibility=Visibility.PRIVATE, omit=true)
    public static IRubyObject caller20(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        Ruby runtime = context.runtime;
        Integer[] ll = RubyKernel.levelAndLengthFromArgs(runtime, args2, 1);
        Integer level2 = ll[0];
        Integer length2 = ll[1];
        return context.createCallerBacktrace(level2, length2, Thread.currentThread().getStackTrace());
    }

    @JRubyMethod(optional=2, module=true, visibility=Visibility.PRIVATE, omit=true)
    public static IRubyObject caller_locations(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Ruby runtime = context.runtime;
        Integer[] ll = RubyKernel.levelAndLengthFromArgs(runtime, args2, 1);
        Integer level2 = ll[0];
        Integer length2 = ll[1];
        return context.createCallerLocations(level2, length2, Thread.currentThread().getStackTrace());
    }

    static Integer[] levelAndLengthFromArgs(Ruby runtime, IRubyObject[] args2, int defaultLevel) {
        int level2;
        Integer length2 = null;
        if (args2.length > 1) {
            level2 = RubyNumeric.fix2int(args2[0]);
            length2 = RubyNumeric.fix2int(args2[1]);
        } else if (args2.length > 0 && args2[0] instanceof RubyRange) {
            RubyRange range = (RubyRange)args2[0];
            ThreadContext context = runtime.getCurrentContext();
            level2 = RubyNumeric.fix2int(range.first(context));
            length2 = RubyNumeric.fix2int(range.last(context)) - level2;
            if (!range.exclude_end_p().isTrue()) {
                Integer n = length2;
                Integer n2 = length2 = Integer.valueOf(length2 + 1);
            }
            length2 = length2 < 0 ? 0 : length2;
        } else {
            level2 = args2.length > 0 ? RubyNumeric.fix2int(args2[0]) : defaultLevel;
        }
        if (level2 < 0) {
            throw runtime.newArgumentError("negative level (" + level2 + ')');
        }
        if (length2 != null && length2 < 0) {
            throw runtime.newArgumentError("negative size (" + length2 + ')');
        }
        return new Integer[]{level2, length2};
    }

    public static IRubyObject rbCatch(ThreadContext context, IRubyObject recv2, IRubyObject tag2, Block block) {
        return RubyKernel.rbCatch19(context, recv2, tag2, block);
    }

    @JRubyMethod(name={"catch"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject rbCatch19(ThreadContext context, IRubyObject recv2, Block block) {
        RubyObject tag2 = new RubyObject(context.runtime.getObject());
        return RubyKernel.rbCatch19Common(context, tag2, block);
    }

    @JRubyMethod(name={"catch"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject rbCatch19(ThreadContext context, IRubyObject recv2, IRubyObject tag2, Block block) {
        return RubyKernel.rbCatch19Common(context, tag2, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IRubyObject rbCatch19Common(ThreadContext context, IRubyObject tag2, Block block) {
        RubyContinuation rbContinuation = new RubyContinuation(context.runtime, tag2);
        try {
            context.pushCatch(rbContinuation.getContinuation());
            IRubyObject iRubyObject = rbContinuation.enter(context, tag2, block);
            return iRubyObject;
        }
        finally {
            context.popCatch();
        }
    }

    public static IRubyObject rbThrow(ThreadContext context, IRubyObject recv2, IRubyObject tag2, Block block) {
        return RubyKernel.rbThrow19(context, recv2, tag2, block);
    }

    public static IRubyObject rbThrow(ThreadContext context, IRubyObject recv2, IRubyObject tag2, IRubyObject arg2, Block block) {
        return RubyKernel.rbThrow19(context, recv2, tag2, arg2, block);
    }

    @JRubyMethod(name={"throw"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject rbThrow19(ThreadContext context, IRubyObject recv2, IRubyObject tag2, Block block) {
        return RubyKernel.rbThrowInternal(context, tag2, null);
    }

    @JRubyMethod(name={"throw"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject rbThrow19(ThreadContext context, IRubyObject recv2, IRubyObject tag2, IRubyObject value2, Block block) {
        return RubyKernel.rbThrowInternal(context, tag2, value2);
    }

    private static IRubyObject rbThrowInternal(ThreadContext context, IRubyObject tag2, IRubyObject arg2) {
        Ruby runtime = context.runtime;
        runtime.getGlobalVariables().set("$!", context.nil);
        RubyContinuation.Continuation continuation = context.getActiveCatch(tag2);
        if (continuation != null) {
            IRubyObject[] iRubyObjectArray;
            if (arg2 == null) {
                iRubyObjectArray = IRubyObject.NULL_ARRAY;
            } else {
                IRubyObject[] iRubyObjectArray2 = new IRubyObject[1];
                iRubyObjectArray = iRubyObjectArray2;
                iRubyObjectArray2[0] = arg2;
            }
            continuation.args = iRubyObjectArray;
            throw continuation;
        }
        IRubyObject value2 = arg2 == null ? context.nil : arg2;
        throw RubyKernel.uncaughtThrow(runtime, tag2, value2, RubyString.newStringShared(runtime, uncaught_throw_p));
    }

    private static RaiseException uncaughtThrow(Ruby runtime, IRubyObject tag2, IRubyObject value2, RubyString message2) {
        return new RaiseException(RubyUncaughtThrowError.newUncaughtThrowError(runtime, tag2, value2, message2));
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject warn(ThreadContext context, IRubyObject recv2, IRubyObject message2) {
        Ruby runtime = context.runtime;
        if (runtime.warningsEnabled()) {
            IRubyObject out = runtime.getGlobalVariables().get("$stderr");
            RubyKernel.sites((ThreadContext)context).write.call(context, out, out, message2);
            RubyKernel.sites((ThreadContext)context).write.call(context, out, out, runtime.getGlobalVariables().getDefaultSeparator());
        }
        return context.nil;
    }

    @JRubyMethod(module=true, required=1, rest=true, visibility=Visibility.PRIVATE)
    public static IRubyObject warn(ThreadContext context, IRubyObject recv2, IRubyObject ... messages) {
        for (IRubyObject message2 : messages) {
            RubyKernel.warn(context, recv2, message2);
        }
        return context.nil;
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject set_trace_func(ThreadContext context, IRubyObject recv2, IRubyObject trace_func, Block block) {
        if (trace_func.isNil()) {
            context.runtime.setTraceFunction(null);
        } else {
            if (!(trace_func instanceof RubyProc)) {
                throw context.runtime.newTypeError("trace_func needs to be Proc.");
            }
            context.runtime.setTraceFunction((RubyProc)trace_func);
        }
        return trace_func;
    }

    @JRubyMethod(required=1, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject trace_var(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        RubyProc proc2 = null;
        String var = args2[0].toString();
        if (var.charAt(0) != '$') {
            return context.nil;
        }
        if (args2.length == 1) {
            proc2 = RubyProc.newProc(context.runtime, block, Block.Type.PROC);
        }
        if (args2.length == 2) {
            proc2 = (RubyProc)TypeConverter.convertToType(args2[1], context.runtime.getProc(), "to_proc", true);
        }
        context.runtime.getGlobalVariables().setTraceVar(var, proc2);
        return context.nil;
    }

    @JRubyMethod(required=1, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject untrace_var(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        if (args2.length == 0) {
            throw context.runtime.newArgumentError(0, 1);
        }
        String var = args2[0].toString();
        if (var.charAt(0) != '$') {
            return context.nil;
        }
        if (args2.length > 1) {
            ArrayList<IRubyObject> success = new ArrayList<IRubyObject>(args2.length);
            for (int i2 = 1; i2 < args2.length; ++i2) {
                if (!context.runtime.getGlobalVariables().untraceVar(var, args2[i2])) continue;
                success.add(args2[i2]);
            }
            return RubyArray.newArray(context.runtime, success);
        }
        context.runtime.getGlobalVariables().untraceVar(var);
        return context.nil;
    }

    @JRubyMethod(required=1, optional=1, reads={FrameField.VISIBILITY})
    public static IRubyObject define_singleton_method(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        if (args2.length == 0) {
            throw context.runtime.newArgumentError(0, 1);
        }
        RubyClass singleton_class2 = recv2.getSingletonClass();
        if (args2.length > 1) {
            RubyUnboundMethod method;
            RubyModule owner2;
            IRubyObject arg1 = args2[1];
            if (context.runtime.getUnboundMethod().isInstance(arg1) && (owner2 = (RubyModule)(method = (RubyUnboundMethod)arg1).owner(context)).isSingleton() && (!recv2.getMetaClass().isSingleton() || !recv2.getMetaClass().isKindOfModule(owner2))) {
                throw context.runtime.newTypeError("can't bind singleton method to a different class");
            }
            return singleton_class2.define_method(context, args2[0], args2[1], block);
        }
        return singleton_class2.define_method(context, args2[0], block);
    }

    @JRubyMethod(name={"proc"}, module=true, visibility=Visibility.PRIVATE)
    public static RubyProc proc(ThreadContext context, IRubyObject recv2, Block block) {
        return context.runtime.newProc(Block.Type.PROC, block);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static RubyProc lambda(ThreadContext context, IRubyObject recv2, Block block) {
        Block.Type type2 = block.type == Block.Type.PROC ? block.type : Block.Type.LAMBDA;
        return context.runtime.newProc(type2, block);
    }

    @Deprecated
    public static RubyProc proc_1_9(ThreadContext context, IRubyObject recv2, Block block) {
        return RubyKernel.proc(context, recv2, block);
    }

    @JRubyMethod(name={"loop"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject loop(ThreadContext context, IRubyObject recv2, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, recv2, "loop", RubyKernel.loopSizeFn(context));
        }
        Ruby runtime = context.runtime;
        IRubyObject oldExc = runtime.getGlobalVariables().get("$!");
        try {
            while (true) {
                block.yieldSpecific(context);
                context.pollThreadEvents();
            }
        }
        catch (RaiseException ex) {
            RubyClass StopIteration = runtime.getStopIteration();
            if (StopIteration.isInstance(ex.getException())) {
                runtime.getGlobalVariables().set("$!", oldExc);
                return ex.getException().callMethod("result");
            }
            throw ex;
        }
    }

    private static RubyEnumerator.SizeFn loopSizeFn(final ThreadContext context) {
        return new RubyEnumerator.SizeFn(){

            @Override
            public IRubyObject size(IRubyObject[] args2) {
                return RubyFloat.newFloat(context.runtime, Double.POSITIVE_INFINITY);
            }
        };
    }

    @JRubyMethod(required=2, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject test(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        if (args2.length == 0) {
            throw context.runtime.newArgumentError("wrong number of arguments");
        }
        int cmd = args2[0] instanceof RubyFixnum ? (int)((RubyFixnum)args2[0]).getLongValue() : (args2[0] instanceof RubyString && ((RubyString)args2[0]).getByteList().length() > 0 ? (int)((RubyString)args2[0]).getByteList().charAt(0) : (int)args2[0].convertToInteger().getLongValue());
        switch (cmd) {
            case 45: 
            case 60: 
            case 61: 
            case 62: 
            case 65: 
            case 67: 
            case 71: 
            case 77: 
            case 79: 
            case 82: 
            case 83: 
            case 87: 
            case 88: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 107: 
            case 108: 
            case 111: 
            case 112: 
            case 114: 
            case 115: 
            case 117: 
            case 119: 
            case 120: 
            case 122: {
                break;
            }
            default: {
                throw context.runtime.newArgumentError("unknown command ?" + (char)cmd);
            }
        }
        switch (cmd) {
            case 45: 
            case 60: 
            case 61: 
            case 62: {
                if (args2.length == 3) break;
                throw context.runtime.newArgumentError(args2.length, 3);
            }
            default: {
                if (args2.length == 2) break;
                throw context.runtime.newArgumentError(args2.length, 2);
            }
        }
        switch (cmd) {
            case 65: {
                return context.runtime.newFileStat(args2[1].convertToString().toString(), false).atime();
            }
            case 98: {
                return RubyFileTest.blockdev_p(recv2, args2[1]);
            }
            case 99: {
                return RubyFileTest.chardev_p(recv2, args2[1]);
            }
            case 67: {
                return context.runtime.newFileStat(args2[1].convertToString().toString(), false).ctime();
            }
            case 100: {
                return RubyFileTest.directory_p(recv2, args2[1]);
            }
            case 101: {
                return RubyFileTest.exist_p(recv2, args2[1]);
            }
            case 102: {
                return RubyFileTest.file_p(recv2, args2[1]);
            }
            case 103: {
                return RubyFileTest.setgid_p(recv2, args2[1]);
            }
            case 71: {
                return RubyFileTest.grpowned_p(recv2, args2[1]);
            }
            case 107: {
                return RubyFileTest.sticky_p(recv2, args2[1]);
            }
            case 77: {
                return context.runtime.newFileStat(args2[1].convertToString().toString(), false).mtime();
            }
            case 108: {
                return RubyFileTest.symlink_p(recv2, args2[1]);
            }
            case 111: {
                return RubyFileTest.owned_p(recv2, args2[1]);
            }
            case 79: {
                return RubyFileTest.rowned_p(recv2, args2[1]);
            }
            case 112: {
                return RubyFileTest.pipe_p(recv2, args2[1]);
            }
            case 114: {
                return RubyFileTest.readable_p(recv2, args2[1]);
            }
            case 82: {
                return RubyFileTest.readable_p(recv2, args2[1]);
            }
            case 115: {
                return RubyFileTest.size_p(recv2, args2[1]);
            }
            case 83: {
                return RubyFileTest.socket_p(recv2, args2[1]);
            }
            case 117: {
                return RubyFileTest.setuid_p(recv2, args2[1]);
            }
            case 119: {
                return RubyFileTest.writable_p(recv2, args2[1]);
            }
            case 87: {
                return RubyFileTest.writable_p(recv2, args2[1]);
            }
            case 120: {
                return RubyFileTest.executable_p(recv2, args2[1]);
            }
            case 88: {
                return RubyFileTest.executable_real_p(recv2, args2[1]);
            }
            case 122: {
                return RubyFileTest.zero_p(recv2, args2[1]);
            }
            case 61: {
                return context.runtime.newFileStat(args2[1].convertToString().toString(), false).mtimeEquals(args2[2]);
            }
            case 60: {
                return context.runtime.newFileStat(args2[1].convertToString().toString(), false).mtimeLessThan(args2[2]);
            }
            case 62: {
                return context.runtime.newFileStat(args2[1].convertToString().toString(), false).mtimeGreaterThan(args2[2]);
            }
            case 45: {
                return RubyFileTest.identical_p(recv2, args2[1], args2[2]);
            }
        }
        throw new InternalError("unreachable code reached!");
    }

    @JRubyMethod(name={"`"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject backquote(ThreadContext context, IRubyObject recv2, IRubyObject str) {
        long[] tuple;
        Ruby runtime = context.runtime;
        if (runtime.getPosix().isNative() && !Platform.IS_WINDOWS) {
            str = str.convertToString();
            context.setLastExitStatus(context.nil);
            IRubyObject port = PopenExecutor.pipeOpen(context, str, "r", 4097, null);
            if (port.isNil()) {
                return RubyString.newEmptyString(runtime);
            }
            OpenFile fptr = ((RubyIO)port).getOpenFileChecked();
            IRubyObject result2 = fptr.readAll(context, fptr.remainSize(), context.nil);
            ((RubyIO)port).rbIoClose(runtime);
            return result2;
        }
        RubyString string2 = str.convertToString();
        IRubyObject[] args2 = new IRubyObject[]{string2};
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            tuple = ShellLauncher.runAndWaitPid(runtime, args2, output, false);
        }
        catch (Exception e) {
            tuple = new long[]{127L, -1L};
        }
        context.setLastExitStatus(RubyProcess.RubyStatus.newProcessStatus(runtime, tuple[0] << 8, tuple[1]));
        byte[] out = output.toByteArray();
        int length2 = out.length;
        if (Platform.IS_WINDOWS) {
            int newPos = 0;
            for (int pos2 = 0; pos2 < length2; ++pos2) {
                byte curr = out[pos2];
                if (pos2 == length2 - 1) {
                    out[newPos++] = curr;
                    break;
                }
                byte next2 = out[pos2 + 1];
                if (curr == 13 && next2 == 10) continue;
                out[newPos++] = curr;
            }
            length2 = newPos;
        }
        ByteList buf = new ByteList(out, 0, length2, runtime.getDefaultExternalEncoding(), false);
        return RubyString.newString(runtime, buf);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject srand(ThreadContext context, IRubyObject recv2) {
        return RubyRandom.srandCommon(context, recv2);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject srand(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        return RubyRandom.srandCommon(context, recv2, arg2);
    }

    public static IRubyObject rand18(ThreadContext context, IRubyObject recv2, IRubyObject[] arg2) {
        return RubyKernel.rand19(context, recv2, arg2);
    }

    @JRubyMethod(name={"rand"}, module=true, optional=1, visibility=Visibility.PRIVATE)
    public static IRubyObject rand19(ThreadContext context, IRubyObject recv2, IRubyObject[] arg2) {
        return RubyRandom.randCommon19(context, recv2, arg2);
    }

    @JRubyMethod(rest=true, module=true, visibility=Visibility.PRIVATE)
    public static RubyFixnum spawn(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyProcess.spawn(context, recv2, args2);
    }

    @JRubyMethod(required=1, optional=9, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject syscall(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        throw context.runtime.newNotImplementedError("Kernel#syscall is not implemented in JRuby");
    }

    public static IRubyObject system(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyKernel.system19(context, recv2, args2);
    }

    @JRubyMethod(name={"system"}, required=1, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject system19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        boolean needChdir;
        Ruby runtime = context.runtime;
        boolean bl = needChdir = !runtime.getCurrentDirectory().equals(runtime.getPosix().getcwd());
        if (!needChdir && runtime.getPosix().isNative() && !Platform.IS_WINDOWS) {
            long ret;
            int[] status2 = new int[1];
            context.setLastExitStatus(context.nil);
            PopenExecutor executor = new PopenExecutor();
            long pid2 = executor.spawnInternal(context, args2, null);
            if (pid2 > 0L && (ret = RubyProcess.waitpid(runtime, pid2, 0)) == -1L) {
                throw runtime.newErrnoFromInt(runtime.getPosix().errno(), "Another thread waited the process started by system().");
            }
            if (pid2 < 0L) {
                return runtime.getNil();
            }
            status2[0] = (int)((RubyProcess.RubyStatus)context.getLastExitStatus()).getStatus();
            if (status2[0] == 0) {
                return runtime.getTrue();
            }
            return runtime.getFalse();
        }
        if (args2[0] instanceof RubyHash) {
            RubyHash env = args2[0].convertToHash();
            if (env != null) {
                runtime.getENV().merge_bang(context, env, Block.NULL_BLOCK);
            }
            args2 = ArraySupport.newCopy(args2, 1, args2.length - 1);
        }
        int resultCode = RubyKernel.systemCommon(context, recv2, args2);
        switch (resultCode) {
            case 0: {
                return runtime.getTrue();
            }
            case 127: {
                return runtime.getNil();
            }
        }
        return runtime.getFalse();
    }

    private static int systemCommon(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        long[] tuple;
        Ruby runtime = context.runtime;
        try {
            args2 = RubyKernel.dropLastArgIfOptions(runtime, args2);
            if (!Platform.IS_WINDOWS && args2[args2.length - 1].asJavaString().matches(".*[^&]&\\s*")) {
                ShellLauncher.runWithoutWait(runtime, args2);
                return 0;
            }
            tuple = ShellLauncher.runAndWaitPid(runtime, args2);
        }
        catch (Exception e) {
            tuple = new long[]{127L, -1L};
        }
        context.setLastExitStatus(RubyProcess.RubyStatus.newProcessStatus(runtime, tuple[0] << 8, tuple[1]));
        return (int)tuple[0];
    }

    private static IRubyObject[] dropLastArgIfOptions(Ruby runtime, IRubyObject[] args2) {
        IRubyObject lastArg = args2[args2.length - 1];
        if (lastArg instanceof RubyHash) {
            if (!((RubyHash)lastArg).isEmpty()) {
                runtime.getWarnings().warn(IRubyWarnings.ID.UNSUPPORTED_SUBPROCESS_OPTION, "system does not support options in JRuby yet: " + lastArg);
            }
            return Arrays.copyOf(args2, args2.length - 1);
        }
        return args2;
    }

    public static IRubyObject exec(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Ruby runtime = context.runtime;
        return RubyKernel.execCommon(runtime, null, args2[0], null, args2);
    }

    @JRubyMethod(required=4, visibility=Visibility.PRIVATE)
    public static IRubyObject _exec_internal(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Ruby runtime = context.runtime;
        IRubyObject env = args2[0];
        IRubyObject prog = args2[1];
        IRubyObject options2 = args2[2];
        RubyArray cmdArgs = (RubyArray)args2[3];
        RubyIO.checkExecOptions(options2);
        return RubyKernel.execCommon(runtime, env, prog, options2, cmdArgs.toJavaArray());
    }

    private static IRubyObject execCommon(Ruby runtime, IRubyObject env, IRubyObject prog, IRubyObject options2, IRubyObject[] args2) {
        RubyHash envMap;
        if (args2.length == 1) {
            RubyString command = args2[0].convertToString();
            if (command.isEmpty()) {
                throw runtime.newErrnoENOENTError(command.toString());
            }
            for (byte b2 : command.getBytes()) {
                if (b2 != 0) continue;
                throw runtime.newArgumentError("string contains null byte");
            }
        }
        ThreadContext context = runtime.getCurrentContext();
        if (env != null && !env.isNil() && (envMap = env.convertToHash()) != null) {
            runtime.getENV().merge_bang(context, envMap, Block.NULL_BLOCK);
        }
        boolean nativeFailed = false;
        boolean nativeExec = (Boolean)Options.NATIVE_EXEC.load();
        boolean jmxStopped = false;
        System.setProperty("user.dir", runtime.getCurrentDirectory());
        if (nativeExec) {
            IRubyObject oldExc = runtime.getGlobalVariables().get("$!");
            try {
                ShellLauncher.LaunchConfig cfg = new ShellLauncher.LaunchConfig(runtime, args2, true);
                if (cfg.shouldRunInShell()) {
                    cfg.verifyExecutableForShell();
                } else {
                    cfg.verifyExecutableForDirect();
                }
                String progStr = cfg.getExecArgs()[0];
                String[] argv2 = cfg.getExecArgs();
                jmxStopped = runtime.getBeanManager().tryShutdownAgent();
                runtime.getPosix().chdir(System.getProperty("user.dir"));
                if (Platform.IS_WINDOWS) {
                    runtime.getPosix().exec(progStr, argv2);
                } else {
                    RubyHash ENV = runtime.getENV();
                    ArrayList<String> envStrings = new ArrayList<String>(ENV.size() + 1);
                    for (Map.Entry envEntry : ENV.entrySet()) {
                        envStrings.add((String)envEntry.getKey() + '=' + (String)envEntry.getValue());
                    }
                    envStrings.add(null);
                    runtime.getPosix().execve(progStr, argv2, envStrings.toArray(new String[envStrings.size()]));
                }
                nativeFailed = true;
            }
            catch (RaiseException e) {
                runtime.getGlobalVariables().set("$!", oldExc);
            }
            catch (Exception e) {
                throw runtime.newErrnoENOENTError("cannot execute: " + e.getLocalizedMessage());
            }
        }
        if (nativeFailed) {
            if (jmxStopped && runtime.getBeanManager().tryRestartAgent()) {
                runtime.registerMBeans();
            }
            throw runtime.newErrnoFromLastPOSIXErrno();
        }
        int resultCode = ShellLauncher.execAndWait(runtime, args2);
        RubyKernel.exit(runtime, new IRubyObject[]{runtime.newFixnum(resultCode)}, true);
        return runtime.getNil();
    }

    public static IRubyObject fork(ThreadContext context, IRubyObject recv2, Block block) {
        return RubyKernel.fork19(context, recv2, block);
    }

    @JRubyMethod(name={"fork"}, module=true, visibility=Visibility.PRIVATE, notImplemented=true)
    public static IRubyObject fork19(ThreadContext context, IRubyObject recv2, Block block) {
        Ruby runtime = context.runtime;
        throw runtime.newNotImplementedError("fork is not available on this platform");
    }

    @JRubyMethod(module=true)
    public static IRubyObject tap(ThreadContext context, IRubyObject recv2, Block block) {
        block.yield(context, recv2);
        return recv2;
    }

    @JRubyMethod(name={"to_enum", "enum_for"}, optional=1, rest=true)
    public static IRubyObject obj_to_enum(final ThreadContext context, IRubyObject self2, IRubyObject[] args2, final Block block) {
        String method = "each";
        RubyEnumerator.SizeFn sizeFn = null;
        if (args2.length > 0) {
            method = args2[0].asJavaString();
            args2 = Arrays.copyOfRange(args2, 1, args2.length);
        }
        if (block.isGiven()) {
            sizeFn = new RubyEnumerator.SizeFn(){

                @Override
                public IRubyObject size(IRubyObject[] args2) {
                    return block.call(context, args2);
                }
            };
        }
        return RubyEnumerator.enumeratorizeWithSize(context, self2, method, args2, sizeFn);
    }

    @JRubyMethod(name={"__method__", "__callee__"}, module=true, visibility=Visibility.PRIVATE, reads={FrameField.METHODNAME}, omit=true)
    public static IRubyObject __method__(ThreadContext context, IRubyObject recv2) {
        String frameName = context.getFrameName();
        if (frameName == null) {
            return context.nil;
        }
        return context.runtime.newSymbol(frameName);
    }

    @JRubyMethod(name={"__dir__"}, module=true, visibility=Visibility.PRIVATE, reads={FrameField.FILENAME})
    public static IRubyObject __dir__(ThreadContext context, IRubyObject recv2) {
        String dir = RubyFile.dirname(context, new File(context.gatherCallerBacktrace()[1].getFileName()).getAbsolutePath());
        return RubyString.newString(context.runtime, dir);
    }

    @JRubyMethod(module=true)
    public static IRubyObject singleton_class(IRubyObject recv2) {
        return recv2.getSingletonClass();
    }

    @JRubyMethod(rest=true)
    public static IRubyObject public_send(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        if (args2.length == 0) {
            throw context.runtime.newArgumentError("no method name given");
        }
        String name2 = RubySymbol.objectToSymbolString(args2[0]);
        int length2 = args2.length - 1;
        args2 = length2 == 0 ? IRubyObject.NULL_ARRAY : ArraySupport.newCopy(args2, 1, length2);
        DynamicMethod method = recv2.getMetaClass().searchMethod(name2);
        if (method.isUndefined() || method.getVisibility() != Visibility.PUBLIC) {
            return Helpers.callMethodMissing(context, recv2, method.getVisibility(), name2, CallType.NORMAL, args2, block);
        }
        return method.call(context, recv2, (RubyModule)recv2.getMetaClass(), name2, args2, block);
    }

    @JRubyMethod(name={"eql?"}, required=1)
    public static IRubyObject eql_p(IRubyObject self2, IRubyObject obj) {
        return ((RubyBasicObject)self2).eql_p(obj);
    }

    @JRubyMethod(name={"==="}, required=1)
    public static IRubyObject op_eqq(ThreadContext context, IRubyObject self2, IRubyObject other) {
        return ((RubyBasicObject)self2).op_eqq(context, other);
    }

    @JRubyMethod(name={"<=>"}, required=1)
    public static IRubyObject op_cmp(ThreadContext context, IRubyObject self2, IRubyObject other) {
        return ((RubyBasicObject)self2).op_cmp(context, other);
    }

    @JRubyMethod(name={"initialize_copy"}, required=1, visibility=Visibility.PRIVATE)
    public static IRubyObject initialize_copy(IRubyObject self2, IRubyObject original) {
        return ((RubyBasicObject)self2).initialize_copy(original);
    }

    @JRubyMethod(name={"initialize_clone"}, required=1, visibility=Visibility.PRIVATE)
    public static IRubyObject initialize_clone(ThreadContext context, IRubyObject self2, IRubyObject original) {
        return RubyKernel.sites((ThreadContext)context).initialize_copy.call(context, self2, self2, original);
    }

    @JRubyMethod(name={"initialize_dup"}, required=1, visibility=Visibility.PRIVATE)
    public static IRubyObject initialize_dup(ThreadContext context, IRubyObject self2, IRubyObject original) {
        return RubyKernel.sites((ThreadContext)context).initialize_copy.call(context, self2, self2, original);
    }

    public static RubyBoolean respond_to_p(IRubyObject self2, IRubyObject mname) {
        return ((RubyBasicObject)self2).respond_to_p(mname);
    }

    @JRubyMethod(name={"respond_to?"})
    public static IRubyObject respond_to_p19(IRubyObject self2, IRubyObject mname) {
        return ((RubyBasicObject)self2).respond_to_p19(mname);
    }

    public static RubyBoolean respond_to_p(IRubyObject self2, IRubyObject mname, IRubyObject includePrivate) {
        return ((RubyBasicObject)self2).respond_to_p(mname, includePrivate);
    }

    @JRubyMethod(name={"respond_to?"})
    public static IRubyObject respond_to_p19(IRubyObject self2, IRubyObject mname, IRubyObject includePrivate) {
        return ((RubyBasicObject)self2).respond_to_p19(mname, includePrivate);
    }

    @JRubyMethod
    public static RubyFixnum hash(IRubyObject self2) {
        return ((RubyBasicObject)self2).hash();
    }

    @JRubyMethod(name={"class"})
    public static RubyClass type(IRubyObject self2) {
        return ((RubyBasicObject)self2).type();
    }

    @JRubyMethod(name={"clone"})
    public static IRubyObject rbClone(IRubyObject self2) {
        return ((RubyBasicObject)self2).rbClone();
    }

    @JRubyMethod
    public static IRubyObject dup(IRubyObject self2) {
        return ((RubyBasicObject)self2).dup();
    }

    @JRubyMethod(optional=1)
    public static IRubyObject display(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        return ((RubyBasicObject)self2).display(context, args2);
    }

    @JRubyMethod(name={"tainted?", "untrusted?"})
    public static RubyBoolean tainted_p(ThreadContext context, IRubyObject self2) {
        return ((RubyBasicObject)self2).tainted_p(context);
    }

    @JRubyMethod(name={"taint", "untrust"})
    public static IRubyObject taint(ThreadContext context, IRubyObject self2) {
        return ((RubyBasicObject)self2).taint(context);
    }

    @JRubyMethod(name={"untaint", "trust"})
    public static IRubyObject untaint(ThreadContext context, IRubyObject self2) {
        return ((RubyBasicObject)self2).untaint(context);
    }

    @JRubyMethod
    public static IRubyObject freeze(ThreadContext context, IRubyObject self2) {
        return ((RubyBasicObject)self2).freeze(context);
    }

    @JRubyMethod(name={"frozen?"})
    public static RubyBoolean frozen_p(ThreadContext context, IRubyObject self2) {
        return ((RubyBasicObject)self2).frozen_p(context);
    }

    @JRubyMethod(name={"inspect"})
    public static IRubyObject inspect(IRubyObject self2) {
        return ((RubyBasicObject)self2).inspect();
    }

    @JRubyMethod(name={"instance_of?"}, required=1)
    public static RubyBoolean instance_of_p(ThreadContext context, IRubyObject self2, IRubyObject type2) {
        return ((RubyBasicObject)self2).instance_of_p(context, type2);
    }

    @JRubyMethod(name={"itself"})
    public static IRubyObject itself(IRubyObject self2) {
        return self2;
    }

    @JRubyMethod(name={"kind_of?", "is_a?"}, required=1)
    public static RubyBoolean kind_of_p(ThreadContext context, IRubyObject self2, IRubyObject type2) {
        return ((RubyBasicObject)self2).kind_of_p(context, type2);
    }

    @JRubyMethod(name={"methods"}, optional=1)
    public static IRubyObject methods19(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        return ((RubyBasicObject)self2).methods19(context, args2);
    }

    @JRubyMethod(name={"object_id"})
    public static IRubyObject object_id(IRubyObject self2) {
        return self2.id();
    }

    @JRubyMethod(name={"public_methods"}, optional=1)
    public static IRubyObject public_methods19(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        return ((RubyBasicObject)self2).public_methods19(context, args2);
    }

    @JRubyMethod(name={"protected_methods"}, optional=1)
    public static IRubyObject protected_methods19(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        return ((RubyBasicObject)self2).protected_methods19(context, args2);
    }

    @JRubyMethod(name={"private_methods"}, optional=1)
    public static IRubyObject private_methods19(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        return ((RubyBasicObject)self2).private_methods19(context, args2);
    }

    @JRubyMethod(name={"singleton_methods"}, optional=1)
    public static RubyArray singleton_methods19(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        return ((RubyBasicObject)self2).singleton_methods(context, args2);
    }

    @JRubyMethod(name={"method"}, required=1)
    public static IRubyObject method19(IRubyObject self2, IRubyObject symbol) {
        return ((RubyBasicObject)self2).method19(symbol);
    }

    @JRubyMethod(name={"to_s"})
    public static IRubyObject to_s(IRubyObject self2) {
        return ((RubyBasicObject)self2).to_s();
    }

    @JRubyMethod(name={"extend"}, required=1, rest=true)
    public static IRubyObject extend(IRubyObject self2, IRubyObject[] args2) {
        return ((RubyBasicObject)self2).extend(args2);
    }

    @JRubyMethod(name={"send"}, omit=true)
    public static IRubyObject send19(ThreadContext context, IRubyObject self2, IRubyObject arg0, Block block) {
        return ((RubyBasicObject)self2).send19(context, arg0, block);
    }

    @JRubyMethod(name={"send"}, omit=true)
    public static IRubyObject send19(ThreadContext context, IRubyObject self2, IRubyObject arg0, IRubyObject arg1, Block block) {
        return ((RubyBasicObject)self2).send19(context, arg0, arg1, block);
    }

    @JRubyMethod(name={"send"}, omit=true)
    public static IRubyObject send19(ThreadContext context, IRubyObject self2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return ((RubyBasicObject)self2).send19(context, arg0, arg1, arg2, block);
    }

    @JRubyMethod(name={"send"}, required=1, rest=true, omit=true)
    public static IRubyObject send19(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block) {
        return ((RubyBasicObject)self2).send19(context, args2, block);
    }

    @JRubyMethod(name={"nil?"})
    public static IRubyObject nil_p(ThreadContext context, IRubyObject self2) {
        return ((RubyBasicObject)self2).nil_p(context);
    }

    public static IRubyObject op_match(ThreadContext context, IRubyObject self2, IRubyObject arg2) {
        return RubyKernel.op_match19(context, self2, arg2);
    }

    @JRubyMethod(name={"=~"}, required=1, writes={FrameField.BACKREF})
    public static IRubyObject op_match19(ThreadContext context, IRubyObject self2, IRubyObject arg2) {
        return ((RubyBasicObject)self2).op_match19(context, arg2);
    }

    @JRubyMethod(name={"!~"}, required=1, writes={FrameField.BACKREF})
    public static IRubyObject op_not_match(ThreadContext context, IRubyObject self2, IRubyObject arg2) {
        return ((RubyBasicObject)self2).op_not_match(context, arg2);
    }

    @JRubyMethod(name={"instance_variable_defined?"}, required=1)
    public static IRubyObject instance_variable_defined_p(ThreadContext context, IRubyObject self2, IRubyObject name2) {
        return ((RubyBasicObject)self2).instance_variable_defined_p(context, name2);
    }

    @JRubyMethod(name={"instance_variable_get"}, required=1)
    public static IRubyObject instance_variable_get(ThreadContext context, IRubyObject self2, IRubyObject name2) {
        return ((RubyBasicObject)self2).instance_variable_get(context, name2);
    }

    @JRubyMethod(name={"instance_variable_set"}, required=2)
    public static IRubyObject instance_variable_set(IRubyObject self2, IRubyObject name2, IRubyObject value2) {
        return ((RubyBasicObject)self2).instance_variable_set(name2, value2);
    }

    @JRubyMethod(name={"remove_instance_variable"}, required=1)
    public static IRubyObject remove_instance_variable(ThreadContext context, IRubyObject self2, IRubyObject name2, Block block) {
        return ((RubyBasicObject)self2).remove_instance_variable(context, name2, block);
    }

    @JRubyMethod(name={"instance_variables"})
    public static RubyArray instance_variables19(ThreadContext context, IRubyObject self2) {
        return ((RubyBasicObject)self2).instance_variables19(context);
    }

    public static IRubyObject gsub(ThreadContext context, IRubyObject recv2, IRubyObject arg0, Block block) {
        RubyString str = (RubyString)RubyKernel.getLastlineString(context, context.runtime).dup();
        if (!str.gsub_bang(context, arg0, block).isNil()) {
            context.setLastLine(str);
        }
        return str;
    }

    public static IRubyObject gsub(ThreadContext context, IRubyObject recv2, IRubyObject arg0, IRubyObject arg1, Block block) {
        RubyString str = (RubyString)RubyKernel.getLastlineString(context, context.runtime).dup();
        if (!str.gsub_bang(context, arg0, arg1, block).isNil()) {
            context.setLastLine(str);
        }
        return str;
    }

    private static JavaSites.KernelSites sites(ThreadContext context) {
        return context.sites.Kernel;
    }

    @Deprecated
    public static IRubyObject methodMissing(ThreadContext context, IRubyObject recv2, String name2, Visibility lastVis, CallType lastCallType, IRubyObject[] args2, Block block) {
        return RubyKernel.methodMissing(context, recv2, name2, lastVis, lastCallType, args2);
    }

    public static class LoopMethods {
        @JRubyMethod(module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE})
        public static IRubyObject gsub(ThreadContext context, IRubyObject recv2, IRubyObject arg0, Block block) {
            return context.setLastLine(RubyKernel.getLastlineString(context, context.runtime).gsub(context, arg0, block));
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE})
        public static IRubyObject gsub(ThreadContext context, IRubyObject recv2, IRubyObject arg0, IRubyObject arg1, Block block) {
            return context.setLastLine(RubyKernel.getLastlineString(context, context.runtime).gsub(context, arg0, arg1, block));
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE})
        public static IRubyObject sub(ThreadContext context, IRubyObject recv2, IRubyObject arg0, Block block) {
            return context.setLastLine(RubyKernel.getLastlineString(context, context.runtime).sub(context, arg0, block));
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE})
        public static IRubyObject sub(ThreadContext context, IRubyObject recv2, IRubyObject arg0, IRubyObject arg1, Block block) {
            return context.setLastLine(RubyKernel.getLastlineString(context, context.runtime).sub(context, arg0, arg1, block));
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE})
        public static IRubyObject chop(ThreadContext context, IRubyObject recv2) {
            return context.setLastLine(RubyKernel.getLastlineString(context, context.runtime).chop(context));
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE})
        public static IRubyObject chomp(ThreadContext context, IRubyObject recv2) {
            return context.setLastLine(RubyKernel.getLastlineString(context, context.runtime).chomp(context));
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE})
        public static IRubyObject chomp(ThreadContext context, IRubyObject recv2, IRubyObject arg0) {
            return context.setLastLine(RubyKernel.getLastlineString(context, context.runtime).chomp(context, arg0));
        }
    }

    private static abstract class EvalBinding {
        private EvalBinding() {
        }

        public abstract Binding convertToBinding(IRubyObject var1);
    }

    public static class MethodMissingMethod
    extends JavaMethod.JavaMethodNBlock {
        private final Visibility visibility;
        private final CallType callType;

        public MethodMissingMethod(RubyModule implementationClass, Visibility visibility, CallType callType) {
            super(implementationClass, Visibility.PRIVATE);
            this.callType = callType;
            this.visibility = visibility;
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            return RubyKernel.methodMissing(context, self2, name2, this.visibility, this.callType, args2);
        }
    }
}

