/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport.ext;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channel;
import org.jruby.Ruby;
import org.jruby.RubyIO;
import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class JavaIo {
    public static void define(Ruby runtime) {
        RubyModule proxyClass = Java.getProxyClass(runtime, InputStream.class);
        proxyClass.addMethodInternal("to_io", new InputStreamToIO(proxyClass));
        proxyClass = Java.getProxyClass(runtime, OutputStream.class);
        proxyClass.addMethodInternal("to_io", new OutputStreamToIO(proxyClass));
        proxyClass = Java.getProxyClass(runtime, Channel.class);
        proxyClass.addMethodInternal("to_io", new ChannelToIO(proxyClass));
    }

    static RubyIO to_io(ThreadContext context, InputStream stream, IRubyObject opts) {
        RubyIO io2 = new RubyIO(context.runtime, stream);
        JavaIo.setAutoclose(context, io2, opts);
        return io2;
    }

    static RubyIO to_io(ThreadContext context, OutputStream stream, IRubyObject opts) {
        RubyIO io2 = new RubyIO(context.runtime, stream);
        JavaIo.setAutoclose(context, io2, opts);
        return io2;
    }

    private static void setAutoclose(ThreadContext context, RubyIO io2, IRubyObject opts) {
        IRubyObject autoclose2;
        if (opts != null && opts != context.nil && (autoclose2 = opts.callMethod(context, "[]", context.runtime.newSymbol("autoclose"))) != context.nil) {
            io2.setAutoclose(autoclose2.isTrue());
        }
    }

    private static final class ChannelToIO
    extends JavaMethod.JavaMethodZeroOrOne {
        ChannelToIO(RubyModule implClass) {
            super(implClass, Visibility.PUBLIC);
        }

        @Override
        public RubyIO call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2) {
            return ChannelToIO.to_io(context, self2, null);
        }

        @Override
        public RubyIO call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject opts) {
            return ChannelToIO.to_io(context, self2, opts);
        }

        private static RubyIO to_io(ThreadContext context, IRubyObject self2, IRubyObject opts) {
            RubyIO io2 = new RubyIO(context.runtime, (Channel)JavaUtil.unwrapJavaObject(self2));
            JavaIo.setAutoclose(context, io2, opts);
            return io2;
        }
    }

    private static final class OutputStreamToIO
    extends JavaMethod.JavaMethodZeroOrOne {
        OutputStreamToIO(RubyModule implClass) {
            super(implClass, Visibility.PUBLIC);
        }

        @Override
        public RubyIO call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2) {
            return JavaIo.to_io(context, (OutputStream)JavaUtil.unwrapJavaObject(self2), null);
        }

        @Override
        public RubyIO call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject opts) {
            return JavaIo.to_io(context, (OutputStream)JavaUtil.unwrapJavaObject(self2), opts);
        }
    }

    private static final class InputStreamToIO
    extends JavaMethod.JavaMethodZeroOrOne {
        InputStreamToIO(RubyModule implClass) {
            super(implClass, Visibility.PUBLIC);
        }

        @Override
        public RubyIO call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2) {
            return JavaIo.to_io(context, (InputStream)JavaUtil.unwrapJavaObject(self2), null);
        }

        @Override
        public RubyIO call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject opts) {
            return JavaIo.to_io(context, (InputStream)JavaUtil.unwrapJavaObject(self2), opts);
        }
    }
}

