/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.concurrent.locks.ReentrantLock;
import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyEncoding;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.compiler.Constantizable;
import org.jruby.runtime.ArgumentDescriptor;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.ContextAwareBlockBody;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.encoding.EncodingCapable;
import org.jruby.runtime.encoding.MarshalEncoding;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.runtime.opto.OptoFactory;
import org.jruby.util.ByteList;
import org.jruby.util.PerlHash;
import org.jruby.util.SipHashInline;
import org.jruby.util.StringSupport;

@JRubyClass(name={"Symbol"}, include={"Enumerable"})
public class RubySymbol
extends RubyObject
implements MarshalEncoding,
EncodingCapable,
Constantizable {
    public static final long symbolHashSeedK0 = 5238926673095087190L;
    private final String symbol;
    private final int id;
    private final ByteList symbolBytes;
    private final int hashCode;
    private Object constant;

    private RubySymbol(Ruby runtime, String internedSymbol, ByteList symbolBytes) {
        super(runtime, runtime.getSymbol(), false);
        this.symbol = internedSymbol;
        if (StringSupport.codeRangeScan(symbolBytes.getEncoding(), symbolBytes) == 16) {
            symbolBytes = symbolBytes.dup();
            symbolBytes.setEncoding((Encoding)USASCIIEncoding.INSTANCE);
        }
        this.symbolBytes = symbolBytes;
        this.id = runtime.allocSymbolId();
        long hash2 = runtime.isSiphashEnabled() ? SipHashInline.hash24(5238926673095087190L, 0L, symbolBytes.getUnsafeBytes(), symbolBytes.getBegin(), symbolBytes.getRealSize()) : PerlHash.hash(5238926673095087190L, symbolBytes.getUnsafeBytes(), symbolBytes.getBegin(), symbolBytes.getRealSize());
        this.hashCode = (int)hash2;
        this.setFrozen(true);
    }

    private RubySymbol(Ruby runtime, String internedSymbol) {
        this(runtime, internedSymbol, RubySymbol.symbolBytesFromString(runtime, internedSymbol));
    }

    public static RubyClass createSymbolClass(Ruby runtime) {
        RubyClass symbolClass = runtime.defineClass("Symbol", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        runtime.setSymbol(symbolClass);
        RubyClass symbolMetaClass = symbolClass.getMetaClass();
        symbolClass.setClassIndex(ClassIndex.SYMBOL);
        symbolClass.setReifiedClass(RubySymbol.class);
        symbolClass.kindOf = new RubyModule.JavaClassKindOf(RubySymbol.class);
        symbolClass.defineAnnotatedMethods(RubySymbol.class);
        symbolMetaClass.undefineMethod("new");
        symbolClass.includeModule(runtime.getComparable());
        return symbolClass;
    }

    @Override
    public ClassIndex getNativeClassIndex() {
        return ClassIndex.SYMBOL;
    }

    @Override
    public final String asJavaString() {
        return this.symbol;
    }

    @Override
    public final String toString() {
        return this.symbol;
    }

    final ByteList getBytes() {
        return this.symbolBytes;
    }

    public void associateEncoding(Encoding encoding2) {
        this.symbolBytes.setEncoding(encoding2);
    }

    @Override
    public final boolean eql(IRubyObject other) {
        return other == this;
    }

    @Override
    public boolean isImmediate() {
        return true;
    }

    @Override
    public RubyClass getSingletonClass() {
        throw this.getRuntime().newTypeError("can't define singleton");
    }

    public static RubySymbol getSymbolLong(Ruby runtime, long id2) {
        return runtime.getSymbolTable().lookup(id2);
    }

    @Deprecated
    public static RubySymbol newSymbol(Ruby runtime, IRubyObject name2) {
        if (name2 instanceof RubySymbol) {
            return runtime.getSymbolTable().getSymbol(((RubySymbol)name2).getBytes(), false);
        }
        if (name2 instanceof RubyString) {
            return runtime.getSymbolTable().getSymbol(((RubyString)name2).getByteList(), false);
        }
        return RubySymbol.newSymbol(runtime, name2.asJavaString());
    }

    public static RubySymbol newHardSymbol(Ruby runtime, IRubyObject name2) {
        if (name2 instanceof RubySymbol || name2 instanceof RubyString) {
            return runtime.getSymbolTable().getSymbol(name2.asJavaString(), true);
        }
        return RubySymbol.newSymbol(runtime, name2.asJavaString());
    }

    public static RubySymbol newSymbol(Ruby runtime, String name2) {
        return runtime.getSymbolTable().getSymbol(name2, false);
    }

    public static RubySymbol newHardSymbol(Ruby runtime, String name2) {
        return runtime.getSymbolTable().getSymbol(name2, true);
    }

    public static RubySymbol newSymbol(Ruby runtime, String name2, Encoding encoding2) {
        RubySymbol newSymbol = RubySymbol.newSymbol(runtime, name2);
        newSymbol.associateEncoding(encoding2);
        return newSymbol;
    }

    public static RubySymbol newHardSymbol(Ruby runtime, String name2, Encoding encoding2) {
        RubySymbol newSymbol = RubySymbol.newHardSymbol(runtime, name2);
        newSymbol.associateEncoding(encoding2);
        return newSymbol;
    }

    @Override
    public Object constant() {
        return this.constant == null ? (this.constant = OptoFactory.newConstantWrapper(IRubyObject.class, this)) : this.constant;
    }

    @Override
    public IRubyObject inspect() {
        return this.inspect(this.getRuntime());
    }

    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect(ThreadContext context) {
        return this.inspect(context.runtime);
    }

    final RubyString inspect(Ruby runtime) {
        ByteList result2 = new ByteList(this.symbolBytes.getRealSize() + 1);
        result2.setEncoding(this.symbolBytes.getEncoding());
        result2.append((byte)58);
        result2.append(this.symbolBytes);
        Encoding resenc = runtime.getDefaultInternalEncoding();
        if (resenc == null) {
            resenc = runtime.getDefaultExternalEncoding();
        }
        RubyString str = RubyString.newString(runtime, result2);
        if (this.isPrintable() && (resenc.equals((Object)this.symbolBytes.getEncoding()) || str.isAsciiOnly()) && RubySymbol.isSymbolName19(this.symbol)) {
            return str;
        }
        str = str.inspect(runtime);
        ByteList bytes2 = str.getByteList();
        bytes2.set(0, 58);
        bytes2.set(1, 34);
        return str;
    }

    @Deprecated
    public IRubyObject inspect19(ThreadContext context) {
        return this.inspect(context);
    }

    @Override
    public IRubyObject to_s() {
        return this.to_s(this.getRuntime());
    }

    @JRubyMethod
    public IRubyObject to_s(ThreadContext context) {
        return this.to_s(context.runtime);
    }

    private final IRubyObject to_s(Ruby runtime) {
        return RubyString.newStringShared(runtime, this.symbolBytes);
    }

    public IRubyObject id2name() {
        return this.to_s(this.getRuntime());
    }

    @JRubyMethod
    public IRubyObject id2name(ThreadContext context) {
        return this.to_s(context);
    }

    @Override
    @JRubyMethod(name={"==="}, required=1)
    public IRubyObject op_eqq(ThreadContext context, IRubyObject other) {
        return context.runtime.newBoolean(this == other);
    }

    @Override
    @JRubyMethod(name={"=="}, required=1)
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        return context.runtime.newBoolean(this == other);
    }

    @Override
    @Deprecated
    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(this.hashCode());
    }

    @JRubyMethod
    public RubyFixnum hash(ThreadContext context) {
        return context.runtime.newFixnum(this.hashCode());
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    public int getId() {
        return this.id;
    }

    @Override
    public boolean equals(Object other) {
        return other == this;
    }

    @Override
    public int compareTo(IRubyObject that) {
        if (that instanceof RubySymbol) {
            return this.symbol.compareTo(((RubySymbol)that).symbol);
        }
        return 0;
    }

    @JRubyMethod(name={"to_sym"})
    public IRubyObject to_sym() {
        return this;
    }

    @JRubyMethod(name={"intern"})
    public IRubyObject to_sym19() {
        return this;
    }

    @Override
    public IRubyObject taint(ThreadContext context) {
        return this;
    }

    private RubyString newShared(Ruby runtime) {
        return RubyString.newStringShared(runtime, this.symbolBytes);
    }

    private RubyString rubyStringFromString(Ruby runtime) {
        return RubyString.newString(runtime, this.symbol);
    }

    @JRubyMethod(name={"succ", "next"})
    public IRubyObject succ(ThreadContext context) {
        Ruby runtime = context.runtime;
        return RubySymbol.newSymbol(runtime, this.newShared(runtime).succ(context).toString());
    }

    @Override
    @JRubyMethod(name={"<=>"})
    public IRubyObject op_cmp(ThreadContext context, IRubyObject other) {
        Ruby runtime = context.runtime;
        return !(other instanceof RubySymbol) ? runtime.getNil() : this.newShared(runtime).op_cmp(context, ((RubySymbol)other).newShared(runtime));
    }

    @JRubyMethod
    public IRubyObject casecmp(ThreadContext context, IRubyObject other) {
        Ruby runtime = context.runtime;
        return !(other instanceof RubySymbol) ? runtime.getNil() : this.newShared(runtime).casecmp19(context, ((RubySymbol)other).newShared(runtime));
    }

    @Override
    @JRubyMethod(name={"=~", "match"})
    public IRubyObject op_match19(ThreadContext context, IRubyObject other) {
        return this.newShared(context.runtime).op_match19(context, other);
    }

    @JRubyMethod(name={"[]", "slice"})
    public IRubyObject op_aref(ThreadContext context, IRubyObject arg2) {
        return this.newShared(context.runtime).op_aref19(context, arg2);
    }

    @JRubyMethod(name={"[]", "slice"})
    public IRubyObject op_aref(ThreadContext context, IRubyObject arg1, IRubyObject arg2) {
        return this.newShared(context.runtime).op_aref19(context, arg1, arg2);
    }

    @JRubyMethod(name={"length", "size"})
    public IRubyObject length() {
        return this.newShared(this.getRuntime()).length19();
    }

    @JRubyMethod(name={"empty?"})
    public IRubyObject empty_p(ThreadContext context) {
        return this.newShared(context.runtime).empty_p(context);
    }

    @JRubyMethod
    public IRubyObject upcase(ThreadContext context) {
        Ruby runtime = context.runtime;
        return RubySymbol.newSymbol(runtime, this.rubyStringFromString(runtime).upcase19(context).toString());
    }

    @JRubyMethod
    public IRubyObject downcase(ThreadContext context) {
        Ruby runtime = context.runtime;
        return RubySymbol.newSymbol(runtime, this.rubyStringFromString(runtime).downcase19(context).toString());
    }

    @JRubyMethod
    public IRubyObject capitalize(ThreadContext context) {
        Ruby runtime = context.runtime;
        return RubySymbol.newSymbol(runtime, this.rubyStringFromString(runtime).capitalize19(context).toString());
    }

    @JRubyMethod
    public IRubyObject swapcase(ThreadContext context) {
        Ruby runtime = context.runtime;
        return RubySymbol.newSymbol(runtime, this.rubyStringFromString(runtime).swapcase19(context).toString());
    }

    @JRubyMethod
    public IRubyObject encoding(ThreadContext context) {
        return context.runtime.getEncodingService().getEncoding(this.symbolBytes.getEncoding());
    }

    @JRubyMethod
    public IRubyObject to_proc(ThreadContext context) {
        SymbolProcBody body = new SymbolProcBody(context.runtime, this.symbol);
        return RubyProc.newProc(context.runtime, new Block(body, Binding.DUMMY), Block.Type.PROC);
    }

    private static boolean isIdentStart(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c >= '\u0080';
    }

    private static boolean isIdentChar(char c) {
        return c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c == '_' || c >= '\u0080';
    }

    private static boolean isIdentifier(String s2) {
        if (s2 == null || s2.length() <= 0 || !RubySymbol.isIdentStart(s2.charAt(0))) {
            return false;
        }
        for (int i2 = 1; i2 < s2.length(); ++i2) {
            if (RubySymbol.isIdentChar(s2.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    private static boolean isSpecialGlobalName(String s2) {
        if (s2 == null || s2.length() <= 0) {
            return false;
        }
        int length2 = s2.length();
        switch (s2.charAt(0)) {
            case '!': 
            case '\"': 
            case '$': 
            case '&': 
            case '\'': 
            case '*': 
            case '+': 
            case ',': 
            case '.': 
            case '/': 
            case '0': 
            case ':': 
            case ';': 
            case '<': 
            case '=': 
            case '>': 
            case '?': 
            case '@': 
            case '\\': 
            case '`': 
            case '~': {
                return length2 == 1;
            }
            case '-': {
                return length2 == 1 || length2 == 2 && RubySymbol.isIdentChar(s2.charAt(1));
            }
        }
        for (int i2 = 0; i2 < length2; ++i2) {
            if (Character.isDigit(s2.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    private boolean isPrintable() {
        int c;
        int p2;
        Ruby runtime = this.getRuntime();
        int end2 = p2 + this.symbolBytes.getRealSize();
        byte[] bytes2 = this.symbolBytes.getUnsafeBytes();
        Encoding enc = this.symbolBytes.getEncoding();
        for (p2 = this.symbolBytes.getBegin(); p2 < end2; p2 += StringSupport.codeLength(enc, c)) {
            c = StringSupport.codePoint(runtime, enc, bytes2, p2, end2);
            if (enc.isPrint(c)) continue;
            return false;
        }
        return true;
    }

    private static boolean isSymbolName19(String s2) {
        if (s2 == null || s2.length() < 1) {
            return false;
        }
        int length2 = s2.length();
        char c = s2.charAt(0);
        return RubySymbol.isSymbolNameCommon(s2, c, length2) || c == '!' && (length2 == 1 || length2 == 2 && (s2.charAt(1) == '~' || s2.charAt(1) == '=')) || RubySymbol.isSymbolLocal(s2, c, length2);
    }

    private static boolean isSymbolNameCommon(String s2, char c, int length2) {
        switch (c) {
            case '$': {
                if (length2 > 1 && RubySymbol.isSpecialGlobalName(s2.substring(1))) {
                    return true;
                }
                return RubySymbol.isIdentifier(s2.substring(1));
            }
            case '@': {
                int offset2 = 1;
                if (length2 >= 2 && s2.charAt(1) == '@') {
                    ++offset2;
                }
                return RubySymbol.isIdentifier(s2.substring(offset2));
            }
            case '<': {
                return length2 == 1 || length2 == 2 && (s2.equals("<<") || s2.equals("<=")) || length2 == 3 && s2.equals("<=>");
            }
            case '>': {
                return length2 == 1 || length2 == 2 && (s2.equals(">>") || s2.equals(">="));
            }
            case '=': {
                return length2 == 2 && (s2.equals("==") || s2.equals("=~")) || length2 == 3 && s2.equals("===");
            }
            case '*': {
                return length2 == 1 || length2 == 2 && s2.equals("**");
            }
            case '+': {
                return length2 == 1 || length2 == 2 && s2.equals("+@");
            }
            case '-': {
                return length2 == 1 || length2 == 2 && s2.equals("-@");
            }
            case '%': 
            case '&': 
            case '/': 
            case '^': 
            case '`': 
            case '|': 
            case '~': {
                return length2 == 1;
            }
            case '[': {
                return s2.equals("[]") || s2.equals("[]=");
            }
        }
        return false;
    }

    private static boolean isSymbolLocal(String s2, char c, int length2) {
        char d;
        int last2;
        if (!RubySymbol.isIdentStart(c)) {
            return false;
        }
        boolean localID = c >= 'a' && c <= 'z';
        for (last2 = 1; last2 < length2 && RubySymbol.isIdentChar(d = s2.charAt(last2)); ++last2) {
        }
        if (last2 == length2) {
            return true;
        }
        if (localID && last2 == length2 - 1) {
            d = s2.charAt(last2);
            return d == '!' || d == '?' || d == '=';
        }
        return false;
    }

    @JRubyMethod(meta=true)
    public static IRubyObject all_symbols(ThreadContext context, IRubyObject recv2) {
        return context.runtime.getSymbolTable().all_symbols();
    }

    @Deprecated
    public static IRubyObject all_symbols(IRubyObject recv2) {
        return recv2.getRuntime().getSymbolTable().all_symbols();
    }

    public static RubySymbol unmarshalFrom(UnmarshalStream input) throws IOException {
        RubySymbol result2 = RubySymbol.newSymbol(input.getRuntime(), RubyString.byteListToString(input.unmarshalString()));
        input.registerLinkTarget(result2);
        return result2;
    }

    @Override
    public Object toJava(Class target) {
        if (target == String.class || target == CharSequence.class) {
            return this.symbol;
        }
        return super.toJava(target);
    }

    public static ByteList symbolBytesFromString(Ruby runtime, String internedSymbol) {
        return new ByteList(ByteList.plain((CharSequence)internedSymbol), (Encoding)USASCIIEncoding.INSTANCE, false);
    }

    @Override
    public Encoding getEncoding() {
        return this.symbolBytes.getEncoding();
    }

    @Override
    public void setEncoding(Encoding e) {
        this.symbolBytes.setEncoding(e);
    }

    private static int javaStringHashCode(String str) {
        return str.hashCode();
    }

    private static int javaStringHashCode(ByteList iso8859) {
        int h = 0;
        int length2 = iso8859.length();
        if (length2 > 0) {
            byte[] val = iso8859.getUnsafeBytes();
            int begin2 = iso8859.begin();
            h = new String(val, begin2, length2, RubyEncoding.ISO).hashCode();
        }
        return h;
    }

    @Override
    public boolean shouldMarshalEncoding() {
        return this.getMarshalEncoding() != USASCIIEncoding.INSTANCE;
    }

    @Override
    public Encoding getMarshalEncoding() {
        return this.symbolBytes.getEncoding();
    }

    public static String objectToSymbolString(IRubyObject object) {
        if (object instanceof RubySymbol) {
            return ((RubySymbol)object).toString();
        }
        if (object instanceof RubyString) {
            return ((RubyString)object).getByteList().toString();
        }
        return object.convertToString().getByteList().toString();
    }

    private static final class SymbolProcBody
    extends ContextAwareBlockBody {
        private final CallSite site;

        public SymbolProcBody(Ruby runtime, String symbol) {
            super(runtime.getStaticScopeFactory().getDummyScope(), Signature.OPTIONAL);
            this.site = MethodIndex.getFunctionalCallSite(symbol);
        }

        private IRubyObject yieldInner(ThreadContext context, RubyArray array, Block blockArg) {
            if (array.isEmpty()) {
                throw context.runtime.newArgumentError("no receiver given");
            }
            IRubyObject self2 = array.shift(context);
            return this.site.call(context, self2, self2, array.toJavaArray(), blockArg);
        }

        @Override
        public IRubyObject yield(ThreadContext context, Block block, IRubyObject[] args2, IRubyObject self2, Block blockArg) {
            RubyProc.prepareArgs(context, block.type, blockArg.getBody(), args2);
            return this.yieldInner(context, RubyArray.newArrayMayCopy(context.runtime, args2), blockArg);
        }

        @Override
        public IRubyObject yield(ThreadContext context, Block block, IRubyObject value2, Block blockArg) {
            return this.yieldInner(context, ArgsUtil.convertToRubyArray(context.runtime, value2, false), blockArg);
        }

        @Override
        protected IRubyObject doYield(ThreadContext context, Block block, IRubyObject value2) {
            return this.yieldInner(context, ArgsUtil.convertToRubyArray(context.runtime, value2, false), Block.NULL_BLOCK);
        }

        @Override
        protected IRubyObject doYield(ThreadContext context, Block block, IRubyObject[] args2, IRubyObject self2) {
            return this.yieldInner(context, RubyArray.newArrayMayCopy(context.runtime, args2), Block.NULL_BLOCK);
        }

        @Override
        public IRubyObject yieldSpecific(ThreadContext context, Block block, IRubyObject arg0) {
            return this.site.call(context, arg0, arg0);
        }

        @Override
        public IRubyObject yieldSpecific(ThreadContext context, Block block, IRubyObject arg0, IRubyObject arg1) {
            return this.site.call(context, arg0, arg0, arg1);
        }

        @Override
        public IRubyObject yieldSpecific(ThreadContext context, Block block, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
            return this.site.call(context, arg0, arg0, arg1, arg2);
        }

        @Override
        public String getFile() {
            return this.site.methodName;
        }

        @Override
        public int getLine() {
            return -1;
        }

        @Override
        public ArgumentDescriptor[] getArgumentDescriptors() {
            return ArgumentDescriptor.ANON_REST;
        }
    }

    public static final class SymbolTable {
        static final int DEFAULT_INITIAL_CAPACITY = 1024;
        static final int MAXIMUM_CAPACITY = 65536;
        static final float DEFAULT_LOAD_FACTOR = 0.75f;
        private final ReentrantLock tableLock = new ReentrantLock();
        private volatile SymbolEntry[] symbolTable;
        private int size;
        private int threshold;
        private final float loadFactor;
        private final Ruby runtime;

        public SymbolTable(Ruby runtime) {
            this.runtime = runtime;
            this.loadFactor = 0.75f;
            this.threshold = 768;
            this.symbolTable = new SymbolEntry[1024];
        }

        public RubySymbol getSymbol(String name2) {
            return this.getSymbol(name2, false);
        }

        public RubySymbol getSymbol(String name2, boolean hard) {
            int hash2 = RubySymbol.javaStringHashCode(name2);
            RubySymbol symbol = null;
            SymbolEntry e = SymbolTable.getEntryFromTable(this.symbolTable, hash2);
            while (e != null) {
                if (SymbolTable.isSymbolMatch(name2, hash2, e)) {
                    if (hard) {
                        e.setHardReference();
                    }
                    symbol = (RubySymbol)e.symbol.get();
                    break;
                }
                e = e.next;
            }
            if (symbol == null) {
                symbol = this.createSymbol(name2, RubySymbol.symbolBytesFromString(this.runtime, name2), hash2, hard);
            }
            return symbol;
        }

        public RubySymbol getSymbol(ByteList bytes2) {
            return this.getSymbol(bytes2, false);
        }

        public RubySymbol getSymbol(ByteList bytes2, boolean hard) {
            RubySymbol symbol = null;
            int hash2 = RubySymbol.javaStringHashCode(bytes2);
            SymbolEntry e = SymbolTable.getEntryFromTable(this.symbolTable, hash2);
            while (e != null) {
                if (SymbolTable.isSymbolMatch(bytes2, hash2, e)) {
                    if (hard) {
                        e.setHardReference();
                    }
                    symbol = (RubySymbol)e.symbol.get();
                    break;
                }
                e = e.next;
            }
            if (symbol == null) {
                bytes2 = bytes2.dup();
                symbol = this.createSymbol(bytes2.toString(), bytes2, hash2, hard);
            }
            return symbol;
        }

        public RubySymbol fastGetSymbol(String internedName) {
            return this.fastGetSymbol(internedName, false);
        }

        public RubySymbol fastGetSymbol(String internedName, boolean hard) {
            RubySymbol symbol = null;
            SymbolEntry e = SymbolTable.getEntryFromTable(this.symbolTable, internedName.hashCode());
            while (e != null) {
                if (SymbolTable.isSymbolMatch(internedName, e)) {
                    if (hard) {
                        e.setHardReference();
                    }
                    symbol = (RubySymbol)e.symbol.get();
                    break;
                }
                e = e.next;
            }
            if (symbol == null) {
                symbol = this.fastCreateSymbol(internedName, hard);
            }
            return symbol;
        }

        private static SymbolEntry getEntryFromTable(SymbolEntry[] table, int hash2) {
            return table[hash2 & table.length - 1];
        }

        private static boolean isSymbolMatch(String name2, int hash2, SymbolEntry entry) {
            return hash2 == entry.hash && name2.equals(entry.name);
        }

        private static boolean isSymbolMatch(ByteList bytes2, int hash2, SymbolEntry entry) {
            return hash2 == entry.hash && bytes2.equals((Object)entry.bytes);
        }

        private static boolean isSymbolMatch(String internedName, SymbolEntry entry) {
            return internedName == entry.name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private RubySymbol createSymbol(String name2, ByteList value2, int hash2, boolean hard) {
            ReentrantLock lock2 = this.tableLock;
            lock2.lock();
            try {
                SymbolEntry[] table = this.size > this.threshold ? this.rehash() : this.symbolTable;
                int index2 = hash2 & table.length - 1;
                RubySymbol symbol = null;
                SymbolEntry last2 = null;
                SymbolEntry curr = table[index2];
                while (curr != null) {
                    block10: {
                        RubySymbol localSymbol;
                        block9: {
                            localSymbol = (RubySymbol)curr.symbol.get();
                            if (localSymbol != null) break block9;
                            this.removeDeadEntry(table, index2, last2, curr);
                            if (hash2 != curr.hash || !name2.equals(curr.name)) break block10;
                        }
                        last2 = curr;
                        if (hash2 == curr.hash && name2.equals(curr.name)) {
                            symbol = localSymbol;
                            break;
                        }
                    }
                    curr = curr.next;
                }
                if (symbol == null) {
                    String internedName = name2.intern();
                    symbol = new RubySymbol(this.runtime, internedName, value2);
                    table[index2] = new SymbolEntry(hash2, internedName, value2, symbol, table[index2], hard);
                    ++this.size;
                    this.symbolTable = table;
                }
                RubySymbol rubySymbol = symbol;
                return rubySymbol;
            }
            finally {
                lock2.unlock();
            }
        }

        private void removeDeadEntry(SymbolEntry[] table, int index2, SymbolEntry last2, SymbolEntry e) {
            if (last2 == null) {
                table[index2] = e.next;
            } else {
                last2.next = e.next;
            }
            --this.size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private RubySymbol fastCreateSymbol(String internedName, boolean hard) {
            ReentrantLock lock2 = this.tableLock;
            lock2.lock();
            try {
                SymbolEntry[] table = this.size + 1 > this.threshold ? this.rehash() : this.symbolTable;
                int hash2 = internedName.hashCode();
                int index2 = hash2 & table.length - 1;
                RubySymbol symbol = null;
                SymbolEntry last2 = null;
                SymbolEntry curr = table[index2];
                while (curr != null) {
                    block10: {
                        RubySymbol localSymbol;
                        block9: {
                            localSymbol = (RubySymbol)curr.symbol.get();
                            if (localSymbol != null) break block9;
                            this.removeDeadEntry(table, index2, last2, curr);
                            if (internedName != curr.name) break block10;
                        }
                        last2 = curr;
                        if (internedName == curr.name) {
                            symbol = localSymbol;
                            break;
                        }
                    }
                    curr = curr.next;
                }
                if (symbol == null) {
                    symbol = new RubySymbol(this.runtime, internedName);
                    table[index2] = new SymbolEntry(hash2, internedName, symbol.getBytes(), symbol, table[index2], hard);
                    ++this.size;
                    this.symbolTable = table;
                }
                RubySymbol rubySymbol = symbol;
                return rubySymbol;
            }
            finally {
                lock2.unlock();
            }
        }

        public RubySymbol lookup(long id2) {
            SymbolEntry[] table = this.symbolTable;
            RubySymbol symbol = null;
            int i2 = table.length;
            while (--i2 >= 0) {
                SymbolEntry e = table[i2];
                while (e != null) {
                    symbol = (RubySymbol)e.symbol.get();
                    if (symbol != null && id2 == (long)symbol.id) {
                        return symbol;
                    }
                    e = e.next;
                }
            }
            return null;
        }

        public RubyArray all_symbols() {
            SymbolEntry[] table = this.symbolTable;
            RubyArray array = this.runtime.newArray(this.size);
            int i2 = table.length;
            while (--i2 >= 0) {
                SymbolEntry e = table[i2];
                while (e != null) {
                    RubySymbol symbol = (RubySymbol)e.symbol.get();
                    if (symbol != null) {
                        array.append(symbol);
                    }
                    e = e.next;
                }
            }
            return array;
        }

        private SymbolEntry[] rehash() {
            SymbolEntry[] oldTable = this.symbolTable;
            int oldCapacity = oldTable.length;
            if (oldCapacity >= 65536) {
                return oldTable;
            }
            int newCapacity = oldCapacity << 1;
            SymbolEntry[] newTable = new SymbolEntry[newCapacity];
            this.threshold = (int)((float)newCapacity * this.loadFactor);
            int sizeMask = newCapacity - 1;
            int i2 = oldCapacity;
            while (--i2 >= 0) {
                int k;
                SymbolEntry e = oldTable[i2];
                if (e == null) continue;
                SymbolEntry next2 = e.next;
                int idx = e.hash & sizeMask;
                if (next2 == null) {
                    newTable[idx] = e;
                    continue;
                }
                SymbolEntry lastRun = e;
                int lastIdx = idx;
                SymbolEntry last2 = next2;
                while (last2 != null) {
                    k = last2.hash & sizeMask;
                    if (k != lastIdx) {
                        lastIdx = k;
                        lastRun = last2;
                    }
                    last2 = last2.next;
                }
                newTable[lastIdx] = lastRun;
                SymbolEntry p2 = e;
                while (p2 != lastRun) {
                    k = p2.hash & sizeMask;
                    SymbolEntry n = newTable[k];
                    newTable[k] = new SymbolEntry(p2.hash, p2.name, p2.bytes, (RubySymbol)p2.symbol.get(), n, p2.hardReference != null);
                    p2 = p2.next;
                }
            }
            this.symbolTable = newTable;
            return newTable;
        }

        @Deprecated
        public RubySymbol lookup(String name2) {
            int hash2 = name2.hashCode();
            SymbolEntry[] table = this.symbolTable;
            RubySymbol symbol = null;
            SymbolEntry e = table[hash2 & table.length - 1];
            while (!(e == null || hash2 == e.hash && name2.equals(e.name) && (symbol = (RubySymbol)e.symbol.get()) != null)) {
                e = e.next;
            }
            return symbol;
        }

        @Deprecated
        public void store(RubySymbol symbol) {
            throw new UnsupportedOperationException();
        }

        static final class SymbolEntry {
            final int hash;
            final String name;
            final ByteList bytes;
            final WeakReference<RubySymbol> symbol;
            RubySymbol hardReference;
            SymbolEntry next;

            SymbolEntry(int hash2, String name2, ByteList bytes2, RubySymbol symbol, SymbolEntry next2, boolean hard) {
                this.hash = hash2;
                this.name = name2;
                this.bytes = bytes2;
                this.symbol = new WeakReference<RubySymbol>(symbol);
                this.next = next2;
                if (hard) {
                    this.hardReference = symbol;
                }
            }

            public void setHardReference() {
                if (this.hardReference == null) {
                    this.hardReference = (RubySymbol)this.symbol.get();
                }
            }
        }
    }
}

