/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.specialized;

import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyComparable;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFixnum;
import org.jruby.RubyString;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.invokedynamic.MethodNames;
import org.jruby.specialized.RubyArrayOneObject;
import org.jruby.specialized.RubyArraySpecialized;
import org.jruby.util.io.EncodingUtils;

public class RubyArrayTwoObject
extends RubyArraySpecialized {
    private IRubyObject car;
    private IRubyObject cdr;

    public RubyArrayTwoObject(Ruby runtime, IRubyObject car, IRubyObject cdr) {
        super(runtime, false);
        this.car = car;
        this.cdr = cdr;
        this.realLength = 2;
    }

    public RubyArrayTwoObject(RubyClass otherClass, IRubyObject car, IRubyObject cdr) {
        super(otherClass, false);
        this.car = car;
        this.cdr = cdr;
        this.realLength = 2;
    }

    RubyArrayTwoObject(RubyArrayTwoObject other) {
        this(other.getMetaClass(), other.car, other.cdr);
    }

    RubyArrayTwoObject(RubyClass metaClass, RubyArrayTwoObject other) {
        this(metaClass, other.car, other.cdr);
    }

    @Override
    public final IRubyObject eltInternal(int index2) {
        if (!this.packed()) {
            return super.eltInternal(index2);
        }
        if (index2 == 0) {
            return this.car;
        }
        if (index2 == 1) {
            return this.cdr;
        }
        throw new ArrayIndexOutOfBoundsException(index2);
    }

    @Override
    public final IRubyObject eltInternalSet(int index2, IRubyObject value2) {
        if (!this.packed()) {
            return super.eltInternalSet(index2, value2);
        }
        if (index2 == 0) {
            this.car = value2;
            return this.car;
        }
        if (index2 == 1) {
            this.cdr = value2;
            return this.cdr;
        }
        throw new ArrayIndexOutOfBoundsException(index2);
    }

    @Override
    protected void finishUnpack(IRubyObject nil) {
        this.car = this.cdr = nil;
    }

    @Override
    public RubyArray aryDup() {
        if (!this.packed()) {
            return super.aryDup();
        }
        return new RubyArrayTwoObject(this.getRuntime().getArray(), this);
    }

    @Override
    public IRubyObject rb_clear() {
        IRubyObject nil;
        if (!this.packed()) {
            return super.rb_clear();
        }
        this.modifyCheck();
        this.car = this.cdr = (nil = this.getRuntime().getNil());
        this.values = IRubyObject.NULL_ARRAY;
        this.realLength = 0;
        return this;
    }

    @Override
    public IRubyObject collect(ThreadContext context, Block block) {
        if (!this.packed()) {
            return super.collect(context, block);
        }
        return new RubyArrayTwoObject(this.getRuntime(), block.yield(context, this.car), block.yield(context, this.cdr));
    }

    @Override
    public void copyInto(IRubyObject[] target, int start2) {
        if (!this.packed()) {
            super.copyInto(target, start2);
            return;
        }
        target[start2] = this.car;
        target[start2 + 1] = this.cdr;
    }

    @Override
    public void copyInto(IRubyObject[] target, int start2, int len) {
        if (!this.packed()) {
            super.copyInto(target, start2, len);
            return;
        }
        if (len != 2) {
            this.unpack();
            super.copyInto(target, start2, len);
            return;
        }
        target[start2] = this.car;
        target[start2 + 1] = this.cdr;
    }

    @Override
    public IRubyObject dup() {
        if (!this.packed()) {
            return super.dup();
        }
        return new RubyArrayTwoObject(this);
    }

    @Override
    public IRubyObject each(ThreadContext context, Block block) {
        if (!this.packed()) {
            return super.each(context, block);
        }
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, this, "each", this.enumLengthFn());
        }
        block.yield(context, this.car);
        block.yield(context, this.cdr);
        return this;
    }

    @Override
    protected IRubyObject fillCommon(ThreadContext context, int beg, long len, Block block) {
        if (!this.packed()) {
            return super.fillCommon(context, beg, len, block);
        }
        this.unpack();
        return super.fillCommon(context, beg, len, block);
    }

    @Override
    protected IRubyObject fillCommon(ThreadContext context, int beg, long len, IRubyObject item) {
        if (!this.packed()) {
            return super.fillCommon(context, beg, len, item);
        }
        this.unpack();
        return super.fillCommon(context, beg, len, item);
    }

    @Override
    public boolean includes(ThreadContext context, IRubyObject item) {
        if (!this.packed()) {
            return super.includes(context, item);
        }
        if (RubyArrayTwoObject.equalInternal(context, this.car, item)) {
            return true;
        }
        return RubyArrayTwoObject.equalInternal(context, this.cdr, item);
    }

    @Override
    public int indexOf(Object element) {
        if (!this.packed()) {
            return super.indexOf(element);
        }
        if (element != null) {
            IRubyObject convertedElement = JavaUtil.convertJavaToUsableRubyObject(this.getRuntime(), element);
            if (convertedElement.equals(this.car)) {
                return 0;
            }
            if (convertedElement.equals(this.cdr)) {
                return 1;
            }
        }
        return -1;
    }

    @Override
    protected IRubyObject inspectAry(ThreadContext context) {
        if (!this.packed()) {
            return super.inspectAry(context);
        }
        Ruby runtime = context.runtime;
        RubyString str = RubyString.newStringLight(runtime, 10, (Encoding)USASCIIEncoding.INSTANCE);
        EncodingUtils.strBufCat(runtime, str, OPEN_BRACKET);
        boolean tainted = this.isTaint();
        RubyString s1 = RubyArrayTwoObject.inspect(context, this.car);
        RubyString s2 = RubyArrayTwoObject.inspect(context, this.cdr);
        if (s1.isTaint()) {
            tainted = true;
        } else {
            str.setEncoding(s1.getEncoding());
        }
        str.cat19(s1);
        EncodingUtils.strBufCat(runtime, str, COMMA_SPACE);
        if (s2.isTaint()) {
            tainted = true;
        } else {
            str.setEncoding(s2.getEncoding());
        }
        str.cat19(s2);
        EncodingUtils.strBufCat(runtime, str, CLOSE_BRACKET);
        if (tainted) {
            str.setTaint(true);
        }
        return str;
    }

    @Override
    protected IRubyObject internalRotate(ThreadContext context, int cnt) {
        if (!this.packed()) {
            return super.internalRotate(context, cnt);
        }
        if (cnt % 2 == 1) {
            return new RubyArrayTwoObject(context.runtime, this.cdr, this.car);
        }
        return new RubyArrayTwoObject(context.runtime, this.car, this.cdr);
    }

    @Override
    protected IRubyObject internalRotateBang(ThreadContext context, int cnt) {
        if (!this.packed()) {
            return super.internalRotateBang(context, cnt);
        }
        this.modifyCheck();
        if (cnt % 2 == 1) {
            IRubyObject tmp = this.car;
            this.car = this.cdr;
            this.cdr = tmp;
        }
        return context.nil;
    }

    @Override
    public IRubyObject op_plus(IRubyObject obj) {
        if (!this.packed()) {
            return super.op_plus(obj);
        }
        RubyArray y = obj.convertToArray();
        if (y.size() == 0) {
            return new RubyArrayTwoObject(this);
        }
        return super.op_plus(y);
    }

    @Override
    public IRubyObject replace(IRubyObject orig) {
        if (!this.packed()) {
            return super.replace(orig);
        }
        this.modifyCheck();
        RubyArray origArr = orig.convertToArray();
        if (this == orig) {
            return this;
        }
        if (origArr.size() == 2) {
            this.car = origArr.eltInternal(0);
            this.cdr = origArr.eltInternal(0);
            return this;
        }
        this.unpack();
        return super.replace(origArr);
    }

    @Override
    public IRubyObject reverse_bang() {
        if (!this.packed()) {
            return super.reverse_bang();
        }
        IRubyObject tmp = this.car;
        this.car = this.cdr;
        this.cdr = tmp;
        return this;
    }

    @Override
    protected RubyArray safeReverse() {
        if (!this.packed()) {
            return super.safeReverse();
        }
        return new RubyArrayTwoObject(this.getMetaClass(), this.cdr, this.car);
    }

    @Override
    protected IRubyObject sortInternal(ThreadContext context, Block block) {
        if (!this.packed()) {
            return super.sortInternal(context, block);
        }
        IRubyObject ret = block.yieldArray(context, RubyArrayTwoObject.newArray(context.runtime, this.car, this.cdr), null);
        int compare = RubyComparable.cmpint(context, ret, this.car, this.cdr);
        if (compare > 0) {
            this.reverse_bang();
        }
        return this;
    }

    @Override
    protected IRubyObject sortInternal(ThreadContext context, boolean honorOverride) {
        if (!this.packed()) {
            return super.sortInternal(context, honorOverride);
        }
        Ruby runtime = context.runtime;
        boolean fixnumBypass = !honorOverride || runtime.getFixnum().isMethodBuiltin("<=>");
        boolean stringBypass = !honorOverride || runtime.getString().isMethodBuiltin("<=>");
        IRubyObject o1 = this.car;
        IRubyObject o2 = this.cdr;
        int compare = fixnumBypass && o1 instanceof RubyFixnum && o2 instanceof RubyFixnum ? RubyArrayTwoObject.compareFixnums((RubyFixnum)o1, (RubyFixnum)o2) : (stringBypass && o1 instanceof RubyString && o2 instanceof RubyString ? ((RubyString)o1).op_cmp((RubyString)o2) : RubyArrayTwoObject.compareOthers(context, o1, o2));
        if (compare > 0) {
            this.reverse_bang();
        }
        return this;
    }

    @Override
    public IRubyObject store(long index2, IRubyObject value2) {
        if (!this.packed()) {
            return super.store(index2, value2);
        }
        switch ((int)index2) {
            case 0: {
                this.car = value2;
                return this.car;
            }
            case 1: {
                this.cdr = value2;
                return this.cdr;
            }
        }
        this.unpack();
        return super.store(index2, value2);
    }

    @Override
    public IRubyObject subseq(RubyClass metaClass, long beg, long len, boolean light) {
        if (!this.packed()) {
            return super.subseq(metaClass, beg, len, light);
        }
        Ruby runtime = this.getRuntime();
        if (beg > 2L || beg < 0L || len < 0L) {
            return runtime.getNil();
        }
        if (len == 0L || beg == 2L) {
            return new RubyArray(runtime, metaClass, IRubyObject.NULL_ARRAY);
        }
        if (beg == 0L) {
            if (len == 1L) {
                return new RubyArrayOneObject(metaClass, this.car);
            }
            return new RubyArrayTwoObject(metaClass, this);
        }
        return new RubyArrayOneObject(metaClass, this.cdr);
    }

    @Override
    public IRubyObject[] toJavaArray() {
        if (!this.packed()) {
            return super.toJavaArray();
        }
        return Helpers.arrayOf(this.car, this.cdr);
    }

    @Override
    public IRubyObject uniq(ThreadContext context) {
        if (!this.packed()) {
            return super.uniq(context);
        }
        if (Helpers.invokedynamic(context, this.car, MethodNames.HASH).equals(Helpers.invokedynamic(context, this.cdr, MethodNames.HASH)) && (this.car == this.cdr || Helpers.invokedynamic(context, this.car, MethodNames.EQL, this.cdr).isTrue())) {
            return new RubyArrayOneObject(this.getMetaClass(), this.cdr);
        }
        return new RubyArrayTwoObject(this);
    }
}

