/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.targets;

import com.headius.invokebinder.Signature;
import java.util.HashMap;
import java.util.Map;
import org.jruby.ir.IRScope;
import org.jruby.ir.operands.Label;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.targets.IRBytecodeAdapter;
import org.jruby.ir.targets.JVM;
import org.objectweb.asm.Type;

public class MethodData {
    public final IRBytecodeAdapter method;
    public final IRScope scope;
    public final Signature signature;
    public final int specificArity;
    public final Map<String, Integer> varMap = new HashMap<String, Integer>();
    public final Map<Label, org.objectweb.asm.Label> labelMap = new HashMap<Label, org.objectweb.asm.Label>();

    public MethodData(IRBytecodeAdapter method, IRScope scope, Signature signature, int specificArity) {
        this.method = method;
        this.scope = scope;
        this.signature = signature;
        this.specificArity = specificArity;
        for (int i2 = 0; i2 < signature.argCount(); ++i2) {
            this.local("$" + signature.argName(i2), Type.getType((Class)signature.argType(i2)));
        }
        this.local("$dynamicScope");
    }

    public int local(Variable variable, Type type2) {
        String newName = variable.getName().replace('%', '$');
        return this.local(newName, type2);
    }

    public int local(Variable variable) {
        return this.local(variable, JVM.OBJECT_TYPE);
    }

    public int local(String newName) {
        return this.local(newName, JVM.OBJECT_TYPE);
    }

    public int local(String newName, Type type2) {
        if (this.varMap.containsKey(newName)) {
            return this.varMap.get(newName);
        }
        int index2 = this.method.newLocal(newName, type2);
        this.varMap.put(newName, index2);
        return index2;
    }

    public org.objectweb.asm.Label getLabel(Label label2) {
        org.objectweb.asm.Label asmLabel = this.labelMap.get(label2);
        if (asmLabel == null) {
            asmLabel = this.method.newLabel();
            this.labelMap.put(label2, asmLabel);
        }
        return asmLabel;
    }
}

