/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComparable;
import org.jruby.RubyEnumerable;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyRandom;
import org.jruby.RubyRange;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.RaiseException;
import org.jruby.java.util.ArrayUtils;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CacheEntry;
import org.jruby.runtime.callsite.CachingCallSite;
import org.jruby.runtime.encoding.EncodingCapable;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.specialized.RubyArrayOneObject;
import org.jruby.specialized.RubyArrayTwoObject;
import org.jruby.util.ByteList;
import org.jruby.util.Pack;
import org.jruby.util.RecursiveComparator;
import org.jruby.util.TypeConverter;
import org.jruby.util.io.EncodingUtils;

@JRubyClass(name={"Array"})
public class RubyArray
extends RubyObject
implements List,
RandomAccess {
    public static final int DEFAULT_INSPECT_STR_SIZE = 10;
    private static ObjectAllocator ARRAY_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyArray(runtime, klass, IRubyObject.NULL_ARRAY);
        }
    };
    public static final int ARRAY_DEFAULT_SIZE = 16;
    protected volatile IRubyObject[] values;
    private static final int TMPLOCK_ARR_F = 512;
    private static final int TMPLOCK_OR_FROZEN_ARR_F = 0x200 | FROZEN_F;
    protected volatile boolean isShared = false;
    protected int begin = 0;
    protected int realLength = 0;
    private static final ByteList EMPTY_ARRAY_BYTELIST = new ByteList(ByteList.plain((CharSequence)"[]"), (Encoding)USASCIIEncoding.INSTANCE);
    private static final ByteList RECURSIVE_ARRAY_BYTELIST = new ByteList(ByteList.plain((CharSequence)"[...]"), (Encoding)USASCIIEncoding.INSTANCE);
    protected static final ByteList OPEN_BRACKET = new ByteList(new byte[]{91}, (Encoding)USASCIIEncoding.INSTANCE);
    protected static final ByteList CLOSE_BRACKET = new ByteList(new byte[]{93}, (Encoding)USASCIIEncoding.INSTANCE);
    protected static final ByteList COMMA_SPACE = new ByteList(new byte[]{44, 32}, (Encoding)USASCIIEncoding.INSTANCE);
    private static final int SORTED_THRESHOLD = 10;

    public static RubyClass createArrayClass(Ruby runtime) {
        RubyClass arrayc = runtime.defineClass("Array", runtime.getObject(), ARRAY_ALLOCATOR);
        runtime.setArray(arrayc);
        arrayc.setClassIndex(ClassIndex.ARRAY);
        arrayc.setReifiedClass(RubyArray.class);
        arrayc.kindOf = new RubyModule.JavaClassKindOf(RubyArray.class);
        arrayc.includeModule(runtime.getEnumerable());
        arrayc.defineAnnotatedMethods(RubyArray.class);
        return arrayc;
    }

    @Override
    public ClassIndex getNativeClassIndex() {
        return ClassIndex.ARRAY;
    }

    protected final void concurrentModification() {
        RubyArray.concurrentModification(this.getRuntime(), null);
    }

    private static void concurrentModification(Ruby runtime, Exception cause2) {
        RaiseException ex = runtime.newConcurrencyError("Detected invalid array contents due to unsynchronized modifications with concurrent users");
        throw ex;
    }

    @JRubyMethod(name={"[]"}, rest=true, meta=true)
    public static IRubyObject create(IRubyObject klass, IRubyObject[] args2, Block block) {
        switch (args2.length) {
            case 1: {
                return new RubyArrayOneObject((RubyClass)klass, args2[0]);
            }
            case 2: {
                return new RubyArrayTwoObject((RubyClass)klass, args2[0], args2[1]);
            }
        }
        RubyArray arr = (RubyArray)((RubyClass)klass).allocate();
        if (args2.length > 0) {
            arr.values = new IRubyObject[args2.length];
            System.arraycopy(args2, 0, arr.values, 0, args2.length);
            arr.realLength = args2.length;
        }
        return arr;
    }

    public static final RubyArray newArray(Ruby runtime, long len) {
        RubyArray.checkLength(runtime, len);
        return RubyArray.newArray(runtime, (int)len);
    }

    public static final RubyArray newArrayLight(Ruby runtime, long len) {
        RubyArray.checkLength(runtime, len);
        return RubyArray.newArrayLight(runtime, (int)len);
    }

    public static final RubyArray newArray(Ruby runtime, int len) {
        RubyArray array = new RubyArray(runtime, len);
        Helpers.fillNil(array.values, 0, len, runtime);
        return array;
    }

    public static final RubyArray newArrayLight(Ruby runtime, int len) {
        RubyArray array = new RubyArray(runtime, len, false);
        Helpers.fillNil(array.values, 0, len, runtime);
        return array;
    }

    public static final RubyArray newArray(Ruby runtime) {
        return RubyArray.newArray(runtime, 16);
    }

    public static final RubyArray newArrayLight(Ruby runtime) {
        return RubyArray.newArrayLight(runtime, 16);
    }

    public static RubyArray newArray(Ruby runtime, IRubyObject obj) {
        return new RubyArrayOneObject(runtime, obj);
    }

    public static RubyArray newArrayLight(Ruby runtime, IRubyObject obj) {
        return new RubyArrayOneObject(runtime, obj);
    }

    public static RubyArray newArrayLight(Ruby runtime, IRubyObject car, IRubyObject cdr) {
        return new RubyArrayTwoObject(runtime, car, cdr);
    }

    public static RubyArray newArrayLight(Ruby runtime, IRubyObject ... objs) {
        return new RubyArray(runtime, objs, false);
    }

    public static RubyArray newArray(Ruby runtime, IRubyObject car, IRubyObject cdr) {
        return new RubyArrayTwoObject(runtime, car, cdr);
    }

    public static RubyArray newArray(Ruby runtime, IRubyObject first2, IRubyObject second, IRubyObject third) {
        return new RubyArray(runtime, new IRubyObject[]{first2, second, third});
    }

    public static RubyArray newArray(Ruby runtime, IRubyObject first2, IRubyObject second, IRubyObject third, IRubyObject fourth) {
        return new RubyArray(runtime, new IRubyObject[]{first2, second, third, fourth});
    }

    public static RubyArray newEmptyArray(Ruby runtime) {
        return new RubyArray(runtime, NULL_ARRAY);
    }

    public static RubyArray newArray(Ruby runtime, IRubyObject[] args2) {
        switch (args2.length) {
            case 0: {
                return RubyArray.newEmptyArray(runtime);
            }
            case 1: {
                return new RubyArrayOneObject(runtime, args2[0]);
            }
            case 2: {
                return new RubyArrayTwoObject(runtime, args2[0], args2[1]);
            }
        }
        RubyArray arr = new RubyArray(runtime, new IRubyObject[args2.length]);
        System.arraycopy(args2, 0, arr.values, 0, args2.length);
        arr.realLength = args2.length;
        return arr;
    }

    public static RubyArray newArrayMayCopy(Ruby runtime, IRubyObject ... args2) {
        switch (args2.length) {
            case 0: {
                return RubyArray.newEmptyArray(runtime);
            }
            case 1: {
                return new RubyArrayOneObject(runtime, args2[0]);
            }
            case 2: {
                return new RubyArrayTwoObject(runtime, args2[0], args2[1]);
            }
        }
        return RubyArray.newArrayNoCopy(runtime, args2, 0, args2.length);
    }

    public static RubyArray newArrayMayCopy(Ruby runtime, IRubyObject[] args2, int start2) {
        return RubyArray.newArrayMayCopy(runtime, args2, start2, args2.length - start2);
    }

    public static RubyArray newArrayMayCopy(Ruby runtime, IRubyObject[] args2, int start2, int length2) {
        switch (length2) {
            case 0: {
                return RubyArray.newEmptyArray(runtime);
            }
            case 1: {
                return new RubyArrayOneObject(runtime, args2[start2]);
            }
            case 2: {
                return new RubyArrayTwoObject(runtime, args2[start2], args2[start2 + 1]);
            }
        }
        return RubyArray.newArrayNoCopy(runtime, args2, start2, length2);
    }

    public static RubyArray newArrayNoCopy(Ruby runtime, IRubyObject[] args2) {
        return new RubyArray(runtime, args2);
    }

    public static RubyArray newArrayNoCopy(Ruby runtime, IRubyObject[] args2, int begin2) {
        return new RubyArray(runtime, args2, begin2);
    }

    public static RubyArray newArrayNoCopy(Ruby runtime, IRubyObject[] args2, int begin2, int length2) {
        assert (begin2 >= 0) : "begin must be >= 0";
        assert (length2 >= 0) : "length must be >= 0";
        return new RubyArray(runtime, args2, begin2, length2);
    }

    public static RubyArray newArrayNoCopyLight(Ruby runtime, IRubyObject[] args2) {
        RubyArray arr = new RubyArray(runtime, false);
        arr.values = args2;
        arr.realLength = args2.length;
        return arr;
    }

    public static RubyArray newArray(Ruby runtime, Collection<? extends IRubyObject> collection) {
        IRubyObject[] values2 = collection.toArray(new IRubyObject[collection.size()]);
        switch (values2.length) {
            case 0: {
                return RubyArray.newEmptyArray(runtime);
            }
            case 1: {
                return new RubyArrayOneObject(runtime, values2[0]);
            }
            case 2: {
                return new RubyArrayTwoObject(runtime, values2[0], values2[1]);
            }
        }
        return new RubyArray(runtime, values2);
    }

    public static RubyArray newArray(Ruby runtime, List<? extends IRubyObject> list2) {
        switch (list2.size()) {
            case 0: {
                return RubyArray.newEmptyArray(runtime);
            }
            case 1: {
                return new RubyArrayOneObject(runtime, list2.get(0));
            }
            case 2: {
                return new RubyArrayTwoObject(runtime, list2.get(0), list2.get(1));
            }
        }
        return new RubyArray(runtime, list2.toArray(new IRubyObject[list2.size()]));
    }

    private RubyArray(Ruby runtime, IRubyObject[] vals) {
        super(runtime, runtime.getArray());
        this.values = vals;
        this.realLength = vals.length;
    }

    private RubyArray(Ruby runtime, IRubyObject[] vals, boolean objectSpace) {
        super(runtime, runtime.getArray(), objectSpace);
        this.values = vals;
        this.realLength = vals.length;
    }

    private RubyArray(Ruby runtime, IRubyObject[] vals, int begin2) {
        super(runtime, runtime.getArray());
        this.values = vals;
        this.begin = begin2;
        this.realLength = vals.length - begin2;
        this.isShared = true;
    }

    private RubyArray(Ruby runtime, IRubyObject[] vals, int begin2, int length2) {
        super(runtime, runtime.getArray());
        this.values = vals;
        this.begin = begin2;
        this.realLength = length2;
        this.isShared = true;
    }

    public RubyArray(Ruby runtime, int length2) {
        super(runtime, runtime.getArray());
        this.values = length2 == 0 ? IRubyObject.NULL_ARRAY : new IRubyObject[length2];
    }

    private RubyArray(Ruby runtime, int length2, boolean objectspace) {
        super(runtime, runtime.getArray(), objectspace);
        this.values = length2 == 0 ? IRubyObject.NULL_ARRAY : new IRubyObject[length2];
    }

    private RubyArray(Ruby runtime, boolean objectSpace) {
        super(runtime, runtime.getArray(), objectSpace);
    }

    protected RubyArray(Ruby runtime, RubyClass klass) {
        super(runtime, klass);
    }

    private RubyArray(Ruby runtime, RubyClass klass, int length2) {
        super(runtime, klass);
        this.values = length2 == 0 ? IRubyObject.NULL_ARRAY : new IRubyObject[length2];
    }

    private RubyArray(Ruby runtime, RubyClass klass, IRubyObject[] vals, boolean objectspace) {
        super(runtime, klass, objectspace);
        this.values = vals;
    }

    protected RubyArray(Ruby runtime, RubyClass klass, boolean objectSpace) {
        super(runtime, klass, objectSpace);
    }

    public RubyArray(Ruby runtime, RubyClass klass, IRubyObject[] vals) {
        super(runtime, klass);
        this.values = vals;
        this.realLength = vals.length;
    }

    protected void unpack() {
    }

    private void alloc(int length2) {
        IRubyObject[] newValues = length2 == 0 ? IRubyObject.NULL_ARRAY : new IRubyObject[length2];
        Helpers.fillNil(newValues, this.getRuntime());
        this.values = newValues;
        this.begin = 0;
    }

    private void realloc(int newLength, int valuesLength) {
        this.unpack();
        IRubyObject[] reallocated = new IRubyObject[newLength];
        if (newLength > valuesLength) {
            Helpers.fillNil(reallocated, valuesLength, newLength, this.getRuntime());
            this.safeArrayCopy(this.values, this.begin, reallocated, 0, valuesLength);
        } else {
            this.safeArrayCopy(this.values, this.begin, reallocated, 0, newLength);
        }
        this.begin = 0;
        this.values = reallocated;
    }

    private static void fill(IRubyObject[] arr, int from, int to, IRubyObject with) {
        for (int i2 = from; i2 < to; ++i2) {
            arr[i2] = with;
        }
    }

    protected static final void checkLength(Ruby runtime, long length2) {
        if (length2 < 0L) {
            throw runtime.newArgumentError("negative array size (or size too big)");
        }
        if (length2 >= Integer.MAX_VALUE) {
            throw runtime.newArgumentError("array size too big");
        }
    }

    public final List<IRubyObject> getList() {
        return Arrays.asList(this.toJavaArray());
    }

    public int getLength() {
        return this.realLength;
    }

    public IRubyObject[] toJavaArray() {
        IRubyObject[] copy = new IRubyObject[this.realLength];
        this.copyInto(copy, 0);
        return copy;
    }

    public IRubyObject[] toJavaArrayUnsafe() {
        this.unpack();
        return !this.isShared ? this.values : this.toJavaArray();
    }

    public IRubyObject[] toJavaArrayMaybeUnsafe() {
        this.unpack();
        return !this.isShared && this.begin == 0 && this.values.length == this.realLength ? this.values : this.toJavaArray();
    }

    private RubyArray makeShared() {
        this.unpack();
        return this.makeShared(this.begin, this.realLength, this.getMetaClass());
    }

    private RubyArray makeShared(int beg, int len, RubyClass klass) {
        return this.makeShared(beg, len, new RubyArray(klass.getRuntime(), klass));
    }

    private final RubyArray makeShared(int beg, int len, RubyArray sharedArray) {
        this.unpack();
        this.isShared = true;
        sharedArray.values = this.values;
        sharedArray.isShared = true;
        sharedArray.begin = beg;
        sharedArray.realLength = len;
        return sharedArray;
    }

    private RubyArray makeSharedFirst(ThreadContext context, IRubyObject num, boolean last2, RubyClass klass) {
        int n = RubyNumeric.num2int(num);
        if (n > this.realLength) {
            n = this.realLength;
        } else if (n < 0) {
            throw context.runtime.newArgumentError("negative array size");
        }
        return this.makeShared(last2 ? this.begin + this.realLength - n : this.begin, n, klass);
    }

    protected final void modifyCheck() {
        if ((this.flags & TMPLOCK_OR_FROZEN_ARR_F) != 0) {
            if ((this.flags & FROZEN_F) != 0) {
                throw this.getRuntime().newFrozenError("array");
            }
            if ((this.flags & 0x200) != 0) {
                throw this.getRuntime().newTypeError("can't modify array during iteration");
            }
        }
    }

    protected void modify() {
        this.modifyCheck();
        if (this.isShared) {
            IRubyObject[] vals = new IRubyObject[this.realLength];
            this.safeArrayCopy(this.values, this.begin, vals, 0, this.realLength);
            this.begin = 0;
            this.values = vals;
            this.isShared = false;
        }
    }

    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2, Block block) {
        switch (args2.length) {
            case 0: {
                return this.initialize(context, block);
            }
            case 1: {
                return this.initializeCommon(context, args2[0], null, block);
            }
            case 2: {
                return this.initializeCommon(context, args2[0], args2[1], block);
            }
        }
        Arity.raiseArgumentError(this.getRuntime(), args2.length, 0, 2);
        return null;
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, Block block) {
        this.modifyCheck();
        this.unpack();
        Ruby runtime = context.runtime;
        this.realLength = 0;
        if (block.isGiven() && runtime.isVerbose()) {
            runtime.getWarnings().warning(IRubyWarnings.ID.BLOCK_UNUSED, "given block not used");
        }
        return this;
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject arg0, Block block) {
        return this.initializeCommon(context, arg0, null, block);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        return this.initializeCommon(context, arg0, arg1, block);
    }

    protected IRubyObject initializeCommon(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        IRubyObject val;
        this.unpack();
        Ruby runtime = context.runtime;
        if (arg1 == null && !(arg0 instanceof RubyFixnum) && !(val = arg0.checkArrayType()).isNil()) {
            this.replace(val);
            return this;
        }
        long len = RubyNumeric.num2long(arg0);
        if (len < 0L) {
            throw runtime.newArgumentError("negative array size");
        }
        if (len >= Integer.MAX_VALUE) {
            throw runtime.newArgumentError("array size too big");
        }
        int ilen = (int)len;
        this.modify();
        if (ilen > this.values.length - this.begin) {
            this.values = new IRubyObject[ilen];
            this.begin = 0;
        }
        if (block.isGiven()) {
            if (arg1 != null) {
                runtime.getWarnings().warn(IRubyWarnings.ID.BLOCK_BEATS_DEFAULT_VALUE, "block supersedes default value argument");
            }
            if (block.getSignature() == Signature.NO_ARGUMENTS) {
                IRubyObject nil = runtime.getNil();
                for (int i2 = 0; i2 < ilen; ++i2) {
                    this.store(i2, block.yield(context, nil));
                    this.realLength = i2 + 1;
                }
            } else {
                for (int i3 = 0; i3 < ilen; ++i3) {
                    this.store(i3, block.yield(context, RubyFixnum.newFixnum(runtime, i3)));
                    this.realLength = i3 + 1;
                }
            }
        } else {
            try {
                if (arg1 == null) {
                    Helpers.fillNil(this.values, this.begin, this.begin + ilen, runtime);
                } else {
                    RubyArray.fill(this.values, this.begin, this.begin + ilen, arg1);
                }
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                RubyArray.concurrentModification(runtime, ex);
            }
            this.realLength = ilen;
        }
        return this;
    }

    @Override
    @JRubyMethod(name={"initialize_copy"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject orig) {
        return this.replace(orig);
    }

    @Override
    public IRubyObject dup() {
        if (this.metaClass.getClassIndex() != ClassIndex.ARRAY) {
            return super.dup();
        }
        RubyArray dup2 = new RubyArray(this.metaClass.getClassRuntime(), this.values, this.begin, this.realLength);
        this.isShared = true;
        dup2.isShared = true;
        dup2.flags |= this.flags & TAINTED_F;
        return dup2;
    }

    @JRubyMethod(name={"replace"}, required=1)
    public IRubyObject replace(IRubyObject orig) {
        this.unpack();
        this.modifyCheck();
        RubyArray origArr = orig.convertToArray();
        if (this == orig) {
            return this;
        }
        origArr.unpack();
        origArr.isShared = true;
        this.isShared = true;
        this.values = origArr.values;
        this.realLength = origArr.realLength;
        this.begin = origArr.begin;
        return this;
    }

    @Override
    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s() {
        return this.inspect();
    }

    public boolean includes(ThreadContext context, IRubyObject item) {
        int myBegin = this.begin;
        int end2 = myBegin + this.realLength;
        IRubyObject[] values2 = this.values;
        Ruby runtime = context.runtime;
        for (int i2 = myBegin; i2 < end2; ++i2) {
            IRubyObject value2 = RubyArray.safeArrayRef(runtime, values2, i2);
            if (!RubyArray.equalInternal(context, value2, item)) continue;
            return true;
        }
        return false;
    }

    public RubyFixnum hash19(ThreadContext context) {
        return this.hash(context);
    }

    @JRubyMethod(name={"hash"})
    public RubyFixnum hash(ThreadContext context) {
        Ruby runtime = context.runtime;
        long h = Helpers.hashStart(runtime, this.realLength);
        h = Helpers.murmurCombine(h, System.identityHashCode(RubyArray.class));
        for (int i2 = 0; i2 < this.realLength; ++i2) {
            IRubyObject value2 = this.eltOk(i2);
            RubyFixnum n = Helpers.safeHash(context, value2);
            h = Helpers.murmurCombine(h, n.getLongValue());
        }
        h = Helpers.hashEnd(h);
        return runtime.newFixnum(h);
    }

    public IRubyObject store(long index2, IRubyObject value2) {
        if (index2 < 0L && (index2 += (long)this.realLength) < 0L) {
            throw this.getRuntime().newIndexError("index " + (index2 - (long)this.realLength) + " out of array");
        }
        this.modify();
        if (index2 >= (long)this.realLength) {
            int valuesLength = this.values.length - this.begin;
            if (index2 >= (long)valuesLength) {
                this.storeRealloc(index2, valuesLength);
            }
            this.realLength = (int)index2 + 1;
        }
        this.safeArraySet(this.values, this.begin + (int)index2, value2);
        return value2;
    }

    private void storeRealloc(long index2, int valuesLength) {
        long newLength = valuesLength >> 1;
        if (newLength < 16L) {
            newLength = 16L;
        }
        if (index2 >= Integer.MAX_VALUE || (newLength += index2) >= Integer.MAX_VALUE) {
            throw this.getRuntime().newArgumentError("index too big");
        }
        this.realloc((int)newLength, valuesLength);
    }

    private final IRubyObject elt(long offset2) {
        if (offset2 < 0L || offset2 >= (long)this.realLength) {
            return this.getRuntime().getNil();
        }
        return this.eltOk(offset2);
    }

    public IRubyObject eltOk(long offset2) {
        try {
            return this.eltInternal((int)offset2);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            RubyArray.concurrentModification(this.getRuntime(), ex);
            return null;
        }
    }

    public IRubyObject eltSetOk(long offset2, IRubyObject value2) {
        return this.eltSetOk((int)offset2, value2);
    }

    public IRubyObject eltSetOk(int offset2, IRubyObject value2) {
        try {
            return this.eltInternalSet(offset2, value2);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            RubyArray.concurrentModification(this.getRuntime(), ex);
            return null;
        }
    }

    public final IRubyObject entry(long offset2) {
        return offset2 < 0L ? this.elt(offset2 + (long)this.realLength) : this.elt(offset2);
    }

    public final IRubyObject entry(int offset2) {
        return offset2 < 0 ? this.elt(offset2 + this.realLength) : this.elt(offset2);
    }

    public IRubyObject eltInternal(int offset2) {
        return this.values[this.begin + offset2];
    }

    public IRubyObject eltInternalSet(int offset2, IRubyObject item) {
        IRubyObject iRubyObject = item;
        this.values[this.begin + offset2] = iRubyObject;
        return iRubyObject;
    }

    public IRubyObject fetch(ThreadContext context, IRubyObject[] args2, Block block) {
        switch (args2.length) {
            case 1: {
                return this.fetch(context, args2[0], block);
            }
            case 2: {
                return this.fetch(context, args2[0], args2[1], block);
            }
        }
        Arity.raiseArgumentError(this.getRuntime(), args2.length, 1, 2);
        return null;
    }

    @JRubyMethod
    public IRubyObject fetch(ThreadContext context, IRubyObject arg0, Block block) {
        long index2 = RubyNumeric.num2long(arg0);
        if (index2 < 0L) {
            index2 += (long)this.realLength;
        }
        if (index2 < 0L || index2 >= (long)this.realLength) {
            if (block.isGiven()) {
                return block.yield(context, arg0);
            }
            throw context.runtime.newIndexError("index " + index2 + " out of array");
        }
        return this.eltOk((int)index2);
    }

    @JRubyMethod
    public IRubyObject fetch(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        long index2;
        if (block.isGiven()) {
            context.runtime.getWarnings().warn(IRubyWarnings.ID.BLOCK_BEATS_DEFAULT_VALUE, "block supersedes default value argument");
        }
        if ((index2 = RubyNumeric.num2long(arg0)) < 0L) {
            index2 += (long)this.realLength;
        }
        if (index2 < 0L || index2 >= (long)this.realLength) {
            if (block.isGiven()) {
                return block.yield(context, arg0);
            }
            return arg1;
        }
        return this.eltOk((int)index2);
    }

    public static RubyArray aryToAry(IRubyObject obj) {
        IRubyObject tmp = TypeConverter.checkArrayType(obj);
        if (!tmp.isNil()) {
            return (RubyArray)tmp;
        }
        return obj.getRuntime().newArray(obj);
    }

    private final void splice(long beg, long len, IRubyObject rpl, boolean oneNine) {
        int rlen;
        RubyArray rplArr;
        if (len < 0L) {
            throw this.getRuntime().newIndexError("negative length (" + len + ")");
        }
        if (beg < 0L && (beg += (long)this.realLength) < 0L) {
            throw this.getRuntime().newIndexError("index " + (beg - (long)this.realLength) + " out of array");
        }
        if (rpl == null || rpl.isNil() && !oneNine) {
            rplArr = null;
            rlen = 0;
        } else if (rpl.isNil()) {
            rplArr = RubyArray.newArray(this.getRuntime(), rpl);
            rlen = 1;
        } else {
            rplArr = RubyArray.aryToAry(rpl);
            rlen = rplArr.realLength;
        }
        this.unpack();
        this.modify();
        int valuesLength = this.values.length - this.begin;
        if (beg >= (long)this.realLength) {
            len = beg + (long)rlen;
            if (len >= (long)valuesLength) {
                this.spliceRealloc((int)len, valuesLength);
            }
            try {
                Helpers.fillNil(this.values, this.begin + this.realLength, this.begin + (int)beg, this.getRuntime());
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.concurrentModification();
            }
            this.realLength = (int)len;
        } else {
            int alen;
            if (beg + len > (long)this.realLength) {
                len = (long)this.realLength - beg;
            }
            if ((alen = this.realLength + rlen - (int)len) >= valuesLength) {
                this.spliceRealloc(alen, valuesLength);
            }
            if (len != (long)rlen) {
                this.safeArrayCopy(this.values, this.begin + (int)(beg + len), this.values, this.begin + (int)beg + rlen, this.realLength - (int)(beg + len));
                this.realLength = alen;
            }
        }
        if (rlen > 0) {
            rplArr.copyInto(this.values, this.begin + (int)beg, rlen);
        }
    }

    private final void spliceOne(long beg, IRubyObject rpl) {
        if (beg < 0L && (beg += (long)this.realLength) < 0L) {
            throw this.getRuntime().newIndexError("index " + (beg - (long)this.realLength) + " out of array");
        }
        this.unpack();
        this.modify();
        int valuesLength = this.values.length - this.begin;
        if (beg >= (long)this.realLength) {
            int len = (int)beg + 1;
            if (len >= valuesLength) {
                this.spliceRealloc(len, valuesLength);
            }
            Helpers.fillNil(this.values, this.begin + this.realLength, this.begin + (int)beg, this.getRuntime());
            this.realLength = len;
        } else {
            int len = beg > (long)this.realLength ? this.realLength - (int)beg : 0;
            int alen = this.realLength + 1 - len;
            if (alen >= valuesLength) {
                this.spliceRealloc(alen, valuesLength);
            }
            if (len == 0) {
                this.safeArrayCopy(this.values, this.begin + (int)beg, this.values, this.begin + (int)beg + 1, this.realLength - (int)beg);
                this.realLength = alen;
            }
        }
        this.safeArraySet(this.values, this.begin + (int)beg, rpl);
    }

    private void spliceRealloc(int length2, int valuesLength) {
        int tryLength = valuesLength + (valuesLength >> 1);
        int len = length2 > tryLength ? length2 : tryLength;
        IRubyObject[] vals = new IRubyObject[len];
        System.arraycopy(this.values, this.begin, vals, 0, this.realLength);
        if (len > length2) {
            Helpers.fillNil(vals, length2, len, this.getRuntime());
        }
        this.begin = 0;
        this.values = vals;
    }

    public IRubyObject insert() {
        throw this.getRuntime().newArgumentError(0, 1);
    }

    @JRubyMethod(name={"insert"})
    public IRubyObject insert(IRubyObject arg2) {
        this.modifyCheck();
        return this;
    }

    @Deprecated
    public IRubyObject insert19(IRubyObject arg2) {
        return this.insert(arg2);
    }

    @JRubyMethod(name={"insert"})
    public IRubyObject insert(IRubyObject arg1, IRubyObject arg2) {
        this.modifyCheck();
        long pos2 = RubyNumeric.num2long(arg1);
        if (pos2 == -1L) {
            pos2 = this.realLength;
        }
        if (pos2 < 0L) {
            ++pos2;
        }
        this.spliceOne(pos2, arg2);
        return this;
    }

    @Deprecated
    public IRubyObject insert19(IRubyObject arg1, IRubyObject arg2) {
        return this.insert(arg1, arg2);
    }

    @JRubyMethod(name={"insert"}, required=1, rest=true)
    public IRubyObject insert(IRubyObject[] args2) {
        this.modifyCheck();
        if (args2.length == 1) {
            return this;
        }
        this.unpack();
        long pos2 = RubyNumeric.num2long(args2[0]);
        if (pos2 == -1L) {
            pos2 = this.realLength;
        }
        if (pos2 < 0L) {
            ++pos2;
        }
        RubyArray inserted = new RubyArray(this.getRuntime(), false);
        inserted.values = args2;
        inserted.begin = 1;
        inserted.realLength = args2.length - 1;
        this.splice(pos2, 0L, inserted, false);
        return this;
    }

    @Deprecated
    public IRubyObject insert19(IRubyObject[] args2) {
        return this.insert(args2);
    }

    public RubyArray aryDup() {
        RubyArray dup2 = new RubyArray(this.metaClass.getClassRuntime(), this.values, this.begin, this.realLength);
        dup2.isShared = true;
        this.isShared = true;
        return dup2;
    }

    @JRubyMethod(name={"transpose"})
    public RubyArray transpose() {
        RubyArray result2 = null;
        int alen = this.realLength;
        if (alen == 0) {
            return this.aryDup();
        }
        Ruby runtime = this.getRuntime();
        int elen = -1;
        for (int i2 = 0; i2 < alen; ++i2) {
            int j;
            RubyArray tmp = this.elt(i2).convertToArray();
            if (elen < 0) {
                elen = tmp.realLength;
                result2 = RubyArray.newBlankArray(runtime, elen);
                for (j = 0; j < elen; ++j) {
                    result2.store(j, RubyArray.newBlankArray(runtime, alen));
                }
            } else if (elen != tmp.realLength) {
                throw runtime.newIndexError("element size differs (" + tmp.realLength + " should be " + elen + ")");
            }
            for (j = 0; j < elen; ++j) {
                ((RubyArray)result2.elt(j)).store(i2, tmp.elt(j));
            }
        }
        return result2;
    }

    private final IRubyObject values_at(long olen, IRubyObject[] args2) {
        RubyArray result2 = RubyArray.newArray(this.getRuntime(), args2.length);
        for (int i2 = 0; i2 < args2.length; ++i2) {
            if (args2[i2] instanceof RubyFixnum) {
                result2.append(this.entry(((RubyFixnum)args2[i2]).getLongValue()));
                continue;
            }
            if (args2[i2] instanceof RubyRange) {
                int len;
                long[] beglen = ((RubyRange)args2[i2]).begLen(olen, 0);
                if (beglen == null) continue;
                int beg = (int)beglen[0];
                int end2 = len = (int)beglen[1];
                for (int j = 0; j < end2; ++j) {
                    result2.append(this.entry(j + beg));
                }
                continue;
            }
            result2.append(this.entry(RubyNumeric.num2long(args2[i2])));
        }
        Helpers.fillNil(result2.values, result2.realLength, result2.values.length, this.getRuntime());
        return result2;
    }

    @JRubyMethod(name={"values_at"}, rest=true)
    public IRubyObject values_at(IRubyObject[] args2) {
        return this.values_at(this.realLength, args2);
    }

    public IRubyObject subseq(long beg, long len) {
        return this.subseq(this.getMetaClass(), beg, len, true);
    }

    public IRubyObject subseqLight(long beg, long len) {
        return this.subseq(this.getMetaClass(), beg, len, true);
    }

    public IRubyObject subseq(RubyClass metaClass, long beg, long len, boolean light) {
        Ruby runtime = this.getRuntime();
        if (beg > (long)this.realLength || beg < 0L || len < 0L) {
            return runtime.getNil();
        }
        if (beg + len > (long)this.realLength && (len = (long)this.realLength - beg) < 0L) {
            len = 0L;
        }
        if (len == 0L) {
            return new RubyArray(runtime, metaClass, IRubyObject.NULL_ARRAY, !light);
        }
        return this.makeShared(this.begin + (int)beg, (int)len, new RubyArray(runtime, metaClass, !light));
    }

    @JRubyMethod(name={"length"}, alias={"size"})
    public RubyFixnum length() {
        return this.getRuntime().newFixnum(this.realLength);
    }

    protected RubyEnumerator.SizeFn enumLengthFn() {
        final RubyArray self2 = this;
        return new RubyEnumerator.SizeFn(){

            @Override
            public IRubyObject size(IRubyObject[] args2) {
                return self2.length();
            }
        };
    }

    @JRubyMethod(name={"<<"}, required=1)
    public RubyArray append(IRubyObject item) {
        this.unpack();
        this.modify();
        int valuesLength = this.values.length - this.begin;
        if (this.realLength == valuesLength) {
            if (this.realLength == Integer.MAX_VALUE) {
                throw this.getRuntime().newArgumentError("index too big");
            }
            long newLength = valuesLength + (valuesLength >> 1);
            if (newLength > Integer.MAX_VALUE) {
                newLength = Integer.MAX_VALUE;
            } else if (newLength < 16L) {
                newLength = 16L;
            }
            this.realloc((int)newLength, valuesLength);
        }
        this.safeArraySet(this.values, this.begin + this.realLength++, item);
        return this;
    }

    public RubyArray push_m(IRubyObject[] items) {
        return this.push(items);
    }

    @JRubyMethod(name={"push"}, required=1)
    public RubyArray push(IRubyObject item) {
        this.append(item);
        return this;
    }

    @JRubyMethod(name={"push"}, rest=true)
    public RubyArray push(IRubyObject[] items) {
        if (items.length == 0) {
            this.modifyCheck();
        }
        for (int i2 = 0; i2 < items.length; ++i2) {
            this.append(items[i2]);
        }
        return this;
    }

    @Deprecated
    public RubyArray push_m19(IRubyObject[] items) {
        return this.push(items);
    }

    @JRubyMethod
    public IRubyObject pop(ThreadContext context) {
        this.unpack();
        this.modifyCheck();
        if (this.realLength == 0) {
            return context.nil;
        }
        if (this.isShared) {
            return RubyArray.safeArrayRef(context.runtime, this.values, this.begin + --this.realLength);
        }
        int index2 = this.begin + --this.realLength;
        return RubyArray.safeArrayRefSet(context.runtime, this.values, index2, context.nil);
    }

    @JRubyMethod
    public IRubyObject pop(ThreadContext context, IRubyObject num) {
        this.unpack();
        this.modifyCheck();
        RubyArray result2 = this.makeSharedFirst(context, num, true, context.runtime.getArray());
        this.realLength -= result2.realLength;
        return result2;
    }

    @JRubyMethod(name={"shift"})
    public IRubyObject shift(ThreadContext context) {
        this.unpack();
        this.modifyCheck();
        if (this.realLength == 0) {
            return context.nil;
        }
        IRubyObject obj = RubyArray.safeArrayRefCondSet(context.runtime, this.values, this.begin, !this.isShared, context.nil);
        ++this.begin;
        --this.realLength;
        return obj;
    }

    @JRubyMethod(name={"shift"})
    public IRubyObject shift(ThreadContext context, IRubyObject num) {
        this.unpack();
        this.modify();
        RubyArray result2 = this.makeSharedFirst(context, num, false, context.runtime.getArray());
        int n = result2.realLength;
        this.begin += n;
        this.realLength -= n;
        return result2;
    }

    @JRubyMethod(name={"unshift"})
    public IRubyObject unshift() {
        this.modifyCheck();
        return this;
    }

    @Deprecated
    public IRubyObject unshift19() {
        return this.unshift();
    }

    @JRubyMethod(name={"unshift"})
    public IRubyObject unshift(IRubyObject item) {
        this.unpack();
        this.modifyCheck();
        if (this.begin == 0 || this.isShared) {
            this.modify();
            int valuesLength = this.values.length - this.begin;
            if (this.realLength == valuesLength) {
                int newLength = valuesLength >> 1;
                if (newLength < 16) {
                    newLength = 16;
                }
                IRubyObject[] vals = new IRubyObject[newLength += valuesLength];
                this.safeArrayCopy(this.values, this.begin, vals, 1, valuesLength);
                Helpers.fillNil(vals, valuesLength + 1, newLength, this.getRuntime());
                this.values = vals;
                this.begin = 0;
            } else {
                this.safeArrayCopy(this.values, this.begin, this.values, this.begin + 1, this.realLength);
            }
        } else {
            this.modifyCheck();
            --this.begin;
        }
        ++this.realLength;
        this.values[this.begin] = item;
        return this;
    }

    @Deprecated
    public IRubyObject unshift19(IRubyObject item) {
        return this.unshift(item);
    }

    @JRubyMethod(name={"unshift"}, rest=true)
    public IRubyObject unshift(IRubyObject[] items) {
        this.unpack();
        this.modifyCheck();
        long len = this.realLength;
        if (items.length == 0) {
            return this;
        }
        this.store(len + (long)items.length - 1L, this.getRuntime().getNil());
        try {
            System.arraycopy(this.values, this.begin, this.values, this.begin + items.length, (int)len);
            System.arraycopy(items, 0, this.values, this.begin, items.length);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.concurrentModification();
        }
        return this;
    }

    @Deprecated
    public IRubyObject unshift19(IRubyObject[] items) {
        return this.unshift(items);
    }

    @JRubyMethod(name={"include?"}, required=1)
    public RubyBoolean include_p(ThreadContext context, IRubyObject item) {
        return context.runtime.newBoolean(this.includes(context, item));
    }

    @Override
    @JRubyMethod(name={"frozen?"})
    public RubyBoolean frozen_p(ThreadContext context) {
        return context.runtime.newBoolean(this.isFrozen() || (this.flags & 0x200) != 0);
    }

    public IRubyObject aref(IRubyObject[] args2) {
        switch (args2.length) {
            case 1: {
                return this.aref(args2[0]);
            }
            case 2: {
                return this.aref(args2[0], args2[1]);
            }
        }
        Arity.raiseArgumentError(this.getRuntime(), args2.length, 1, 2);
        return null;
    }

    @JRubyMethod(name={"[]", "slice"})
    public IRubyObject aref(IRubyObject arg0) {
        return arg0 instanceof RubyFixnum ? this.entry(((RubyFixnum)arg0).getLongValue()) : this.arefCommon(arg0);
    }

    @Deprecated
    public IRubyObject aref19(IRubyObject arg0) {
        return this.aref(arg0);
    }

    private IRubyObject arefCommon(IRubyObject arg0) {
        Ruby runtime = this.getRuntime();
        if (arg0 instanceof RubyRange) {
            long[] beglen = ((RubyRange)arg0).begLen(this.realLength, 0);
            return beglen == null ? runtime.getNil() : this.subseq(beglen[0], beglen[1]);
        }
        ThreadContext context = runtime.getCurrentContext();
        JavaSites.ArraySites sites = RubyArray.sites(context);
        if (RubyRange.isRangeLike(context, arg0, sites.respond_to_begin, sites.respond_to_end)) {
            RubyRange range = RubyRange.rangeFromRangeLike(context, arg0, sites.begin, sites.end, sites.exclude_end);
            long[] beglen = range.begLen(this.realLength, 0);
            return beglen == null ? runtime.getNil() : this.subseq(beglen[0], beglen[1]);
        }
        return this.entry(RubyNumeric.num2long(arg0));
    }

    @JRubyMethod(name={"[]", "slice"})
    public IRubyObject aref(IRubyObject arg0, IRubyObject arg1) {
        return this.arefCommon(arg0, arg1);
    }

    @Deprecated
    public IRubyObject aref19(IRubyObject arg0, IRubyObject arg1) {
        return this.aref(arg0, arg1);
    }

    private IRubyObject arefCommon(IRubyObject arg0, IRubyObject arg1) {
        long beg = RubyNumeric.num2long(arg0);
        if (beg < 0L) {
            beg += (long)this.realLength;
        }
        return this.subseq(beg, RubyNumeric.num2long(arg1));
    }

    public IRubyObject aset(IRubyObject[] args2) {
        switch (args2.length) {
            case 2: {
                return this.aset(args2[0], args2[1]);
            }
            case 3: {
                return this.aset(args2[0], args2[1], args2[2]);
            }
        }
        throw this.getRuntime().newArgumentError("wrong number of arguments (" + args2.length + " for 2)");
    }

    @JRubyMethod(name={"[]="})
    public IRubyObject aset(IRubyObject arg0, IRubyObject arg1) {
        this.modifyCheck();
        if (arg0 instanceof RubyFixnum) {
            this.store(((RubyFixnum)arg0).getLongValue(), arg1);
        } else if (arg0 instanceof RubyRange) {
            RubyRange range = (RubyRange)arg0;
            long beg = range.begLen0(this.realLength);
            this.splice(beg, range.begLen1(this.realLength, beg), arg1, true);
        } else {
            ThreadContext context = this.getRuntime().getCurrentContext();
            JavaSites.ArraySites sites = RubyArray.sites(context);
            if (RubyRange.isRangeLike(context, arg0, sites.respond_to_begin, sites.respond_to_end)) {
                RubyRange range = RubyRange.rangeFromRangeLike(context, arg0, sites.begin, sites.end, sites.exclude_end);
                long beg = range.begLen0(this.realLength);
                this.splice(beg, range.begLen1(this.realLength, beg), arg1, true);
            } else {
                this.store(RubyNumeric.num2long(arg0), arg1);
            }
        }
        return arg1;
    }

    @Deprecated
    public IRubyObject aset19(IRubyObject arg0, IRubyObject arg1) {
        return this.aset(arg0, arg1);
    }

    @JRubyMethod(name={"[]="})
    public IRubyObject aset(IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        this.modifyCheck();
        this.splice(RubyNumeric.num2long(arg0), RubyNumeric.num2long(arg1), arg2, true);
        return arg2;
    }

    @Deprecated
    public IRubyObject aset19(IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        return this.aset(arg0, arg1, arg2);
    }

    @JRubyMethod(name={"at"}, required=1)
    public IRubyObject at(IRubyObject pos2) {
        return this.entry(RubyNumeric.num2long(pos2));
    }

    @JRubyMethod(name={"concat"}, required=1)
    public RubyArray concat(IRubyObject obj) {
        this.modifyCheck();
        RubyArray ary = obj.convertToArray();
        if (ary.realLength > 0) {
            this.splice(this.realLength, 0L, ary, false);
        }
        return this;
    }

    @Deprecated
    public RubyArray concat19(IRubyObject obj) {
        return this.concat(obj);
    }

    protected IRubyObject inspectAry(ThreadContext context) {
        Ruby runtime = context.runtime;
        RubyString str = RubyString.newStringLight(runtime, 10, (Encoding)USASCIIEncoding.INSTANCE);
        EncodingUtils.strBufCat(runtime, str, OPEN_BRACKET);
        boolean tainted = this.isTaint();
        for (int i2 = 0; i2 < this.realLength; ++i2) {
            RubyString s2 = RubyArray.inspect(context, RubyArray.safeArrayRef(runtime, this.values, this.begin + i2));
            if (s2.isTaint()) {
                tainted = true;
            }
            if (i2 > 0) {
                EncodingUtils.strBufCat(runtime, str, COMMA_SPACE);
            } else {
                str.setEncoding(s2.getEncoding());
            }
            str.cat19(s2);
        }
        EncodingUtils.strBufCat(runtime, str, CLOSE_BRACKET);
        if (tainted) {
            str.setTaint(true);
        }
        return str;
    }

    @Override
    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect() {
        if (this.realLength == 0) {
            return RubyString.newStringShared(this.getRuntime(), EMPTY_ARRAY_BYTELIST);
        }
        if (this.getRuntime().isInspecting(this)) {
            return RubyString.newStringShared(this.getRuntime(), RECURSIVE_ARRAY_BYTELIST);
        }
        try {
            this.getRuntime().registerInspecting(this);
            IRubyObject iRubyObject = this.inspectAry(this.getRuntime().getCurrentContext());
            return iRubyObject;
        }
        finally {
            this.getRuntime().unregisterInspecting(this);
        }
    }

    public IRubyObject first(IRubyObject[] args2) {
        switch (args2.length) {
            case 0: {
                return this.first();
            }
            case 1: {
                return this.first(args2[0]);
            }
        }
        Arity.raiseArgumentError(this.getRuntime(), args2.length, 0, 1);
        return null;
    }

    @JRubyMethod(name={"first"})
    public IRubyObject first() {
        if (this.realLength == 0) {
            return this.getRuntime().getNil();
        }
        return this.eltOk(0L);
    }

    @JRubyMethod(name={"first"})
    public IRubyObject first(IRubyObject arg0) {
        long n = RubyNumeric.num2long(arg0);
        if (n > (long)this.realLength) {
            n = this.realLength;
        } else {
            if (n < 0L) {
                throw this.getRuntime().newArgumentError("negative array size (or size too big)");
            }
            if (n == 1L) {
                return RubyArray.newArray(this.getRuntime(), this.eltOk(0L));
            }
            if (n == 2L) {
                return RubyArray.newArray(this.getRuntime(), this.eltOk(0L), this.eltOk(1L));
            }
        }
        this.unpack();
        return this.makeShared(this.begin, (int)n, this.getRuntime().getArray());
    }

    public IRubyObject last(IRubyObject[] args2) {
        switch (args2.length) {
            case 0: {
                return this.last();
            }
            case 1: {
                return this.last(args2[0]);
            }
        }
        Arity.raiseArgumentError(this.getRuntime(), args2.length, 0, 1);
        return null;
    }

    @JRubyMethod(name={"last"})
    public IRubyObject last() {
        if (this.realLength == 0) {
            return this.getRuntime().getNil();
        }
        return this.eltOk(this.realLength - 1);
    }

    @JRubyMethod(name={"last"})
    public IRubyObject last(IRubyObject arg0) {
        long n = RubyNumeric.num2long(arg0);
        if (n > (long)this.realLength) {
            n = this.realLength;
        } else {
            if (n < 0L) {
                throw this.getRuntime().newArgumentError("negative array size (or size too big)");
            }
            if (n == 1L) {
                return RubyArray.newArray(this.getRuntime(), this.eltOk(this.realLength - 1));
            }
            if (n == 2L) {
                return RubyArray.newArray(this.getRuntime(), this.eltOk(this.realLength - 2), this.eltOk(this.realLength - 1));
            }
        }
        this.unpack();
        return this.makeShared(this.begin + this.realLength - (int)n, (int)n, this.getRuntime().getArray());
    }

    @JRubyMethod
    public IRubyObject each(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, this, "each", this.enumLengthFn());
        }
        for (int i2 = 0; i2 < this.realLength; ++i2) {
            block.yield(context, this.eltOk(i2));
        }
        return this;
    }

    public IRubyObject eachSlice(ThreadContext context, int size2, Block block) {
        int localRealLength;
        boolean specificArity;
        this.unpack();
        Ruby runtime = context.runtime;
        RubyClass array = runtime.getArray();
        IRubyObject[] localValues = this.values;
        int localBegin = this.begin;
        RubyArray window = this.makeShared(localBegin, size2, array);
        Signature signature = block.getSignature();
        boolean bl = specificArity = signature.isFixed() && signature.required() != 1;
        for (localRealLength = this.realLength; localRealLength >= size2; localRealLength -= size2) {
            block.yield(context, window);
            if (specificArity) {
                window.begin = localBegin += size2;
                continue;
            }
            window = this.makeShared(localBegin += size2, size2, array);
        }
        if (localRealLength > 0) {
            window.realLength = localRealLength;
            block.yield(context, window);
        }
        return runtime.getNil();
    }

    @JRubyMethod
    public IRubyObject each_slice(ThreadContext context, IRubyObject arg2, Block block) {
        int size2 = RubyNumeric.num2int(arg2);
        Ruby runtime = context.runtime;
        if (size2 <= 0) {
            throw runtime.newArgumentError("invalid slice size");
        }
        return block.isGiven() ? this.eachSlice(context, size2, block) : RubyEnumerator.enumeratorizeWithSize(context, (IRubyObject)this, "each_slice", arg2, arg2);
    }

    public IRubyObject eachIndex(ThreadContext context, Block block) {
        Ruby runtime = context.runtime;
        if (!block.isGiven()) {
            throw runtime.newLocalJumpErrorNoBlock();
        }
        for (int i2 = 0; i2 < this.realLength; ++i2) {
            block.yield(context, runtime.newFixnum(i2));
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject each_index(ThreadContext context, Block block) {
        return block.isGiven() ? this.eachIndex(context, block) : RubyEnumerator.enumeratorize(context.runtime, this, "each_index");
    }

    public IRubyObject reverseEach(ThreadContext context, Block block) {
        int len = this.realLength;
        while (len-- > 0) {
            block.yield(context, this.eltOk(len));
            if (this.realLength >= len) continue;
            len = this.realLength;
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject reverse_each(ThreadContext context, Block block) {
        return block.isGiven() ? this.reverseEach(context, block) : RubyEnumerator.enumeratorizeWithSize(context, this, "reverse_each", this.enumLengthFn());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject inspectJoin(ThreadContext context, RubyArray tmp, IRubyObject sep) {
        Ruby runtime = context.runtime;
        if (runtime.isInspecting(this)) {
            return tmp.join(context, sep);
        }
        try {
            runtime.registerInspecting(this);
            IRubyObject iRubyObject = tmp.join(context, sep);
            return iRubyObject;
        }
        finally {
            runtime.unregisterInspecting(this);
        }
    }

    public IRubyObject join(ThreadContext context, IRubyObject sep) {
        return this.join19(context, sep);
    }

    public IRubyObject join(ThreadContext context) {
        return this.join19(context);
    }

    protected RubyString joinStrings(RubyString sep, int max2, RubyString result2) {
        IRubyObject first2 = this.eltOk(0L);
        if (max2 > 0 && first2 instanceof EncodingCapable) {
            result2.setEncoding(((EncodingCapable)((Object)first2)).getEncoding());
        }
        try {
            for (int i2 = 0; i2 < max2; ++i2) {
                if (i2 > 0 && sep != null) {
                    result2.append19(sep);
                }
                result2.append19(this.eltInternal(i2));
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.concurrentModification();
        }
        return result2;
    }

    private RubyString joinAny(ThreadContext context, IRubyObject obj, RubyString sep, int i2, RubyString result2) {
        assert (i2 >= 0) : "joining elements before beginning of array";
        RubyClass arrayClass = context.runtime.getArray();
        JavaSites.CheckedSites to_ary_checked = null;
        while (i2 < this.realLength) {
            IRubyObject val;
            if (i2 > 0 && sep != null) {
                result2.append19(sep);
            }
            if ((val = this.eltOk(i2)) instanceof RubyString) {
                result2.append19(val);
            } else if (val instanceof RubyArray) {
                obj = val;
                this.recursiveJoin(context, obj, sep, result2, val);
            } else {
                IRubyObject tmp = val.checkStringType19();
                if (!tmp.isNil()) {
                    result2.append19(tmp);
                } else {
                    if (to_ary_checked == null) {
                        to_ary_checked = RubyArray.sites((ThreadContext)context).to_ary_checked;
                    }
                    if (!(tmp = TypeConverter.convertToTypeWithCheck(context, val, arrayClass, to_ary_checked)).isNil()) {
                        obj = val;
                        this.recursiveJoin(context, obj, sep, result2, tmp);
                    } else {
                        result2.append19(RubyString.objAsString(context, val));
                    }
                }
            }
            ++i2;
        }
        return result2;
    }

    private void recursiveJoin(ThreadContext context, final IRubyObject outValue, final RubyString sep, final RubyString result2, final IRubyObject ary) {
        Ruby runtime = context.runtime;
        if (ary == this) {
            throw runtime.newArgumentError("recursive array join");
        }
        runtime.safeRecurse(new Ruby.RecursiveFunctionEx<Ruby>(){

            @Override
            public IRubyObject call(ThreadContext context, Ruby runtime, IRubyObject obj, boolean recur) {
                if (recur) {
                    throw runtime.newArgumentError("recursive array join");
                }
                RubyArray recAry = (RubyArray)ary;
                recAry.joinAny(context, outValue, sep, 0, result2);
                return runtime.getNil();
            }
        }, context, runtime, outValue, "join", true);
    }

    @JRubyMethod(name={"join"})
    public IRubyObject join19(ThreadContext context, IRubyObject sep) {
        Ruby runtime = context.runtime;
        if (this.realLength == 0) {
            return RubyString.newEmptyString(runtime, (Encoding)USASCIIEncoding.INSTANCE);
        }
        if (sep.isNil()) {
            sep = runtime.getGlobalVariables().get("$,");
        }
        int len = 1;
        RubyString sepString = null;
        if (!sep.isNil()) {
            sepString = sep.convertToString();
            len += sepString.size() * (this.realLength - 1);
        }
        for (int i2 = 0; i2 < this.realLength; ++i2) {
            IRubyObject val = this.eltOk(i2);
            IRubyObject tmp = val.checkStringType19();
            if (tmp.isNil() || tmp != val) {
                RubyString result2 = (RubyString)RubyString.newStringLight(runtime, len += (this.realLength - i2) * 10, (Encoding)USASCIIEncoding.INSTANCE).infectBy(this);
                RubyString sepStringFinal = sepString;
                int iFinal = i2;
                return this.joinAny(context, this, sepStringFinal, iFinal, this.joinStrings(sepStringFinal, iFinal, result2));
            }
            len += ((RubyString)tmp).getByteList().length();
        }
        return this.joinStrings(sepString, this.realLength, (RubyString)RubyString.newStringLight(runtime, len).infectBy(this));
    }

    @JRubyMethod(name={"join"})
    public IRubyObject join19(ThreadContext context) {
        return this.join19(context, context.runtime.getGlobalVariables().get("$,"));
    }

    @Override
    @JRubyMethod(name={"to_a"})
    public RubyArray to_a() {
        if (this.getMetaClass() != this.getRuntime().getArray()) {
            return this.aryDup();
        }
        return this;
    }

    @JRubyMethod(name={"to_ary"})
    public IRubyObject to_ary() {
        return this;
    }

    @Override
    public RubyArray convertToArray() {
        return this;
    }

    @Override
    public IRubyObject checkArrayType() {
        return this;
    }

    @Override
    @JRubyMethod(name={"=="}, required=1)
    public IRubyObject op_equal(ThreadContext context, IRubyObject obj) {
        Ruby runtime = context.runtime;
        if (this == obj) {
            return runtime.getTrue();
        }
        if (!(obj instanceof RubyArray)) {
            if (obj == context.nil) {
                return runtime.getFalse();
            }
            if (!RubyArray.sites((ThreadContext)context).respond_to_to_ary.respondsTo(context, obj, obj)) {
                return runtime.getFalse();
            }
            return Helpers.rbEqual(context, obj, this);
        }
        return RecursiveComparator.compare(context, RubyArray.sites((ThreadContext)context).op_equal, this, obj);
    }

    public RubyBoolean compare(ThreadContext context, CallSite site, IRubyObject other) {
        if (!(other instanceof RubyArray)) {
            if (!RubyArray.sites((ThreadContext)context).respond_to_to_ary.respondsTo(context, other, other)) {
                return context.runtime.getFalse();
            }
            return Helpers.rbEqual(context, other, this);
        }
        RubyArray ary = (RubyArray)other;
        if (this.realLength != ary.realLength) {
            return context.runtime.getFalse();
        }
        for (int i2 = 0; i2 < this.realLength; ++i2) {
            IRubyObject b2;
            IRubyObject a = this.elt(i2);
            if (a == (b2 = ary.elt(i2)) || site.call(context, a, a, b2).isTrue()) continue;
            return context.runtime.getFalse();
        }
        return context.runtime.getTrue();
    }

    @JRubyMethod(name={"eql?"}, required=1)
    public IRubyObject eql(ThreadContext context, IRubyObject obj) {
        if (!(obj instanceof RubyArray)) {
            return context.runtime.getFalse();
        }
        return RecursiveComparator.compare(context, RubyArray.sites((ThreadContext)context).eql, this, obj);
    }

    @JRubyMethod(name={"compact!"})
    public IRubyObject compact_bang() {
        int p2;
        this.unpack();
        this.modify();
        int t = p2 = this.begin;
        int end2 = p2 + this.realLength;
        try {
            while (t < end2) {
                if (this.values[t].isNil()) {
                    ++t;
                    continue;
                }
                this.values[p2++] = this.values[t++];
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.concurrentModification();
        }
        if (this.realLength == (p2 -= this.begin)) {
            return this.getRuntime().getNil();
        }
        this.realloc(p2, this.values.length - this.begin);
        this.realLength = p2;
        return this;
    }

    @JRubyMethod(name={"compact"})
    public IRubyObject compact() {
        RubyArray ary = this.aryDup();
        ary.compact_bang();
        return ary;
    }

    @Deprecated
    public IRubyObject compact19() {
        return this.compact();
    }

    @JRubyMethod(name={"empty?"})
    public IRubyObject empty_p() {
        return this.realLength == 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"clear"})
    public IRubyObject rb_clear() {
        this.modifyCheck();
        if (this.isShared) {
            this.alloc(16);
            this.isShared = false;
        } else if (this.values.length > 32) {
            this.alloc(32);
        } else {
            try {
                this.begin = 0;
                Helpers.fillNil(this.values, 0, this.realLength, this.getRuntime());
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.concurrentModification();
            }
        }
        this.realLength = 0;
        return this;
    }

    @JRubyMethod
    public IRubyObject fill(ThreadContext context, Block block) {
        if (block.isGiven()) {
            return this.fillCommon(context, 0, (long)this.realLength, block);
        }
        throw context.runtime.newArgumentError(0, 1);
    }

    @JRubyMethod
    public IRubyObject fill(ThreadContext context, IRubyObject arg2, Block block) {
        if (block.isGiven()) {
            if (arg2 instanceof RubyRange) {
                int[] beglen = ((RubyRange)arg2).begLenInt(this.realLength, 1);
                return this.fillCommon(context, beglen[0], (long)beglen[1], block);
            }
            int beg = this.fillBegin(arg2);
            return this.fillCommon(context, beg, this.fillLen(beg, null), block);
        }
        return this.fillCommon(context, 0, (long)this.realLength, arg2);
    }

    @JRubyMethod
    public IRubyObject fill(ThreadContext context, IRubyObject arg1, IRubyObject arg2, Block block) {
        if (block.isGiven()) {
            int beg = this.fillBegin(arg1);
            return this.fillCommon(context, beg, this.fillLen(beg, arg2), block);
        }
        if (arg2 instanceof RubyRange) {
            int[] beglen = ((RubyRange)arg2).begLenInt(this.realLength, 1);
            return this.fillCommon(context, beglen[0], (long)beglen[1], arg1);
        }
        int beg = this.fillBegin(arg2);
        return this.fillCommon(context, beg, this.fillLen(beg, null), arg1);
    }

    @JRubyMethod
    public IRubyObject fill(ThreadContext context, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, Block block) {
        if (block.isGiven()) {
            throw context.runtime.newArgumentError(3, 2);
        }
        int beg = this.fillBegin(arg2);
        return this.fillCommon(context, beg, this.fillLen(beg, arg3), arg1);
    }

    private int fillBegin(IRubyObject arg2) {
        int beg;
        int n = beg = arg2.isNil() ? 0 : RubyNumeric.num2int(arg2);
        if (beg < 0 && (beg = this.realLength + beg) < 0) {
            beg = 0;
        }
        return beg;
    }

    private long fillLen(long beg, IRubyObject arg2) {
        if (arg2 == null || arg2.isNil()) {
            return (long)this.realLength - beg;
        }
        return RubyNumeric.num2long(arg2);
    }

    protected IRubyObject fillCommon(ThreadContext context, int beg, long len, IRubyObject item) {
        this.modify();
        if (len <= 0L) {
            return this;
        }
        if (len > (long)(Integer.MAX_VALUE - beg)) {
            throw context.runtime.newArgumentError("argument too big");
        }
        int end2 = (int)((long)beg + len);
        if (end2 > this.realLength) {
            int valuesLength = this.values.length - this.begin;
            if (end2 >= valuesLength) {
                this.realloc(end2, valuesLength);
            }
            this.realLength = end2;
        }
        if (len > 0L) {
            try {
                RubyArray.fill(this.values, this.begin + beg, this.begin + end2, item);
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                RubyArray.concurrentModification(context.runtime, ex);
            }
        }
        return this;
    }

    protected IRubyObject fillCommon(ThreadContext context, int beg, long len, Block block) {
        this.modify();
        if (len <= 0L) {
            return this;
        }
        if (len > (long)(Integer.MAX_VALUE - beg)) {
            throw context.runtime.newArgumentError("argument too big");
        }
        int end2 = (int)((long)beg + len);
        if (end2 > this.realLength) {
            int valuesLength = this.values.length - this.begin;
            if (end2 >= valuesLength) {
                this.realloc(end2, valuesLength);
            }
            this.realLength = end2;
        }
        Ruby runtime = context.runtime;
        for (int i2 = beg; i2 < end2; ++i2) {
            IRubyObject v = block.yield(context, runtime.newFixnum(i2));
            if (i2 >= this.realLength) break;
            RubyArray.safeArraySet(runtime, this.values, this.begin + i2, v);
        }
        return this;
    }

    public IRubyObject index(ThreadContext context, IRubyObject obj) {
        Ruby runtime = context.runtime;
        for (int i2 = 0; i2 < this.realLength; ++i2) {
            if (!RubyArray.equalInternal(context, this.eltOk(i2), obj)) continue;
            return runtime.newFixnum(i2);
        }
        return runtime.getNil();
    }

    @JRubyMethod(name={"index", "find_index"})
    public IRubyObject index(ThreadContext context, IRubyObject obj, Block unused2) {
        if (unused2.isGiven()) {
            context.runtime.getWarnings().warn(IRubyWarnings.ID.BLOCK_UNUSED, "given block not used");
        }
        return this.index(context, obj);
    }

    @JRubyMethod(name={"index", "find_index"})
    public IRubyObject index(ThreadContext context, Block block) {
        Ruby runtime = context.runtime;
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(runtime, this, "index");
        }
        for (int i2 = 0; i2 < this.realLength; ++i2) {
            if (!block.yield(context, this.eltOk(i2)).isTrue()) continue;
            return runtime.newFixnum(i2);
        }
        return runtime.getNil();
    }

    @JRubyMethod
    public IRubyObject bsearch(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, this, "bsearch");
        }
        int rVal = this.bsearch_index_internal(context, block);
        if (rVal == -1) {
            return context.nil;
        }
        return this.eltOk(rVal);
    }

    @JRubyMethod
    public IRubyObject bsearch_index(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, this, "bsearch_index");
        }
        int rVal = this.bsearch_index_internal(context, block);
        if (rVal == -1) {
            return context.nil;
        }
        return RubyFixnum.newFixnum(context.runtime, rVal);
    }

    private int bsearch_index_internal(ThreadContext context, Block block) {
        Ruby runtime = context.runtime;
        int low = 0;
        int high = this.realLength;
        boolean smaller = false;
        boolean satisfied = false;
        CallSite op_cmp2 = null;
        while (low < high) {
            int mid = low + (high - low) / 2;
            IRubyObject v = block.yieldSpecific(context, this.eltOk(mid));
            if (v instanceof RubyFixnum) {
                long fixValue = ((RubyFixnum)v).getLongValue();
                if (fixValue == 0L) {
                    return mid;
                }
                smaller = fixValue < 0L;
            } else if (v == runtime.getTrue()) {
                satisfied = true;
                smaller = true;
            } else if (v == runtime.getFalse() || v == runtime.getNil()) {
                smaller = false;
            } else if (runtime.getNumeric().isInstance(v)) {
                if (op_cmp2 == null) {
                    op_cmp2 = RubyArray.sites((ThreadContext)context).op_cmp_bsearch;
                }
                switch (RubyComparable.cmpint(context, op_cmp2.call(context, v, v, (IRubyObject)RubyFixnum.zero(runtime)), v, RubyFixnum.zero(runtime))) {
                    case 0: {
                        return mid;
                    }
                    case 1: {
                        smaller = true;
                        break;
                    }
                    case -1: {
                        smaller = false;
                    }
                }
            } else {
                throw runtime.newTypeError("wrong argument type " + v.getType().getName() + " (must be numeric, true, false or nil");
            }
            if (smaller) {
                high = mid;
                continue;
            }
            low = mid + 1;
        }
        if (low == this.realLength) {
            return -1;
        }
        if (!satisfied) {
            return -1;
        }
        return low;
    }

    public IRubyObject rindex(ThreadContext context, IRubyObject obj) {
        Ruby runtime = context.runtime;
        int i2 = this.realLength;
        while (i2-- > 0) {
            if (i2 > this.realLength) {
                i2 = this.realLength;
                continue;
            }
            if (!RubyArray.equalInternal(context, this.eltOk(i2), obj)) continue;
            return runtime.newFixnum(i2);
        }
        return runtime.getNil();
    }

    @JRubyMethod
    public IRubyObject rindex(ThreadContext context, IRubyObject obj, Block unused2) {
        if (unused2.isGiven()) {
            context.runtime.getWarnings().warn(IRubyWarnings.ID.BLOCK_UNUSED, "given block not used");
        }
        return this.rindex(context, obj);
    }

    @JRubyMethod
    public IRubyObject rindex(ThreadContext context, Block block) {
        Ruby runtime = context.runtime;
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(runtime, this, "rindex");
        }
        int i2 = this.realLength;
        while (i2-- > 0) {
            if (i2 >= this.realLength) {
                i2 = this.realLength;
                continue;
            }
            if (!block.yield(context, this.eltOk(i2)).isTrue()) continue;
            return runtime.newFixnum(i2);
        }
        return runtime.getNil();
    }

    @JRubyMethod(name={"indexes", "indices"}, required=1, rest=true)
    public IRubyObject indexes(IRubyObject[] args2) {
        this.getRuntime().getWarnings().warn(IRubyWarnings.ID.DEPRECATED_METHOD, "Array#indexes is deprecated; use Array#values_at");
        if (args2.length == 1) {
            return RubyArray.newArray(this.getRuntime(), args2[0]);
        }
        RubyArray ary = RubyArray.newArray(this.getRuntime(), args2.length);
        for (int i2 = 0; i2 < args2.length; ++i2) {
            ary.append(this.aref(args2[i2]));
        }
        return ary;
    }

    @JRubyMethod(name={"reverse!"})
    public IRubyObject reverse_bang() {
        this.modify();
        try {
            if (this.realLength > 1) {
                int len = this.realLength;
                for (int i2 = 0; i2 < len >> 1; ++i2) {
                    IRubyObject tmp = this.eltInternal(i2);
                    this.eltInternalSet(i2, this.eltInternal(len - i2 - 1));
                    this.eltInternalSet(len - i2 - 1, tmp);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.concurrentModification();
        }
        return this;
    }

    @JRubyMethod(name={"reverse"})
    public IRubyObject reverse() {
        if (this.realLength > 1) {
            RubyArray dup2 = this.safeReverse();
            dup2.flags |= this.flags & TAINTED_F;
            return dup2;
        }
        return this.dup();
    }

    protected RubyArray safeReverse() {
        int length2 = this.realLength;
        int myBegin = this.begin;
        IRubyObject[] myValues = this.values;
        IRubyObject[] vals = new IRubyObject[length2];
        try {
            for (int i2 = 0; i2 <= length2 >> 1; ++i2) {
                vals[i2] = myValues[myBegin + length2 - i2 - 1];
                vals[length2 - i2 - 1] = myValues[myBegin + i2];
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.concurrentModification();
        }
        return new RubyArray(this.getRuntime(), this.getMetaClass(), vals);
    }

    public IRubyObject collect(ThreadContext context, Block block) {
        int i2;
        Ruby runtime = context.runtime;
        if (!block.isGiven()) {
            return this.makeShared();
        }
        IRubyObject[] arr = new IRubyObject[this.realLength];
        for (i2 = 0; i2 < this.realLength; ++i2) {
            arr[i2] = block.yield(context, this.eltOk(i2));
        }
        return RubyArray.newArrayMayCopy(runtime, arr, 0, i2);
    }

    @JRubyMethod(name={"collect"})
    public IRubyObject collect19(ThreadContext context, Block block) {
        return block.isGiven() ? this.collect(context, block) : RubyEnumerator.enumeratorizeWithSize(context, this, "collect", this.enumLengthFn());
    }

    @JRubyMethod(name={"map"})
    public IRubyObject map19(ThreadContext context, Block block) {
        return block.isGiven() ? this.collect(context, block) : RubyEnumerator.enumeratorizeWithSize(context, this, "map", this.enumLengthFn());
    }

    public RubyArray collectBang(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            throw context.runtime.newLocalJumpErrorNoBlock();
        }
        this.modify();
        int len = this.realLength;
        for (int i2 = 0; i2 < len; ++i2) {
            this.store(i2, block.yield(context, this.eltOk(i2)));
        }
        return this;
    }

    @JRubyMethod(name={"collect!"})
    public IRubyObject collect_bang(ThreadContext context, Block block) {
        return block.isGiven() ? this.collectBang(context, block) : RubyEnumerator.enumeratorizeWithSize(context, this, "collect!", this.enumLengthFn());
    }

    @JRubyMethod(name={"map!"})
    public IRubyObject map_bang(ThreadContext context, Block block) {
        return block.isGiven() ? this.collectBang(context, block) : RubyEnumerator.enumeratorizeWithSize(context, this, "map!", this.enumLengthFn());
    }

    public IRubyObject selectCommon(ThreadContext context, Block block) {
        Ruby runtime = context.runtime;
        switch (this.realLength) {
            case 1: {
                IRubyObject value2 = this.eltOk(0L);
                if (block.yield(context, value2).isTrue()) {
                    return new RubyArrayOneObject(runtime, value2);
                }
                return RubyArray.newEmptyArray(runtime);
            }
            case 2: {
                IRubyObject value3 = this.eltOk(0L);
                boolean first2 = block.yield(context, value3).isTrue();
                IRubyObject value2 = this.eltOk(1L);
                boolean second = block.yield(context, value2).isTrue();
                if (first2) {
                    if (second) {
                        return RubyArray.newArray(runtime, value3, value2);
                    }
                    return RubyArray.newArray(runtime, value3);
                }
                if (second) {
                    return RubyArray.newArray(runtime, value2);
                }
                return RubyArray.newEmptyArray(runtime);
            }
        }
        RubyArray result2 = RubyArray.newArray(runtime, this.realLength);
        for (int i2 = 0; i2 < this.realLength; ++i2) {
            IRubyObject value4 = this.eltOk(i2);
            if (!block.yield(context, value4).isTrue()) continue;
            result2.append(value4);
        }
        Helpers.fillNil(result2.values, result2.realLength, result2.values.length, runtime);
        return result2;
    }

    @JRubyMethod
    public IRubyObject select(ThreadContext context, Block block) {
        return block.isGiven() ? this.selectCommon(context, block) : RubyEnumerator.enumeratorizeWithSize(context, this, "select", this.enumLengthFn());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"select!"})
    public IRubyObject select_bang(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, this, "select!", this.enumLengthFn());
        }
        this.unpack();
        this.modify();
        Ruby runtime = context.runtime;
        int len = this.realLength;
        int beg = this.begin;
        int len0 = 0;
        int len1 = 0;
        try {
            int i2 = 0;
            int i1 = 0;
            while (i1 < len) {
                IRubyObject[] values2 = this.values;
                IRubyObject value2 = RubyArray.safeArrayRef(runtime, values2, this.begin + i1);
                if (block.yield(context, value2).isTrue()) {
                    if (i1 != i2) {
                        RubyArray.safeArraySet(runtime, values2, beg + i2, value2);
                    }
                    len1 = ++i2;
                }
                len0 = ++i1;
            }
            IRubyObject iRubyObject = i1 == i2 ? context.nil : this;
            return iRubyObject;
        }
        finally {
            this.selectBangEnsure(runtime, len, beg, len0, len1);
        }
    }

    @JRubyMethod
    public IRubyObject keep_if(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, this, "keep_if", this.enumLengthFn());
        }
        this.select_bang(context, block);
        return this;
    }

    @JRubyMethod(required=1)
    public IRubyObject delete(ThreadContext context, IRubyObject item, Block block) {
        this.unpack();
        int i2 = 0;
        IRubyObject value2 = item;
        Ruby runtime = context.runtime;
        for (int i1 = 0; i1 < this.realLength; ++i1) {
            IRubyObject e = RubyArray.safeArrayRef(runtime, this.values, this.begin + i1);
            if (RubyArray.equalInternal(context, e, item)) {
                value2 = e;
                continue;
            }
            if (i1 != i2) {
                this.store(i2, e);
            }
            ++i2;
        }
        if (this.realLength == i2) {
            if (block.isGiven()) {
                return block.yield(context, item);
            }
            return context.nil;
        }
        this.modify();
        int myRealLength = this.realLength;
        int myBegin = this.begin;
        IRubyObject[] myValues = this.values;
        try {
            if (myRealLength > i2) {
                Helpers.fillNil(myValues, myBegin + i2, myBegin + myRealLength, context.runtime);
                this.realLength = i2;
                int valuesLength = myValues.length - myBegin;
                if (i2 << 1 < valuesLength && valuesLength > 16) {
                    this.realloc(i2 << 1, valuesLength);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            RubyArray.concurrentModification(context.runtime, ex);
        }
        return value2;
    }

    public IRubyObject delete_at(int pos2) {
        int len = this.realLength;
        if (pos2 >= len || pos2 < 0 && (pos2 += len) < 0) {
            return this.getRuntime().getNil();
        }
        this.unpack();
        this.modify();
        IRubyObject nil = this.getRuntime().getNil();
        IRubyObject obj = null;
        try {
            obj = this.values[this.begin + pos2];
            if (pos2 == 0) {
                this.values[this.begin] = nil;
                ++this.begin;
                --this.realLength;
                return obj;
            }
            if (pos2 == this.realLength - 1) {
                this.values[this.begin + this.realLength - 1] = nil;
                --this.realLength;
                return obj;
            }
            System.arraycopy(this.values, this.begin + pos2 + 1, this.values, this.begin + pos2, len - (pos2 + 1));
            this.values[this.begin + len - 1] = this.getRuntime().getNil();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.concurrentModification();
        }
        --this.realLength;
        return obj;
    }

    @JRubyMethod(name={"delete_at"}, required=1)
    public IRubyObject delete_at(IRubyObject obj) {
        return this.delete_at((int)RubyNumeric.num2long(obj));
    }

    public final IRubyObject rejectCommon(ThreadContext context, Block block) {
        RubyArray ary = this.aryDup();
        ary.rejectBang(context, block);
        return ary;
    }

    @JRubyMethod
    public IRubyObject reject(ThreadContext context, Block block) {
        return block.isGiven() ? this.rejectCommon(context, block) : RubyEnumerator.enumeratorizeWithSize(context, this, "reject", this.enumLengthFn());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject rejectBang(ThreadContext context, Block block) {
        this.unpack();
        this.modify();
        Ruby runtime = context.runtime;
        int len = this.realLength;
        int beg = this.begin;
        int len0 = 0;
        int len1 = 0;
        try {
            int i2 = 0;
            int i1 = 0;
            while (i1 < len) {
                IRubyObject[] values2 = this.values;
                IRubyObject value2 = RubyArray.safeArrayRef(runtime, values2, beg + i1);
                if (!block.yield(context, value2).isTrue()) {
                    if (i1 != i2) {
                        RubyArray.safeArraySet(runtime, values2, beg + i2, value2);
                    }
                    len1 = ++i2;
                }
                len0 = ++i1;
            }
            IRubyObject iRubyObject = i1 == i2 ? context.nil : this;
            return iRubyObject;
        }
        finally {
            this.selectBangEnsure(runtime, len, beg, len0, len1);
        }
    }

    private void selectBangEnsure(Ruby runtime, int len, int beg, int i1, int i2) {
        if (i2 < i1) {
            this.realLength = len - i1 + i2;
            if (i1 < len) {
                RubyArray.safeArrayCopy(runtime, this.values, beg + i1, this.values, beg + i2, len - i1);
            } else if (this.realLength > 0) {
                try {
                    Helpers.fillNil(this.values, beg + i2, beg + i1, runtime);
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    RubyArray.concurrentModification(runtime, ex);
                }
            }
        }
    }

    @JRubyMethod(name={"reject!"})
    public IRubyObject reject_bang(ThreadContext context, Block block) {
        return block.isGiven() ? this.rejectBang(context, block) : RubyEnumerator.enumeratorizeWithSize(context, this, "reject!", this.enumLengthFn());
    }

    public IRubyObject deleteIf(ThreadContext context, Block block) {
        this.rejectBang(context, block);
        return this;
    }

    @JRubyMethod
    public IRubyObject delete_if(ThreadContext context, Block block) {
        return block.isGiven() ? this.deleteIf(context, block) : RubyEnumerator.enumeratorizeWithSize(context, this, "delete_if", this.enumLengthFn());
    }

    @JRubyMethod(optional=1, rest=true)
    public IRubyObject zip(ThreadContext context, IRubyObject[] args2, Block block) {
        Ruby runtime = context.runtime;
        RubyClass array = runtime.getArray();
        JavaSites.ArraySites sites = RubyArray.sites(context);
        IRubyObject[] newArgs = new IRubyObject[args2.length];
        boolean hasUncoercible = false;
        JavaSites.CheckedSites to_ary_checked = sites.to_ary_checked;
        for (int i2 = 0; i2 < args2.length; ++i2) {
            newArgs[i2] = TypeConverter.convertToType(context, args2[i2], array, to_ary_checked, false);
            if (!newArgs[i2].isNil()) continue;
            hasUncoercible = true;
        }
        if (hasUncoercible) {
            CallSite to_enum = sites.to_enum;
            RubySymbol each2 = runtime.newSymbol("each");
            for (int i3 = 0; i3 < args2.length; ++i3) {
                IRubyObject arg2 = args2[i3];
                newArgs[i3] = to_enum.call(context, arg2, arg2, (IRubyObject)each2);
            }
        }
        if (hasUncoercible) {
            return this.zipCommon(context, newArgs, block, new ArgumentVisitor(){

                @Override
                public IRubyObject visit(ThreadContext ctx, IRubyObject arg2, int i2) {
                    return RubyEnumerable.zipEnumNext(ctx, arg2);
                }
            });
        }
        return this.zipCommon(context, newArgs, block, new ArgumentVisitor(){

            @Override
            public IRubyObject visit(ThreadContext ctx, IRubyObject arg2, int i2) {
                return ((RubyArray)arg2).elt(i2);
            }
        });
    }

    private IRubyObject zipCommon(ThreadContext context, IRubyObject[] args2, Block block, ArgumentVisitor visitor) {
        Ruby runtime = context.runtime;
        if (block.isGiven()) {
            for (int i2 = 0; i2 < this.realLength; ++i2) {
                IRubyObject[] tmp = new IRubyObject[args2.length + 1];
                tmp[0] = this.eltInternal(i2);
                for (int j = 0; j < args2.length; ++j) {
                    tmp[j + 1] = visitor.visit(context, args2[j], i2);
                }
                block.yield(context, RubyArray.newArrayMayCopy(runtime, tmp));
            }
            return runtime.getNil();
        }
        IRubyObject[] result2 = new IRubyObject[this.realLength];
        try {
            for (int i3 = 0; i3 < this.realLength; ++i3) {
                IRubyObject[] tmp = new IRubyObject[args2.length + 1];
                tmp[0] = this.eltInternal(i3);
                for (int j = 0; j < args2.length; ++j) {
                    tmp[j + 1] = visitor.visit(context, args2[j], i3);
                }
                result2[i3] = RubyArray.newArrayMayCopy(runtime, tmp);
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            RubyArray.concurrentModification(context.runtime, ex);
        }
        return RubyArray.newArrayMayCopy(runtime, result2);
    }

    @Override
    @JRubyMethod(name={"<=>"}, required=1)
    public IRubyObject op_cmp(ThreadContext context, IRubyObject obj) {
        boolean isAnArray;
        Ruby runtime = context.runtime;
        IRubyObject ary2 = runtime.getNil();
        boolean bl = isAnArray = obj instanceof RubyArray || obj.getMetaClass().getSuperClass() == runtime.getArray();
        if (!isAnArray && !RubyArray.sites((ThreadContext)context).respond_to_to_ary.respondsTo(context, obj, obj, true)) {
            return ary2;
        }
        ary2 = !isAnArray ? RubyArray.sites((ThreadContext)context).to_ary.call(context, obj, obj) : obj.convertToArray();
        return this.cmpCommon(context, runtime, (RubyArray)ary2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject cmpCommon(ThreadContext context, Ruby runtime, RubyArray ary2) {
        int len;
        if (this == ary2 || runtime.isInspecting(this)) {
            return RubyFixnum.zero(runtime);
        }
        try {
            runtime.registerInspecting(this);
            len = this.realLength;
            if (len > ary2.realLength) {
                len = ary2.realLength;
            }
            CallSite cmp2 = RubyArray.sites((ThreadContext)context).cmp;
            for (int i2 = 0; i2 < len; ++i2) {
                IRubyObject elt = this.elt(i2);
                IRubyObject v = cmp2.call(context, elt, elt, ary2.elt(i2));
                if (v instanceof RubyFixnum && ((RubyFixnum)v).getLongValue() == 0L) continue;
                IRubyObject iRubyObject = v;
                return iRubyObject;
            }
        }
        finally {
            runtime.unregisterInspecting(this);
        }
        len = this.realLength - ary2.realLength;
        if (len == 0) {
            return RubyFixnum.zero(runtime);
        }
        if (len > 0) {
            return RubyFixnum.one(runtime);
        }
        return RubyFixnum.minus_one(runtime);
    }

    public IRubyObject slice_bang(IRubyObject[] args2) {
        switch (args2.length) {
            case 1: {
                return this.slice_bang(args2[0]);
            }
            case 2: {
                return this.slice_bang(args2[0], args2[1]);
            }
        }
        Arity.raiseArgumentError(this.getRuntime(), args2.length, 1, 2);
        return null;
    }

    private IRubyObject slice_internal(long pos2, long len, Ruby runtime) {
        if (len < 0L) {
            return runtime.getNil();
        }
        int orig_len = this.realLength;
        if (pos2 < 0L ? (pos2 += (long)orig_len) < 0L : (long)orig_len < pos2) {
            return runtime.getNil();
        }
        if ((long)orig_len < pos2 + len) {
            len = (long)orig_len - pos2;
        }
        if (len == 0L) {
            return runtime.newEmptyArray();
        }
        this.unpack();
        RubyArray result2 = this.makeShared(this.begin + (int)pos2, (int)len, this.getMetaClass());
        this.splice(pos2, len, null, false);
        return result2;
    }

    @JRubyMethod(name={"slice!"})
    public IRubyObject slice_bang(IRubyObject arg0) {
        this.modifyCheck();
        Ruby runtime = this.getRuntime();
        if (arg0 instanceof RubyRange) {
            RubyRange range = (RubyRange)arg0;
            if (!range.checkBegin(this.realLength)) {
                return runtime.getNil();
            }
            long pos2 = range.begLen0(this.realLength);
            long len = range.begLen1(this.realLength, pos2);
            return this.slice_internal(pos2, len, runtime);
        }
        return this.delete_at((int)RubyNumeric.num2long(arg0));
    }

    @JRubyMethod(name={"slice!"})
    public IRubyObject slice_bang(IRubyObject arg0, IRubyObject arg1) {
        this.modifyCheck();
        long pos2 = RubyNumeric.num2long(arg0);
        long len = RubyNumeric.num2long(arg1);
        return this.slice_internal(pos2, len, this.getRuntime());
    }

    @JRubyMethod(name={"assoc"}, required=1)
    public IRubyObject assoc(ThreadContext context, IRubyObject key2) {
        Ruby runtime = context.runtime;
        for (int i2 = 0; i2 < this.realLength; ++i2) {
            IRubyObject v = this.eltOk(i2);
            if (!(v instanceof RubyArray)) continue;
            RubyArray arr = (RubyArray)v;
            if (arr.realLength <= 0 || !RubyArray.equalInternal(context, arr.elt(0L), key2)) continue;
            return arr;
        }
        return runtime.getNil();
    }

    @JRubyMethod(name={"rassoc"}, required=1)
    public IRubyObject rassoc(ThreadContext context, IRubyObject value2) {
        Ruby runtime = context.runtime;
        for (int i2 = 0; i2 < this.realLength; ++i2) {
            IRubyObject v = this.eltOk(i2);
            if (!(v instanceof RubyArray)) continue;
            RubyArray arr = (RubyArray)v;
            if (arr.realLength <= 1 || !RubyArray.equalInternal(context, arr.eltOk(1L), value2)) continue;
            return arr;
        }
        return runtime.getNil();
    }

    protected boolean flatten(ThreadContext context, int level2, RubyArray result2) {
        this.unpack();
        Ruby runtime = context.runtime;
        RubyArray stack = RubyArray.newArrayLight(runtime, 16);
        IdentityHashMap<IRubyObject, IRubyObject> memo = new IdentityHashMap<IRubyObject, IRubyObject>();
        RubyArray ary = this;
        memo.put(ary, NEVER);
        boolean modified = false;
        int i2 = 0;
        try {
            while (true) {
                IRubyObject tmp;
                if (i2 < ary.realLength) {
                    IRubyObject elt = ary.eltOk(i2++);
                    if (level2 >= 0 && stack.size() / 2 >= level2) {
                        result2.append(elt);
                        continue;
                    }
                    tmp = TypeConverter.checkArrayType(elt);
                    if (tmp.isNil()) {
                        result2.append(elt);
                        continue;
                    }
                    modified = true;
                    if (memo.get(tmp) != null) {
                        throw runtime.newArgumentError("tried to flatten recursive array");
                    }
                    memo.put(tmp, NEVER);
                    stack.append(ary);
                    stack.append(RubyFixnum.newFixnum(runtime, i2));
                    ary = (RubyArray)tmp;
                    i2 = 0;
                    continue;
                }
                if (stack.realLength != 0) {
                    memo.remove(ary);
                    tmp = stack.pop(context);
                    i2 = (int)((RubyFixnum)tmp).getLongValue();
                    ary = (RubyArray)stack.pop(context);
                    continue;
                }
                break;
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            RubyArray.concurrentModification(context.runtime, ex);
        }
        return modified;
    }

    @JRubyMethod(name={"flatten!"})
    public IRubyObject flatten_bang(ThreadContext context) {
        this.unpack();
        this.modifyCheck();
        RubyArray result2 = new RubyArray(context.runtime, this.getMetaClass(), this.realLength);
        if (this.flatten(context, -1, result2)) {
            this.modifyCheck();
            this.isShared = false;
            this.begin = 0;
            this.realLength = result2.realLength;
            this.values = result2.values;
            return this;
        }
        return context.nil;
    }

    @JRubyMethod(name={"flatten!"})
    public IRubyObject flatten_bang(ThreadContext context, IRubyObject arg2) {
        this.unpack();
        this.modifyCheck();
        int level2 = RubyNumeric.num2int(arg2);
        if (level2 == 0) {
            return context.nil;
        }
        RubyArray result2 = new RubyArray(context.runtime, this.getMetaClass(), this.realLength);
        if (this.flatten(context, level2, result2)) {
            this.isShared = false;
            this.begin = 0;
            this.realLength = result2.realLength;
            this.values = result2.values;
            return this;
        }
        return context.nil;
    }

    @Deprecated
    public IRubyObject flatten_bang19(ThreadContext context, IRubyObject arg2) {
        return this.flatten_bang(context, arg2);
    }

    @JRubyMethod(name={"flatten"})
    public IRubyObject flatten(ThreadContext context) {
        Ruby runtime = context.runtime;
        RubyArray result2 = new RubyArray(runtime, this.getMetaClass(), this.realLength);
        this.flatten(context, -1, result2);
        result2.infectBy(this);
        return result2;
    }

    @JRubyMethod(name={"flatten"})
    public IRubyObject flatten(ThreadContext context, IRubyObject arg2) {
        Ruby runtime = context.runtime;
        int level2 = RubyNumeric.num2int(arg2);
        if (level2 == 0) {
            return this.makeShared();
        }
        RubyArray result2 = new RubyArray(runtime, this.getMetaClass(), this.realLength);
        this.flatten(context, level2, result2);
        result2.infectBy(this);
        return result2;
    }

    @Deprecated
    public IRubyObject flatten19(ThreadContext context) {
        return this.flatten(context);
    }

    @Deprecated
    public IRubyObject flatten19(ThreadContext context, IRubyObject arg2) {
        return this.flatten(context, arg2);
    }

    @JRubyMethod(name={"count"})
    public IRubyObject count(ThreadContext context, Block block) {
        if (block.isGiven()) {
            int n = 0;
            for (int i2 = 0; i2 < this.realLength; ++i2) {
                if (!block.yield(context, this.elt(i2)).isTrue()) continue;
                ++n;
            }
            return RubyFixnum.newFixnum(context.runtime, n);
        }
        return RubyFixnum.newFixnum(context.runtime, this.realLength);
    }

    @JRubyMethod(name={"count"})
    public IRubyObject count(ThreadContext context, IRubyObject obj, Block block) {
        if (block.isGiven()) {
            context.runtime.getWarnings().warn(IRubyWarnings.ID.BLOCK_UNUSED, "given block not used");
        }
        int n = 0;
        for (int i2 = 0; i2 < this.realLength; ++i2) {
            if (!RubyArray.equalInternal(context, this.elt(i2), obj)) continue;
            ++n;
        }
        return RubyFixnum.newFixnum(context.runtime, n);
    }

    @JRubyMethod(name={"nitems"})
    public IRubyObject nitems() {
        int n = 0;
        for (int i2 = 0; i2 < this.realLength; ++i2) {
            if (this.eltOk(i2).isNil()) continue;
            ++n;
        }
        return this.getRuntime().newFixnum(n);
    }

    @JRubyMethod(name={"+"}, required=1)
    public IRubyObject op_plus(IRubyObject obj) {
        Ruby runtime = this.getRuntime();
        RubyArray y = obj.convertToArray();
        int len = this.realLength + y.realLength;
        switch (len) {
            case 1: {
                return new RubyArrayOneObject(runtime, this.realLength == 1 ? this.eltInternal(0) : y.eltInternal(0));
            }
            case 2: {
                switch (this.realLength) {
                    case 0: {
                        return RubyArray.newArray(runtime, y.eltInternal(0), y.eltInternal(1));
                    }
                    case 1: {
                        return RubyArray.newArray(runtime, this.eltInternal(0), y.eltInternal(0));
                    }
                    case 2: {
                        return RubyArray.newArray(runtime, this.eltInternal(0), this.eltInternal(1));
                    }
                }
            }
        }
        RubyArray z = RubyArray.newArray(runtime, len);
        try {
            this.copyInto(z.values, 0);
            y.copyInto(z.values, this.realLength);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.concurrentModification();
        }
        z.realLength = len;
        return z;
    }

    @JRubyMethod(name={"*"}, required=1)
    public IRubyObject op_times(ThreadContext context, IRubyObject times2) {
        IRubyObject tmp = times2.checkStringType();
        if (!tmp.isNil()) {
            return this.join19(context, tmp);
        }
        long len = RubyNumeric.num2long(times2);
        Ruby runtime = context.runtime;
        if (len == 0L) {
            return new RubyArray(runtime, this.getMetaClass(), IRubyObject.NULL_ARRAY).infectBy(this);
        }
        if (len < 0L) {
            throw runtime.newArgumentError("negative argument");
        }
        if (Long.MAX_VALUE / len < (long)this.realLength) {
            throw runtime.newArgumentError("argument too big");
        }
        RubyArray.checkLength(runtime, len *= (long)this.realLength);
        RubyArray ary2 = new RubyArray(runtime, this.getMetaClass(), (int)len);
        ary2.realLength = ary2.values.length;
        try {
            int i2 = 0;
            while ((long)i2 < len) {
                this.copyInto(ary2.values, i2);
                i2 += this.realLength;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.concurrentModification();
        }
        ary2.infectBy(this);
        return ary2;
    }

    @Deprecated
    public IRubyObject op_times19(ThreadContext context, IRubyObject times2) {
        return this.op_times(context, times2);
    }

    private RubyHash makeHash() {
        return this.makeHash(new RubyHash(this.getRuntime(), false));
    }

    private RubyHash makeHash(RubyHash hash2) {
        for (int i2 = 0; i2 < this.realLength; ++i2) {
            hash2.fastASet(this.elt(i2), NEVER);
        }
        return hash2;
    }

    private RubyHash makeHash(RubyArray ary2) {
        return ary2.makeHash(this.makeHash());
    }

    private RubyHash makeHash(ThreadContext context, Block block) {
        return this.makeHash(context, new RubyHash(this.getRuntime(), false), block);
    }

    private RubyHash makeHash(ThreadContext context, RubyHash hash2, Block block) {
        for (int i2 = 0; i2 < this.realLength; ++i2) {
            IRubyObject v = this.elt(i2);
            IRubyObject k = block.yield(context, v);
            if (hash2.fastARef(k) != null) continue;
            hash2.fastASet(k, v);
        }
        return hash2;
    }

    public IRubyObject uniq_bang(ThreadContext context) {
        RubyHash hash2 = this.makeHash();
        if (this.realLength == hash2.size()) {
            return context.runtime.getNil();
        }
        this.unpack();
        int j = 0;
        for (int i2 = 0; i2 < this.realLength; ++i2) {
            IRubyObject v = this.elt(i2);
            if (!hash2.fastDelete(v)) continue;
            this.store(j++, v);
        }
        this.realLength = j;
        return this;
    }

    @JRubyMethod(name={"uniq!"})
    public IRubyObject uniq_bang19(ThreadContext context, Block block) {
        this.modifyCheck();
        if (!block.isGiven()) {
            return this.uniq_bang(context);
        }
        RubyHash hash2 = this.makeHash(context, block);
        if (this.realLength == hash2.size()) {
            return context.runtime.getNil();
        }
        this.unpack();
        this.realLength = 0;
        hash2.visitAll(context, RubyHash.StoreValueVisitor, this);
        return this;
    }

    public IRubyObject uniq(ThreadContext context) {
        RubyHash hash2 = this.makeHash();
        if (this.realLength == hash2.size()) {
            return this.makeShared();
        }
        RubyArray result2 = new RubyArray(context.runtime, this.getMetaClass(), hash2.size());
        int j = 0;
        try {
            for (int i2 = 0; i2 < this.realLength; ++i2) {
                IRubyObject v = this.elt(i2);
                if (!hash2.fastDelete(v)) continue;
                result2.values[j++] = v;
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            RubyArray.concurrentModification(context.runtime, ex);
        }
        result2.realLength = j;
        return result2;
    }

    @JRubyMethod(name={"uniq"})
    public IRubyObject uniq19(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return this.uniq(context);
        }
        RubyHash hash2 = this.makeHash(context, block);
        RubyArray result2 = new RubyArray(context.runtime, this.getMetaClass(), hash2.size());
        hash2.visitAll(context, RubyHash.StoreValueVisitor, result2);
        return result2;
    }

    @JRubyMethod(name={"-"}, required=1)
    public IRubyObject op_diff(IRubyObject other) {
        RubyHash hash2 = other.convertToArray().makeHash();
        RubyArray ary3 = RubyArray.newArray(this.getRuntime());
        try {
            for (int i2 = 0; i2 < this.realLength; ++i2) {
                IRubyObject value2 = this.eltOk(i2);
                if (hash2.fastARef(value2) != null) continue;
                ary3.append(value2);
            }
        }
        catch (ArrayIndexOutOfBoundsException aioob) {
            this.concurrentModification();
        }
        Helpers.fillNil(ary3.values, ary3.realLength, ary3.values.length, this.getRuntime());
        return ary3;
    }

    @JRubyMethod(name={"&"}, required=1)
    public IRubyObject op_and(IRubyObject other) {
        int maxSize;
        Ruby runtime = this.getRuntime();
        RubyArray ary2 = other.convertToArray();
        RubyHash hash2 = ary2.makeHash();
        int n = maxSize = this.realLength < ary2.realLength ? this.realLength : ary2.realLength;
        if (maxSize == 0) {
            return RubyArray.newEmptyArray(runtime);
        }
        RubyArray ary3 = RubyArray.newBlankArray(runtime, maxSize);
        int index2 = 0;
        for (int i2 = 0; i2 < this.realLength; ++i2) {
            IRubyObject v = this.elt(i2);
            if (!hash2.fastDelete(v)) continue;
            ary3.store(index2++, v);
        }
        if (index2 == 0) {
            return RubyArray.newEmptyArray(runtime);
        }
        if (index2 == 1 && maxSize == 2) {
            return RubyArray.newArray(runtime, ary3.eltInternal(0));
        }
        return ary3;
    }

    @JRubyMethod(name={"|"}, required=1)
    public IRubyObject op_or(IRubyObject other) {
        IRubyObject v;
        int i2;
        Ruby runtime = this.getRuntime();
        RubyArray ary2 = other.convertToArray();
        RubyHash set = this.makeHash(ary2);
        int maxSize = this.realLength + ary2.realLength;
        if (maxSize == 0) {
            return RubyArray.newEmptyArray(runtime);
        }
        RubyArray ary3 = RubyArray.newBlankArray(runtime, maxSize);
        int index2 = 0;
        for (i2 = 0; i2 < this.realLength; ++i2) {
            v = this.elt(i2);
            if (!set.fastDelete(v)) continue;
            ary3.store(index2++, v);
        }
        for (i2 = 0; i2 < ary2.realLength; ++i2) {
            v = ary2.elt(i2);
            if (!set.fastDelete(v)) continue;
            ary3.store(index2++, v);
        }
        if (index2 == 1 && maxSize == 2) {
            return RubyArray.newArray(runtime, ary3.eltInternal(0));
        }
        return ary3;
    }

    @JRubyMethod(name={"sort"})
    public RubyArray sort(ThreadContext context, Block block) {
        RubyArray ary = this.aryDup();
        ary.sort_bang(context, block);
        return ary;
    }

    @Deprecated
    public RubyArray sort19(ThreadContext context, Block block) {
        return this.sort(context, block);
    }

    @JRubyMethod(name={"sort!"})
    public IRubyObject sort_bang(ThreadContext context, Block block) {
        this.modify();
        if (this.realLength > 1) {
            return block.isGiven() ? this.sortInternal(context, block) : this.sortInternal(context, true);
        }
        return this;
    }

    @Deprecated
    public IRubyObject sort_bang19(ThreadContext context, Block block) {
        return this.sort_bang(context, block);
    }

    protected IRubyObject sortInternal(final ThreadContext context, boolean honorOverride) {
        Ruby runtime = context.runtime;
        final boolean fixnumBypass = !honorOverride || runtime.getFixnum().isMethodBuiltin("<=>");
        final boolean stringBypass = !honorOverride || runtime.getString().isMethodBuiltin("<=>");
        try {
            Arrays.sort(this.values, this.begin, this.begin + this.realLength, new Comparator(){

                public int compare(Object o1, Object o2) {
                    if (fixnumBypass && o1 instanceof RubyFixnum && o2 instanceof RubyFixnum) {
                        return RubyArray.compareFixnums((RubyFixnum)o1, (RubyFixnum)o2);
                    }
                    if (stringBypass && o1 instanceof RubyString && o2 instanceof RubyString) {
                        return ((RubyString)o1).op_cmp((RubyString)o2);
                    }
                    return RubyArray.compareOthers(context, (IRubyObject)o1, (IRubyObject)o2);
                }
            });
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            RubyArray.concurrentModification(context.runtime, ex);
        }
        return this;
    }

    protected static int compareFixnums(RubyFixnum o1, RubyFixnum o2) {
        long b2;
        long a = o1.getLongValue();
        return a > (b2 = o2.getLongValue()) ? 1 : (a == b2 ? 0 : -1);
    }

    protected static int compareOthers(ThreadContext context, IRubyObject o1, IRubyObject o2) {
        IRubyObject ret = RubyArray.sites((ThreadContext)context).op_cmp_sort.call(context, o1, o1, o2);
        int n = RubyComparable.cmpint(context, ret, o1, o2);
        return n;
    }

    protected IRubyObject sortInternal(final ThreadContext context, final Block block) {
        IRubyObject[] newValues = new IRubyObject[this.realLength];
        int length2 = this.realLength;
        this.copyInto(newValues, 0);
        Arrays.sort(newValues, 0, length2, new Comparator(){
            CallSite gt;
            CallSite lt;
            {
                this.gt = RubyArray.sites((ThreadContext)context).op_gt_sort;
                this.lt = RubyArray.sites((ThreadContext)context).op_lt_sort;
            }

            public int compare(Object o1, Object o2) {
                IRubyObject obj1 = (IRubyObject)o1;
                IRubyObject obj2 = (IRubyObject)o2;
                IRubyObject ret = block.yieldArray(context, RubyArray.this.getRuntime().newArray(obj1, obj2), null);
                return RubyComparable.cmpint(context, this.gt, this.lt, ret, obj1, obj2);
            }
        });
        this.values = newValues;
        this.begin = 0;
        this.realLength = length2;
        return this;
    }

    @JRubyMethod(name={"sort_by!"})
    public IRubyObject sort_by_bang(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, this, "sort_by!", this.enumLengthFn());
        }
        this.modifyCheck();
        RubyArray sorted = RubyArray.sites((ThreadContext)context).sort_by.call(context, (IRubyObject)this, (IRubyObject)this, block).convertToArray();
        this.replace(sorted);
        return this;
    }

    @JRubyMethod(name={"take"})
    public IRubyObject take(ThreadContext context, IRubyObject n) {
        Ruby runtime = context.runtime;
        long len = RubyNumeric.num2long(n);
        if (len < 0L) {
            throw runtime.newArgumentError("attempt to take negative size");
        }
        return this.subseq(0L, len);
    }

    @JRubyMethod(name={"take_while"})
    public IRubyObject take_while(ThreadContext context, Block block) {
        int i2;
        Ruby runtime = context.runtime;
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(runtime, this, "take_while");
        }
        for (i2 = 0; i2 < this.realLength && block.yield(context, this.eltOk(i2)).isTrue(); ++i2) {
        }
        return this.subseq(0L, i2);
    }

    @JRubyMethod(name={"drop"})
    public IRubyObject drop(ThreadContext context, IRubyObject n) {
        Ruby runtime = context.runtime;
        long pos2 = RubyNumeric.num2long(n);
        if (pos2 < 0L) {
            throw runtime.newArgumentError("attempt to drop negative size");
        }
        IRubyObject result2 = this.subseq(pos2, this.realLength);
        return result2.isNil() ? runtime.newEmptyArray() : result2;
    }

    @JRubyMethod(name={"drop_while"})
    public IRubyObject drop_while(ThreadContext context, Block block) {
        int i2;
        Ruby runtime = context.runtime;
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(runtime, this, "drop_while");
        }
        for (i2 = 0; i2 < this.realLength && block.yield(context, this.eltOk(i2)).isTrue(); ++i2) {
        }
        IRubyObject result2 = this.subseq(i2, this.realLength);
        return result2.isNil() ? runtime.newEmptyArray() : result2;
    }

    @JRubyMethod(name={"cycle"})
    public IRubyObject cycle(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, this, "cycle", this.cycleSizeFn(context));
        }
        return this.cycleCommon(context, -1L, block);
    }

    @JRubyMethod(name={"cycle"})
    public IRubyObject cycle(ThreadContext context, IRubyObject arg2, Block block) {
        if (arg2.isNil()) {
            return this.cycle(context, block);
        }
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, (IRubyObject)this, "cycle", new IRubyObject[]{arg2}, this.cycleSizeFn(context));
        }
        long times2 = RubyNumeric.num2long(arg2);
        if (times2 <= 0L) {
            return context.runtime.getNil();
        }
        return this.cycleCommon(context, times2, block);
    }

    private IRubyObject cycleCommon(ThreadContext context, long n, Block block) {
        while (this.realLength > 0 && (n < 0L || 0L < n--)) {
            for (int i2 = 0; i2 < this.realLength; ++i2) {
                block.yield(context, this.eltOk(i2));
            }
        }
        return context.runtime.getNil();
    }

    private RubyEnumerator.SizeFn cycleSizeFn(final ThreadContext context) {
        return new RubyEnumerator.SizeFn(){
            CallSite op_times;
            {
                this.op_times = RubyArray.sites((ThreadContext)context).op_times;
            }

            @Override
            public IRubyObject size(IRubyObject[] args2) {
                Ruby runtime = context.runtime;
                IRubyObject n = runtime.getNil();
                if (RubyArray.this.realLength == 0) {
                    return RubyFixnum.zero(runtime);
                }
                if (args2 != null && args2.length > 0) {
                    n = args2[0];
                }
                if (n == null || n.isNil()) {
                    return RubyFloat.newFloat(runtime, Double.POSITIVE_INFINITY);
                }
                long multiple = RubyNumeric.num2long(n);
                if (multiple <= 0L) {
                    return RubyFixnum.zero(runtime);
                }
                RubyFixnum length2 = RubyArray.this.length();
                return this.op_times.call(context, (IRubyObject)length2, (IRubyObject)length2, (IRubyObject)RubyFixnum.newFixnum(runtime, multiple));
            }
        };
    }

    public IRubyObject product(ThreadContext context, IRubyObject[] args2) {
        return this.product(context, args2, Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"product"}, rest=true)
    public IRubyObject product(ThreadContext context, IRubyObject[] args2, Block block) {
        Ruby runtime = context.runtime;
        boolean useBlock = block.isGiven();
        int n = args2.length + 1;
        RubyArray[] arrays = new RubyArray[n];
        int[] counters = new int[n];
        arrays[0] = this;
        RubyClass array = runtime.getArray();
        JavaSites.CheckedSites to_ary_checked = RubyArray.sites((ThreadContext)context).to_ary_checked;
        for (int i2 = 1; i2 < n; ++i2) {
            arrays[i2] = (RubyArray)TypeConverter.convertToType19(context, args2[i2 - 1], array, to_ary_checked);
        }
        int resultLen = 1;
        for (int i3 = 0; i3 < n; ++i3) {
            int k = arrays[i3].realLength;
            int l = resultLen;
            if (k == 0) {
                return useBlock ? this : RubyArray.newEmptyArray(runtime);
            }
            if ((resultLen *= k) >= k && resultLen >= l && resultLen / k == l || block.isGiven()) continue;
            throw runtime.newRangeError("too big to product");
        }
        RubyArray result2 = useBlock ? null : RubyArray.newBlankArray(runtime, resultLen);
        for (int i4 = 0; i4 < resultLen; ++i4) {
            int m;
            RubyArray sub2 = RubyArray.newBlankArray(runtime, n);
            for (int j = 0; j < n; ++j) {
                sub2.store(j, arrays[j].entry(counters[j]));
            }
            if (useBlock) {
                block.yieldSpecific(context, sub2);
            } else {
                result2.store(i4, sub2);
            }
            int n2 = m = n - 1;
            counters[n2] = counters[n2] + 1;
            while (m > 0 && counters[m] == arrays[m].realLength) {
                counters[m] = 0;
                int n3 = --m;
                counters[n3] = counters[n3] + 1;
            }
        }
        return useBlock ? this : result2;
    }

    @Deprecated
    public IRubyObject product19(ThreadContext context, IRubyObject[] args2, Block block) {
        return this.product(context, args2, block);
    }

    @JRubyMethod(name={"combination"})
    public IRubyObject combination(ThreadContext context, IRubyObject num, Block block) {
        Ruby runtime = context.runtime;
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, (IRubyObject)this, "combination", new IRubyObject[]{num}, this.combinationSize(context));
        }
        int n = RubyNumeric.num2int(num);
        if (n == 0) {
            block.yield(context, RubyArray.newEmptyArray(runtime));
        } else if (n == 1) {
            for (int i2 = 0; i2 < this.realLength; ++i2) {
                block.yield(context, RubyArray.newArray(runtime, this.eltOk(i2)));
            }
        } else if (n >= 0 && this.realLength >= n) {
            int[] stack = new int[n + 1];
            RubyArray values2 = this.makeShared();
            RubyArray.combinate(context, this.size(), n, stack, values2, block);
        }
        return this;
    }

    private static void combinate(ThreadContext context, int len, int n, int[] stack, RubyArray values2, Block block) {
        int lev = 0;
        Arrays.fill(stack, 1, 1 + n, 0);
        stack[0] = -1;
        while (true) {
            ++lev;
            while (lev < n) {
                stack[lev + 1] = stack[lev] + 1;
                ++lev;
            }
            RubyArray.yieldValues(context, n, stack, 1, values2, block);
            do {
                if (lev == 0) {
                    return;
                }
                int n2 = lev--;
                stack[n2] = stack[n2] + 1;
            } while (stack[lev + 1] + n == len + lev + 1);
        }
    }

    private static void rcombinate(ThreadContext context, int n, int r, int[] p2, RubyArray values2, Block block) {
        int i2 = 0;
        int index2 = 0;
        p2[index2] = i2;
        while (true) {
            int n2;
            if (++index2 < r - 1) {
                p2[index2] = i2;
                continue;
            }
            while (i2 < n) {
                p2[index2] = i2++;
                RubyArray.yieldValues(context, r, p2, 0, values2, block);
            }
            do {
                if (index2 <= 0) {
                    return;
                }
                int n3 = --index2;
                n2 = p2[n3] + 1;
                p2[n3] = n2;
                i2 = n2;
            } while (n2 >= n);
        }
    }

    private RubyEnumerator.SizeFn combinationSize(final ThreadContext context) {
        final RubyArray self2 = this;
        return new RubyEnumerator.SizeFn(){

            @Override
            public IRubyObject size(IRubyObject[] args2) {
                long n = self2.realLength;
                assert (args2 != null && args2.length > 0 && args2[0] instanceof RubyNumeric);
                long k = ((RubyNumeric)args2[0]).getLongValue();
                return RubyArray.this.binomialCoefficient(context, k, n);
            }
        };
    }

    private IRubyObject binomialCoefficient(ThreadContext context, long comb, long size2) {
        Ruby runtime = context.runtime;
        if (comb > size2 - comb) {
            comb = size2 - comb;
        }
        if (comb < 0L) {
            return RubyFixnum.zero(runtime);
        }
        IRubyObject r = this.descendingFactorial(context, size2, comb);
        IRubyObject v = this.descendingFactorial(context, comb, comb);
        return RubyArray.sites((ThreadContext)context).op_quo.call(context, r, r, v);
    }

    @JRubyMethod(name={"repeated_combination"})
    public IRubyObject repeatedCombination(ThreadContext context, IRubyObject num, Block block) {
        Ruby runtime = context.runtime;
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, (IRubyObject)this, "repeated_combination", new IRubyObject[]{num}, this.repeatedCombinationSize(context));
        }
        int n = RubyNumeric.num2int(num);
        int len = this.realLength;
        if (n >= 0) {
            if (n == 0) {
                block.yield(context, RubyArray.newEmptyArray(runtime));
            } else if (n == 1) {
                for (int i2 = 0; i2 < len; ++i2) {
                    block.yield(context, RubyArray.newArray(runtime, this.eltOk(i2)));
                }
            } else {
                int[] p2 = new int[n];
                RubyArray values2 = this.makeShared();
                RubyArray.rcombinate(context, len, n, p2, values2, block);
            }
        }
        return this;
    }

    private RubyEnumerator.SizeFn repeatedCombinationSize(final ThreadContext context) {
        final RubyArray self2 = this;
        return new RubyEnumerator.SizeFn(){

            @Override
            public IRubyObject size(IRubyObject[] args2) {
                long n = self2.realLength;
                assert (args2 != null && args2.length > 0 && args2[0] instanceof RubyNumeric);
                long k = ((RubyNumeric)args2[0]).getLongValue();
                if (k == 0L) {
                    return RubyFixnum.one(context.runtime);
                }
                return RubyArray.this.binomialCoefficient(context, k, n + k - 1L);
            }
        };
    }

    /*
     * Unable to fully structure code
     */
    private static void permute(ThreadContext context, int n, int r, int[] p, boolean[] used, RubyArray values, Block block) {
        i = 0;
        index = 0;
        block0: while (true) {
            if ((unused = Helpers.memchr(used, i, n - i, false)) == -1) {
                if (index == 0) break;
                i = p[--index];
                used[i++] = false;
                continue;
            }
            p[index] = i = unused;
            used[i] = true;
            if (++index < r - 1) {
                i = 0;
                p[index] = 0;
                continue;
            }
            i = 0;
            while (true) {
                if (i < n) ** break;
                continue block0;
                if (!used[i]) {
                    p[index] = i;
                    RubyArray.yieldValues(context, r, p, 0, values, block);
                }
                ++i;
            }
            break;
        }
    }

    private static void yieldValues(ThreadContext context, int r, int[] p2, int pStart, RubyArray values2, Block block) {
        RubyArray result2 = RubyArray.newBlankArray(context.runtime, r);
        for (int j = 0; j < r; ++j) {
            result2.store(j, values2.eltInternal(p2[j + pStart]));
        }
        result2.realLength = r;
        block.yield(context, result2);
    }

    private static void rpermute(ThreadContext context, int n, int r, int[] p2, RubyArray values2, Block block) {
        int i2 = 0;
        int index2 = 0;
        p2[index2] = i2;
        while (true) {
            int n2;
            if (++index2 < r - 1) {
                i2 = 0;
                p2[index2] = 0;
                continue;
            }
            i2 = 0;
            while (i2 < n) {
                p2[index2] = i2++;
                RubyArray.yieldValues(context, r, p2, 0, values2, block);
            }
            do {
                if (index2 <= 0) {
                    return;
                }
                int n3 = --index2;
                n2 = p2[n3] + 1;
                p2[n3] = n2;
                i2 = n2;
            } while (n2 >= n);
        }
    }

    @JRubyMethod(name={"permutation"})
    public IRubyObject permutation(ThreadContext context, IRubyObject num, Block block) {
        return block.isGiven() ? this.permutationCommon(context, RubyNumeric.num2int(num), false, block) : RubyEnumerator.enumeratorizeWithSize(context, (IRubyObject)this, "permutation", new IRubyObject[]{num}, this.permutationSize(context));
    }

    @JRubyMethod(name={"permutation"})
    public IRubyObject permutation(ThreadContext context, Block block) {
        return block.isGiven() ? this.permutationCommon(context, this.realLength, false, block) : RubyEnumerator.enumeratorizeWithSize(context, this, "permutation", this.permutationSize(context));
    }

    @JRubyMethod(name={"repeated_permutation"})
    public IRubyObject repeated_permutation(ThreadContext context, IRubyObject num, Block block) {
        return block.isGiven() ? this.permutationCommon(context, RubyNumeric.num2int(num), true, block) : RubyEnumerator.enumeratorizeWithSize(context, (IRubyObject)this, "repeated_permutation", new IRubyObject[]{num}, this.repeatedPermutationSize(context));
    }

    private RubyEnumerator.SizeFn repeatedPermutationSize(final ThreadContext context) {
        final Ruby runtime = context.runtime;
        final RubyArray self2 = this;
        return new RubyEnumerator.SizeFn(){
            CallSite op_exp;
            {
                this.op_exp = RubyArray.sites((ThreadContext)context).op_exp;
            }

            @Override
            public IRubyObject size(IRubyObject[] args2) {
                RubyFixnum n = self2.length();
                assert (args2 != null && args2.length > 0 && args2[0] instanceof RubyNumeric);
                long k = ((RubyNumeric)args2[0]).getLongValue();
                if (k < 0L) {
                    return RubyFixnum.zero(runtime);
                }
                RubyFixnum v = RubyFixnum.newFixnum(runtime, k);
                return this.op_exp.call(context, (IRubyObject)n, (IRubyObject)n, (IRubyObject)v);
            }
        };
    }

    private IRubyObject permutationCommon(ThreadContext context, int r, boolean repeat, Block block) {
        if (r == 0) {
            block.yield(context, RubyArray.newEmptyArray(context.runtime));
        } else if (r == 1) {
            for (int i2 = 0; i2 < this.realLength; ++i2) {
                block.yield(context, RubyArray.newArray(context.runtime, this.eltOk(i2)));
            }
        } else if (r >= 0) {
            this.unpack();
            int n = this.realLength;
            if (repeat) {
                RubyArray.rpermute(context, n, r, new int[r], this.makeShared(this.begin, n, this.getMetaClass()), block);
            } else {
                RubyArray.permute(context, n, r, new int[r], new boolean[n], this.makeShared(this.begin, n, this.getMetaClass()), block);
            }
        }
        return this;
    }

    private RubyEnumerator.SizeFn permutationSize(final ThreadContext context) {
        final RubyArray self2 = this;
        return new RubyEnumerator.SizeFn(){

            @Override
            public IRubyObject size(IRubyObject[] args2) {
                long k;
                long n = self2.realLength;
                if (args2 != null && args2.length > 0) {
                    assert (args2[0] instanceof RubyNumeric);
                    k = ((RubyNumeric)args2[0]).getLongValue();
                } else {
                    k = n;
                }
                return RubyArray.this.descendingFactorial(context, n, k);
            }
        };
    }

    private IRubyObject descendingFactorial(ThreadContext context, long from, long howMany) {
        Ruby runtime = context.runtime;
        IRubyObject cnt = howMany >= 0L ? RubyFixnum.one(runtime) : RubyFixnum.zero(runtime);
        CallSite op_times2 = RubyArray.sites((ThreadContext)context).op_times;
        while (howMany-- > 0L) {
            RubyFixnum v = RubyFixnum.newFixnum(runtime, from--);
            cnt = op_times2.call(context, cnt, cnt, (IRubyObject)v);
        }
        return cnt;
    }

    @Deprecated
    public IRubyObject choice(ThreadContext context) {
        if (this.realLength == 0) {
            return context.nil;
        }
        return this.eltOk((int)(context.runtime.getDefaultRand().genrandReal() * (double)this.realLength));
    }

    public IRubyObject shuffle_bang(ThreadContext context) {
        return this.shuffle_bang(context, IRubyObject.NULL_ARRAY);
    }

    @JRubyMethod(name={"shuffle!"}, optional=1)
    public IRubyObject shuffle_bang(ThreadContext context, IRubyObject[] args2) {
        IRubyObject argRandgen;
        IRubyObject hash2;
        this.modify();
        IRubyObject randgen = context.runtime.getRandomClass();
        if (args2.length > 0 && !(hash2 = TypeConverter.checkHashType(context.runtime, args2[args2.length - 1])).isNil() && (argRandgen = ((RubyHash)hash2).fastARef(context.runtime.newSymbol("random"))) != null) {
            randgen = argRandgen;
        }
        int i2 = this.realLength;
        try {
            while (i2 > 0) {
                int r = (int)(RubyRandom.randomReal(context, randgen) * (double)i2);
                IRubyObject tmp = this.eltOk(--i2);
                this.eltSetOk(i2, this.eltOk(r));
                this.eltSetOk(r, tmp);
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            RubyArray.concurrentModification(context.runtime, ex);
        }
        return this;
    }

    public IRubyObject shuffle(ThreadContext context) {
        return this.shuffle(context, IRubyObject.NULL_ARRAY);
    }

    @JRubyMethod(name={"shuffle"}, optional=1)
    public IRubyObject shuffle(ThreadContext context, IRubyObject[] args2) {
        RubyArray ary = this.aryDup();
        ary.shuffle_bang(context, args2);
        return ary;
    }

    @JRubyMethod(name={"sample"}, optional=2)
    public IRubyObject sample(ThreadContext context, IRubyObject[] args2) {
        this.unpack();
        try {
            int i2;
            IRubyObject hash2;
            IRubyObject randgen = context.runtime.getRandomClass();
            if (args2.length == 0) {
                if (this.realLength == 0) {
                    return context.nil;
                }
                int i3 = this.realLength == 1 ? 0 : this.randomReal(context, randgen, this.realLength);
                return this.eltOk(i3);
            }
            if (args2.length > 0 && !(hash2 = TypeConverter.checkHashType(context.runtime, args2[args2.length - 1])).isNil()) {
                IRubyObject argRandgen = ((RubyHash)hash2).fastARef(context.runtime.newSymbol("random"));
                if (argRandgen != null) {
                    randgen = argRandgen;
                }
                IRubyObject[] newargs = new IRubyObject[args2.length - 1];
                System.arraycopy(args2, 0, newargs, 0, args2.length - 1);
                args2 = newargs;
            }
            if (args2.length == 0) {
                if (this.realLength == 0) {
                    return context.nil;
                }
                if (this.realLength == 1) {
                    return this.eltOk(0L);
                }
                return this.eltOk(this.randomReal(context, randgen, this.realLength));
            }
            Ruby runtime = context.runtime;
            int n = RubyNumeric.num2int(args2[0]);
            if (n < 0) {
                throw runtime.newArgumentError("negative sample number");
            }
            if (n > this.realLength) {
                n = this.realLength;
            }
            double[] rnds = new double[10];
            if (n <= 10) {
                for (int idx = 0; idx < n; ++idx) {
                    rnds[idx] = RubyRandom.randomReal(context, randgen);
                }
            }
            switch (n) {
                case 0: {
                    return RubyArray.newEmptyArray(runtime);
                }
                case 1: {
                    if (this.realLength <= 0) {
                        return RubyArray.newEmptyArray(runtime);
                    }
                    return RubyArray.newArray(runtime, this.eltOk((int)(rnds[0] * (double)this.realLength)));
                }
                case 2: {
                    i2 = (int)(rnds[0] * (double)this.realLength);
                    int j = (int)(rnds[1] * (double)(this.realLength - 1));
                    if (j >= i2) {
                        ++j;
                    }
                    return RubyArray.newArray(runtime, this.eltOk(i2), this.eltOk(j));
                }
                case 3: {
                    i2 = (int)(rnds[0] * (double)this.realLength);
                    int j = (int)(rnds[1] * (double)(this.realLength - 1));
                    int k = (int)(rnds[2] * (double)(this.realLength - 2));
                    int l = j;
                    int g = i2;
                    if (j >= i2) {
                        l = i2;
                        g = ++j;
                    }
                    if (k >= l && ++k >= g) {
                        ++k;
                    }
                    return RubyArray.newArray(runtime, this.eltOk(i2), this.eltOk(j), this.eltOk(k));
                }
            }
            int len = this.realLength;
            if (n > len) {
                n = len;
            }
            if (n < 10) {
                int[] idx = new int[10];
                int[] sorted = new int[10];
                sorted[0] = idx[0] = (int)(rnds[0] * (double)len);
                for (i2 = 1; i2 < n; ++i2) {
                    int j;
                    int k = (int)(rnds[i2] * (double)(--len));
                    for (j = 0; j < i2 && k >= sorted[j]; ++k, ++j) {
                    }
                    System.arraycopy(sorted, j, sorted, j + 1, i2 - j);
                    sorted[j] = idx[i2] = k;
                }
                IRubyObject[] result2 = new IRubyObject[n];
                for (i2 = 0; i2 < n; ++i2) {
                    result2[i2] = this.eltOk(idx[i2]);
                }
                return RubyArray.newArrayMayCopy(runtime, result2);
            }
            IRubyObject[] result3 = new IRubyObject[len];
            System.arraycopy(this.values, this.begin, result3, 0, len);
            for (i2 = 0; i2 < n; ++i2) {
                int j = this.randomReal(context, randgen, len - i2) + i2;
                IRubyObject tmp = result3[j];
                result3[j] = result3[i2];
                result3[i2] = tmp;
            }
            RubyArray ary = RubyArray.newArrayNoCopy(runtime, result3);
            ary.realLength = n;
            return ary;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            RubyArray.concurrentModification(context.runtime, ex);
            return this;
        }
    }

    private int randomReal(ThreadContext context, IRubyObject randgen, int len) {
        return (int)(RubyRandom.randomReal(context, randgen) * (double)len);
    }

    private static void aryReverse(IRubyObject[] _p1, int p1, IRubyObject[] _p2, int p2) {
        while (p1 < p2) {
            IRubyObject tmp = _p1[p1];
            _p1[p1++] = _p2[p2];
            _p2[p2--] = tmp;
        }
    }

    protected IRubyObject internalRotateBang(ThreadContext context, int cnt) {
        this.modify();
        try {
            if (cnt != 0) {
                IRubyObject[] ptr = this.values;
                int len = this.realLength;
                if (len > 0 && (cnt = RubyArray.rotateCount(cnt, len)) > 0) {
                    if (cnt < --len) {
                        RubyArray.aryReverse(ptr, this.begin + cnt, ptr, this.begin + len);
                    }
                    if (--cnt > 0) {
                        RubyArray.aryReverse(ptr, this.begin, ptr, this.begin + cnt);
                    }
                    if (len > 0) {
                        RubyArray.aryReverse(ptr, this.begin, ptr, this.begin + len);
                    }
                    return this;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            RubyArray.concurrentModification(context.runtime, ex);
        }
        return context.runtime.getNil();
    }

    private static int rotateCount(int cnt, int len) {
        return cnt < 0 ? len - ~cnt % len - 1 : cnt % len;
    }

    protected IRubyObject internalRotate(ThreadContext context, int cnt) {
        int len = this.realLength;
        RubyArray rotated = this.aryDup();
        rotated.modify();
        try {
            if (len > 0) {
                cnt = RubyArray.rotateCount(cnt, len);
                IRubyObject[] ptr = this.values;
                IRubyObject[] ptr2 = rotated.values;
                System.arraycopy(ptr, this.begin + cnt, ptr2, 0, len -= cnt);
                System.arraycopy(ptr, this.begin, ptr2, len, cnt);
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            RubyArray.concurrentModification(context.runtime, ex);
        }
        return rotated;
    }

    @JRubyMethod(name={"rotate!"})
    public IRubyObject rotate_bang(ThreadContext context) {
        this.internalRotateBang(context, 1);
        return this;
    }

    @JRubyMethod(name={"rotate!"})
    public IRubyObject rotate_bang(ThreadContext context, IRubyObject cnt) {
        this.internalRotateBang(context, RubyNumeric.fix2int(cnt));
        return this;
    }

    @JRubyMethod(name={"rotate"})
    public IRubyObject rotate(ThreadContext context) {
        return this.internalRotate(context, 1);
    }

    @JRubyMethod(name={"rotate"})
    public IRubyObject rotate(ThreadContext context, IRubyObject cnt) {
        return this.internalRotate(context, RubyNumeric.fix2int(cnt));
    }

    public IRubyObject all_p(ThreadContext context, Block block) {
        if (!this.isBuiltin("each")) {
            return RubyEnumerable.all_pCommon(context, this, block);
        }
        if (!block.isGiven()) {
            return this.all_pBlockless(context);
        }
        for (int i2 = 0; i2 < this.realLength; ++i2) {
            if (block.yield(context, this.eltOk(i2)).isTrue()) continue;
            return context.runtime.getFalse();
        }
        return context.runtime.getTrue();
    }

    private IRubyObject all_pBlockless(ThreadContext context) {
        for (int i2 = 0; i2 < this.realLength; ++i2) {
            if (this.eltOk(i2).isTrue()) continue;
            return context.runtime.getFalse();
        }
        return context.runtime.getTrue();
    }

    @JRubyMethod(name={"any?"})
    public IRubyObject any_p(ThreadContext context, Block block) {
        if (this.isEmpty()) {
            return context.runtime.getFalse();
        }
        if (!this.isBuiltin("each")) {
            return RubyEnumerable.any_pCommon(context, this, block);
        }
        if (!block.isGiven()) {
            return this.any_pBlockless(context);
        }
        for (int i2 = 0; i2 < this.realLength; ++i2) {
            if (!block.yield(context, this.eltOk(i2)).isTrue()) continue;
            return context.runtime.getTrue();
        }
        return context.runtime.getFalse();
    }

    private IRubyObject any_pBlockless(ThreadContext context) {
        for (int i2 = 0; i2 < this.realLength; ++i2) {
            if (!this.eltOk(i2).isTrue()) continue;
            return context.runtime.getTrue();
        }
        return context.runtime.getFalse();
    }

    public IRubyObject find(ThreadContext context, IRubyObject ifnone, Block block) {
        if (!this.isBuiltin("each")) {
            return RubyEnumerable.detectCommon(context, this, block);
        }
        return this.detectCommon(context, ifnone, block);
    }

    public IRubyObject find_index(ThreadContext context, Block block) {
        if (!this.isBuiltin("each")) {
            return RubyEnumerable.find_indexCommon(context, (IRubyObject)this, block, Signature.OPTIONAL);
        }
        for (int i2 = 0; i2 < this.realLength; ++i2) {
            if (!block.yield(context, this.eltOk(i2)).isTrue()) continue;
            return context.runtime.newFixnum(i2);
        }
        return context.nil;
    }

    public IRubyObject find_index(ThreadContext context, IRubyObject cond) {
        if (!this.isBuiltin("each")) {
            return RubyEnumerable.find_indexCommon(context, this, cond);
        }
        for (int i2 = 0; i2 < this.realLength; ++i2) {
            if (!this.eltOk(i2).equals(cond)) continue;
            return context.runtime.newFixnum(i2);
        }
        return context.nil;
    }

    public IRubyObject detectCommon(ThreadContext context, IRubyObject ifnone, Block block) {
        for (int i2 = 0; i2 < this.realLength; ++i2) {
            IRubyObject value2 = this.eltOk(i2);
            if (!block.yield(context, value2).isTrue()) continue;
            return value2;
        }
        return ifnone != null ? RubyArray.sites((ThreadContext)context).call.call(context, ifnone, ifnone) : context.nil;
    }

    public static void marshalTo(RubyArray array, MarshalStream output) throws IOException {
        output.registerLinkTarget(array);
        int length2 = array.realLength;
        output.writeInt(length2);
        try {
            for (int i2 = 0; i2 < length2; ++i2) {
                output.dumpObject(array.eltInternal(i2));
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            RubyArray.concurrentModification(array.getRuntime(), ex);
        }
    }

    public static RubyArray unmarshalFrom(UnmarshalStream input) throws IOException {
        Ruby runtime = input.getRuntime();
        int size2 = input.unmarshalInt();
        RubyArray result2 = RubyArray.newBlankArray(runtime, size2);
        input.registerLinkTarget(result2);
        for (int i2 = 0; i2 < size2; ++i2) {
            result2.store(i2, input.unmarshalObject());
        }
        return result2;
    }

    public static RubyArray newBlankArray(Ruby runtime, int size2) {
        switch (size2) {
            case 0: {
                return RubyArray.newEmptyArray(runtime);
            }
            case 1: {
                return new RubyArrayOneObject(runtime, runtime.getNil());
            }
            case 2: {
                return new RubyArrayTwoObject(runtime, runtime.getNil(), runtime.getNil());
            }
        }
        return RubyArray.newArray(runtime, size2);
    }

    @JRubyMethod(name={"try_convert"}, meta=true)
    public static IRubyObject try_convert(ThreadContext context, IRubyObject self2, IRubyObject arg2) {
        return arg2.checkArrayType();
    }

    @JRubyMethod(name={"pack"}, required=1)
    public RubyString pack(ThreadContext context, IRubyObject obj) {
        RubyString iFmt = obj.convertToString();
        try {
            return Pack.pack(context, context.runtime, this, iFmt);
        }
        catch (ArrayIndexOutOfBoundsException aioob) {
            this.concurrentModification();
            return null;
        }
    }

    @JRubyMethod(name={"dig"}, required=1, rest=true)
    public IRubyObject dig(ThreadContext context, IRubyObject[] args2) {
        return this.dig(context, args2, 0);
    }

    final IRubyObject dig(ThreadContext context, IRubyObject[] args2, int idx) {
        IRubyObject val = this.at(args2[idx++]);
        return idx == args2.length ? val : RubyObject.dig(context, val, args2, idx);
    }

    private IRubyObject maxWithBlock(ThreadContext context, Block block) {
        IRubyObject result2 = UNDEF;
        Ruby runtime = context.runtime;
        JavaSites.ArraySites sites = RubyArray.sites(context);
        CallSite op_gt2 = sites.op_gt_minmax;
        CallSite op_lt2 = sites.op_lt_minmax;
        for (int i2 = 0; i2 < this.realLength; ++i2) {
            IRubyObject v = this.eltOk(i2);
            if (result2 != UNDEF && RubyComparable.cmpint(context, op_gt2, op_lt2, block.yieldArray(context, runtime.newArray(v, result2), null), v, result2) <= 0) continue;
            result2 = v;
        }
        return result2 == UNDEF ? context.nil : result2;
    }

    @JRubyMethod(name={"max"})
    public IRubyObject max(ThreadContext context, Block block) {
        if (block.isGiven()) {
            return this.maxWithBlock(context, block);
        }
        if (this.realLength < 1) {
            return context.nil;
        }
        IRubyObject result2 = UNDEF;
        JavaSites.ArraySites sites = RubyArray.sites(context);
        CachingCallSite op_cmp2 = sites.op_cmp_minmax;
        CallSite op_gt2 = sites.op_gt_minmax;
        CallSite op_lt2 = sites.op_lt_minmax;
        int generation = this.getArg0Generation(op_cmp2);
        for (int i2 = 0; i2 < this.realLength; ++i2) {
            IRubyObject v = this.eltOk(i2);
            if (result2 != UNDEF && RubyArray.optimizedCmp(context, v, result2, generation, op_cmp2, op_gt2, op_lt2) <= 0) continue;
            result2 = v;
        }
        return result2 == UNDEF ? context.nil : result2;
    }

    @JRubyMethod(name={"max"})
    public IRubyObject max(ThreadContext context, IRubyObject num, Block block) {
        if (!num.isNil()) {
            return RubyEnumerable.max(context, this, num, block);
        }
        return this.max(context, block);
    }

    private IRubyObject minWithBlock(ThreadContext context, Block block) {
        IRubyObject result2 = UNDEF;
        Ruby runtime = context.runtime;
        JavaSites.ArraySites sites = RubyArray.sites(context);
        CallSite op_gt2 = sites.op_gt_minmax;
        CallSite op_lt2 = sites.op_lt_minmax;
        for (int i2 = 0; i2 < this.realLength; ++i2) {
            IRubyObject v = this.eltOk(i2);
            if (result2 != UNDEF && RubyComparable.cmpint(context, op_gt2, op_lt2, block.yieldArray(context, runtime.newArray(v, result2), null), v, result2) >= 0) continue;
            result2 = v;
        }
        return result2 == UNDEF ? context.nil : result2;
    }

    @JRubyMethod(name={"min"})
    public IRubyObject min(ThreadContext context, Block block) {
        if (block.isGiven()) {
            return this.minWithBlock(context, block);
        }
        if (this.realLength == 0) {
            return context.nil;
        }
        if (this.realLength == 1) {
            return this.eltInternal(0);
        }
        IRubyObject result2 = UNDEF;
        JavaSites.ArraySites sites = RubyArray.sites(context);
        CachingCallSite op_cmp2 = sites.op_cmp_minmax;
        CallSite op_gt2 = sites.op_gt_minmax;
        CallSite op_lt2 = sites.op_lt_minmax;
        int generation = this.getArg0Generation(op_cmp2);
        for (int i2 = 0; i2 < this.realLength; ++i2) {
            IRubyObject v = this.eltOk(i2);
            if (result2 != UNDEF && RubyArray.optimizedCmp(context, v, result2, generation, op_cmp2, op_gt2, op_lt2) >= 0) continue;
            result2 = v;
        }
        return result2 == UNDEF ? context.nil : result2;
    }

    private int getArg0Generation(CachingCallSite op_cmp2) {
        IRubyObject arg0 = this.eltInternal(0);
        RubyClass metaclass = arg0.getMetaClass();
        CacheEntry entry = op_cmp2.retrieveCache(metaclass);
        int generation = -1;
        if (entry.method.isBuiltin()) {
            generation = entry.token;
        }
        return generation;
    }

    @JRubyMethod(name={"min"})
    public IRubyObject min(ThreadContext context, IRubyObject num, Block block) {
        if (!num.isNil()) {
            return RubyEnumerable.min(context, this, num, block);
        }
        return this.min(context, block);
    }

    private static final int optimizedCmp(ThreadContext context, IRubyObject a, IRubyObject b2, int token, CachingCallSite op_cmp2, CallSite op_gt2, CallSite op_lt2) {
        if (token == ((RubyBasicObject)a).getMetaClass().generation) {
            if (a instanceof RubyFixnum && b2 instanceof RubyFixnum) {
                long aLong = ((RubyFixnum)a).getLongValue();
                long bLong = ((RubyFixnum)b2).getLongValue();
                return Long.compare(aLong, bLong);
            }
            if (a instanceof RubyString && b2 instanceof RubyString) {
                return ((RubyString)a).op_cmp((RubyString)b2);
            }
        }
        return RubyComparable.cmpint(context, op_gt2, op_lt2, op_cmp2.call(context, a, a, b2), a, b2);
    }

    @Override
    public Class getJavaClass() {
        return List.class;
    }

    public void copyInto(IRubyObject[] target, int start2) {
        assert (target.length - start2 >= this.realLength);
        this.safeArrayCopy(this.values, this.begin, target, start2, this.realLength);
    }

    public void copyInto(IRubyObject[] target, int start2, int len) {
        assert (target.length - start2 >= len);
        this.safeArrayCopy(this.values, this.begin, target, start2, len);
    }

    @Override
    public int size() {
        return this.realLength;
    }

    @Override
    public boolean isEmpty() {
        return this.realLength == 0;
    }

    @Override
    public boolean contains(Object element) {
        return this.indexOf(element) != -1;
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.realLength];
        for (int i2 = 0; i2 < this.realLength; ++i2) {
            array[i2] = this.eltInternal(i2).toJava(Object.class);
        }
        return array;
    }

    @Override
    public Object[] toArray(Object[] arg2) {
        Object[] array = arg2;
        Class<?> type2 = array.getClass().getComponentType();
        if (array.length < this.realLength) {
            array = (Object[])Array.newInstance(type2, this.realLength);
        }
        int length2 = this.realLength;
        for (int i2 = 0; i2 < length2; ++i2) {
            array[i2] = this.eltInternal(i2).toJava(type2);
        }
        return array;
    }

    @Override
    public Object toJava(Class target) {
        if (target.isArray()) {
            Class<?> type2 = target.getComponentType();
            Object rawJavaArray = Array.newInstance(type2, this.realLength);
            try {
                ArrayUtils.copyDataToJavaArrayDirect(this.getRuntime().getCurrentContext(), this, rawJavaArray);
            }
            catch (ArrayIndexOutOfBoundsException aioob) {
                this.concurrentModification();
            }
            return rawJavaArray;
        }
        return super.toJava(target);
    }

    @Override
    public boolean add(Object element) {
        this.append(JavaUtil.convertJavaToUsableRubyObject(this.getRuntime(), element));
        return true;
    }

    @Override
    public boolean remove(Object element) {
        this.unpack();
        Ruby runtime = this.getRuntime();
        ThreadContext context = runtime.getCurrentContext();
        IRubyObject item = JavaUtil.convertJavaToUsableRubyObject(runtime, element);
        boolean listchanged = false;
        for (int i1 = 0; i1 < this.realLength; ++i1) {
            IRubyObject e = this.values[this.begin + i1];
            if (!RubyArray.equalInternal(context, e, item)) continue;
            this.delete_at(i1);
            listchanged = true;
            break;
        }
        return listchanged;
    }

    @Override
    public boolean containsAll(Collection c) {
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            if (this.indexOf(iter.next()) != -1) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection c) {
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            this.add(iter.next());
        }
        return !c.isEmpty();
    }

    public boolean addAll(int index2, Collection c) {
        Iterator iter = c.iterator();
        int i2 = index2;
        while (iter.hasNext()) {
            this.add(i2, iter.next());
            ++i2;
        }
        return !c.isEmpty();
    }

    @Override
    public boolean removeAll(Collection c) {
        boolean listChanged = false;
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            IRubyObject deleted = this.delete(this.getRuntime().getCurrentContext(), JavaUtil.convertJavaToUsableRubyObject(this.getRuntime(), iter.next()), Block.NULL_BLOCK);
            if (deleted.isNil()) continue;
            listChanged = true;
        }
        return listChanged;
    }

    @Override
    public boolean retainAll(Collection c) {
        boolean listChanged = false;
        for (Object element : this) {
            if (c.contains(element)) continue;
            this.remove(element);
            listChanged = true;
        }
        return listChanged;
    }

    public Object get(int index2) {
        return this.elt(index2).toJava(Object.class);
    }

    public Object set(int index2, Object element) {
        Object previous = this.elt(index2).toJava(Object.class);
        this.store(index2, JavaUtil.convertJavaToUsableRubyObject(this.getRuntime(), element));
        return previous;
    }

    public void add(int index2, Object element) {
        this.insert(new IRubyObject[]{RubyFixnum.newFixnum(this.getRuntime(), index2), JavaUtil.convertJavaToUsableRubyObject(this.getRuntime(), element)});
    }

    public Object remove(int index2) {
        return this.delete_at(index2).toJava(Object.class);
    }

    @Override
    public int indexOf(Object element) {
        int myBegin = this.begin;
        if (element != null) {
            IRubyObject convertedElement = JavaUtil.convertJavaToUsableRubyObject(this.getRuntime(), element);
            for (int i2 = myBegin; i2 < myBegin + this.realLength; ++i2) {
                if (!convertedElement.equals(this.values[i2])) continue;
                return i2;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object element) {
        boolean myBegin = false;
        if (element != null) {
            IRubyObject convertedElement = JavaUtil.convertJavaToUsableRubyObject(this.getRuntime(), element);
            for (int i2 = this.realLength - 1; i2 >= 0; --i2) {
                if (!convertedElement.equals(this.eltInternal(i2))) continue;
                return i2;
            }
        }
        return -1;
    }

    @Override
    public Iterator iterator() {
        return new RubyArrayConversionIterator();
    }

    public ListIterator listIterator() {
        return new RubyArrayConversionListIterator();
    }

    public ListIterator listIterator(int index2) {
        return new RubyArrayConversionListIterator(index2);
    }

    public List subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this.size() || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException();
        }
        IRubyObject subList = this.subseq(fromIndex, toIndex - fromIndex);
        return subList.isNil() ? null : (List)((Object)subList);
    }

    @Override
    public void clear() {
        this.rb_clear();
    }

    private IRubyObject safeArrayRef(IRubyObject[] values2, int i2) {
        return RubyArray.safeArrayRef(this.getRuntime(), values2, i2);
    }

    private static IRubyObject safeArrayRef(Ruby runtime, IRubyObject[] values2, int i2) {
        try {
            return values2[i2];
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            RubyArray.concurrentModification(runtime, ex);
            return null;
        }
    }

    private IRubyObject safeArraySet(IRubyObject[] values2, int i2, IRubyObject value2) {
        return RubyArray.safeArraySet(this.getRuntime(), values2, i2, value2);
    }

    private static IRubyObject safeArraySet(Ruby runtime, IRubyObject[] values2, int i2, IRubyObject value2) {
        try {
            values2[i2] = value2;
            return values2[i2];
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            RubyArray.concurrentModification(runtime, ex);
            return null;
        }
    }

    private static IRubyObject safeArrayRefSet(Ruby runtime, IRubyObject[] values2, int i2, IRubyObject value2) {
        try {
            IRubyObject tmp = values2[i2];
            values2[i2] = value2;
            return tmp;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            RubyArray.concurrentModification(runtime, e);
            return null;
        }
    }

    private static IRubyObject safeArrayRefCondSet(Ruby runtime, IRubyObject[] values2, int i2, boolean doSet, IRubyObject value2) {
        try {
            IRubyObject tmp = values2[i2];
            if (doSet) {
                values2[i2] = value2;
            }
            return tmp;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            RubyArray.concurrentModification(runtime, ex);
            return null;
        }
    }

    private void safeArrayCopy(IRubyObject[] source2, int sourceStart, IRubyObject[] target, int targetStart, int length2) {
        RubyArray.safeArrayCopy(this.getRuntime(), source2, sourceStart, target, targetStart, length2);
    }

    private static void safeArrayCopy(Ruby runtime, IRubyObject[] source2, int sourceStart, IRubyObject[] target, int targetStart, int length2) {
        try {
            System.arraycopy(source2, sourceStart, target, targetStart, length2);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            RubyArray.concurrentModification(runtime, ex);
        }
    }

    private static JavaSites.ArraySites sites(ThreadContext context) {
        return context.sites.Array;
    }

    @Deprecated
    public IRubyObject compatc19() {
        return this.compact19();
    }

    @Deprecated
    public final RubyArray aryDup19() {
        return this.aryDup();
    }

    @Deprecated
    public void ensureCapacity(int minCapacity) {
        this.unpack();
        if (this.isShared || this.values.length - this.begin < minCapacity) {
            int len = this.realLength;
            int newCapacity = minCapacity > len ? minCapacity : len;
            IRubyObject[] values2 = new IRubyObject[newCapacity];
            System.arraycopy(this.values, this.begin, values2, 0, len);
            this.values = values2;
            this.begin = 0;
        }
    }

    @Deprecated
    public IRubyObject flatten_bang19(ThreadContext context) {
        return this.flatten_bang(context);
    }

    final class RubyArrayConversionListIterator
    extends RubyArrayConversionIterator
    implements ListIterator {
        public RubyArrayConversionListIterator() {
        }

        public RubyArrayConversionListIterator(int index2) {
            this.index = index2;
        }

        @Override
        public boolean hasPrevious() {
            return this.index >= 0;
        }

        public Object previous() {
            this.last = --this.index;
            return RubyArray.this.elt(this.index).toJava(Object.class);
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        public void set(Object obj) {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            RubyArray.this.store(this.last, JavaUtil.convertJavaToUsableRubyObject(RubyArray.this.getRuntime(), obj));
        }

        public void add(Object obj) {
            RubyArray.this.insert(new IRubyObject[]{RubyFixnum.newFixnum(RubyArray.this.getRuntime(), this.index++), JavaUtil.convertJavaToUsableRubyObject(RubyArray.this.getRuntime(), obj)});
            this.last = -1;
        }
    }

    public class RubyArrayConversionIterator
    implements Iterator {
        protected int index = 0;
        protected int last = -1;

        @Override
        public boolean hasNext() {
            return this.index < RubyArray.this.realLength;
        }

        public Object next() {
            IRubyObject element = RubyArray.this.elt(this.index);
            this.last = this.index++;
            return element.toJava(Object.class);
        }

        @Override
        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            RubyArray.this.delete_at(this.last);
            if (this.last < this.index) {
                --this.index;
            }
            this.last = -1;
        }
    }

    public static interface ArgumentVisitor {
        public IRubyObject visit(ThreadContext var1, IRubyObject var2, int var3);
    }
}

