/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.targets;

import com.headius.invokebinder.Binder;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.MutableCallSite;
import java.lang.invoke.SwitchPoint;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubySymbol;
import org.jruby.ir.operands.UndefinedValue;
import org.jruby.ir.targets.Bootstrap;
import org.jruby.ir.targets.SiteTracker;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CodegenUtils;
import org.jruby.util.cli.Options;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;
import org.objectweb.asm.Handle;

public class ConstantLookupSite
extends MutableCallSite {
    private static final Logger LOG = LoggerFactory.getLogger(ConstantLookupSite.class);
    private final String name;
    private final boolean publicOnly;
    private final boolean callConstMissing;
    private volatile RubySymbol symbolicName;
    private final SiteTracker tracker = new SiteTracker();
    public static final Handle BOOTSTRAP = new Handle(6, CodegenUtils.p(ConstantLookupSite.class), "constLookup", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, String.class, Integer.TYPE, Integer.TYPE), false);
    private MethodHandle _SMFC;
    private MethodHandle _noCacheSMFC;
    private MethodHandle _ISC;
    private MethodHandle _noCacheISC;

    public ConstantLookupSite(MethodType type2, String name2, boolean publicOnly, boolean callConstMissing) {
        super(type2);
        this.name = name2;
        this.publicOnly = publicOnly;
        this.callConstMissing = callConstMissing;
    }

    public static CallSite constLookup(MethodHandles.Lookup lookup, String searchType, MethodType type2, String constName, int publicOnly, int callConstMissing) {
        ConstantLookupSite site = new ConstantLookupSite(type2, constName, publicOnly != 0, callConstMissing != 0);
        MethodHandle handle = Binder.from((MethodHandles.Lookup)lookup, (MethodType)type2).insert(0, new Object[]{site}).invokeVirtualQuiet(lookup, searchType);
        site.setTarget(handle);
        return site;
    }

    private RubySymbol getSymbolicName(ThreadContext context) {
        RubySymbol symbolicName = this.symbolicName;
        if (symbolicName != null) {
            return symbolicName;
        }
        this.symbolicName = context.runtime.fastNewSymbol(this.name);
        return this.symbolicName;
    }

    public IRubyObject searchConst(ThreadContext context, StaticScope staticScope) {
        Ruby runtime = context.getRuntime();
        RubyClass object = runtime.getObject();
        IRubyObject constant = staticScope == null ? object.getConstant(this.name) : staticScope.getConstantInner(this.name);
        RubyModule module = null;
        if (constant == null) {
            module = staticScope == null ? object : staticScope.getModule();
            IRubyObject iRubyObject = constant = this.publicOnly ? module.getConstantFromNoConstMissing(this.name, false) : module.getConstantNoConstMissing(this.name);
        }
        if (constant == null) {
            if (this.callConstMissing) {
                return module.callMethod(context, "const_missing", (IRubyObject)this.getSymbolicName(context));
            }
            return UndefinedValue.UNDEFINED;
        }
        SwitchPoint switchPoint = (SwitchPoint)runtime.getConstantInvalidator(this.name).getData();
        MethodHandle target = Binder.from((MethodType)this.type()).drop(0, 2).constant((Object)constant);
        MethodHandle fallback = Binder.from((MethodType)this.type()).insert(0, new Object[]{this}).invokeVirtualQuiet(Bootstrap.LOOKUP, "searchConst");
        this.setTarget(switchPoint.guardWithTest(target, fallback));
        if (((Boolean)Options.INVOKEDYNAMIC_LOG_CONSTANTS.load()).booleanValue()) {
            LOG.info(this.name + "\tretrieved and cached from scope (searchConst) " + staticScope.getIRScope(), new Object[0]);
        }
        return constant;
    }

    public IRubyObject searchModuleForConst(ThreadContext context, IRubyObject cmVal) throws Throwable {
        IRubyObject constant;
        if (!(cmVal instanceof RubyModule)) {
            throw context.runtime.newTypeError(cmVal + " is not a type/class");
        }
        RubyModule module = (RubyModule)cmVal;
        if (this.checkForBailout(module)) {
            return this.bail(context, cmVal, this.noCacheSMFC());
        }
        Ruby runtime = context.getRuntime();
        IRubyObject iRubyObject = constant = this.publicOnly ? module.getConstantFromNoConstMissing(this.name, false) : module.getConstantNoConstMissing(this.name);
        if (constant == null) {
            if (this.callConstMissing) {
                return module.callMethod(context, "const_missing", (IRubyObject)this.getSymbolicName(context));
            }
            return UndefinedValue.UNDEFINED;
        }
        this.bind(runtime, module, constant, this.SMFC());
        if (((Boolean)Options.INVOKEDYNAMIC_LOG_CONSTANTS.load()).booleanValue()) {
            LOG.info(this.name + "\tretrieved and cached from module (searchModuleForConst) " + cmVal.getMetaClass(), new Object[0]);
        }
        return constant;
    }

    public IRubyObject noCacheSearchModuleForConst(ThreadContext context, IRubyObject cmVal) {
        IRubyObject constant;
        if (!(cmVal instanceof RubyModule)) {
            throw context.runtime.newTypeError(cmVal + " is not a type/class");
        }
        RubyModule module = (RubyModule)cmVal;
        IRubyObject iRubyObject = constant = this.publicOnly ? module.getConstantFromNoConstMissing(this.name, false) : module.getConstantNoConstMissing(this.name);
        if (constant == null) {
            return module.callMethod(context, "const_missing", (IRubyObject)this.getSymbolicName(context));
        }
        return constant;
    }

    public IRubyObject inheritanceSearchConst(ThreadContext context, IRubyObject cmVal) throws Throwable {
        Ruby runtime = context.runtime;
        if (!(cmVal instanceof RubyModule)) {
            throw runtime.newTypeError(cmVal + " is not a type/class");
        }
        RubyModule module = (RubyModule)cmVal;
        if (this.checkForBailout(module)) {
            return this.bail(context, cmVal, this.noCacheISC());
        }
        IRubyObject constant = module.getConstantNoConstMissingSKipAutoload(this.name);
        if (constant == null) {
            constant = UndefinedValue.UNDEFINED;
        }
        this.bind(runtime, module, constant, this.ISC());
        this.tracker.addType(module.id);
        if (((Boolean)Options.INVOKEDYNAMIC_LOG_CONSTANTS.load()).booleanValue()) {
            LOG.info(this.name + "\tconstant cached from type (inheritanceSearchConst) " + cmVal.getMetaClass(), new Object[0]);
        }
        return constant;
    }

    public IRubyObject noCacheInheritanceSearchConst(ThreadContext context, IRubyObject cmVal) {
        Ruby runtime = context.runtime;
        if (!(cmVal instanceof RubyModule)) {
            throw runtime.newTypeError(cmVal + " is not a type/class");
        }
        RubyModule module = (RubyModule)cmVal;
        IRubyObject constant = module.getConstantNoConstMissingSKipAutoload(this.name);
        if (constant == null) {
            constant = UndefinedValue.UNDEFINED;
        }
        return constant;
    }

    private MethodHandle getFallback(RubyModule module, MethodHandle cachingFallback) {
        MethodHandle fallback;
        if (this.tracker.seenTypesCount() > 0 && !this.tracker.hasSeenType(module.id)) {
            if (((Boolean)Options.INVOKEDYNAMIC_LOG_CONSTANTS.load()).booleanValue()) {
                LOG.info(this.name + "\tconstant added to PIC", new Object[0]);
            }
            fallback = this.getTarget();
        } else {
            String bound;
            String string2 = bound = this.tracker.seenTypesCount() > 0 ? "rebound" : "bound";
            if (((Boolean)Options.INVOKEDYNAMIC_LOG_CONSTANTS.load()).booleanValue()) {
                LOG.info(this.name + "\tconstant " + bound, new Object[0]);
            }
            fallback = cachingFallback;
            this.tracker.clearTypes();
        }
        return fallback;
    }

    private boolean checkForBailout(RubyModule module) {
        if (this.tracker.clearCount() > (Integer)Options.INVOKEDYNAMIC_MAXFAIL.load()) {
            if (((Boolean)Options.INVOKEDYNAMIC_LOG_CONSTANTS.load()).booleanValue()) {
                LOG.info(this.name + "\tinvalidated more than " + Options.INVOKEDYNAMIC_MAXFAIL.load() + " times ", new Object[0]);
            }
            return true;
        }
        if (!this.tracker.hasSeenType(module.id) && this.tracker.seenTypesCount() + 1 > (Integer)Options.INVOKEDYNAMIC_MAXPOLY.load()) {
            if (((Boolean)Options.INVOKEDYNAMIC_LOG_CONSTANTS.load()).booleanValue()) {
                LOG.info(this.name + "\tencountered more than " + Options.INVOKEDYNAMIC_MAXPOLY.load() + " types ", new Object[0]);
            }
            return true;
        }
        return false;
    }

    private IRubyObject bail(ThreadContext context, IRubyObject cmVal, MethodHandle noncachingFallback) throws Throwable {
        this.setTarget(noncachingFallback);
        return noncachingFallback.invokeExact(context, cmVal);
    }

    private void bind(Ruby runtime, RubyModule module, IRubyObject constant, MethodHandle cachingFallback) {
        MethodHandle target = Binder.from((MethodType)this.type()).drop(0, 2).constant((Object)constant);
        MethodHandle fallback = this.getFallback(module, cachingFallback);
        target = MethodHandles.guardWithTest(module.getIdTest(), target, fallback);
        SwitchPoint switchPoint = (SwitchPoint)runtime.getConstantInvalidator(this.name).getData();
        target = switchPoint.guardWithTest(target, fallback);
        this.setTarget(target);
    }

    public IRubyObject lexicalSearchConst(ThreadContext context, StaticScope scope) {
        Ruby runtime = context.runtime;
        IRubyObject constant = scope.getConstantDefined(this.name);
        if (constant == null) {
            constant = UndefinedValue.UNDEFINED;
        }
        SwitchPoint switchPoint = (SwitchPoint)runtime.getConstantInvalidator(this.name).getData();
        MethodHandle target = Binder.from((MethodType)this.type()).drop(0, 2).constant((Object)constant);
        MethodHandle fallback = Binder.from((MethodType)this.type()).insert(0, new Object[]{this}).invokeVirtualQuiet(Bootstrap.LOOKUP, "lexicalSearchConst");
        this.setTarget(switchPoint.guardWithTest(target, fallback));
        if (((Boolean)Options.INVOKEDYNAMIC_LOG_CONSTANTS.load()).booleanValue()) {
            LOG.info(this.name + "\tretrieved and cached from scope (lexicalSearchConst) " + scope.getIRScope(), new Object[0]);
        }
        return constant;
    }

    private MethodHandle SMFC() {
        if (this._SMFC != null) {
            return this._SMFC;
        }
        this._SMFC = Binder.from((MethodType)this.type()).insert(0, new Object[]{this}).invokeVirtualQuiet(Bootstrap.LOOKUP, "searchModuleForConst");
        return this._SMFC;
    }

    private MethodHandle noCacheSMFC() {
        if (this._noCacheSMFC != null) {
            return this._noCacheSMFC;
        }
        this._noCacheSMFC = Binder.from((MethodType)this.type()).insert(0, new Object[]{this}).invokeVirtualQuiet(Bootstrap.LOOKUP, "noCacheSearchModuleForConst");
        return this._noCacheSMFC;
    }

    private MethodHandle ISC() {
        if (this._ISC != null) {
            return this._ISC;
        }
        this._ISC = Binder.from((MethodType)this.type()).insert(0, new Object[]{this}).invokeVirtualQuiet(Bootstrap.LOOKUP, "inheritanceSearchConst");
        return this._ISC;
    }

    private MethodHandle noCacheISC() {
        if (this._noCacheISC != null) {
            return this._noCacheISC;
        }
        this._noCacheISC = Binder.from((MethodType)this.type()).insert(0, new Object[]{this}).invokeVirtualQuiet(Bootstrap.LOOKUP, "noCacheInheritanceSearchConst");
        return this._noCacheISC;
    }
}

