/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.jruby.compiler.JITCompiler;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.util.ClassDefiningClassLoader;
import org.jruby.util.ClassDefiningJRubyClassLoader;
import org.jruby.util.CodegenUtils;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class HandleFactory {
    public static Handle createHandle(ClassDefiningClassLoader classLoader, Method method) {
        String name2 = HandleFactory.createHandleName(method);
        try {
            Class<?> handleClass = classLoader.loadClass(name2);
            return (Handle)handleClass.newInstance();
        }
        catch (Exception exception2) {
            Class handleClass = HandleFactory.createHandleClass(classLoader, method, name2);
            try {
                return (Handle)handleClass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static Class createHandleClass(ClassDefiningClassLoader classLoader, Method method, String name2) {
        byte[] bytes2 = HandleFactory.createHandleBytes(method, name2);
        return (classLoader != null ? classLoader : new ClassDefiningJRubyClassLoader(ClassDefiningJRubyClassLoader.class.getClassLoader())).defineClass(name2, bytes2);
    }

    public static byte[] createHandleBytes(Method method, String name2) {
        String signature;
        Class<?> returnType = method.getReturnType();
        Class[] paramTypes = method.getParameterTypes();
        ClassWriter cv = new ClassWriter(1);
        cv.visit(49, 49, name2, null, CodegenUtils.p(Handle.class), null);
        boolean needsArgsVersion = true;
        switch (paramTypes.length) {
            case 0: {
                signature = CodegenUtils.sig(Object.class, Object.class);
                break;
            }
            case 1: {
                signature = CodegenUtils.sig(Object.class, Object.class, Object.class);
                break;
            }
            case 2: {
                signature = CodegenUtils.sig(Object.class, Object.class, Object.class, Object.class);
                break;
            }
            case 3: {
                signature = CodegenUtils.sig(Object.class, Object.class, Object.class, Object.class, Object.class);
                break;
            }
            default: {
                needsArgsVersion = false;
                signature = CodegenUtils.sig(Object.class, Object.class, Object[].class);
            }
        }
        SkinnyMethodAdapter m = new SkinnyMethodAdapter((ClassVisitor)cv, 4113, "invoke", signature, null, null);
        m.start();
        if (!Modifier.isStatic(method.getModifiers())) {
            m.aload(1);
            if (method.getDeclaringClass() != Object.class) {
                m.checkcast(CodegenUtils.p(method.getDeclaringClass()));
            }
        }
        switch (paramTypes.length) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                int i2;
                for (i2 = 0; i2 < paramTypes.length; ++i2) {
                    HandleFactory.loadUnboxedArgument(m, i2 + 2, paramTypes[i2]);
                }
                break;
            }
            default: {
                int i2;
                for (i2 = 0; i2 < paramTypes.length; ++i2) {
                    m.aload(2);
                    m.pushInt(i2);
                    m.aaload();
                    Class<?> paramClass = paramTypes[i2];
                    if (paramClass.isPrimitive()) {
                        Class boxType = CodegenUtils.getBoxType(paramClass);
                        m.checkcast(CodegenUtils.p(boxType));
                        m.invokevirtual(CodegenUtils.p(boxType), paramClass.toString() + "Value", CodegenUtils.sig(paramClass, new Class[0]));
                        continue;
                    }
                    if (paramClass == Object.class) continue;
                    m.checkcast(CodegenUtils.p(paramClass));
                }
            }
        }
        if (Modifier.isStatic(method.getModifiers())) {
            m.invokestatic(CodegenUtils.p(method.getDeclaringClass()), method.getName(), CodegenUtils.sig(returnType, paramTypes));
        } else if (Modifier.isInterface(method.getDeclaringClass().getModifiers())) {
            m.invokeinterface(CodegenUtils.p(method.getDeclaringClass()), method.getName(), CodegenUtils.sig(returnType, paramTypes));
        } else {
            m.invokevirtual(CodegenUtils.p(method.getDeclaringClass()), method.getName(), CodegenUtils.sig(returnType, paramTypes));
        }
        if (returnType == Void.TYPE) {
            m.aconst_null();
        } else if (returnType.isPrimitive()) {
            Class boxType = CodegenUtils.getBoxType(returnType);
            m.invokestatic(CodegenUtils.p(boxType), "valueOf", CodegenUtils.sig(boxType, returnType));
        }
        m.areturn();
        m.end();
        if (needsArgsVersion) {
            m = new SkinnyMethodAdapter((ClassVisitor)cv, 4113, "invoke", CodegenUtils.sig(Object.class, Object.class, Object[].class), null, null);
            m.start();
            m.aload(0);
            m.aload(1);
            for (int i3 = 0; i3 < paramTypes.length; ++i3) {
                m.aload(2);
                m.ldc(i3);
                m.aaload();
            }
            m.invokevirtual(name2, "invoke", CodegenUtils.sig(Object.class, CodegenUtils.params(Object.class, Object.class, paramTypes.length)));
            m.areturn();
            m.end();
        }
        m = new SkinnyMethodAdapter((ClassVisitor)cv, 1, "<init>", CodegenUtils.sig(Void.TYPE, new Class[0]), null, null);
        m.start();
        m.aload(0);
        m.invokespecial(CodegenUtils.p(Handle.class), "<init>", CodegenUtils.sig(Void.TYPE, new Class[0]));
        m.voidreturn();
        m.end();
        cv.visitEnd();
        byte[] bytes2 = cv.toByteArray();
        return bytes2;
    }

    private static String createHandleName(Method method) {
        Class<?> returnType = method.getReturnType();
        Class[] paramTypes = method.getParameterTypes();
        return method.getDeclaringClass().getCanonicalName().replaceAll("\\.", "__") + '#' + method.getName() + '#' + JITCompiler.getHashForString(CodegenUtils.pretty(returnType, paramTypes));
    }

    public static void loadUnboxedArgument(SkinnyMethodAdapter m, int index2, Class type2) {
        m.aload(index2);
        HandleFactory.unboxAndCast(m, type2);
    }

    public static void unboxAndCast(SkinnyMethodAdapter m, Class paramClass) {
        if (paramClass.isPrimitive()) {
            Class boxType = CodegenUtils.getBoxType(paramClass);
            m.checkcast(CodegenUtils.p(boxType));
            m.invokevirtual(CodegenUtils.p(boxType), paramClass.toString() + "Value", CodegenUtils.sig(paramClass, new Class[0]));
        } else if (paramClass != Object.class) {
            m.checkcast(CodegenUtils.p(paramClass));
        }
    }

    public static void main(String[] args2) {
        try {
            Method method = HandleFactory.class.getMethod("dummy", String.class);
            Handle handle = HandleFactory.createHandle(null, method);
            String prop1 = "java.class.path";
            String prop2 = "";
            for (int i2 = 0; i2 < 10; ++i2) {
                String tmp;
                Object result2;
                int j;
                System.out.print("reflected invocation: ");
                long time = System.currentTimeMillis();
                for (j = 0; j < 50000000; ++j) {
                    result2 = method.invoke(null, prop1);
                    method.invoke(null, prop2);
                    tmp = prop1;
                    prop1 = prop2;
                    prop2 = tmp;
                    if (j % 10000000 != 0) continue;
                    System.out.println(prop2);
                }
                System.out.println(System.currentTimeMillis() - time);
                System.out.print("method invocation: ");
                time = System.currentTimeMillis();
                for (j = 0; j < 50000000; ++j) {
                    result2 = HandleFactory.dummy(prop1);
                    HandleFactory.dummy(prop2);
                    tmp = prop1;
                    prop1 = prop2;
                    prop2 = tmp;
                    if (j % 10000000 != 0) continue;
                    System.out.println(prop2);
                }
                System.out.println(System.currentTimeMillis() - time);
                System.out.print("handle invocation: ");
                time = System.currentTimeMillis();
                for (j = 0; j < 50000000; ++j) {
                    result2 = handle.invoke((Object)null, (Object)prop1);
                    handle.invoke((Object)null, (Object)prop2);
                    tmp = prop1;
                    prop1 = prop2;
                    prop2 = tmp;
                    if (j % 10000000 != 0) continue;
                    System.out.println(prop2);
                }
                System.out.println(System.currentTimeMillis() - time);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static String dummy(String str) {
        if (str.length() == 0) {
            return null;
        }
        return str;
    }

    public static int dummy2() {
        return 1;
    }

    public static Object dummy3(Object obj) {
        return obj;
    }

    public static class Tool {
        public static void main(String[] args2) {
            if (args2.length != 2) {
                System.err.println("Usage:\n  tool <java class> <target dir>");
                System.exit(1);
            }
            String classname = args2[0];
            String target = args2[1];
            FakeLoader loader = new FakeLoader(Tool.class.getClassLoader());
            try {
                Class<?> klass = loader.loadClass(classname, false);
                for (Method method : klass.getMethods()) {
                    String name2 = HandleFactory.createHandleName(method);
                    byte[] bytes2 = HandleFactory.createHandleBytes(method, name2);
                    FileOutputStream fos = null;
                    try {
                        fos = new FileOutputStream(new File(target, name2 + ".class"));
                        fos.write(bytes2);
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException(ioe);
                    }
                    finally {
                        try {
                            fos.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException(cnfe);
            }
        }
    }

    private static class FakeLoader
    extends ClassLoader {
        public FakeLoader(ClassLoader parent) {
            super(parent);
        }

        @Override
        public Class<?> loadClass(String name2, boolean resolve) throws ClassNotFoundException {
            return super.loadClass(name2, resolve);
        }
    }

    public static class Handle {
        private Error fail() {
            return new AbstractMethodError("invalid call signature for target method: " + this.getClass());
        }

        public Object invoke(Object receiver2) {
            throw this.fail();
        }

        public Object invoke(Object receiver2, Object arg0) {
            throw this.fail();
        }

        public Object invoke(Object receiver2, Object arg0, Object arg1) {
            throw this.fail();
        }

        public Object invoke(Object receiver2, Object arg0, Object arg1, Object arg2) {
            throw this.fail();
        }

        public Object invoke(Object receiver2, Object ... args2) {
            throw this.fail();
        }
    }
}

