/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Locale;
import jnr.posix.POSIX;
import org.jcodings.Encoding;
import org.jcodings.exception.EncodingException;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.specific.UTF16BEEncoding;
import org.jcodings.specific.UTF16LEEncoding;
import org.jcodings.specific.UTF32BEEncoding;
import org.jcodings.specific.UTF32LEEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jcodings.unicode.UnicodeEncoding;
import org.joni.Matcher;
import org.joni.Regex;
import org.joni.Region;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComparable;
import org.jruby.RubyComplex;
import org.jruby.RubyEncoding;
import org.jruby.RubyEnumerable;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyMatchData;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyRange;
import org.jruby.RubyRational;
import org.jruby.RubyRegexp;
import org.jruby.RubySymbol;
import org.jruby.anno.FrameField;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.platform.Platform;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.encoding.EncodingCapable;
import org.jruby.runtime.encoding.MarshalEncoding;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.ByteList;
import org.jruby.util.CodeRangeSupport;
import org.jruby.util.CodeRangeable;
import org.jruby.util.ConvertBytes;
import org.jruby.util.Numeric;
import org.jruby.util.Pack;
import org.jruby.util.PerlHash;
import org.jruby.util.RegexpOptions;
import org.jruby.util.SipHashInline;
import org.jruby.util.Sprintf;
import org.jruby.util.StringSupport;
import org.jruby.util.TypeConverter;
import org.jruby.util.io.EncodingUtils;

@JRubyClass(name={"String"}, include={"Enumerable", "Comparable"})
public class RubyString
extends RubyObject
implements EncodingCapable,
MarshalEncoding,
CodeRangeable {
    public static final String DEBUG_INFO_FIELD = "@debug_created_info";
    private static final ASCIIEncoding ASCII = ASCIIEncoding.INSTANCE;
    private static final UTF8Encoding UTF8 = UTF8Encoding.INSTANCE;
    private static final int SHARE_LEVEL_NONE = 0;
    private static final int SHARE_LEVEL_BUFFER = 1;
    private static final int SHARE_LEVEL_BYTELIST = 2;
    private static final byte[] SCRUB_REPL_UTF8 = new byte[]{-17, -65, -67};
    private static final byte[] SCRUB_REPL_ASCII = new byte[]{63};
    private static final byte[] SCRUB_REPL_UTF16BE = new byte[]{-1, -3};
    private static final byte[] SCRUB_REPL_UTF16LE = new byte[]{-3, -1};
    private static final byte[] SCRUB_REPL_UTF32BE = new byte[]{0, 0, -1, -3};
    private static final byte[] SCRUB_REPL_UTF32LE = new byte[]{-3, -1, 0, 0};
    private volatile int shareLevel = 0;
    private ByteList value;
    private static final String[][] opTable19 = new String[][]{{"+", "+(binary)"}, {"-", "-(binary)"}};
    private static ObjectAllocator STRING_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return RubyString.newAllocatedString(runtime, klass);
        }
    };
    private static final ByteList EMPTY_ASCII8BIT_BYTELIST = new ByteList(ByteList.NULL_ARRAY, (Encoding)ASCIIEncoding.INSTANCE);
    private static final ByteList EMPTY_USASCII_BYTELIST = new ByteList(ByteList.NULL_ARRAY, (Encoding)USASCIIEncoding.INSTANCE);
    private static EmptyByteListHolder[] EMPTY_BYTELISTS = new EmptyByteListHolder[4];
    private static final ByteList SPACE_BYTELIST = new ByteList(new byte[]{32}, false);

    public static RubyClass createStringClass(Ruby runtime) {
        RubyClass stringClass = runtime.defineClass("String", runtime.getObject(), STRING_ALLOCATOR);
        runtime.setString(stringClass);
        stringClass.setClassIndex(ClassIndex.STRING);
        stringClass.setReifiedClass(RubyString.class);
        stringClass.kindOf = new RubyModule.JavaClassKindOf(RubyString.class);
        stringClass.includeModule(runtime.getComparable());
        stringClass.defineAnnotatedMethods(RubyString.class);
        return stringClass;
    }

    @Override
    public Encoding getEncoding() {
        return this.value.getEncoding();
    }

    @Override
    public void setEncoding(Encoding encoding2) {
        this.value.setEncoding(encoding2);
    }

    @Override
    public boolean shouldMarshalEncoding() {
        return this.getEncoding() != ASCIIEncoding.INSTANCE;
    }

    @Override
    public Encoding getMarshalEncoding() {
        return this.getEncoding();
    }

    public void associateEncoding(Encoding enc) {
        StringSupport.associateEncoding(this, enc);
    }

    public final void setEncodingAndCodeRange(Encoding enc, int cr) {
        this.value.setEncoding(enc);
        this.setCodeRange(cr);
    }

    public final Encoding toEncoding(Ruby runtime) {
        return runtime.getEncodingService().findEncoding(this);
    }

    @Override
    public final int getCodeRange() {
        return this.flags & 0x30;
    }

    @Override
    public final void setCodeRange(int codeRange) {
        this.clearCodeRange();
        this.flags |= codeRange & 0x30;
    }

    @Override
    public final void clearCodeRange() {
        this.flags &= 0xFFFFFFCF;
    }

    @Override
    public final void keepCodeRange() {
        if (this.getCodeRange() == 48) {
            this.clearCodeRange();
        }
    }

    public final boolean isCodeRangeAsciiOnly() {
        return CodeRangeSupport.isCodeRangeAsciiOnly(this);
    }

    public final boolean isAsciiOnly() {
        return StringSupport.isAsciiOnly(this);
    }

    @Override
    public final boolean isCodeRangeValid() {
        return (this.flags & 0x30) == 32;
    }

    public final boolean isCodeRangeBroken() {
        return (this.flags & 0x30) == 48;
    }

    public final boolean isBrokenString() {
        return this.scanForCodeRange() == 48;
    }

    private void copyCodeRangeForSubstr(RubyString from, Encoding enc) {
        if (this.value.getRealSize() == 0) {
            this.setCodeRange(!enc.isAsciiCompatible() ? 32 : 16);
        } else {
            int fromCr = from.getCodeRange();
            if (fromCr == 16) {
                this.setCodeRange(fromCr);
            } else {
                this.setCodeRange(0);
            }
        }
    }

    @Override
    public final int scanForCodeRange() {
        int cr = this.getCodeRange();
        if (cr == 0) {
            Encoding enc = this.getEncoding();
            cr = enc.minLength() > 1 && enc.isDummy() ? 48 : StringSupport.codeRangeScan(EncodingUtils.getActualEncoding(this.getEncoding(), this.value), this.value);
            this.setCodeRange(cr);
        }
        return cr;
    }

    final boolean singleByteOptimizable() {
        return StringSupport.isSingleByteOptimizable(this, EncodingUtils.STR_ENC_GET(this));
    }

    final boolean singleByteOptimizable(Encoding enc) {
        return StringSupport.isSingleByteOptimizable(this, enc);
    }

    final Encoding isCompatibleWith(EncodingCapable other) {
        Encoding enc2;
        if (other instanceof RubyString) {
            return this.checkEncoding((RubyString)other);
        }
        Encoding enc1 = this.value.getEncoding();
        if (enc1 == (enc2 = other.getEncoding())) {
            return enc1;
        }
        if (this.value.getRealSize() == 0) {
            return enc2;
        }
        if (!enc1.isAsciiCompatible() || !enc2.isAsciiCompatible()) {
            return null;
        }
        if (enc2 instanceof USASCIIEncoding) {
            return enc1;
        }
        if (this.scanForCodeRange() == 16) {
            return enc2;
        }
        return null;
    }

    public final Encoding checkEncoding(RubyString other) {
        return this.checkEncoding((CodeRangeable)other);
    }

    final Encoding checkEncoding(EncodingCapable other) {
        Encoding enc = this.isCompatibleWith(other);
        if (enc == null) {
            throw this.getRuntime().newEncodingCompatibilityError("incompatible character encodings: " + this.value.getEncoding() + " and " + other.getEncoding());
        }
        return enc;
    }

    @Override
    public final Encoding checkEncoding(CodeRangeable other) {
        Encoding enc = StringSupport.areCompatible(this, other);
        if (enc == null) {
            throw this.getRuntime().newEncodingCompatibilityError("incompatible character encodings: " + this.value.getEncoding() + " and " + other.getByteList().getEncoding());
        }
        return enc;
    }

    private Encoding checkDummyEncoding() {
        Encoding enc = this.value.getEncoding();
        if (enc.isDummy()) {
            throw this.getRuntime().newEncodingCompatibilityError("incompatible encoding with this operation: " + enc);
        }
        return enc;
    }

    public final int strLength() {
        return StringSupport.strLengthFromRubyString(this);
    }

    final int subLength(int pos2) {
        if (pos2 < 0 || this.singleByteOptimizable()) {
            return pos2;
        }
        return StringSupport.strLength(this.value.getEncoding(), this.value.getUnsafeBytes(), this.value.getBegin(), this.value.getBegin() + pos2);
    }

    @Override
    public final boolean eql(IRubyObject other) {
        Ruby runtime;
        RubyClass metaclass = this.getMetaClass();
        if (metaclass != (runtime = metaclass.getClassRuntime()).getString() || metaclass != other.getMetaClass()) {
            return super.eql(other);
        }
        return this.eql19(other);
    }

    private boolean eql19(IRubyObject other) {
        RubyString otherString = (RubyString)other;
        return StringSupport.areComparable(this, otherString) && this.value.equal(otherString.value);
    }

    public RubyString(Ruby runtime, RubyClass rubyClass) {
        this(runtime, rubyClass, ByteList.NULL_ARRAY);
    }

    public RubyString(Ruby runtime, RubyClass rubyClass, CharSequence value2) {
        this(runtime, rubyClass, value2, null);
    }

    public RubyString(Ruby runtime, RubyClass rubyClass, CharSequence value2, Encoding enc) {
        super(runtime, rubyClass);
        assert (value2 != null);
        if (enc == null) {
            enc = UTF8;
        }
        this.value = RubyString.encodeBytelist(value2, enc);
    }

    public RubyString(Ruby runtime, RubyClass rubyClass, byte[] value2) {
        super(runtime, rubyClass);
        assert (value2 != null);
        this.value = new ByteList(value2);
    }

    public RubyString(Ruby runtime, RubyClass rubyClass, ByteList value2) {
        super(runtime, rubyClass);
        assert (value2 != null);
        this.value = value2;
    }

    public RubyString(Ruby runtime, RubyClass rubyClass, ByteList value2, boolean objectSpace) {
        super(runtime, rubyClass, objectSpace);
        assert (value2 != null);
        this.value = value2;
    }

    public RubyString(Ruby runtime, RubyClass rubyClass, ByteList value2, Encoding encoding2, boolean objectSpace) {
        this(runtime, rubyClass, value2, objectSpace);
        value2.setEncoding(encoding2);
    }

    protected RubyString(Ruby runtime, RubyClass rubyClass, ByteList value2, Encoding enc, int cr) {
        this(runtime, rubyClass, value2);
        value2.setEncoding(enc);
        this.flags |= cr;
    }

    protected RubyString(Ruby runtime, RubyClass rubyClass, ByteList value2, Encoding enc) {
        this(runtime, rubyClass, value2);
        value2.setEncoding(enc);
    }

    protected RubyString(Ruby runtime, RubyClass rubyClass, ByteList value2, int cr) {
        this(runtime, rubyClass, value2);
        this.flags |= cr;
    }

    @Deprecated
    public RubyString newString(CharSequence s2) {
        return new RubyString(this.getRuntime(), this.getType(), s2);
    }

    @Deprecated
    public RubyString newString(ByteList s2) {
        return new RubyString(this.getRuntime(), this.getMetaClass(), s2);
    }

    @Deprecated
    public static RubyString newString(Ruby runtime, RubyClass clazz, CharSequence str) {
        return new RubyString(runtime, clazz, str);
    }

    public static RubyString newStringLight(Ruby runtime, ByteList bytes2) {
        return new RubyString(runtime, runtime.getString(), bytes2, false);
    }

    public static RubyString newStringLight(Ruby runtime, int size2) {
        return new RubyString(runtime, runtime.getString(), new ByteList(size2), false);
    }

    public static RubyString newStringLight(Ruby runtime, int size2, Encoding encoding2) {
        return new RubyString(runtime, runtime.getString(), new ByteList(size2), encoding2, false);
    }

    public static RubyString newString(Ruby runtime, CharSequence str) {
        return new RubyString(runtime, runtime.getString(), str);
    }

    public static RubyString newString(Ruby runtime, String str) {
        return new RubyString(runtime, runtime.getString(), str);
    }

    public static RubyString newString(Ruby runtime, String str, Encoding encoding2) {
        return new RubyString(runtime, runtime.getString(), str, encoding2);
    }

    public static RubyString newUSASCIIString(Ruby runtime, String str) {
        return new RubyString(runtime, runtime.getString(), str, (Encoding)USASCIIEncoding.INSTANCE);
    }

    public static RubyString newString(Ruby runtime, byte[] bytes2) {
        return new RubyString(runtime, runtime.getString(), bytes2);
    }

    public static RubyString newString(Ruby runtime, byte[] bytes2, int start2, int length2) {
        return RubyString.newString(runtime, bytes2, start2, length2, (Encoding)ASCIIEncoding.INSTANCE);
    }

    public static RubyString newString(Ruby runtime, byte[] bytes2, int start2, int length2, Encoding encoding2) {
        byte[] copy = new byte[length2];
        System.arraycopy(bytes2, start2, copy, 0, length2);
        return new RubyString(runtime, runtime.getString(), new ByteList(copy, encoding2, false));
    }

    public static RubyString newString(Ruby runtime, ByteList bytes2) {
        return new RubyString(runtime, runtime.getString(), bytes2);
    }

    public static RubyString newString(Ruby runtime, ByteList bytes2, int coderange) {
        return new RubyString(runtime, runtime.getString(), bytes2, coderange);
    }

    public static RubyString newString(Ruby runtime, ByteList bytes2, Encoding encoding2) {
        return new RubyString(runtime, runtime.getString(), bytes2, encoding2);
    }

    public static RubyString newUnicodeString(Ruby runtime, String str) {
        Encoding defaultInternal = runtime.getDefaultInternalEncoding();
        if (defaultInternal == UTF16BEEncoding.INSTANCE) {
            return RubyString.newUTF16String(runtime, str);
        }
        return RubyString.newUTF8String(runtime, str);
    }

    public static RubyString newUTF8String(Ruby runtime, String str) {
        ByteList byteList = new ByteList(RubyEncoding.encodeUTF8(str), (Encoding)UTF8Encoding.INSTANCE, false);
        return new RubyString(runtime, runtime.getString(), byteList);
    }

    public static RubyString newUTF16String(Ruby runtime, String str) {
        ByteList byteList = new ByteList(RubyEncoding.encodeUTF16(str), (Encoding)UTF16BEEncoding.INSTANCE, false);
        return new RubyString(runtime, runtime.getString(), byteList);
    }

    public static RubyString newUnicodeString(Ruby runtime, CharSequence str) {
        Encoding defaultInternal = runtime.getDefaultInternalEncoding();
        if (defaultInternal == UTF16BEEncoding.INSTANCE) {
            return RubyString.newUTF16String(runtime, str);
        }
        return RubyString.newUTF8String(runtime, str);
    }

    public static RubyString newUTF8String(Ruby runtime, CharSequence str) {
        ByteList byteList = new ByteList(RubyEncoding.encodeUTF8(str), (Encoding)UTF8Encoding.INSTANCE, false);
        return new RubyString(runtime, runtime.getString(), byteList);
    }

    public static RubyString newUTF16String(Ruby runtime, CharSequence str) {
        ByteList byteList = new ByteList(RubyEncoding.encodeUTF16(str), (Encoding)UTF16BEEncoding.INSTANCE, false);
        return new RubyString(runtime, runtime.getString(), byteList);
    }

    public static RubyString newInternalFromJavaExternal(Ruby runtime, String str) {
        Encoding internal = runtime.getDefaultInternalEncoding();
        Charset rubyInt = null;
        if (internal != null) {
            rubyInt = EncodingUtils.charsetForEncoding(internal);
        }
        if (rubyInt == null) {
            Encoding javaExtEncoding = runtime.getEncodingService().getJavaDefault();
            return RubyString.newString(runtime, new ByteList(str.getBytes(), javaExtEncoding));
        }
        return RubyString.newString(runtime, new ByteList(RubyEncoding.encode(str, rubyInt), internal));
    }

    public static RubyString newStringShared(Ruby runtime, RubyString orig) {
        orig.shareLevel = 2;
        RubyString str = new RubyString(runtime, runtime.getString(), orig.value);
        str.shareLevel = 2;
        return str;
    }

    public static RubyString newStringShared(Ruby runtime, ByteList bytes2) {
        return RubyString.newStringShared(runtime, runtime.getString(), bytes2);
    }

    public static RubyString newStringShared(Ruby runtime, ByteList bytes2, Encoding encoding2) {
        return RubyString.newStringShared(runtime, runtime.getString(), bytes2, encoding2);
    }

    public static RubyString newStringShared(Ruby runtime, ByteList bytes2, int codeRange) {
        RubyString str = new RubyString(runtime, runtime.getString(), bytes2, codeRange);
        str.shareLevel = 2;
        return str;
    }

    public static RubyString newStringShared(Ruby runtime, RubyClass clazz, ByteList bytes2) {
        RubyString str = new RubyString(runtime, clazz, bytes2);
        str.shareLevel = 2;
        return str;
    }

    public static RubyString newStringShared(Ruby runtime, RubyClass clazz, ByteList bytes2, Encoding encoding2) {
        RubyString str = new RubyString(runtime, clazz, bytes2, encoding2);
        str.shareLevel = 2;
        return str;
    }

    public static RubyString newStringShared(Ruby runtime, byte[] bytes2) {
        return RubyString.newStringShared(runtime, new ByteList(bytes2, false));
    }

    public static RubyString newStringShared(Ruby runtime, byte[] bytes2, Encoding encoding2) {
        return RubyString.newStringShared(runtime, new ByteList(bytes2, encoding2, false));
    }

    public static RubyString newStringShared(Ruby runtime, byte[] bytes2, int start2, int length2) {
        return RubyString.newStringShared(runtime, new ByteList(bytes2, start2, length2, false));
    }

    public static RubyString newStringShared(Ruby runtime, byte[] bytes2, int start2, int length2, Encoding encoding2) {
        return RubyString.newStringShared(runtime, new ByteList(bytes2, start2, length2, encoding2, false));
    }

    public static RubyString newEmptyString(Ruby runtime) {
        return RubyString.newEmptyString(runtime, runtime.getString());
    }

    public static RubyString newAllocatedString(Ruby runtime, RubyClass metaClass) {
        RubyString empty = new RubyString(runtime, metaClass, EMPTY_ASCII8BIT_BYTELIST);
        empty.shareLevel = 2;
        return empty;
    }

    public static RubyString newEmptyString(Ruby runtime, RubyClass metaClass) {
        RubyString empty = new RubyString(runtime, metaClass, EMPTY_USASCII_BYTELIST);
        empty.shareLevel = 2;
        return empty;
    }

    public static RubyString newStringNoCopy(Ruby runtime, ByteList bytes2) {
        return RubyString.newStringNoCopy(runtime, runtime.getString(), bytes2);
    }

    public static RubyString newStringNoCopy(Ruby runtime, RubyClass clazz, ByteList bytes2) {
        return new RubyString(runtime, clazz, bytes2);
    }

    public static RubyString newStringNoCopy(Ruby runtime, byte[] bytes2, int start2, int length2) {
        return RubyString.newStringNoCopy(runtime, new ByteList(bytes2, start2, length2, false));
    }

    public static RubyString newStringNoCopy(Ruby runtime, byte[] bytes2) {
        return RubyString.newStringNoCopy(runtime, new ByteList(bytes2, false));
    }

    public final boolean independent() {
        return this.shareLevel == 0;
    }

    public final RubyString makeIndependent() {
        RubyClass klass = this.metaClass;
        RubyString str = this.strDup(klass.getClassRuntime(), klass);
        str.modify();
        str.setFrozen(true);
        str.infectBy(this);
        return str;
    }

    public final RubyString makeIndependent(int length2) {
        RubyClass klass = this.metaClass;
        RubyString str = this.strDup(klass.getClassRuntime(), klass);
        str.modify(length2);
        str.setFrozen(true);
        str.infectBy(this);
        return str;
    }

    public RubyString export(ThreadContext context) {
        if (Platform.IS_WINDOWS) {
            return EncodingUtils.strConvEncOpts(context, this, null, (Encoding)UTF8Encoding.INSTANCE, 0, context.nil);
        }
        return this;
    }

    static EmptyByteListHolder getEmptyByteList(Encoding enc) {
        EmptyByteListHolder bytes2;
        int index2;
        if (enc == null) {
            enc = ASCIIEncoding.INSTANCE;
        }
        if ((index2 = enc.getIndex()) < EMPTY_BYTELISTS.length && (bytes2 = EMPTY_BYTELISTS[index2]) != null) {
            return bytes2;
        }
        return RubyString.prepareEmptyByteList(enc);
    }

    private static EmptyByteListHolder prepareEmptyByteList(Encoding enc) {
        int index2;
        if (enc == null) {
            enc = ASCIIEncoding.INSTANCE;
        }
        if ((index2 = enc.getIndex()) >= EMPTY_BYTELISTS.length) {
            EmptyByteListHolder[] tmp = new EmptyByteListHolder[index2 + 4];
            System.arraycopy(EMPTY_BYTELISTS, 0, tmp, 0, EMPTY_BYTELISTS.length);
            EMPTY_BYTELISTS = tmp;
        }
        RubyString.EMPTY_BYTELISTS[index2] = new EmptyByteListHolder(enc);
        return RubyString.EMPTY_BYTELISTS[index2];
    }

    public static RubyString newEmptyString(Ruby runtime, RubyClass metaClass, Encoding enc) {
        EmptyByteListHolder holder = RubyString.getEmptyByteList(enc);
        RubyString empty = new RubyString(runtime, metaClass, holder.bytes, holder.cr);
        empty.shareLevel = 2;
        return empty;
    }

    public static RubyString newEmptyString(Ruby runtime, Encoding enc) {
        return RubyString.newEmptyString(runtime, runtime.getString(), enc);
    }

    public static RubyString newStringNoCopy(Ruby runtime, RubyClass clazz, ByteList bytes2, Encoding enc, int cr) {
        return new RubyString(runtime, clazz, bytes2, enc, cr);
    }

    public static RubyString newStringNoCopy(Ruby runtime, ByteList bytes2, Encoding enc, int cr) {
        return RubyString.newStringNoCopy(runtime, runtime.getString(), bytes2, enc, cr);
    }

    public static RubyString newUsAsciiStringNoCopy(Ruby runtime, ByteList bytes2) {
        return RubyString.newStringNoCopy(runtime, bytes2, (Encoding)USASCIIEncoding.INSTANCE, 16);
    }

    public static RubyString newUsAsciiStringShared(Ruby runtime, ByteList bytes2) {
        RubyString str = RubyString.newUsAsciiStringNoCopy(runtime, bytes2);
        str.shareLevel = 2;
        return str;
    }

    public static RubyString newUsAsciiStringShared(Ruby runtime, byte[] bytes2, int start2, int length2) {
        byte[] copy = new byte[length2];
        System.arraycopy(bytes2, start2, copy, 0, length2);
        return RubyString.newUsAsciiStringShared(runtime, new ByteList(copy, false));
    }

    @Override
    public ClassIndex getNativeClassIndex() {
        return ClassIndex.STRING;
    }

    @Override
    public Class getJavaClass() {
        return String.class;
    }

    @Override
    public RubyString convertToString() {
        return this;
    }

    @Override
    public String toString() {
        return this.decodeString();
    }

    public String decodeString() {
        return Helpers.decodeByteList(this.getRuntime(), this.value);
    }

    @Override
    public IRubyObject dup() {
        RubyClass mc = this.metaClass.getRealClass();
        if (mc.getClassIndex() != ClassIndex.STRING) {
            return super.dup();
        }
        return this.strDup(mc.getClassRuntime(), mc.getRealClass());
    }

    public IRubyObject dupFrozen() {
        RubyString dup2 = (RubyString)this.dup();
        dup2.setFrozen(true);
        return dup2;
    }

    public final RubyString strDup(Ruby runtime) {
        return this.strDup(runtime, this.getMetaClass().getRealClass());
    }

    final RubyString strDup(Ruby runtime, RubyClass clazz) {
        this.shareLevel = 2;
        RubyString dup2 = new RubyString(runtime, clazz, this.value);
        dup2.shareLevel = 2;
        dup2.flags |= this.flags & (0x30 | TAINTED_F);
        return dup2;
    }

    public final RubyString makeSharedString(Ruby runtime, int index2, int len) {
        return this.makeShared19(runtime, runtime.getString(), index2, len);
    }

    public RubyString makeSharedString19(Ruby runtime, int index2, int len) {
        return this.makeShared19(runtime, runtime.getString(), this.value, index2, len);
    }

    public final RubyString makeShared(Ruby runtime, int index2, int len) {
        return this.makeShared19(runtime, this.getType(), index2, len);
    }

    public final RubyString makeShared(Ruby runtime, RubyClass meta, int index2, int len) {
        RubyString shared;
        if (len == 0) {
            shared = RubyString.newEmptyString(runtime, meta);
        } else if (len == 1) {
            shared = RubyString.newStringShared(runtime, meta, RubyInteger.SINGLE_CHAR_BYTELISTS[this.value.getUnsafeBytes()[this.value.getBegin() + index2] & 0xFF]);
        } else {
            if (this.shareLevel == 0) {
                this.shareLevel = 1;
            }
            shared = new RubyString(runtime, meta, this.value.makeShared(index2, len));
            shared.shareLevel = 1;
        }
        shared.infectBy(this);
        return shared;
    }

    public final RubyString makeShared19(Ruby runtime, int index2, int len) {
        return this.makeShared19(runtime, this.value, index2, len);
    }

    public final RubyString makeShared19(Ruby runtime, RubyClass meta, int index2, int len) {
        return this.makeShared19(runtime, meta, this.value, index2, len);
    }

    private RubyString makeShared19(Ruby runtime, ByteList value2, int index2, int len) {
        return this.makeShared19(runtime, this.getType(), value2, index2, len);
    }

    private RubyString makeShared19(Ruby runtime, RubyClass meta, ByteList value2, int index2, int len) {
        RubyString shared;
        Encoding enc = value2.getEncoding();
        if (len == 0) {
            shared = RubyString.newEmptyString(runtime, meta, enc);
        } else if (len == 1) {
            ByteList bytes2 = new ByteList(new byte[]{(byte)value2.get(index2)}, enc);
            shared = new RubyString(runtime, meta, bytes2, enc);
        } else {
            if (this.shareLevel == 0) {
                this.shareLevel = 1;
            }
            shared = new RubyString(runtime, meta, value2.makeShared(index2, len));
            shared.shareLevel = 1;
        }
        shared.copyCodeRangeForSubstr(this, enc);
        shared.infectBy(this);
        return shared;
    }

    public final void setByteListShared() {
        if (this.shareLevel != 2) {
            this.shareLevel = 2;
        }
    }

    public final void modifyCheck() {
        this.frozenCheck();
    }

    public void modifyCheck(byte[] b2, int len) {
        if (this.value.getUnsafeBytes() != b2 || this.value.getRealSize() != len) {
            throw this.getRuntime().newRuntimeError("string modified");
        }
    }

    private void modifyCheck(byte[] b2, int len, Encoding enc) {
        if (this.value.getUnsafeBytes() != b2 || this.value.getRealSize() != len || this.value.getEncoding() != enc) {
            throw this.getRuntime().newRuntimeError("string modified");
        }
    }

    private void frozenCheck() {
        this.frozenCheck(false);
    }

    private void frozenCheck(boolean runtimeError) {
        if (this.isFrozen()) {
            RubyArray info;
            IRubyObject obj;
            if (this.getRuntime().getInstanceConfig().isDebuggingFrozenStringLiteral() && (obj = this.getInstanceVariable(DEBUG_INFO_FIELD)) != null && obj instanceof RubyArray && (info = (RubyArray)obj).getLength() == 2) {
                throw this.getRuntime().newRaiseException(this.getRuntime().getRuntimeError(), "can't modify frozen String, created at " + info.eltInternal(0) + ":" + info.eltInternal(1));
            }
            throw this.getRuntime().newFrozenError("String", runtimeError);
        }
    }

    @Override
    public final void modify() {
        this.modifyCheck();
        if (this.shareLevel != 0) {
            if (this.shareLevel == 2) {
                this.value = this.value.dup();
            } else {
                this.value.unshare();
            }
            this.shareLevel = 0;
        }
        this.value.invalidate();
    }

    public final void modify19() {
        this.modify();
        this.clearCodeRange();
    }

    @Override
    public void modifyAndKeepCodeRange() {
        this.modify();
        this.keepCodeRange();
    }

    @Override
    public final void modify(int length2) {
        this.modifyCheck();
        if (this.shareLevel != 0) {
            if (this.shareLevel == 2) {
                this.value = this.value.dup(length2);
            } else {
                this.value.unshare(length2);
            }
            this.shareLevel = 0;
        } else {
            this.value.ensure(length2);
        }
        this.value.invalidate();
    }

    public final void modifyExpand(int length2) {
        this.modify(length2);
        this.clearCodeRange();
    }

    public void setReadLength(int length2) {
        if (this.size() != length2) {
            this.modify();
            this.value.setRealSize(length2);
        }
    }

    public RubyString newFrozen() {
        if (this.isFrozen()) {
            return this;
        }
        RubyClass klass = this.getMetaClass();
        RubyString str = this.strDup(klass.getClassRuntime());
        str.setCodeRange(this.getCodeRange());
        str.setFrozen(true);
        return str;
    }

    public final void resize(int length2) {
        if (this.value.getRealSize() > length2) {
            this.modify();
            this.value.setRealSize(length2);
        } else if (this.value.length() < length2) {
            this.modify();
            this.value.length(length2);
        }
    }

    public final void view(ByteList bytes2) {
        this.modifyCheck();
        this.value = bytes2;
        this.shareLevel = 0;
    }

    private void view(byte[] bytes2, boolean copy) {
        this.modifyCheck();
        this.value = new ByteList(bytes2, copy);
        this.shareLevel = 0;
        this.value.invalidate();
    }

    private void view(int index2, int len) {
        this.modifyCheck();
        if (this.shareLevel != 0) {
            if (this.shareLevel == 2) {
                this.value = this.value.makeShared(index2, len);
                this.shareLevel = 1;
            } else {
                this.value.view(index2, len);
            }
        } else {
            this.value.view(index2, len);
            this.shareLevel = 1;
        }
        this.value.invalidate();
    }

    public static String bytesToString(byte[] bytes2, int beg, int len) {
        return new String(ByteList.plain((byte[])bytes2, (int)beg, (int)len));
    }

    public static String byteListToString(ByteList bytes2) {
        return RubyString.bytesToString(bytes2.getUnsafeBytes(), bytes2.begin(), bytes2.length());
    }

    public static String bytesToString(byte[] bytes2) {
        return RubyString.bytesToString(bytes2, 0, bytes2.length);
    }

    public static byte[] stringToBytes(String string2) {
        return ByteList.plain((CharSequence)string2);
    }

    @Override
    public RubyString asString() {
        return this;
    }

    @Override
    public IRubyObject checkStringType() {
        return this;
    }

    @Override
    public IRubyObject checkStringType19() {
        return this;
    }

    @JRubyMethod(meta=true)
    public static IRubyObject try_convert(ThreadContext context, IRubyObject recv2, IRubyObject str) {
        return str.checkStringType();
    }

    @Override
    @JRubyMethod(name={"to_s", "to_str"})
    public IRubyObject to_s() {
        Ruby runtime = this.getRuntime();
        if (this.getMetaClass().getRealClass() != runtime.getString()) {
            return this.strDup(runtime, runtime.getString());
        }
        return this;
    }

    @Override
    public final int compareTo(IRubyObject other) {
        return (int)this.op_cmp(this.getRuntime().getCurrentContext(), other).convertToInteger().getLongValue();
    }

    @Override
    @JRubyMethod(name={"<=>"})
    public IRubyObject op_cmp(ThreadContext context, IRubyObject other) {
        Ruby runtime = context.runtime;
        if (other instanceof RubyString) {
            return runtime.newFixnum(this.op_cmp((RubyString)other));
        }
        JavaSites.CheckedSites sites = RubyString.sites((ThreadContext)context).to_str_checked;
        if (sites.respond_to_X.respondsTo(context, this, other)) {
            IRubyObject tmp = TypeConverter.checkStringType(context, sites, other);
            if (tmp instanceof RubyString) {
                return runtime.newFixnum(this.op_cmp((RubyString)tmp));
            }
        } else {
            return RubyComparable.invcmp(context, RubyString.sites((ThreadContext)context).recursive_cmp, this, other);
        }
        return runtime.getNil();
    }

    @Override
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        return this.op_equal19(context, other);
    }

    @JRubyMethod(name={"==", "==="})
    public IRubyObject op_equal19(ThreadContext context, IRubyObject other) {
        Ruby runtime = context.runtime;
        if (this == other) {
            return runtime.getTrue();
        }
        if (other instanceof RubyString) {
            RubyString otherString = (RubyString)other;
            return StringSupport.areComparable(this, otherString) && this.value.equal(otherString.value) ? runtime.getTrue() : runtime.getFalse();
        }
        return this.op_equalCommon(context, other);
    }

    private IRubyObject op_equalCommon(ThreadContext context, IRubyObject other) {
        Ruby runtime = context.runtime;
        if (!RubyString.sites((ThreadContext)context).respond_to_to_str.respondsTo(context, this, other)) {
            return runtime.getFalse();
        }
        return RubyString.sites((ThreadContext)context).equals.call(context, (IRubyObject)this, other, (IRubyObject)this).isTrue() ? runtime.getTrue() : runtime.getFalse();
    }

    @JRubyMethod(name={"-@"})
    public final IRubyObject minus_at() {
        return this.isFrozen() ? this : this.dupFrozen();
    }

    @JRubyMethod(name={"+@"})
    public final IRubyObject plus_at() {
        return this.isFrozen() ? this.dup() : this;
    }

    public IRubyObject op_plus(ThreadContext context, IRubyObject arg2) {
        return this.op_plus19(context, arg2);
    }

    @JRubyMethod(name={"+"}, required=1)
    public IRubyObject op_plus19(ThreadContext context, IRubyObject arg2) {
        RubyString str = arg2.convertToString();
        Encoding enc = this.checkEncoding(str);
        long len = (long)this.value.getRealSize() + (long)str.value.getRealSize();
        if (len > Integer.MAX_VALUE) {
            throw context.runtime.newArgumentError("argument too big");
        }
        RubyString resultStr = RubyString.newStringNoCopy(context.runtime, StringSupport.addByteLists(this.value, str.value), enc, CodeRangeSupport.codeRangeAnd(this.getCodeRange(), str.getCodeRange()));
        resultStr.infectBy(this.flags | str.flags);
        return resultStr;
    }

    public IRubyObject op_mul(ThreadContext context, IRubyObject other) {
        return this.op_mul19(context, other);
    }

    @JRubyMethod(name={"*"}, required=1)
    public IRubyObject op_mul19(ThreadContext context, IRubyObject other) {
        RubyString result2 = this.multiplyByteList(context, other);
        result2.value.setEncoding(this.value.getEncoding());
        result2.copyCodeRangeForSubstr(this, this.value.getEncoding());
        return result2;
    }

    private RubyString multiplyByteList(ThreadContext context, IRubyObject arg2) {
        int len = RubyNumeric.num2int(arg2);
        if (len < 0) {
            throw context.runtime.newArgumentError("negative argument");
        }
        if (len > 0 && Integer.MAX_VALUE / len < this.value.getRealSize()) {
            throw context.runtime.newArgumentError("argument too big");
        }
        ByteList bytes2 = new ByteList(len *= this.value.getRealSize());
        if (len > 0) {
            int n;
            bytes2.setRealSize(len);
            System.arraycopy(this.value.getUnsafeBytes(), this.value.getBegin(), bytes2.getUnsafeBytes(), 0, n);
            for (n = this.value.getRealSize(); n <= len >> 1; n <<= 1) {
                System.arraycopy(bytes2.getUnsafeBytes(), 0, bytes2.getUnsafeBytes(), n, n);
            }
            System.arraycopy(bytes2.getUnsafeBytes(), 0, bytes2.getUnsafeBytes(), n, len - n);
        }
        RubyString result2 = new RubyString(context.runtime, this.getMetaClass(), bytes2);
        result2.infectBy(this);
        return result2;
    }

    @JRubyMethod(name={"%"}, required=1)
    public RubyString op_format(ThreadContext context, IRubyObject arg2) {
        return this.opFormatCommon(context, arg2);
    }

    private RubyString opFormatCommon(ThreadContext context, IRubyObject arg2) {
        IRubyObject tmp;
        if (arg2 instanceof RubyHash) {
            tmp = arg2;
        } else {
            tmp = arg2.checkArrayType();
            if (tmp.isNil()) {
                tmp = arg2;
            }
        }
        ByteList out = new ByteList(this.value.getRealSize());
        out.setEncoding(this.value.getEncoding());
        boolean tainted = Sprintf.sprintf1_9(out, Locale.US, (CharSequence)this.value, tmp);
        RubyString str = RubyString.newString(context.runtime, out);
        str.setTaint(tainted || this.isTaint());
        return str;
    }

    @Override
    @JRubyMethod
    public RubyFixnum hash() {
        Ruby runtime = this.getRuntime();
        return RubyFixnum.newFixnum(runtime, this.strHashCode(runtime));
    }

    @Override
    public int hashCode() {
        return this.strHashCode(this.getRuntime());
    }

    public int strHashCode(Ruby runtime) {
        long hash2 = runtime.isSiphashEnabled() ? SipHashInline.hash24(runtime.getHashSeedK0(), runtime.getHashSeedK1(), this.value.getUnsafeBytes(), this.value.getBegin(), this.value.getRealSize()) : PerlHash.hash(runtime.getHashSeedK0(), this.value.getUnsafeBytes(), this.value.getBegin(), this.value.getRealSize());
        return (int)(hash2 ^= (long)(this.value.getEncoding().isAsciiCompatible() && this.scanForCodeRange() == 16 ? 0 : this.value.getEncoding().getIndex()));
    }

    public int unseededStrHashCode(Ruby runtime) {
        long hash2 = runtime.isSiphashEnabled() ? SipHashInline.hash24(0L, 0L, this.value.getUnsafeBytes(), this.value.getBegin(), this.value.getRealSize()) : PerlHash.hash(0L, this.value.getUnsafeBytes(), this.value.getBegin(), this.value.getRealSize());
        return (int)(hash2 ^= (long)(this.value.getEncoding().isAsciiCompatible() && this.scanForCodeRange() == 16 ? 0 : this.value.getEncoding().getIndex()));
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof RubyString && ((RubyString)other).value.equal(this.value);
    }

    public static RubyString objAsString(ThreadContext context, IRubyObject obj) {
        if (obj instanceof RubyString) {
            return (RubyString)obj;
        }
        IRubyObject str = RubyString.sites((ThreadContext)context).to_s.call(context, obj, obj);
        if (!(str instanceof RubyString)) {
            return (RubyString)obj.anyToString();
        }
        if (obj.isTaint() && !str.isTaint() && !str.isFrozen()) {
            str.setTaint(true);
        }
        return (RubyString)str;
    }

    public final int op_cmp(RubyString other) {
        int ret = this.value.cmp(other.value);
        if (ret == 0 && !StringSupport.areComparable(this, other)) {
            return this.value.getEncoding().getIndex() > other.value.getEncoding().getIndex() ? 1 : -1;
        }
        return ret;
    }

    @Override
    public String asJavaString() {
        return this.toString();
    }

    public IRubyObject doClone() {
        return RubyString.newString(this.getRuntime(), this.value.dup());
    }

    public final RubyString cat(byte[] str) {
        this.modify(this.value.getRealSize() + str.length);
        System.arraycopy(str, 0, this.value.getUnsafeBytes(), this.value.getBegin() + this.value.getRealSize(), str.length);
        this.value.setRealSize(this.value.getRealSize() + str.length);
        return this;
    }

    public final RubyString cat(byte[] str, int beg, int len) {
        this.modify(this.value.getRealSize() + len);
        if (len == 0) {
            return this;
        }
        System.arraycopy(str, beg, this.value.getUnsafeBytes(), this.value.getBegin() + this.value.getRealSize(), len);
        this.value.setRealSize(this.value.getRealSize() + len);
        return this;
    }

    public final RubyString cat19(RubyString str2) {
        int str2_cr = this.cat19(str2.getByteList(), str2.getCodeRange());
        this.infectBy(str2);
        str2.setCodeRange(str2_cr);
        return this;
    }

    public final int cat19(ByteList other, int codeRange) {
        int[] ptr_cr_ret = new int[]{codeRange};
        EncodingUtils.encCrStrBufCat(this.getRuntime(), this, other, other.getEncoding(), codeRange, ptr_cr_ret);
        return ptr_cr_ret[0];
    }

    public final RubyString cat(RubyString str) {
        return this.cat(str.getByteList());
    }

    public final RubyString cat(ByteList str) {
        this.modify(this.value.getRealSize() + str.getRealSize());
        System.arraycopy(str.getUnsafeBytes(), str.getBegin(), this.value.getUnsafeBytes(), this.value.getBegin() + this.value.getRealSize(), str.getRealSize());
        this.value.setRealSize(this.value.getRealSize() + str.getRealSize());
        return this;
    }

    public final RubyString cat(byte ch) {
        this.modify(this.value.getRealSize() + 1);
        this.value.getUnsafeBytes()[this.value.getBegin() + this.value.getRealSize()] = ch;
        this.value.setRealSize(this.value.getRealSize() + 1);
        return this;
    }

    public final RubyString cat(int ch) {
        return this.cat((byte)ch);
    }

    public final RubyString cat(int code, Encoding enc) {
        int n = StringSupport.codeLength(enc, code);
        this.modify(this.value.getRealSize() + n);
        enc.codeToMbc(code, this.value.getUnsafeBytes(), this.value.getBegin() + this.value.getRealSize());
        this.value.setRealSize(this.value.getRealSize() + n);
        return this;
    }

    public final int cat(byte[] bytes2, int p2, int len, Encoding enc) {
        int[] ptr_cr_ret = new int[]{0};
        EncodingUtils.encCrStrBufCat(this.getRuntime(), this, new ByteList(bytes2, p2, len), enc, 0, ptr_cr_ret);
        return ptr_cr_ret[0];
    }

    public final RubyString catAscii(byte[] bytes2, int ptr, int ptrLen) {
        Encoding enc = this.value.getEncoding();
        if (enc.isAsciiCompatible()) {
            EncodingUtils.encCrStrBufCat(this.getRuntime(), this, new ByteList(bytes2, ptr, ptrLen), enc, 16, null);
        } else {
            byte[] buf = new byte[enc.maxLength()];
            int end2 = ptr + ptrLen;
            while (ptr < end2) {
                byte c = bytes2[ptr];
                int len = StringSupport.codeLength(enc, c);
                EncodingUtils.encMbcput(c, buf, 0, enc);
                EncodingUtils.encCrStrBufCat(this.getRuntime(), this, buf, 0, len, enc, 32, null);
                ++ptr;
            }
        }
        return this;
    }

    public IRubyObject replace(IRubyObject other) {
        return this.replace19(other);
    }

    @Override
    @JRubyMethod(name={"initialize_copy"}, required=1, visibility=Visibility.PRIVATE)
    public RubyString initialize_copy(IRubyObject other) {
        return this.replace19(other);
    }

    @JRubyMethod(name={"replace"}, required=1)
    public RubyString replace19(IRubyObject other) {
        this.modifyCheck();
        if (this == other) {
            return this;
        }
        this.setCodeRange(this.replaceCommon(other).getCodeRange());
        return this;
    }

    private RubyString replaceCommon(IRubyObject other) {
        this.modifyCheck();
        RubyString otherStr = other.convertToString();
        this.shareLevel = 2;
        otherStr.shareLevel = 2;
        this.value = otherStr.value;
        this.infectBy(otherStr);
        return otherStr;
    }

    @JRubyMethod
    public RubyString clear() {
        this.modifyCheck();
        Encoding enc = this.value.getEncoding();
        EmptyByteListHolder holder = RubyString.getEmptyByteList(enc);
        this.value = holder.bytes;
        this.shareLevel = 2;
        this.setCodeRange(holder.cr);
        return this;
    }

    public IRubyObject reverse(ThreadContext context) {
        return this.reverse19(context);
    }

    @JRubyMethod(name={"reverse"})
    public IRubyObject reverse19(ThreadContext context) {
        RubyString str = this.strDup(context.runtime);
        str.reverse_bang19(context);
        return str;
    }

    public RubyString reverse_bang(ThreadContext context) {
        return this.reverse_bang19(context);
    }

    @JRubyMethod(name={"reverse!"})
    public RubyString reverse_bang19(ThreadContext context) {
        this.modifyCheck();
        if (this.value.getRealSize() > 1) {
            int p2;
            this.modifyAndKeepCodeRange();
            byte[] bytes2 = this.value.getUnsafeBytes();
            int len = this.value.getRealSize();
            int end2 = p2 + len;
            int op = len;
            int cr = this.getCodeRange();
            Encoding enc = this.value.getEncoding();
            if (this.singleByteOptimizable()) {
                for (int i2 = 0; i2 < len >> 1; ++i2) {
                    byte b2 = bytes2[p2 + i2];
                    bytes2[p2 + i2] = bytes2[p2 + len - i2 - 1];
                    bytes2[p2 + len - i2 - 1] = b2;
                }
            } else if (cr == 32) {
                int cl;
                byte[] obytes = new byte[len];
                for (p2 = this.value.getBegin(); p2 < end2; p2 += cl) {
                    cl = StringSupport.encFastMBCLen(bytes2, p2, end2, enc);
                    System.arraycopy(bytes2, p2, obytes, op -= cl, cl);
                }
                this.value.setUnsafeBytes(obytes);
            } else {
                byte[] obytes = new byte[len];
                int n = cr = enc.isAsciiCompatible() ? 16 : 32;
                while (p2 < end2) {
                    int cl = StringSupport.length(enc, bytes2, p2, end2);
                    if (cl > 1 || (bytes2[p2] & 0x80) != 0) {
                        cr = 0;
                    }
                    System.arraycopy(bytes2, p2, obytes, op -= cl, cl);
                    p2 += cl;
                }
                this.value.setUnsafeBytes(obytes);
            }
            this.setCodeRange(cr);
        }
        return this;
    }

    public static RubyString newInstance(IRubyObject recv2, IRubyObject[] args2, Block block) {
        RubyString newString = RubyString.newStringShared(recv2.getRuntime(), ByteList.EMPTY_BYTELIST);
        newString.setMetaClass((RubyClass)recv2);
        newString.callInit(args2, block);
        return newString;
    }

    @Override
    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context) {
        return this;
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject arg0) {
        IRubyObject tmp = ArgsUtil.getOptionsArg(context.runtime, arg0);
        if (tmp.isNil()) {
            return this.initialize(context, arg0, null);
        }
        return this.initialize(context, null, (RubyHash)tmp);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject arg0, IRubyObject opts) {
        Ruby runtime = context.runtime;
        IRubyObject tmp = ArgsUtil.getOptionsArg(context.runtime, opts);
        if (tmp.isNil()) {
            throw runtime.newArgumentError(2, 1);
        }
        return this.initialize(context, arg0, (RubyHash)tmp);
    }

    private IRubyObject initialize(ThreadContext context, IRubyObject arg0, RubyHash opts) {
        IRubyObject encoding2;
        Ruby runtime = context.runtime;
        if (arg0 != null) {
            this.replace19(arg0);
        }
        if (opts != null && !(encoding2 = opts.fastARef(context.runtime.newSymbol("encoding"))).isNil()) {
            this.modify();
            this.setEncodingAndCodeRange(runtime.getEncodingService().getEncodingFromObject(encoding2), 0);
        }
        return this;
    }

    @Deprecated
    public IRubyObject initialize19(ThreadContext context, IRubyObject arg0) {
        return this.initialize(context, arg0);
    }

    public IRubyObject casecmp(ThreadContext context, IRubyObject other) {
        return this.casecmp19(context, other);
    }

    @JRubyMethod(name={"casecmp"})
    public IRubyObject casecmp19(ThreadContext context, IRubyObject other) {
        Ruby runtime = context.runtime;
        RubyString otherStr = other.convertToString();
        Encoding enc = StringSupport.areCompatible(this, otherStr);
        if (enc == null) {
            return runtime.getNil();
        }
        if (this.singleByteOptimizable() && otherStr.singleByteOptimizable()) {
            return RubyFixnum.newFixnum(runtime, this.value.caseInsensitiveCmp(otherStr.value));
        }
        int ret = StringSupport.multiByteCasecmp(enc, this.value, otherStr.value);
        if (ret < 0) {
            return RubyFixnum.minus_one(runtime);
        }
        if (ret > 0) {
            return RubyFixnum.one(runtime);
        }
        return RubyFixnum.zero(runtime);
    }

    @Override
    public IRubyObject op_match(ThreadContext context, IRubyObject other) {
        return this.op_match19(context, other);
    }

    @Override
    @JRubyMethod(name={"=~"}, writes={FrameField.BACKREF})
    public IRubyObject op_match19(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyRegexp) {
            return ((RubyRegexp)other).op_match19(context, this);
        }
        if (other instanceof RubyString) {
            throw context.runtime.newTypeError("type mismatch: String given");
        }
        return RubyString.sites((ThreadContext)context).op_match.call(context, other, other, (IRubyObject)this);
    }

    public IRubyObject match(ThreadContext context, IRubyObject pattern) {
        return this.match19(context, pattern, Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"match"}, reads={FrameField.BACKREF})
    public IRubyObject match19(ThreadContext context, IRubyObject pattern, Block block) {
        RubyRegexp coercedPattern = this.getPattern(pattern);
        IRubyObject result2 = RubyString.sites((ThreadContext)context).match.call(context, (IRubyObject)coercedPattern, (IRubyObject)coercedPattern, (IRubyObject)this);
        return block.isGiven() && !result2.isNil() ? block.yield(context, result2) : result2;
    }

    @JRubyMethod(name={"match"}, required=1, rest=true, reads={FrameField.BACKREF})
    public IRubyObject match19(ThreadContext context, IRubyObject[] args2, Block block) {
        RubyRegexp pattern = this.getPattern(args2[0]);
        args2[0] = this;
        IRubyObject result2 = RubyString.sites((ThreadContext)context).match.call(context, (IRubyObject)pattern, (IRubyObject)pattern, args2);
        return block.isGiven() && !result2.isNil() ? block.yield(context, result2) : result2;
    }

    public IRubyObject capitalize(ThreadContext context) {
        return this.capitalize19(context);
    }

    public IRubyObject capitalize_bang(ThreadContext context) {
        return this.capitalize_bang19(context);
    }

    @JRubyMethod(name={"capitalize"})
    public IRubyObject capitalize19(ThreadContext context) {
        RubyString str = this.strDup(context.runtime);
        str.capitalize_bang19(context);
        return str;
    }

    @JRubyMethod(name={"capitalize!"})
    public IRubyObject capitalize_bang19(ThreadContext context) {
        Ruby runtime = context.runtime;
        Encoding enc = this.checkDummyEncoding();
        if (this.value.getRealSize() == 0) {
            this.modifyCheck();
            return runtime.getNil();
        }
        this.modifyAndKeepCodeRange();
        int s2 = this.value.getBegin();
        int end2 = s2 + this.value.getRealSize();
        byte[] bytes2 = this.value.getUnsafeBytes();
        boolean modify = false;
        int c = StringSupport.codePoint(runtime, enc, bytes2, s2, end2);
        if (enc.isLower(c)) {
            enc.codeToMbc(StringSupport.toUpper(enc, c), bytes2, s2);
            modify = true;
        }
        s2 += StringSupport.codeLength(enc, c);
        while (s2 < end2) {
            c = StringSupport.codePoint(runtime, enc, bytes2, s2, end2);
            if (enc.isUpper(c)) {
                enc.codeToMbc(StringSupport.toLower(enc, c), bytes2, s2);
                modify = true;
            }
            s2 += StringSupport.codeLength(enc, c);
        }
        return modify ? this : runtime.getNil();
    }

    public IRubyObject op_ge(ThreadContext context, IRubyObject other) {
        return this.op_ge19(context, other);
    }

    @JRubyMethod(name={">="})
    public IRubyObject op_ge19(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyString && this.cmpIsBuiltin(context)) {
            return context.runtime.newBoolean(this.op_cmp((RubyString)other) >= 0);
        }
        return RubyComparable.op_ge(context, this, other);
    }

    public IRubyObject op_gt(ThreadContext context, IRubyObject other) {
        return this.op_gt19(context, other);
    }

    @JRubyMethod(name={">"})
    public IRubyObject op_gt19(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyString && this.cmpIsBuiltin(context)) {
            return context.runtime.newBoolean(this.op_cmp((RubyString)other) > 0);
        }
        return RubyComparable.op_gt(context, this, other);
    }

    public IRubyObject op_le(ThreadContext context, IRubyObject other) {
        return this.op_le19(context, other);
    }

    @JRubyMethod(name={"<="})
    public IRubyObject op_le19(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyString && this.cmpIsBuiltin(context)) {
            return context.runtime.newBoolean(this.op_cmp((RubyString)other) <= 0);
        }
        return RubyComparable.op_le(context, this, other);
    }

    public IRubyObject op_lt(ThreadContext context, IRubyObject other) {
        return this.op_lt19(context, other);
    }

    @JRubyMethod(name={"<"})
    public IRubyObject op_lt19(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyString && this.cmpIsBuiltin(context)) {
            return context.runtime.newBoolean(this.op_cmp((RubyString)other) < 0);
        }
        return RubyComparable.op_lt(context, RubyString.sites((ThreadContext)context).cmp, this, other);
    }

    private boolean cmpIsBuiltin(ThreadContext context) {
        return RubyString.sites((ThreadContext)context).cmp.isBuiltin(this.metaClass);
    }

    public IRubyObject str_eql_p(ThreadContext context, IRubyObject other) {
        return this.str_eql_p19(context, other);
    }

    @JRubyMethod(name={"eql?"})
    public IRubyObject str_eql_p19(ThreadContext context, IRubyObject other) {
        RubyString otherString;
        Ruby runtime = context.runtime;
        if (other instanceof RubyString && StringSupport.areComparable(this, otherString = (RubyString)other) && this.value.equal(otherString.value)) {
            return runtime.getTrue();
        }
        return runtime.getFalse();
    }

    @Deprecated
    public RubyString upcase(ThreadContext context) {
        return this.upcase19(context);
    }

    @Deprecated
    public IRubyObject upcase_bang(ThreadContext context) {
        return this.upcase_bang19(context);
    }

    @JRubyMethod(name={"upcase"})
    public RubyString upcase19(ThreadContext context) {
        RubyString str = this.strDup(context.runtime);
        str.upcase_bang19(context);
        return str;
    }

    @JRubyMethod(name={"upcase!"})
    public IRubyObject upcase_bang19(ThreadContext context) {
        Ruby runtime = context.runtime;
        Encoding enc = this.checkDummyEncoding();
        if (this.value.getRealSize() == 0) {
            this.modifyCheck();
            return runtime.getNil();
        }
        this.modifyAndKeepCodeRange();
        int s2 = this.value.getBegin();
        int end2 = s2 + this.value.getRealSize();
        byte[] bytes2 = this.value.getUnsafeBytes();
        if (this.singleByteOptimizable(enc)) {
            return this.singleByteUpcase(runtime, bytes2, s2, end2);
        }
        return this.multiByteUpcase(runtime, enc, bytes2, s2, end2);
    }

    private IRubyObject singleByteUpcase(Ruby runtime, byte[] bytes2, int s2, int end2) {
        boolean modify = StringSupport.singleByteUpcase(bytes2, s2, end2);
        return modify ? this : runtime.getNil();
    }

    private IRubyObject multiByteUpcase(Ruby runtime, Encoding enc, byte[] bytes2, int s2, int end2) {
        try {
            boolean modify = StringSupport.multiByteUpcase(enc, bytes2, s2, end2);
            return modify ? this : runtime.getNil();
        }
        catch (IllegalArgumentException e) {
            throw runtime.newArgumentError(e.getMessage());
        }
    }

    @Deprecated
    public RubyString downcase(ThreadContext context) {
        return this.downcase19(context);
    }

    @Deprecated
    public IRubyObject downcase_bang(ThreadContext context) {
        return this.downcase_bang19(context);
    }

    @JRubyMethod(name={"downcase"})
    public RubyString downcase19(ThreadContext context) {
        RubyString str = this.strDup(context.runtime);
        str.downcase_bang19(context);
        return str;
    }

    @JRubyMethod(name={"downcase!"})
    public IRubyObject downcase_bang19(ThreadContext context) {
        Ruby runtime = context.runtime;
        Encoding enc = this.checkDummyEncoding();
        if (this.value.getRealSize() == 0) {
            this.modifyCheck();
            return runtime.getNil();
        }
        this.modifyAndKeepCodeRange();
        int s2 = this.value.getBegin();
        int end2 = s2 + this.value.getRealSize();
        byte[] bytes2 = this.value.getUnsafeBytes();
        if (this.singleByteOptimizable(enc)) {
            return this.singleByteDowncase(runtime, bytes2, s2, end2);
        }
        return this.multiByteDowncase(runtime, enc, bytes2, s2, end2);
    }

    private IRubyObject singleByteDowncase(Ruby runtime, byte[] bytes2, int s2, int end2) {
        boolean modify = StringSupport.singleByteDowncase(bytes2, s2, end2);
        return modify ? this : runtime.getNil();
    }

    private IRubyObject multiByteDowncase(Ruby runtime, Encoding enc, byte[] bytes2, int s2, int end2) {
        try {
            boolean modify = StringSupport.multiByteDowncase(enc, bytes2, s2, end2);
            return modify ? this : runtime.getNil();
        }
        catch (IllegalArgumentException e) {
            throw runtime.newArgumentError(e.getMessage());
        }
    }

    public RubyString swapcase(ThreadContext context) {
        return this.swapcase19(context);
    }

    public IRubyObject swapcase_bang(ThreadContext context) {
        return this.swapcase_bang19(context);
    }

    @JRubyMethod(name={"swapcase"})
    public RubyString swapcase19(ThreadContext context) {
        RubyString str = this.strDup(context.runtime);
        str.swapcase_bang19(context);
        return str;
    }

    @JRubyMethod(name={"swapcase!"})
    public IRubyObject swapcase_bang19(ThreadContext context) {
        Ruby runtime = context.runtime;
        Encoding enc = this.checkDummyEncoding();
        if (this.value.getRealSize() == 0) {
            this.modifyCheck();
            return runtime.getNil();
        }
        this.modifyAndKeepCodeRange();
        int s2 = this.value.getBegin();
        int end2 = s2 + this.value.getRealSize();
        byte[] bytes2 = this.value.getUnsafeBytes();
        if (this.singleByteOptimizable(enc) ? StringSupport.singleByteSwapcase(bytes2, s2, end2) : StringSupport.multiByteSwapcase(runtime, enc, bytes2, s2, end2)) {
            return this;
        }
        return runtime.getNil();
    }

    public IRubyObject dump() {
        return this.dump19();
    }

    @JRubyMethod(name={"dump"})
    public IRubyObject dump19() {
        ByteList outBytes = StringSupport.dumpCommon(this.getRuntime(), this.value);
        RubyString result2 = new RubyString(this.getRuntime(), this.getMetaClass(), outBytes);
        Encoding enc = this.value.getEncoding();
        if (!enc.isAsciiCompatible()) {
            result2.cat(".force_encoding(\"".getBytes());
            result2.cat(enc.getName());
            result2.cat((byte)34).cat((byte)41);
            enc = ASCII;
        }
        result2.associateEncoding(enc);
        result2.setCodeRange(16);
        return result2.infectBy(this);
    }

    public IRubyObject insert(ThreadContext context, IRubyObject indexArg, IRubyObject stringArg) {
        return this.insert19(context, indexArg, stringArg);
    }

    @JRubyMethod(name={"insert"})
    public IRubyObject insert19(ThreadContext context, IRubyObject indexArg, IRubyObject stringArg) {
        RubyString str = stringArg.convertToString();
        int index2 = RubyNumeric.num2int(indexArg);
        if (index2 == -1) {
            return this.append19(stringArg);
        }
        if (index2 < 0) {
            ++index2;
        }
        this.replaceInternal19(index2, 0, str);
        return this;
    }

    private int checkIndex(int beg, int len) {
        if (beg > len) {
            this.raiseIndexOutOfString(beg);
        }
        if (beg < 0) {
            if (-beg > len) {
                this.raiseIndexOutOfString(beg);
            }
            beg += len;
        }
        return beg;
    }

    private int checkIndexForRef(int beg, int len) {
        if (beg >= len) {
            this.raiseIndexOutOfString(beg);
        }
        if (beg < 0) {
            if (-beg > len) {
                this.raiseIndexOutOfString(beg);
            }
            beg += len;
        }
        return beg;
    }

    private int checkLength(int len) {
        if (len < 0) {
            throw this.getRuntime().newIndexError("negative length " + len);
        }
        return len;
    }

    private void raiseIndexOutOfString(int index2) {
        throw this.getRuntime().newIndexError("index " + index2 + " out of string");
    }

    @Override
    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect() {
        return this.inspect(this.getRuntime());
    }

    final RubyString inspect(Ruby runtime) {
        return (RubyString)RubyString.inspect(runtime, this.value).infectBy(this);
    }

    @Deprecated
    public IRubyObject inspect19() {
        return this.inspect();
    }

    public static IRubyObject rbStrEscape(ThreadContext context, RubyString str) {
        Ruby runtime = context.runtime;
        Encoding enc = str.getEncoding();
        ByteList strBL = str.getByteList();
        byte[] pBytes = strBL.unsafeBytes();
        int p2 = strBL.begin();
        int pend = p2 + strBL.realSize();
        int prev = p2;
        RubyString result2 = RubyString.newEmptyString(runtime);
        boolean unicode_p = enc.isUnicode();
        boolean asciicompat = enc.isAsciiCompatible();
        while (p2 < pend) {
            int cc;
            int n = enc.length(pBytes, p2, pend);
            if (!StringSupport.MBCLEN_CHARFOUND_P(n)) {
                if (p2 > prev) {
                    result2.cat(pBytes, prev, p2 - prev);
                }
                if (pend < p2 + (n = enc.minLength())) {
                    n = pend - p2;
                }
                while (n-- > 0) {
                    result2.modify();
                    Sprintf.sprintf(runtime, result2.getByteList(), (CharSequence)"\\x%02X", pBytes[p2] & 0xFF);
                    prev = ++p2;
                }
                continue;
            }
            n = StringSupport.MBCLEN_CHARFOUND_LEN(n);
            int c = enc.mbcToCode(pBytes, p2, pend);
            p2 += n;
            switch (c) {
                case 10: {
                    cc = 110;
                    break;
                }
                case 13: {
                    cc = 114;
                    break;
                }
                case 9: {
                    cc = 116;
                    break;
                }
                case 12: {
                    cc = 102;
                    break;
                }
                case 11: {
                    cc = 118;
                    break;
                }
                case 8: {
                    cc = 98;
                    break;
                }
                case 7: {
                    cc = 97;
                    break;
                }
                case 27: {
                    cc = 101;
                    break;
                }
                default: {
                    cc = 0;
                }
            }
            if (cc != 0) {
                if (p2 - n > prev) {
                    result2.cat(pBytes, prev, p2 - n - prev);
                }
                result2.cat(92);
                result2.cat((byte)cc);
                prev = p2;
                continue;
            }
            if (asciicompat && Encoding.isAscii((int)c) && c < 127 && c > 31) continue;
            if (p2 - n > prev) {
                result2.cat(pBytes, prev, p2 - n - prev);
            }
            result2.modify();
            Sprintf.sprintf(runtime, result2.getByteList(), (CharSequence)StringSupport.escapedCharFormat(c, unicode_p), (long)c & 0xFFFFFFFFL);
            prev = p2;
        }
        if (p2 > prev) {
            result2.cat(pBytes, prev, p2 - prev);
        }
        result2.setEncodingAndCodeRange((Encoding)USASCIIEncoding.INSTANCE, 16);
        result2.infectBy(str);
        return result2;
    }

    @Deprecated
    public static IRubyObject inspect19(Ruby runtime, ByteList byteList) {
        return RubyString.inspect(runtime, byteList);
    }

    public static RubyString inspect(Ruby runtime, ByteList byteList) {
        Encoding enc = byteList.getEncoding();
        byte[] bytes2 = byteList.getUnsafeBytes();
        int p2 = byteList.getBegin();
        int end2 = p2 + byteList.getRealSize();
        RubyString result2 = new RubyString(runtime, runtime.getString(), new ByteList(end2 - p2));
        Encoding resultEnc = runtime.getDefaultInternalEncoding();
        boolean isUnicode = StringSupport.isUnicode(enc);
        boolean asciiCompat = enc.isAsciiCompatible();
        if (resultEnc == null) {
            resultEnc = runtime.getDefaultExternalEncoding();
        }
        if (!resultEnc.isAsciiCompatible()) {
            resultEnc = USASCIIEncoding.INSTANCE;
        }
        result2.associateEncoding(resultEnc);
        result2.cat(34);
        int prev = p2;
        Encoding actEnc = EncodingUtils.getActualEncoding(enc, byteList);
        if (actEnc != enc) {
            enc = actEnc;
            if (isUnicode) {
                isUnicode = enc instanceof UnicodeEncoding;
            }
        }
        while (p2 < end2) {
            int n = StringSupport.preciseLength(enc, bytes2, p2, end2);
            if (!StringSupport.MBCLEN_CHARFOUND_P(n)) {
                if (p2 > prev) {
                    result2.cat(bytes2, prev, p2 - prev);
                }
                if (end2 < p2 + (n = enc.minLength())) {
                    n = end2 - p2;
                }
                while (n-- > 0) {
                    result2.modifyExpand(result2.size() + 4);
                    Sprintf.sprintf(runtime, result2.getByteList(), (CharSequence)"\\x%02X", bytes2[p2] & 0xFF);
                    prev = ++p2;
                }
                continue;
            }
            n = StringSupport.MBCLEN_CHARFOUND_LEN(n);
            int c = enc.mbcToCode(bytes2, p2, end2);
            int cc = 0;
            if ((asciiCompat || isUnicode) && (c == 34 || c == 92 || c == 35 && (p2 += n) < end2 && StringSupport.MBCLEN_CHARFOUND_P(StringSupport.preciseLength(enc, bytes2, p2, end2)) && ((cc = StringSupport.codePoint(runtime, enc, bytes2, p2, end2)) == 36 || cc == 64 || cc == 123))) {
                if (p2 - n > prev) {
                    result2.cat(bytes2, prev, p2 - n - prev);
                }
                result2.cat(92);
                if (asciiCompat || enc == resultEnc) {
                    prev = p2 - n;
                    continue;
                }
            }
            switch (c) {
                case 10: {
                    cc = 110;
                    break;
                }
                case 13: {
                    cc = 114;
                    break;
                }
                case 9: {
                    cc = 116;
                    break;
                }
                case 12: {
                    cc = 102;
                    break;
                }
                case 11: {
                    cc = 118;
                    break;
                }
                case 8: {
                    cc = 98;
                    break;
                }
                case 7: {
                    cc = 97;
                    break;
                }
                case 27: {
                    cc = 101;
                    break;
                }
                default: {
                    cc = 0;
                }
            }
            if (cc != 0) {
                if (p2 - n > prev) {
                    result2.cat(bytes2, prev, p2 - n - prev);
                }
                result2.cat(92);
                result2.cat(cc);
                prev = p2;
                continue;
            }
            if (enc == resultEnc && enc.isPrint(c) || asciiCompat && c < 128 && c > 0 && enc.isPrint(c)) continue;
            if (p2 - n > prev) {
                result2.cat(bytes2, prev, p2 - n - prev);
            }
            Sprintf.sprintf(runtime, result2.getByteList(), (CharSequence)StringSupport.escapedCharFormat(c, isUnicode), (long)c & 0xFFFFFFFFL);
            prev = p2;
        }
        if (p2 > prev) {
            result2.cat(bytes2, prev, p2 - prev);
        }
        result2.cat(34);
        return result2;
    }

    public int size() {
        return this.value.getRealSize();
    }

    public RubyFixnum length() {
        return this.length19();
    }

    @JRubyMethod(name={"length", "size"})
    public RubyFixnum length19() {
        return this.getRuntime().newFixnum(this.strLength());
    }

    @JRubyMethod(name={"bytesize"})
    public RubyFixnum bytesize() {
        return this.getRuntime().newFixnum(this.value.getRealSize());
    }

    private RubyEnumerator.SizeFn eachByteSizeFn() {
        final RubyString self2 = this;
        return new RubyEnumerator.SizeFn(){

            @Override
            public IRubyObject size(IRubyObject[] args2) {
                return self2.bytesize();
            }
        };
    }

    @JRubyMethod(name={"empty?"})
    public RubyBoolean empty_p(ThreadContext context) {
        return this.isEmpty() ? context.runtime.getTrue() : context.runtime.getFalse();
    }

    public boolean isEmpty() {
        return this.value.length() == 0;
    }

    public RubyString append(IRubyObject other) {
        if (other instanceof RubyFixnum) {
            this.cat(ConvertBytes.longToByteList(((RubyFixnum)other).getLongValue()));
            return this;
        }
        if (other instanceof RubyFloat) {
            return this.cat((RubyString)((RubyFloat)other).to_s());
        }
        if (other instanceof RubySymbol) {
            this.cat(((RubySymbol)other).getBytes());
            return this;
        }
        RubyString otherStr = other.convertToString();
        this.infectBy(otherStr);
        return this.cat(otherStr.value);
    }

    public RubyString append19(IRubyObject other) {
        if (other instanceof RubyFixnum) {
            this.cat19(ConvertBytes.longToByteList(((RubyFixnum)other).getLongValue()), 16);
            return this;
        }
        if (other instanceof RubyFloat) {
            return this.cat19((RubyString)((RubyFloat)other).to_s());
        }
        if (other instanceof RubySymbol) {
            this.cat19(((RubySymbol)other).getBytes(), 0);
            return this;
        }
        return this.cat19(other.convertToString());
    }

    public RubyString concat(IRubyObject other) {
        return this.concat19(this.getRuntime().getCurrentContext(), other);
    }

    @JRubyMethod(name={"concat", "<<"})
    public RubyString concat19(ThreadContext context, IRubyObject other) {
        Ruby runtime = context.runtime;
        if (other instanceof RubyFixnum) {
            long c = RubyNumeric.num2long(other);
            if (c < 0L) {
                throw runtime.newRangeError(c + " out of char range");
            }
            return this.concatNumeric(runtime, (int)(c & 0xFFFFFFFFFFFFFFFFL));
        }
        if (other instanceof RubyBignum) {
            if (((RubyBignum)other).getBigIntegerValue().signum() < 0) {
                throw runtime.newRangeError("negative string size (or size too big)");
            }
            long c = ((RubyBignum)other).getLongValue();
            return this.concatNumeric(runtime, (int)c);
        }
        if (other instanceof RubySymbol) {
            throw runtime.newTypeError("can't convert Symbol into String");
        }
        return this.append19(other);
    }

    private RubyString concatNumeric(Ruby runtime, int c) {
        int cl;
        Encoding enc = this.value.getEncoding();
        try {
            cl = StringSupport.codeLength(enc, c);
            if (cl <= 0) {
                throw runtime.newRangeError(c + " out of char range or invalid code point");
            }
            this.modify19(this.value.getRealSize() + cl);
            if (enc == USASCIIEncoding.INSTANCE) {
                if (c > 255) {
                    throw runtime.newRangeError(c + " out of char range");
                }
                if (c > 121) {
                    this.value.setEncoding((Encoding)ASCIIEncoding.INSTANCE);
                    enc = this.value.getEncoding();
                }
            }
            enc.codeToMbc(c, this.value.getUnsafeBytes(), this.value.getBegin() + this.value.getRealSize());
        }
        catch (EncodingException e) {
            throw runtime.newRangeError(c + " out of char range");
        }
        this.value.setRealSize(this.value.getRealSize() + cl);
        return this;
    }

    @JRubyMethod
    public IRubyObject prepend(ThreadContext context, IRubyObject other) {
        return this.replace19(other.convertToString().op_plus19(context, this));
    }

    @JRubyMethod(name={"crypt"})
    public RubyString crypt(ThreadContext context, IRubyObject other) {
        Encoding ascii8bit = context.runtime.getEncodingService().getAscii8bitEncoding();
        RubyString otherStr = other.convertToString().strDup(context.runtime);
        otherStr.modify();
        otherStr.associateEncoding(ascii8bit);
        ByteList otherBL = otherStr.getByteList();
        if (otherBL.length() < 2) {
            throw context.runtime.newArgumentError("salt too short (need >=2 bytes)");
        }
        POSIX posix = context.runtime.getPosix();
        byte[] keyBytes = Arrays.copyOfRange(this.value.unsafeBytes(), this.value.begin(), this.value.begin() + this.value.realSize());
        byte[] saltBytes = Arrays.copyOfRange(otherBL.unsafeBytes(), otherBL.begin(), otherBL.begin() + otherBL.realSize());
        if (saltBytes[0] == 0 || saltBytes[1] == 0) {
            throw context.runtime.newArgumentError("salt too short (need >=2 bytes)");
        }
        byte[] cryptedString = posix.crypt(keyBytes, saltBytes);
        if (cryptedString == null) {
            throw context.runtime.newErrnoFromInt(posix.errno());
        }
        RubyString result2 = RubyString.newStringNoCopy(context.runtime, cryptedString, 0, cryptedString.length - 1);
        result2.associateEncoding(ascii8bit);
        result2.infectBy(this);
        result2.infectBy(otherStr);
        return result2;
    }

    public static RubyString stringValue(IRubyObject object) {
        return (RubyString)(object instanceof RubyString ? object : object.convertToString());
    }

    @Deprecated
    public IRubyObject sub19(ThreadContext context, IRubyObject arg0, Block block) {
        return this.sub(context, arg0, block);
    }

    @Deprecated
    public IRubyObject sub19(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        return this.sub(context, arg0, arg1, block);
    }

    @Deprecated
    public IRubyObject sub_bang19(ThreadContext context, IRubyObject arg0, Block block) {
        return this.sub_bang(context, arg0, block);
    }

    @Deprecated
    public IRubyObject sub_bang19(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        return this.sub_bang(context, arg0, arg1, block);
    }

    @JRubyMethod(name={"sub"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF})
    public IRubyObject sub(ThreadContext context, IRubyObject arg0, Block block) {
        RubyString str = this.strDup(context.runtime);
        str.sub_bang(context, arg0, block);
        return str;
    }

    @JRubyMethod(name={"sub"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF})
    public IRubyObject sub(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        RubyString str = this.strDup(context.runtime);
        str.sub_bang(context, arg0, arg1, block);
        return str;
    }

    @JRubyMethod(name={"sub!"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF})
    public IRubyObject sub_bang(ThreadContext context, IRubyObject arg0, Block block) {
        Ruby runtime = context.runtime;
        this.frozenCheck();
        if (block.isGiven()) {
            return this.subBangIter(runtime, context, arg0, null, block);
        }
        throw runtime.newArgumentError(1, 2);
    }

    @JRubyMethod(name={"sub!"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF})
    public IRubyObject sub_bang(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        Ruby runtime = context.runtime;
        IRubyObject hash2 = TypeConverter.convertToTypeWithCheck(context, arg1, runtime.getHash(), RubyString.sites((ThreadContext)context).to_hash_checked);
        this.frozenCheck();
        if (hash2.isNil()) {
            return this.subBangNoIter(runtime, context, arg0, arg1.convertToString());
        }
        return this.subBangIter(runtime, context, arg0, (RubyHash)hash2, block);
    }

    private RubyRegexp asRegexpArg(Ruby runtime, IRubyObject arg0) {
        return arg0 instanceof RubyRegexp ? (RubyRegexp)arg0 : RubyRegexp.newRegexp(runtime, RubyRegexp.quote19(this.getStringForPattern(arg0).getByteList(), false), new RegexpOptions());
    }

    private IRubyObject subBangIter(Ruby runtime, ThreadContext context, IRubyObject arg0, RubyHash hash2, Block block) {
        RubyRegexp regexp2 = this.asRegexpArg(runtime, arg0);
        Regex pattern = regexp2.getPattern();
        Regex prepared = regexp2.preparePattern(this);
        int begin2 = this.value.getBegin();
        int len = this.value.getRealSize();
        int range = begin2 + len;
        byte[] bytes2 = this.value.getUnsafeBytes();
        Encoding enc = this.value.getEncoding();
        Matcher matcher = prepared.matcher(bytes2, begin2, range);
        if (RubyRegexp.matcherSearch(runtime, matcher, begin2, range, 0) >= 0) {
            RubyString repl;
            int tuFlags;
            RubyMatchData match2 = RubyRegexp.createMatchData19(context, this, matcher, pattern);
            match2.regexp = regexp2;
            context.setBackRef(match2);
            int mBeg = matcher.getBegin();
            int mEnd = matcher.getEnd();
            RubyString subStr = this.makeShared19(runtime, mBeg, mEnd - mBeg);
            if (hash2 == null) {
                tuFlags = 0;
                repl = RubyString.objAsString(context, block.yield(context, subStr));
            } else {
                tuFlags = hash2.flags;
                repl = RubyString.objAsString(context, hash2.op_aref(context, subStr));
            }
            this.modifyCheck(bytes2, len, enc);
            return this.subBangCommon(context, mBeg, mEnd, repl, tuFlags | repl.flags);
        }
        return context.setBackRef(runtime.getNil());
    }

    private IRubyObject subBangNoIter(Ruby runtime, ThreadContext context, IRubyObject arg0, RubyString repl) {
        RubyRegexp regexp2 = this.asRegexpArg(runtime, arg0);
        Regex pattern = regexp2.getPattern();
        Regex prepared = regexp2.preparePattern(this);
        int begin2 = this.value.getBegin();
        int range = begin2 + this.value.getRealSize();
        Matcher matcher = prepared.matcher(this.value.getUnsafeBytes(), begin2, range);
        if (RubyRegexp.matcherSearch(runtime, matcher, begin2, range, 0) >= 0) {
            repl = RubyRegexp.regsub19(context, repl, this, matcher, pattern);
            RubyMatchData match2 = RubyRegexp.createMatchData19(context, this, matcher, pattern);
            match2.regexp = regexp2;
            context.setBackRef(match2);
            return this.subBangCommon(context, matcher.getBegin(), matcher.getEnd(), repl, repl.flags);
        }
        return context.setBackRef(runtime.getNil());
    }

    private IRubyObject subBangCommon(ThreadContext context, int beg, int end2, RubyString repl, int tuFlags) {
        int plen;
        ByteList replValue;
        int replSize;
        Encoding enc = StringSupport.areCompatible(this, repl);
        if (enc == null) {
            enc = this.subBangVerifyEncoding(context, repl, beg, end2);
        }
        if ((replSize = (replValue = repl.value).getRealSize()) > (plen = end2 - beg)) {
            this.modifyExpand(this.value.getRealSize() + replSize - plen);
        } else {
            this.modify19();
        }
        ByteList value2 = this.value;
        int size2 = value2.getRealSize();
        this.associateEncoding(enc);
        int cr = this.getCodeRange();
        if (cr > 0 && cr < 48) {
            int cr2 = repl.getCodeRange();
            cr = cr2 == 48 || cr == 32 && cr2 == 16 ? 0 : cr2;
        }
        if (replSize != plen) {
            int src = value2.getBegin() + beg + plen;
            int dst = value2.getBegin() + beg + replSize;
            System.arraycopy(value2.getUnsafeBytes(), src, value2.getUnsafeBytes(), dst, size2 - beg - plen);
        }
        System.arraycopy(replValue.getUnsafeBytes(), replValue.getBegin(), value2.getUnsafeBytes(), value2.getBegin() + beg, replSize);
        value2.setRealSize(size2 + replSize - plen);
        this.setCodeRange(cr);
        return this.infectBy(tuFlags);
    }

    private Encoding subBangVerifyEncoding(ThreadContext context, RubyString repl, int beg, int end2) {
        ByteList value2 = this.value;
        byte[] bytes2 = value2.getUnsafeBytes();
        int p2 = value2.getBegin();
        int len = value2.getRealSize();
        Encoding strEnc = value2.getEncoding();
        if (StringSupport.codeRangeScan(strEnc, bytes2, p2, beg) != 16 || StringSupport.codeRangeScan(strEnc, bytes2, p2 + end2, len - end2) != 16) {
            throw context.runtime.newEncodingCompatibilityError("incompatible character encodings " + strEnc + " and " + repl.value.getEncoding());
        }
        return repl.value.getEncoding();
    }

    public IRubyObject gsub(ThreadContext context, IRubyObject arg0, Block block) {
        return this.gsub19(context, arg0, block);
    }

    public IRubyObject gsub(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        return this.gsub19(context, arg0, arg1, block);
    }

    public IRubyObject gsub_bang(ThreadContext context, IRubyObject arg0, Block block) {
        return this.gsub_bang19(context, arg0, block);
    }

    public IRubyObject gsub_bang(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        return this.gsub_bang19(context, arg0, arg1, block);
    }

    @JRubyMethod(name={"gsub"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF})
    public IRubyObject gsub19(ThreadContext context, IRubyObject arg0, Block block) {
        return block.isGiven() ? this.gsubCommon19(context, block, null, null, arg0, false, 0) : RubyEnumerator.enumeratorize(context.runtime, (IRubyObject)this, "gsub", arg0);
    }

    @JRubyMethod(name={"gsub"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF})
    public IRubyObject gsub19(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        return this.gsub19(context, arg0, arg1, block, false);
    }

    @JRubyMethod(name={"gsub!"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF})
    public IRubyObject gsub_bang19(ThreadContext context, IRubyObject arg0, Block block) {
        this.checkFrozen();
        return block.isGiven() ? this.gsubCommon19(context, block, null, null, arg0, true, 0) : RubyEnumerator.enumeratorize(context.runtime, (IRubyObject)this, "gsub!", arg0);
    }

    @JRubyMethod(name={"gsub!"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF})
    public IRubyObject gsub_bang19(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        this.checkFrozen();
        return this.gsub19(context, arg0, arg1, block, true);
    }

    private IRubyObject gsub19(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block, boolean bang) {
        int tuFlags;
        RubyString str;
        RubyHash hash2;
        Ruby runtime = context.runtime;
        IRubyObject tryHash = TypeConverter.convertToTypeWithCheck(context, arg1, runtime.getHash(), RubyString.sites((ThreadContext)context).to_hash_checked);
        if (tryHash.isNil()) {
            hash2 = null;
            str = arg1.convertToString();
            tuFlags = str.flags;
        } else {
            hash2 = (RubyHash)tryHash;
            str = null;
            tuFlags = hash2.flags & TAINTED_F;
        }
        return this.gsubCommon19(context, block, str, hash2, arg0, bang, tuFlags);
    }

    private IRubyObject gsubCommon19(ThreadContext context, Block block, RubyString repl, RubyHash hash2, IRubyObject arg0, boolean bang, int tuFlags) {
        return this.gsubCommon19(context, block, repl, hash2, arg0, bang, tuFlags, true);
    }

    private IRubyObject gsubCommon19(ThreadContext context, Block block, RubyString repl, RubyHash hash2, IRubyObject arg0, boolean bang, int tuFlags, boolean useBackref) {
        int spLen;
        int spBeg;
        byte[] spBytes;
        Ruby runtime = context.runtime;
        RubyRegexp regexp2 = this.asRegexpArg(runtime, arg0);
        Regex pattern = regexp2.getPattern();
        Regex prepared = regexp2.preparePattern(this);
        Matcher matcher = prepared.matcher(spBytes = this.value.getUnsafeBytes(), spBeg = this.value.getBegin(), spBeg + (spLen = this.value.getRealSize()));
        int beg = RubyRegexp.matcherSearch(runtime, matcher, spBeg, spBeg + spLen, 0);
        if (beg < 0) {
            if (useBackref) {
                context.setBackRef(context.nil);
            }
            return bang ? context.nil : this.strDup(runtime);
        }
        int offset2 = 0;
        int cp = spBeg;
        RubyString dest = new RubyString(runtime, this.getMetaClass(), new ByteList(spLen + 30));
        Encoding str_enc = this.value.getEncoding();
        dest.setEncoding(str_enc);
        dest.setCodeRange(str_enc.isAsciiCompatible() ? 16 : 32);
        RubyMatchData match2 = null;
        do {
            RubyString val;
            int begz = matcher.getBegin();
            int endz = matcher.getEnd();
            if (repl != null) {
                val = RubyRegexp.regsub19(context, repl, this, matcher, pattern);
            } else {
                RubyString substr = this.makeShared19(runtime, begz, endz - begz);
                if (hash2 != null) {
                    val = RubyString.objAsString(context, hash2.op_aref(context, substr));
                } else {
                    match2 = RubyRegexp.createMatchData19(context, this, matcher, pattern);
                    match2.regexp = regexp2;
                    if (useBackref) {
                        context.setBackRef(match2);
                    }
                    val = RubyString.objAsString(context, block.yield(context, substr));
                }
                this.modifyCheck(spBytes, spLen, str_enc);
                if (bang) {
                    this.frozenCheck();
                }
            }
            tuFlags |= val.flags;
            int len = beg - offset2;
            if (len != 0) {
                dest.cat(spBytes, cp, len, str_enc);
            }
            dest.cat19(val);
            offset2 = endz;
            if (begz == endz) {
                if (spLen <= endz) break;
                len = StringSupport.encFastMBCLen(spBytes, spBeg + endz, spBeg + spLen, str_enc);
                dest.cat(spBytes, spBeg + endz, len, str_enc);
                offset2 = endz + len;
            }
            cp = spBeg + offset2;
        } while (offset2 <= spLen && (beg = RubyRegexp.matcherSearch(runtime, matcher, cp, spBeg + spLen, 0)) >= 0);
        if (spLen > offset2) {
            dest.cat(spBytes, cp, spLen - offset2, str_enc);
        }
        if (match2 != null) {
            if (useBackref) {
                context.setBackRef(match2);
            }
        } else {
            match2 = RubyRegexp.createMatchData19(context, this, matcher, pattern);
            match2.regexp = regexp2;
            if (useBackref) {
                context.setBackRef(match2);
            }
        }
        if (bang) {
            this.view(dest.value);
            this.setCodeRange(dest.getCodeRange());
            return this.infectBy(tuFlags);
        }
        return dest.infectBy(tuFlags | this.flags);
    }

    public IRubyObject index(ThreadContext context, IRubyObject arg0) {
        return this.index19(context, arg0);
    }

    public IRubyObject index(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        return this.index19(context, arg0, arg1);
    }

    @JRubyMethod(name={"index"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF})
    public IRubyObject index19(ThreadContext context, IRubyObject arg0) {
        return this.indexCommon19(context.runtime, context, arg0, 0);
    }

    @JRubyMethod(name={"index"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF})
    public IRubyObject index19(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        int pos2 = RubyNumeric.num2int(arg1);
        Ruby runtime = context.runtime;
        if (pos2 < 0 && (pos2 += this.strLength()) < 0) {
            if (arg0 instanceof RubyRegexp) {
                context.setBackRef(runtime.getNil());
            }
            return runtime.getNil();
        }
        return this.indexCommon19(runtime, context, arg0, pos2);
    }

    private IRubyObject indexCommon19(Ruby runtime, ThreadContext context, IRubyObject sub2, int pos2) {
        if (sub2 instanceof RubyRegexp) {
            if (pos2 > this.strLength()) {
                return context.nil;
            }
            RubyRegexp regSub = (RubyRegexp)sub2;
            pos2 = this.singleByteOptimizable() ? pos2 : StringSupport.nth(this.checkEncoding(regSub), this.value.getUnsafeBytes(), this.value.getBegin(), this.value.getBegin() + this.value.getRealSize(), pos2) - this.value.getBegin();
            pos2 = regSub.adjustStartPos(this, pos2, false);
            pos2 = regSub.search19(context, this, pos2, false);
            pos2 = this.subLength(pos2);
        } else if (sub2 instanceof RubyString) {
            pos2 = StringSupport.index(this, (RubyString)sub2, pos2, this.checkEncoding((RubyString)sub2));
            pos2 = this.subLength(pos2);
        } else {
            IRubyObject tmp = sub2.checkStringType();
            if (tmp.isNil()) {
                throw runtime.newTypeError("type mismatch: " + sub2.getMetaClass().getName() + " given");
            }
            pos2 = StringSupport.index(this, (RubyString)tmp, pos2, this.checkEncoding((RubyString)tmp));
            pos2 = this.subLength(pos2);
        }
        return pos2 == -1 ? runtime.getNil() : RubyFixnum.newFixnum(runtime, pos2);
    }

    private int strseqIndex(RubyString sub2, int offset2, boolean inBytes) {
        int pos2;
        int slen;
        byte[] sBytes = this.value.unsafeBytes();
        boolean single_byte = this.singleByteOptimizable();
        Encoding enc = this.checkEncoding(sub2);
        if (sub2.isCodeRangeBroken()) {
            return -1;
        }
        int len = inBytes || single_byte ? this.value.realSize() : this.strLength();
        int n = slen = inBytes ? sub2.value.realSize() : sub2.strLength();
        if (offset2 < 0 && (offset2 += len) < 0) {
            return -1;
        }
        if (len - offset2 < slen) {
            return -1;
        }
        int s2 = this.value.begin();
        int e = s2 + this.value.realSize();
        if (offset2 != 0) {
            if (!inBytes) {
                offset2 = StringSupport.offset(enc, sBytes, s2, e, offset2, single_byte);
            }
            s2 += offset2;
        }
        if (slen == 0) {
            return offset2;
        }
        byte[] sptrBytes = sub2.value.unsafeBytes();
        int sptr = sub2.value.begin();
        slen = sub2.value.realSize();
        len = this.value.realSize() - offset2;
        while (true) {
            if ((pos2 = StringSupport.memsearch(sptrBytes, sptr, slen, sBytes, s2, len, enc)) < 0) {
                return pos2;
            }
            int t = enc.rightAdjustCharHead(sBytes, s2, s2 + pos2, e);
            if (t == s2 + pos2) break;
            if ((len -= t - s2) <= 0) {
                return -1;
            }
            offset2 += t - s2;
            s2 = t;
        }
        return pos2 + offset2;
    }

    public IRubyObject rindex(ThreadContext context, IRubyObject arg0) {
        return this.rindex19(context, arg0);
    }

    public IRubyObject rindex(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        return this.rindex19(context, arg0, arg1);
    }

    @JRubyMethod(name={"rindex"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF})
    public IRubyObject rindex19(ThreadContext context, IRubyObject arg0) {
        return this.rindexCommon19(context.runtime, context, arg0, this.strLength());
    }

    @JRubyMethod(name={"rindex"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF})
    public IRubyObject rindex19(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        int pos2 = RubyNumeric.num2int(arg1);
        Ruby runtime = context.runtime;
        int length2 = this.strLength();
        if (pos2 < 0 && (pos2 += length2) < 0) {
            if (arg0 instanceof RubyRegexp) {
                context.setBackRef(runtime.getNil());
            }
            return runtime.getNil();
        }
        if (pos2 > length2) {
            pos2 = length2;
        }
        return this.rindexCommon19(runtime, context, arg0, pos2);
    }

    private IRubyObject rindexCommon19(Ruby runtime, ThreadContext context, IRubyObject sub2, int pos2) {
        if (sub2 instanceof RubyRegexp) {
            RubyRegexp regSub = (RubyRegexp)sub2;
            pos2 = StringSupport.offset(this.value.getEncoding(), this.value.getUnsafeBytes(), this.value.getBegin(), this.value.getBegin() + this.value.getRealSize(), pos2, this.singleByteOptimizable());
            if (regSub.length() > 0) {
                pos2 = regSub.search19(context, this, pos2, true);
                pos2 = this.subLength(pos2);
            }
        } else if (sub2 instanceof RubyString) {
            Encoding enc = this.checkEncoding((RubyString)sub2);
            pos2 = StringSupport.rindex(this.value, StringSupport.strLengthFromRubyString(this, enc), StringSupport.strLengthFromRubyString((RubyString)sub2, enc), pos2, (RubyString)sub2, this.checkEncoding((RubyString)sub2));
        } else {
            IRubyObject tmp = sub2.checkStringType();
            if (tmp.isNil()) {
                throw runtime.newTypeError("type mismatch: " + sub2.getMetaClass().getName() + " given");
            }
            pos2 = StringSupport.rindex(this.value, StringSupport.strLengthFromRubyString(this, this.checkEncoding((RubyString)tmp)), StringSupport.strLengthFromRubyString((RubyString)tmp, this.checkEncoding((RubyString)tmp)), pos2, (RubyString)tmp, this.checkEncoding((RubyString)tmp));
        }
        if (pos2 >= 0) {
            return RubyFixnum.newFixnum(runtime, pos2);
        }
        return runtime.getNil();
    }

    @Deprecated
    public final IRubyObject substr(int beg, int len) {
        return this.substr(this.getRuntime(), beg, len);
    }

    public final IRubyObject substr(Ruby runtime, int beg, int len) {
        int length2 = this.value.length();
        if (len < 0 || beg > length2) {
            return runtime.getNil();
        }
        if (beg < 0 && (beg += length2) < 0) {
            return runtime.getNil();
        }
        int end2 = Math.min(length2, beg + len);
        return this.makeShared19(runtime, beg, end2 - beg);
    }

    private IRubyObject byteSubstr(Ruby runtime, int beg, int len) {
        int length2 = this.value.length();
        if (len < 0 || beg > length2) {
            return runtime.getNil();
        }
        if (beg < 0 && (beg += length2) < 0) {
            return runtime.getNil();
        }
        if (beg + len > length2) {
            len = length2 - beg;
        }
        if (len <= 0) {
            len = 0;
        }
        return this.makeShared19(runtime, beg, len);
    }

    private IRubyObject byteARef(Ruby runtime, IRubyObject idx) {
        int index2;
        if (idx instanceof RubyRange) {
            int[] begLen = ((RubyRange)idx).begLenInt(this.getByteList().length(), 0);
            return begLen == null ? runtime.getNil() : this.byteSubstr(runtime, begLen[0], begLen[1]);
        }
        if (idx instanceof RubyFixnum) {
            index2 = RubyNumeric.fix2int((RubyFixnum)idx);
        } else {
            ThreadContext context = runtime.getCurrentContext();
            JavaSites.StringSites sites = RubyString.sites(context);
            if (RubyRange.isRangeLike(context, idx, sites.respond_to_begin, sites.respond_to_end)) {
                RubyRange range = RubyRange.rangeFromRangeLike(context, idx, sites.begin, sites.end, sites.exclude_end);
                int[] begLen = range.begLenInt(this.getByteList().length(), 0);
                return begLen == null ? runtime.getNil() : this.byteSubstr(runtime, begLen[0], begLen[1]);
            }
            index2 = RubyNumeric.num2int(idx);
        }
        IRubyObject obj = this.byteSubstr(runtime, index2, 1);
        if (obj.isNil() || ((RubyString)obj).getByteList().length() == 0) {
            return runtime.getNil();
        }
        return obj;
    }

    public final IRubyObject substr19(Ruby runtime, int beg, int len) {
        Encoding enc;
        if (len < 0) {
            return runtime.getNil();
        }
        int length2 = this.value.getRealSize();
        if (length2 == 0) {
            len = 0;
        }
        if (this.singleByteOptimizable(enc = this.value.getEncoding())) {
            if (beg > length2) {
                return runtime.getNil();
            }
            if (beg < 0 && (beg += length2) < 0) {
                return runtime.getNil();
            }
            if (beg + len > length2) {
                len = length2 - beg;
            }
            if (len <= 0) {
                beg = 0;
                len = 0;
            }
            return this.makeShared19(runtime, beg, len);
        }
        if (beg + len > length2) {
            len = length2 - beg;
        }
        return this.multibyteSubstr19(runtime, enc, len, beg, length2);
    }

    private IRubyObject multibyteSubstr19(Ruby runtime, Encoding enc, int len, int beg, int length2) {
        int p2;
        int s2 = this.value.getBegin();
        int end2 = s2 + length2;
        byte[] bytes2 = this.value.getUnsafeBytes();
        if (beg < 0) {
            if (len > -beg) {
                len = -beg;
            }
            if (-beg * enc.maxLength() < length2 >>> 3) {
                beg = -beg;
                int e = end2;
                while (beg-- > len && (e = enc.prevCharHead(bytes2, s2, e, e)) != -1) {
                }
                int p3 = e;
                if (p3 == -1) {
                    return runtime.getNil();
                }
                while (len-- > 0 && (p3 = enc.prevCharHead(bytes2, s2, p3, e)) != -1) {
                }
                if (p3 == -1) {
                    return runtime.getNil();
                }
                return this.makeShared19(runtime, p3 - s2, e - p3);
            }
            if ((beg += StringSupport.strLengthFromRubyString(this, enc)) < 0) {
                return runtime.getNil();
            }
        } else if (beg > 0 && beg > StringSupport.strLengthFromRubyString(this, enc)) {
            return runtime.getNil();
        }
        if (len == 0) {
            p2 = 0;
        } else if (this.isCodeRangeValid() && enc.isUTF8()) {
            p2 = StringSupport.utf8Nth(bytes2, s2, end2, beg);
            len = StringSupport.utf8Offset(bytes2, p2, end2, len);
        } else if (enc.isFixedWidth()) {
            int w = enc.maxLength();
            p2 = s2 + beg * w;
            if (p2 > end2) {
                p2 = end2;
                len = 0;
            } else {
                len = len * w > end2 - p2 ? end2 - p2 : (len *= w);
            }
        } else {
            p2 = StringSupport.nth(enc, bytes2, s2, end2, beg);
            len = p2 == end2 ? 0 : StringSupport.offset(enc, bytes2, p2, end2, len);
        }
        return this.makeShared19(runtime, p2 - s2, len);
    }

    private IRubyObject replaceInternal(int beg, int len, RubyString repl) {
        StringSupport.replaceInternal(beg, len, this, repl);
        return this.infectBy(repl);
    }

    private void replaceInternal19(int beg, int len, RubyString repl) {
        StringSupport.replaceInternal19(this.getRuntime(), beg, len, this, repl);
        this.infectBy(repl);
    }

    public IRubyObject op_aref(ThreadContext context, IRubyObject arg1, IRubyObject arg2) {
        return this.op_aref19(context, arg1, arg2);
    }

    public IRubyObject op_aref(ThreadContext context, IRubyObject arg2) {
        return this.op_aref19(context, arg2);
    }

    @JRubyMethod(name={"[]", "slice"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF})
    public IRubyObject op_aref19(ThreadContext context, IRubyObject arg1, IRubyObject arg2) {
        Ruby runtime = context.runtime;
        if (arg1 instanceof RubyRegexp) {
            return this.subpat19(runtime, context, (RubyRegexp)arg1, arg2);
        }
        return this.substr19(runtime, RubyNumeric.num2int(arg1), RubyNumeric.num2int(arg2));
    }

    @JRubyMethod(name={"[]", "slice"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF})
    public IRubyObject op_aref19(ThreadContext context, IRubyObject arg2) {
        Ruby runtime = context.runtime;
        if (arg2 instanceof RubyFixnum) {
            return this.op_aref19(runtime, RubyNumeric.fix2int((RubyFixnum)arg2));
        }
        if (arg2 instanceof RubyRegexp) {
            return this.subpat19(runtime, context, (RubyRegexp)arg2);
        }
        if (arg2 instanceof RubyString) {
            RubyString str = (RubyString)arg2;
            return StringSupport.index(this, str, 0, this.checkEncoding(str)) != -1 ? str.strDup(runtime) : runtime.getNil();
        }
        if (arg2 instanceof RubyRange) {
            int len = this.strLength();
            int[] begLen = ((RubyRange)arg2).begLenInt(len, 0);
            return begLen == null ? runtime.getNil() : this.substr19(runtime, begLen[0], begLen[1]);
        }
        JavaSites.StringSites sites = RubyString.sites(context);
        if (RubyRange.isRangeLike(context, arg2, sites.respond_to_begin, sites.respond_to_end)) {
            int len = this.strLength();
            RubyRange range = RubyRange.rangeFromRangeLike(context, arg2, sites.begin, sites.end, sites.exclude_end);
            int[] begLen = range.begLenInt(len, 0);
            return begLen == null ? runtime.getNil() : this.substr19(runtime, begLen[0], begLen[1]);
        }
        return this.op_aref19(runtime, RubyNumeric.num2int(arg2));
    }

    @JRubyMethod
    public IRubyObject byteslice(ThreadContext context, IRubyObject arg1, IRubyObject arg2) {
        return this.byteSubstr(context.runtime, RubyNumeric.num2int(arg1), RubyNumeric.num2int(arg2));
    }

    @JRubyMethod
    public IRubyObject byteslice(ThreadContext context, IRubyObject arg2) {
        return this.byteARef(context.runtime, arg2);
    }

    private IRubyObject op_aref19(Ruby runtime, int idx) {
        IRubyObject str = this.substr19(runtime, idx, 1);
        return !str.isNil() && ((RubyString)str).value.getRealSize() == 0 ? runtime.getNil() : str;
    }

    private int subpatSetCheck(Ruby runtime, int nth, Region regs) {
        int numRegs;
        int n = numRegs = regs == null ? 1 : regs.numRegs;
        if (nth < numRegs) {
            if (nth < 0) {
                if (-nth < numRegs) {
                    return nth + numRegs;
                }
            } else {
                return nth;
            }
        }
        throw runtime.newIndexError("index " + nth + " out of regexp");
    }

    private void subpatSet19(ThreadContext context, RubyRegexp regexp2, IRubyObject backref, IRubyObject repl) {
        int end2;
        int start2;
        int nth;
        Ruby runtime = context.runtime;
        int result2 = regexp2.search19(context, this, 0, false);
        if (result2 < 0) {
            throw runtime.newIndexError("regexp not matched");
        }
        RubyMatchData match2 = (RubyMatchData)context.getBackRef();
        int n = nth = backref == null ? 0 : this.subpatSetCheck(runtime, match2.backrefNumber(backref), match2.regs);
        if (match2.regs == null) {
            start2 = match2.begin;
            end2 = match2.end;
        } else {
            start2 = match2.regs.beg[nth];
            end2 = match2.regs.end[nth];
        }
        if (start2 == -1) {
            throw runtime.newIndexError("regexp group " + nth + " not matched");
        }
        RubyString replStr = repl.convertToString();
        Encoding enc = this.checkEncoding(replStr);
        this.replaceInternal(start2, end2 - start2, replStr);
        this.associateEncoding(enc);
    }

    private IRubyObject subpat19(Ruby runtime, ThreadContext context, RubyRegexp regex, IRubyObject backref) {
        int result2 = regex.search19(context, this, 0, false);
        if (result2 >= 0) {
            RubyMatchData match2 = (RubyMatchData)context.getBackRef();
            return RubyRegexp.nth_match(match2.backrefNumber(backref), match2);
        }
        return runtime.getNil();
    }

    private IRubyObject subpat19(Ruby runtime, ThreadContext context, RubyRegexp regex) {
        int result2 = regex.search19(context, this, 0, false);
        if (result2 >= 0) {
            return RubyRegexp.nth_match(0, context.getBackRef());
        }
        return runtime.getNil();
    }

    public IRubyObject op_aset(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        return this.op_aset19(context, arg0, arg1);
    }

    public IRubyObject op_aset(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        return this.op_aset19(context, arg0, arg1, arg2);
    }

    @JRubyMethod(name={"[]="}, reads={FrameField.BACKREF})
    public IRubyObject op_aset19(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        if (arg0 instanceof RubyFixnum) {
            return this.op_aset19(context, RubyNumeric.fix2int((RubyFixnum)arg0), arg1);
        }
        if (arg0 instanceof RubyRegexp) {
            this.subpatSet19(context, (RubyRegexp)arg0, null, arg1);
            return arg1;
        }
        if (arg0 instanceof RubyString) {
            RubyString orig = (RubyString)arg0;
            int beg = StringSupport.index(this, orig, 0, this.checkEncoding(orig));
            if (beg < 0) {
                throw context.runtime.newIndexError("string not matched");
            }
            beg = this.subLength(beg);
            this.replaceInternal19(beg, orig.strLength(), arg1.convertToString());
            return arg1;
        }
        if (arg0 instanceof RubyRange) {
            int[] begLen = ((RubyRange)arg0).begLenInt(this.strLength(), 2);
            this.replaceInternal19(begLen[0], begLen[1], arg1.convertToString());
            return arg1;
        }
        JavaSites.StringSites sites = RubyString.sites(context);
        if (RubyRange.isRangeLike(context, arg0, sites.respond_to_begin, sites.respond_to_end)) {
            RubyRange rng = RubyRange.rangeFromRangeLike(context, arg0, sites.begin, sites.end, sites.exclude_end);
            int[] begLen = rng.begLenInt(this.strLength(), 2);
            this.replaceInternal19(begLen[0], begLen[1], arg1.convertToString());
            return arg1;
        }
        return this.op_aset19(context, RubyNumeric.num2int(arg0), arg1);
    }

    private IRubyObject op_aset19(ThreadContext context, int idx, IRubyObject arg1) {
        StringSupport.replaceInternal19(context.runtime, idx, 1, this, arg1.convertToString());
        return arg1;
    }

    @JRubyMethod(name={"[]="}, reads={FrameField.BACKREF})
    public IRubyObject op_aset19(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        if (arg0 instanceof RubyRegexp) {
            this.subpatSet19(context, (RubyRegexp)arg0, arg1, arg2);
        } else {
            int beg = RubyNumeric.num2int(arg0);
            int len = RubyNumeric.num2int(arg1);
            this.checkLength(len);
            RubyString repl = arg2.convertToString();
            StringSupport.replaceInternal19(context.runtime, beg, len, this, repl);
        }
        return arg2;
    }

    @Deprecated
    public IRubyObject slice_bang19(ThreadContext context, IRubyObject arg0) {
        return this.slice_bang(context, arg0);
    }

    @Deprecated
    public IRubyObject slice_bang19(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        return this.slice_bang(context, arg0, arg1);
    }

    @JRubyMethod(name={"slice!"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF})
    public IRubyObject slice_bang(ThreadContext context, IRubyObject arg0) {
        IRubyObject result2 = this.op_aref19(context, arg0);
        if (result2.isNil()) {
            this.modifyCheck();
        } else {
            this.op_aset19(context, arg0, (IRubyObject)RubyString.newEmptyString(context.runtime));
        }
        return result2;
    }

    @JRubyMethod(name={"slice!"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF})
    public IRubyObject slice_bang(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        IRubyObject result2 = this.op_aref19(context, arg0, arg1);
        if (result2.isNil()) {
            this.modifyCheck();
        } else {
            this.op_aset19(context, arg0, arg1, RubyString.newEmptyString(context.runtime));
        }
        return result2;
    }

    @Deprecated
    public IRubyObject succ19(ThreadContext context) {
        return this.succ(context);
    }

    @Deprecated
    public IRubyObject succ_bang19() {
        return this.succ_bang();
    }

    @JRubyMethod(name={"succ", "next"})
    public IRubyObject succ(ThreadContext context) {
        Ruby runtime = context.runtime;
        RubyString str = this.value.getRealSize() > 0 ? new RubyString(runtime, this.getMetaClass(), StringSupport.succCommon(runtime, this.value)) : RubyString.newEmptyString(runtime, this.getType(), this.value.getEncoding());
        return str.infectBy(this);
    }

    @JRubyMethod(name={"succ!", "next!"})
    public IRubyObject succ_bang() {
        this.modifyCheck();
        if (this.value.getRealSize() > 0) {
            this.value = StringSupport.succCommon(this.getRuntime(), this.value);
            this.shareLevel = 0;
        }
        return this;
    }

    @Deprecated
    public final IRubyObject upto19(ThreadContext context, IRubyObject end2, Block block) {
        return this.upto(context, end2, block);
    }

    @Deprecated
    public final IRubyObject upto19(ThreadContext context, IRubyObject end2, IRubyObject excl, Block block) {
        return this.upto(context, end2, excl, block);
    }

    @JRubyMethod(name={"upto"})
    public final IRubyObject upto(ThreadContext context, IRubyObject end2, Block block) {
        Ruby runtime = context.runtime;
        return block.isGiven() ? this.uptoCommon(context, end2, false, block) : RubyEnumerator.enumeratorize(runtime, (IRubyObject)this, "upto", end2);
    }

    @JRubyMethod(name={"upto"})
    public final IRubyObject upto(ThreadContext context, IRubyObject end2, IRubyObject excl, Block block) {
        return block.isGiven() ? this.uptoCommon(context, end2, excl.isTrue(), block) : RubyEnumerator.enumeratorize(context.runtime, (IRubyObject)this, "upto", new IRubyObject[]{end2, excl});
    }

    final IRubyObject uptoCommon(ThreadContext context, IRubyObject arg2, boolean excl, Block block) {
        return this.uptoCommon(context, arg2, excl, block, false);
    }

    final IRubyObject uptoCommon(ThreadContext context, IRubyObject arg2, boolean excl, Block block, boolean asSymbol) {
        boolean isAscii;
        Ruby runtime = context.runtime;
        if (arg2 instanceof RubySymbol) {
            throw runtime.newTypeError("can't convert Symbol into String");
        }
        RubyString end2 = arg2.convertToString();
        Encoding enc = this.checkEncoding(end2);
        boolean bl = isAscii = this.scanForCodeRange() == 16 && end2.scanForCodeRange() == 16;
        if (this.value.getRealSize() == 1 && end2.value.getRealSize() == 1 && isAscii) {
            byte e;
            byte c = this.value.getUnsafeBytes()[this.value.getBegin()];
            if (c > (e = end2.value.getUnsafeBytes()[end2.value.getBegin()]) || excl && c == e) {
                return this;
            }
            do {
                RubyString s2 = new RubyString(runtime, runtime.getString(), RubyInteger.SINGLE_CHAR_BYTELISTS[c & 0xFF], enc, 16);
                s2.shareLevel = 2;
                block.yield(context, asSymbol ? runtime.newSymbol(s2.toString()) : s2);
                if (!excl && c == e) break;
                c = (byte)(c + 1);
            } while (!excl || c != e);
            return this;
        }
        if (isAscii && ASCII.isDigit((int)this.value.getUnsafeBytes()[this.value.getBegin()]) && ASCII.isDigit((int)end2.value.getUnsafeBytes()[end2.value.getBegin()])) {
            int s3;
            int send2 = s3 + this.value.getRealSize();
            byte[] bytes2 = this.value.getUnsafeBytes();
            for (s3 = this.value.getBegin(); s3 < send2; ++s3) {
                if (ASCII.isDigit(bytes2[s3] & 0xFF)) continue;
                return this.uptoCommonNoDigits(context, end2, excl, block, asSymbol);
            }
            send2 = s3 + end2.value.getRealSize();
            bytes2 = end2.value.getUnsafeBytes();
            for (s3 = end2.value.getBegin(); s3 < send2; ++s3) {
                if (ASCII.isDigit(bytes2[s3] & 0xFF)) continue;
                return this.uptoCommonNoDigits(context, end2, excl, block, asSymbol);
            }
            IRubyObject b2 = this.stringToInum19(10, false);
            IRubyObject e = end2.stringToInum19(10, false);
            RubyArray argsArr = RubyArray.newArray(runtime, RubyFixnum.newFixnum(runtime, this.value.length()), context.nil);
            if (b2 instanceof RubyFixnum && e instanceof RubyFixnum) {
                long el = RubyNumeric.fix2long(e);
                for (long bl2 = RubyNumeric.fix2long(b2); !(bl2 > el || excl && bl2 == el); ++bl2) {
                    argsArr.eltSetOk(1, (IRubyObject)RubyFixnum.newFixnum(runtime, bl2));
                    ByteList to = new ByteList(this.value.length() + 5);
                    Sprintf.sprintf(to, "%.*d", (IRubyObject)argsArr);
                    RubyString str = RubyString.newStringNoCopy(runtime, to, (Encoding)USASCIIEncoding.INSTANCE, 16);
                    block.yield(context, asSymbol ? runtime.newSymbol(str.toString()) : str);
                }
            } else {
                CallSite op;
                JavaSites.StringSites sites = RubyString.sites(context);
                CallSite callSite = op = excl ? sites.op_lt : sites.op_le;
                while (op.call(context, b2, b2, e).isTrue()) {
                    argsArr.eltSetOk(1, b2);
                    ByteList to = new ByteList(this.value.length() + 5);
                    Sprintf.sprintf(to, "%.*d", (IRubyObject)argsArr);
                    RubyString str = RubyString.newStringNoCopy(runtime, to, (Encoding)USASCIIEncoding.INSTANCE, 16);
                    block.yield(context, asSymbol ? runtime.newSymbol(str.toString()) : str);
                    b2 = sites.succ.call(context, b2, b2);
                }
            }
            return this;
        }
        return this.uptoCommonNoDigits(context, end2, excl, block, asSymbol);
    }

    private IRubyObject uptoCommonNoDigits(ThreadContext context, RubyString end2, boolean excl, Block block, boolean asSymbol) {
        Ruby runtime = context.runtime;
        int n = this.op_cmp(end2);
        if (n > 0 || excl && n == 0) {
            return this;
        }
        JavaSites.StringSites sites = RubyString.sites(context);
        CallSite succ2 = sites.succ;
        IRubyObject afterEnd = succ2.call(context, end2, end2);
        RubyString current2 = this.strDup(context.runtime);
        while (!current2.op_equal19(context, afterEnd).isTrue()) {
            IRubyObject next2 = null;
            if (excl || !current2.op_equal19(context, end2).isTrue()) {
                next2 = succ2.call(context, current2, current2);
            }
            block.yield(context, asSymbol ? runtime.newSymbol(current2.toString()) : current2);
            if (next2 == null) break;
            current2 = next2.convertToString();
            if ((!excl || !current2.op_equal19(context, end2).isTrue()) && current2.getByteList().length() <= end2.getByteList().length() && current2.getByteList().length() != 0) continue;
            break;
        }
        return this;
    }

    @Deprecated
    public final RubyBoolean include_p19(ThreadContext context, IRubyObject obj) {
        return this.include_p(context, obj);
    }

    @JRubyMethod(name={"include?"})
    public RubyBoolean include_p(ThreadContext context, IRubyObject obj) {
        Ruby runtime = context.runtime;
        RubyString coerced = obj.convertToString();
        return StringSupport.index(this, coerced, 0, this.checkEncoding(coerced)) == -1 ? runtime.getFalse() : runtime.getTrue();
    }

    @JRubyMethod
    public IRubyObject chr(ThreadContext context) {
        return this.substr19(context.runtime, 0, 1);
    }

    @JRubyMethod
    public IRubyObject getbyte(ThreadContext context, IRubyObject index2) {
        Ruby runtime = context.runtime;
        int i2 = RubyNumeric.num2int(index2);
        if (i2 < 0) {
            i2 += this.value.getRealSize();
        }
        if (i2 < 0 || i2 >= this.value.getRealSize()) {
            return runtime.getNil();
        }
        return RubyFixnum.newFixnum(runtime, this.value.getUnsafeBytes()[this.value.getBegin() + i2] & 0xFF);
    }

    @JRubyMethod
    public IRubyObject setbyte(ThreadContext context, IRubyObject index2, IRubyObject val) {
        int i2 = RubyNumeric.num2int(index2);
        int b2 = RubyNumeric.num2int(val);
        int normalizedIndex = this.checkIndexForRef(i2, this.value.getRealSize());
        this.modify19();
        this.value.getUnsafeBytes()[normalizedIndex] = (byte)b2;
        return val;
    }

    public IRubyObject to_i() {
        return this.to_i19();
    }

    public IRubyObject to_i(IRubyObject arg0) {
        return this.to_i19(arg0);
    }

    @JRubyMethod(name={"to_i"})
    public IRubyObject to_i19() {
        return this.stringToInum19(10, false);
    }

    @JRubyMethod(name={"to_i"})
    public IRubyObject to_i19(IRubyObject arg0) {
        long base = this.checkBase(arg0);
        return this.stringToInum19((int)base, false);
    }

    private long checkBase(IRubyObject arg0) {
        long base = arg0.convertToInteger().getLongValue();
        if (base < 0L) {
            throw this.getRuntime().newArgumentError("illegal radix " + base);
        }
        return base;
    }

    @Deprecated
    public IRubyObject stringToInum(int base, boolean badcheck) {
        ByteList s2 = this.value;
        return ConvertBytes.byteListToInum(this.getRuntime(), s2, base, badcheck);
    }

    public IRubyObject stringToInum19(int base, boolean badcheck) {
        ByteList s2 = this.value;
        if (!s2.getEncoding().isAsciiCompatible()) {
            throw this.getRuntime().newEncodingCompatibilityError("ASCII incompatible encoding: " + s2.getEncoding());
        }
        return ConvertBytes.byteListToInum19(this.getRuntime(), s2, base, badcheck);
    }

    public IRubyObject oct(ThreadContext context) {
        return this.oct19(context);
    }

    @JRubyMethod(name={"oct"})
    public IRubyObject oct19(ThreadContext context) {
        return this.stringToInum19(-8, false);
    }

    public IRubyObject hex(ThreadContext context) {
        return this.hex19(context);
    }

    @JRubyMethod(name={"hex"})
    public IRubyObject hex19(ThreadContext context) {
        return this.stringToInum19(16, false);
    }

    public IRubyObject to_f() {
        return this.to_f19();
    }

    @JRubyMethod(name={"to_f"})
    public IRubyObject to_f19() {
        return RubyNumeric.str2fnum(this.getRuntime(), this, false);
    }

    public RubyArray split(ThreadContext context) {
        return this.split19(context);
    }

    public RubyArray split(ThreadContext context, IRubyObject arg0) {
        return this.split19(context, arg0);
    }

    public RubyArray split(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        return this.split19(context, arg0, arg1);
    }

    private void populateCapturesForSplit(Ruby runtime, RubyArray result2, RubyMatchData match2) {
        for (int i2 = 1; i2 < match2.numRegs(); ++i2) {
            int beg = match2.begin(i2);
            if (beg == -1) continue;
            result2.append(this.makeShared19(runtime, beg, match2.end(i2) - beg));
        }
    }

    @JRubyMethod(name={"split"}, writes={FrameField.BACKREF})
    public RubyArray split19(ThreadContext context) {
        return this.split19(context, context.runtime.getNil());
    }

    @JRubyMethod(name={"split"}, writes={FrameField.BACKREF})
    public RubyArray split19(ThreadContext context, IRubyObject arg0) {
        return this.splitCommon19(arg0, false, 0, 0, context, true);
    }

    @JRubyMethod(name={"split"}, writes={FrameField.BACKREF})
    public RubyArray split19(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        int lim = RubyNumeric.num2int(arg1);
        if (lim <= 0) {
            return this.splitCommon19(arg0, false, lim, 1, context, true);
        }
        if (lim == 1) {
            return this.value.getRealSize() == 0 ? context.runtime.newArray() : context.runtime.newArray((IRubyObject)this);
        }
        return this.splitCommon19(arg0, true, lim, 1, context, true);
    }

    public RubyArray split19(IRubyObject spat, ThreadContext context, boolean useBackref) {
        return this.splitCommon19(spat, false, this.value.realSize(), 0, context, useBackref);
    }

    private RubyArray splitCommon19(IRubyObject spat, boolean limit2, int lim, int i2, ThreadContext context, boolean useBackref) {
        RubyArray result2;
        if (spat.isNil() && (spat = context.runtime.getGlobalVariables().get("$;")).isNil()) {
            result2 = this.awkSplit19(limit2, lim, i2);
        } else if ((spat = RubyString.getPatternQuoted(context, spat, false)) instanceof RubyString) {
            ByteList spatValue = ((RubyString)spat).value;
            int len = spatValue.getRealSize();
            Encoding spatEnc = spatValue.getEncoding();
            ((RubyString)spat).mustnotBroken(context);
            if (len == 0) {
                RubyRegexp pattern = RubyRegexp.newRegexpFromStr(context.runtime, (RubyString)spat, 0);
                result2 = this.regexSplit19(context, pattern, limit2, lim, i2, useBackref);
            } else {
                byte[] bytes2 = spatValue.getUnsafeBytes();
                int p2 = spatValue.getBegin();
                int c = spatEnc.isAsciiCompatible() ? (len == 1 ? bytes2[p2] & 0xFF : -1) : (len == StringSupport.preciseLength(spatEnc, bytes2, p2, p2 + len) ? spatEnc.mbcToCode(bytes2, p2, p2 + len) : -1);
                result2 = c == 32 ? this.awkSplit19(limit2, lim, i2) : this.stringSplit19(context, (RubyString)spat, limit2, lim, i2);
            }
        } else {
            result2 = this.regexSplit19(context, (RubyRegexp)spat, limit2, lim, i2, useBackref);
        }
        if (!limit2 && lim == 0) {
            while (result2.size() > 0 && ((RubyString)result2.eltInternal((int)(result2.size() - 1))).value.getRealSize() == 0) {
                result2.pop(context);
            }
        }
        return result2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private RubyArray regexSplit19(ThreadContext context, RubyRegexp pattern, boolean limit2, int lim, int i2, boolean useBackref) {
        int end2;
        IRubyObject[] iRubyObjectArray;
        Ruby runtime = context.runtime;
        int ptr = this.value.getBegin();
        int len = this.value.getRealSize();
        byte[] bytes2 = this.value.getUnsafeBytes();
        RubyArray result2 = runtime.newArray();
        Encoding enc = this.value.getEncoding();
        boolean captures2 = pattern.getPattern().numberOfCaptures() != 0;
        int beg = 0;
        boolean lastNull = false;
        int start2 = beg;
        if (useBackref) {
            iRubyObjectArray = null;
        } else {
            IRubyObject[] iRubyObjectArray2 = new IRubyObject[1];
            iRubyObjectArray = iRubyObjectArray2;
            iRubyObjectArray2[0] = context.nil;
        }
        IRubyObject[] holder = iRubyObjectArray;
        while ((end2 = pattern.search19(context, this, start2, false, holder)) >= 0) {
            RubyMatchData match2;
            block11: {
                RubyMatchData rubyMatchData = match2 = useBackref ? (RubyMatchData)context.getBackRef() : (RubyMatchData)holder[0];
                if (start2 == end2 && match2.begin(0) == match2.end(0)) {
                    if (len == 0) {
                        result2.append(RubyString.newEmptyString(runtime, this.getMetaClass()).infectBy(this));
                        break;
                    }
                    if (lastNull) {
                        result2.append(this.makeShared19(runtime, beg, StringSupport.length(enc, bytes2, ptr + beg, ptr + len)));
                        beg = start2;
                        break block11;
                    } else {
                        start2 = ptr + start2 == ptr + len ? ++start2 : (start2 += StringSupport.length(enc, bytes2, ptr + start2, ptr + len));
                        lastNull = true;
                        continue;
                    }
                }
                result2.append(this.makeShared19(runtime, beg, end2 - beg));
                start2 = beg = match2.end(0);
            }
            lastNull = false;
            if (captures2) {
                this.populateCapturesForSplit(runtime, result2, match2);
            }
            if (!limit2 || lim > ++i2) continue;
        }
        if (useBackref) {
            context.setBackRef(context.nil);
        } else {
            holder[0] = context.nil;
        }
        if (len > 0 && (limit2 || len > beg || lim < 0)) {
            result2.append(this.makeShared19(runtime, beg, len - beg));
        }
        return result2;
    }

    private RubyArray awkSplit19(boolean limit2, int lim, int i2) {
        int p2;
        Ruby runtime = this.getRuntime();
        RubyArray result2 = runtime.newArray();
        byte[] bytes2 = this.value.getUnsafeBytes();
        int ptr = p2 = this.value.getBegin();
        int len = this.value.getRealSize();
        int end2 = p2 + len;
        Encoding enc = this.value.getEncoding();
        boolean skip2 = true;
        int e = 0;
        int b2 = 0;
        boolean singlebyte = this.singleByteOptimizable(enc);
        while (p2 < end2) {
            int c;
            if (singlebyte) {
                c = bytes2[p2++] & 0xFF;
            } else {
                c = StringSupport.codePoint(runtime, enc, bytes2, p2, end2);
                p2 += StringSupport.length(enc, bytes2, p2, end2);
            }
            if (skip2) {
                if (enc.isSpace(c)) {
                    b2 = p2 - ptr;
                    continue;
                }
                e = p2 - ptr;
                skip2 = false;
                if (!limit2 || lim > i2) continue;
                break;
            }
            if (enc.isSpace(c)) {
                result2.append(this.makeShared19(runtime, b2, e - b2));
                skip2 = true;
                b2 = p2 - ptr;
                if (!limit2) continue;
                ++i2;
                continue;
            }
            e = p2 - ptr;
        }
        if (len > 0 && (limit2 || len > b2 || lim < 0)) {
            result2.append(this.makeShared19(runtime, b2, len - b2));
        }
        return result2;
    }

    private RubyArray stringSplit19(ThreadContext context, RubyString spat, boolean limit2, int lim, int i2) {
        int e;
        Ruby runtime = context.runtime;
        this.mustnotBroken(context);
        RubyArray result2 = runtime.newArray();
        Encoding enc = this.checkEncoding(spat);
        ByteList pattern = spat.value;
        byte[] patternBytes = pattern.getUnsafeBytes();
        int patternBegin = pattern.getBegin();
        int patternRealSize = pattern.getRealSize();
        byte[] bytes2 = this.value.getUnsafeBytes();
        int begin2 = this.value.getBegin();
        int realSize = this.value.getRealSize();
        int p2 = 0;
        while (p2 < realSize && (e = RubyString.indexOf(bytes2, begin2, realSize, patternBytes, patternBegin, patternRealSize, p2)) >= 0) {
            int t = enc.rightAdjustCharHead(bytes2, p2 + begin2, e + begin2, begin2 + realSize) - begin2;
            if (t != e) {
                p2 = t;
                continue;
            }
            result2.append(this.makeShared19(runtime, p2, e - p2));
            p2 = e + pattern.getRealSize();
            if (!limit2 || lim > ++i2) continue;
            break;
        }
        if (this.value.getRealSize() > 0 && (limit2 || this.value.getRealSize() > p2 || lim < 0)) {
            result2.append(this.makeShared19(runtime, p2, this.value.getRealSize() - p2));
        }
        return result2;
    }

    static int indexOf(byte[] source2, int sourceOffset, int sourceCount, byte[] target, int targetOffset, int targetCount, int fromIndex) {
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        byte first2 = target[targetOffset];
        int max2 = sourceOffset + (sourceCount - targetCount);
        for (int i2 = sourceOffset + fromIndex; i2 <= max2; ++i2) {
            if (source2[i2] != first2) {
                while (++i2 <= max2 && source2[i2] != first2) {
                }
            }
            if (i2 > max2) continue;
            int j = i2 + 1;
            int end2 = j + targetCount - 1;
            int k = targetOffset + 1;
            while (j < end2 && source2[j] == target[k]) {
                ++j;
                ++k;
            }
            if (j != end2) continue;
            return i2 - sourceOffset;
        }
        return -1;
    }

    private RubyString getStringForPattern(IRubyObject obj) {
        if (obj instanceof RubyString) {
            return (RubyString)obj;
        }
        IRubyObject val = obj.checkStringType();
        if (val.isNil()) {
            throw this.getRuntime().newTypeError("wrong argument type " + obj.getMetaClass() + " (expected Regexp)");
        }
        return (RubyString)val;
    }

    private RubyRegexp getPattern(IRubyObject obj) {
        if (obj instanceof RubyRegexp) {
            return (RubyRegexp)obj;
        }
        return RubyRegexp.newRegexpFromStr(this.getRuntime(), this.getStringForPattern(obj), 0);
    }

    private static IRubyObject getPatternQuoted(ThreadContext context, IRubyObject pat, boolean check2) {
        if (pat instanceof RubyRegexp) {
            return pat;
        }
        if (!(pat instanceof RubyString)) {
            IRubyObject val = pat.checkStringType19();
            if (val.isNil()) {
                TypeConverter.checkType(context, pat, context.runtime.getRegexp());
            }
            pat = val;
        }
        if (check2 && ((RubyString)pat).isBrokenString()) {
            throw context.runtime.newRegexpError("invalid byte sequence in " + ((RubyString)pat).getEncoding());
        }
        return pat;
    }

    public IRubyObject scan(ThreadContext context, IRubyObject arg2, Block block) {
        return this.scan19(context, arg2, block);
    }

    private IRubyObject populateCapturesForScan(Ruby runtime, Matcher matcher, int range, int tuFlags, boolean is19) {
        Region region = matcher.getRegion();
        RubyArray result2 = this.getRuntime().newArray(region.numRegs);
        for (int i2 = 1; i2 < region.numRegs; ++i2) {
            int beg = region.beg[i2];
            if (beg == -1) {
                result2.append(runtime.getNil());
                continue;
            }
            RubyString substr = is19 ? this.makeShared19(runtime, beg, region.end[i2] - beg) : this.makeShared(runtime, beg, region.end[i2] - beg);
            substr.infectBy(tuFlags);
            result2.append(substr);
        }
        return result2;
    }

    @JRubyMethod(name={"scan"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF})
    public IRubyObject scan19(ThreadContext context, IRubyObject pat, Block block) {
        IRubyObject result2;
        RubyString str = this;
        int last2 = -1;
        int prev = 0;
        int[] startp = new int[]{0};
        pat = RubyString.getPatternQuoted(context, pat, true);
        this.mustnotBroken(context);
        if (!block.isGiven()) {
            IRubyObject result3;
            RubyArray ary = null;
            while (!(result3 = RubyString.scanOnce(context, str, pat, startp)).isNil()) {
                last2 = prev;
                prev = startp[0];
                if (ary == null) {
                    ary = context.runtime.newArray(4);
                }
                ary.push(result3);
            }
            if (last2 >= 0) {
                RubyString.patternSearch(context, pat, str, last2, true);
            }
            return ary == null ? context.runtime.newEmptyArray() : ary;
        }
        byte[] pBytes = this.value.unsafeBytes();
        int len = this.value.realSize();
        while (!(result2 = RubyString.scanOnce(context, str, pat, startp)).isNil()) {
            last2 = prev;
            prev = startp[0];
            block.yieldSpecific(context, result2);
            str.modifyCheck(pBytes, len);
        }
        if (last2 >= 0) {
            RubyString.patternSearch(context, pat, str, last2, true);
        }
        return this;
    }

    private void mustnotBroken(ThreadContext context) {
        if (this.scanForCodeRange() == 48) {
            throw context.runtime.newArgumentError("invalid byte sequence in " + this.getEncoding());
        }
    }

    private static IRubyObject scanOnce(ThreadContext context, RubyString str, IRubyObject pat, int[] startp) {
        if (RubyString.patternSearch(context, pat, str, startp[0], true) >= 0) {
            RubyMatchData match2 = (RubyMatchData)context.getBackRef();
            int matchEnd = match2.end(0);
            if (match2.begin(0) == matchEnd) {
                Encoding enc = str.getEncoding();
                if (str.size() > matchEnd) {
                    ByteList strValue = str.value;
                    startp[0] = matchEnd + StringSupport.encFastMBCLen(strValue.unsafeBytes(), strValue.begin() + matchEnd, strValue.begin() + strValue.realSize(), enc);
                } else {
                    startp[0] = matchEnd + 1;
                }
            } else {
                startp[0] = matchEnd;
            }
            if (match2.numRegs() == 1) {
                return RubyRegexp.nth_match(0, match2);
            }
            int size2 = match2.numRegs();
            RubyArray result2 = RubyArray.newBlankArray(context.runtime, size2 - 1);
            int index2 = 0;
            for (int i2 = 1; i2 < size2; ++i2) {
                result2.store(index2++, RubyRegexp.nth_match(i2, match2));
            }
            return result2;
        }
        return context.nil;
    }

    private static int patternSearch(ThreadContext context, IRubyObject pattern, RubyString str, int pos2, boolean setBackrefStr) {
        if (pattern instanceof RubyString) {
            RubyString strPattern = (RubyString)pattern;
            int beg = str.strseqIndex(strPattern, pos2, true);
            if (setBackrefStr) {
                if (beg >= 0) {
                    RubyString.setBackRefString(context, str, beg, strPattern).infectBy(pattern);
                } else {
                    context.setBackRef(context.nil);
                }
            }
            return beg;
        }
        return ((RubyRegexp)pattern).search19(context, str, pos2, false);
    }

    private static RubyMatchData setBackRefString(ThreadContext context, RubyString str, int pos2, RubyString pattern) {
        IRubyObject m = context.getBackRef();
        RubyMatchData match2 = m == null || m.isNil() || ((RubyMatchData)m).used() ? new RubyMatchData(context.runtime) : (RubyMatchData)m;
        match2.initMatchData(context, str, pos2, pattern);
        context.setBackRef(match2);
        return match2;
    }

    @JRubyMethod(name={"start_with?"})
    public IRubyObject start_with_p(ThreadContext context) {
        return context.runtime.getFalse();
    }

    @JRubyMethod(name={"start_with?"})
    public IRubyObject start_with_p(ThreadContext context, IRubyObject arg2) {
        return this.start_with_pCommon(arg2) ? context.runtime.getTrue() : context.runtime.getFalse();
    }

    @JRubyMethod(name={"start_with?"}, rest=true)
    public IRubyObject start_with_p(ThreadContext context, IRubyObject[] args2) {
        for (int i2 = 0; i2 < args2.length; ++i2) {
            if (!this.start_with_pCommon(args2[i2])) continue;
            return context.runtime.getTrue();
        }
        return context.runtime.getFalse();
    }

    private boolean start_with_pCommon(IRubyObject arg2) {
        RubyString otherString = arg2.convertToString();
        this.checkEncoding(otherString);
        int otherLength = otherString.value.getRealSize();
        if (otherLength == 0) {
            return true;
        }
        if (this.value.getRealSize() < otherLength) {
            return false;
        }
        return this.value.startsWith(otherString.value);
    }

    @JRubyMethod(name={"end_with?"})
    public IRubyObject end_with_p(ThreadContext context) {
        return context.runtime.getFalse();
    }

    @JRubyMethod(name={"end_with?"})
    public IRubyObject end_with_p(ThreadContext context, IRubyObject arg2) {
        return this.end_with_pCommon(arg2) ? context.runtime.getTrue() : context.runtime.getFalse();
    }

    @JRubyMethod(name={"end_with?"}, rest=true)
    public IRubyObject end_with_p(ThreadContext context, IRubyObject[] args2) {
        for (int i2 = 0; i2 < args2.length; ++i2) {
            if (!this.end_with_pCommon(args2[i2])) continue;
            return context.runtime.getTrue();
        }
        return context.runtime.getFalse();
    }

    private boolean end_with_pCommon(IRubyObject tmp) {
        tmp = tmp.convertToString();
        ByteList tmpBL = ((RubyString)tmp).value;
        if (tmpBL.getRealSize() == 0) {
            return true;
        }
        Encoding enc = this.checkEncoding((RubyString)tmp);
        if (this.value.realSize() < tmpBL.realSize()) {
            return false;
        }
        int p2 = this.value.begin();
        int e = p2 + this.value.realSize();
        int s2 = e - tmpBL.realSize();
        if (enc.leftAdjustCharHead(this.value.unsafeBytes(), p2, s2, e) != s2) {
            return false;
        }
        return ByteList.memcmp((byte[])this.value.unsafeBytes(), (int)s2, (byte[])tmpBL.unsafeBytes(), (int)tmpBL.begin(), (int)tmpBL.realSize()) == 0;
    }

    private IRubyObject justify19(Ruby runtime, IRubyObject arg0, int jflag) {
        RubyString result2 = this.justifyCommon(runtime, SPACE_BYTELIST, 1, true, EncodingUtils.STR_ENC_GET(this), RubyFixnum.num2int(arg0), jflag);
        if (this.getCodeRange() != 48) {
            result2.setCodeRange(this.getCodeRange());
        }
        return result2;
    }

    private IRubyObject justify19(IRubyObject arg0, IRubyObject arg1, int jflag) {
        int cr;
        Ruby runtime = this.getRuntime();
        RubyString padStr = arg1.convertToString();
        ByteList pad = padStr.value;
        Encoding enc = this.checkEncoding(padStr);
        int padCharLen = StringSupport.strLengthFromRubyString(padStr, enc);
        if (pad.getRealSize() == 0 || padCharLen == 0) {
            throw runtime.newArgumentError("zero width padding");
        }
        int width = RubyFixnum.num2int(arg0);
        RubyString result2 = this.justifyCommon(runtime, pad, padCharLen, padStr.singleByteOptimizable(), enc, width, jflag);
        if (result2.strLength() > this.strLength()) {
            result2.infectBy(padStr);
        }
        if ((cr = CodeRangeSupport.codeRangeAnd(this.getCodeRange(), padStr.getCodeRange())) != 48) {
            result2.setCodeRange(cr);
        }
        return result2;
    }

    private RubyString justifyCommon(Ruby runtime, ByteList pad, int padCharLen, boolean padSinglebyte, Encoding enc, int width, int jflag) {
        int padPP;
        int len = StringSupport.strLengthFromRubyString(this, enc);
        if (width < 0 || len >= width) {
            return this.strDup(runtime);
        }
        int n = width - len;
        int llen = jflag == 108 ? 0 : (jflag == 114 ? n : n / 2);
        int rlen = n - llen;
        int padP = pad.getBegin();
        int padLen = pad.getRealSize();
        byte[] padBytes = pad.getUnsafeBytes();
        ByteList res = new ByteList(this.value.getRealSize() + n * padLen / padCharLen + 2);
        int p2 = res.getBegin();
        byte[] bytes2 = res.getUnsafeBytes();
        while (llen > 0) {
            if (padLen <= 1) {
                bytes2[p2++] = padBytes[padP];
                --llen;
                continue;
            }
            if (llen > padCharLen) {
                System.arraycopy(padBytes, padP, bytes2, p2, padLen);
                p2 += padLen;
                llen -= padCharLen;
                continue;
            }
            padPP = padSinglebyte ? padP + llen : StringSupport.nth(enc, padBytes, padP, padP + padLen, llen);
            n = padPP - padP;
            System.arraycopy(padBytes, padP, bytes2, p2, n);
            p2 += n;
            break;
        }
        System.arraycopy(this.value.getUnsafeBytes(), this.value.getBegin(), bytes2, p2, this.value.getRealSize());
        p2 += this.value.getRealSize();
        while (rlen > 0) {
            if (padLen <= 1) {
                bytes2[p2++] = padBytes[padP];
                --rlen;
                continue;
            }
            if (rlen > padCharLen) {
                System.arraycopy(padBytes, padP, bytes2, p2, padLen);
                p2 += padLen;
                rlen -= padCharLen;
                continue;
            }
            padPP = padSinglebyte ? padP + rlen : StringSupport.nth(enc, padBytes, padP, padP + padLen, rlen);
            n = padPP - padP;
            System.arraycopy(padBytes, padP, bytes2, p2, n);
            p2 += n;
            break;
        }
        res.setRealSize(p2);
        RubyString result2 = new RubyString(runtime, this.getMetaClass(), res);
        if (result2.strLength() > this.strLength()) {
            result2.infectBy(this);
        }
        result2.associateEncoding(enc);
        return result2;
    }

    public IRubyObject ljust(IRubyObject arg0) {
        return this.ljust19(arg0);
    }

    public IRubyObject ljust(IRubyObject arg0, IRubyObject arg1) {
        return this.ljust19(arg0, arg1);
    }

    @JRubyMethod(name={"ljust"})
    public IRubyObject ljust19(IRubyObject arg0) {
        return this.justify19(this.getRuntime(), arg0, 108);
    }

    @JRubyMethod(name={"ljust"})
    public IRubyObject ljust19(IRubyObject arg0, IRubyObject arg1) {
        return this.justify19(arg0, arg1, 108);
    }

    public IRubyObject rjust(IRubyObject arg0) {
        return this.rjust19(arg0);
    }

    public IRubyObject rjust(IRubyObject arg0, IRubyObject arg1) {
        return this.rjust19(arg0, arg1);
    }

    @JRubyMethod(name={"rjust"})
    public IRubyObject rjust19(IRubyObject arg0) {
        return this.justify19(this.getRuntime(), arg0, 114);
    }

    @JRubyMethod(name={"rjust"})
    public IRubyObject rjust19(IRubyObject arg0, IRubyObject arg1) {
        return this.justify19(arg0, arg1, 114);
    }

    public IRubyObject center(IRubyObject arg0) {
        return this.center19(arg0);
    }

    public IRubyObject center(IRubyObject arg0, IRubyObject arg1) {
        return this.center19(arg0, arg1);
    }

    @JRubyMethod(name={"center"})
    public IRubyObject center19(IRubyObject arg0) {
        return this.justify19(this.getRuntime(), arg0, 99);
    }

    @JRubyMethod(name={"center"})
    public IRubyObject center19(IRubyObject arg0, IRubyObject arg1) {
        return this.justify19(arg0, arg1, 99);
    }

    @JRubyMethod(reads={FrameField.BACKREF}, writes={FrameField.BACKREF})
    public IRubyObject partition(ThreadContext context, Block block) {
        return RubyEnumerable.partition(context, this, block);
    }

    @JRubyMethod(reads={FrameField.BACKREF}, writes={FrameField.BACKREF})
    public IRubyObject partition(ThreadContext context, IRubyObject arg2, Block block) {
        RubyString sep;
        int pos2;
        Ruby runtime = context.runtime;
        if (arg2 instanceof RubyRegexp) {
            RubyRegexp regex = (RubyRegexp)arg2;
            pos2 = regex.search19(context, this, 0, false);
            if (pos2 < 0) {
                return this.partitionMismatch(runtime);
            }
            sep = (RubyString)this.subpat19(runtime, context, regex);
            if (pos2 == 0 && sep.value.getRealSize() == 0) {
                return this.partitionMismatch(runtime);
            }
        } else {
            IRubyObject tmp = arg2.checkStringType();
            if (tmp.isNil()) {
                throw runtime.newTypeError("type mismatch: " + arg2.getMetaClass().getName() + " given");
            }
            sep = (RubyString)tmp;
            pos2 = StringSupport.index(this, sep, 0, this.checkEncoding(sep));
            if (pos2 < 0) {
                return this.partitionMismatch(runtime);
            }
        }
        return RubyArray.newArray(runtime, new IRubyObject[]{this.makeShared19(runtime, 0, pos2), sep, this.makeShared19(runtime, pos2 + sep.value.getRealSize(), this.value.getRealSize() - pos2 - sep.value.getRealSize())});
    }

    private IRubyObject partitionMismatch(Ruby runtime) {
        Encoding enc = this.getEncoding();
        return RubyArray.newArray(runtime, new IRubyObject[]{this, RubyString.newEmptyString(runtime, enc), RubyString.newEmptyString(runtime, enc)});
    }

    @JRubyMethod(name={"rpartition"}, reads={FrameField.BACKREF}, writes={FrameField.BACKREF})
    public IRubyObject rpartition(ThreadContext context, IRubyObject arg2) {
        RubyString sep;
        int pos2;
        Ruby runtime = context.runtime;
        if (arg2 instanceof RubyRegexp) {
            RubyRegexp regex = (RubyRegexp)arg2;
            pos2 = regex.search19(context, this, this.value.getRealSize(), true);
            if (pos2 < 0) {
                return this.rpartitionMismatch(runtime);
            }
            sep = (RubyString)RubyRegexp.nth_match(0, context.getBackRef());
        } else {
            IRubyObject tmp = arg2.checkStringType();
            if (tmp.isNil()) {
                throw runtime.newTypeError("type mismatch: " + arg2.getMetaClass().getName() + " given");
            }
            sep = (RubyString)tmp;
            pos2 = StringSupport.rindex(this.value, StringSupport.strLengthFromRubyString(this, this.checkEncoding(sep)), StringSupport.strLengthFromRubyString(sep, this.checkEncoding(sep)), this.subLength(this.value.getRealSize()), sep, this.checkEncoding(sep));
            if (pos2 < 0) {
                return this.rpartitionMismatch(runtime);
            }
        }
        return RubyArray.newArray(runtime, new IRubyObject[]{this.substr19(runtime, 0, pos2), sep, this.substr19(runtime, pos2 + sep.strLength(), this.value.getRealSize())});
    }

    private IRubyObject rpartitionMismatch(Ruby runtime) {
        Encoding enc = this.getEncoding();
        return RubyArray.newArray(runtime, new IRubyObject[]{RubyString.newEmptyString(runtime, enc), RubyString.newEmptyString(runtime, enc), this});
    }

    public IRubyObject chop(ThreadContext context) {
        return this.chop19(context);
    }

    public IRubyObject chop_bang(ThreadContext context) {
        return this.chop_bang19(context);
    }

    @JRubyMethod(name={"chop"})
    public IRubyObject chop19(ThreadContext context) {
        Ruby runtime = context.runtime;
        if (this.value.getRealSize() == 0) {
            return RubyString.newEmptyString(runtime, this.getMetaClass(), this.value.getEncoding()).infectBy(this);
        }
        return this.makeShared19(runtime, 0, StringSupport.choppedLength(this));
    }

    @JRubyMethod(name={"chop!"})
    public IRubyObject chop_bang19(ThreadContext context) {
        this.modifyAndKeepCodeRange();
        if (this.size() > 0) {
            int len = StringSupport.choppedLength(this);
            this.value.realSize(len);
            if (this.getCodeRange() != 16) {
                this.clearCodeRange();
            }
            return this;
        }
        return context.nil;
    }

    public RubyString chomp(ThreadContext context) {
        return this.chomp19(context);
    }

    public RubyString chomp(ThreadContext context, IRubyObject arg0) {
        return this.chomp19(context, arg0);
    }

    public IRubyObject chomp_bang(ThreadContext context) {
        return this.chomp_bang19(context);
    }

    public IRubyObject chomp_bang(ThreadContext context, IRubyObject arg0) {
        return this.chomp_bang19(context, arg0);
    }

    @JRubyMethod(name={"chomp"})
    public RubyString chomp19(ThreadContext context) {
        RubyString str = this.strDup(context.runtime);
        str.chomp_bang19(context);
        return str;
    }

    @JRubyMethod(name={"chomp"})
    public RubyString chomp19(ThreadContext context, IRubyObject arg0) {
        RubyString str = this.strDup(context.runtime);
        str.chomp_bang19(context, arg0);
        return str;
    }

    @JRubyMethod(name={"chomp!"})
    public IRubyObject chomp_bang19(ThreadContext context) {
        Ruby runtime = context.runtime;
        if (this.value.getRealSize() == 0) {
            return runtime.getNil();
        }
        IRubyObject rsObj = runtime.getGlobalVariables().get("$/");
        if (rsObj == runtime.getGlobalVariables().getDefaultSeparator()) {
            return this.smartChopBangCommon19(runtime);
        }
        return this.chompBangCommon19(runtime, rsObj);
    }

    @JRubyMethod(name={"chomp!"})
    public IRubyObject chomp_bang19(ThreadContext context, IRubyObject arg0) {
        this.modifyCheck();
        Ruby runtime = context.runtime;
        if (this.value.getRealSize() == 0) {
            return runtime.getNil();
        }
        return this.chompBangCommon19(runtime, arg0);
    }

    private IRubyObject chompBangCommon19(Ruby runtime, IRubyObject rsObj) {
        if (rsObj.isNil()) {
            return rsObj;
        }
        RubyString rs = rsObj.convertToString();
        int p2 = this.value.getBegin();
        int len = this.value.getRealSize();
        int end2 = p2 + len;
        byte[] bytes2 = this.value.getUnsafeBytes();
        int rslen = rs.value.getRealSize();
        if (rslen == 0) {
            while (len > 0 && bytes2[p2 + len - 1] == 10) {
                if (--len <= 0 || bytes2[p2 + len - 1] != 13) continue;
                --len;
            }
            if (len < this.value.getRealSize()) {
                this.keepCodeRange();
                this.view(0, len);
                return this;
            }
            return runtime.getNil();
        }
        if (rslen > len) {
            return runtime.getNil();
        }
        byte newline = rs.value.getUnsafeBytes()[rslen - 1];
        if (rslen == 1 && newline == 10) {
            return this.smartChopBangCommon19(runtime);
        }
        Encoding enc = this.checkEncoding(rs);
        if (rs.scanForCodeRange() == 48) {
            return runtime.getNil();
        }
        int pp = end2 - rslen;
        if (bytes2[p2 + len - 1] == newline && rslen <= 1 || this.value.endsWith(rs.value)) {
            if (enc.leftAdjustCharHead(bytes2, p2, pp, end2) != pp) {
                return runtime.getNil();
            }
            if (this.getCodeRange() != 16) {
                this.clearCodeRange();
            }
            this.view(0, this.value.getRealSize() - rslen);
            return this;
        }
        return runtime.getNil();
    }

    private IRubyObject smartChopBangCommon19(Ruby runtime) {
        int p2 = this.value.getBegin();
        int len = this.value.getRealSize();
        int end2 = p2 + len;
        byte[] bytes2 = this.value.getUnsafeBytes();
        Encoding enc = this.value.getEncoding();
        this.keepCodeRange();
        if (enc.minLength() > 1) {
            int pp = enc.leftAdjustCharHead(bytes2, p2, end2 - enc.minLength(), end2);
            if (enc.isNewLine(bytes2, pp, end2)) {
                end2 = pp;
            }
            if ((pp = end2 - enc.minLength()) >= p2 && StringSupport.preciseLength(enc, bytes2, pp = enc.leftAdjustCharHead(bytes2, p2, pp, end2), end2) > 0 && enc.mbcToCode(bytes2, pp, end2) == 13) {
                end2 = pp;
            }
            if (end2 == p2 + this.value.getRealSize()) {
                this.modifyCheck();
                return runtime.getNil();
            }
            len = end2 - p2;
            this.view(0, len);
        } else if (bytes2[p2 + len - 1] == 10) {
            if (--len > 0 && bytes2[p2 + len - 1] == 13) {
                --len;
            }
            this.view(0, len);
        } else if (bytes2[p2 + len - 1] == 13) {
            this.view(0, --len);
        } else {
            this.modifyCheck();
            return runtime.getNil();
        }
        return this;
    }

    public IRubyObject lstrip(ThreadContext context) {
        return this.lstrip19(context);
    }

    public IRubyObject lstrip_bang(ThreadContext context) {
        return this.lstrip_bang19(context);
    }

    @JRubyMethod(name={"lstrip"})
    public IRubyObject lstrip19(ThreadContext context) {
        RubyString str = this.strDup(context.runtime);
        str.lstrip_bang19(context);
        return str;
    }

    @JRubyMethod(name={"lstrip!"})
    public IRubyObject lstrip_bang19(ThreadContext context) {
        this.modifyCheck();
        ByteList value2 = this.value;
        if (value2.getRealSize() == 0) {
            return context.nil;
        }
        int s2 = value2.getBegin();
        int end2 = s2 + value2.getRealSize();
        byte[] bytes2 = value2.getUnsafeBytes();
        Encoding enc = EncodingUtils.STR_ENC_GET(this);
        IRubyObject result2 = this.singleByteOptimizable(enc) ? this.singleByteLStrip(context.runtime, bytes2, s2, end2) : this.multiByteLStrip(context.runtime, enc, bytes2, s2, end2);
        this.keepCodeRange();
        return result2;
    }

    private IRubyObject singleByteLStrip(Ruby runtime, byte[] bytes2, int s2, int end2) {
        int p2;
        for (p2 = s2; p2 < end2 && ASCII.isSpace(bytes2[p2] & 0xFF); ++p2) {
        }
        if (p2 > s2) {
            this.view(p2 - s2, end2 - p2);
            return this;
        }
        return runtime.getNil();
    }

    private IRubyObject multiByteLStrip(Ruby runtime, Encoding enc, byte[] bytes2, int s2, int end2) {
        int p2;
        int c;
        for (p2 = s2; p2 < end2 && ASCII.isSpace(c = StringSupport.codePoint(runtime, enc, bytes2, p2, end2)); p2 += StringSupport.codeLength(enc, c)) {
        }
        if (p2 > s2) {
            this.view(p2 - s2, end2 - p2);
            return this;
        }
        return runtime.getNil();
    }

    public IRubyObject rstrip(ThreadContext context) {
        return this.rstrip19(context);
    }

    public IRubyObject rstrip_bang(ThreadContext context) {
        return this.rstrip_bang19(context);
    }

    @JRubyMethod(name={"rstrip"})
    public IRubyObject rstrip19(ThreadContext context) {
        RubyString str = this.strDup(context.runtime);
        str.rstrip_bang19(context);
        return str;
    }

    @JRubyMethod(name={"rstrip!"})
    public IRubyObject rstrip_bang19(ThreadContext context) {
        this.modifyCheck();
        Ruby runtime = context.runtime;
        if (this.value.getRealSize() == 0) {
            return runtime.getNil();
        }
        this.checkDummyEncoding();
        Encoding enc = EncodingUtils.STR_ENC_GET(this);
        IRubyObject result2 = this.singleByteOptimizable(enc) ? this.singleByteRStrip19(runtime) : this.multiByteRStrip19(runtime, context);
        this.keepCodeRange();
        return result2;
    }

    private IRubyObject singleByteRStrip19(Ruby runtime) {
        int endp;
        byte[] bytes2 = this.value.getUnsafeBytes();
        int start2 = this.value.getBegin();
        int end2 = start2 + this.value.getRealSize();
        for (endp = end2 - 1; endp >= start2 && (bytes2[endp] == 0 || ASCII.isSpace(bytes2[endp] & 0xFF)); --endp) {
        }
        if (endp < end2 - 1) {
            this.view(0, endp - start2 + 1);
            return this;
        }
        return runtime.getNil();
    }

    private IRubyObject multiByteRStrip19(Ruby runtime, ThreadContext context) {
        int point;
        int prev;
        byte[] bytes2 = this.value.getUnsafeBytes();
        int start2 = this.value.getBegin();
        int end2 = start2 + this.value.getRealSize();
        Encoding enc = EncodingUtils.STR_ENC_GET(this);
        int endp = end2;
        while ((prev = enc.prevCharHead(bytes2, start2, endp, end2)) != -1 && ((point = StringSupport.codePoint(runtime, enc, bytes2, prev, end2)) == 0 || ASCII.isSpace(point))) {
            endp = prev;
        }
        if (endp < end2) {
            this.view(0, endp - start2);
            return this;
        }
        return runtime.getNil();
    }

    public IRubyObject strip(ThreadContext context) {
        return this.strip19(context);
    }

    public IRubyObject strip_bang(ThreadContext context) {
        return this.strip_bang19(context);
    }

    @JRubyMethod(name={"strip"})
    public IRubyObject strip19(ThreadContext context) {
        RubyString str = this.strDup(context.runtime);
        str.strip_bang19(context);
        return str;
    }

    @JRubyMethod(name={"strip!"})
    public IRubyObject strip_bang19(ThreadContext context) {
        this.modifyCheck();
        IRubyObject left2 = this.lstrip_bang19(context);
        IRubyObject right = this.rstrip_bang19(context);
        return left2.isNil() && right.isNil() ? context.runtime.getNil() : this;
    }

    public IRubyObject count(ThreadContext context) {
        return this.count19(context);
    }

    public IRubyObject count(ThreadContext context, IRubyObject arg2) {
        return this.count19(context, arg2);
    }

    public IRubyObject count(ThreadContext context, IRubyObject[] args2) {
        return this.count19(context, args2);
    }

    @JRubyMethod(name={"count"})
    public IRubyObject count19(ThreadContext context) {
        throw context.runtime.newArgumentError("wrong number of arguments");
    }

    @JRubyMethod(name={"count"})
    public IRubyObject count19(ThreadContext context, IRubyObject arg2) {
        int size2;
        int begin2;
        byte[] countBytes;
        Ruby runtime = context.runtime;
        RubyString countStr = arg2.convertToString();
        ByteList countValue = countStr.getByteList();
        Encoding enc = this.checkEncoding(countStr);
        if (countValue.length() == 1 && enc.isAsciiCompatible() && enc.isReverseMatchAllowed(countBytes = countValue.unsafeBytes(), begin2 = countValue.begin(), begin2 + (size2 = countValue.length())) && !this.isCodeRangeBroken()) {
            if (this.value.length() == 0) {
                return RubyFixnum.zero(runtime);
            }
            int n = 0;
            int[] len_p = new int[]{0};
            int c = EncodingUtils.encCodepointLength(runtime, countBytes, begin2, begin2 + size2, len_p, enc);
            byte[] bytes2 = this.value.unsafeBytes();
            int i2 = this.value.begin();
            int end2 = i2 + this.value.length();
            while (i2 < end2) {
                if ((bytes2[i2++] & 0xFF) != c) continue;
                ++n;
            }
            return RubyFixnum.newFixnum(runtime, n);
        }
        boolean[] table = new boolean[257];
        StringSupport.TrTables tables = StringSupport.trSetupTable(countValue, runtime, table, null, true, enc);
        return runtime.newFixnum(StringSupport.strCount(this.value, runtime, table, tables, enc));
    }

    @JRubyMethod(name={"count"}, required=1, rest=true)
    public IRubyObject count19(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime = context.runtime;
        if (this.value.length() == 0) {
            return RubyFixnum.zero(runtime);
        }
        RubyString countStr = args2[0].convertToString();
        Encoding enc = this.checkEncoding(countStr);
        boolean[] table = new boolean[257];
        StringSupport.TrTables tables = StringSupport.trSetupTable(countStr.value, runtime, table, null, true, enc);
        for (int i2 = 1; i2 < args2.length; ++i2) {
            countStr = args2[i2].convertToString();
            enc = this.checkEncoding(countStr);
            tables = StringSupport.trSetupTable(countStr.value, runtime, table, tables, false, enc);
        }
        return runtime.newFixnum(StringSupport.strCount(this.value, runtime, table, tables, enc));
    }

    public IRubyObject delete(ThreadContext context) {
        return this.delete19(context);
    }

    public IRubyObject delete(ThreadContext context, IRubyObject arg2) {
        return this.delete19(context, arg2);
    }

    public IRubyObject delete(ThreadContext context, IRubyObject[] args2) {
        return this.delete19(context, args2);
    }

    public IRubyObject delete_bang(ThreadContext context) {
        return this.delete_bang19(context);
    }

    public IRubyObject delete_bang(ThreadContext context, IRubyObject arg2) {
        return this.delete_bang19(context, arg2);
    }

    public IRubyObject delete_bang(ThreadContext context, IRubyObject[] args2) {
        return this.delete_bang19(context, args2);
    }

    @JRubyMethod(name={"delete"})
    public IRubyObject delete19(ThreadContext context) {
        throw context.runtime.newArgumentError("wrong number of arguments");
    }

    @JRubyMethod(name={"delete"})
    public IRubyObject delete19(ThreadContext context, IRubyObject arg2) {
        RubyString str = this.strDup(context.runtime);
        str.delete_bang19(context, arg2);
        return str;
    }

    @JRubyMethod(name={"delete"}, required=1, rest=true)
    public IRubyObject delete19(ThreadContext context, IRubyObject[] args2) {
        RubyString str = this.strDup(context.runtime);
        str.delete_bang19(context, args2);
        return str;
    }

    @JRubyMethod(name={"delete!"})
    public IRubyObject delete_bang19(ThreadContext context) {
        throw context.runtime.newArgumentError("wrong number of arguments");
    }

    @JRubyMethod(name={"delete!"})
    public IRubyObject delete_bang19(ThreadContext context, IRubyObject arg2) {
        Ruby runtime = context.runtime;
        if (this.value.getRealSize() == 0) {
            return runtime.getNil();
        }
        boolean[] squeeze = new boolean[257];
        RubyString otherStr = arg2.convertToString();
        Encoding enc = this.checkEncoding(otherStr);
        StringSupport.TrTables tables = StringSupport.trSetupTable(otherStr.value, runtime, squeeze, null, true, enc);
        if (StringSupport.delete_bangCommon19(this, runtime, squeeze, tables, enc) == null) {
            return runtime.getNil();
        }
        return this;
    }

    @JRubyMethod(name={"delete!"}, required=1, rest=true)
    public IRubyObject delete_bang19(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime = context.runtime;
        if (this.value.getRealSize() == 0) {
            return runtime.getNil();
        }
        Encoding enc = null;
        boolean[] squeeze = new boolean[257];
        StringSupport.TrTables tables = null;
        for (int i2 = 0; i2 < args2.length; ++i2) {
            RubyString otherStr = args2[i2].convertToString();
            enc = this.checkEncoding(otherStr);
            tables = StringSupport.trSetupTable(otherStr.value, runtime, squeeze, tables, i2 == 0, enc);
        }
        if (StringSupport.delete_bangCommon19(this, runtime, squeeze, tables, enc) == null) {
            return context.nil;
        }
        return this;
    }

    public IRubyObject squeeze(ThreadContext context) {
        return this.squeeze19(context);
    }

    public IRubyObject squeeze(ThreadContext context, IRubyObject arg2) {
        return this.squeeze19(context, arg2);
    }

    public IRubyObject squeeze(ThreadContext context, IRubyObject[] args2) {
        return this.squeeze19(context, args2);
    }

    public IRubyObject squeeze_bang(ThreadContext context) {
        return this.squeeze_bang19(context);
    }

    public IRubyObject squeeze_bang(ThreadContext context, IRubyObject arg2) {
        return this.squeeze_bang19(context, arg2);
    }

    public IRubyObject squeeze_bang(ThreadContext context, IRubyObject[] args2) {
        return this.squeeze_bang19(context, args2);
    }

    @JRubyMethod(name={"squeeze"})
    public IRubyObject squeeze19(ThreadContext context) {
        RubyString str = this.strDup(context.runtime);
        str.squeeze_bang19(context);
        return str;
    }

    @JRubyMethod(name={"squeeze"}, required=1)
    public IRubyObject squeeze19(ThreadContext context, IRubyObject arg2) {
        RubyString str = this.strDup(context.runtime);
        str.squeeze_bang19(context, arg2);
        return str;
    }

    @JRubyMethod(name={"squeeze"}, required=2, rest=true)
    public IRubyObject squeeze19(ThreadContext context, IRubyObject[] args2) {
        RubyString str = this.strDup(context.runtime);
        str.squeeze_bang19(context, args2);
        return str;
    }

    @JRubyMethod(name={"squeeze!"})
    public IRubyObject squeeze_bang19(ThreadContext context) {
        if (this.value.getRealSize() == 0) {
            this.modifyCheck();
            return context.nil;
        }
        Ruby runtime = context.runtime;
        boolean[] squeeze = new boolean[256];
        for (int i2 = 0; i2 < 256; ++i2) {
            squeeze[i2] = true;
        }
        this.modifyAndKeepCodeRange();
        if (this.singleByteOptimizable() ? !StringSupport.singleByteSqueeze(this.value, squeeze) : !StringSupport.multiByteSqueeze(runtime, this.value, squeeze, null, this.value.getEncoding(), false)) {
            return runtime.getNil();
        }
        return this;
    }

    @JRubyMethod(name={"squeeze!"}, required=1)
    public IRubyObject squeeze_bang19(ThreadContext context, IRubyObject arg2) {
        Ruby runtime = context.runtime;
        RubyString otherStr = arg2.convertToString();
        boolean[] squeeze = new boolean[257];
        StringSupport.TrTables tables = StringSupport.trSetupTable(otherStr.value, runtime, squeeze, null, true, this.checkEncoding(otherStr));
        this.modifyAndKeepCodeRange();
        if (this.singleByteOptimizable() && otherStr.singleByteOptimizable() ? !StringSupport.singleByteSqueeze(this.value, squeeze) : !StringSupport.multiByteSqueeze(runtime, this.value, squeeze, tables, this.value.getEncoding(), true)) {
            return runtime.getNil();
        }
        return this;
    }

    @JRubyMethod(name={"squeeze!"}, rest=true, required=2)
    public IRubyObject squeeze_bang19(ThreadContext context, IRubyObject[] args2) {
        if (this.value.getRealSize() == 0) {
            this.modifyCheck();
            return context.nil;
        }
        Ruby runtime = context.runtime;
        RubyString otherStr = args2[0].convertToString();
        Encoding enc = this.checkEncoding(otherStr);
        boolean[] squeeze = new boolean[257];
        StringSupport.TrTables tables = StringSupport.trSetupTable(otherStr.value, runtime, squeeze, null, true, enc);
        boolean singleByte = this.singleByteOptimizable() && otherStr.singleByteOptimizable();
        for (int i2 = 1; i2 < args2.length; ++i2) {
            otherStr = args2[i2].convertToString();
            enc = this.checkEncoding(otherStr);
            singleByte = singleByte && otherStr.singleByteOptimizable();
            tables = StringSupport.trSetupTable(otherStr.value, runtime, squeeze, tables, false, enc);
        }
        this.modifyAndKeepCodeRange();
        if (singleByte ? !StringSupport.singleByteSqueeze(this.value, squeeze) : !StringSupport.multiByteSqueeze(runtime, this.value, squeeze, tables, enc, true)) {
            return runtime.getNil();
        }
        return this;
    }

    public IRubyObject tr(ThreadContext context, IRubyObject src, IRubyObject repl) {
        return this.tr19(context, src, repl);
    }

    public IRubyObject tr_bang(ThreadContext context, IRubyObject src, IRubyObject repl) {
        return this.tr_bang19(context, src, repl);
    }

    @JRubyMethod(name={"tr"})
    public IRubyObject tr19(ThreadContext context, IRubyObject src, IRubyObject repl) {
        RubyString str = this.strDup(context.runtime);
        str.trTrans19(context, src, repl, false);
        return str;
    }

    @JRubyMethod(name={"tr!"})
    public IRubyObject tr_bang19(ThreadContext context, IRubyObject src, IRubyObject repl) {
        return this.trTrans19(context, src, repl, false);
    }

    private IRubyObject trTrans19(ThreadContext context, IRubyObject src, IRubyObject repl, boolean sflag) {
        Ruby runtime = context.runtime;
        RubyString replStr = repl.convertToString();
        ByteList replList = replStr.value;
        RubyString srcStr = src.convertToString();
        if (this.value.getRealSize() == 0) {
            return runtime.getNil();
        }
        if (replList.getRealSize() == 0) {
            return this.delete_bang19(context, src);
        }
        CodeRangeable ret = StringSupport.trTransHelper(runtime, this, srcStr, replStr, sflag);
        if (ret == null) {
            return runtime.getNil();
        }
        return (IRubyObject)((Object)ret);
    }

    public IRubyObject tr_s(ThreadContext context, IRubyObject src, IRubyObject repl) {
        return this.tr_s19(context, src, repl);
    }

    public IRubyObject tr_s_bang(ThreadContext context, IRubyObject src, IRubyObject repl) {
        return this.tr_s_bang19(context, src, repl);
    }

    @JRubyMethod(name={"tr_s"})
    public IRubyObject tr_s19(ThreadContext context, IRubyObject src, IRubyObject repl) {
        RubyString str = this.strDup(context.runtime);
        str.trTrans19(context, src, repl, true);
        return str;
    }

    @JRubyMethod(name={"tr_s!"})
    public IRubyObject tr_s_bang19(ThreadContext context, IRubyObject src, IRubyObject repl) {
        return this.trTrans19(context, src, repl, true);
    }

    public IRubyObject each_line(ThreadContext context, Block block) {
        return this.each_lineCommon(context, context.runtime.getGlobalVariables().get("$/"), block);
    }

    public IRubyObject each_line(ThreadContext context, IRubyObject arg2, Block block) {
        return this.each_lineCommon(context, arg2, block);
    }

    public IRubyObject each_lineCommon(ThreadContext context, IRubyObject sep, Block block) {
        Ruby runtime = context.runtime;
        if (sep.isNil()) {
            block.yield(context, this);
            return this;
        }
        RubyString sepStr = sep.convertToString();
        ByteList sepValue = sepStr.value;
        int rslen = sepValue.getRealSize();
        byte newline = rslen == 0 ? (byte)10 : sepValue.getUnsafeBytes()[sepValue.getBegin() + rslen - 1];
        int p2 = this.value.getBegin();
        int end2 = p2 + this.value.getRealSize();
        int ptr = p2;
        int s2 = p2;
        int len = this.value.getRealSize();
        byte[] bytes2 = this.value.getUnsafeBytes();
        p2 += rslen;
        while (p2 < end2) {
            if (rslen == 0 && bytes2[p2] == 10) {
                if (++p2 != end2 && bytes2[p2] == 10) {
                    while (p2 < end2 && bytes2[p2] == 10) {
                        ++p2;
                    }
                }
            } else if (ptr < p2 && bytes2[p2 - 1] == newline && (rslen <= 1 || ByteList.memcmp((byte[])sepValue.getUnsafeBytes(), (int)sepValue.getBegin(), (int)rslen, (byte[])bytes2, (int)(p2 - rslen), (int)rslen) == 0)) {
                block.yield(context, this.makeShared(runtime, s2 - ptr, p2 - s2).infectBy(this));
                this.modifyCheck(bytes2, len);
                s2 = p2;
            }
            ++p2;
        }
        if (s2 != end2) {
            if (p2 > end2) {
                p2 = end2;
            }
            block.yield(context, this.makeShared(runtime, s2 - ptr, p2 - s2).infectBy(this));
        }
        return this;
    }

    @JRubyMethod(name={"each_line"})
    public IRubyObject each_line19(ThreadContext context, Block block) {
        return StringSupport.rbStrEnumerateLines(this, context, "each_line", context.runtime.getGlobalVariables().get("$/"), block, false);
    }

    @JRubyMethod(name={"each_line"})
    public IRubyObject each_line19(ThreadContext context, IRubyObject arg2, Block block) {
        return StringSupport.rbStrEnumerateLines(this, context, "each_line", arg2, block, false);
    }

    public IRubyObject lines(ThreadContext context, Block block) {
        return this.lines20(context, block);
    }

    public IRubyObject lines(ThreadContext context, IRubyObject arg2, Block block) {
        return this.lines20(context, arg2, block);
    }

    @JRubyMethod(name={"lines"})
    public IRubyObject lines20(ThreadContext context, Block block) {
        return StringSupport.rbStrEnumerateLines(this, context, "lines", context.runtime.getGlobalVariables().get("$/"), block, true);
    }

    @JRubyMethod(name={"lines"})
    public IRubyObject lines20(ThreadContext context, IRubyObject arg2, Block block) {
        return StringSupport.rbStrEnumerateLines(this, context, "lines", arg2, block, true);
    }

    public RubyString each_byte(ThreadContext context, Block block) {
        Ruby runtime = context.runtime;
        for (int i2 = 0; i2 < this.value.length(); ++i2) {
            block.yield(context, runtime.newFixnum(this.value.get(i2) & 0xFF));
        }
        return this;
    }

    @JRubyMethod(name={"each_byte"})
    public IRubyObject each_byte19(ThreadContext context, Block block) {
        return this.enumerateBytes(context, "each_byte", block, false);
    }

    @JRubyMethod
    public IRubyObject bytes(ThreadContext context, Block block) {
        return this.enumerateBytes(context, "bytes", block, true);
    }

    @JRubyMethod(name={"each_char"})
    public IRubyObject each_char19(ThreadContext context, Block block) {
        return this.enumerateChars(context, "each_char", block, false);
    }

    @JRubyMethod(name={"chars"})
    public IRubyObject chars19(ThreadContext context, Block block) {
        return this.enumerateChars(context, "chars", block, true);
    }

    private RubyEnumerator.SizeFn eachCharSizeFn() {
        final RubyString self2 = this;
        return new RubyEnumerator.SizeFn(){

            @Override
            public IRubyObject size(IRubyObject[] args2) {
                return self2.length();
            }
        };
    }

    @JRubyMethod
    public IRubyObject each_codepoint(ThreadContext context, Block block) {
        return this.enumerateCodepoints(context, "each_codepoint", block, false);
    }

    @JRubyMethod
    public IRubyObject codepoints(ThreadContext context, Block block) {
        return this.enumerateCodepoints(context, "codepoints", block, true);
    }

    private IRubyObject enumerateChars(ThreadContext context, String name2, Block block, boolean wantarray) {
        RubyString str;
        Ruby runtime = context.runtime;
        RubyString orig = str = this;
        RubyArray ary = null;
        str = this.strDup(runtime);
        ByteList strByteList = str.getByteList();
        byte[] ptrBytes = strByteList.unsafeBytes();
        int ptr = strByteList.begin();
        int len = strByteList.getRealSize();
        Encoding enc = str.getEncoding();
        if (block.isGiven()) {
            if (wantarray) {
                runtime.getWarnings().warning("passing a block to String#chars is deprecated");
                wantarray = false;
            }
        } else if (wantarray) {
            ary = RubyArray.newArray(runtime, str.length().getLongValue());
        } else {
            return RubyEnumerator.enumeratorizeWithSize(context, this, name2, this.eachCharSizeFn());
        }
        switch (this.getCodeRange()) {
            case 16: 
            case 32: {
                int n;
                for (int i2 = 0; i2 < len; i2 += n) {
                    n = StringSupport.encFastMBCLen(ptrBytes, ptr + i2, ptr + len, enc);
                    IRubyObject substr = str.substr(runtime, i2, n);
                    if (wantarray) {
                        ary.push(substr);
                        continue;
                    }
                    block.yield(context, substr);
                }
                break;
            }
            default: {
                int n;
                for (int i3 = 0; i3 < len; i3 += n) {
                    n = StringSupport.length(enc, ptrBytes, ptr + i3, ptr + len);
                    IRubyObject substr = str.substr(runtime, i3, n);
                    if (wantarray) {
                        ary.push(substr);
                        continue;
                    }
                    block.yield(context, substr);
                }
            }
        }
        if (wantarray) {
            return ary;
        }
        return orig;
    }

    private IRubyObject enumerateCodepoints(ThreadContext context, String name2, Block block, boolean wantarray) {
        RubyString str;
        Ruby runtime = context.runtime;
        RubyString orig = str = this;
        RubyArray ary = null;
        if (this.singleByteOptimizable()) {
            return this.enumerateBytes(context, name2, block, wantarray);
        }
        str = RubyString.newString(runtime, str.getByteList().dup());
        ByteList strByteList = str.getByteList();
        byte[] ptrBytes = strByteList.unsafeBytes();
        int ptr = strByteList.begin();
        int end2 = ptr + strByteList.getRealSize();
        Encoding enc = EncodingUtils.STR_ENC_GET(str);
        if (block.isGiven()) {
            if (wantarray) {
                runtime.getWarnings().warning("passing a block to String#codepoints is deprecated");
                wantarray = false;
            }
        } else if (wantarray) {
            ary = RubyArray.newArray(runtime, str.length().getLongValue());
        } else {
            return RubyEnumerator.enumeratorizeWithSize(context, str, name2, this.eachCodepointSizeFn());
        }
        while (ptr < end2) {
            int c = StringSupport.codePoint(runtime, enc, ptrBytes, ptr, end2);
            int n = StringSupport.codeLength(enc, c);
            if (wantarray) {
                ary.push(RubyFixnum.newFixnum(runtime, c));
            } else {
                block.yield(context, RubyFixnum.newFixnum(runtime, c));
            }
            ptr += n;
        }
        if (wantarray) {
            return ary;
        }
        return orig;
    }

    private IRubyObject enumerateBytes(ThreadContext context, String name2, Block block, boolean wantarray) {
        Ruby runtime = context.runtime;
        RubyString str = this;
        RubyArray ary = null;
        if (block.isGiven()) {
            if (wantarray) {
                runtime.getWarnings().warning("passing a block to String#bytes is deprecated");
                wantarray = false;
            }
        } else if (wantarray) {
            ary = RubyArray.newBlankArray(runtime, str.size());
        } else {
            return RubyEnumerator.enumeratorizeWithSize(context, str, name2, this.eachByteSizeFn());
        }
        for (int i2 = 0; i2 < str.size(); ++i2) {
            RubyFixnum bite = RubyFixnum.newFixnum(runtime, str.getByteList().get(i2) & 0xFF);
            if (wantarray) {
                ary.store(i2, bite);
                continue;
            }
            block.yield(context, bite);
        }
        if (wantarray) {
            return ary;
        }
        return str;
    }

    private RubyEnumerator.SizeFn eachCodepointSizeFn() {
        final RubyString self2 = this;
        return new RubyEnumerator.SizeFn(){

            @Override
            public IRubyObject size(IRubyObject[] args2) {
                return self2.length();
            }
        };
    }

    private RubySymbol to_sym() {
        RubySymbol specialCaseIntern = this.checkSpecialCasesIntern(this.value);
        if (specialCaseIntern != null) {
            return specialCaseIntern;
        }
        RubySymbol symbol = this.getRuntime().getSymbolTable().getSymbol(this.value);
        if (symbol.getBytes() == this.value) {
            this.shareLevel = 2;
        }
        return symbol;
    }

    private RubySymbol checkSpecialCasesIntern(ByteList value2) {
        String[][] opTable = opTable19;
        for (int i2 = 0; i2 < opTable.length; ++i2) {
            String op = opTable[i2][1];
            if (!value2.toString().equals(op)) continue;
            return this.getRuntime().getSymbolTable().getSymbol(opTable[i2][0]);
        }
        return null;
    }

    public RubySymbol intern() {
        return this.intern19();
    }

    @JRubyMethod(name={"to_sym", "intern"})
    public RubySymbol intern19() {
        return this.to_sym();
    }

    @JRubyMethod
    public IRubyObject ord(ThreadContext context) {
        Ruby runtime = context.runtime;
        return RubyFixnum.newFixnum(runtime, StringSupport.codePoint(runtime, EncodingUtils.STR_ENC_GET(this), this.value.getUnsafeBytes(), this.value.getBegin(), this.value.getBegin() + this.value.getRealSize()));
    }

    @JRubyMethod
    public IRubyObject sum(ThreadContext context) {
        return this.sumCommon(context, 16L);
    }

    @JRubyMethod
    public IRubyObject sum(ThreadContext context, IRubyObject arg2) {
        return this.sumCommon(context, RubyNumeric.num2long(arg2));
    }

    public IRubyObject sumCommon(ThreadContext context, long bits) {
        Ruby runtime = context.runtime;
        byte[] bytes2 = this.value.getUnsafeBytes();
        int p2 = this.value.getBegin();
        int len = this.value.getRealSize();
        int end2 = p2 + len;
        if (bits >= 64L) {
            RubyFixnum one = RubyFixnum.one(runtime);
            IRubyObject sum2 = RubyFixnum.zero(runtime);
            JavaSites.StringSites sites = RubyString.sites(context);
            CallSite op_plus2 = sites.op_plus;
            while (p2 < end2) {
                this.modifyCheck(bytes2, len);
                sum2 = op_plus2.call(context, sum2, sum2, (IRubyObject)RubyFixnum.newFixnum(runtime, bytes2[p2++] & 0xFF));
            }
            if (bits != 0L) {
                IRubyObject mod = sites.op_lshift.call(context, (IRubyObject)one, (IRubyObject)one, (IRubyObject)RubyFixnum.newFixnum(runtime, bits));
                sum2 = sites.op_and.call(context, sum2, sum2, sites.op_minus.call(context, mod, mod, (IRubyObject)one));
            }
            return sum2;
        }
        long sum3 = 0L;
        while (p2 < end2) {
            this.modifyCheck(bytes2, len);
            sum3 += (long)(bytes2[p2++] & 0xFF);
        }
        return RubyFixnum.newFixnum(runtime, bits == 0L ? sum3 : sum3 & (1L << (int)bits) - 1L);
    }

    @JRubyMethod
    public IRubyObject to_c(ThreadContext context) {
        RubyRegexp underscore_pattern;
        Ruby runtime = context.runtime;
        RubyString underscore = runtime.newString(new ByteList(new byte[]{95}));
        IRubyObject s2 = this.gsubCommon19(context, null, underscore, null, underscore_pattern = RubyRegexp.newDummyRegexp(runtime, Numeric.ComplexPatterns.underscores_pat), false, 0, false);
        RubyArray a = RubyComplex.str_to_c_internal(context, s2);
        IRubyObject first2 = a.eltInternal(0);
        if (!first2.isNil()) {
            return first2;
        }
        return RubyComplex.newComplexCanonicalize(context, RubyFixnum.zero(runtime));
    }

    @JRubyMethod
    public IRubyObject to_r(ThreadContext context) {
        RubyRegexp underscore_pattern;
        Ruby runtime = context.runtime;
        RubyString underscore = runtime.newString(new ByteList(new byte[]{95}));
        IRubyObject s2 = this.gsubCommon19(context, null, underscore, null, underscore_pattern = RubyRegexp.newDummyRegexp(runtime, Numeric.ComplexPatterns.underscores_pat), false, 0, false);
        RubyArray a = RubyRational.str_to_r_internal(context, s2);
        IRubyObject first2 = a.eltInternal(0);
        if (!first2.isNil()) {
            return first2;
        }
        return RubyRational.newRationalCanonicalize(context, RubyFixnum.zero(runtime));
    }

    public static RubyString unmarshalFrom(UnmarshalStream input) throws IOException {
        RubyString result2 = RubyString.newString(input.getRuntime(), input.unmarshalString());
        input.registerLinkTarget(result2);
        return result2;
    }

    @JRubyMethod
    public RubyArray unpack(IRubyObject obj) {
        return Pack.unpack(this.getRuntime(), this.value, RubyString.stringValue((IRubyObject)obj).value);
    }

    public void empty() {
        this.value = ByteList.EMPTY_BYTELIST;
        this.shareLevel = 2;
    }

    @JRubyMethod
    public IRubyObject encoding(ThreadContext context) {
        return context.runtime.getEncodingService().getEncoding(this.value.getEncoding());
    }

    public IRubyObject encode_bang(ThreadContext context, IRubyObject arg0) {
        return this.encode_bang(context, new IRubyObject[]{arg0});
    }

    public IRubyObject encode_bang(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        return this.encode_bang(context, new IRubyObject[]{arg0, arg1});
    }

    public IRubyObject encode_bang(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        return this.encode_bang(context, new IRubyObject[]{arg0, arg1, arg2});
    }

    @JRubyMethod(name={"encode!"}, optional=3)
    public IRubyObject encode_bang(ThreadContext context, IRubyObject[] args2) {
        this.modify19();
        IRubyObject[] newstr_p = new IRubyObject[]{this};
        Encoding encindex = EncodingUtils.strTranscode(context, args2, newstr_p);
        if (encindex == null) {
            return this;
        }
        if (newstr_p[0] == this) {
            this.setEncoding(encindex);
            return this;
        }
        this.replace(newstr_p[0]);
        this.setEncoding(encindex);
        return this;
    }

    @JRubyMethod
    public IRubyObject encode(ThreadContext context) {
        return EncodingUtils.strEncode(context, this, new IRubyObject[0]);
    }

    @JRubyMethod
    public IRubyObject encode(ThreadContext context, IRubyObject arg2) {
        return EncodingUtils.strEncode(context, this, arg2);
    }

    @JRubyMethod
    public IRubyObject encode(ThreadContext context, IRubyObject toEncoding, IRubyObject arg2) {
        return EncodingUtils.strEncode(context, this, toEncoding, arg2);
    }

    @JRubyMethod
    public IRubyObject encode(ThreadContext context, IRubyObject toEncoding, IRubyObject forcedEncoding, IRubyObject opts) {
        return EncodingUtils.strEncode(context, this, toEncoding, forcedEncoding, opts);
    }

    @JRubyMethod
    public IRubyObject force_encoding(ThreadContext context, IRubyObject enc) {
        return this.force_encoding(EncodingUtils.rbToEncoding(context, enc));
    }

    private IRubyObject force_encoding(Encoding encoding2) {
        this.modifyCheck();
        this.modify19();
        this.associateEncoding(encoding2);
        this.clearCodeRange();
        return this;
    }

    @JRubyMethod(name={"valid_encoding?"})
    public IRubyObject valid_encoding_p(ThreadContext context) {
        return context.runtime.newBoolean(this.scanForCodeRange() != 48);
    }

    @JRubyMethod(name={"ascii_only?"})
    public IRubyObject ascii_only_p(ThreadContext context) {
        return context.runtime.newBoolean(this.scanForCodeRange() == 16);
    }

    @JRubyMethod
    public IRubyObject b(ThreadContext context) {
        ASCIIEncoding encoding2 = ASCIIEncoding.INSTANCE;
        RubyString dup2 = this.strDup(context.runtime);
        dup2.modify19();
        dup2.setEncoding((Encoding)encoding2);
        return dup2;
    }

    @JRubyMethod
    public IRubyObject scrub(ThreadContext context, Block block) {
        return this.scrub(context, context.nil, block);
    }

    @JRubyMethod
    public IRubyObject scrub(ThreadContext context, IRubyObject repl, Block block) {
        IRubyObject newStr = this.strScrub(context, repl, block);
        if (newStr.isNil()) {
            return this.strDup(context.runtime);
        }
        return newStr;
    }

    @JRubyMethod(name={"scrub!"})
    public IRubyObject scrub_bang(ThreadContext context, Block block) {
        return this.scrub_bang(context, context.nil, block);
    }

    @JRubyMethod(name={"scrub!"})
    public IRubyObject scrub_bang(ThreadContext context, IRubyObject repl, Block block) {
        IRubyObject newStr = this.strScrub(context, repl, block);
        if (!newStr.isNil()) {
            return this.replace(newStr);
        }
        return this;
    }

    @Override
    @JRubyMethod
    public IRubyObject freeze(ThreadContext context) {
        if (this.isFrozen()) {
            return this;
        }
        this.resize(this.size());
        return super.freeze(context);
    }

    public void setValue(CharSequence value2) {
        this.view(ByteList.plain((CharSequence)value2), false);
    }

    public void setValue(ByteList value2) {
        this.view(value2);
    }

    public CharSequence getValue() {
        return this.toString();
    }

    public byte[] getBytes() {
        return this.value.bytes();
    }

    @Override
    public ByteList getByteList() {
        return this.value;
    }

    public String getUnicodeValue() {
        return RubyEncoding.decodeUTF8(this.value.getUnsafeBytes(), this.value.getBegin(), this.value.getRealSize());
    }

    public static ByteList encodeBytelist(CharSequence value2, Encoding encoding2) {
        Charset charset = EncodingUtils.charsetForEncoding(encoding2);
        if (charset == null) {
            return EncodingUtils.transcodeString(value2.toString(), encoding2, 0);
        }
        byte[] bytes2 = charset == RubyEncoding.UTF8 ? RubyEncoding.encodeUTF8(value2) : (charset == RubyEncoding.UTF16 ? RubyEncoding.encodeUTF16(value2) : RubyEncoding.encode(value2, charset));
        return new ByteList(bytes2, encoding2, false);
    }

    @Override
    public Object toJava(Class target) {
        if (target.isAssignableFrom(String.class)) {
            return this.decodeString();
        }
        if (target.isAssignableFrom(ByteList.class)) {
            return this.value;
        }
        if (target == Character.class || target == Character.TYPE) {
            if (this.strLength() != 1) {
                throw this.getRuntime().newArgumentError("could not coerce string of length " + this.strLength() + " (!= 1) into a char");
            }
            return Character.valueOf(this.decodeString().charAt(0));
        }
        return super.toJava(target);
    }

    public IRubyObject strScrub(ThreadContext context, IRubyObject repl, Block block) {
        Ruby runtime = context.runtime;
        int cr = this.getCodeRange();
        IRubyObject buf = context.nil;
        int replen = -1;
        boolean tainted = false;
        if (block.isGiven()) {
            if (!repl.isNil()) {
                throw runtime.newArgumentError("both of block and replacement given");
            }
            replen = 0;
        }
        if (cr == 16 || cr == 32) {
            return context.nil;
        }
        Encoding enc = EncodingUtils.STR_ENC_GET(this);
        if (!repl.isNil()) {
            repl = EncodingUtils.strCompatAndValid(context, repl, enc);
            tainted |= repl.isTaint();
        }
        if (enc.isDummy()) {
            return context.nil;
        }
        Encoding encidx = enc;
        if (enc.isAsciiCompatible()) {
            int ret;
            boolean rep7bit_p;
            int rep;
            byte[] repBytes;
            byte[] pBytes = this.value.unsafeBytes();
            int p2 = this.value.begin();
            int e = p2 + this.value.getRealSize();
            int p1 = p2;
            if (block.isGiven()) {
                repBytes = null;
                rep = 0;
                replen = 0;
                rep7bit_p = false;
            } else if (!repl.isNil()) {
                repBytes = ((RubyString)repl).value.unsafeBytes();
                rep = ((RubyString)repl).value.begin();
                replen = ((RubyString)repl).value.getRealSize();
                rep7bit_p = ((RubyString)repl).getCodeRange() == 16;
            } else if (encidx == UTF8Encoding.INSTANCE) {
                repBytes = SCRUB_REPL_UTF8;
                rep = 0;
                replen = repBytes.length;
                rep7bit_p = false;
            } else {
                repBytes = SCRUB_REPL_ASCII;
                rep = 0;
                replen = repBytes.length;
                rep7bit_p = false;
            }
            cr = 16;
            p2 = StringSupport.searchNonAscii(pBytes, p2, e);
            if (p2 == -1) {
                p2 = e;
            }
            while (p2 < e && !StringSupport.MBCLEN_NEEDMORE_P(ret = enc.length(pBytes, p2, e))) {
                if (StringSupport.MBCLEN_CHARFOUND_P(ret)) {
                    cr = 32;
                    p2 += StringSupport.MBCLEN_CHARFOUND_LEN(ret);
                    continue;
                }
                if (!StringSupport.MBCLEN_INVALID_P(ret)) continue;
                int clen = enc.maxLength();
                if (buf.isNil()) {
                    buf = RubyString.newStringLight(runtime, this.value.getRealSize());
                }
                if (p2 > p1) {
                    ((RubyString)buf).cat(pBytes, p1, p2 - p1);
                }
                if (e - p2 < clen) {
                    clen = e - p2;
                }
                if (clen <= 2) {
                    clen = 1;
                } else {
                    int q = p2;
                    --clen;
                    while (clen > 1 && !StringSupport.MBCLEN_NEEDMORE_P(ret = enc.length(pBytes, q, q + clen))) {
                        if (StringSupport.MBCLEN_INVALID_P(ret)) {
                            // empty if block
                        }
                        --clen;
                    }
                }
                if (repBytes != null) {
                    ((RubyString)buf).cat(repBytes, rep, replen);
                    if (!rep7bit_p) {
                        cr = 32;
                    }
                } else {
                    repl = block.yieldSpecific(context, RubyString.newString(runtime, pBytes, p2, clen, enc));
                    repl = EncodingUtils.strCompatAndValid(context, repl, enc);
                    tainted |= repl.isTaint();
                    ((RubyString)buf).cat((RubyString)repl);
                    if (((RubyString)repl).getCodeRange() == 32) {
                        cr = 32;
                    }
                }
                p1 = p2 += clen;
                if ((p2 = StringSupport.searchNonAscii(pBytes, p2, e)) != -1) continue;
                p2 = e;
                break;
            }
            if (buf.isNil()) {
                if (p2 == e) {
                    this.setCodeRange(cr);
                    return context.nil;
                }
                buf = RubyString.newStringLight(runtime, this.value.getRealSize());
            }
            if (p1 < p2) {
                ((RubyString)buf).cat(pBytes, p1, p2 - p1);
            }
            if (p2 < e) {
                if (repBytes != null) {
                    ((RubyString)buf).cat(repBytes, rep, replen);
                    if (!rep7bit_p) {
                        cr = 32;
                    }
                } else {
                    repl = block.yieldSpecific(context, RubyString.newString(runtime, pBytes, p2, e - p2, enc));
                    repl = EncodingUtils.strCompatAndValid(context, repl, enc);
                    tainted |= repl.isTaint();
                    ((RubyString)buf).cat((RubyString)repl);
                    if (((RubyString)repl).getCodeRange() == 32) {
                        cr = 32;
                    }
                }
            }
        } else {
            int ret;
            int rep;
            byte[] repBytes;
            byte[] pBytes = this.value.unsafeBytes();
            int p3 = this.value.begin();
            int e = p3 + this.value.getRealSize();
            int p1 = p3;
            int mbminlen = enc.minLength();
            if (block.isGiven()) {
                repBytes = null;
                rep = 0;
                replen = 0;
            } else if (!repl.isNil()) {
                repBytes = ((RubyString)repl).value.unsafeBytes();
                rep = ((RubyString)repl).value.begin();
                replen = ((RubyString)repl).value.getRealSize();
            } else if (encidx == UTF16BEEncoding.INSTANCE) {
                repBytes = SCRUB_REPL_UTF16BE;
                rep = 0;
                replen = repBytes.length;
            } else if (encidx == UTF16LEEncoding.INSTANCE) {
                repBytes = SCRUB_REPL_UTF16LE;
                rep = 0;
                replen = repBytes.length;
            } else if (encidx == UTF32BEEncoding.INSTANCE) {
                repBytes = SCRUB_REPL_UTF32BE;
                rep = 0;
                replen = repBytes.length;
            } else if (encidx == UTF32LEEncoding.INSTANCE) {
                repBytes = SCRUB_REPL_UTF32LE;
                rep = 0;
                replen = repBytes.length;
            } else {
                repBytes = SCRUB_REPL_ASCII;
                rep = 0;
                replen = repBytes.length;
            }
            while (p3 < e && !StringSupport.MBCLEN_NEEDMORE_P(ret = StringSupport.preciseLength(enc, pBytes, p3, e))) {
                if (StringSupport.MBCLEN_CHARFOUND_P(ret)) {
                    p3 += StringSupport.MBCLEN_CHARFOUND_LEN(ret);
                    continue;
                }
                if (!StringSupport.MBCLEN_INVALID_P(ret)) continue;
                int q = p3;
                int clen = enc.maxLength();
                if (buf.isNil()) {
                    buf = RubyString.newStringLight(runtime, this.value.getRealSize());
                }
                if (p3 > p1) {
                    ((RubyString)buf).cat(pBytes, p1, p3 - p1);
                }
                if (e - p3 < clen) {
                    clen = e - p3;
                }
                if (clen <= mbminlen * 2) {
                    clen = mbminlen;
                } else {
                    clen -= mbminlen;
                    while (clen > mbminlen && !StringSupport.MBCLEN_NEEDMORE_P(ret = enc.length(pBytes, q, q + clen))) {
                        if (StringSupport.MBCLEN_INVALID_P(ret)) {
                            // empty if block
                        }
                        clen -= mbminlen;
                    }
                }
                if (repBytes != null) {
                    ((RubyString)buf).cat(repBytes, rep, replen);
                } else {
                    repl = block.yieldSpecific(context, RubyString.newString(runtime, pBytes, p3, clen, enc));
                    repl = EncodingUtils.strCompatAndValid(context, repl, enc);
                    tainted |= repl.isTaint();
                    ((RubyString)buf).cat((RubyString)repl);
                }
                p1 = p3 += clen;
            }
            if (buf.isNil()) {
                if (p3 == e) {
                    this.setCodeRange(32);
                    return context.nil;
                }
                buf = RubyString.newStringLight(runtime, this.value.getRealSize());
            }
            if (p1 < p3) {
                ((RubyString)buf).cat(pBytes, p1, p3 - p1);
            }
            if (p3 < e) {
                if (repBytes != null) {
                    ((RubyString)buf).cat(repBytes, rep, replen);
                } else {
                    repl = block.yieldSpecific(context, RubyString.newString(runtime, pBytes, p3, e - p3, enc));
                    repl = EncodingUtils.strCompatAndValid(context, repl, enc);
                    tainted |= repl.isTaint();
                    ((RubyString)buf).cat((RubyString)repl);
                }
            }
            cr = 32;
        }
        buf.setTaint(tainted | this.isTaint());
        ((RubyString)buf).setEncodingAndCodeRange(enc, cr);
        return buf;
    }

    public int rbStrOffset(int pos2) {
        return this.strOffset(pos2, StringSupport.isSingleByteOptimizable(this, this.getEncoding()));
    }

    private int strOffset(int nth, boolean singlebyte) {
        int p2 = this.value.begin();
        int size2 = this.value.realSize();
        int e = p2 + size2;
        int pp = StringSupport.nth(this.value.getEncoding(), this.value.unsafeBytes(), p2, e, nth, singlebyte);
        if (pp == -1) {
            return size2;
        }
        return pp - p2;
    }

    private static JavaSites.StringSites sites(ThreadContext context) {
        return context.sites.String;
    }

    @Deprecated
    public final RubyString strDup() {
        return this.strDup(this.getRuntime(), this.getMetaClass().getRealClass());
    }

    @Deprecated
    final RubyString strDup(RubyClass clazz) {
        return this.strDup(this.getRuntime(), this.getMetaClass());
    }

    @Deprecated
    public final void modify19(int length2) {
        this.modifyExpand(length2);
    }

    @Deprecated
    public RubyArray split19(ThreadContext context, IRubyObject arg0, boolean useBackref) {
        return this.splitCommon19(arg0, useBackref, this.flags, this.flags, context, useBackref);
    }

    private static final class EmptyByteListHolder {
        final ByteList bytes;
        final int cr;

        EmptyByteListHolder(Encoding enc) {
            this.bytes = new ByteList(ByteList.NULL_ARRAY, enc);
            this.cr = this.bytes.getEncoding().isAsciiCompatible() ? 16 : 32;
        }
    }
}

