/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.targets;

import com.headius.invokebinder.Signature;
import java.util.Stack;
import org.jruby.RubyModule;
import org.jruby.ir.IRScope;
import org.jruby.ir.targets.ClassData;
import org.jruby.ir.targets.IRBytecodeAdapter;
import org.jruby.ir.targets.MethodData;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.JavaNameMangler;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;

public abstract class JVM {
    Stack<ClassData> clsStack = new Stack();
    ClassWriter writer;
    public static final int CMP_EQ = 0;
    public static final Class OBJECT = IRubyObject.class;
    public static final Class OBJECT_ARRAY = IRubyObject[].class;
    public static final Class BLOCK = Block.class;
    public static final Class THREADCONTEXT = ThreadContext.class;
    public static final Class STATICSCOPE = StaticScope.class;
    public static final Class RUBY_MODULE = RubyModule.class;
    public static final Type OBJECT_TYPE = Type.getType((Class)OBJECT);
    public static final Type OBJECT_ARRAY_TYPE = Type.getType((Class)OBJECT_ARRAY);
    public static final Type BOOLEAN_TYPE = Type.BOOLEAN_TYPE;
    public static final Type DOUBLE_TYPE = Type.DOUBLE_TYPE;
    public static final Type LONG_TYPE = Type.LONG_TYPE;
    public static final Type BLOCK_TYPE = Type.getType((Class)BLOCK);
    public static final Type THREADCONTEXT_TYPE = Type.getType((Class)THREADCONTEXT);
    public static final Type STATICSCOPE_TYPE = Type.getType((Class)STATICSCOPE);
    public static final Type RUBY_MODULE_TYPE = Type.getType((Class)RUBY_MODULE);

    public byte[] code() {
        return this.writer.toByteArray();
    }

    public ClassVisitor cls() {
        return this.clsData().cls;
    }

    public ClassData clsData() {
        return this.clsStack.peek();
    }

    public MethodData methodData() {
        return this.clsData().methodData();
    }

    public abstract void pushscript(String var1, String var2);

    public void popclass() {
        this.clsStack.pop();
    }

    public IRBytecodeAdapter method() {
        return this.clsData().method();
    }

    public void pushmethod(String name2, IRScope scope, Signature signature, boolean specificArity) {
        this.clsData().pushmethod(name2, scope, signature, specificArity);
        this.method().startMethod();
    }

    public void popmethod() {
        this.clsData().popmethod();
    }

    public static String scriptToClass(String name2) {
        if (name2 == null || name2.length() == 0) {
            return "NullFilename";
        }
        if (name2.equals("-e")) {
            return "DashE";
        }
        return JavaNameMangler.mangledFilenameForStartupClasspath(name2);
    }
}

