/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.targets;

import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import org.jruby.RubyClass;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.targets.ClassSuperInvokeSite;
import org.jruby.ir.targets.InstanceSuperInvokeSite;
import org.jruby.ir.targets.InvokeSite;
import org.jruby.ir.targets.SelfInvokeSite;
import org.jruby.runtime.CallType;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JavaNameMangler;
import org.objectweb.asm.Handle;

public abstract class ResolvedSuperInvokeSite
extends SelfInvokeSite {
    protected final String superName;
    protected final boolean[] splatMap;
    public static final Handle BOOTSTRAP = new Handle(6, CodegenUtils.p(ResolvedSuperInvokeSite.class), "bootstrap", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, String.class));

    public ResolvedSuperInvokeSite(MethodType type2, String superName, String splatmapString) {
        super(type2, superName, CallType.SUPER);
        this.superName = superName;
        this.splatMap = IRRuntimeHelpers.decodeSplatmap(splatmapString);
    }

    public static CallSite bootstrap(MethodHandles.Lookup lookup, String name2, MethodType type2, String splatmapString) {
        ResolvedSuperInvokeSite site;
        String[] targetAndMethod = name2.split(":");
        String superName = JavaNameMangler.demangleMethodName(targetAndMethod[1]);
        switch (targetAndMethod[0]) {
            case "invokeInstanceSuper": {
                site = new InstanceSuperInvokeSite(type2, superName, splatmapString);
                break;
            }
            case "invokeClassSuper": {
                site = new ClassSuperInvokeSite(type2, superName, splatmapString);
                break;
            }
            default: {
                throw new RuntimeException("invalid super call: " + name2);
            }
        }
        return InvokeSite.bootstrap(site, lookup);
    }

    protected abstract RubyClass getSuperClass(RubyClass var1);
}

