/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.representations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.jruby.dirgra.DirectedGraph;
import org.jruby.dirgra.Edge;
import org.jruby.dirgra.ExplicitVertexID;
import org.jruby.ir.IRManager;
import org.jruby.ir.IRScope;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.BranchInstr;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.ExceptionRegionEndMarkerInstr;
import org.jruby.ir.instructions.ExceptionRegionStartMarkerInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.JumpInstr;
import org.jruby.ir.instructions.LabelInstr;
import org.jruby.ir.instructions.ReturnInstr;
import org.jruby.ir.instructions.ThrowExceptionInstr;
import org.jruby.ir.operands.Label;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.operands.WrappedIRClosure;
import org.jruby.ir.representations.BasicBlock;
import org.jruby.ir.representations.ExceptionRegion;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class CFG {
    private static final Logger LOG = LoggerFactory.getLogger(CFG.class);
    private IRScope scope;
    private Map<Label, BasicBlock> bbMap;
    private Map<BasicBlock, BasicBlock> rescuerMap;
    private BasicBlock entryBB;
    private BasicBlock exitBB;
    private BasicBlock globalEnsureBB;
    private DirectedGraph<BasicBlock> graph;
    private int nextBBId;
    LinkedList<BasicBlock> postOrderList;

    public CFG(IRScope scope) {
        this.scope = scope;
        this.graph = new DirectedGraph();
        this.bbMap = new HashMap<Label, BasicBlock>();
        this.rescuerMap = new HashMap<BasicBlock, BasicBlock>();
        this.nextBBId = 0;
        this.exitBB = null;
        this.entryBB = null;
        this.globalEnsureBB = null;
        this.postOrderList = null;
    }

    public int getNextBBID() {
        ++this.nextBBId;
        return this.nextBBId;
    }

    public IRManager getManager() {
        return this.scope.getManager();
    }

    public int getMaxNodeID() {
        return this.nextBBId;
    }

    public boolean bbIsProtected(BasicBlock b2) {
        return this.getRescuerBBFor(b2) != null;
    }

    public BasicBlock getBBForLabel(Label label2) {
        return this.bbMap.get(label2);
    }

    public BasicBlock getEntryBB() {
        return this.entryBB;
    }

    public BasicBlock getExitBB() {
        return this.exitBB;
    }

    public BasicBlock getGlobalEnsureBB() {
        return this.globalEnsureBB;
    }

    public LinkedList<BasicBlock> postOrderList() {
        if (this.postOrderList == null) {
            this.postOrderList = this.buildPostOrderList();
        }
        return this.postOrderList;
    }

    public Iterator<BasicBlock> getPostOrderTraverser() {
        return this.postOrderList().iterator();
    }

    public Iterator<BasicBlock> getReversePostOrderTraverser() {
        return this.postOrderList().descendingIterator();
    }

    public void resetState() {
        this.postOrderList = null;
    }

    public IRScope getScope() {
        return this.scope;
    }

    public int size() {
        return this.graph.size();
    }

    public Collection<BasicBlock> getBasicBlocks() {
        return this.graph.allData();
    }

    public Collection<BasicBlock> getSortedBasicBlocks() {
        return this.graph.getInorderData();
    }

    public void addEdge(BasicBlock source2, BasicBlock destination, Object type2) {
        this.graph.findOrCreateVertexFor((ExplicitVertexID)source2).addEdgeTo((ExplicitVertexID)destination, type2);
    }

    public int inDegree(BasicBlock b2) {
        return this.graph.findVertexFor((ExplicitVertexID)b2).inDegree();
    }

    public int outDegree(BasicBlock b2) {
        return this.graph.findVertexFor((ExplicitVertexID)b2).outDegree();
    }

    public Iterable<BasicBlock> getIncomingSources(BasicBlock block) {
        return this.graph.findVertexFor((ExplicitVertexID)block).getIncomingSourcesData();
    }

    public Iterable<Edge<BasicBlock>> getIncomingEdges(BasicBlock block) {
        return this.graph.findVertexFor((ExplicitVertexID)block).getIncomingEdges();
    }

    public BasicBlock getIncomingSourceOfType(BasicBlock block, Object type2) {
        return (BasicBlock)this.graph.findVertexFor((ExplicitVertexID)block).getIncomingSourceDataOfType(type2);
    }

    public BasicBlock getOutgoingDestinationOfType(BasicBlock block, Object type2) {
        return (BasicBlock)this.graph.findVertexFor((ExplicitVertexID)block).getOutgoingDestinationDataOfType(type2);
    }

    public Iterable<BasicBlock> getOutgoingDestinations(BasicBlock block) {
        return this.graph.findVertexFor((ExplicitVertexID)block).getOutgoingDestinationsData();
    }

    public Iterable<BasicBlock> getOutgoingDestinationsOfType(BasicBlock block, Object type2) {
        return this.graph.findVertexFor((ExplicitVertexID)block).getOutgoingDestinationsDataOfType(type2);
    }

    public Iterable<BasicBlock> getOutgoingDestinationsNotOfType(BasicBlock block, Object type2) {
        return this.graph.findVertexFor((ExplicitVertexID)block).getOutgoingDestinationsDataNotOfType(type2);
    }

    public Collection<Edge<BasicBlock>> getOutgoingEdges(BasicBlock block) {
        return this.graph.findVertexFor((ExplicitVertexID)block).getOutgoingEdges();
    }

    public BasicBlock getRescuerBBFor(BasicBlock block) {
        return this.rescuerMap.get(block);
    }

    public void addGlobalEnsureBB(BasicBlock geb) {
        assert (this.globalEnsureBB == null) : "CFG for scope " + this.getScope() + " already has a global ensure block.";
        this.addBasicBlock(geb);
        this.addEdge(geb, this.getExitBB(), (Object)EdgeType.EXIT);
        for (BasicBlock b2 : this.getBasicBlocks()) {
            if (b2 == geb || this.bbIsProtected(b2) || b2 == this.getEntryBB()) continue;
            this.addEdge(b2, geb, (Object)EdgeType.EXCEPTION);
            this.setRescuerBB(b2, geb);
        }
        this.globalEnsureBB = geb;
    }

    public void setRescuerBB(BasicBlock block, BasicBlock rescuerBlock) {
        this.rescuerMap.put(block, rescuerBlock);
    }

    public DirectedGraph<BasicBlock> build(Instr[] instrs) {
        BasicBlock firstBB;
        HashMap<Label, List<BasicBlock>> forwardRefs = new HashMap<Label, List<BasicBlock>>();
        ArrayList<BasicBlock> returnBBs = new ArrayList<BasicBlock>();
        ArrayList<BasicBlock> exceptionBBs = new ArrayList<BasicBlock>();
        Stack<ExceptionRegion> nestedExceptionRegions = new Stack<ExceptionRegion>();
        ArrayList<ExceptionRegion> allExceptionRegions = new ArrayList<ExceptionRegion>();
        this.entryBB = this.createBB(nestedExceptionRegions);
        BasicBlock currBB = firstBB = this.createBB(nestedExceptionRegions);
        boolean bbEnded = false;
        boolean nextBBIsFallThrough = true;
        for (Instr i2 : instrs) {
            BasicBlock newBB;
            Operation iop = i2.getOperation();
            if (iop == Operation.LABEL) {
                Label l = ((LabelInstr)i2).getLabel();
                newBB = this.createBB(l, nestedExceptionRegions);
                if (nextBBIsFallThrough) {
                    this.graph.addEdge((ExplicitVertexID)currBB, (ExplicitVertexID)newBB, (Object)EdgeType.FALL_THROUGH);
                }
                currBB = newBB;
                bbEnded = false;
                nextBBIsFallThrough = true;
                List frefs = (List)forwardRefs.get(l);
                if (frefs != null) {
                    for (BasicBlock b2 : frefs) {
                        this.graph.addEdge((ExplicitVertexID)b2, (ExplicitVertexID)newBB, (Object)EdgeType.REGULAR);
                    }
                }
            } else if (bbEnded && iop != Operation.EXC_REGION_END) {
                newBB = this.createBB(nestedExceptionRegions);
                if (nextBBIsFallThrough) {
                    this.graph.addEdge((ExplicitVertexID)currBB, (ExplicitVertexID)newBB, (Object)EdgeType.FALL_THROUGH);
                }
                currBB = newBB;
                bbEnded = false;
                nextBBIsFallThrough = true;
            }
            if (i2 instanceof ExceptionRegionStartMarkerInstr) {
                ExceptionRegionStartMarkerInstr ersmi = (ExceptionRegionStartMarkerInstr)i2;
                ExceptionRegion rr = new ExceptionRegion(ersmi.getFirstRescueBlockLabel(), currBB);
                rr.addBB(currBB);
                allExceptionRegions.add(rr);
                if (!nestedExceptionRegions.empty()) {
                    nestedExceptionRegions.peek().addNestedRegion(rr);
                }
                nestedExceptionRegions.push(rr);
                continue;
            }
            if (i2 instanceof ExceptionRegionEndMarkerInstr) {
                nestedExceptionRegions.pop().setEndBB(currBB);
                continue;
            }
            if (iop.endsBasicBlock()) {
                Label tgt;
                bbEnded = true;
                currBB.addInstr(i2);
                nextBBIsFallThrough = false;
                if (i2 instanceof BranchInstr) {
                    tgt = ((BranchInstr)i2).getJumpTarget();
                    nextBBIsFallThrough = true;
                } else if (i2 instanceof JumpInstr) {
                    tgt = ((JumpInstr)i2).getJumpTarget();
                } else if (iop.isReturn()) {
                    tgt = null;
                    returnBBs.add(currBB);
                } else if (i2 instanceof ThrowExceptionInstr) {
                    tgt = null;
                    exceptionBBs.add(currBB);
                } else {
                    throw new RuntimeException("Unhandled case in CFG builder for basic block ending instr: " + i2);
                }
                if (tgt == null) continue;
                this.addEdge(currBB, tgt, forwardRefs);
                continue;
            }
            if (iop == Operation.LABEL) continue;
            currBB.addInstr(i2);
        }
        for (ExceptionRegion rr : allExceptionRegions) {
            Label rescueLabel = rr.getFirstRescueBlockLabel();
            if (Label.UNRESCUED_REGION_LABEL.equals(rescueLabel)) continue;
            BasicBlock firstRescueBB = this.bbMap.get(rescueLabel);
            firstRescueBB.markRescueEntryBB();
            for (BasicBlock b3 : rr.getExclusiveBBs()) {
                this.setRescuerBB(b3, firstRescueBB);
                this.graph.addEdge((ExplicitVertexID)b3, (ExplicitVertexID)firstRescueBB, (Object)EdgeType.EXCEPTION);
            }
        }
        this.buildExitBasicBlock(nestedExceptionRegions, firstBB, returnBBs, exceptionBBs, nextBBIsFallThrough, currBB, this.entryBB);
        this.optimize(returnBBs);
        return this.graph;
    }

    private void addEdge(BasicBlock src, Label targetLabel, Map<Label, List<BasicBlock>> forwardRefs) {
        BasicBlock target = this.bbMap.get(targetLabel);
        if (target != null) {
            this.graph.addEdge((ExplicitVertexID)src, (ExplicitVertexID)target, (Object)EdgeType.REGULAR);
            return;
        }
        List<BasicBlock> forwardReferences = forwardRefs.get(targetLabel);
        if (forwardReferences == null) {
            forwardReferences = new ArrayList<BasicBlock>();
            forwardRefs.put(targetLabel, forwardReferences);
        }
        forwardReferences.add(src);
    }

    private BasicBlock buildExitBasicBlock(Stack<ExceptionRegion> nestedExceptionRegions, BasicBlock firstBB, List<BasicBlock> returnBBs, List<BasicBlock> exceptionBBs, boolean nextIsFallThrough, BasicBlock currBB, BasicBlock entryBB) {
        this.exitBB = this.createBB(nestedExceptionRegions);
        this.graph.addEdge((ExplicitVertexID)entryBB, (ExplicitVertexID)this.exitBB, (Object)EdgeType.EXIT);
        this.graph.addEdge((ExplicitVertexID)entryBB, (ExplicitVertexID)firstBB, (Object)EdgeType.FALL_THROUGH);
        for (BasicBlock rb : returnBBs) {
            this.graph.addEdge((ExplicitVertexID)rb, (ExplicitVertexID)this.exitBB, (Object)EdgeType.EXIT);
        }
        for (BasicBlock rb : exceptionBBs) {
            this.graph.addEdge((ExplicitVertexID)rb, (ExplicitVertexID)this.exitBB, (Object)EdgeType.EXIT);
        }
        if (nextIsFallThrough) {
            this.graph.addEdge((ExplicitVertexID)currBB, (ExplicitVertexID)this.exitBB, (Object)EdgeType.EXIT);
        }
        return this.exitBB;
    }

    private BasicBlock createBB(Label label2, Stack<ExceptionRegion> nestedExceptionRegions) {
        BasicBlock basicBlock = new BasicBlock(this, label2);
        this.addBasicBlock(basicBlock);
        if (label2.isGlobalEnsureBlockLabel()) {
            this.globalEnsureBB = basicBlock;
        }
        if (!nestedExceptionRegions.empty()) {
            nestedExceptionRegions.peek().addBB(basicBlock);
        }
        return basicBlock;
    }

    private BasicBlock createBB(Stack<ExceptionRegion> nestedExceptionRegions) {
        return this.createBB(this.scope.getNewLabel(), nestedExceptionRegions);
    }

    public void addBasicBlock(BasicBlock bb) {
        this.graph.findOrCreateVertexFor((ExplicitVertexID)bb);
        this.bbMap.put(bb.getLabel(), bb);
        this.postOrderList = null;
    }

    public void removeAllOutgoingEdgesForBB(BasicBlock b2) {
        this.graph.findVertexFor((ExplicitVertexID)b2).removeAllOutgoingEdges();
    }

    private void deleteOrphanedBlocks(DirectedGraph<BasicBlock> graph) {
        while (true) {
            BasicBlock bbToRemove = null;
            for (BasicBlock b2 : graph.allData()) {
                if (b2 == this.entryBB || !graph.findVertexFor((ExplicitVertexID)b2).getIncomingEdges().isEmpty()) continue;
                bbToRemove = b2;
                break;
            }
            if (bbToRemove == null) break;
            this.removeBB(bbToRemove);
            this.removeNestedScopesFromBB(bbToRemove);
        }
    }

    private boolean mergeBBs(BasicBlock a, BasicBlock b2) {
        BasicBlock bR;
        BasicBlock aR = this.getRescuerBBFor(a);
        if (aR == (bR = this.getRescuerBBFor(b2)) || a.isEmpty() || b2.isEmpty()) {
            Instr lastInstr = a.getLastInstr();
            if (lastInstr instanceof JumpInstr) {
                a.removeInstr(lastInstr);
            }
            a.swallowBB(b2);
            this.removeEdge(a, b2);
            for (Edge<BasicBlock> e : this.getOutgoingEdges(b2)) {
                this.addEdge(a, (BasicBlock)e.getDestination().getData(), e.getType());
            }
            this.removeBB(b2);
            if (aR == null && bR != null) {
                this.setRescuerBB(a, bR);
            }
            return true;
        }
        return false;
    }

    public void removeBB(BasicBlock b2) {
        if (b2 == this.globalEnsureBB) {
            this.globalEnsureBB = null;
        }
        this.graph.removeVertexFor((ExplicitVertexID)b2);
        this.bbMap.remove(b2.getLabel());
        this.rescuerMap.remove(b2);
    }

    private void removeNestedScopesFromBB(BasicBlock bb) {
        block0: for (Instr instr : bb.getInstrs()) {
            for (Operand oper : instr.getOperands()) {
                if (!(oper instanceof WrappedIRClosure)) continue;
                this.scope.removeClosure(((WrappedIRClosure)oper).getClosure());
                continue block0;
            }
        }
    }

    public void collapseStraightLineBBs() {
        ArrayList<BasicBlock> cfgBBs = new ArrayList<BasicBlock>();
        for (BasicBlock b2 : this.getBasicBlocks()) {
            cfgBBs.add(b2);
        }
        HashSet<BasicBlock> mergedBBs = new HashSet<BasicBlock>();
        for (BasicBlock b3 : cfgBBs) {
            if (mergedBBs.contains(b3) || this.outDegree(b3) != 1) continue;
            for (Edge<BasicBlock> e : this.getOutgoingEdges(b3)) {
                BasicBlock outB = (BasicBlock)e.getDestination().getData();
                if (e.getType() == EdgeType.EXCEPTION || this.inDegree(outB) != 1 || !this.mergeBBs(b3, outB)) continue;
                mergedBBs.add(outB);
            }
        }
    }

    private void optimize(List<BasicBlock> returnBBs) {
        ArrayList<Object> toRemove = new ArrayList<Object>();
        for (BasicBlock basicBlock : returnBBs) {
            Operand rv;
            List<Instr> rbInstrs = basicBlock.getInstrs();
            Instr first2 = rbInstrs.get(0);
            if (!(first2 instanceof ReturnInstr) || !((rv = ((ReturnInstr)first2).getReturnValue()) instanceof Variable)) continue;
            for (Edge<BasicBlock> e : this.getIncomingEdges(basicBlock)) {
                BasicBlock srcBB = (BasicBlock)e.getSource().getData();
                List<Instr> srcInstrs = srcBB.getInstrs();
                int n = srcInstrs.size();
                if (n == 0) continue;
                Instr jump = null;
                Instr last2 = srcInstrs.get(n - 1);
                if (last2 instanceof JumpInstr && n > 2) {
                    jump = last2;
                    last2 = srcInstrs.get(n - 2);
                }
                if (!(last2 instanceof CopyInstr) || !((CopyInstr)last2).getResult().equals(rv)) continue;
                srcInstrs.set(n - 1, new ReturnInstr(((CopyInstr)last2).getSource()));
                toRemove.add(e);
                this.addEdge(srcBB, this.exitBB, (Object)EdgeType.EXIT);
                if (jump == null) continue;
                srcInstrs.remove(jump);
            }
        }
        for (Edge edge : toRemove) {
            this.graph.removeEdge(edge);
        }
        toRemove = new ArrayList();
        for (BasicBlock basicBlock : this.graph.allData()) {
            boolean noExceptions = true;
            for (Instr i2 : basicBlock.getInstrs()) {
                if (!i2.canRaiseException()) continue;
                noExceptions = false;
                break;
            }
            if (!noExceptions) continue;
            for (Edge e : this.graph.findVertexFor((ExplicitVertexID)basicBlock).getOutgoingEdgesOfType((Object)EdgeType.EXCEPTION)) {
                BasicBlock source2 = (BasicBlock)e.getSource().getData();
                BasicBlock destination = (BasicBlock)e.getDestination().getData();
                toRemove.add(e);
                if (this.rescuerMap.get(source2) != destination) continue;
                this.rescuerMap.remove(source2);
            }
        }
        if (!toRemove.isEmpty()) {
            for (Edge edge : toRemove) {
                this.graph.removeEdge(edge);
            }
        }
        this.deleteOrphanedBlocks(this.graph);
        this.collapseStraightLineBBs();
    }

    public String toStringGraph() {
        return this.graph.toString();
    }

    public String toStringInstrs() {
        StringBuilder buf = new StringBuilder();
        for (BasicBlock b2 : this.getSortedBasicBlocks()) {
            buf.append(b2.toStringInstrs());
        }
        buf.append("\n\n------ Rescue block map ------\n");
        ArrayList<BasicBlock> e = new ArrayList<BasicBlock>(this.rescuerMap.keySet());
        Collections.sort(e);
        for (BasicBlock bb : e) {
            buf.append("BB ").append(bb.getID()).append(" --> BB ").append(this.rescuerMap.get(bb).getID()).append("\n");
        }
        return buf.toString();
    }

    public void removeEdge(BasicBlock a, BasicBlock b2) {
        this.graph.removeEdge((ExplicitVertexID)a, (ExplicitVertexID)b2);
    }

    private LinkedList<BasicBlock> buildPostOrderList() {
        BasicBlock root = this.getEntryBB();
        LinkedList<BasicBlock> list2 = new LinkedList<BasicBlock>();
        Stack<BasicBlock> stack = new Stack<BasicBlock>();
        boolean[] visited = new boolean[1 + this.getMaxNodeID()];
        stack.push(root);
        visited[root.getID()] = true;
        while (!stack.empty()) {
            BasicBlock b2 = (BasicBlock)stack.peek();
            boolean allChildrenVisited = true;
            for (BasicBlock dst : this.getOutgoingDestinations(b2)) {
                int dstID = dst.getID();
                if (visited[dstID]) continue;
                allChildrenVisited = false;
                if (this.graph.findVertexFor((ExplicitVertexID)dst).outDegree() == 0) {
                    list2.add(dst);
                } else {
                    stack.push(dst);
                }
                visited[dstID] = true;
            }
            if (!allChildrenVisited) continue;
            stack.pop();
            list2.add(b2);
        }
        for (BasicBlock b3 : this.getBasicBlocks()) {
            if (visited[b3.getID()]) continue;
            this.printError("BB " + b3.getID() + " missing from po list!");
            break;
        }
        return list2;
    }

    public CFG clone(CloneInfo info, IRScope clonedScope) {
        CFG newCFG = new CFG(clonedScope);
        HashMap<BasicBlock, BasicBlock> cloneBBMap = new HashMap<BasicBlock, BasicBlock>();
        for (BasicBlock bb : this.getBasicBlocks()) {
            BasicBlock newBB = bb.clone(info, newCFG);
            newCFG.addBasicBlock(newBB);
            cloneBBMap.put(bb, newBB);
        }
        for (BasicBlock bb : this.getBasicBlocks()) {
            BasicBlock newSource = (BasicBlock)cloneBBMap.get(bb);
            for (Edge<BasicBlock> edge : this.getOutgoingEdges(bb)) {
                BasicBlock newDestination = (BasicBlock)cloneBBMap.get(edge.getDestination().getData());
                newCFG.addEdge(newSource, newDestination, edge.getType());
            }
        }
        for (BasicBlock bb : this.rescuerMap.keySet()) {
            newCFG.setRescuerBB((BasicBlock)cloneBBMap.get(bb), (BasicBlock)cloneBBMap.get(this.rescuerMap.get(bb)));
        }
        newCFG.entryBB = (BasicBlock)cloneBBMap.get(this.entryBB);
        newCFG.exitBB = (BasicBlock)cloneBBMap.get(this.exitBB);
        newCFG.globalEnsureBB = (BasicBlock)cloneBBMap.get(this.globalEnsureBB);
        return newCFG;
    }

    private void printError(String message2) {
        LOG.error(message2 + "\nGraph:\n" + this + "\nInstructions:\n" + this.toStringInstrs(), new Object[0]);
    }

    public static enum EdgeType {
        REGULAR,
        EXCEPTION,
        FALL_THROUGH,
        EXIT;

    }
}

