/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import jnr.constants.platform.Fcntl;
import jnr.constants.platform.IPProto;
import jnr.constants.platform.ProtocolFamily;
import jnr.constants.platform.Sock;
import jnr.constants.platform.SocketLevel;
import jnr.constants.platform.SocketOption;
import jnr.constants.platform.TCP;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyIO;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.ext.socket.Addrinfo;
import org.jruby.ext.socket.MulticastStateManager;
import org.jruby.ext.socket.Option;
import org.jruby.ext.socket.SocketType;
import org.jruby.ext.socket.SocketUtils;
import org.jruby.platform.Platform;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.Pack;
import org.jruby.util.TypeConverter;
import org.jruby.util.io.BadDescriptorException;
import org.jruby.util.io.ChannelFD;
import org.jruby.util.io.OpenFile;
import org.jruby.util.io.Sockaddr;

@JRubyClass(name={"BasicSocket"}, parent="IO")
public class RubyBasicSocket
extends RubyIO {
    private static ObjectAllocator BASICSOCKET_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyBasicSocket(runtime, klass);
        }
    };
    private static final ByteList FORMAT_SMALL_I = new ByteList(ByteList.plain((CharSequence)"i"));
    protected MulticastStateManager multicastStateManager = null;
    private boolean doNotReverseLookup = true;

    static void createBasicSocket(Ruby runtime) {
        RubyClass rb_cBasicSocket = runtime.defineClass("BasicSocket", runtime.getIO(), BASICSOCKET_ALLOCATOR);
        rb_cBasicSocket.defineAnnotatedMethods(RubyBasicSocket.class);
    }

    public RubyBasicSocket(Ruby runtime, RubyClass type2) {
        super(runtime, type2);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject for_fd(ThreadContext context, IRubyObject _klass, IRubyObject _fileno) {
        Ruby runtime = context.runtime;
        int fileno2 = (int)_fileno.convertToInteger().getLongValue();
        RubyClass klass = (RubyClass)_klass;
        ChannelFD fd = runtime.getFilenoUtil().getWrapperFromFileno(fileno2);
        RubyBasicSocket basicSocket = (RubyBasicSocket)klass.getAllocator().allocate(runtime, klass);
        basicSocket.initSocket(fd);
        return basicSocket;
    }

    @JRubyMethod(name={"do_not_reverse_lookup"})
    public IRubyObject do_not_reverse_lookup19(ThreadContext context) {
        return context.runtime.newBoolean(this.doNotReverseLookup);
    }

    @JRubyMethod(name={"do_not_reverse_lookup="})
    public IRubyObject set_do_not_reverse_lookup19(ThreadContext context, IRubyObject flag) {
        this.doNotReverseLookup = flag.isTrue();
        return this.do_not_reverse_lookup19(context);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject do_not_reverse_lookup(ThreadContext context, IRubyObject recv2) {
        return context.runtime.newBoolean(context.runtime.isDoNotReverseLookupEnabled());
    }

    @JRubyMethod(name={"do_not_reverse_lookup="}, meta=true)
    public static IRubyObject set_do_not_reverse_lookup(ThreadContext context, IRubyObject recv2, IRubyObject flag) {
        context.runtime.setDoNotReverseLookupEnabled(flag.isTrue());
        return flag;
    }

    @JRubyMethod(name={"send"})
    public IRubyObject send(ThreadContext context, IRubyObject _mesg, IRubyObject _flags) {
        return this.syswrite(context, _mesg);
    }

    @JRubyMethod(name={"send"})
    public IRubyObject send(ThreadContext context, IRubyObject _mesg, IRubyObject _flags, IRubyObject _to) {
        return this.send(context, _mesg, _flags);
    }

    @JRubyMethod
    public IRubyObject recv(ThreadContext context, IRubyObject length2) {
        return this.recv(context, length2, null, null);
    }

    @JRubyMethod(required=2, optional=1)
    public IRubyObject recv(ThreadContext context, IRubyObject[] args2) {
        IRubyObject flags2;
        RubyString str;
        IRubyObject length2;
        switch (args2.length) {
            case 3: {
                length2 = args2[0];
                str = (RubyString)args2[1];
                flags2 = args2[2].convertToHash();
                break;
            }
            case 2: {
                length2 = args2[0];
                flags2 = TypeConverter.checkHashType(context.runtime, args2[1]);
                str = flags2.isNil() ? (RubyString)args2[1] : null;
                break;
            }
            case 1: {
                length2 = args2[0];
                str = null;
                flags2 = null;
                break;
            }
            default: {
                length2 = context.nil;
                str = null;
                flags2 = null;
            }
        }
        return this.recv(context, length2, str, flags2);
    }

    @Deprecated
    public IRubyObject recv(ThreadContext context, IRubyObject length2, IRubyObject flags2) {
        return this.recv(context, new IRubyObject[]{length2, flags2});
    }

    private IRubyObject recv(ThreadContext context, IRubyObject length2, RubyString str, IRubyObject flags2) {
        ByteBuffer buffer = ByteBuffer.allocate(RubyNumeric.fix2int(length2));
        ByteList bytes2 = this.doReceive(context, buffer);
        if (bytes2 == null) {
            return context.nil;
        }
        if (str != null) {
            str.setValue(bytes2);
            return str;
        }
        return RubyString.newString(context.runtime, bytes2);
    }

    @JRubyMethod
    public IRubyObject recv_nonblock(ThreadContext context, IRubyObject length2) {
        return this.recv_nonblock(context, length2, context.nil, context.nil, false);
    }

    @JRubyMethod(required=1, optional=3)
    public IRubyObject recv_nonblock(ThreadContext context, IRubyObject[] args2) {
        IRubyObject length2;
        Ruby runtime = context.runtime;
        int argc = args2.length;
        IRubyObject opts = ArgsUtil.getOptionsArg(context.runtime, args2);
        if (!opts.isNil()) {
            --argc;
        }
        IRubyObject flags2 = length2 = context.nil;
        IRubyObject str = length2;
        switch (argc) {
            case 3: {
                str = args2[3];
            }
            case 2: {
                flags2 = args2[2];
            }
            case 1: {
                length2 = args2[1];
            }
        }
        boolean exception2 = ArgsUtil.extractKeywordArg(context, "exception", opts) != runtime.getFalse();
        return this.recv_nonblock(context, length2, flags2, str, exception2);
    }

    protected IRubyObject recv_nonblock(ThreadContext context, IRubyObject length2, IRubyObject flags2, IRubyObject str, boolean ex) {
        Ruby runtime = context.runtime;
        ByteBuffer buffer = ByteBuffer.allocate(RubyNumeric.fix2int(length2));
        ByteList bytes2 = this.doReceiveNonblock(context, buffer);
        if (bytes2 == null) {
            if (!ex) {
                return runtime.newSymbol("wait_readable");
            }
            throw context.runtime.newErrnoEAGAINReadableError("recvfrom(2)");
        }
        if (str != null && !str.isNil()) {
            str = str.convertToString();
            ((RubyString)str).setValue(bytes2);
            return str;
        }
        return RubyString.newString(context.runtime, bytes2);
    }

    @JRubyMethod
    public IRubyObject getsockopt(ThreadContext context, IRubyObject _level, IRubyObject _opt) {
        Ruby runtime = context.runtime;
        SocketLevel level2 = RubyBasicSocket.levelFromArg(_level);
        SocketOption opt = RubyBasicSocket.optionFromArg(_opt);
        try {
            Channel channel = this.getOpenChannel();
            switch (level2) {
                case SOL_SOCKET: 
                case SOL_IP: 
                case SOL_TCP: 
                case SOL_UDP: {
                    if (opt == SocketOption.__UNKNOWN_CONSTANT__) {
                        throw runtime.newErrnoENOPROTOOPTError();
                    }
                    int value2 = SocketType.forChannel(channel).getSocketOption(channel, opt);
                    return new Option(runtime, ProtocolFamily.PF_INET, level2, opt, value2);
                }
            }
            throw runtime.newErrnoENOPROTOOPTError();
        }
        catch (IOException e) {
            throw runtime.newErrnoENOPROTOOPTError();
        }
    }

    @JRubyMethod
    public IRubyObject setsockopt(ThreadContext context, IRubyObject _level, IRubyObject _opt, IRubyObject val) {
        Ruby runtime = context.runtime;
        SocketLevel level2 = RubyBasicSocket.levelFromArg(_level);
        SocketOption opt = RubyBasicSocket.optionFromArg(_opt);
        try {
            Channel channel = this.getOpenChannel();
            SocketType socketType = SocketType.forChannel(channel);
            switch (level2) {
                case SOL_SOCKET: 
                case SOL_IP: 
                case SOL_TCP: 
                case SOL_UDP: {
                    if (opt == SocketOption.SO_LINGER) {
                        if (val instanceof RubyBoolean && !val.isTrue()) {
                            socketType.setSoLinger(channel, false, 0);
                            break;
                        }
                        int num = RubyBasicSocket.asNumber(val);
                        if (num == -1) {
                            socketType.setSoLinger(channel, false, 0);
                            break;
                        }
                        socketType.setSoLinger(channel, true, num);
                        break;
                    }
                    socketType.setSocketOption(channel, opt, RubyBasicSocket.asNumber(val));
                    break;
                }
                default: {
                    int intLevel = (int)_level.convertToInteger().getLongValue();
                    int intOpt = (int)_opt.convertToInteger().getLongValue();
                    if (IPProto.IPPROTO_TCP.intValue() == intLevel && TCP.TCP_NODELAY.intValue() == intOpt) {
                        socketType.setTcpNoDelay(channel, this.asBoolean(val));
                        break;
                    }
                    if (IPProto.IPPROTO_IP.intValue() == intLevel) {
                        if (12 == intOpt) {
                            this.joinMulticastGroup(val);
                        }
                        break;
                    }
                    throw runtime.newErrnoENOPROTOOPTError();
                }
            }
        }
        catch (BadDescriptorException e) {
            throw runtime.newErrnoEBADFError();
        }
        catch (IOException e) {
            throw runtime.newErrnoENOPROTOOPTError();
        }
        return runtime.newFixnum(0);
    }

    @JRubyMethod(name={"getsockname"})
    public IRubyObject getsockname(ThreadContext context) {
        return this.getSocknameCommon(context, "getsockname");
    }

    @JRubyMethod(name={"getpeername"})
    public IRubyObject getpeername(ThreadContext context) {
        Ruby runtime = context.runtime;
        try {
            InetSocketAddress sock = this.getRemoteSocket();
            if (sock == null) {
                throw runtime.newIOError("Not Supported");
            }
            return runtime.newString(((Object)sock).toString());
        }
        catch (BadDescriptorException e) {
            throw runtime.newErrnoEBADFError();
        }
    }

    @JRubyMethod(name={"getpeereid"}, notImplemented=true)
    public IRubyObject getpeereid(ThreadContext context) {
        throw context.runtime.newNotImplementedError("getpeereid not implemented");
    }

    @JRubyMethod
    public IRubyObject local_address(ThreadContext context) {
        try {
            InetSocketAddress address2 = this.getSocketAddress();
            if (address2 == null) {
                return context.nil;
            }
            return new Addrinfo(context.runtime, context.runtime.getClass("Addrinfo"), address2.getAddress(), address2.getPort(), SocketType.forChannel(this.getChannel()));
        }
        catch (BadDescriptorException e) {
            throw context.runtime.newErrnoEBADFError("address unavailable");
        }
    }

    @JRubyMethod
    public IRubyObject remote_address(ThreadContext context) {
        try {
            InetSocketAddress address2 = this.getRemoteSocket();
            if (address2 == null) {
                return context.nil;
            }
            return new Addrinfo(context.runtime, context.runtime.getClass("Addrinfo"), address2.getAddress(), address2.getPort(), SocketType.forChannel(this.getChannel()));
        }
        catch (BadDescriptorException e) {
            throw context.runtime.newErrnoEBADFError("address unavailable");
        }
    }

    @JRubyMethod(optional=1)
    public IRubyObject shutdown(ThreadContext context, IRubyObject[] args2) {
        int how = 2;
        if (args2.length > 0) {
            String howString = null;
            if (args2[0] instanceof RubyString) {
                howString = ((RubyString)args2[0]).asJavaString();
            } else if (args2[0] instanceof RubySymbol) {
                howString = ((RubySymbol)args2[0]).asJavaString();
            }
            if (howString != null) {
                if (howString.equals("RD") || howString.equals("SHUT_RD")) {
                    how = 0;
                } else if (howString.equals("WR") || howString.equals("SHUT_WR")) {
                    how = 1;
                } else if (howString.equals("RDWR") || howString.equals("SHUT_RDWR")) {
                    how = 2;
                }
            } else {
                how = RubyNumeric.fix2int(args2[0]);
            }
        }
        try {
            return this.shutdownInternal(context, how);
        }
        catch (BadDescriptorException e) {
            throw context.runtime.newErrnoEBADFError();
        }
    }

    @Override
    @JRubyMethod
    public IRubyObject close_write(ThreadContext context) {
        Ruby runtime = context.runtime;
        OpenFile fptr = this.getOpenFileChecked();
        if ((fptr.getMode() & 1) == 0) {
            return this.rbIoClose(runtime);
        }
        try {
            this.shutdownInternal(context, 1);
        }
        catch (BadDescriptorException e) {
            throw runtime.newErrnoEBADFError();
        }
        return context.nil;
    }

    @Override
    @JRubyMethod
    public IRubyObject close_read(ThreadContext context) {
        Ruby runtime = context.runtime;
        if (!this.openFile.isOpen()) {
            throw context.runtime.newIOError("not opened for reading");
        }
        if (!this.openFile.isWritable()) {
            this.close();
        } else {
            try {
                this.shutdownInternal(context, 0);
            }
            catch (BadDescriptorException e) {
                throw runtime.newErrnoEBADFError();
            }
        }
        return context.nil;
    }

    @JRubyMethod(rest=true, notImplemented=true)
    public IRubyObject sendmsg(ThreadContext context, IRubyObject[] args2) {
        throw context.runtime.newNotImplementedError("sendmsg is not implemented");
    }

    @JRubyMethod(rest=true, notImplemented=true)
    public IRubyObject sendmsg_nonblock(ThreadContext context, IRubyObject[] args2) {
        throw context.runtime.newNotImplementedError("sendmsg_nonblock is not implemented");
    }

    @JRubyMethod(rest=true, notImplemented=true)
    public IRubyObject readmsg(ThreadContext context, IRubyObject[] args2) {
        throw context.runtime.newNotImplementedError("readmsg is not implemented");
    }

    @JRubyMethod(rest=true, notImplemented=true)
    public IRubyObject readmsg_nonblock(ThreadContext context, IRubyObject[] args2) {
        throw context.runtime.newNotImplementedError("readmsg_nonblock is not implemented");
    }

    private ByteList doReceive(ThreadContext context, ByteBuffer buffer) {
        Ruby runtime = context.runtime;
        OpenFile fptr = this.getOpenFile();
        fptr.checkReadable(context);
        try {
            context.getThread().beforeBlockingCall();
            int read2 = this.openFile.readChannel().read(buffer);
            if (read2 == 0) {
                ByteList byteList = null;
                return byteList;
            }
            ByteList byteList = new ByteList(buffer.array(), 0, buffer.position());
            return byteList;
        }
        catch (IOException e) {
            if ("Socket not open".equals(e.getMessage())) {
                throw context.runtime.newIOError(e.getMessage());
            }
            throw context.runtime.newSystemCallError(e.getMessage());
        }
        finally {
            context.getThread().afterBlockingCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteList doReceiveNonblock(ThreadContext context, ByteBuffer buffer) {
        Ruby runtime = context.runtime;
        Channel channel = this.getChannel();
        if (!(channel instanceof SelectableChannel)) {
            throw context.runtime.newErrnoEAGAINReadableError(channel.getClass().getName() + " does not support nonblocking");
        }
        SelectableChannel selectable = (SelectableChannel)channel;
        Object object = selectable.blockingLock();
        synchronized (object) {
            ByteList byteList;
            boolean oldBlocking = selectable.isBlocking();
            selectable.configureBlocking(false);
            try {
                byteList = this.doReceive(context, buffer);
            }
            catch (Throwable throwable) {
                try {
                    selectable.configureBlocking(oldBlocking);
                    throw throwable;
                }
                catch (IOException e) {
                    throw runtime.newIOErrorFromException(e);
                }
            }
            selectable.configureBlocking(oldBlocking);
            return byteList;
        }
    }

    private void joinMulticastGroup(IRubyObject val) throws IOException, BadDescriptorException {
        Channel socketChannel = this.getOpenChannel();
        if (socketChannel instanceof DatagramChannel) {
            if (this.multicastStateManager == null) {
                this.multicastStateManager = new MulticastStateManager();
            }
            if (val instanceof RubyString) {
                byte[] ipaddr_buf = val.convertToString().getBytes();
                this.multicastStateManager.addMembership(ipaddr_buf);
            }
        }
    }

    protected InetSocketAddress getSocketAddress() throws BadDescriptorException {
        Channel channel = this.getOpenChannel();
        return (InetSocketAddress)SocketType.forChannel(channel).getLocalSocketAddress(channel);
    }

    protected InetSocketAddress getRemoteSocket() throws BadDescriptorException {
        Channel channel = this.getOpenChannel();
        return (InetSocketAddress)SocketType.forChannel(channel).getRemoteSocketAddress(channel);
    }

    protected Sock getDefaultSocketType() {
        return Sock.SOCK_STREAM;
    }

    protected IRubyObject getSocknameCommon(ThreadContext context, String caller) {
        try {
            InetSocketAddress sock = this.getSocketAddress();
            if (sock == null) {
                return Sockaddr.pack_sockaddr_in(context, 0, "0.0.0.0");
            }
            return Sockaddr.pack_sockaddr_in(context, sock);
        }
        catch (BadDescriptorException e) {
            throw context.runtime.newErrnoEBADFError();
        }
    }

    private IRubyObject shutdownInternal(ThreadContext context, int how) throws BadDescriptorException {
        Ruby runtime = context.runtime;
        switch (how) {
            case 0: {
                Channel channel = this.getOpenChannel();
                try {
                    SocketType.forChannel(channel).shutdownInput(channel);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.openFile.setMode(this.openFile.getMode() & 0xFFFFFFFE);
                return RubyFixnum.zero(runtime);
            }
            case 1: {
                Channel channel = this.getOpenChannel();
                try {
                    SocketType.forChannel(channel).shutdownOutput(channel);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.openFile.setMode(this.openFile.getMode() & 0xFFFFFFFD);
                return RubyFixnum.zero(runtime);
            }
            case 2: {
                this.shutdownInternal(context, 0);
                this.shutdownInternal(context, 1);
                return RubyFixnum.zero(runtime);
            }
        }
        throw runtime.newArgumentError("`how' should be either :SHUT_RD, :SHUT_WR, :SHUT_RDWR");
    }

    public boolean doNotReverseLookup(ThreadContext context) {
        return context.runtime.isDoNotReverseLookupEnabled() || this.doNotReverseLookup;
    }

    protected static ChannelFD newChannelFD(Ruby runtime, Channel channel) {
        ChannelFD fd = new ChannelFD(channel, runtime.getPosix(), runtime.getFilenoUtil());
        if (runtime.getPosix().isNative() && fd.realFileno >= 0 && !Platform.IS_WINDOWS) {
            runtime.getPosix().fcntlInt(fd.realFileno, Fcntl.F_SETFD, 1);
        }
        return fd;
    }

    protected void initSocket(ChannelFD fd) {
        this.MakeOpenFile();
        this.openFile.setFD(fd);
        this.openFile.setMode(11);
        this.setAscii8bitBinmode();
    }

    private Channel getOpenChannel() {
        return this.getOpenFileChecked().channel();
    }

    static RuntimeException sockerr(Ruby runtime, String msg, Exception cause2) {
        RuntimeException ex = SocketUtils.sockerr(runtime, msg);
        if (cause2 != null) {
            ex.initCause(cause2);
        }
        return ex;
    }

    private static int asNumber(IRubyObject val) {
        if (val instanceof RubyNumeric) {
            return RubyNumeric.fix2int(val);
        }
        if (val instanceof RubyBoolean) {
            return val.isTrue() ? 1 : 0;
        }
        return RubyBasicSocket.stringAsNumber(val);
    }

    private static int stringAsNumber(IRubyObject val) {
        ByteList str;
        Ruby runtime = val.getRuntime();
        IRubyObject res = Pack.unpack(runtime, str = val.convertToString().getByteList(), FORMAT_SMALL_I).entry(0);
        if (res.isNil()) {
            throw runtime.newErrnoEINVALError();
        }
        return RubyNumeric.fix2int(res);
    }

    protected boolean asBoolean(IRubyObject val) {
        if (val instanceof RubyString) {
            return RubyBasicSocket.stringAsNumber(val) != 0;
        }
        if (val instanceof RubyNumeric) {
            return RubyNumeric.fix2int(val) != 0;
        }
        return val.isTrue();
    }

    protected static SocketOption optionFromArg(IRubyObject _opt) {
        SocketOption opt = _opt instanceof RubyString || _opt instanceof RubySymbol ? SocketOption.valueOf((String)("SO_" + _opt.toString())) : SocketOption.valueOf((long)RubyNumeric.fix2int(_opt));
        return opt;
    }

    protected static SocketLevel levelFromArg(IRubyObject _level) {
        SocketLevel level2 = _level instanceof RubyString || _level instanceof RubySymbol ? SocketLevel.valueOf((String)("SOL_" + _level.toString())) : SocketLevel.valueOf((long)RubyNumeric.fix2int(_level));
        return level2;
    }

    protected IRubyObject addrFor(ThreadContext context, InetSocketAddress addr2, boolean reverse2) {
        Ruby runtime = context.runtime;
        IRubyObject[] ret = new IRubyObject[4];
        ret[0] = addr2.getAddress() instanceof Inet6Address ? runtime.newString("AF_INET6") : runtime.newString("AF_INET");
        ret[1] = runtime.newFixnum(addr2.getPort());
        String hostAddress = addr2.getAddress().getHostAddress();
        ret[2] = !reverse2 || this.doNotReverseLookup(context) ? runtime.newString(hostAddress) : runtime.newString(addr2.getHostName());
        ret[3] = runtime.newString(hostAddress);
        return runtime.newArrayNoCopy(ret);
    }

    @Deprecated
    public IRubyObject recv(IRubyObject[] args2) {
        return this.recv(this.getRuntime().getCurrentContext(), args2);
    }

    @Deprecated
    public IRubyObject getsockopt(IRubyObject lev, IRubyObject optname2) {
        return this.getsockopt(this.getRuntime().getCurrentContext(), lev, optname2);
    }

    @Deprecated
    public IRubyObject setsockopt(IRubyObject lev, IRubyObject optname2, IRubyObject val) {
        return this.setsockopt(this.getRuntime().getCurrentContext(), lev, optname2, val);
    }

    @Deprecated
    public IRubyObject getsockname() {
        return this.getsockname(this.getRuntime().getCurrentContext());
    }

    @Deprecated
    public IRubyObject getpeername() {
        return this.getpeername(this.getRuntime().getCurrentContext());
    }

    @Deprecated
    public static IRubyObject do_not_reverse_lookup(IRubyObject recv2) {
        return RubyBasicSocket.do_not_reverse_lookup(recv2.getRuntime().getCurrentContext(), recv2);
    }

    @Deprecated
    public static IRubyObject set_do_not_reverse_lookup(IRubyObject recv2, IRubyObject flag) {
        return RubyBasicSocket.set_do_not_reverse_lookup(recv2.getRuntime().getCurrentContext(), recv2, flag);
    }
}

