/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import jnr.constants.platform.Errno;
import jnr.constants.platform.Fcntl;
import jnr.enxio.channels.NativeDeviceChannel;
import jnr.posix.FileStat;
import jnr.posix.POSIX;
import org.jruby.RubyFile;
import org.jruby.platform.Platform;
import org.jruby.util.AbstractFileResource;
import org.jruby.util.JRubyFile;
import org.jruby.util.ResourceException;
import org.jruby.util.io.ModeFlags;
import org.jruby.util.io.PosixShim;

class RegularFileResource
extends AbstractFileResource {
    private final JRubyFile file;
    private final POSIX posix;

    RegularFileResource(POSIX posix, File file2) {
        this(posix, file2.getAbsolutePath());
    }

    protected RegularFileResource(POSIX posix, String filename2) {
        this.file = new JRubyFile(filename2);
        this.posix = posix;
    }

    @Override
    public String absolutePath() {
        return RubyFile.canonicalize(this.file.getAbsolutePath());
    }

    @Override
    public String canonicalPath() {
        try {
            return this.file.getCanonicalPath();
        }
        catch (IOException ioError) {
            return this.file.getAbsolutePath();
        }
    }

    @Override
    public long length() {
        return this.file.length();
    }

    @Override
    public long lastModified() {
        return this.file.lastModified();
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public boolean canExecute() {
        return this.file.canExecute();
    }

    @Override
    public int errno() {
        return this.posix.errno();
    }

    @Override
    public boolean isFile() {
        return this.file.isFile();
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public boolean isSymLink() {
        FileStat stat2 = this.posix.allocateStat();
        return this.posix.lstat(this.file.getAbsolutePath(), stat2) < 0 ? false : stat2.isSymlink();
    }

    @Override
    public boolean canRead() {
        return this.file.canRead();
    }

    @Override
    public boolean canWrite() {
        return this.file.canWrite();
    }

    @Override
    public String[] list() {
        String[] fileList = this.file.list();
        if (fileList == null) {
            return null;
        }
        String[] list2 = new String[fileList.length + 2];
        list2[0] = ".";
        list2[1] = "..";
        System.arraycopy(fileList, 0, list2, 2, fileList.length);
        return list2;
    }

    @Override
    public FileStat stat() {
        FileStat stat2 = this.posix.allocateStat();
        return this.posix.stat(this.file.getAbsolutePath(), stat2) < 0 ? null : stat2;
    }

    @Override
    public FileStat lstat() {
        FileStat stat2 = this.posix.allocateStat();
        return this.posix.lstat(this.file.getAbsolutePath(), stat2) < 0 ? null : stat2;
    }

    public String toString() {
        return this.file.toString();
    }

    @Override
    public JRubyFile hackyGetJRubyFile() {
        return this.file;
    }

    @Override
    InputStream openInputStream() throws IOException {
        return new FileInputStream((File)((Object)this.file));
    }

    @Override
    public Channel openChannel(ModeFlags flags2, int perm) throws ResourceException {
        if (this.posix.isNative() && !Platform.IS_WINDOWS) {
            int fd = this.posix.open((CharSequence)this.absolutePath(), flags2.getFlags(), perm);
            if (fd < 0) {
                Errno errno2 = Errno.valueOf((long)this.posix.errno());
                switch (errno2) {
                    case EACCES: {
                        throw new ResourceException.PermissionDenied(this.absolutePath());
                    }
                    case EEXIST: {
                        throw new ResourceException.FileExists(this.absolutePath());
                    }
                    case EINVAL: {
                        throw new ResourceException.InvalidArguments(this.absolutePath());
                    }
                    case ENOENT: {
                        throw new ResourceException.NotFound(this.absolutePath());
                    }
                    case ELOOP: {
                        throw new ResourceException.TooManySymlinks(this.absolutePath());
                    }
                }
                throw new ResourceException.IOError(new IOException("unhandled errno: " + errno2));
            }
            this.posix.fcntlInt(fd, Fcntl.F_SETFD, this.posix.fcntl(fd, Fcntl.F_GETFD) | 1);
            return new NativeDeviceChannel(fd);
        }
        if (flags2.isCreate()) {
            boolean fileCreated;
            try {
                fileCreated = this.file.createNewFile();
            }
            catch (IOException ioe) {
                File parent = this.file.getParentFile();
                if (parent != null && parent != this.file && !parent.exists()) {
                    throw new ResourceException.NotFound(this.absolutePath());
                }
                if (!this.file.canWrite()) {
                    throw new ResourceException.PermissionDenied(this.absolutePath());
                }
                throw new ResourceException.IOError(ioe);
            }
            if (!fileCreated && flags2.isExclusive()) {
                throw new ResourceException.FileExists(this.absolutePath());
            }
            Channel channel = this.createChannel(flags2);
            if (fileCreated && this.posix != null && (perm &= ~PosixShim.umask(this.posix)) > 0) {
                this.posix.chmod(this.file.getPath(), perm);
            }
            return channel;
        }
        if (this.file.isDirectory() && flags2.isWritable()) {
            throw new ResourceException.FileIsDirectory(this.absolutePath());
        }
        if (!this.file.exists()) {
            throw new ResourceException.NotFound(this.absolutePath());
        }
        return this.createChannel(flags2);
    }

    private Channel createChannel(ModeFlags flags2) throws ResourceException {
        FileChannel fileChannel;
        block8: {
            try {
                if (flags2.isWritable() && !flags2.isReadable()) {
                    FileOutputStream fos = new FileOutputStream((File)((Object)this.file), flags2.isAppendable());
                    fileChannel = fos.getChannel();
                } else {
                    RandomAccessFile raf = new RandomAccessFile((File)((Object)this.file), flags2.toJavaModeString());
                    fileChannel = raf.getChannel();
                }
            }
            catch (FileNotFoundException fnfe) {
                throw this.file.exists() ? new ResourceException.PermissionDenied(this.absolutePath()) : new ResourceException.NotFound(this.absolutePath());
            }
            catch (IOException ioe) {
                throw new ResourceException.IOError(ioe);
            }
            try {
                if (flags2.isTruncate()) {
                    fileChannel.truncate(0L);
                }
            }
            catch (IOException ioe) {
                if (ioe.getMessage().equals("Illegal seek")) break block8;
                throw new ResourceException.IOError(ioe);
            }
        }
        return fileChannel;
    }
}

