/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import org.jruby.MetaClass;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.compiler.Compilable;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.CompiledIRMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.IRMethodArgs;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRScope;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.ArgumentDescriptor;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.PositionAware;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.cli.Options;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class MixedModeIRMethod
extends DynamicMethod
implements IRMethodArgs,
PositionAware,
Compilable<DynamicMethod> {
    private static final Logger LOG = LoggerFactory.getLogger("InterpretedIRMethod");
    private Signature signature;
    private boolean displayedCFG = false;
    protected final IRScope method;
    protected DynamicMethodBox box = new DynamicMethodBox();

    public MixedModeIRMethod(IRScope method, Visibility visibility, RubyModule implementationClass) {
        super(implementationClass, visibility, CallConfiguration.FrameNoneScopeNone, method.getName());
        this.method = method;
        this.getStaticScope().determineModule();
        this.signature = this.getStaticScope().getSignature();
        if (!implementationClass.getRuntime().getInstanceConfig().getCompileMode().shouldJIT()) {
            this.box.callCount = -1;
        }
    }

    @Override
    public IRScope getIRScope() {
        return this.method;
    }

    public DynamicMethod getActualMethod() {
        return this.box.actualMethod;
    }

    public StaticScope getStaticScope() {
        return this.method.getStaticScope();
    }

    @Override
    public ArgumentDescriptor[] getArgumentDescriptors() {
        this.ensureInstrsReady();
        return ((IRMethod)this.method).getArgumentDescriptors();
    }

    @Override
    public Signature getSignature() {
        return this.signature;
    }

    @Override
    public Arity getArity() {
        return this.signature.arity();
    }

    protected void post(InterpreterContext ic, ThreadContext context) {
        context.popFrame();
        if (ic.popDynScope()) {
            context.popScope();
        }
    }

    protected void pre(InterpreterContext ic, ThreadContext context, IRubyObject self2, String name2, Block block, RubyModule implClass) {
        context.preMethodFrameOnly(implClass, name2, self2, block);
        if (ic.pushNewDynScope()) {
            context.pushScope(DynamicScope.newDynamicScope(ic.getStaticScope()));
        }
    }

    @Override
    public InterpreterContext ensureInstrsReady() {
        if (this.method instanceof IRMethod) {
            return ((IRMethod)this.method).lazilyAcquireInterpreterContext();
        }
        return this.method.getInterpreterContext();
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
        DynamicMethod jittedMethod;
        if (IRRuntimeHelpers.isDebug()) {
            this.doDebug();
        }
        DynamicMethodBox box = this.box;
        if (box.callCount >= 0) {
            this.tryJit(context, box);
        }
        if ((jittedMethod = box.actualMethod) != null) {
            return jittedMethod.call(context, self2, clazz, name2, args2, block);
        }
        return this.INTERPRET_METHOD(context, this.ensureInstrsReady(), this.getImplementationClass().getMethodLocation(), self2, name2, args2, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject INTERPRET_METHOD(ThreadContext context, InterpreterContext ic, RubyModule implClass, IRubyObject self2, String name2, IRubyObject[] args2, Block block) {
        try {
            ThreadContext.pushBacktrace(context, name2, ic.getFileName(), context.getLine());
            if (ic.hasExplicitCallProtocol()) {
                IRubyObject iRubyObject = ic.engine.interpret(context, self2, ic, implClass, name2, args2, block, null);
                return iRubyObject;
            }
            try {
                this.pre(ic, context, self2, name2, block, implClass);
                IRubyObject iRubyObject = ic.engine.interpret(context, self2, ic, implClass, name2, args2, block, null);
                this.post(ic, context);
                return iRubyObject;
            }
            catch (Throwable throwable) {
                this.post(ic, context);
                throw throwable;
            }
        }
        finally {
            ThreadContext.popBacktrace(context);
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, Block block) {
        DynamicMethod jittedMethod;
        if (IRRuntimeHelpers.isDebug()) {
            this.doDebug();
        }
        DynamicMethodBox box = this.box;
        if (box.callCount >= 0) {
            this.tryJit(context, box);
        }
        if ((jittedMethod = box.actualMethod) != null) {
            return jittedMethod.call(context, self2, clazz, name2, block);
        }
        return this.INTERPRET_METHOD(context, this.ensureInstrsReady(), this.getImplementationClass().getMethodLocation(), self2, name2, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject INTERPRET_METHOD(ThreadContext context, InterpreterContext ic, RubyModule implClass, IRubyObject self2, String name2, Block block) {
        try {
            ThreadContext.pushBacktrace(context, name2, ic.getFileName(), context.getLine());
            if (ic.hasExplicitCallProtocol()) {
                IRubyObject iRubyObject = ic.engine.interpret(context, self2, ic, implClass, name2, block, null);
                return iRubyObject;
            }
            try {
                this.pre(ic, context, self2, name2, block, implClass);
                IRubyObject iRubyObject = ic.engine.interpret(context, self2, ic, implClass, name2, block, null);
                this.post(ic, context);
                return iRubyObject;
            }
            catch (Throwable throwable) {
                this.post(ic, context);
                throw throwable;
            }
        }
        finally {
            ThreadContext.popBacktrace(context);
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, Block block) {
        DynamicMethod jittedMethod;
        if (IRRuntimeHelpers.isDebug()) {
            this.doDebug();
        }
        DynamicMethodBox box = this.box;
        if (box.callCount >= 0) {
            this.tryJit(context, box);
        }
        if ((jittedMethod = box.actualMethod) != null) {
            return jittedMethod.call(context, self2, clazz, name2, arg0, block);
        }
        return this.INTERPRET_METHOD(context, this.ensureInstrsReady(), this.getImplementationClass().getMethodLocation(), self2, name2, arg0, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject INTERPRET_METHOD(ThreadContext context, InterpreterContext ic, RubyModule implClass, IRubyObject self2, String name2, IRubyObject arg1, Block block) {
        try {
            ThreadContext.pushBacktrace(context, name2, ic.getFileName(), context.getLine());
            if (ic.hasExplicitCallProtocol()) {
                IRubyObject iRubyObject = ic.engine.interpret(context, self2, ic, implClass, name2, arg1, block, null);
                return iRubyObject;
            }
            try {
                this.pre(ic, context, self2, name2, block, implClass);
                IRubyObject iRubyObject = ic.engine.interpret(context, self2, ic, implClass, name2, arg1, block, null);
                this.post(ic, context);
                return iRubyObject;
            }
            catch (Throwable throwable) {
                this.post(ic, context);
                throw throwable;
            }
        }
        finally {
            ThreadContext.popBacktrace(context);
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        DynamicMethod jittedMethod;
        if (IRRuntimeHelpers.isDebug()) {
            this.doDebug();
        }
        DynamicMethodBox box = this.box;
        if (box.callCount >= 0) {
            this.tryJit(context, box);
        }
        if ((jittedMethod = box.actualMethod) != null) {
            return jittedMethod.call(context, self2, clazz, name2, arg0, arg1, block);
        }
        return this.INTERPRET_METHOD(context, this.ensureInstrsReady(), this.getImplementationClass().getMethodLocation(), self2, name2, arg0, arg1, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject INTERPRET_METHOD(ThreadContext context, InterpreterContext ic, RubyModule implClass, IRubyObject self2, String name2, IRubyObject arg1, IRubyObject arg2, Block block) {
        try {
            ThreadContext.pushBacktrace(context, name2, ic.getFileName(), context.getLine());
            if (ic.hasExplicitCallProtocol()) {
                IRubyObject iRubyObject = ic.engine.interpret(context, self2, ic, implClass, name2, arg1, arg2, block, null);
                return iRubyObject;
            }
            try {
                this.pre(ic, context, self2, name2, block, implClass);
                IRubyObject iRubyObject = ic.engine.interpret(context, self2, ic, implClass, name2, arg1, arg2, block, null);
                this.post(ic, context);
                return iRubyObject;
            }
            catch (Throwable throwable) {
                this.post(ic, context);
                throw throwable;
            }
        }
        finally {
            ThreadContext.popBacktrace(context);
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        DynamicMethod jittedMethod;
        if (IRRuntimeHelpers.isDebug()) {
            this.doDebug();
        }
        DynamicMethodBox box = this.box;
        if (box.callCount >= 0) {
            this.tryJit(context, box);
        }
        if ((jittedMethod = box.actualMethod) != null) {
            return jittedMethod.call(context, self2, clazz, name2, arg0, arg1, arg2, block);
        }
        return this.INTERPRET_METHOD(context, this.ensureInstrsReady(), this.getImplementationClass().getMethodLocation(), self2, name2, arg0, arg1, arg2, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject INTERPRET_METHOD(ThreadContext context, InterpreterContext ic, RubyModule implClass, IRubyObject self2, String name2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, Block block) {
        try {
            ThreadContext.pushBacktrace(context, name2, ic.getFileName(), context.getLine());
            if (ic.hasExplicitCallProtocol()) {
                IRubyObject iRubyObject = ic.engine.interpret(context, self2, ic, implClass, name2, arg1, arg2, arg3, block, null);
                return iRubyObject;
            }
            try {
                this.pre(ic, context, self2, name2, block, implClass);
                IRubyObject iRubyObject = ic.engine.interpret(context, self2, ic, implClass, name2, arg1, arg2, arg3, block, null);
                this.post(ic, context);
                return iRubyObject;
            }
            catch (Throwable throwable) {
                this.post(ic, context);
                throw throwable;
            }
        }
        finally {
            ThreadContext.popBacktrace(context);
        }
    }

    protected void doDebug() {
        this.ensureInstrsReady();
        LOG.info("Executing '" + this.method.getName() + "'", new Object[0]);
        if (!this.displayedCFG) {
            LOG.info(this.method.debugOutput(), new Object[0]);
            this.displayedCFG = true;
        }
    }

    public DynamicMethod getMethodForCaching() {
        DynamicMethod method = this.box.actualMethod;
        if (method instanceof CompiledIRMethod) {
            return method;
        }
        return this;
    }

    @Override
    public void completeBuild(DynamicMethod newMethod) {
        this.box.actualMethod = newMethod;
        this.box.actualMethod.serialNumber = this.serialNumber;
        this.box.callCount = -1;
        this.getImplementationClass().invalidateCacheDescendants();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tryJit(ThreadContext context, DynamicMethodBox box) {
        if (context.runtime.isBooting()) {
            return;
        }
        MixedModeIRMethod mixedModeIRMethod = this;
        synchronized (mixedModeIRMethod) {
            if (box.callCount >= 0 && box.callCount++ >= (Integer)Options.JIT_THRESHOLD.load()) {
                box.callCount = -1;
                context.runtime.getJITCompiler().buildThresholdReached(context, this);
            }
        }
    }

    @Override
    public String getClassName(ThreadContext context) {
        MetaClass metaClass;
        RubyClass realClass;
        String className = this.implementationClass.isSingleton() ? ((realClass = (metaClass = (MetaClass)this.implementationClass).getRealClass()) == context.runtime.getClassClass() ? ((RubyClass)metaClass.getAttached()).getName() : realClass.getName()) : this.implementationClass.getName();
        return className;
    }

    public void setActualMethod(CompiledIRMethod method) {
        this.box.actualMethod = method;
    }

    protected void dupBox(MixedModeIRMethod orig) {
        this.box = orig.box;
    }

    @Override
    public DynamicMethod dup() {
        MixedModeIRMethod x = new MixedModeIRMethod(this.method, this.getVisibility(), this.implementationClass);
        x.box = this.box;
        return x;
    }

    @Override
    public String getFile() {
        return this.method.getFileName();
    }

    @Override
    public int getLine() {
        return this.method.getLineNumber();
    }

    @Override
    public void setCallCount(int callCount) {
        this.box.callCount = callCount;
    }

    protected static class DynamicMethodBox {
        public volatile DynamicMethod actualMethod;
        public volatile int callCount = 0;

        protected DynamicMethodBox() {
        }
    }
}

