/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.cli;

import com.headius.options.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jruby.RubyInstanceConfig;
import org.jruby.util.KCode;
import org.jruby.util.SafePropertyAccessor;
import org.jruby.util.cli.Category;

public class Options {
    private static final List<Option> _loadedOptions = new ArrayList<Option>();
    private static final boolean INVOKEDYNAMIC_DEFAULT = Options.calculateInvokedynamicDefault();
    public static final Option<Boolean> PARSER_WARN_USELESSS_USE_OF = Options.bool(Category.PARSER, "parser.warn.useless_use_of", true, "Warn about potentially useless expressions in void contents.");
    public static final Option<Boolean> PARSER_WARN_NOT_REACHED = Options.bool(Category.PARSER, "parser.warn.not_reached", true, "Warn about statements that can never be reached.");
    public static final Option<Boolean> PARSER_WARN_GROUPED_EXPRESSIONS = Options.bool(Category.PARSER, "parser.warn.grouped_expressions", true, "Warn about interpreting (...) as a grouped expression.");
    public static final Option<Boolean> PARSER_WARN_LOCAL_SHADOWING = Options.bool(Category.PARSER, "parser.warn.shadowing_local", true, "Warn about shadowing local variables.");
    public static final Option<Boolean> PARSER_WARN_REGEX_CONDITION = Options.bool(Category.PARSER, "parser.warn.regex_condition", true, "Warn about regex literals in conditions.");
    public static final Option<Boolean> PARSER_WARN_ARGUMENT_PREFIX = Options.bool(Category.PARSER, "parser.warn.argument_prefix", true, "Warn about splat operators being interpreted as argument prefixes.");
    public static final Option<Boolean> PARSER_WARN_AMBIGUOUS_ARGUMENTS = Options.bool(Category.PARSER, "parser.warn.ambiguous_argument", true, "Warn about ambiguous arguments.");
    public static final Option<Boolean> PARSER_WARN_FLAGS_IGNORED = Options.bool(Category.PARSER, "parser.warn.flags_ignored", true, "Warn about ignored regex flags being ignored.");
    public static final Option<RubyInstanceConfig.CompileMode> COMPILE_MODE = Options.enumeration(Category.COMPILER, "compile.mode", RubyInstanceConfig.CompileMode.class, RubyInstanceConfig.CompileMode.JIT, "Set compilation mode. JIT = at runtime; FORCE = before execution.");
    public static final Option<Boolean> COMPILE_DUMP = Options.bool(Category.COMPILER, "compile.dump", false, "Dump to console all bytecode generated at runtime.");
    public static final Option<Boolean> COMPILE_THREADLESS = Options.bool(Category.COMPILER, "compile.threadless", false, "(EXPERIMENTAL) Turn on compilation without polling for \"unsafe\" thread events.");
    public static final Option<Boolean> COMPILE_FASTOPS = Options.bool(Category.COMPILER, "compile.fastops", true, "Turn on fast operators for Fixnum and Float.");
    public static final Option<Integer> COMPILE_CHAINSIZE = Options.integer(Category.COMPILER, "compile.chainsize", 500, "Set the number of lines at which compiled bodies are \"chained\".");
    public static final Option<Boolean> COMPILE_PEEPHOLE = Options.bool(Category.COMPILER, "compile.peephole", true, "Enable or disable peephole optimizations.");
    public static final Option<Boolean> COMPILE_NOGUARDS = Options.bool(Category.COMPILER, "compile.noguards", false, "Compile calls without guards, for experimentation.");
    public static final Option<Boolean> COMPILE_FASTEST = Options.bool(Category.COMPILER, "compile.fastest", false, "Compile with all \"mostly harmless\" compiler optimizations.");
    public static final Option<Boolean> COMPILE_FASTSEND = Options.bool(Category.COMPILER, "compile.fastsend", false, "Compile obj.__send__(<literal>, ...) as obj.<literal>(...).");
    public static final Option<Boolean> COMPILE_FASTMASGN = Options.bool(Category.COMPILER, "compile.fastMasgn", false, "Return true from multiple assignment instead of a new array.");
    public static final Option<Boolean> COMPILE_INVOKEDYNAMIC = Options.bool(Category.COMPILER, "compile.invokedynamic", INVOKEDYNAMIC_DEFAULT, "Use invokedynamic for optimizing Ruby code.");
    public static final Option<Integer> COMPILE_OUTLINE_CASECOUNT = Options.integer(Category.COMPILER, "compile.outline.casecount", 50, "Outline when bodies when number of cases exceeds this value.");
    public static final Option<Integer> INVOKEDYNAMIC_MAXFAIL = Options.integer(Category.INVOKEDYNAMIC, "invokedynamic.maxfail", 1000, "Maximum call site failures after which to inline cache.");
    public static final Option<Integer> INVOKEDYNAMIC_MAXPOLY = Options.integer(Category.INVOKEDYNAMIC, "invokedynamic.maxpoly", 6, "Maximum polymorphism of PIC binding.");
    public static final Option<Boolean> INVOKEDYNAMIC_LOG_BINDING = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.log.binding", false, "Log binding of invokedynamic call sites.");
    public static final Option<Boolean> INVOKEDYNAMIC_LOG_CONSTANTS = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.log.constants", false, "Log invokedynamic-based constant lookups.");
    public static final Option<Boolean> INVOKEDYNAMIC_LOG_GLOBALS = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.log.globals", false, "Log invokedynamic-based global lookups.");
    public static final Option<Boolean> INVOKEDYNAMIC_ALL = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.all", false, "Enable all possible uses of invokedynamic.");
    public static final Option<Boolean> INVOKEDYNAMIC_SAFE = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.safe", false, "Enable all safe (but maybe not fast) uses of invokedynamic.");
    public static final Option<Boolean> INVOKEDYNAMIC_INVOCATION = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.invocation", true, "Enable invokedynamic for method invocations.");
    public static final Option<Boolean> INVOKEDYNAMIC_INVOCATION_INDIRECT = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.invocation.indirect", true, "Also bind indirect method invokers to invokedynamic.");
    public static final Option<Boolean> INVOKEDYNAMIC_INVOCATION_JAVA = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.invocation.java", true, "Bind Ruby to Java invocations with invokedynamic.");
    public static final Option<Boolean> INVOKEDYNAMIC_INVOCATION_ATTR = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.invocation.attr", true, "Bind Ruby attribute invocations directly to invokedynamic.");
    public static final Option<Boolean> INVOKEDYNAMIC_INVOCATION_FFI = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.invocation.ffi", true, "Bind Ruby FFI invocations directly to invokedynamic.");
    public static final Option<Boolean> INVOKEDYNAMIC_INVOCATION_FASTOPS = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.invocation.fastops", true, "Bind Fixnum and Float math using optimized logic.");
    public static final Option<Boolean> INVOKEDYNAMIC_CACHE = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.cache", true, "Use invokedynamic to load cached values like literals and constants.");
    public static final Option<Boolean> INVOKEDYNAMIC_CACHE_CONSTANTS = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.cache.constants", true, "Use invokedynamic to load constants.");
    public static final Option<Boolean> INVOKEDYNAMIC_CACHE_LITERALS = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.cache.literals", true, "Use invokedynamic to load literals.");
    public static final Option<Boolean> INVOKEDYNAMIC_CACHE_IVARS = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.cache.ivars", true, "Use invokedynamic to get/set instance variables.");
    public static final Option<Boolean> INVOKEDYNAMIC_CLASS_VALUES = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.class.values", false, "Use ClassValue to store class-specific data.");
    public static final Option<Integer> INVOKEDYNAMIC_GLOBAL_MAXFAIL = Options.integer(Category.INVOKEDYNAMIC, "invokedynamic.global.maxfail", 100, "Maximum global cache failures after which to use slow path.");
    public static final Option<Boolean> INVOKEDYNAMIC_HANDLES = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.handles", false, "Use MethodHandles rather than generated code to bind Ruby methods.");
    public static final Option<Integer> JIT_THRESHOLD = Options.integer(Category.JIT, "jit.threshold", 50, "Set the JIT threshold to the specified method invocation count.");
    public static final Option<Integer> JIT_MAX = Options.integer(Category.JIT, "jit.max", 4096, "Set the max count of active methods eligible for JIT-compilation.");
    public static final Option<Integer> JIT_MAXSIZE = Options.integer(Category.JIT, "jit.maxsize", 2000, "Set the max size (in IR instructions) for a method to be eligible to JIT.");
    public static final Option<Boolean> JIT_LOGGING = Options.bool(Category.JIT, "jit.logging", false, "Enable JIT logging (reports successful compilation).");
    public static final Option<Boolean> JIT_LOGGING_VERBOSE = Options.bool(Category.JIT, "jit.logging.verbose", false, "Enable verbose JIT logging (reports failed compilation).");
    public static final Option<Boolean> JIT_DUMPING = Options.bool(Category.JIT, "jit.dumping", false, "Enable stdout dumping of JITed bytecode.");
    public static final Option<Integer> JIT_LOGEVERY = Options.integer(Category.JIT, "jit.logEvery", 0, "Log a message every n methods JIT compiled.");
    public static final Option<String> JIT_EXCLUDE = Options.string(Category.JIT, "jit.exclude", "", "Exclude methods from JIT. <ModClsName or '-'>::<method_name>, comma-delimited.");
    public static final Option<Boolean> JIT_DEBUG = Options.bool(Category.JIT, "jit.debug", false, "Log loading of JITed bytecode.");
    public static final Option<Boolean> JIT_BACKGROUND = Options.bool(Category.JIT, "jit.background", (Integer)JIT_THRESHOLD.load() != 0, "Run the JIT compiler in a background thread. Off if jit.threshold=0.");
    public static final Option<Boolean> IR_DEBUG = Options.bool(Category.IR, "ir.debug", false, "Debug generation of JRuby IR.");
    public static final Option<Boolean> IR_PROFILE = Options.bool(Category.IR, "ir.profile", false, "[EXPT]: Profile IR code during interpretation.");
    public static final Option<Boolean> IR_COMPILER_DEBUG = Options.bool(Category.IR, "ir.compiler.debug", false, "Debug compilation of JRuby IR.");
    public static final Option<Boolean> IR_VISUALIZER = Options.bool(Category.IR, "ir.visualizer", false, "Visualization of JRuby IR.");
    public static final Option<Boolean> IR_UNBOXING = Options.bool(Category.IR, "ir.unboxing", false, "Implement unboxing opts.");
    public static final Option<String> IR_COMPILER_PASSES = Options.string(Category.IR, "ir.passes", "Specify comma delimeted list of passes to run.");
    public static final Option<String> IR_JIT_PASSES = Options.string(Category.IR, "ir.jit.passes", "Specify comma delimeted list of passes to run before JIT.");
    public static final Option<Boolean> IR_READING = Options.bool(Category.IR, "ir.reading", false, "Read JRuby IR file.");
    public static final Option<Boolean> IR_READING_DEBUG = Options.bool(Category.IR, "ir.reading.debug", false, "Debug reading JRuby IR file.");
    public static final Option<Boolean> IR_WRITING = Options.bool(Category.IR, "ir.writing", false, "Write JRuby IR file.");
    public static final Option<Boolean> IR_WRITING_DEBUG = Options.bool(Category.IR, "ir.writing.debug", false, "Debug writing JRuby IR file.");
    public static final Option<String> IR_INLINE_COMPILER_PASSES = Options.string(Category.IR, "ir.inline_passes", "Specify comma delimeted list of passes to run after inlining a method.");
    public static final Option<Boolean> NATIVE_ENABLED = Options.bool(Category.NATIVE, "native.enabled", true, "Enable/disable native code, including POSIX features and C exts.");
    public static final Option<Boolean> NATIVE_VERBOSE = Options.bool(Category.NATIVE, "native.verbose", false, "Enable verbose logging of native extension loading.");
    public static final Option<Boolean> FFI_COMPILE_DUMP = Options.bool(Category.NATIVE, "ffi.compile.dump", false, "Dump bytecode-generated FFI stubs to console.");
    public static final Option<Integer> FFI_COMPILE_THRESHOLD = Options.integer(Category.NATIVE, "ffi.compile.threshold", 100, "Number of FFI invocations before generating a bytecode stub.");
    public static final Option<Boolean> FFI_COMPILE_INVOKEDYNAMIC = Options.bool(Category.NATIVE, "ffi.compile.invokedynamic", false, "Use invokedynamic to bind FFI invocations.");
    public static final Option<Boolean> FFI_COMPILE_REIFY = Options.bool(Category.NATIVE, "ffi.compile.reify", false, "Reify FFI compiled classes.");
    public static final Option<Integer> THREADPOOL_MIN = Options.integer(Category.THREADPOOL, "thread.pool.min", 0, "The minimum number of threads to keep alive in the pool.");
    public static final Option<Integer> THREADPOOL_MAX = Options.integer(Category.THREADPOOL, "thread.pool.max", Integer.MAX_VALUE, "The maximum number of threads to allow in the pool.");
    public static final Option<Integer> THREADPOOL_TTL = Options.integer(Category.THREADPOOL, "thread.pool.ttl", 60, "The maximum number of seconds to keep alive an idle thread.");
    public static final Option<Integer> FIBER_THREADPOOL_TTL = Options.integer(Category.THREADPOOL, "fiber.thread.pool.ttl", 60, "The maximum number of seconds to keep alive a pooled fiber thread.");
    public static final Option<Boolean> CLASSLOADER_DELEGATE = Options.bool(Category.MISCELLANEOUS, "classloader.delegate", true, "In some cases of classloader conflicts it might help not to delegate first to the parent classloader but to load first from the jruby-classloader.");
    public static final Option<Boolean> OBJECTSPACE_ENABLED = Options.bool(Category.MISCELLANEOUS, "objectspace.enabled", false, "Enable or disable ObjectSpace.each_object.");
    public static final Option<Boolean> SIPHASH_ENABLED = Options.bool(Category.MISCELLANEOUS, "siphash.enabled", false, "Enable or disable SipHash for String hash function.");
    public static final Option<Boolean> LAUNCH_INPROC = Options.bool(Category.MISCELLANEOUS, "launch.inproc", false, "Set in-process launching of e.g. system('ruby ...').");
    public static final Option<String> BYTECODE_VERSION = Options.string(Category.MISCELLANEOUS, "bytecode.version", new String[]{"1.5", "1.6", "1.7"}, SafePropertyAccessor.getProperty("java.specification.version", "1.5"), "Specify the major Java bytecode version.");
    public static final Option<Boolean> MANAGEMENT_ENABLED = Options.bool(Category.MISCELLANEOUS, "management.enabled", false, "Set whether JMX management is enabled.");
    public static final Option<Boolean> JUMP_BACKTRACE = Options.bool(Category.MISCELLANEOUS, "jump.backtrace", false, "Make non-local flow jumps generate backtraces.");
    public static final Option<Boolean> PROCESS_NOUNWRAP = Options.bool(Category.MISCELLANEOUS, "process.noUnwrap", false, "Do not unwrap process streams (issue on some recent JVMs).");
    public static final Option<Boolean> REIFY_CLASSES = Options.bool(Category.MISCELLANEOUS, "reify.classes", false, "Before instantiation, stand up a real Java class for every Ruby class.");
    public static final Option<Boolean> REIFY_LOGERRORS = Options.bool(Category.MISCELLANEOUS, "reify.logErrors", false, "Log errors during reification (reify.classes=true).");
    public static final Option<Boolean> REFLECTED_HANDLES = Options.bool(Category.MISCELLANEOUS, "reflected.handles", false, "Use reflection for binding methods, not generated bytecode.");
    public static final Option<Boolean> BACKTRACE_COLOR = Options.bool(Category.MISCELLANEOUS, "backtrace.color", false, "Enable colorized backtraces.");
    public static final Option<String> BACKTRACE_STYLE = Options.string(Category.MISCELLANEOUS, "backtrace.style", new String[]{"normal", "raw", "full", "mri"}, "normal", "Set the style of exception backtraces.");
    public static final Option<Boolean> BACKTRACE_MASK = Options.bool(Category.MISCELLANEOUS, "backtrace.mask", false, "Mask .java lines in Ruby backtraces.");
    public static final Option<String> THREAD_DUMP_SIGNAL = Options.string(Category.MISCELLANEOUS, "thread.dump.signal", new String[]{"USR1", "USR2", "etc"}, "USR2", "Set the signal used for dumping thread stacks.");
    public static final Option<Boolean> NATIVE_NET_PROTOCOL = Options.bool(Category.MISCELLANEOUS, "native.net.protocol", false, "Use native impls for parts of net/protocol.");
    public static final Option<Boolean> FIBER_COROUTINES = Options.bool(Category.MISCELLANEOUS, "fiber.coroutines", false, "Use JVM coroutines for Fiber.");
    public static final Option<Boolean> GLOBAL_REQUIRE_LOCK = Options.bool(Category.MISCELLANEOUS, "global.require.lock", false, "Use a single global lock for requires.");
    public static final Option<Boolean> NATIVE_EXEC = Options.bool(Category.MISCELLANEOUS, "native.exec", true, "Do a true process-obliterating native exec for Kernel#exec.");
    public static final Option<Boolean> ENUMERATOR_LIGHTWEIGHT = Options.bool(Category.MISCELLANEOUS, "enumerator.lightweight", true, "Use lightweight Enumerator#next logic when possible.");
    public static final Option<Boolean> CONSISTENT_HASHING = Options.bool(Category.MISCELLANEOUS, "consistent.hashing", false, "Generate consistent object hashes across JVMs");
    public static final Option<Boolean> REIFY_VARIABLES = Options.bool(Category.MISCELLANEOUS, "reify.variables", false, "Attempt to expand instance vars into Java fields");
    public static final Option<Boolean> PREFER_IPV4 = Options.bool(Category.MISCELLANEOUS, "net.preferIPv4", true, "Prefer IPv4 network stack");
    public static final Option<Boolean> FCNTL_LOCKING = Options.bool(Category.MISCELLANEOUS, "file.flock.fcntl", true, "Use fcntl rather than flock for File#flock");
    public static final Option<Boolean> DEBUG_LOADSERVICE = Options.bool(Category.DEBUG, "debug.loadService", false, "Log require/load file searches.");
    public static final Option<Boolean> DEBUG_LOADSERVICE_TIMING = Options.bool(Category.DEBUG, "debug.loadService.timing", false, "Log require/load parse+evaluate times.");
    public static final Option<Boolean> DEBUG_LAUNCH = Options.bool(Category.DEBUG, "debug.launch", false, "Log externally-launched processes.");
    public static final Option<Boolean> DEBUG_FULLTRACE = Options.bool(Category.DEBUG, "debug.fullTrace", false, "Set whether full traces are enabled (c-call/c-return).");
    public static final Option<Boolean> DEBUG_SCRIPTRESOLUTION = Options.bool(Category.DEBUG, "debug.scriptResolution", false, "Print which script is executed by '-S' flag.");
    public static final Option<Boolean> DEBUG_PARSER = Options.bool(Category.DEBUG, "debug.parser", false, "disables JRuby impl script loads and prints parse exceptions");
    public static final Option<Boolean> ERRNO_BACKTRACE = Options.bool(Category.DEBUG, "errno.backtrace", false, "Generate backtraces for heavily-used Errno exceptions (EAGAIN).");
    public static final Option<Boolean> STOPITERATION_BACKTRACE = Options.bool(Category.DEBUG, "stop_iteration.backtrace", false, "Generate backtraces for heavily-used Errno exceptions (EAGAIN).");
    public static final Option<Boolean> LOG_EXCEPTIONS = Options.bool(Category.DEBUG, "log.exceptions", false, "Log every time an exception is constructed.");
    public static final Option<Boolean> LOG_BACKTRACES = Options.bool(Category.DEBUG, "log.backtraces", false, "Log every time an exception backtrace is generated.");
    public static final Option<Boolean> LOG_CALLERS = Options.bool(Category.DEBUG, "log.callers", false, "Log every time a Kernel#caller backtrace is generated.");
    public static final Option<Boolean> LOG_WARNINGS = Options.bool(Category.DEBUG, "log.warnings", false, "Log every time a built-in warning backtrace is generated.");
    public static final Option<String> LOGGER_CLASS = Options.string(Category.DEBUG, "logger.class", new String[]{"class name"}, "org.jruby.util.log.StandardErrorLogger", "Use specified class for logging.");
    public static final Option<Boolean> DUMP_INSTANCE_VARS = Options.bool(Category.DEBUG, "dump.variables", false, "Dump class + instance var names on first new of Object subclasses.");
    public static final Option<Boolean> REWRITE_JAVA_TRACE = Options.bool(Category.DEBUG, "rewrite.java.trace", true, "Rewrite stack traces from exceptions raised in Java calls.");
    public static final Option<Boolean> JI_SETACCESSIBLE = Options.bool(Category.JAVA_INTEGRATION, "ji.setAccessible", true, "Try to set inaccessible Java methods to be accessible.");
    public static final Option<Boolean> JI_LOGCANSETACCESSIBLE = Options.bool(Category.JAVA_INTEGRATION, "ji.logCanSetAccessible", false, "Log whether setAccessible is working.");
    public static final Option<Boolean> JI_UPPER_CASE_PACKAGE_NAME_ALLOWED = Options.bool(Category.JAVA_INTEGRATION, "ji.upper.case.package.name.allowed", false, "Allow Capitalized Java pacakge names.");
    public static final Option<Boolean> INTERFACES_USEPROXY = Options.bool(Category.JAVA_INTEGRATION, "interfaces.useProxy", false, "Use java.lang.reflect.Proxy for interface impl.");
    public static final Option<Boolean> JAVA_HANDLES = Options.bool(Category.JAVA_INTEGRATION, "java.handles", false, "Use generated handles instead of reflection for calling Java.");
    public static final Option<Boolean> JI_NEWSTYLEEXTENSION = Options.bool(Category.JAVA_INTEGRATION, "ji.newStyleExtension", false, "Extend Java classes without using a proxy object.");
    public static final Option<Boolean> JI_OBJECTPROXYCACHE = Options.bool(Category.JAVA_INTEGRATION, "ji.objectProxyCache", false, "Cache Java object wrappers between calls.");
    public static final Option<String> JI_PROXYCLASSFACTORY = Options.string(Category.JAVA_INTEGRATION, "ji.proxyClassFactory", "Allow external envs to replace JI proxy class factory");
    public static final Option<Boolean> AOT_LOADCLASSES = Options.bool(Category.JAVA_INTEGRATION, "aot.loadClasses", false, "Look for .class before .rb to load AOT-compiled code");
    public static final Option<Integer> PROFILE_MAX_METHODS = Options.integer(Category.PROFILING, "profile.max.methods", 100000, "Maximum number of methods to consider for profiling.");
    public static final Option<Boolean> CLI_AUTOSPLIT = Options.bool(Category.CLI, "cli.autosplit", false, "Split $_ into $F for -p or -n. Same as -a.");
    public static final Option<Boolean> CLI_DEBUG = Options.bool(Category.CLI, "cli.debug", false, "Enable debug mode logging. Same as -d.");
    public static final Option<Boolean> CLI_PROCESS_LINE_ENDS = Options.bool(Category.CLI, "cli.process.line.ends", false, "Enable line ending processing. Same as -l.");
    public static final Option<Boolean> CLI_ASSUME_LOOP = Options.bool(Category.CLI, "cli.assume.loop", false, "Wrap execution with a gets() loop. Same as -n.");
    public static final Option<Boolean> CLI_ASSUME_PRINT = Options.bool(Category.CLI, "cli.assume.print", false, "Print $_ after each execution of script. Same as -p.");
    public static final Option<Boolean> CLI_VERBOSE = Options.bool(Category.CLI, "cli.verbose", false, "Verbose mode, as -w or -W2. Sets default for cli.warning.level.");
    public static final Option<RubyInstanceConfig.Verbosity> CLI_WARNING_LEVEL = Options.enumeration(Category.CLI, "cli.warning.level", RubyInstanceConfig.Verbosity.class, (Boolean)CLI_VERBOSE.load() != false ? RubyInstanceConfig.Verbosity.TRUE : RubyInstanceConfig.Verbosity.FALSE, "Warning level (off=0,normal=1,on=2). Same as -W.");
    public static final Option<Boolean> CLI_PARSER_DEBUG = Options.bool(Category.CLI, "cli.parser.debug", false, "Enable parser debug logging. Same as -y.");
    public static final Option<Boolean> CLI_VERSION = Options.bool(Category.CLI, "cli.version", false, "Print version to stderr. Same as --version.");
    public static final Option<Boolean> CLI_BYTECODE = Options.bool(Category.CLI, "cli.bytecode", false, "Print target script bytecode to stderr. Same as --bytecode.");
    public static final Option<Boolean> CLI_COPYRIGHT = Options.bool(Category.CLI, "cli.copyright", false, "Print copyright to stderr. Same as --copyright but runs script.");
    public static final Option<Boolean> CLI_CHECK_SYNTAX = Options.bool(Category.CLI, "cli.check.syntax", false, "Check syntax of target script. Same as -c but runs script.");
    public static final Option<String> CLI_AUTOSPLIT_SEPARATOR = Options.string(Category.CLI, "cli.autosplit.separator", "Set autosplit separator. Same as -F.");
    public static final Option<KCode> CLI_KCODE = Options.enumeration(Category.CLI, "cli.kcode", KCode.class, KCode.NONE, "Set kcode character set. Same as -K (1.8).");
    public static final Option<Boolean> CLI_HELP = Options.bool(Category.CLI, "cli.help", false, "Print command-line usage. Same as --help but runs script.");
    public static final Option<Boolean> CLI_PROPERTIES = Options.bool(Category.CLI, "cli.properties", false, "Print config properties. Same as --properties but runs script.");
    public static final Option<String> CLI_ENCODING_INTERNAL = Options.string(Category.CLI, "cli.encoding.internal", "Encoding name to use internally.");
    public static final Option<String> CLI_ENCODING_EXTERNAL = Options.string(Category.CLI, "cli.encoding.external", "Encoding name to treat external data.");
    public static final Option<String> CLI_ENCODING_SOURCE = Options.string(Category.CLI, "cli.encoding.source", "Encoding name to treat source code.");
    public static final Option<String> CLI_RECORD_SEPARATOR = Options.string(Category.CLI, "cli.record.separator", "\n", "Default record separator.");
    public static final Option<String> CLI_BACKUP_EXTENSION = Options.string(Category.CLI, "cli.backup.extension", "Backup extension for in-place ARGV files. Same as -i.");
    public static final Option<RubyInstanceConfig.ProfilingMode> CLI_PROFILING_MODE = Options.enumeration(Category.CLI, "cli.profiling.mode", RubyInstanceConfig.ProfilingMode.class, RubyInstanceConfig.ProfilingMode.OFF, "Enable instrumented profiling modes.");
    public static final Option<Boolean> CLI_RUBYGEMS_ENABLE = Options.bool(Category.CLI, "cli.rubygems.enable", true, "Enable/disable RubyGems.");
    public static final Option<Boolean> CLI_RUBYOPT_ENABLE = Options.bool(Category.CLI, "cli.rubyopt.enable", true, "Enable/disable RUBYOPT processing at start.");
    public static final Option<Boolean> CLI_STRIP_HEADER = Options.bool(Category.CLI, "cli.strip.header", false, "Strip text before shebang in script. Same as -x.");
    public static final Option<Boolean> CLI_LOAD_GEMFILE = Options.bool(Category.CLI, "cli.load.gemfile", false, "Load a bundler Gemfile in cwd before running. Same as -G.");
    public static final Option<String> TRUFFLE_CORE_LOAD_PATH = Options.string(Category.TRUFFLE, "truffle.core.load_path", "truffle:/jruby-truffle", "Directory to load the Truffle core library from.");
    public static final Option<Integer> TRUFFLE_DISPATCH_POLYMORPHIC_MAX = Options.integer(Category.TRUFFLE, "truffle.dispatch.polymorphic.max", 8, "Maximum size of a polymorphic call site cache.");
    public static final Option<Integer> TRUFFLE_ARRAYS_UNINITIALIZED_SIZE = Options.integer(Category.TRUFFLE, "truffle.arrays.uninitialized_size", 32, "How large an array to allocate when we have no other information to go on.");
    public static final Option<Integer> TRUFFLE_ARRAYS_SMALL = Options.integer(Category.TRUFFLE, "truffle.arrays.small", 3, "Maximum size of an Array to consider small for optimisations.");
    public static final Option<Integer> TRUFFLE_HASH_PACKED_ARRAY_MAX = Options.integer(Category.TRUFFLE, "truffle.hash.packed_array_max", 3, "Maximum size of a Hash to use with the packed array storage strategy.");
    public static final Option<Integer> TRUFFLE_INSTRUMENTATION_SERVER_PORT = Options.integer(Category.TRUFFLE, "truffle.instrumentation_server_port", 0, "Port number to run an HTTP server on that provides instrumentation services");
    public static final Option<Boolean> TRUFFLE_EXCEPTIONS_PRINT_JAVA = Options.bool(Category.TRUFFLE, "truffle.exceptions.print_java", false, "Print Java exceptions at the point of translating them to Ruby exceptions.");
    public static final Option<Boolean> TRUFFLE_EXCEPTIONS_PRINT_UNCAUGHT_JAVA = Options.bool(Category.TRUFFLE, "truffle.exceptions.print_uncaught_java", false, "Print uncaught Java exceptions at the point of translating them to Ruby exceptions.");
    public static final Option<Boolean> TRUFFLE_COVERAGE = Options.bool(Category.TRUFFLE, "truffle.coverage", false, "Enable coverage (will be enabled by default in the future - currently has some bugs");
    public static final Option<Boolean> TRUFFLE_BACKTRACES_HIDE_CORE_FILES = Options.bool(Category.TRUFFLE, "truffle.backtraces.hide_core_files", true, "Hide core source files in backtraces, like MRI does.");
    public static final Option<Boolean> TRUFFLE_INLINER_ALWAYS_CLONE_YIELD = Options.bool(Category.TRUFFLE, "truffle.inliner.always_clone_yield", true, "Always clone yield call targets.");
    public static final Option<Boolean> TRUFFLE_INLINER_ALWAYS_INLINE_YIELD = Options.bool(Category.TRUFFLE, "truffle.inliner.always_inline_yield", true, "Always inline yield call targets.");
    public static final Option<Boolean> TRUFFLE_DISPATCH_METAPROGRAMMING_ALWAYS_UNCACHED = Options.bool(Category.TRUFFLE, "truffle.dispatch.metaprogramming_always_uncached", false, "Always use uncached dispatch for the metaprogramming methods #__send__, #send and #respond_to?, and for any call site that has to use #method_missing or #const_missing.");
    public static final Option<Boolean> TRUFFLE_DISPATCH_METAPROGRAMMING_ALWAYS_INDIRECT = Options.bool(Category.TRUFFLE, "truffle.dispatch.metaprogramming_always_indirect", false, "Always use indirect calls for the metaprogramming methods #__send__ and #send, and for any call site that has to use #method_missing or #const_missing.");
    public static final Option<Boolean> TRUFFLE_DISPATCH_METHODMISSING_ALWAYS_CLONED = Options.bool(Category.TRUFFLE, "truffle.call.method_missing_always_cloned", true, "Always clone #method_missing call targets.");
    public static final Option<Boolean> TRUFFLE_DISPATCH_METHODMISSING_ALWAYS_INLINED = Options.bool(Category.TRUFFLE, "truffle.call.method_missing_always_inlined", true, "Always inline #method_missing call targets.");
    public static final Option<Integer> TRUFFLE_PACK_UNROLL_LIMIT = Options.integer(Category.TRUFFLE, "truffle.pack.unroll", 4, "If a pack expression has a loop less than this many iterations, unroll it.");
    public static final Option<Boolean> TRUFFLE_METRICS_TIME = Options.bool(Category.TRUFFLE, "truffle.metrics.time", false, "Print the time at various stages of VM operation.");
    public static final Option<Boolean> TRUFFLE_METRICS_MEMORY_USED_ON_EXIT = Options.bool(Category.TRUFFLE, "truffle.metrics.memory_used_on_exit", false, "Print the size of heap memory in use on exit.");
    public static final Collection<Option> PROPERTIES = Collections.unmodifiableCollection(_loadedOptions);
    @Deprecated
    public static final Option<Boolean> JIT_CACHE = Options.bool(Category.JIT, "jit.cache", (Boolean)COMPILE_INVOKEDYNAMIC.load() == false, "(DEPRECATED) Cache jitted method in-memory bodies across runtimes and loads.");
    @Deprecated
    public static final Option<String> JIT_CODECACHE = Options.string(Category.JIT, "jit.codeCache", new String[]{"dir"}, "Save jitted methods to <dir> as they're compiled, for future runs.");

    public static String dump() {
        return "# JRuby configuration options with current values\n" + Option.formatValues(_loadedOptions);
    }

    private static Option<String> string(Category category, String name2, String[] options2, String defval, String description) {
        Option option = Option.string((String)"jruby", (String)name2, (Enum)category, (String[])options2, (String)defval, (String)description);
        _loadedOptions.add(option);
        return option;
    }

    private static Option<String> string(Category category, String name2, String defval, String description) {
        Option option = Option.string((String)"jruby", (String)name2, (Enum)category, (String)defval, (String)description);
        _loadedOptions.add(option);
        return option;
    }

    private static Option<String> string(Category category, String name2, String[] options2, String description) {
        Option option = Option.string((String)"jruby", (String)name2, (Enum)category, (String[])options2, (String)description);
        _loadedOptions.add(option);
        return option;
    }

    private static Option<String> string(Category category, String name2, String description) {
        Option option = Option.string((String)"jruby", (String)name2, (Enum)category, (String)description);
        _loadedOptions.add(option);
        return option;
    }

    private static Option<Boolean> bool(Category category, String name2, Boolean defval, String description) {
        Option option = Option.bool((String)"jruby", (String)name2, (Enum)category, (Boolean)defval, (String)description);
        _loadedOptions.add(option);
        return option;
    }

    private static Option<Integer> integer(Category category, String name2, Integer defval, String description) {
        Option option = Option.integer((String)"jruby", (String)name2, (Enum)category, (Integer)defval, (String)description);
        _loadedOptions.add(option);
        return option;
    }

    private static <T extends Enum<T>> Option<T> enumeration(Category category, String name2, Class<T> enumClass, T defval, String description) {
        Option option = Option.enumeration((String)"jruby", (String)name2, (Enum)category, defval, (String)description);
        _loadedOptions.add(option);
        return option;
    }

    private static boolean calculateInvokedynamicDefault() {
        return false;
    }

    public static void listPrefix(String prefix) {
        Options.list(SearchMode.PREFIX, prefix);
    }

    public static void listContains(String substring) {
        Options.list(SearchMode.CONTAINS, substring);
    }

    private static void list(SearchMode mode2, String string2) {
        for (Option option : PROPERTIES) {
            boolean include2 = false;
            switch (mode2) {
                case PREFIX: {
                    include2 = option.shortName().startsWith(string2);
                    break;
                }
                case CONTAINS: {
                    include2 = option.shortName().contains(string2);
                }
            }
            if (!include2) continue;
            System.out.printf("%s=%s\n", option.shortName(), option.load());
        }
    }

    public static Set<String> getPropertyNames() {
        HashSet<String> propertyNames = new HashSet<String>();
        for (Option option : PROPERTIES) {
            propertyNames.add(option.propertyName());
        }
        return Collections.unmodifiableSet(propertyNames);
    }

    private static enum SearchMode {
        PREFIX,
        CONTAINS;

    }
}

