/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import java.nio.ByteBuffer;
import java.util.Locale;
import jnr.constants.platform.Errno;
import jnr.constants.platform.ProtocolFamily;
import jnr.constants.platform.Sock;
import jnr.constants.platform.SocketLevel;
import jnr.constants.platform.SocketOption;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.Pack;
import org.jruby.util.Sprintf;

public class Option
extends RubyObject {
    private ProtocolFamily family;
    private SocketLevel level;
    private SocketOption option;
    private ByteList data;
    private long intData;

    public static void createOption(Ruby runtime) {
        RubyClass addrinfo = runtime.getClass("Socket").defineClassUnder("Option", runtime.getObject(), new ObjectAllocator(){

            @Override
            public IRubyObject allocate(Ruby runtime, RubyClass klazz) {
                return new Option(runtime, klazz);
            }
        });
        addrinfo.defineAnnotatedMethods(Option.class);
    }

    public Option(Ruby runtime, RubyClass klass) {
        super(runtime, klass);
    }

    public Option(Ruby runtime, ProtocolFamily family2, SocketLevel level2, SocketOption option, int data2) {
        this(runtime, (RubyClass)runtime.getClassFromPath("Socket::Option"), family2, level2, option, data2);
    }

    public Option(Ruby runtime, RubyClass klass, ProtocolFamily family2, SocketLevel level2, SocketOption option, int data2) {
        super(runtime, klass);
        this.family = family2;
        this.level = level2;
        this.option = option;
        this.intData = data2;
        ByteList result2 = new ByteList(4);
        this.data = Pack.packInt_i(result2, data2);
    }

    @JRubyMethod(required=4, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2) {
        this.family = ProtocolFamily.valueOf((long)args2[0].convertToInteger().getLongValue());
        this.level = SocketLevel.valueOf((long)args2[1].convertToInteger().getLongValue());
        this.option = SocketOption.valueOf((long)args2[2].convertToInteger().getLongValue());
        this.data = args2[3].convertToString().getByteList();
        this.intData = Pack.unpackInt_i(ByteBuffer.wrap(this.data.bytes()));
        return context.nil;
    }

    @JRubyMethod
    public IRubyObject family(ThreadContext context) {
        return context.runtime.newFixnum(this.family.longValue());
    }

    @JRubyMethod
    public IRubyObject level(ThreadContext context) {
        return context.runtime.newFixnum(this.level.longValue());
    }

    @JRubyMethod
    public IRubyObject optname(ThreadContext context) {
        return context.runtime.newFixnum(this.option.longValue());
    }

    @JRubyMethod
    public IRubyObject data(ThreadContext context) {
        return RubyString.newString(context.runtime, this.data).freeze(context);
    }

    @JRubyMethod
    public IRubyObject inspect(ThreadContext context) {
        StringBuffer buf = new StringBuffer("#<");
        buf.append(this.metaClass.getRealClass().getName()).append(" ").append(this.noPrefix(this.family));
        if (this.level == SocketLevel.SOL_SOCKET) {
            buf.append(" SOCKET ").append(this.noPrefix(this.option));
        } else if (this.family == ProtocolFamily.PF_UNIX) {
            buf.append(" level:").append(this.level.longValue()).append(" ").append(this.noPrefix(this.option));
        } else {
            buf.append(" level:").append(this.level.description()).append(" ").append(this.noPrefix(this.option));
        }
        buf.append(" ").append(this.optionValue()).append(">");
        return context.runtime.newString(buf.toString());
    }

    private String noPrefix(ProtocolFamily family2) {
        return family2.description().substring("PF_".length());
    }

    private String noPrefix(SocketOption option) {
        return option.description().substring("SO_".length());
    }

    private String optionValue() {
        switch (this.option) {
            case SO_DEBUG: 
            case SO_ACCEPTCONN: 
            case SO_BROADCAST: 
            case SO_REUSEADDR: 
            case SO_KEEPALIVE: 
            case SO_OOBINLINE: 
            case SO_SNDBUF: 
            case SO_RCVBUF: 
            case SO_DONTROUTE: 
            case SO_RCVLOWAT: 
            case SO_SNDLOWAT: {
                return String.valueOf(this.intData);
            }
            case SO_LINGER: {
                return this.intData == -1L ? "off" : (this.intData == 0L ? "on" : "on(" + this.intData + ")");
            }
            case SO_RCVTIMEO: 
            case SO_SNDTIMEO: {
                return Sprintf.getNumberFormat(Locale.getDefault()).format((double)this.intData / 1000.0);
            }
            case SO_ERROR: {
                return Errno.valueOf((long)this.intData).description();
            }
            case SO_TYPE: {
                return Sock.valueOf((long)this.intData).description();
            }
        }
        return "";
    }

    @JRubyMethod(meta=true)
    public IRubyObject rb_int(ThreadContext context, IRubyObject self2) {
        return context.nil;
    }

    @JRubyMethod(name={"int"})
    public IRubyObject asInt(ThreadContext context) {
        return context.getRuntime().newFixnum((int)this.intData);
    }

    @JRubyMethod(meta=true)
    public IRubyObject bool(ThreadContext context, IRubyObject self2) {
        return context.nil;
    }

    @JRubyMethod
    public IRubyObject bool(ThreadContext context) {
        return context.nil;
    }

    @JRubyMethod(meta=true)
    public IRubyObject linger(ThreadContext context, IRubyObject self2) {
        return context.nil;
    }

    @JRubyMethod
    public IRubyObject linger(ThreadContext context) {
        return context.nil;
    }

    @JRubyMethod
    public IRubyObject unpack(ThreadContext context, IRubyObject arg0) {
        return Pack.unpack(context.runtime, this.data, arg0.convertToString().getByteList());
    }

    @JRubyMethod
    public IRubyObject to_s(ThreadContext context) {
        return RubyString.newString(context.runtime, this.data);
    }
}

