/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import com.headius.invokebinder.Binder;
import com.kenai.jffi.CallContext;
import com.kenai.jffi.InvokeDynamicSupport;
import com.kenai.jffi.Platform;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.ext.ffi.NativeType;
import org.jruby.ext.ffi.Type;
import org.jruby.ext.ffi.jffi.DefaultMethod;
import org.jruby.ext.ffi.jffi.JITRuntime;
import org.jruby.ext.ffi.jffi.NativeInvoker;
import org.jruby.ext.ffi.jffi.Signature;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.invokedynamic.JRubyCallSite;
import org.jruby.util.CodegenUtils;
import org.jruby.util.cli.Options;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public final class InvokeDynamic {
    private static final Logger LOG = LoggerFactory.getLogger("ffi invokedynamic");

    private InvokeDynamic() {
    }

    public static MethodHandle getMethodHandle(JRubyCallSite site, DynamicMethod method) {
        try {
            MethodHandle fast = InvokeDynamic.getFastNumericMethodHandle(site, method);
            if (fast == null) {
                return InvokeDynamic.generateNativeInvokerHandle(site, method);
            }
            MethodHandle guard = InvokeDynamic.getDirectPointerParameterGuard(site, method);
            return guard != null ? MethodHandles.guardWithTest(guard, fast, InvokeDynamic.generateNativeInvokerHandle(site, method)) : fast;
        }
        catch (IndyNotSupportedException inse) {
            if (((Boolean)Options.INVOKEDYNAMIC_LOG_BINDING.load()).booleanValue()) {
                LOG.info(site.name() + "\t" + inse.getLocalizedMessage(), new Object[0]);
            }
            return null;
        }
        catch (NullPointerException npe) {
            if (((Boolean)Options.INVOKEDYNAMIC_LOG_BINDING.load()).booleanValue()) {
                LOG.info(site.name() + "\t" + npe.getLocalizedMessage(), new Object[0]);
            }
            return null;
        }
    }

    public static MethodHandle getFastNumericMethodHandle(JRubyCallSite site, DynamicMethod method) {
        long functionAddress;
        Signature signature = method instanceof NativeInvoker ? ((NativeInvoker)method).getSignature() : ((DefaultMethod)method).getSignature();
        CallContext callContext = method instanceof NativeInvoker ? ((NativeInvoker)method).getCallContext() : ((DefaultMethod)method).getCallContext();
        InvokeDynamicSupport.Invoker jffiInvoker = InvokeDynamicSupport.getFastNumericInvoker((CallContext)callContext, (long)(functionAddress = method instanceof NativeInvoker ? ((NativeInvoker)method).getFunctionAddress() : ((DefaultMethod)method).getFunctionAddress()));
        if (jffiInvoker == null || jffiInvoker.getMethod() == null || !(jffiInvoker.getMethodHandle() instanceof MethodHandle)) {
            return null;
        }
        MethodHandle nativeInvoker = (MethodHandle)jffiInvoker.getMethodHandle();
        Method invokerMethod = jffiInvoker.getMethod();
        Class<?> nativeIntClass = invokerMethod.getReturnType();
        MethodHandle resultFilter = InvokeDynamic.getResultFilter(method.getImplementationClass().getRuntime(), signature.getResultType().getNativeType(), nativeIntClass);
        if (resultFilter == null) {
            return null;
        }
        MethodHandle[] parameterFilters = InvokeDynamic.getParameterFilters(signature, nativeIntClass);
        if (parameterFilters == null) {
            return null;
        }
        MethodHandle targetHandle = Binder.from(IRubyObject.class, (Class[])CodegenUtils.params(IRubyObject.class, signature.getParameterCount())).filter(0, parameterFilters).filterReturn(resultFilter).invoke(nativeInvoker);
        if (signature.getParameterCount() > 3) {
            targetHandle = targetHandle.asSpreader(IRubyObject[].class, signature.getParameterCount());
        }
        MethodHandle methodHandle = Binder.from((MethodType)site.type()).drop(0, 3).invoke(targetHandle);
        if (((Boolean)Options.INVOKEDYNAMIC_LOG_BINDING.load()).booleanValue()) {
            LOG.info(site.name() + "\tbound to ffi method " + InvokeDynamic.logMethod(method) + String.format("[function address=%x]: ", functionAddress) + invokerMethod, new Object[0]);
        }
        return methodHandle;
    }

    private static MethodHandle generateNativeInvokerHandle(JRubyCallSite site, DynamicMethod method) throws IndyNotSupportedException {
        MethodHandle nativeTarget;
        if (method instanceof DefaultMethod) {
            NativeInvoker nativeInvoker = ((DefaultMethod)method).forceCompilation();
            if (nativeInvoker == null) {
                throw new IndyNotSupportedException("compilation failed");
            }
            method = nativeInvoker;
        }
        if (!method.getArity().isFixed()) {
            throw new IndyNotSupportedException("non fixed arity");
        }
        if (method.getArity().getValue() > 6) {
            throw new IndyNotSupportedException("arity > 6");
        }
        if (!CallConfiguration.FrameNoneScopeNone.equals((Object)method.getCallConfig())) {
            throw new IndyNotSupportedException("cannot bindy functions with scope or frame");
        }
        Object[] callMethodParameters = new Class[4 + method.getArity().getValue()];
        callMethodParameters[0] = ThreadContext.class;
        callMethodParameters[1] = IRubyObject.class;
        callMethodParameters[2] = RubyModule.class;
        callMethodParameters[3] = String.class;
        Arrays.fill(callMethodParameters, 4, callMethodParameters.length, IRubyObject.class);
        try {
            nativeTarget = site.lookup().findVirtual(method.getClass(), "call", MethodType.methodType(IRubyObject.class, callMethodParameters));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        int argCount = method.getArity().getValue();
        if (argCount > 3) {
            nativeTarget = nativeTarget.asSpreader(IRubyObject[].class, argCount);
        }
        nativeTarget = Binder.from((MethodType)site.type()).drop(1, 1).insert(2, new Object[]{method.getImplementationClass(), site.name()}).invoke(nativeTarget.bindTo(method));
        method.setHandle(nativeTarget);
        if (((Boolean)Options.INVOKEDYNAMIC_LOG_BINDING.load()).booleanValue()) {
            LOG.info(site.name() + "\tbound to ffi method " + InvokeDynamic.logMethod(method) + ": " + IRubyObject.class.getSimpleName() + " " + method.getClass().getSimpleName() + ".call" + CodegenUtils.prettyShortParams((Class[])callMethodParameters), new Object[0]);
        }
        return nativeTarget;
    }

    private static String logMethod(DynamicMethod method) {
        return "[#" + method.getSerialNumber() + " " + method.getImplementationClass() + "]";
    }

    private static MethodHandle findResultHelper(String name2, Class nativeIntClass) {
        return org.jruby.runtime.invokedynamic.InvokeDynamicSupport.findStatic(JITRuntime.class, name2, MethodType.methodType(IRubyObject.class, Ruby.class, nativeIntClass));
    }

    private static MethodHandle getResultFilter(Ruby runtime, NativeType nativeType, Class nativeIntClass) {
        MethodHandle resultFilter;
        switch (nativeType) {
            case VOID: {
                return Binder.from(IRubyObject.class, (Class)nativeIntClass, (Class[])new Class[0]).drop(0).constant((Object)runtime.getNil());
            }
            case BOOL: {
                resultFilter = InvokeDynamic.findResultHelper("newBoolean", nativeIntClass);
                break;
            }
            case CHAR: {
                resultFilter = InvokeDynamic.findResultHelper("newSigned8", nativeIntClass);
                break;
            }
            case UCHAR: {
                resultFilter = InvokeDynamic.findResultHelper("newUnsigned8", nativeIntClass);
                break;
            }
            case SHORT: {
                resultFilter = InvokeDynamic.findResultHelper("newSigned16", nativeIntClass);
                break;
            }
            case USHORT: {
                resultFilter = InvokeDynamic.findResultHelper("newUnsigned16", nativeIntClass);
                break;
            }
            case INT: {
                resultFilter = InvokeDynamic.findResultHelper("newSigned32", nativeIntClass);
                break;
            }
            case UINT: {
                resultFilter = InvokeDynamic.findResultHelper("newUnsigned32", nativeIntClass);
                break;
            }
            case LONG: {
                resultFilter = InvokeDynamic.findResultHelper("newSigned" + Platform.getPlatform().longSize(), nativeIntClass);
                break;
            }
            case ULONG: {
                resultFilter = InvokeDynamic.findResultHelper("newUnsigned" + Platform.getPlatform().longSize(), nativeIntClass);
                break;
            }
            case LONG_LONG: {
                resultFilter = InvokeDynamic.findResultHelper("newSigned64", nativeIntClass);
                break;
            }
            case ULONG_LONG: {
                resultFilter = InvokeDynamic.findResultHelper("newUnsigned64", nativeIntClass);
                break;
            }
            case FLOAT: {
                resultFilter = InvokeDynamic.findResultHelper("newFloat32", nativeIntClass);
                break;
            }
            case DOUBLE: {
                resultFilter = InvokeDynamic.findResultHelper("newFloat64", nativeIntClass);
                break;
            }
            case POINTER: {
                resultFilter = InvokeDynamic.findResultHelper("newPointer" + Platform.getPlatform().addressSize(), nativeIntClass);
                break;
            }
            case STRING: 
            case TRANSIENT_STRING: {
                resultFilter = InvokeDynamic.findResultHelper("newString", nativeIntClass);
                break;
            }
            default: {
                return null;
            }
        }
        return MethodHandles.insertArguments(resultFilter, 0, runtime);
    }

    private static MethodHandle findParameterHelper(String name2, Class nativeIntClass) {
        return org.jruby.runtime.invokedynamic.InvokeDynamicSupport.findStatic(JITRuntime.class, name2 + (Integer.TYPE == nativeIntClass ? 32 : 64), MethodType.methodType(nativeIntClass, IRubyObject.class));
    }

    private static MethodHandle[] getParameterFilters(Signature signature, Class nativeIntClass) {
        MethodHandle[] parameterFilters = new MethodHandle[signature.getParameterCount()];
        for (int i2 = 0; i2 < signature.getParameterCount(); ++i2) {
            MethodHandle ph;
            if (!(signature.getParameterType(i2) instanceof Type.Builtin)) {
                return null;
            }
            switch (signature.getParameterType(i2).getNativeType()) {
                case BOOL: {
                    ph = InvokeDynamic.findParameterHelper("boolValue", nativeIntClass);
                    break;
                }
                case CHAR: {
                    ph = InvokeDynamic.findParameterHelper("s8Value", nativeIntClass);
                    break;
                }
                case UCHAR: {
                    ph = InvokeDynamic.findParameterHelper("u8Value", nativeIntClass);
                    break;
                }
                case SHORT: {
                    ph = InvokeDynamic.findParameterHelper("s16Value", nativeIntClass);
                    break;
                }
                case USHORT: {
                    ph = InvokeDynamic.findParameterHelper("u16Value", nativeIntClass);
                    break;
                }
                case INT: {
                    ph = InvokeDynamic.findParameterHelper("s32Value", nativeIntClass);
                    break;
                }
                case UINT: {
                    ph = InvokeDynamic.findParameterHelper("u32Value", nativeIntClass);
                    break;
                }
                case LONG: {
                    ph = InvokeDynamic.findParameterHelper("s" + Platform.getPlatform().longSize() + "Value", nativeIntClass);
                    break;
                }
                case ULONG: {
                    ph = InvokeDynamic.findParameterHelper("u" + Platform.getPlatform().longSize() + "Value", nativeIntClass);
                    break;
                }
                case LONG_LONG: {
                    ph = InvokeDynamic.findParameterHelper("s64Value", nativeIntClass);
                    break;
                }
                case ULONG_LONG: {
                    ph = InvokeDynamic.findParameterHelper("u64Value", nativeIntClass);
                    break;
                }
                case FLOAT: {
                    ph = InvokeDynamic.findParameterHelper("f32Value", nativeIntClass);
                    break;
                }
                case DOUBLE: {
                    ph = InvokeDynamic.findParameterHelper("f64Value", nativeIntClass);
                    break;
                }
                case POINTER: 
                case BUFFER_IN: 
                case BUFFER_OUT: 
                case BUFFER_INOUT: {
                    ph = InvokeDynamic.findParameterHelper("pointerValue", nativeIntClass);
                    break;
                }
                default: {
                    return null;
                }
            }
            parameterFilters[i2] = ph;
        }
        return parameterFilters;
    }

    private static MethodHandle getDirectPointerParameterGuard(JRubyCallSite site, DynamicMethod method) {
        Signature signature = method instanceof NativeInvoker ? ((NativeInvoker)method).getSignature() : ((DefaultMethod)method).getSignature();
        Object[] guards = new MethodHandle[signature.getParameterCount()];
        Arrays.fill(guards, 0, guards.length, Binder.from(Boolean.TYPE, IRubyObject.class, (Class[])new Class[0]).drop(0, 1).constant((Object)true));
        boolean guardNeeded = false;
        for (int i2 = 0; i2 < signature.getParameterCount(); ++i2) {
            switch (signature.getParameterType(i2).getNativeType()) {
                case POINTER: 
                case BUFFER_IN: 
                case BUFFER_OUT: 
                case BUFFER_INOUT: {
                    guards[i2] = org.jruby.runtime.invokedynamic.InvokeDynamicSupport.findStatic(JITRuntime.class, "isDirectPointer", MethodType.methodType(Boolean.TYPE, IRubyObject.class));
                    guardNeeded = true;
                }
            }
        }
        if (!guardNeeded) {
            return null;
        }
        MethodHandle isTrue = org.jruby.runtime.invokedynamic.InvokeDynamicSupport.findStatic(JITRuntime.class, "isTrue", MethodType.methodType(Boolean.TYPE, CodegenUtils.params(Boolean.TYPE, signature.getParameterCount())));
        isTrue = Binder.from(Boolean.TYPE, (Class[])CodegenUtils.params(IRubyObject.class, signature.getParameterCount())).filter(0, (MethodHandle[])guards).invoke(isTrue);
        if (signature.getParameterCount() > 3) {
            isTrue = isTrue.asSpreader(IRubyObject[].class, signature.getParameterCount());
        }
        return Binder.from((MethodType)site.type().changeReturnType(Boolean.TYPE)).drop(0, 3).invoke(isTrue);
    }

    private static final class IndyNotSupportedException
    extends Exception {
        private IndyNotSupportedException() {
        }

        private IndyNotSupportedException(String message2) {
            super(message2);
        }
    }
}

