/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.invokedynamic;

import com.headius.invokebinder.Binder;
import com.headius.invokebinder.Signature;
import com.headius.invokebinder.SmartBinder;
import com.headius.invokebinder.SmartHandle;
import java.lang.invoke.CallSite;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.SwitchPoint;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyLocalJumpError;
import org.jruby.RubyModule;
import org.jruby.RubyNil;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.JumpException;
import org.jruby.ext.ffi.jffi.DefaultMethod;
import org.jruby.ext.ffi.jffi.InvokeDynamic;
import org.jruby.ext.ffi.jffi.JITNativeInvoker;
import org.jruby.internal.runtime.methods.AliasMethod;
import org.jruby.internal.runtime.methods.AttrReaderMethod;
import org.jruby.internal.runtime.methods.AttrWriterMethod;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.Framing;
import org.jruby.internal.runtime.methods.HandleMethod;
import org.jruby.internal.runtime.methods.ProfilingDynamicMethod;
import org.jruby.internal.runtime.methods.Scoping;
import org.jruby.internal.runtime.methods.WrapperMethod;
import org.jruby.java.invokers.SingletonMethodInvoker;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.proxy.InternalJavaProxy;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CacheEntry;
import org.jruby.runtime.invokedynamic.InvokeDynamicSupport;
import org.jruby.runtime.invokedynamic.JRubyCallSite;
import org.jruby.runtime.ivars.FieldVariableAccessor;
import org.jruby.runtime.ivars.VariableAccessor;
import org.jruby.util.ByteList;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JavaNameMangler;
import org.jruby.util.cli.Options;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class InvocationLinker {
    private static final Logger LOG = LoggerFactory.getLogger("InvocationLinker");
    private static final List<HandleGenerator> HANDLE_GENERATORS = Arrays.asList(new HandleMethodGenerator(), new AttrReaderGenerator(), new AttrWriterGenerator(), new FFIGenerator(), new JavaCallGenerator(), new CoreCallGenerator());
    private static final MethodHandle BLOCK_ESCAPE = InvokeDynamicSupport.findStatic(InvocationLinker.class, "blockEscape", MethodType.methodType(Void.TYPE, Block.class));
    private static final MethodHandle IS_JAVA_SUBCLASS = InvokeDynamicSupport.findStatic(InvocationLinker.class, "subclassProxyTest", MethodType.methodType(Boolean.TYPE, Object.class));
    private static final MethodHandle PGC = Binder.from(RubyClass.class, ThreadContext.class, (Class[])new Class[]{IRubyObject.class}).invokeStaticQuiet(MethodHandles.lookup(), InvokeDynamicSupport.class, "pollAndGetClass");
    private static final MethodHandle TEST_GENERATION = Binder.from(Boolean.TYPE, Integer.TYPE, (Class[])new Class[]{IRubyObject.class}).invokeStaticQuiet(MethodHandles.lookup(), InvocationLinker.class, "testGeneration");
    private static final MethodHandle TEST_METACLASS;
    private static final MethodHandle TEST;
    private static final MethodHandle TEST_CLASS;
    private static final Signature DYNAMIC_CALL_SIG;
    private static final Signature DYNAMIC_CALL_SIG_1ARG;
    private static final Signature DYNAMIC_CALL_SIG_2ARG;
    private static final Signature DYNAMIC_CALL_SIG_3ARG;
    private static final Signature DYNAMIC_CALL_SIG_NARG;
    private static final Signature DYNAMIC_CALL_SIG_BLOCK;
    private static final Signature DYNAMIC_CALL_SIG_1ARG_BLOCK;
    private static final Signature DYNAMIC_CALL_SIG_2ARG_BLOCK;
    private static final Signature DYNAMIC_CALL_SIG_3ARG_BLOCK;
    private static final Signature DYNAMIC_CALL_SIG_NARG_BLOCK;
    private static final Signature DYNAMIC_METHOD_SIG;
    private static final Signature DYNAMIC_METHOD_SIG_1ARG;
    private static final Signature DYNAMIC_METHOD_SIG_2ARG;
    private static final Signature DYNAMIC_METHOD_SIG_3ARG;
    private static final Signature DYNAMIC_METHOD_SIG_NARG;
    private static final Signature DYNAMIC_METHOD_SIG_BLOCK;
    private static final Signature DYNAMIC_METHOD_SIG_1ARG_BLOCK;
    private static final Signature DYNAMIC_METHOD_SIG_2ARG_BLOCK;
    private static final Signature DYNAMIC_METHOD_SIG_3ARG_BLOCK;
    private static final Signature DYNAMIC_METHOD_SIG_NARG_BLOCK;
    private static final MethodHandle TARGET_0;
    private static final MethodHandle TARGET_1;
    private static final MethodHandle TARGET_2;
    private static final MethodHandle TARGET_3;
    private static final MethodHandle TARGET_N;
    private static final MethodHandle TARGET_0_B;
    private static final MethodHandle TARGET_1_B;
    private static final MethodHandle TARGET_2_B;
    private static final MethodHandle TARGET_3_B;
    private static final MethodHandle TARGET_N_B;
    private static final Signature FALLBACK_SIG;
    private static final Signature FALLBACK_SIG_1ARG;
    private static final Signature FALLBACK_SIG_2ARG;
    private static final Signature FALLBACK_SIG_3ARG;
    private static final Signature FALLBACK_SIG_NARG;
    private static final Signature FALLBACK_SIG_BLOCK;
    private static final Signature FALLBACK_SIG_1ARG_BLOCK;
    private static final Signature FALLBACK_SIG_2ARG_BLOCK;
    private static final Signature FALLBACK_SIG_3ARG_BLOCK;
    private static final Signature FALLBACK_SIG_NARG_BLOCK;
    private static final MethodHandle FALLBACK_0;
    private static final MethodHandle FALLBACK_1;
    private static final MethodHandle FALLBACK_2;
    private static final MethodHandle FALLBACK_3;
    private static final MethodHandle FALLBACK_N;
    private static final MethodHandle FALLBACK_0_B;
    private static final MethodHandle FALLBACK_1_B;
    private static final MethodHandle FALLBACK_2_B;
    private static final MethodHandle FALLBACK_3_B;
    private static final MethodHandle FALLBACK_N_B;
    private static final MethodHandle FAIL_0;
    private static final MethodHandle FAIL_1;
    private static final MethodHandle FAIL_2;
    private static final MethodHandle FAIL_3;
    private static final MethodHandle FAIL_N;
    private static final MethodHandle FAIL_0_B;
    private static final MethodHandle FAIL_1_B;
    private static final MethodHandle FAIL_2_B;
    private static final MethodHandle FAIL_3_B;
    private static final MethodHandle FAIL_N_B;
    private static final MethodHandle[] FALLBACKS;
    private static final MethodHandle[] FAILS;
    private static final MethodHandle[] FALLBACKS_B;
    private static final MethodHandle[] FAILS_B;

    public static CallSite invocationBootstrap(MethodHandles.Lookup lookup, String name2, MethodType type2, String file2, int line) throws NoSuchMethodException, IllegalAccessException {
        String[] names2 = name2.split(":");
        String operation = names2[0];
        if (name2.equals("yieldSpecific")) {
            MethodHandle target = lookup.findStatic(InvocationLinker.class, "yieldSpecificFallback", type2);
            return new ConstantCallSite(target);
        }
        JRubyCallSite site = null;
        String method = JavaNameMangler.demangleMethodName(names2[1]);
        MethodType fallbackType = type2.insertParameterTypes(0, JRubyCallSite.class);
        MethodHandle myFallback = MethodHandles.insertArguments(lookup.findStatic(InvocationLinker.class, "invocationFallback", fallbackType), 0, site);
        site.setInitialTarget(myFallback);
        return site;
    }

    public static IRubyObject invocationFallback(JRubyCallSite site, ThreadContext context, IRubyObject caller, IRubyObject self2) throws Throwable {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self2);
        String method = site.name();
        SwitchPoint switchPoint = (SwitchPoint)selfClass.getInvalidator().getData();
        CacheEntry entry = selfClass.searchWithCache(method);
        if (InvokeDynamicSupport.methodMissing(entry, site.callType(), method, caller)) {
            return InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self2, method);
        }
        MethodHandle target = InvocationLinker.getTarget(site, selfClass, entry, 0);
        target = InvocationLinker.updateInvocationTarget(target, site, self2, selfClass, method, entry, switchPoint, false, 0);
        return (IRubyObject)target.invokeWithArguments(context, caller, self2);
    }

    public static IRubyObject invocationFallback(JRubyCallSite site, ThreadContext context, IRubyObject caller, IRubyObject self2, IRubyObject arg0) throws Throwable {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self2);
        String method = site.name();
        SwitchPoint switchPoint = (SwitchPoint)selfClass.getInvalidator().getData();
        CacheEntry entry = selfClass.searchWithCache(method);
        if (InvokeDynamicSupport.methodMissing(entry, site.callType(), method, caller)) {
            IRubyObject mmResult = InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self2, method, arg0);
            return site.isAttrAssign() ? arg0 : mmResult;
        }
        MethodHandle target = InvocationLinker.getTarget(site, selfClass, entry, 1);
        target = InvocationLinker.updateInvocationTarget(target, site, self2, selfClass, method, entry, switchPoint, false, 1);
        return (IRubyObject)target.invokeWithArguments(context, caller, self2, arg0);
    }

    public static IRubyObject invocationFallback(JRubyCallSite site, ThreadContext context, IRubyObject caller, IRubyObject self2, IRubyObject arg0, IRubyObject arg1) throws Throwable {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self2);
        String method = site.name();
        SwitchPoint switchPoint = (SwitchPoint)selfClass.getInvalidator().getData();
        CacheEntry entry = selfClass.searchWithCache(method);
        if (InvokeDynamicSupport.methodMissing(entry, site.callType(), method, caller)) {
            IRubyObject mmResult = InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self2, method, arg0, arg1);
            return site.isAttrAssign() ? arg1 : mmResult;
        }
        MethodHandle target = InvocationLinker.getTarget(site, selfClass, entry, 2);
        target = InvocationLinker.updateInvocationTarget(target, site, self2, selfClass, method, entry, switchPoint, false, 2);
        return (IRubyObject)target.invokeWithArguments(context, caller, self2, arg0, arg1);
    }

    public static IRubyObject invocationFallback(JRubyCallSite site, ThreadContext context, IRubyObject caller, IRubyObject self2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) throws Throwable {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self2);
        String method = site.name();
        SwitchPoint switchPoint = (SwitchPoint)selfClass.getInvalidator().getData();
        CacheEntry entry = selfClass.searchWithCache(method);
        if (InvokeDynamicSupport.methodMissing(entry, site.callType(), method, caller)) {
            IRubyObject mmResult = InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self2, method, arg0, arg1, arg2);
            return site.isAttrAssign() ? arg2 : mmResult;
        }
        MethodHandle target = InvocationLinker.getTarget(site, selfClass, entry, 3);
        target = InvocationLinker.updateInvocationTarget(target, site, self2, selfClass, method, entry, switchPoint, false, 3);
        return (IRubyObject)target.invokeWithArguments(context, caller, self2, arg0, arg1, arg2);
    }

    public static IRubyObject invocationFallback(JRubyCallSite site, ThreadContext context, IRubyObject caller, IRubyObject self2, IRubyObject[] args2) throws Throwable {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self2);
        String method = site.name();
        SwitchPoint switchPoint = (SwitchPoint)selfClass.getInvalidator().getData();
        CacheEntry entry = selfClass.searchWithCache(method);
        if (InvokeDynamicSupport.methodMissing(entry, site.callType(), method, caller)) {
            IRubyObject mmResult = InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self2, method, args2);
            return site.isAttrAssign() ? args2[args2.length - 1] : mmResult;
        }
        MethodHandle target = InvocationLinker.getTarget(site, selfClass, entry, -1);
        target = InvocationLinker.updateInvocationTarget(target, site, self2, selfClass, method, entry, switchPoint, false, 4);
        return (IRubyObject)target.invokeWithArguments(context, caller, self2, args2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject invocationFallback(JRubyCallSite site, ThreadContext context, IRubyObject caller, IRubyObject self2, Block block) throws Throwable {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self2);
        String method = site.name();
        SwitchPoint switchPoint = (SwitchPoint)selfClass.getInvalidator().getData();
        CacheEntry entry = selfClass.searchWithCache(method);
        if (InvokeDynamicSupport.methodMissing(entry, site.callType(), method, caller)) {
            try {
                IRubyObject iRubyObject = InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self2, method, block);
                return iRubyObject;
            }
            finally {
                if (site.isIterator()) {
                    block.escape();
                }
            }
        }
        MethodHandle target = InvocationLinker.getTarget(site, selfClass, entry, 0);
        target = InvocationLinker.updateInvocationTarget(target, site, self2, selfClass, method, entry, switchPoint, true, 0);
        return (IRubyObject)target.invokeWithArguments(context, caller, self2, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject invocationFallback(JRubyCallSite site, ThreadContext context, IRubyObject caller, IRubyObject self2, IRubyObject arg0, Block block) throws Throwable {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self2);
        String method = site.name();
        SwitchPoint switchPoint = (SwitchPoint)selfClass.getInvalidator().getData();
        CacheEntry entry = selfClass.searchWithCache(method);
        if (InvokeDynamicSupport.methodMissing(entry, site.callType(), method, caller)) {
            try {
                IRubyObject iRubyObject = InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self2, method, arg0, block);
                return iRubyObject;
            }
            finally {
                if (site.isIterator()) {
                    block.escape();
                }
            }
        }
        MethodHandle target = InvocationLinker.getTarget(site, selfClass, entry, 1);
        target = InvocationLinker.updateInvocationTarget(target, site, self2, selfClass, method, entry, switchPoint, true, 1);
        return (IRubyObject)target.invokeWithArguments(context, caller, self2, arg0, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject invocationFallback(JRubyCallSite site, ThreadContext context, IRubyObject caller, IRubyObject self2, IRubyObject arg0, IRubyObject arg1, Block block) throws Throwable {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self2);
        String method = site.name();
        SwitchPoint switchPoint = (SwitchPoint)selfClass.getInvalidator().getData();
        CacheEntry entry = selfClass.searchWithCache(method);
        if (InvokeDynamicSupport.methodMissing(entry, site.callType(), method, caller)) {
            try {
                IRubyObject iRubyObject = InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self2, method, arg0, arg1, block);
                return iRubyObject;
            }
            finally {
                if (site.isIterator()) {
                    block.escape();
                }
            }
        }
        MethodHandle target = InvocationLinker.getTarget(site, selfClass, entry, 2);
        target = InvocationLinker.updateInvocationTarget(target, site, self2, selfClass, method, entry, switchPoint, true, 2);
        return (IRubyObject)target.invokeWithArguments(context, caller, self2, arg0, arg1, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject invocationFallback(JRubyCallSite site, ThreadContext context, IRubyObject caller, IRubyObject self2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) throws Throwable {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self2);
        String method = site.name();
        SwitchPoint switchPoint = (SwitchPoint)selfClass.getInvalidator().getData();
        CacheEntry entry = selfClass.searchWithCache(method);
        if (InvokeDynamicSupport.methodMissing(entry, site.callType(), method, caller)) {
            try {
                IRubyObject iRubyObject = InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self2, method, arg0, arg1, arg2, block);
                return iRubyObject;
            }
            finally {
                if (site.isIterator()) {
                    block.escape();
                }
            }
        }
        MethodHandle target = InvocationLinker.getTarget(site, selfClass, entry, 3);
        target = InvocationLinker.updateInvocationTarget(target, site, self2, selfClass, method, entry, switchPoint, true, 3);
        return (IRubyObject)target.invokeWithArguments(context, caller, self2, arg0, arg1, arg2, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject invocationFallback(JRubyCallSite site, ThreadContext context, IRubyObject caller, IRubyObject self2, IRubyObject[] args2, Block block) throws Throwable {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self2);
        String method = site.name();
        SwitchPoint switchPoint = (SwitchPoint)selfClass.getInvalidator().getData();
        CacheEntry entry = selfClass.searchWithCache(method);
        if (InvokeDynamicSupport.methodMissing(entry, site.callType(), method, caller)) {
            try {
                IRubyObject iRubyObject = InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self2, method, args2, block);
                return iRubyObject;
            }
            finally {
                if (site.isIterator()) {
                    block.escape();
                }
            }
        }
        MethodHandle target = InvocationLinker.getTarget(site, selfClass, entry, -1);
        target = InvocationLinker.updateInvocationTarget(target, site, self2, selfClass, method, entry, switchPoint, true, 4);
        return (IRubyObject)target.invokeWithArguments(context, caller, self2, args2, block);
    }

    private static MethodHandle updateInvocationTarget(MethodHandle target, JRubyCallSite site, IRubyObject self2, RubyModule selfClass, String name2, CacheEntry entry, SwitchPoint switchPoint, boolean block, int arity2) {
        if (target == null || site.clearCount() > (Integer)Options.INVOKEDYNAMIC_MAXFAIL.load() || !site.hasSeenType(selfClass.id) && site.seenTypesCount() + 1 > (Integer)Options.INVOKEDYNAMIC_MAXPOLY.load()) {
            target = InvocationLinker.createFail((block ? FAILS_B : FAILS)[arity2], site, name2, entry.method);
            site.setTarget(target);
        } else {
            SmartHandle test2;
            boolean curry2;
            MethodHandle fallback;
            target = InvocationLinker.postProcess(site, target);
            if (site.seenTypesCount() > 0 && site.getTarget() != null && !site.hasSeenType(selfClass.id)) {
                if (((Boolean)Options.INVOKEDYNAMIC_LOG_BINDING.load()).booleanValue()) {
                    LOG.info(name2 + "\tadded to PIC " + InvocationLinker.logMethod(entry.method), new Object[0]);
                }
                fallback = site.getTarget();
                curry2 = false;
            } else {
                String bind2;
                String string2 = bind2 = site.boundOnce() ? "rebind" : "bind";
                if (((Boolean)Options.INVOKEDYNAMIC_LOG_BINDING.load()).booleanValue()) {
                    LOG.info(name2 + "\ttriggered site #" + site.siteID() + " " + bind2 + " (" + site.file() + ":" + site.line() + ")", new Object[0]);
                }
                fallback = (block ? FALLBACKS_B : FALLBACKS)[arity2];
                site.clearTypes();
                curry2 = true;
            }
            site.addType(selfClass.id);
            SmartBinder selfTest = SmartBinder.from((Signature)site.signature().asFold(Boolean.TYPE)).permute(new String[]{"self"});
            if (self2 instanceof RubySymbol || self2 instanceof RubyFixnum || self2 instanceof RubyFloat || self2 instanceof RubyNil || self2 instanceof RubyBoolean.True || self2 instanceof RubyBoolean.False) {
                test2 = selfTest.insert(1, "selfJavaType", self2.getClass()).cast(Boolean.TYPE, new Class[]{Object.class, Class.class}).invoke(TEST_CLASS);
            } else {
                selfTest = selfTest.insert(0, "selfClass", (Object)selfClass);
                test2 = selfTest.cast(Boolean.TYPE, new Class[]{RubyClass.class, IRubyObject.class}).invoke(TEST);
            }
            MethodHandle gwt = InvocationLinker.createGWT(test2, target, fallback, entry, site, curry2);
            gwt = switchPoint.guardWithTest(gwt, curry2 ? MethodHandles.insertArguments(fallback, 0, site) : fallback);
            site.setTarget(gwt);
        }
        return target;
    }

    public static IRubyObject yieldSpecificFallback(Block block, ThreadContext context) throws Throwable {
        return block.yieldSpecific(context);
    }

    public static IRubyObject yieldSpecificFallback(Block block, ThreadContext context, IRubyObject arg0) throws Throwable {
        return block.yieldSpecific(context, arg0);
    }

    public static IRubyObject yieldSpecificFallback(Block block, ThreadContext context, IRubyObject arg0, IRubyObject arg1) throws Throwable {
        return block.yieldSpecific(context, arg0, arg1);
    }

    public static IRubyObject yieldSpecificFallback(Block block, ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) throws Throwable {
        return block.yieldSpecific(context, arg0, arg1, arg2);
    }

    private static MethodHandle createFail(MethodHandle fail, JRubyCallSite site, String name2, DynamicMethod method) {
        if (((Boolean)Options.INVOKEDYNAMIC_LOG_BINDING.load()).booleanValue()) {
            LOG.info(name2 + "\tbound to inline cache failed " + InvocationLinker.logMethod(method), new Object[0]);
        }
        MethodHandle myFail = MethodHandles.insertArguments(fail, 0, site);
        myFail = InvocationLinker.postProcess(site, myFail);
        return myFail;
    }

    private static MethodHandle createGWT(SmartHandle test2, MethodHandle target, MethodHandle fallback, CacheEntry entry, JRubyCallSite site, boolean curryFallback) {
        MethodHandle myFallback = curryFallback ? MethodHandles.insertArguments(fallback, 0, site) : fallback;
        MethodHandle guardWithTest = test2.guard(target, myFallback);
        return guardWithTest;
    }

    public static int getNativeArgCount(DynamicMethod method, DynamicMethod.NativeCall nativeCall) {
        return InvocationLinker.getArgCount(nativeCall.getNativeSignature(), nativeCall.isStatic());
    }

    public static DynamicMethod unwrapMethod(DynamicMethod method, String[] realName) throws IndirectBindingException {
        while (method instanceof AliasMethod) {
            realName[0] = ((AliasMethod)method).getOldName();
            method = method.getRealMethod();
        }
        while (method instanceof WrapperMethod) {
            method = method.getRealMethod();
        }
        if (method instanceof ProfilingDynamicMethod) {
            throw new IndirectBindingException("profiling active");
        }
        return method;
    }

    private static MethodHandle tryDispatchDirect(JRubyCallSite site, RubyClass cls, DynamicMethod method) {
        String[] realName = new String[]{site.name()};
        method = InvocationLinker.unwrapMethod(method, realName);
        for (HandleGenerator generator : HANDLE_GENERATORS) {
            if (!generator.canGenerate(site, cls, method)) continue;
            return generator.generate(site, cls, method, realName[0]);
        }
        throw new IndirectBindingException("no direct path available for " + method.getClass().getName());
    }

    private static MethodHandle getTarget(JRubyCallSite site, RubyClass cls, CacheEntry entry, int arity2) {
        try {
            return InvocationLinker.tryDispatchDirect(site, cls, entry.method);
        }
        catch (IndirectBindingException _ibe) {
            IndirectBindingException ibe = _ibe;
            if (!((Boolean)Options.INVOKEDYNAMIC_INVOCATION_INDIRECT.load()).booleanValue()) {
                if (((Boolean)Options.INVOKEDYNAMIC_LOG_BINDING.load()).booleanValue()) {
                    LOG.info(site.name() + "\tfailed to bind to " + InvocationLinker.logMethod(entry.method) + ": " + ibe.getMessage(), new Object[0]);
                }
                return null;
            }
            if (((Boolean)Options.INVOKEDYNAMIC_LOG_BINDING.load()).booleanValue()) {
                LOG.info(site.name() + "\tbound indirectly to " + InvocationLinker.logMethod(entry.method) + ": " + ibe.getMessage(), new Object[0]);
            }
            MethodHandle dynMethodTarget = InvocationLinker.getDynamicMethodTarget(site.type(), arity2, entry.method);
            dynMethodTarget = MethodHandles.insertArguments(dynMethodTarget, 4, site.name());
            dynMethodTarget = MethodHandles.insertArguments(dynMethodTarget, 0, entry.method);
            return dynMethodTarget;
        }
    }

    private static MethodHandle postProcessNativeHandle(MethodHandle nativeTarget, JRubyCallSite site, DynamicMethod method, boolean checkArity, boolean rewriteStackTrace) {
        if (nativeTarget != null) {
            int nativeArgCount;
            nativeTarget = InvocationLinker.addOrRemoveBlock(site, nativeTarget);
            if (checkArity && (nativeArgCount = InvocationLinker.getNativeArgCount(method, method.getNativeCall())) == 4 && site.arity() == 4) {
                Method reflected = method.getNativeCall().getMethod();
                JRubyMethod annotation2 = reflected.getAnnotation(JRubyMethod.class);
                int required = annotation2.required();
                int optional = annotation2.optional();
                boolean rest2 = annotation2.rest();
                if (required > 0 || !rest2) {
                    MethodHandle arityCheck = Binder.from((MethodType)site.type().changeReturnType(Void.TYPE)).insert(0, new Class[]{Integer.TYPE, Integer.TYPE, Boolean.TYPE}, new Object[]{required, optional, rest2}).invokeStaticQuiet(site.lookup(), InvocationLinker.class, "checkArity");
                    nativeTarget = MethodHandles.foldArguments(nativeTarget, arityCheck);
                }
            }
            if (rewriteStackTrace) {
                SmartHandle rewriteHandle = SmartBinder.from((MethodHandles.Lookup)MethodHandles.lookup(), (Signature)site.signature().insertArg(0, "throwable", Throwable.class)).permute(new String[]{"throwable"}).append("runtime", (Object)method.getImplementationClass().getRuntime()).invokeStaticQuiet(MethodHandles.lookup(), Helpers.class, "rewriteStackTraceAndThrow");
                nativeTarget = MethodHandles.catchException(nativeTarget, Throwable.class, rewriteHandle.handle());
            }
        }
        return nativeTarget;
    }

    private static MethodHandle addOrRemoveBlock(JRubyCallSite site, MethodHandle nativeTarget) {
        if (site.type().parameterCount() > 0 && site.type().parameterArray()[site.type().parameterCount() - 1] != Block.class && nativeTarget.type().parameterCount() > 0 && nativeTarget.type().parameterType(nativeTarget.type().parameterCount() - 1) == Block.class) {
            nativeTarget = MethodHandles.insertArguments(nativeTarget, nativeTarget.type().parameterCount() - 1, Block.NULL_BLOCK);
        } else if (site.type().parameterCount() > 0 && site.type().parameterArray()[site.type().parameterCount() - 1] == Block.class && nativeTarget.type().parameterCount() > 0 && nativeTarget.type().parameterType(nativeTarget.type().parameterCount() - 1) != Block.class) {
            nativeTarget = MethodHandles.dropArguments(nativeTarget, nativeTarget.type().parameterCount(), new Class[]{Block.class});
        }
        return nativeTarget;
    }

    public static void checkArity(int required, int optional, boolean rest2, ThreadContext context, IRubyObject caller, IRubyObject self2, IRubyObject[] args2) {
        Arity.checkArgumentCount(context.runtime, args2, required, rest2 ? -1 : required + optional);
    }

    public static void checkArity(int required, int optional, boolean rest2, ThreadContext context, IRubyObject caller, IRubyObject self2, IRubyObject[] args2, Block block) {
        InvocationLinker.checkArity(required, optional, rest2, context, caller, self2, args2);
    }

    public static boolean testGeneration(int token, IRubyObject self2) {
        return token == ((RubyBasicObject)self2).getMetaClass().getGeneration();
    }

    public static boolean testMetaclass(RubyClass metaclass, IRubyObject self2) {
        return metaclass == ((RubyBasicObject)self2).getMetaClass();
    }

    public static boolean testRealClass(int id2, IRubyObject self2) {
        return id2 == ((RubyBasicObject)self2).getMetaClass().getRealClass().id;
    }

    public static boolean testClass(Object object, Class clazz) {
        return object.getClass() == clazz;
    }

    public static IRubyObject getLast(IRubyObject[] args2) {
        return args2[args2.length - 1];
    }

    public static void blockEscape(Block block) {
        block.escape();
    }

    private static MethodHandle postProcess(JRubyCallSite site, MethodHandle target) {
        if (site.isAttrAssign() && site.isExpression()) {
            MethodHandle newTarget = MethodHandles.identity(IRubyObject.class);
            if (site.type().parameterArray()[site.type().parameterCount() - 1] == IRubyObject[].class) {
                newTarget = MethodHandles.filterArguments(newTarget, 0, InvokeDynamicSupport.findStatic(InvocationLinker.class, "getLast", MethodType.methodType(IRubyObject.class, IRubyObject[].class)));
            }
            newTarget = MethodHandles.dropArguments(newTarget, 0, IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class);
            MethodType dropped = target.type().dropParameterTypes(0, 3);
            if (dropped.parameterCount() > 1) {
                Object[] drops = new Class[dropped.parameterCount() - 1];
                Arrays.fill(drops, IRubyObject.class);
                newTarget = MethodHandles.dropArguments(newTarget, 4, drops);
            }
            target = MethodHandles.foldArguments(newTarget, target);
        }
        return target;
    }

    public static IRubyObject fail(JRubyCallSite site, ThreadContext context, IRubyObject caller, IRubyObject self2) throws Throwable {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self2);
        String name2 = site.name();
        CacheEntry entry = site.entry;
        if (entry.typeOk(selfClass)) {
            return entry.method.call(context, self2, selfClass, name2);
        }
        entry = selfClass.searchWithCache(name2);
        if (InvokeDynamicSupport.methodMissing(entry, site.callType(), name2, caller)) {
            return InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self2, name2);
        }
        site.entry = entry;
        return entry.method.call(context, self2, selfClass, name2);
    }

    public static IRubyObject fail(JRubyCallSite site, ThreadContext context, IRubyObject caller, IRubyObject self2, IRubyObject arg0) throws Throwable {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self2);
        String name2 = site.name();
        CacheEntry entry = site.entry;
        if (entry.typeOk(selfClass)) {
            return entry.method.call(context, self2, (RubyModule)selfClass, name2, arg0);
        }
        entry = selfClass.searchWithCache(name2);
        if (InvokeDynamicSupport.methodMissing(entry, site.callType(), name2, caller)) {
            return InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self2, name2, arg0);
        }
        site.entry = entry;
        return entry.method.call(context, self2, (RubyModule)selfClass, name2, arg0);
    }

    public static IRubyObject fail(JRubyCallSite site, ThreadContext context, IRubyObject caller, IRubyObject self2, IRubyObject arg0, IRubyObject arg1) throws Throwable {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self2);
        String name2 = site.name();
        CacheEntry entry = site.entry;
        if (entry.typeOk(selfClass)) {
            return entry.method.call(context, self2, (RubyModule)selfClass, name2, arg0, arg1);
        }
        entry = selfClass.searchWithCache(name2);
        if (InvokeDynamicSupport.methodMissing(entry, site.callType(), name2, caller)) {
            return InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self2, name2, arg0, arg1);
        }
        site.entry = entry;
        return entry.method.call(context, self2, (RubyModule)selfClass, name2, arg0, arg1);
    }

    public static IRubyObject fail(JRubyCallSite site, ThreadContext context, IRubyObject caller, IRubyObject self2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) throws Throwable {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self2);
        String name2 = site.name();
        CacheEntry entry = site.entry;
        if (entry.typeOk(selfClass)) {
            return entry.method.call(context, self2, (RubyModule)selfClass, name2, arg0, arg1, arg2);
        }
        entry = selfClass.searchWithCache(name2);
        if (InvokeDynamicSupport.methodMissing(entry, site.callType(), name2, caller)) {
            return InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self2, name2, arg0, arg1, arg2);
        }
        site.entry = entry;
        return entry.method.call(context, self2, (RubyModule)selfClass, name2, arg0, arg1, arg2);
    }

    public static IRubyObject fail(JRubyCallSite site, ThreadContext context, IRubyObject caller, IRubyObject self2, IRubyObject[] args2) throws Throwable {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self2);
        String name2 = site.name();
        CacheEntry entry = site.entry;
        if (entry.typeOk(selfClass)) {
            return entry.method.call(context, self2, (RubyModule)selfClass, name2, args2);
        }
        entry = selfClass.searchWithCache(name2);
        if (InvokeDynamicSupport.methodMissing(entry, site.callType(), name2, caller)) {
            return InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self2, name2, args2);
        }
        site.entry = entry;
        return entry.method.call(context, self2, (RubyModule)selfClass, name2, args2);
    }

    public static IRubyObject fail(JRubyCallSite site, ThreadContext context, IRubyObject caller, IRubyObject self2, Block block) throws Throwable {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self2);
        String name2 = site.name();
        CacheEntry entry = site.entry;
        if (entry.typeOk(selfClass)) {
            return entry.method.call(context, self2, (RubyModule)selfClass, name2, block);
        }
        entry = selfClass.searchWithCache(name2);
        if (InvokeDynamicSupport.methodMissing(entry, site.callType(), name2, caller)) {
            return InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self2, name2, block);
        }
        site.entry = entry;
        return entry.method.call(context, self2, (RubyModule)selfClass, name2, block);
    }

    public static IRubyObject fail(JRubyCallSite site, ThreadContext context, IRubyObject caller, IRubyObject self2, IRubyObject arg0, Block block) throws Throwable {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self2);
        String name2 = site.name();
        CacheEntry entry = site.entry;
        if (entry.typeOk(selfClass)) {
            return entry.method.call(context, self2, (RubyModule)selfClass, name2, arg0, block);
        }
        entry = selfClass.searchWithCache(name2);
        if (InvokeDynamicSupport.methodMissing(entry, site.callType(), name2, caller)) {
            return InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self2, name2, arg0, block);
        }
        site.entry = entry;
        return entry.method.call(context, self2, (RubyModule)selfClass, name2, arg0, block);
    }

    public static IRubyObject fail(JRubyCallSite site, ThreadContext context, IRubyObject caller, IRubyObject self2, IRubyObject arg0, IRubyObject arg1, Block block) throws Throwable {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self2);
        String name2 = site.name();
        CacheEntry entry = site.entry;
        if (entry.typeOk(selfClass)) {
            return entry.method.call(context, self2, (RubyModule)selfClass, name2, arg0, arg1, block);
        }
        entry = selfClass.searchWithCache(name2);
        if (InvokeDynamicSupport.methodMissing(entry, site.callType(), name2, caller)) {
            return InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self2, name2, arg0, arg1, block);
        }
        site.entry = entry;
        return entry.method.call(context, self2, (RubyModule)selfClass, name2, arg0, arg1, block);
    }

    public static IRubyObject fail(JRubyCallSite site, ThreadContext context, IRubyObject caller, IRubyObject self2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) throws Throwable {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self2);
        String name2 = site.name();
        CacheEntry entry = site.entry;
        if (entry.typeOk(selfClass)) {
            return entry.method.call(context, self2, selfClass, name2, arg0, arg1, arg2, block);
        }
        entry = selfClass.searchWithCache(name2);
        if (InvokeDynamicSupport.methodMissing(entry, site.callType(), name2, caller)) {
            return InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self2, name2, arg0, arg1, arg2, block);
        }
        site.entry = entry;
        return entry.method.call(context, self2, selfClass, name2, arg0, arg1, arg2, block);
    }

    public static IRubyObject fail(JRubyCallSite site, ThreadContext context, IRubyObject caller, IRubyObject self2, IRubyObject[] args2, Block block) throws Throwable {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self2);
        String name2 = site.name();
        CacheEntry entry = site.entry;
        if (entry.typeOk(selfClass)) {
            return entry.method.call(context, self2, (RubyModule)selfClass, name2, args2, block);
        }
        entry = selfClass.searchWithCache(name2);
        if (InvokeDynamicSupport.methodMissing(entry, site.callType(), name2, caller)) {
            return InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self2, name2, args2, block);
        }
        site.entry = entry;
        return entry.method.call(context, self2, (RubyModule)selfClass, name2, args2, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject failIter(JRubyCallSite site, ThreadContext context, IRubyObject caller, IRubyObject self2, Block block) throws Throwable {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self2);
        String name2 = site.name();
        CacheEntry entry = site.entry;
        try {
            if (entry.typeOk(selfClass)) {
                IRubyObject iRubyObject = entry.method.call(context, self2, (RubyModule)selfClass, name2, block);
                return iRubyObject;
            }
            entry = selfClass.searchWithCache(name2);
            if (InvokeDynamicSupport.methodMissing(entry, site.callType(), name2, caller)) {
                IRubyObject iRubyObject = InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self2, name2, block);
                return iRubyObject;
            }
            site.entry = entry;
            IRubyObject iRubyObject = entry.method.call(context, self2, (RubyModule)selfClass, name2, block);
            return iRubyObject;
        }
        finally {
            block.escape();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject failIter(JRubyCallSite site, ThreadContext context, IRubyObject caller, IRubyObject self2, IRubyObject arg0, Block block) throws Throwable {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self2);
        String name2 = site.name();
        CacheEntry entry = site.entry;
        try {
            if (entry.typeOk(selfClass)) {
                IRubyObject iRubyObject = entry.method.call(context, self2, (RubyModule)selfClass, name2, arg0, block);
                return iRubyObject;
            }
            entry = selfClass.searchWithCache(name2);
            if (InvokeDynamicSupport.methodMissing(entry, site.callType(), name2, caller)) {
                IRubyObject iRubyObject = InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self2, name2, arg0, block);
                return iRubyObject;
            }
            site.entry = entry;
            IRubyObject iRubyObject = entry.method.call(context, self2, (RubyModule)selfClass, name2, arg0, block);
            return iRubyObject;
        }
        finally {
            block.escape();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject failIter(JRubyCallSite site, ThreadContext context, IRubyObject caller, IRubyObject self2, IRubyObject arg0, IRubyObject arg1, Block block) throws Throwable {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self2);
        String name2 = site.name();
        CacheEntry entry = site.entry;
        try {
            if (entry.typeOk(selfClass)) {
                IRubyObject iRubyObject = entry.method.call(context, self2, (RubyModule)selfClass, name2, arg0, arg1, block);
                return iRubyObject;
            }
            entry = selfClass.searchWithCache(name2);
            if (InvokeDynamicSupport.methodMissing(entry, site.callType(), name2, caller)) {
                IRubyObject iRubyObject = InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self2, name2, arg0, arg1, block);
                return iRubyObject;
            }
            site.entry = entry;
            IRubyObject iRubyObject = entry.method.call(context, self2, (RubyModule)selfClass, name2, arg0, arg1, block);
            return iRubyObject;
        }
        finally {
            block.escape();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject failIter(JRubyCallSite site, ThreadContext context, IRubyObject caller, IRubyObject self2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) throws Throwable {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self2);
        String name2 = site.name();
        CacheEntry entry = site.entry;
        try {
            if (entry.typeOk(selfClass)) {
                IRubyObject iRubyObject = entry.method.call(context, self2, selfClass, name2, arg0, arg1, arg2, block);
                return iRubyObject;
            }
            entry = selfClass.searchWithCache(name2);
            if (InvokeDynamicSupport.methodMissing(entry, site.callType(), name2, caller)) {
                IRubyObject iRubyObject = InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self2, name2, arg0, arg1, arg2, block);
                return iRubyObject;
            }
            site.entry = entry;
            IRubyObject iRubyObject = entry.method.call(context, self2, selfClass, name2, arg0, arg1, arg2, block);
            return iRubyObject;
        }
        finally {
            block.escape();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject failIter(JRubyCallSite site, ThreadContext context, IRubyObject caller, IRubyObject self2, IRubyObject[] args2, Block block) throws Throwable {
        RubyClass selfClass = InvokeDynamicSupport.pollAndGetClass(context, self2);
        String name2 = site.name();
        CacheEntry entry = site.entry;
        try {
            if (entry.typeOk(selfClass)) {
                IRubyObject iRubyObject = entry.method.call(context, self2, (RubyModule)selfClass, name2, args2, block);
                return iRubyObject;
            }
            entry = selfClass.searchWithCache(name2);
            if (InvokeDynamicSupport.methodMissing(entry, site.callType(), name2, caller)) {
                IRubyObject iRubyObject = InvokeDynamicSupport.callMethodMissing(entry, site.callType(), context, self2, name2, args2, block);
                return iRubyObject;
            }
            site.entry = entry;
            IRubyObject iRubyObject = entry.method.call(context, self2, (RubyModule)selfClass, name2, args2, block);
            return iRubyObject;
        }
        finally {
            block.escape();
        }
    }

    private static MethodHandle getDynamicMethodTarget(MethodType callType, int arity2, DynamicMethod method) {
        MethodHandle target = null;
        TypeDescriptor.OfField lastParam = callType.parameterType(callType.parameterCount() - 1);
        boolean block = lastParam == Block.class;
        switch (arity2) {
            case 0: {
                target = block ? TARGET_0_B : TARGET_0;
                break;
            }
            case 1: {
                target = block ? TARGET_1_B : TARGET_1;
                break;
            }
            case 2: {
                target = block ? TARGET_2_B : TARGET_2;
                break;
            }
            case 3: {
                target = block ? TARGET_3_B : TARGET_3;
                break;
            }
            default: {
                target = block ? TARGET_N_B : TARGET_N;
            }
        }
        return target;
    }

    private static MethodHandle createJavaHandle(CallSite site, DynamicMethod method) {
        MethodHandle nativeTarget = (MethodHandle)method.getHandle();
        if (nativeTarget != null) {
            return nativeTarget;
        }
        MethodHandle returnFilter = null;
        Ruby runtime = method.getImplementationClass().getRuntime();
        DynamicMethod.NativeCall nativeCall = method.getNativeCall();
        boolean isStatic = nativeCall.isStatic();
        Class[] signature = nativeCall.getNativeSignature();
        if (signature.length > 0 && signature[signature.length - 1].isArray()) {
            return null;
        }
        if (method instanceof SingletonMethodInvoker) {
            return null;
        }
        MethodType apparentType = MethodType.methodType(nativeCall.getNativeReturn(), nativeCall.getNativeSignature());
        nativeTarget = isStatic ? InvokeDynamicSupport.findStatic(nativeCall.getNativeTarget(), nativeCall.getNativeName(), apparentType) : InvokeDynamicSupport.findVirtual(nativeCall.getNativeTarget(), nativeCall.getNativeName(), apparentType);
        MethodType nativeType = nativeTarget.type();
        Class<?>[] nativeParams = nativeType.parameterArray();
        TypeDescriptor.OfField nativeReturn = nativeType.returnType();
        MethodHandle[] argConverters = new MethodHandle[nativeType.parameterCount()];
        for (int i2 = 0; i2 < argConverters.length; ++i2) {
            MethodHandle converter = !isStatic && i2 == 0 ? Binder.from(nativeParams[0], IRubyObject.class, (Class[])new Class[0]).cast(Object.class, new Class[]{IRubyObject.class}).invokeStaticQuiet(MethodHandles.lookup(), JavaUtil.class, "objectFromJavaProxy") : Binder.from(nativeParams[i2], IRubyObject.class, (Class[])new Class[0]).insert(1, new Object[]{nativeParams[i2]}).cast(Object.class, new Class[]{IRubyObject.class, Class.class}).invokeVirtualQuiet(MethodHandles.lookup(), "toJava");
            argConverters[i2] = converter;
        }
        nativeTarget = MethodHandles.filterArguments(nativeTarget, 0, argConverters);
        Class[] convertedParams = CodegenUtils.params(IRubyObject.class, nativeTarget.type().parameterCount());
        if (nativeReturn == Byte.TYPE || nativeReturn == Short.TYPE || nativeReturn == Character.TYPE || nativeReturn == Integer.TYPE || nativeReturn == Long.TYPE) {
            nativeTarget = MethodHandles.explicitCastArguments(nativeTarget, MethodType.methodType(Long.TYPE, convertedParams));
            returnFilter = MethodHandles.insertArguments(InvokeDynamicSupport.findStatic(RubyFixnum.class, "newFixnum", MethodType.methodType(RubyFixnum.class, Ruby.class, Long.TYPE)), 0, runtime);
        } else if (nativeReturn == Byte.class || nativeReturn == Short.class || nativeReturn == Character.class || nativeReturn == Integer.class || nativeReturn == Long.class) {
            returnFilter = MethodHandles.insertArguments(InvokeDynamicSupport.findStatic(InvocationLinker.class, "fixnumOrNil", MethodType.methodType(IRubyObject.class, Ruby.class, new Class[]{nativeReturn})), 0, runtime);
        } else if (nativeReturn == Float.TYPE || nativeReturn == Double.TYPE) {
            nativeTarget = MethodHandles.explicitCastArguments(nativeTarget, MethodType.methodType(Double.TYPE, convertedParams));
            returnFilter = MethodHandles.insertArguments(InvokeDynamicSupport.findStatic(RubyFloat.class, "newFloat", MethodType.methodType(RubyFloat.class, Ruby.class, Double.TYPE)), 0, runtime);
        } else if (nativeReturn == Float.class || nativeReturn == Double.class) {
            returnFilter = MethodHandles.insertArguments(InvokeDynamicSupport.findStatic(InvocationLinker.class, "floatOrNil", MethodType.methodType(IRubyObject.class, Ruby.class, new Class[]{nativeReturn})), 0, runtime);
        } else if (nativeReturn == Boolean.TYPE) {
            nativeTarget = MethodHandles.explicitCastArguments(nativeTarget, MethodType.methodType(Boolean.TYPE, convertedParams));
            returnFilter = MethodHandles.insertArguments(InvokeDynamicSupport.findStatic(RubyBoolean.class, "newBoolean", MethodType.methodType(RubyBoolean.class, Ruby.class, Boolean.TYPE)), 0, runtime);
        } else if (nativeReturn == Boolean.class) {
            returnFilter = MethodHandles.insertArguments(InvokeDynamicSupport.findStatic(InvocationLinker.class, "booleanOrNil", MethodType.methodType(IRubyObject.class, Ruby.class, Boolean.class)), 0, runtime);
        } else if (CharSequence.class.isAssignableFrom((Class<?>)nativeReturn)) {
            nativeTarget = MethodHandles.explicitCastArguments(nativeTarget, MethodType.methodType(CharSequence.class, convertedParams));
            returnFilter = MethodHandles.insertArguments(InvokeDynamicSupport.findStatic(InvocationLinker.class, "stringOrNil", MethodType.methodType(IRubyObject.class, Ruby.class, CharSequence.class)), 0, runtime);
        } else if (nativeReturn == Void.TYPE) {
            returnFilter = MethodHandles.constant(IRubyObject.class, runtime.getNil());
        } else if (nativeReturn != ByteList.class && nativeReturn != BigInteger.class) {
            nativeTarget = MethodHandles.explicitCastArguments(nativeTarget, MethodType.methodType(Object.class, convertedParams));
            returnFilter = MethodHandles.insertArguments(InvokeDynamicSupport.findStatic(JavaUtil.class, "convertJavaToUsableRubyObject", MethodType.methodType(IRubyObject.class, Ruby.class, Object.class)), 0, runtime);
        }
        if (returnFilter != null) {
            Class[] newNativeParams = nativeTarget.type().parameterArray();
            TypeDescriptor.OfField newNativeReturn = nativeTarget.type().returnType();
            Binder exBinder = Binder.from((Class)newNativeReturn, Throwable.class, (Class[])newNativeParams).drop(1, newNativeParams.length).insert(0, new Object[]{runtime});
            if (nativeReturn != Void.TYPE) {
                exBinder = exBinder.filterReturn(Binder.from((Class)newNativeReturn).constant(InvocationLinker.nullValue((Class)newNativeReturn)));
            }
            nativeTarget = Binder.from((MethodType)site.type()).drop(0, isStatic ? 3 : 2).filterReturn(returnFilter).invoke(nativeTarget);
            method.setHandle(nativeTarget);
            return nativeTarget;
        }
        return null;
    }

    public static boolean subclassProxyTest(Object target) {
        return target instanceof InternalJavaProxy;
    }

    private static Object nullValue(Class type2) {
        if (type2 == Boolean.TYPE || type2 == Boolean.class) {
            return false;
        }
        if (type2 == Byte.TYPE || type2 == Byte.class) {
            return (byte)0;
        }
        if (type2 == Short.TYPE || type2 == Short.class) {
            return (short)0;
        }
        if (type2 == Integer.TYPE || type2 == Integer.class) {
            return 0;
        }
        if (type2 == Long.TYPE || type2 == Long.class) {
            return 0L;
        }
        if (type2 == Float.TYPE || type2 == Float.class) {
            return Float.valueOf(0.0f);
        }
        if (type2 == Double.TYPE || type2 == Double.class) {
            return 0.0;
        }
        return null;
    }

    public static IRubyObject fixnumOrNil(Ruby runtime, Byte b2) {
        return b2 == null ? runtime.getNil() : RubyFixnum.newFixnum(runtime, b2.byteValue());
    }

    public static IRubyObject fixnumOrNil(Ruby runtime, Short s2) {
        return s2 == null ? runtime.getNil() : RubyFixnum.newFixnum(runtime, s2.shortValue());
    }

    public static IRubyObject fixnumOrNil(Ruby runtime, Character c) {
        return c == null ? runtime.getNil() : RubyFixnum.newFixnum(runtime, c.charValue());
    }

    public static IRubyObject fixnumOrNil(Ruby runtime, Integer i2) {
        return i2 == null ? runtime.getNil() : RubyFixnum.newFixnum(runtime, i2.intValue());
    }

    public static IRubyObject fixnumOrNil(Ruby runtime, Long l) {
        return l == null ? runtime.getNil() : RubyFixnum.newFixnum(runtime, l);
    }

    public static IRubyObject floatOrNil(Ruby runtime, Float f) {
        return f == null ? runtime.getNil() : RubyFloat.newFloat(runtime, f.floatValue());
    }

    public static IRubyObject floatOrNil(Ruby runtime, Double d) {
        return d == null ? runtime.getNil() : RubyFloat.newFloat(runtime, d);
    }

    public static IRubyObject booleanOrNil(Ruby runtime, Boolean b2) {
        return b2 == null ? runtime.getNil() : RubyBoolean.newBoolean(runtime, b2);
    }

    public static IRubyObject stringOrNil(Ruby runtime, CharSequence cs) {
        return cs == null ? runtime.getNil() : RubyString.newUnicodeString(runtime, cs);
    }

    private static MethodHandle createNativeHandle(Ruby runtime, JRubyCallSite site, DynamicMethod method, String name2) {
        MethodHandle nativeTarget = (MethodHandle)method.getHandle();
        if (nativeTarget != null) {
            return nativeTarget;
        }
        DynamicMethod.NativeCall nativeCall = method.getNativeCall();
        Class[] nativeSig = nativeCall.getNativeSignature();
        boolean isStatic = nativeCall.isStatic();
        try {
            nativeTarget = isStatic ? site.lookup().findStatic(nativeCall.getNativeTarget(), nativeCall.getNativeName(), MethodType.methodType(nativeCall.getNativeReturn(), nativeCall.getNativeSignature())) : site.lookup().findVirtual(nativeCall.getNativeTarget(), nativeCall.getNativeName(), MethodType.methodType(nativeCall.getNativeReturn(), nativeCall.getNativeSignature()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (nativeCall.getNativeReturn() == Void.TYPE) {
            nativeTarget = MethodHandles.filterReturnValue(nativeTarget, MethodHandles.constant(IRubyObject.class, runtime.getNil()));
        }
        Signature fullSig = site.fullSignature();
        Signature target = nativeSig.length > 0 && nativeSig[0] == ThreadContext.class ? (nativeSig[nativeSig.length - 1] == Block.class ? (isStatic ? fullSig.permute(new String[]{"context", "self", "arg*", "block"}) : fullSig.permute(new String[]{"self", "context", "arg*", "block"})) : (isStatic ? fullSig.permute(new String[]{"context", "self", "arg*"}) : fullSig.permute(new String[]{"self", "context", "arg*"}))) : (nativeSig.length > 0 && nativeSig[nativeSig.length - 1] == Block.class ? fullSig.permute(new String[]{"self", "arg*", "block"}) : fullSig.permute(new String[]{"self", "arg*"}));
        nativeTarget = MethodHandles.explicitCastArguments(nativeTarget, target.type());
        nativeTarget = MethodHandles.permuteArguments(nativeTarget, fullSig.type(), fullSig.to(target));
        nativeTarget = InvocationLinker.wrapWithFraming(fullSig, method.getCallConfig(), method.getImplementationClass(), name2, nativeTarget, null);
        method.setHandle(nativeTarget);
        return nativeTarget;
    }

    private static MethodHandle createFFIHandle(JRubyCallSite site, DynamicMethod method) {
        if (site.type().parameterType(site.type().parameterCount() - 1) == Block.class) {
            return null;
        }
        MethodHandle nativeTarget = (MethodHandle)method.getHandle();
        if (nativeTarget != null) {
            return nativeTarget;
        }
        nativeTarget = InvokeDynamic.getMethodHandle(site, method);
        if (nativeTarget != null) {
            method.setHandle(nativeTarget);
            return nativeTarget;
        }
        return null;
    }

    private static MethodHandle createAttrReaderHandle(JRubyCallSite site, RubyClass cls, VariableAccessor accessor) {
        MethodHandle nativeTarget;
        MethodHandle filter = Binder.from(IRubyObject.class, IRubyObject.class, (Class[])new Class[0]).insert(1, new Object[]{cls.getRuntime().getNil()}).cast(IRubyObject.class, new Class[]{IRubyObject.class, IRubyObject.class}).invokeStaticQuiet(MethodHandles.lookup(), InvocationLinker.class, "valueOrNil");
        if (accessor instanceof FieldVariableAccessor) {
            Binder b2 = Binder.from((MethodType)site.type()).permute(new int[]{2}).filterReturn(filter);
            int offset2 = ((FieldVariableAccessor)accessor).getOffset();
            Class objCls = InvokeDynamicSupport.REIFIED_OBJECT_CLASSES[offset2];
            nativeTarget = b2.cast(Object.class, new Class[]{objCls}).getFieldQuiet(MethodHandles.lookup(), "var" + offset2);
        } else {
            nativeTarget = Binder.from((MethodType)site.type()).permute(new int[]{2}).filterReturn(filter).insert(1, accessor.getIndex()).cast(Object.class, new Class[]{RubyBasicObject.class, Integer.TYPE}).invokeStaticQuiet(MethodHandles.lookup(), VariableAccessor.class, "getVariable");
        }
        return nativeTarget;
    }

    public static IRubyObject valueOrNil(IRubyObject value2, IRubyObject nil) {
        return value2 == null ? nil : value2;
    }

    private static MethodHandle createAttrWriterHandle(JRubyCallSite site, RubyClass cls, VariableAccessor accessor) {
        MethodHandle nativeTarget;
        MethodHandle filter = Binder.from(IRubyObject.class, Object.class, (Class[])new Class[0]).drop(0).constant((Object)cls.getRuntime().getNil());
        if (accessor instanceof FieldVariableAccessor) {
            Binder b2 = Binder.from((MethodType)site.type()).permute(new int[]{2, 3}).filterReturn(filter);
            int offset2 = ((FieldVariableAccessor)accessor).getOffset();
            Class objCls = InvokeDynamicSupport.REIFIED_OBJECT_CLASSES[offset2];
            nativeTarget = b2.cast(Void.TYPE, new Class[]{objCls, Object.class}).invokeStaticQuiet(MethodHandles.lookup(), objCls, "setVariableChecked");
        } else {
            nativeTarget = Binder.from((MethodType)site.type()).permute(new int[]{2, 3}).filterReturn(filter).insert(1, new Object[]{cls.getRealClass(), accessor.getIndex()}).cast(Void.TYPE, new Class[]{RubyBasicObject.class, RubyClass.class, Integer.TYPE, Object.class}).invokeStaticQuiet(MethodHandles.lookup(), accessor.getClass(), "setVariableChecked");
        }
        return nativeTarget;
    }

    public static MethodHandle wrapWithFraming(Signature signature, CallConfiguration callConfig, RubyModule implClass, String name2, MethodHandle nativeTarget, StaticScope scope) {
        MethodHandle framePre = InvocationLinker.getFramePre(signature, callConfig, implClass, name2, scope);
        if (framePre != null) {
            boolean framed;
            MethodHandle framePost = InvocationLinker.getFramePost(signature, callConfig);
            boolean heapScoped = callConfig.scoping() != Scoping.None;
            boolean bl = framed = callConfig.framing() != Framing.None;
            if (framed || heapScoped) {
                nativeTarget = MethodHandles.catchException(nativeTarget, JumpException.ReturnJump.class, Binder.from((MethodType)nativeTarget.type().insertParameterTypes(0, JumpException.ReturnJump.class)).permute(new int[]{0, 1}).invokeStaticQuiet(MethodHandles.lookup(), InvocationLinker.class, "handleReturn"));
            }
            if (framed) {
                nativeTarget = MethodHandles.catchException(nativeTarget, JumpException.RedoJump.class, Binder.from((MethodType)nativeTarget.type().insertParameterTypes(0, JumpException.RedoJump.class)).permute(new int[]{0, 1}).invokeStaticQuiet(MethodHandles.lookup(), InvocationLinker.class, "handleRedo"));
            }
            nativeTarget = Binder.from((MethodType)nativeTarget.type()).tryFinally(framePost).invoke(nativeTarget);
            nativeTarget = MethodHandles.foldArguments(nativeTarget, framePre);
            nativeTarget = Binder.from((MethodType)nativeTarget.type()).fold(Binder.from((MethodType)nativeTarget.type().changeReturnType(Void.TYPE)).permute(new int[]{0}).invokeStaticQuiet(MethodHandles.lookup(), ThreadContext.class, "callThreadPoll")).invoke(nativeTarget);
        }
        return nativeTarget;
    }

    public static IRubyObject handleRedo(JumpException.RedoJump rj, ThreadContext context) {
        throw context.runtime.newLocalJumpError(RubyLocalJumpError.Reason.REDO, context.runtime.getNil(), "unexpected redo");
    }

    public static MethodHandle getFramePre(Signature signature, CallConfiguration callConfig, RubyModule implClass, String name2, StaticScope scope) {
        Signature inbound = signature.asFold(Void.TYPE);
        SmartBinder binder = SmartBinder.from((Signature)inbound);
        switch (callConfig) {
            case FrameFullScopeFull: {
                return binder.permute(new String[]{"context", "self", "block"}).insert(1, Helpers.arrayOf("selfClass", "name"), Helpers.arrayOf(RubyModule.class, String.class), new Object[]{implClass, name2}).insert(5, Helpers.arrayOf("scope"), Helpers.arrayOf(StaticScope.class), new Object[]{scope}).invokeVirtualQuiet(MethodHandles.lookup(), "preMethodFrameAndScope").handle();
            }
            case FrameFullScopeDummy: {
                return binder.permute(new String[]{"context", "self", "block"}).insert(1, Helpers.arrayOf("selfClass", "name"), Helpers.arrayOf(RubyModule.class, String.class), new Object[]{implClass, name2}).insert(5, Helpers.arrayOf("scope"), Helpers.arrayOf(StaticScope.class), new Object[]{scope}).invokeVirtualQuiet(MethodHandles.lookup(), "preMethodFrameAndDummyScope").handle();
            }
            case FrameFullScopeNone: {
                return binder.permute(new String[]{"context", "self", "block"}).insert(1, Helpers.arrayOf("selfClass", "name"), Helpers.arrayOf(RubyModule.class, String.class), new Object[]{implClass, name2}).invokeVirtualQuiet(MethodHandles.lookup(), "preMethodFrameOnly").handle();
            }
            case FrameNoneScopeFull: {
                return binder.permute(new String[]{"context"}).insert(1, Helpers.arrayOf("selfClass", "scope"), Helpers.arrayOf(RubyModule.class, StaticScope.class), new Object[]{implClass, scope}).invokeVirtualQuiet(MethodHandles.lookup(), "preMethodScopeOnly").handle();
            }
            case FrameNoneScopeDummy: {
                return binder.permute(new String[]{"context"}).insert(1, Helpers.arrayOf("selfClass", "scope"), Helpers.arrayOf(RubyModule.class, StaticScope.class), new Object[]{implClass, scope}).invokeVirtualQuiet(MethodHandles.lookup(), "preMethodNoFrameAndDummyScope").handle();
            }
        }
        return null;
    }

    public static MethodHandle getFramePost(Signature signature, CallConfiguration callConfig) {
        Signature inbound = signature.asFold(Void.TYPE);
        SmartBinder binder = SmartBinder.from((Signature)inbound).permute(new String[]{"context"});
        switch (callConfig) {
            case FrameFullScopeFull: {
                return binder.invokeVirtualQuiet(MethodHandles.lookup(), "postMethodFrameAndScope").handle();
            }
            case FrameFullScopeDummy: {
                return binder.invokeVirtualQuiet(MethodHandles.lookup(), "postMethodFrameAndScope").handle();
            }
            case FrameFullScopeNone: {
                return binder.invokeVirtualQuiet(MethodHandles.lookup(), "postMethodFrameOnly").handle();
            }
            case FrameNoneScopeFull: {
                return binder.invokeVirtualQuiet(MethodHandles.lookup(), "postMethodScopeOnly").handle();
            }
            case FrameNoneScopeDummy: {
                return binder.invokeVirtualQuiet(MethodHandles.lookup(), "postMethodScopeOnly").handle();
            }
        }
        return null;
    }

    private static int getArgCount(Class[] args2, boolean isStatic) {
        int length2 = args2.length;
        boolean hasContext = false;
        if (isStatic) {
            if (args2.length > 1 && args2[0] == ThreadContext.class) {
                --length2;
                hasContext = true;
            }
            assert (args2.length >= 1);
            --length2;
            if (args2.length > 1 && args2[args2.length - 1] == Block.class) {
                --length2;
            }
            if (length2 == 1) {
                if (hasContext && args2[2] == IRubyObject[].class) {
                    length2 = 4;
                } else if (args2[1] == IRubyObject[].class) {
                    length2 = 4;
                }
            }
        } else {
            if (args2.length > 0 && args2[0] == ThreadContext.class) {
                --length2;
                hasContext = true;
            }
            if (args2.length > 0 && args2[args2.length - 1] == Block.class) {
                --length2;
            }
            if (length2 == 1) {
                if (hasContext && args2[1] == IRubyObject[].class) {
                    length2 = 4;
                } else if (args2[0] == IRubyObject[].class) {
                    length2 = 4;
                }
            }
        }
        return length2;
    }

    private static int getRubyArgCount(Class[] args2) {
        int length2 = args2.length;
        boolean hasContext = false;
        --length2;
        if (args2.length > 2 && args2[1] == ThreadContext.class) {
            --length2;
            hasContext = true;
        }
        assert (args2.length >= 2);
        --length2;
        if (args2.length > 2 && args2[args2.length - 1] == Block.class) {
            --length2;
        }
        if (length2 == 1) {
            if (hasContext && args2[3] == IRubyObject[].class) {
                length2 = 4;
            } else if (args2[2] == IRubyObject[].class) {
                length2 = 4;
            }
        }
        return length2;
    }

    private static int getSiteCount(Class[] args2) {
        if (args2[args2.length - 1] == Block.class) {
            if (args2[args2.length - 2] == IRubyObject[].class) {
                return 4;
            }
            return args2.length - 4;
        }
        if (args2[args2.length - 1] == IRubyObject[].class) {
            return 4;
        }
        return args2.length - 3;
    }

    private static String logMethod(DynamicMethod method) {
        return "[#" + method.getSerialNumber() + " " + method.getImplementationClass() + "]";
    }

    private static MethodHandle dynamicCallTarget(Signature from, Signature to) {
        return SmartBinder.from((Signature)from).fold("selfClass", from.asFold(RubyClass.class).permuteWith(PGC, new String[]{"context", "self"})).permute(to).cast(to).invokeVirtualQuiet(MethodHandles.lookup(), "call").handle();
    }

    static {
        TEST = TEST_METACLASS = Binder.from(Boolean.TYPE, RubyClass.class, (Class[])new Class[]{IRubyObject.class}).invokeStaticQuiet(MethodHandles.lookup(), InvocationLinker.class, "testMetaclass");
        TEST_CLASS = Binder.from(Boolean.TYPE, Object.class, (Class[])new Class[]{Class.class}).invokeStaticQuiet(MethodHandles.lookup(), InvocationLinker.class, "testClass");
        DYNAMIC_CALL_SIG = Signature.returning(IRubyObject.class).appendArg("method", DynamicMethod.class).appendArg("context", ThreadContext.class).appendArg("caller", IRubyObject.class).appendArg("self", IRubyObject.class).appendArg("name", String.class);
        DYNAMIC_CALL_SIG_1ARG = DYNAMIC_CALL_SIG.appendArg("arg0", IRubyObject.class);
        DYNAMIC_CALL_SIG_2ARG = DYNAMIC_CALL_SIG_1ARG.appendArg("arg1", IRubyObject.class);
        DYNAMIC_CALL_SIG_3ARG = DYNAMIC_CALL_SIG_2ARG.appendArg("arg2", IRubyObject.class);
        DYNAMIC_CALL_SIG_NARG = DYNAMIC_CALL_SIG.appendArg("args", IRubyObject[].class);
        DYNAMIC_CALL_SIG_BLOCK = DYNAMIC_CALL_SIG.appendArg("block", Block.class);
        DYNAMIC_CALL_SIG_1ARG_BLOCK = DYNAMIC_CALL_SIG_1ARG.appendArg("block", Block.class);
        DYNAMIC_CALL_SIG_2ARG_BLOCK = DYNAMIC_CALL_SIG_2ARG.appendArg("block", Block.class);
        DYNAMIC_CALL_SIG_3ARG_BLOCK = DYNAMIC_CALL_SIG_3ARG.appendArg("block", Block.class);
        DYNAMIC_CALL_SIG_NARG_BLOCK = DYNAMIC_CALL_SIG_NARG.appendArg("block", Block.class);
        DYNAMIC_METHOD_SIG = Signature.returning(IRubyObject.class).appendArg("method", DynamicMethod.class).appendArg("context", ThreadContext.class).appendArg("self", IRubyObject.class).appendArg("selfClass", RubyModule.class).appendArg("name", String.class);
        DYNAMIC_METHOD_SIG_1ARG = DYNAMIC_METHOD_SIG.appendArg("arg0", IRubyObject.class);
        DYNAMIC_METHOD_SIG_2ARG = DYNAMIC_METHOD_SIG_1ARG.appendArg("arg1", IRubyObject.class);
        DYNAMIC_METHOD_SIG_3ARG = DYNAMIC_METHOD_SIG_2ARG.appendArg("arg2", IRubyObject.class);
        DYNAMIC_METHOD_SIG_NARG = DYNAMIC_METHOD_SIG.appendArg("args", IRubyObject[].class);
        DYNAMIC_METHOD_SIG_BLOCK = DYNAMIC_METHOD_SIG.appendArg("block", Block.class);
        DYNAMIC_METHOD_SIG_1ARG_BLOCK = DYNAMIC_METHOD_SIG_1ARG.appendArg("block", Block.class);
        DYNAMIC_METHOD_SIG_2ARG_BLOCK = DYNAMIC_METHOD_SIG_2ARG.appendArg("block", Block.class);
        DYNAMIC_METHOD_SIG_3ARG_BLOCK = DYNAMIC_METHOD_SIG_3ARG.appendArg("block", Block.class);
        DYNAMIC_METHOD_SIG_NARG_BLOCK = DYNAMIC_METHOD_SIG_NARG.appendArg("block", Block.class);
        TARGET_0 = InvocationLinker.dynamicCallTarget(DYNAMIC_CALL_SIG, DYNAMIC_METHOD_SIG);
        TARGET_1 = InvocationLinker.dynamicCallTarget(DYNAMIC_CALL_SIG_1ARG, DYNAMIC_METHOD_SIG_1ARG);
        TARGET_2 = InvocationLinker.dynamicCallTarget(DYNAMIC_CALL_SIG_2ARG, DYNAMIC_METHOD_SIG_2ARG);
        TARGET_3 = InvocationLinker.dynamicCallTarget(DYNAMIC_CALL_SIG_3ARG, DYNAMIC_METHOD_SIG_3ARG);
        TARGET_N = InvocationLinker.dynamicCallTarget(DYNAMIC_CALL_SIG_NARG, DYNAMIC_METHOD_SIG_NARG);
        TARGET_0_B = InvocationLinker.dynamicCallTarget(DYNAMIC_CALL_SIG_BLOCK, DYNAMIC_METHOD_SIG_BLOCK);
        TARGET_1_B = InvocationLinker.dynamicCallTarget(DYNAMIC_CALL_SIG_1ARG_BLOCK, DYNAMIC_METHOD_SIG_1ARG_BLOCK);
        TARGET_2_B = InvocationLinker.dynamicCallTarget(DYNAMIC_CALL_SIG_2ARG_BLOCK, DYNAMIC_METHOD_SIG_2ARG_BLOCK);
        TARGET_3_B = InvocationLinker.dynamicCallTarget(DYNAMIC_CALL_SIG_3ARG_BLOCK, DYNAMIC_METHOD_SIG_3ARG_BLOCK);
        TARGET_N_B = InvocationLinker.dynamicCallTarget(DYNAMIC_CALL_SIG_NARG_BLOCK, DYNAMIC_METHOD_SIG_NARG_BLOCK);
        FALLBACK_SIG = Signature.returning(IRubyObject.class).appendArg("site", JRubyCallSite.class).appendArg("context", ThreadContext.class).appendArg("caller", IRubyObject.class).appendArg("self", IRubyObject.class);
        FALLBACK_SIG_1ARG = FALLBACK_SIG.appendArg("arg0", IRubyObject.class);
        FALLBACK_SIG_2ARG = FALLBACK_SIG_1ARG.appendArg("arg1", IRubyObject.class);
        FALLBACK_SIG_3ARG = FALLBACK_SIG_2ARG.appendArg("arg2", IRubyObject.class);
        FALLBACK_SIG_NARG = FALLBACK_SIG.appendArg("args", IRubyObject[].class);
        FALLBACK_SIG_BLOCK = FALLBACK_SIG.appendArg("block", Block.class);
        FALLBACK_SIG_1ARG_BLOCK = FALLBACK_SIG_1ARG.appendArg("block", Block.class);
        FALLBACK_SIG_2ARG_BLOCK = FALLBACK_SIG_2ARG.appendArg("block", Block.class);
        FALLBACK_SIG_3ARG_BLOCK = FALLBACK_SIG_3ARG.appendArg("block", Block.class);
        FALLBACK_SIG_NARG_BLOCK = FALLBACK_SIG_NARG.appendArg("block", Block.class);
        FALLBACK_0 = InvokeDynamicSupport.findStatic(InvocationLinker.class, "invocationFallback", FALLBACK_SIG.type());
        FALLBACK_1 = InvokeDynamicSupport.findStatic(InvocationLinker.class, "invocationFallback", FALLBACK_SIG_1ARG.type());
        FALLBACK_2 = InvokeDynamicSupport.findStatic(InvocationLinker.class, "invocationFallback", FALLBACK_SIG_2ARG.type());
        FALLBACK_3 = InvokeDynamicSupport.findStatic(InvocationLinker.class, "invocationFallback", FALLBACK_SIG_3ARG.type());
        FALLBACK_N = InvokeDynamicSupport.findStatic(InvocationLinker.class, "invocationFallback", FALLBACK_SIG_NARG.type());
        FALLBACK_0_B = InvokeDynamicSupport.findStatic(InvocationLinker.class, "invocationFallback", FALLBACK_SIG_BLOCK.type());
        FALLBACK_1_B = InvokeDynamicSupport.findStatic(InvocationLinker.class, "invocationFallback", FALLBACK_SIG_1ARG_BLOCK.type());
        FALLBACK_2_B = InvokeDynamicSupport.findStatic(InvocationLinker.class, "invocationFallback", FALLBACK_SIG_2ARG_BLOCK.type());
        FALLBACK_3_B = InvokeDynamicSupport.findStatic(InvocationLinker.class, "invocationFallback", FALLBACK_SIG_3ARG_BLOCK.type());
        FALLBACK_N_B = InvokeDynamicSupport.findStatic(InvocationLinker.class, "invocationFallback", FALLBACK_SIG_NARG_BLOCK.type());
        FAIL_0 = InvokeDynamicSupport.findStatic(InvocationLinker.class, "fail", FALLBACK_SIG.type());
        FAIL_1 = InvokeDynamicSupport.findStatic(InvocationLinker.class, "fail", FALLBACK_SIG_1ARG.type());
        FAIL_2 = InvokeDynamicSupport.findStatic(InvocationLinker.class, "fail", FALLBACK_SIG_2ARG.type());
        FAIL_3 = InvokeDynamicSupport.findStatic(InvocationLinker.class, "fail", FALLBACK_SIG_3ARG.type());
        FAIL_N = InvokeDynamicSupport.findStatic(InvocationLinker.class, "fail", FALLBACK_SIG_NARG.type());
        FAIL_0_B = InvokeDynamicSupport.findStatic(InvocationLinker.class, "fail", FALLBACK_SIG_BLOCK.type());
        FAIL_1_B = InvokeDynamicSupport.findStatic(InvocationLinker.class, "fail", FALLBACK_SIG_1ARG_BLOCK.type());
        FAIL_2_B = InvokeDynamicSupport.findStatic(InvocationLinker.class, "fail", FALLBACK_SIG_2ARG_BLOCK.type());
        FAIL_3_B = InvokeDynamicSupport.findStatic(InvocationLinker.class, "fail", FALLBACK_SIG_3ARG_BLOCK.type());
        FAIL_N_B = InvokeDynamicSupport.findStatic(InvocationLinker.class, "fail", FALLBACK_SIG_NARG_BLOCK.type());
        FALLBACKS = new MethodHandle[]{FALLBACK_0, FALLBACK_1, FALLBACK_2, FALLBACK_3, FALLBACK_N};
        FAILS = new MethodHandle[]{FAIL_0, FAIL_1, FAIL_2, FAIL_3, FAIL_N};
        FALLBACKS_B = new MethodHandle[]{FALLBACK_0_B, FALLBACK_1_B, FALLBACK_2_B, FALLBACK_3_B, FALLBACK_N_B};
        FAILS_B = new MethodHandle[]{FAIL_0_B, FAIL_1_B, FAIL_2_B, FAIL_3_B, FAIL_N_B};
    }

    public static class CoreCallGenerator
    implements HandleGenerator {
        @Override
        public boolean canGenerate(JRubyCallSite site, RubyClass cls, DynamicMethod method) {
            DynamicMethod.NativeCall nativeCall = method.getNativeCall();
            if (nativeCall != null) {
                int nativeArgCount = InvocationLinker.getNativeArgCount(method, method.getNativeCall());
                if (nativeArgCount != site.arity()) {
                    throw new IndirectBindingException("arity mismatch or varargs at call site: " + nativeArgCount + " != " + site.arity());
                }
                return true;
            }
            return false;
        }

        @Override
        public MethodHandle generate(JRubyCallSite site, RubyClass cls, DynamicMethod method, String realName) {
            if (((Boolean)Options.INVOKEDYNAMIC_LOG_BINDING.load()).booleanValue()) {
                LOG.info(site.name() + "\tbound to native method " + InvocationLinker.logMethod(method) + ": " + method.getNativeCall(), new Object[0]);
            }
            return InvocationLinker.postProcessNativeHandle(InvocationLinker.createNativeHandle(cls.getClassRuntime(), site, method, realName), site, method, true, false);
        }
    }

    public static class JavaCallGenerator
    implements HandleGenerator {
        @Override
        public boolean canGenerate(JRubyCallSite site, RubyClass cls, DynamicMethod method) {
            DynamicMethod.NativeCall nativeCall = method.getNativeCall();
            if (nativeCall != null && nativeCall.isJava()) {
                if (!((Boolean)Options.INVOKEDYNAMIC_INVOCATION_JAVA.load()).booleanValue()) {
                    throw new IndirectBindingException("direct Java dispatch not enabled");
                }
                if (nativeCall.getNativeSignature().length != site.arity() || site.arity() > 3 || site.isIterator() || !cls.getJavaProxy()) {
                    throw new IndirectBindingException("Java call arity mismatch or > 3 args");
                }
                return true;
            }
            return false;
        }

        @Override
        public MethodHandle generate(JRubyCallSite site, RubyClass cls, DynamicMethod method, String realName) {
            if (((Boolean)Options.INVOKEDYNAMIC_LOG_BINDING.load()).booleanValue()) {
                LOG.info(site.name() + "\tbound to Java method " + InvocationLinker.logMethod(method) + ": " + method.getNativeCall(), new Object[0]);
            }
            return InvocationLinker.postProcessNativeHandle(InvocationLinker.createJavaHandle(site, method), site, method, false, (Boolean)Options.REWRITE_JAVA_TRACE.load());
        }
    }

    public static class FFIGenerator
    implements HandleGenerator {
        @Override
        public boolean canGenerate(JRubyCallSite site, RubyClass cls, DynamicMethod method) {
            if (!((Boolean)Options.INVOKEDYNAMIC_INVOCATION_FFI.load()).booleanValue()) {
                throw new IndirectBindingException("direct FFI dispatch not enabled");
            }
            if (method instanceof DefaultMethod || method instanceof JITNativeInvoker) {
                if (method.getCallConfig() != CallConfiguration.FrameNoneScopeNone) {
                    throw new IndirectBindingException("frame or scope required: " + (Object)((Object)method.getCallConfig()));
                }
                if (!method.getArity().isFixed()) {
                    throw new IndirectBindingException("fixed arity required: " + method.getArity());
                }
                if (method.getArity().getValue() != site.arity()) {
                    throw new IndirectBindingException("arity mismatch");
                }
                if (method.getArity().getValue() > 6) {
                    throw new IndirectBindingException("target args > 6");
                }
                if (site.type().parameterType(site.type().parameterCount() - 1) == Block.class) {
                    throw new IndirectBindingException("callback block supplied");
                }
                return true;
            }
            return false;
        }

        @Override
        public MethodHandle generate(JRubyCallSite site, RubyClass cls, DynamicMethod method, String realName) {
            return InvocationLinker.createFFIHandle(site, method);
        }
    }

    public static class AttrWriterGenerator
    implements HandleGenerator {
        @Override
        public boolean canGenerate(JRubyCallSite site, RubyClass cls, DynamicMethod method) {
            if (method instanceof AttrWriterMethod) {
                if (!((Boolean)Options.INVOKEDYNAMIC_INVOCATION_ATTR.load()).booleanValue()) {
                    throw new IndirectBindingException("direct attribute dispatch not enabled");
                }
                if (site.arity() != 1) {
                    throw new IndirectBindingException("attr writer with > 1 args");
                }
                return true;
            }
            return false;
        }

        @Override
        public MethodHandle generate(JRubyCallSite site, RubyClass cls, DynamicMethod method, String realName) {
            AttrWriterMethod attrReader = (AttrWriterMethod)method;
            String varName = attrReader.getVariableName();
            VariableAccessor accessor = cls.getRealClass().getVariableAccessorForWrite(varName);
            if (((Boolean)Options.INVOKEDYNAMIC_LOG_BINDING.load()).booleanValue()) {
                if (accessor instanceof FieldVariableAccessor) {
                    LOG.info(site.name() + "\tbound as field attr writer " + InvocationLinker.logMethod(method) + ":" + ((AttrWriterMethod)method).getVariableName(), new Object[0]);
                } else {
                    LOG.info(site.name() + "\tbound as attr writer " + InvocationLinker.logMethod(method) + ":" + ((AttrWriterMethod)method).getVariableName(), new Object[0]);
                }
            }
            return InvocationLinker.createAttrWriterHandle(site, cls, accessor);
        }
    }

    public static class AttrReaderGenerator
    implements HandleGenerator {
        @Override
        public boolean canGenerate(JRubyCallSite site, RubyClass cls, DynamicMethod method) {
            if (method instanceof AttrReaderMethod) {
                if (!((Boolean)Options.INVOKEDYNAMIC_INVOCATION_ATTR.load()).booleanValue()) {
                    throw new IndirectBindingException("direct attribute dispatch not enabled");
                }
                if (site.arity() != 0) {
                    throw new IndirectBindingException("attr reader with > 0 args");
                }
                return true;
            }
            return false;
        }

        @Override
        public MethodHandle generate(JRubyCallSite site, RubyClass cls, DynamicMethod method, String realName) {
            AttrReaderMethod attrReader = (AttrReaderMethod)method;
            String varName = attrReader.getVariableName();
            VariableAccessor accessor = cls.getRealClass().getVariableAccessorForWrite(varName);
            if (((Boolean)Options.INVOKEDYNAMIC_LOG_BINDING.load()).booleanValue()) {
                if (accessor instanceof FieldVariableAccessor) {
                    LOG.info(site.name() + "\tbound as field attr reader " + InvocationLinker.logMethod(method) + ":" + ((AttrReaderMethod)method).getVariableName(), new Object[0]);
                } else {
                    LOG.info(site.name() + "\tbound as attr reader " + InvocationLinker.logMethod(method) + ":" + ((AttrReaderMethod)method).getVariableName(), new Object[0]);
                }
            }
            return InvocationLinker.createAttrReaderHandle(site, cls, accessor);
        }
    }

    public static class HandleMethodGenerator
    implements HandleGenerator {
        @Override
        public boolean canGenerate(JRubyCallSite site, RubyClass cls, DynamicMethod method) {
            return method instanceof HandleMethod;
        }

        @Override
        public MethodHandle generate(JRubyCallSite site, RubyClass cls, DynamicMethod method, String realName) {
            MethodHandle handle = ((HandleMethod)method).getHandle(site.arity());
            if (handle == null) {
                throw new IndirectBindingException("MH dynamic method does not have needed arity");
            }
            if (((Boolean)Options.INVOKEDYNAMIC_LOG_BINDING.load()).booleanValue()) {
                LOG.info(site.name() + "\tbound from MHDynMethod " + InvocationLinker.logMethod(method) + ":" + handle, new Object[0]);
            }
            Signature fullSig = site.fullSignature();
            MethodHandle nativeTarget = Binder.from((MethodType)fullSig.type()).permute(fullSig.to(new String[]{"context", "self", "arg*", "block"})).invoke(handle);
            nativeTarget = InvocationLinker.addOrRemoveBlock(site, nativeTarget);
            return nativeTarget;
        }
    }

    public static interface HandleGenerator {
        public boolean canGenerate(JRubyCallSite var1, RubyClass var2, DynamicMethod var3);

        public MethodHandle generate(JRubyCallSite var1, RubyClass var2, DynamicMethod var3, String var4);
    }

    private static class IndirectBindingException
    extends RuntimeException {
        public IndirectBindingException(String reason2) {
            super(reason2);
        }
    }
}

