/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.translator;

import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.source.NullSourceSection;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.jcodings.Encoding;
import org.jruby.RubyFile;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.NilNode;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.jruby.parser.Parser;
import org.jruby.parser.ParserConfiguration;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.scope.ManyVarsDynamicScope;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyRootNode;
import org.jruby.truffle.nodes.control.SequenceNode;
import org.jruby.truffle.nodes.literal.ObjectLiteralNode;
import org.jruby.truffle.nodes.methods.CatchNextNode;
import org.jruby.truffle.nodes.methods.CatchRetryAsErrorNode;
import org.jruby.truffle.nodes.methods.CatchReturnAsErrorNode;
import org.jruby.truffle.runtime.LexicalScope;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyCallStack;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyException;
import org.jruby.truffle.runtime.methods.SharedMethodInfo;
import org.jruby.truffle.translator.BodyTranslator;
import org.jruby.truffle.translator.MethodTranslator;
import org.jruby.truffle.translator.ModuleTranslator;
import org.jruby.truffle.translator.NodeWrapper;
import org.jruby.truffle.translator.TranslatorEnvironment;

public class TranslatorDriver {
    private long nextReturnID = 0L;

    public RubyNode parse(RubyContext context, Node parseTree, ArgsNode argsNode, Node bodyNode, RubyNode currentNode) {
        MethodTranslator translator;
        LexicalScope lexicalScope = context.getRootLexicalScope();
        SharedMethodInfo sharedMethod = new SharedMethodInfo(null, lexicalScope, "(unknown)", false, parseTree, false);
        TranslatorEnvironment environment = new TranslatorEnvironment(context, this.environmentForFrame(context, null), this, this.allocateReturnID(), true, true, sharedMethod, sharedMethod.getName(), false);
        try {
            translator = new MethodTranslator(currentNode, context, null, environment, false, Source.fromFileName((String)bodyNode.getPosition().getFile()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return translator.compileFunctionNode(null, "(unknown)", argsNode, bodyNode, sharedMethod);
    }

    public RubyRootNode parse(RubyContext context, Source source2, Encoding defaultEncoding, ParserContext parserContext, MaterializedFrame parentFrame, RubyNode currentNode, NodeWrapper wrapper) {
        RootNode node;
        Parser parser = new Parser(context.getRuntime());
        StaticScope staticScope = context.getRuntime().getStaticScopeFactory().newLocalScope(null);
        if (parentFrame != null) {
            MaterializedFrame frame = parentFrame;
            while (frame != null) {
                for (FrameSlot slot : frame.getFrameDescriptor().getSlots()) {
                    if (!(slot.getIdentifier() instanceof String)) continue;
                    String name2 = (String)slot.getIdentifier();
                    staticScope.addVariableThisScope(name2);
                }
                frame = RubyArguments.getDeclarationFrame(frame.getArguments());
            }
        }
        ParserConfiguration parserConfiguration = new ParserConfiguration(context.getRuntime(), 0, false, parserContext == ParserContext.TOP_LEVEL, true);
        parserConfiguration.setDefaultEncoding(defaultEncoding);
        try {
            node = (RootNode)parser.parse(source2.getName(), source2.getCode().getBytes(StandardCharsets.UTF_8), (DynamicScope)new ManyVarsDynamicScope(staticScope), parserConfiguration);
        }
        catch (Exception e) {
            String message2 = e.getMessage();
            if (message2 == null) {
                message2 = "(no message)";
            }
            throw new RaiseException(new RubyException(context.getCoreLibrary().getSyntaxErrorClass(), context.makeString(message2), RubyCallStack.getBacktrace(currentNode)));
        }
        return this.parse(currentNode, context, source2, parserContext, parentFrame, node, wrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyRootNode parse(RubyNode currentNode, RubyContext context, Source source2, ParserContext parserContext, MaterializedFrame parentFrame, RootNode rootNode, NodeWrapper wrapper) {
        RubyNode truffleNode;
        SourceSection sourceSection = source2.createSection("<main>", 0, source2.getCode().length());
        SharedMethodInfo sharedMethodInfo = new SharedMethodInfo(sourceSection, context.getRootLexicalScope(), "<main>", false, rootNode, false);
        TranslatorEnvironment environment = new TranslatorEnvironment(context, this.environmentForFrame(context, parentFrame), this, this.allocateReturnID(), true, false, sharedMethodInfo, sharedMethodInfo.getName(), false);
        Object data2 = this.getData(context);
        if (data2 != null) {
            context.getCoreLibrary().getObjectClass().setConstant(currentNode, "DATA", data2);
        }
        BodyTranslator translator = parserContext == ParserContext.MODULE ? new ModuleTranslator(currentNode, context, null, environment, source2) : new BodyTranslator(currentNode, context, null, environment, source2, parserContext == ParserContext.TOP_LEVEL);
        if (rootNode.getBodyNode() == null || rootNode.getBodyNode() instanceof NilNode) {
            translator.parentSourceSection = sharedMethodInfo.getSourceSection();
            try {
                truffleNode = new ObjectLiteralNode(context, null, context.getCoreLibrary().getNilObject());
            }
            finally {
                translator.parentSourceSection = null;
            }
        } else {
            truffleNode = rootNode.getBodyNode().accept(translator);
        }
        if (environment.getFlipFlopStates().size() > 0) {
            truffleNode = SequenceNode.sequence(context, truffleNode.getSourceSection(), translator.initFlipFlopStates(truffleNode.getSourceSection()), truffleNode);
        }
        truffleNode = new CatchNextNode(context, truffleNode.getSourceSection(), truffleNode);
        truffleNode = new CatchReturnAsErrorNode(context, truffleNode.getSourceSection(), truffleNode);
        truffleNode = new CatchRetryAsErrorNode(context, truffleNode.getSourceSection(), truffleNode);
        truffleNode = wrapper.wrap(truffleNode);
        return new RubyRootNode(context, truffleNode.getSourceSection(), environment.getFrameDescriptor(), sharedMethodInfo, truffleNode);
    }

    private Object getData(RubyContext context) {
        IRubyObject jrubyData = context.getRuntime().getObject().getConstantNoConstMissing("DATA", false, false);
        if (jrubyData == null) {
            return null;
        }
        RubyFile jrubyFile = (RubyFile)jrubyData;
        org.jruby.truffle.runtime.core.RubyFile truffleFile = new org.jruby.truffle.runtime.core.RubyFile(context.getCoreLibrary().getFileClass(), new InputStreamReader(jrubyFile.getInStream(), StandardCharsets.UTF_8), null);
        return truffleFile;
    }

    public long allocateReturnID() {
        if (this.nextReturnID == Long.MAX_VALUE) {
            throw new RuntimeException("Return IDs exhausted");
        }
        long allocated = this.nextReturnID++;
        return allocated;
    }

    private TranslatorEnvironment environmentForFrame(RubyContext context, MaterializedFrame frame) {
        if (frame == null) {
            return null;
        }
        NullSourceSection sourceSection = new NullSourceSection("Unknown source section", "(unknown)");
        SharedMethodInfo sharedMethodInfo = new SharedMethodInfo((SourceSection)sourceSection, context.getRootLexicalScope(), "(unknown)", false, null, false);
        MaterializedFrame parent = RubyArguments.getDeclarationFrame(frame.getArguments());
        return new TranslatorEnvironment(context, this.environmentForFrame(context, parent), frame.getFrameDescriptor(), this, this.allocateReturnID(), true, true, sharedMethodInfo, sharedMethodInfo.getName(), false);
    }

    public static enum ParserContext {
        TOP_LEVEL,
        SHELL,
        MODULE;

    }
}

