/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.core;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;
import java.util.concurrent.ConcurrentHashMap;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyRootNode;
import org.jruby.truffle.nodes.methods.SymbolProcNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.methods.SharedMethodInfo;
import org.jruby.util.ByteList;

public class RubySymbol
extends RubyBasicObject {
    private final String symbol;
    private final ByteList symbolBytes;

    private RubySymbol(RubyClass symbolClass, String symbol, ByteList byteList) {
        super(symbolClass);
        this.symbol = symbol;
        this.symbolBytes = byteList;
    }

    public static RubySymbol newSymbol(RubyContext runtime, String name2) {
        return runtime.getSymbolTable().getSymbol(name2);
    }

    public RubyProc toProc(SourceSection sourceSection, RubyNode currentNode) {
        RubyNode.notDesignedForCompilation();
        RubyContext context = this.getContext();
        SharedMethodInfo sharedMethodInfo = new SharedMethodInfo(sourceSection, null, this.symbol, true, null, false);
        RubyRootNode rootNode = new RubyRootNode(context, sourceSection, new FrameDescriptor(), sharedMethodInfo, new SymbolProcNode(context, sourceSection, this.symbol));
        RootCallTarget callTarget = Truffle.getRuntime().createCallTarget((RootNode)rootNode);
        return new RubyProc(context.getCoreLibrary().getProcClass(), RubyProc.Type.PROC, sharedMethodInfo, (CallTarget)callTarget, (CallTarget)callTarget, (CallTarget)callTarget, null, null, null, this.getContext().getCoreLibrary().getNilObject(), null);
    }

    public org.jruby.RubySymbol getJRubySymbol() {
        RubyNode.notDesignedForCompilation();
        return this.getContext().getRuntime().newSymbol(this.symbolBytes);
    }

    public int hashCode() {
        return this.symbol.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof RubySymbol) {
            return this.symbol == ((RubySymbol)other).symbol;
        }
        if (other instanceof RubyString) {
            return other.equals(this.symbol);
        }
        return super.equals(other);
    }

    public String toString() {
        return this.symbol;
    }

    public RubyString toRubyString() {
        return this.getContext().makeString(this.toString());
    }

    @Override
    public boolean hasNoSingleton() {
        return true;
    }

    public static final class SymbolTable {
        private final ConcurrentHashMap<ByteList, RubySymbol> symbolsTable = new ConcurrentHashMap();
        private final RubyContext context;

        public SymbolTable(RubyContext context) {
            this.context = context;
        }

        public RubySymbol getSymbol(String name2) {
            ByteList byteList = org.jruby.RubySymbol.symbolBytesFromString(this.context.getRuntime(), name2);
            RubySymbol symbol = this.symbolsTable.get(byteList);
            if (symbol == null) {
                symbol = this.createSymbol(name2);
            }
            return symbol;
        }

        public RubySymbol getSymbol(ByteList byteList) {
            RubySymbol symbol = this.symbolsTable.get(byteList);
            if (symbol == null) {
                symbol = this.createSymbol(byteList);
            }
            return symbol;
        }

        private RubySymbol createSymbol(ByteList byteList) {
            RubySymbol symbol = new RubySymbol(this.context.getCoreLibrary().getSymbolClass(), byteList.toString(), byteList);
            this.symbolsTable.put(byteList, symbol);
            return symbol;
        }

        private RubySymbol createSymbol(String name2) {
            RubySymbol symbol;
            ByteList byteList = org.jruby.RubySymbol.symbolBytesFromString(this.context.getRuntime(), name2);
            RubySymbol existingSymbol = this.symbolsTable.putIfAbsent(byteList, symbol = new RubySymbol(this.context.getCoreLibrary().getSymbolClass(), name2, byteList));
            return existingSymbol == null ? symbol : existingSymbol;
        }

        public ConcurrentHashMap<ByteList, RubySymbol> getSymbolsTable() {
            return this.symbolsTable;
        }
    }
}

