/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameSlot;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import org.jcodings.Encoding;
import org.joni.Matcher;
import org.joni.NameEntry;
import org.joni.Regex;
import org.joni.Region;
import org.joni.Syntax;
import org.joni.exception.SyntaxException;
import org.joni.exception.ValueException;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.objects.Allocator;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyEncoding;
import org.jruby.truffle.runtime.core.RubyMatchData;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.util.ByteList;
import org.jruby.util.StringSupport;

public class RubyRegexp
extends RubyBasicObject {
    @CompilerDirectives.CompilationFinal
    private Regex regex;
    @CompilerDirectives.CompilationFinal
    private ByteList source;
    private RubyEncoding encoding;

    public RubyRegexp(RubyClass regexpClass) {
        super(regexpClass);
    }

    public RubyRegexp(RubyNode currentNode, RubyClass regexpClass, ByteList regex, int options2) {
        this(regexpClass);
        this.initialize(RubyRegexp.compile(currentNode, this.getContext(), regex, options2), regex);
    }

    public RubyRegexp(RubyClass regexpClass, Regex regex, ByteList source2) {
        this(regexpClass);
        this.initialize(regex, source2);
    }

    public void initialize(RubyNode currentNode, ByteList setSource, int options2) {
        this.regex = RubyRegexp.compile(currentNode, this.getContext(), setSource, options2);
        this.source = setSource;
    }

    public void initialize(RubyNode currentNode, ByteList setSource) {
        this.initialize(currentNode, setSource, 0);
    }

    public void initialize(Regex setRegex, ByteList setSource) {
        this.regex = setRegex;
        this.source = setSource;
    }

    public Regex getRegex() {
        return this.regex;
    }

    public ByteList getSource() {
        return this.source;
    }

    @CompilerDirectives.TruffleBoundary
    public Object matchCommon(ByteList bytes2, boolean operator, boolean setNamedCaptures) {
        byte[] stringBytes = bytes2.bytes();
        Matcher matcher = this.regex.matcher(stringBytes);
        int range = stringBytes.length;
        return this.matchCommon(bytes2, operator, setNamedCaptures, matcher, 0, range);
    }

    @CompilerDirectives.TruffleBoundary
    public Object matchCommon(ByteList bytes2, boolean operator, boolean setNamedCaptures, Matcher matcher, int startPos, int range) {
        RubyContext context = this.getContext();
        Frame frame = Truffle.getRuntime().getCallerFrame().getFrame(FrameInstance.FrameAccess.READ_WRITE, false);
        int match = matcher.search(startPos, range, 0);
        RubyNilClass nil = this.getContext().getCoreLibrary().getNilObject();
        if (match == -1) {
            this.setThread("$~", nil);
            if (setNamedCaptures && this.regex.numberOfNames() > 0) {
                Iterator i2 = this.regex.namedBackrefIterator();
                while (i2.hasNext()) {
                    NameEntry e = (NameEntry)i2.next();
                    String name2 = new String(e.name, e.nameP, e.nameEnd - e.nameP, StandardCharsets.UTF_8).intern();
                    this.setFrame(frame, name2, this.getContext().getCoreLibrary().getNilObject());
                }
            }
            return this.getContext().getCoreLibrary().getNilObject();
        }
        Region region = matcher.getEagerRegion();
        Object[] values2 = new Object[region.numRegs];
        for (int n = 0; n < region.numRegs; ++n) {
            RubyBasicObject groupString;
            int start2 = region.beg[n];
            int end2 = region.end[n];
            if (operator) {
                groupString = start2 > -1 && end2 > -1 ? new RubyString(context.getCoreLibrary().getStringClass(), bytes2.makeShared(start2, end2 - start2).dup()) : this.getContext().getCoreLibrary().getNilObject();
                values2[n] = groupString;
                continue;
            }
            if (start2 == -1 || end2 == -1) {
                values2[n] = this.getContext().getCoreLibrary().getNilObject();
                continue;
            }
            groupString = new RubyString(context.getCoreLibrary().getStringClass(), bytes2.makeShared(start2, end2 - start2).dup());
            values2[n] = groupString;
        }
        RubyString pre = new RubyString(context.getCoreLibrary().getStringClass(), bytes2.makeShared(0, region.beg[0]).dup());
        RubyString post = new RubyString(context.getCoreLibrary().getStringClass(), bytes2.makeShared(region.end[0], bytes2.length() - region.end[0]).dup());
        RubyString global = new RubyString(context.getCoreLibrary().getStringClass(), bytes2.makeShared(region.beg[0], region.end[0] - region.beg[0]).dup());
        RubyMatchData matchObject = new RubyMatchData(context.getCoreLibrary().getMatchDataClass(), region, values2, pre, post, global);
        if (operator && values2.length > 0) {
            int nonNil = values2.length - 1;
            while (values2[nonNil] == this.getContext().getCoreLibrary().getNilObject()) {
                --nonNil;
            }
        }
        this.setThread("$~", matchObject);
        if (setNamedCaptures && this.regex.numberOfNames() > 0) {
            Iterator i3 = this.regex.namedBackrefIterator();
            while (i3.hasNext()) {
                RubyBasicObject value2;
                NameEntry e = (NameEntry)i3.next();
                String name3 = new String(e.name, e.nameP, e.nameEnd - e.nameP, StandardCharsets.UTF_8).intern();
                int nth = this.regex.nameToBackrefNumber(e.name, e.nameP, e.nameEnd, region);
                if (nth >= region.numRegs || nth < 0 && (nth += region.numRegs) <= 0) {
                    value2 = this.getContext().getCoreLibrary().getNilObject();
                } else {
                    int start3 = region.beg[nth];
                    int end3 = region.end[nth];
                    value2 = start3 != -1 ? new RubyString(context.getCoreLibrary().getStringClass(), bytes2.makeShared(start3, end3 - start3).dup()) : this.getContext().getCoreLibrary().getNilObject();
                }
                this.setFrame(frame, name3, value2);
            }
        }
        if (operator) {
            return matcher.getBegin();
        }
        return matchObject;
    }

    private void setFrame(Frame frame, String name2, Object value2) {
        assert (value2 != null);
        while (frame != null) {
            FrameSlot slot = frame.getFrameDescriptor().findFrameSlot((Object)name2);
            if (slot != null) {
                frame.setObject(slot, value2);
                break;
            }
            frame = RubyArguments.getDeclarationFrame(frame.getArguments());
        }
    }

    public void setThread(String name2, Object value2) {
        assert (value2 != null);
        RubyNode.notDesignedForCompilation();
        this.getContext().getThreadManager().getCurrentThread().getThreadLocals().getOperations().setInstanceVariable(this.getContext().getThreadManager().getCurrentThread().getThreadLocals(), name2, value2);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyString gsub(RubyString string2, String replacement2) {
        RubyContext context = this.getContext();
        byte[] stringBytes = string2.getBytes().bytes();
        Encoding encoding2 = string2.getBytes().getEncoding();
        Matcher matcher = this.regex.matcher(stringBytes);
        int p2 = string2.getBytes().getBegin();
        int end2 = 0;
        int range = p2 + string2.getBytes().getRealSize();
        int lastMatchEnd = 0;
        int matchedStringIndex = 0;
        StringBuilder builder = new StringBuilder();
        while (true) {
            Object matchData;
            if ((matchData = this.matchCommon(string2.getBytes(), false, false, matcher, p2 + end2, range)) == context.getCoreLibrary().getNilObject()) break;
            Region region = matcher.getEagerRegion();
            int regionStart = region.beg[matchedStringIndex];
            int regionEnd = region.end[matchedStringIndex];
            builder.append(StandardCharsets.UTF_8.decode(ByteBuffer.wrap(stringBytes, lastMatchEnd, regionStart - lastMatchEnd)));
            builder.append(StandardCharsets.UTF_8.decode(ByteBuffer.wrap(replacement2.getBytes(StandardCharsets.UTF_8))));
            lastMatchEnd = regionEnd;
            end2 = StringSupport.positionEndForScan(string2.getBytes(), matcher, encoding2, p2, range);
        }
        builder.append(StandardCharsets.UTF_8.decode(ByteBuffer.wrap(stringBytes, lastMatchEnd, range - lastMatchEnd)));
        return context.makeString(builder.toString());
    }

    @CompilerDirectives.TruffleBoundary
    public RubyString sub(String string2, String replacement2) {
        RubyContext context = this.getContext();
        byte[] stringBytes = string2.getBytes(StandardCharsets.UTF_8);
        Matcher matcher = this.regex.matcher(stringBytes);
        int match = matcher.search(0, stringBytes.length, 0);
        if (match == -1) {
            return context.makeString(string2);
        }
        StringBuilder builder = new StringBuilder();
        builder.append(StandardCharsets.UTF_8.decode(ByteBuffer.wrap(stringBytes, 0, matcher.getBegin())));
        builder.append(StandardCharsets.UTF_8.decode(ByteBuffer.wrap(replacement2.getBytes(StandardCharsets.UTF_8))));
        builder.append(StandardCharsets.UTF_8.decode(ByteBuffer.wrap(stringBytes, matcher.getEnd(), stringBytes.length - matcher.getEnd())));
        return context.makeString(builder.toString());
    }

    @CompilerDirectives.TruffleBoundary
    public RubyString[] split(String string2) {
        RubyContext context = this.getContext();
        byte[] stringBytes = string2.getBytes(StandardCharsets.UTF_8);
        Matcher matcher = this.regex.matcher(stringBytes);
        ArrayList<RubyString> strings = new ArrayList<RubyString>();
        int p2 = 0;
        while (true) {
            int match;
            if ((match = matcher.search(p2, stringBytes.length, 0)) == -1) break;
            strings.add(context.makeString(StandardCharsets.UTF_8.decode(ByteBuffer.wrap(stringBytes, p2, matcher.getBegin() - p2)).toString()));
            p2 = matcher.getEnd();
        }
        strings.add(context.makeString(StandardCharsets.UTF_8.decode(ByteBuffer.wrap(stringBytes, p2, stringBytes.length - p2)).toString()));
        return strings.toArray(new RubyString[strings.size()]);
    }

    @CompilerDirectives.TruffleBoundary
    public Object scan(RubyString string2) {
        Object matchData;
        RubyContext context = this.getContext();
        byte[] stringBytes = string2.getBytes().bytes();
        Encoding encoding2 = string2.getBytes().getEncoding();
        Matcher matcher = this.regex.matcher(stringBytes);
        int p2 = string2.getBytes().getBegin();
        int end2 = 0;
        int range = p2 + string2.getBytes().getRealSize();
        Object lastGoodMatchData = this.getContext().getCoreLibrary().getNilObject();
        if (this.regex.numberOfCaptures() == 0) {
            Object matchData2;
            ArrayList<RubyString> strings = new ArrayList<RubyString>();
            while ((matchData2 = this.matchCommon(string2.getBytes(), false, true, matcher, p2 + end2, range)) != context.getCoreLibrary().getNilObject()) {
                RubyMatchData md = (RubyMatchData)matchData2;
                Object[] values2 = md.getValues();
                assert (values2.length == 1);
                strings.add((RubyString)values2[0]);
                lastGoodMatchData = matchData2;
                end2 = StringSupport.positionEndForScan(string2.getBytes(), matcher, encoding2, p2, range);
            }
            this.setThread("$~", lastGoodMatchData);
            return strings.toArray(new RubyString[strings.size()]);
        }
        ArrayList<RubyArray> allMatches = new ArrayList<RubyArray>();
        while ((matchData = this.matchCommon(string2.getBytes(), false, true, matcher, p2 + end2, stringBytes.length)) != context.getCoreLibrary().getNilObject()) {
            Object[] captures2 = ((RubyMatchData)matchData).getCaptures();
            allMatches.add(new RubyArray(context.getCoreLibrary().getArrayClass(), captures2, captures2.length));
            lastGoodMatchData = matchData;
            end2 = StringSupport.positionEndForScan(string2.getBytes(), matcher, encoding2, p2, range);
        }
        this.setThread("$~", lastGoodMatchData);
        return allMatches.toArray(new Object[allMatches.size()]);
    }

    public int hashCode() {
        return this.regex.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RubyRegexp)) {
            return false;
        }
        RubyRegexp other = (RubyRegexp)obj;
        return !(this.source == null ? other.source != null : !this.source.equals((Object)other.source));
    }

    public static Regex compile(RubyNode currentNode, RubyContext context, ByteList bytes2, int options2) {
        RubyNode.notDesignedForCompilation();
        return RubyRegexp.compile(currentNode, context, bytes2.bytes(), bytes2.getEncoding(), options2);
    }

    public static Regex compile(RubyNode currentNode, RubyContext context, byte[] bytes2, Encoding encoding2, int options2) {
        RubyNode.notDesignedForCompilation();
        try {
            return new Regex(bytes2, 0, bytes2.length, options2, encoding2, Syntax.RUBY);
        }
        catch (ValueException e) {
            throw new RaiseException(context.getCoreLibrary().runtimeError("error compiling regex", currentNode));
        }
        catch (SyntaxException e) {
            throw new RaiseException(context.getCoreLibrary().regexpError(e.getMessage(), currentNode));
        }
    }

    public void forceEncoding(RubyEncoding encoding2) {
        this.encoding = encoding2;
    }

    public RubyEncoding getEncoding() {
        if (this.encoding == null) {
            this.encoding = RubyEncoding.getEncoding(this.regex.getEncoding());
        }
        return this.encoding;
    }

    public static class RegexpAllocator
    implements Allocator {
        @Override
        public RubyBasicObject allocate(RubyContext context, RubyClass rubyClass, RubyNode currentNode) {
            return new RubyRegexp(context.getCoreLibrary().getRegexpClass());
        }
    }
}

