/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.core;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.objects.Allocator;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyModule;

public class RubyClass
extends RubyModule {
    @CompilerDirectives.CompilationFinal
    Allocator allocator = new RubyBasicObject.BasicObjectAllocator();
    private boolean isSingleton;
    private final Set<RubyClass> subClasses = Collections.newSetFromMap(new WeakHashMap());

    public static RubyClass createBootClass(RubyContext context, String name2) {
        return new RubyClass(context, null, null, name2, false);
    }

    public RubyClass(RubyContext context, RubyModule lexicalParent, RubyClass superclass2, String name2) {
        this(context, lexicalParent, superclass2, name2, false);
        this.ensureSingletonConsistency();
    }

    protected static RubyClass createSingletonClassOfObject(RubyContext context, RubyClass superclass2, String name2) {
        return new RubyClass(context, null, superclass2, name2, true).ensureSingletonConsistency();
    }

    protected RubyClass(RubyContext context, RubyModule lexicalParent, RubyClass superclass2, String name2, boolean isSingleton) {
        super(context, context.getCoreLibrary().getClassClass(), lexicalParent, name2, null);
        this.isSingleton = isSingleton;
        if (superclass2 != null) {
            this.unsafeSetSuperclass(superclass2);
        }
    }

    public void setAllocator(Allocator allocator) {
        this.allocator = allocator;
    }

    public void initialize(RubyClass superclass2) {
        this.unsafeSetSuperclass(superclass2);
        this.ensureSingletonConsistency();
        this.allocator = superclass2.allocator;
    }

    @Override
    public void initCopy(RubyModule other) {
        super.initCopy(other);
        assert (other instanceof RubyClass);
    }

    private RubyClass ensureSingletonConsistency() {
        this.createOneSingletonClass();
        return this;
    }

    @Override
    public RubyClass getSingletonClass(Node currentNode) {
        return this.createOneSingletonClass().ensureSingletonConsistency();
    }

    private RubyClass createOneSingletonClass() {
        CompilerAsserts.neverPartOfCompilation();
        if (this.metaClass.isSingleton()) {
            return this.metaClass;
        }
        RubyClass singletonSuperclass = this.getSuperClass() == null ? this.getLogicalClass() : this.getSuperClass().createOneSingletonClass();
        this.metaClass = new RubyClass(this.getContext(), null, singletonSuperclass, String.format("#<Class:%s>", this.getName()), true);
        return this.metaClass;
    }

    public void unsafeSetSuperclass(RubyClass newSuperclass) {
        RubyNode.notDesignedForCompilation();
        assert (this.parentModule == null);
        this.unsafeSetParent(newSuperclass);
        newSuperclass.subClasses.add(this);
        this.newVersion();
    }

    public RubyBasicObject allocate(RubyNode currentNode) {
        return this.allocator.allocate(this.getContext(), this, currentNode);
    }

    public boolean isSingleton() {
        return this.isSingleton;
    }

    public RubyClass getSuperClass() {
        CompilerAsserts.neverPartOfCompilation();
        for (RubyModule ancestor : this.parentAncestors()) {
            if (!(ancestor instanceof RubyClass)) continue;
            return (RubyClass)ancestor;
        }
        return null;
    }

    public Allocator getAllocator() {
        return this.allocator;
    }

    public static class ClassAllocator
    implements Allocator {
        @Override
        public RubyBasicObject allocate(RubyContext context, RubyClass rubyClass, RubyNode currentNode) {
            return new RubyClass(context, null, null, null, false);
        }
    }
}

