/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime;

import com.oracle.truffle.api.ExactMath;
import java.math.BigInteger;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBignum;

public abstract class ObjectIDOperations {
    public static final int FALSE = 0;
    public static final int TRUE = 2;
    public static final int NIL = 4;
    public static final int FIRST_OBJECT_ID = 6;
    private static final BigInteger LARGE_FIXNUM_FLAG = BigInteger.ONE.shiftLeft(64);
    private static final BigInteger FLOAT_FLAG = BigInteger.ONE.shiftLeft(65);
    private static final long SMALL_FIXNUM_MIN = -4611686018427387904L;
    private static final long SMALL_FIXNUM_MAX = 0x3FFFFFFFFFFFFFFFL;

    public static boolean isSmallFixnum(long fixnum) {
        return -4611686018427387904L <= fixnum && fixnum <= 0x3FFFFFFFFFFFFFFFL;
    }

    public static long smallFixnumToIDOverflow(long fixnum) throws ArithmeticException {
        return ExactMath.addExact((long)ExactMath.multiplyExact((long)fixnum, (long)2L), (long)1L);
    }

    public static long smallFixnumToID(long fixnum) {
        assert (ObjectIDOperations.isSmallFixnum(fixnum));
        return fixnum * 2L + 1L;
    }

    public static RubyBignum largeFixnumToID(RubyContext context, long fixnum) {
        assert (!ObjectIDOperations.isSmallFixnum(fixnum));
        return new RubyBignum(context.getCoreLibrary().getBignumClass(), BigInteger.valueOf(fixnum).or(LARGE_FIXNUM_FLAG));
    }

    public static RubyBignum floatToID(RubyContext context, double value2) {
        long bits = Double.doubleToRawLongBits(value2);
        return new RubyBignum(context.getCoreLibrary().getBignumClass(), BigInteger.valueOf(bits).or(FLOAT_FLAG));
    }

    public static boolean isSmallFixnumID(long id2) {
        return id2 % 2L != 0L;
    }

    public static long toFixnum(long id2) {
        return (id2 - 1L) / 2L;
    }

    public static boolean isLargeFixnumID(RubyBignum id2) {
        return !id2.bigIntegerValue().and(LARGE_FIXNUM_FLAG).equals(BigInteger.ZERO);
    }

    public static long toFixnum(RubyBignum id2) {
        return id2.longValue();
    }

    public static boolean isFloatID(RubyBignum id2) {
        return !id2.bigIntegerValue().and(FLOAT_FLAG).equals(BigInteger.ZERO);
    }

    public static double toFloat(RubyBignum id2) {
        return Double.longBitsToDouble(id2.longValue());
    }
}

