/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.supercall;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.ModuleOperations;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyCallStack;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyModule;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.methods.InternalMethod;
import org.jruby.truffle.runtime.methods.MethodLike;

public abstract class AbstractGeneralSuperCallNode
extends RubyNode {
    @Node.Child
    protected DirectCallNode callNode;
    @CompilerDirectives.CompilationFinal
    protected Assumption unmodifiedAssumption;
    @CompilerDirectives.CompilationFinal
    protected InternalMethod method;

    public AbstractGeneralSuperCallNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    protected boolean guard() {
        return this.method != null && this.unmodifiedAssumption != null && this.unmodifiedAssumption.isValid();
    }

    protected void lookup(VirtualFrame frame) {
        CompilerAsserts.neverPartOfCompilation();
        FrameInstance currentFrame = Truffle.getRuntime().getCurrentFrame();
        MethodLike methodLike = RubyCallStack.getMethod(currentFrame);
        while (!(methodLike instanceof InternalMethod)) {
            methodLike = ((RubyProc)methodLike).getMethod();
        }
        String name2 = ((InternalMethod)methodLike).getName();
        RubyModule declaringModule = RubyCallStack.getCurrentDeclaringModule();
        RubyClass selfMetaClass = this.getContext().getCoreLibrary().getMetaClass(RubyArguments.getSelf(frame.getArguments()));
        this.method = ModuleOperations.lookupSuperMethod(declaringModule, name2, selfMetaClass);
        if (this.method == null || this.method.isUndefined()) {
            this.method = null;
            throw new RaiseException(this.getContext().getCoreLibrary().noMethodError(String.format("super: no superclass method `%s'", name2), this));
        }
        DirectCallNode newCallNode = Truffle.getRuntime().createDirectCallNode(this.method.getCallTarget());
        if (this.callNode == null) {
            this.callNode = (DirectCallNode)this.insert((Node)newCallNode);
        } else {
            this.callNode.replace((Node)newCallNode);
        }
        this.unmodifiedAssumption = declaringModule.getUnmodifiedAssumption();
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        AbstractGeneralSuperCallNode.notDesignedForCompilation();
        RubyContext context = this.getContext();
        try {
            Object self2 = RubyArguments.getSelf(frame.getArguments());
            if (!this.guard()) {
                this.lookup(frame);
            }
            if (this.method == null || this.method.isUndefined() || !this.method.isVisibleTo(this, context.getCoreLibrary().getMetaClass(self2))) {
                return this.getContext().getCoreLibrary().getNilObject();
            }
            return context.makeString("super");
        }
        catch (Throwable t) {
            return this.getContext().getCoreLibrary().getNilObject();
        }
    }
}

