/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.ConditionProfile;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitive;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.util.StringSupport;

public abstract class StringPrimitiveNodes {

    @RubiniusPrimitive(name="string_index")
    public static abstract class StringIndexPrimitiveNode
    extends RubiniusPrimitiveNode {
        public StringIndexPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public StringIndexPrimitiveNode(StringIndexPrimitiveNode prev) {
            super(prev);
        }

        @Specialization
        public Object stringIndex(RubyString string2, RubyString pattern, int start2) {
            int index2 = StringSupport.index(string2, pattern, start2, string2.getBytes().getEncoding());
            if (index2 == -1) {
                return this.getContext().getCoreLibrary().getNilObject();
            }
            return index2;
        }
    }

    @RubiniusPrimitive(name="string_to_f", needsSelf=false)
    public static abstract class StringToFPrimitiveNode
    extends RubiniusPrimitiveNode {
        public StringToFPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public StringToFPrimitiveNode(StringToFPrimitiveNode prev) {
            super(prev);
        }

        @Specialization
        public RubyString stringToF(RubyString string2) {
            throw new UnsupportedOperationException("string_to_f");
        }
    }

    @RubiniusPrimitive(name="string_check_null_safe", needsSelf=false)
    public static abstract class StringCheckNullSafePrimitiveNode
    extends RubiniusPrimitiveNode {
        private final ConditionProfile nullByteProfile = ConditionProfile.createBinaryProfile();

        public StringCheckNullSafePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public StringCheckNullSafePrimitiveNode(StringCheckNullSafePrimitiveNode prev) {
            super(prev);
        }

        @Specialization
        public boolean stringCheckNullSafe(RubyString string2) {
            for (byte b2 : string2.getBytes().unsafeBytes()) {
                if (!this.nullByteProfile.profile(b2 == 0)) continue;
                return false;
            }
            return true;
        }
    }
}

