/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.objects;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.objects.ClassNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;

@GeneratedBy(value=ClassNode.class)
public final class ClassNodeFactory
extends NodeFactoryBase<ClassNode> {
    private static ClassNodeFactory instance;

    private ClassNodeFactory() {
        super(ClassNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class}});
    }

    public ClassNode createNode(Object ... arguments) {
        if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
            return ClassNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]));
        }
        throw new IllegalArgumentException("Invalid create signature.");
    }

    public static ClassNode create(RubyContext context, SourceSection sourceSection, RubyNode object) {
        return ClassUninitializedNode.create0(context, sourceSection, object);
    }

    public static NodeFactory<ClassNode> getInstance() {
        if (instance == null) {
            instance = new ClassNodeFactory();
        }
        return instance;
    }

    @GeneratedBy(value=ClassNode.class)
    @NodeInfo(cost=NodeCost.POLYMORPHIC)
    private static final class ClassPolymorphicNode
    extends ClassBaseNode {
        @CompilerDirectives.CompilationFinal
        private Class<?> objectPolymorphicType;

        ClassPolymorphicNode(ClassBaseNode copy) {
            super(copy);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyClass value2;
            try {
                value2 = this.executeRubyClass(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubyClass executeRubyClass(VirtualFrame frameValue) throws UnexpectedResultException {
            Object objectValue;
            try {
                objectValue = this.objectPolymorphicType == Boolean.TYPE ? Boolean.valueOf(this.object.executeBoolean(frameValue)) : (this.objectPolymorphicType == Integer.TYPE ? Integer.valueOf(this.object.executeIntegerFixnum(frameValue)) : (this.objectPolymorphicType == Long.TYPE ? Long.valueOf(this.object.executeLongFixnum(frameValue)) : (this.objectPolymorphicType == Double.TYPE ? Double.valueOf(this.object.executeFloat(frameValue)) : (this.objectPolymorphicType == RubyBasicObject.class ? this.object.executeRubyBasicObject(frameValue) : this.object.execute(frameValue)))));
            }
            catch (UnexpectedResultException ex) {
                this.objectPolymorphicType = Object.class;
                return this.next0.executeChained0(frameValue, ex.getResult());
            }
            return this.next0.executeChained0(frameValue, objectValue);
        }

        @Override
        public void updateTypes0(Class<?>[] types) {
            this.objectPolymorphicType = types[0];
        }

        @Override
        protected RubyClass executeChained0(VirtualFrame frameValue, Object objectValue) {
            return this.next0.executeChained0(frameValue, objectValue);
        }
    }

    @GeneratedBy(value=ClassNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ClassRubyBasicObjectNode
    extends ClassBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ClassRubyBasicObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBasicObject.class}, 0, 0);

        ClassRubyBasicObjectNode(ClassBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyClass value2;
            try {
                value2 = this.executeRubyClass(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubyClass executeRubyClass(VirtualFrame frameValue) throws UnexpectedResultException {
            RubyBasicObject objectValue;
            try {
                objectValue = this.object.executeRubyBasicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected objectValue instanceof RubyBasicObject");
            }
            return super.getClass(objectValue);
        }

        @Override
        protected RubyClass executeChained0(VirtualFrame frameValue, Object objectValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(objectValue)) {
                RubyBasicObject objectValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(objectValue);
                return super.getClass(objectValueCast);
            }
            return this.next0.executeChained0(frameValue, objectValue);
        }

        static ClassNode create0(ClassNode current2) {
            return new ClassRubyBasicObjectNode((ClassBaseNode)current2);
        }
    }

    @GeneratedBy(value=ClassNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ClassDoubleNode
    extends ClassBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ClassDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE}, 0, 0);

        ClassDoubleNode(ClassBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyClass value2;
            try {
                value2 = this.executeRubyClass(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubyClass executeRubyClass(VirtualFrame frameValue) throws UnexpectedResultException {
            double objectValue;
            try {
                objectValue = this.object.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected objectValue instanceof double");
            }
            return super.getClass(objectValue);
        }

        @Override
        protected RubyClass executeChained0(VirtualFrame frameValue, Object objectValue) {
            if (RubyTypesGen.RUBYTYPES.isDouble(objectValue)) {
                double objectValueCast = RubyTypesGen.RUBYTYPES.asDouble(objectValue);
                return super.getClass(objectValueCast);
            }
            return this.next0.executeChained0(frameValue, objectValue);
        }

        static ClassNode create0(ClassNode current2) {
            return new ClassDoubleNode((ClassBaseNode)current2);
        }
    }

    @GeneratedBy(value=ClassNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ClassLongNode
    extends ClassBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ClassLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE}, 0, 0);

        ClassLongNode(ClassBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyClass value2;
            try {
                value2 = this.executeRubyClass(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubyClass executeRubyClass(VirtualFrame frameValue) throws UnexpectedResultException {
            long objectValue;
            try {
                objectValue = this.object.executeLongFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected objectValue instanceof long");
            }
            return super.getClass(objectValue);
        }

        @Override
        protected RubyClass executeChained0(VirtualFrame frameValue, Object objectValue) {
            if (RubyTypesGen.RUBYTYPES.isLong(objectValue)) {
                long objectValueCast = RubyTypesGen.RUBYTYPES.asLong(objectValue);
                return super.getClass(objectValueCast);
            }
            return this.next0.executeChained0(frameValue, objectValue);
        }

        static ClassNode create0(ClassNode current2) {
            return new ClassLongNode((ClassBaseNode)current2);
        }
    }

    @GeneratedBy(value=ClassNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ClassIntNode
    extends ClassBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ClassIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE}, 0, 0);

        ClassIntNode(ClassBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyClass value2;
            try {
                value2 = this.executeRubyClass(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubyClass executeRubyClass(VirtualFrame frameValue) throws UnexpectedResultException {
            int objectValue;
            try {
                objectValue = this.object.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected objectValue instanceof int");
            }
            return super.getClass(objectValue);
        }

        @Override
        protected RubyClass executeChained0(VirtualFrame frameValue, Object objectValue) {
            if (RubyTypesGen.RUBYTYPES.isInteger(objectValue)) {
                int objectValueCast = RubyTypesGen.RUBYTYPES.asInteger(objectValue);
                return super.getClass(objectValueCast);
            }
            return this.next0.executeChained0(frameValue, objectValue);
        }

        static ClassNode create0(ClassNode current2) {
            return new ClassIntNode((ClassBaseNode)current2);
        }
    }

    @GeneratedBy(value=ClassNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ClassBoolean1Node
    extends ClassBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ClassBoolean1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Boolean.TYPE}, 0, 0);

        ClassBoolean1Node(ClassBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyClass value2;
            try {
                value2 = this.executeRubyClass(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubyClass executeRubyClass(VirtualFrame frameValue) throws UnexpectedResultException {
            boolean objectValue;
            try {
                objectValue = this.object.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected objectValue instanceof boolean");
            }
            if (!super.isTrue(objectValue)) {
                return super.getClassFalse(objectValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, objectValue, "One of guards [!isTrue] failed");
        }

        @Override
        protected RubyClass executeChained0(VirtualFrame frameValue, Object objectValue) {
            boolean objectValueCast;
            if (RubyTypesGen.RUBYTYPES.isBoolean(objectValue) && !super.isTrue(objectValueCast = RubyTypesGen.RUBYTYPES.asBoolean(objectValue))) {
                return super.getClassFalse(objectValueCast);
            }
            return this.next0.executeChained0(frameValue, objectValue);
        }

        static ClassNode create0(ClassNode current2) {
            return new ClassBoolean1Node((ClassBaseNode)current2);
        }
    }

    @GeneratedBy(value=ClassNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ClassBoolean0Node
    extends ClassBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ClassBoolean0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Boolean.TYPE}, 0, 0);

        ClassBoolean0Node(ClassBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyClass value2;
            try {
                value2 = this.executeRubyClass(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubyClass executeRubyClass(VirtualFrame frameValue) throws UnexpectedResultException {
            boolean objectValue;
            try {
                objectValue = this.object.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected objectValue instanceof boolean");
            }
            if (super.isTrue(objectValue)) {
                return super.getClassTrue(objectValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, objectValue, "One of guards [isTrue] failed");
        }

        @Override
        protected RubyClass executeChained0(VirtualFrame frameValue, Object objectValue) {
            boolean objectValueCast;
            if (RubyTypesGen.RUBYTYPES.isBoolean(objectValue) && super.isTrue(objectValueCast = RubyTypesGen.RUBYTYPES.asBoolean(objectValue))) {
                return super.getClassTrue(objectValueCast);
            }
            return this.next0.executeChained0(frameValue, objectValue);
        }

        static ClassNode create0(ClassNode current2) {
            return new ClassBoolean0Node((ClassBaseNode)current2);
        }
    }

    @GeneratedBy(value=ClassNode.class)
    @NodeInfo(cost=NodeCost.UNINITIALIZED)
    private static final class ClassUninitializedNode
    extends ClassBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ClassUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
        @CompilerDirectives.CompilationFinal
        private boolean containsFallback;

        ClassUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode object) {
            super(context, sourceSection, object);
        }

        ClassUninitializedNode(ClassBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        public NodeCost getCost() {
            if (this.containsFallback) {
                return NodeCost.MONOMORPHIC;
            }
            return super.getCost();
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyClass value2;
            try {
                value2 = this.executeRubyClass(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubyClass executeRubyClass(VirtualFrame frameValue) throws UnexpectedResultException {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            Object objectValue = this.object.execute(frameValue);
            return this.executeUninitialized0(frameValue, objectValue);
        }

        @Override
        protected RubyClass executeChained0(VirtualFrame frameValue, Object objectValue) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            return this.executeUninitialized0(frameValue, objectValue);
        }

        protected RubyClass executeUninitialized0(VirtualFrame frameValue, Object objectValue) {
            ClassBaseNode newNode = this.specialize0(objectValue);
            if (newNode == null) {
                if (CompilerDirectives.inInterpreter()) {
                    this.containsFallback = true;
                }
                CompilerDirectives.transferToInterpreter();
                ClassBaseNode rootNode = (ClassBaseNode)DSLShare.findRoot((Node)this);
                throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.object}, new Object[]{objectValue});
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return ((ClassBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, objectValue);
        }

        static ClassNode create0(RubyContext context, SourceSection sourceSection, RubyNode object) {
            return new ClassUninitializedNode(context, sourceSection, object);
        }
    }

    @GeneratedBy(value=ClassNode.class)
    private static abstract class ClassBaseNode
    extends ClassNode
    implements DSLNode {
        @Node.Child
        protected RubyNode object;
        @Node.Child
        protected ClassBaseNode next0;

        ClassBaseNode(RubyContext context, SourceSection sourceSection, RubyNode object) {
            super(context, sourceSection);
            this.object = object;
        }

        ClassBaseNode(ClassBaseNode copy) {
            super(copy);
        }

        protected abstract RubyClass executeChained0(VirtualFrame var1, Object var2);

        protected final RubyClass rewrite0(VirtualFrame frameValue, Object objectValue, String reason2) {
            String message2;
            ClassBaseNode returnNode;
            CompilerAsserts.neverPartOfCompilation();
            ClassBaseNode newNode = this.specialize0(objectValue);
            if (newNode == null) {
                newNode = new ClassUninitializedNode(this);
                ((ClassUninitializedNode)newNode).containsFallback = true;
            }
            if ((returnNode = (ClassBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = ClassBaseNode.createInfo0(reason2, objectValue)))) == null) {
                returnNode = (ClassBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ClassUninitializedNode(this), (Node)new ClassPolymorphicNode(this), (DSLNode)((ClassBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
            }
            return returnNode.executeChained0(frameValue, objectValue);
        }

        @CompilerDirectives.TruffleBoundary
        protected final ClassBaseNode specialize0(Object objectValue) {
            if (RubyTypesGen.RUBYTYPES.isBoolean(objectValue)) {
                boolean objectValueCast = RubyTypesGen.RUBYTYPES.asBoolean(objectValue);
                if (super.isTrue(objectValueCast)) {
                    return (ClassBaseNode)ClassBoolean0Node.create0(this);
                }
                return (ClassBaseNode)ClassBoolean1Node.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isInteger(objectValue)) {
                return (ClassBaseNode)ClassIntNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isLong(objectValue)) {
                return (ClassBaseNode)ClassLongNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isDouble(objectValue)) {
                return (ClassBaseNode)ClassDoubleNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(objectValue)) {
                return (ClassBaseNode)ClassRubyBasicObjectNode.create0(this);
            }
            return null;
        }

        public final void adoptChildren0(Node other, Node newNext) {
            this.object = other == null ? null : ((ClassBaseNode)other).object;
            this.next0 = newNext == null ? null : (ClassBaseNode)newNext;
        }

        public DSLMetadata getMetadata0() {
            return DSLMetadata.NONE;
        }

        public void updateTypes0(Class<?>[] types) {
        }

        public final Node getNext0() {
            return this.next0;
        }

        protected static String createInfo0(String message2, Object objectValue) {
            if (TruffleOptions.DetailedRewriteReasons) {
                StringBuilder builder = new StringBuilder(message2);
                builder.append(" (");
                builder.append("objectValue").append(" = ").append(objectValue);
                if (objectValue != null) {
                    builder.append(" (").append(objectValue.getClass().getSimpleName()).append(")");
                }
                builder.append(")");
                return builder.toString();
            }
            return message2;
        }
    }
}

