/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.methods.locals;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.WriteNode;
import org.jruby.truffle.nodes.methods.locals.FrameSlotNode;
import org.jruby.truffle.nodes.methods.locals.ReadLevelVariableNodeFactory;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;

@NodeChild(value="rhs", type=RubyNode.class)
public abstract class WriteLevelVariableNode
extends FrameSlotNode
implements WriteNode {
    private final int varLevel;

    public WriteLevelVariableNode(RubyContext context, SourceSection sourceSection, FrameSlot frameSlot, int level2) {
        super(context, sourceSection, frameSlot);
        this.varLevel = level2;
    }

    protected WriteLevelVariableNode(WriteLevelVariableNode prev) {
        this(prev.getContext(), prev.getSourceSection(), prev.frameSlot, prev.varLevel);
    }

    @Specialization(guards={"isBooleanKind"})
    public boolean doBoolean(VirtualFrame frame, boolean value2) {
        MaterializedFrame levelFrame = RubyArguments.getDeclarationFrame(frame, this.varLevel);
        this.setBoolean((Frame)levelFrame, value2);
        return value2;
    }

    @Specialization(guards={"isFixnumKind"})
    public int doFixnum(VirtualFrame frame, int value2) {
        MaterializedFrame levelFrame = RubyArguments.getDeclarationFrame(frame, this.varLevel);
        this.setFixnum((Frame)levelFrame, value2);
        return value2;
    }

    @Specialization(guards={"isLongFixnumKind"})
    public long doLongFixnum(VirtualFrame frame, long value2) {
        MaterializedFrame levelFrame = RubyArguments.getDeclarationFrame(frame, this.varLevel);
        this.setLongFixnum((Frame)levelFrame, value2);
        return value2;
    }

    @Specialization(guards={"isFloatKind"})
    public double doFloat(VirtualFrame frame, double value2) {
        MaterializedFrame levelFrame = RubyArguments.getDeclarationFrame(frame, this.varLevel);
        this.setFloat((Frame)levelFrame, value2);
        return value2;
    }

    @Specialization(guards={"isObjectKind"})
    public Object doObject(VirtualFrame frame, Object value2) {
        MaterializedFrame levelFrame = RubyArguments.getDeclarationFrame(frame, this.varLevel);
        this.setObject((Frame)levelFrame, value2);
        return value2;
    }

    @Override
    public RubyNode makeReadNode() {
        return ReadLevelVariableNodeFactory.create(this.getContext(), this.getSourceSection(), this.frameSlot, this.varLevel);
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        return this.getContext().makeString("assignment");
    }
}

