/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.methods;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyModule;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.methods.MethodLike;
import org.jruby.truffle.runtime.methods.SharedMethodInfo;

public class BlockDefinitionNode
extends RubyNode {
    private final SharedMethodInfo sharedMethodInfo;
    private final CallTarget callTargetForBlocks;
    private final CallTarget callTargetForProcs;
    private final CallTarget callTargetForMethods;
    private final boolean requiresDeclarationFrame;

    public BlockDefinitionNode(RubyContext context, SourceSection sourceSection, SharedMethodInfo sharedMethodInfo, boolean requiresDeclarationFrame, CallTarget callTargetForBlocks, CallTarget callTargetForProcs, CallTarget callTargetForMethods) {
        super(context, sourceSection);
        this.sharedMethodInfo = sharedMethodInfo;
        this.callTargetForBlocks = callTargetForBlocks;
        this.callTargetForProcs = callTargetForProcs;
        this.callTargetForMethods = callTargetForMethods;
        this.requiresDeclarationFrame = requiresDeclarationFrame;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        MaterializedFrame declarationFrame = this.requiresDeclarationFrame ? frame.materialize() : null;
        MethodLike methodLike = RubyArguments.getMethod(frame.getArguments());
        RubyModule declaringModule = methodLike == null ? null : methodLike.getDeclaringModule();
        return new RubyProc(this.getContext().getCoreLibrary().getProcClass(), RubyProc.Type.PROC, this.sharedMethodInfo, this.callTargetForBlocks, this.callTargetForProcs, this.callTargetForMethods, declarationFrame, declaringModule, RubyArguments.getMethod(frame.getArguments()), RubyArguments.getSelf(frame.getArguments()), RubyArguments.getBlock(frame.getArguments()));
    }
}

