/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.globals;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyMatchData;

public class ReadMatchReferenceNode
extends RubyNode {
    public static final int PRE = -1;
    public static final int POST = -2;
    public static final int GLOBAL = -3;
    public static final int HIGHEST = -4;
    private final int index;

    public ReadMatchReferenceNode(RubyContext context, SourceSection sourceSection, int index2) {
        super(context, sourceSection);
        this.index = index2;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        ReadMatchReferenceNode.notDesignedForCompilation();
        Object match = this.getContext().getThreadManager().getCurrentThread().getThreadLocals().getInstanceVariable("$~");
        if (match == null || match == this.getContext().getCoreLibrary().getNilObject()) {
            return this.getContext().getCoreLibrary().getNilObject();
        }
        RubyMatchData matchData = (RubyMatchData)match;
        if (this.index > 0) {
            Object[] values2 = matchData.getValues();
            if (this.index >= values2.length) {
                return this.getContext().getCoreLibrary().getNilObject();
            }
            return values2[this.index];
        }
        if (this.index == -1) {
            return matchData.getPre();
        }
        if (this.index == -2) {
            return matchData.getPost();
        }
        if (this.index == -3) {
            return matchData.getGlobal();
        }
        if (this.index == -4) {
            Object[] values3 = matchData.getValues();
            for (int n = values3.length - 1; n >= 0; --n) {
                if (values3[n] == this.getContext().getCoreLibrary().getNilObject()) continue;
                return values3[n];
            }
            return this.getContext().getCoreLibrary().getNilObject();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        ReadMatchReferenceNode.notDesignedForCompilation();
        if (this.execute(frame) != this.getContext().getCoreLibrary().getNilObject()) {
            return this.getContext().makeString("global-variable");
        }
        return this.getContext().getCoreLibrary().getNilObject();
    }
}

